/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.c;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMInputArrayStartDataType;
import com.ibm.cics.schema.ICMInputSimpleDataType;
import com.ibm.cics.schema.ICMInputStructureStartDataType;
import com.ibm.cics.schema.impl.Factory;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.CICSWSDLParseException;
import com.ibm.cics.wsdl.c.LangStruct_C;
import com.ibm.cics.wsdl.c.LanguageStruct;
import com.ibm.cics.wsdl.c.UserType;
import com.ibm.cics.wsdl.ls2ws.LangStruct;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Member {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private String instanceName;
    private UserType type = null;
    private String typeName;
    private List<Integer> dimensions;
    private LangStruct_C controller;

    public Member(LangStruct_C theController, String instName, String theTypeName, List<Integer> theDimensions) {
        this.instanceName = instName;
        this.typeName = theTypeName;
        this.dimensions = theDimensions;
        this.controller = theController;
    }

    public final String getInstanceName() {
        return this.instanceName;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    public final void setTypeName(String theTypeName) {
        this.typeName = theTypeName;
    }

    public final List<Integer> getDimensions() {
        return this.dimensions;
    }

    public final UserType getType() throws CICSWSDLParseException {
        if (this.type == null) {
            this.type = this.controller.getUserType(this.typeName);
        }
        return this.type;
    }

    public final void setType(UserType theType) {
        this.type = theType;
    }

    public final void generateICM(String instName, LangStruct ls, Set<String> uniqueNameSet, boolean packed) throws CICSWSDLException {
        switch (this.getType().getUserType()) {
            case 2: {
                String name = this.controller.ensureValidXMLString(this.instanceName, uniqueNameSet);
                ICMInputSimpleDataType field = Factory.createICMSimpleDataType(name, this.type.getICMType());
                field.setLar(this.type.getLAR());
                field.setMappingStrategy(this.type.getMappingStrategy());
                field.setAligned(!packed);
                field.setSignLeading(false);
                field.setSeparateCharacter(false);
                field.setSuppressed(false);
                ls.addDataElementEntry(field);
                break;
            }
            case 1: {
                UserType theType = this.controller.getUserType(this.getTypeName());
                this.setType(theType);
                this.setTypeName(theType.getTypeName());
                List<Integer> dims = theType.getDimensions();
                int dimCount = 0;
                if (dims != null) {
                    dimCount = dims.size();
                    for (Integer dim : dims) {
                        ICMInputArrayStartDataType field = Factory.createICMArrayStartDataType(this.controller.ensureValidXMLString(this.instanceName, uniqueNameSet), dim);
                        ls.addFixedRepeatEntry(field);
                    }
                }
                this.generateICM(instName, ls, uniqueNameSet, packed);
                for (int i = 0; i < dimCount; ++i) {
                    ls.addEndRepeatEntry(Factory.createICMArrayEndDataType());
                }
                break;
            }
            case 0: {
                String name = this.controller.ensureValidXMLString(this.instanceName, uniqueNameSet);
                ICMInputStructureStartDataType structure = Factory.createICMStructureStartDataType(name, ICM.StructureType.STRUCTURE_STANDARD);
                ls.sendStructStart(structure);
                uniqueNameSet = new HashSet<String>();
                for (Member member : this.getType().getOrderedMembers()) {
                    List<Integer> dims = member.getDimensions();
                    int dimCount = dims.size();
                    for (Integer dim : dims) {
                        String memberName = member.getInstanceName();
                        ICMInputArrayStartDataType array = Factory.createICMArrayStartDataType(memberName, dim);
                        ls.addFixedRepeatEntry(array);
                    }
                    boolean newPacked = ((LanguageStruct)this.getType()).isPacked();
                    member.generateICM(this.instanceName, ls, uniqueNameSet, newPacked);
                    for (int i = 0; i < dimCount; ++i) {
                        ls.addEndRepeatEntry(Factory.createICMArrayEndDataType());
                    }
                }
                ls.sendStructEnd(Factory.createICMStructureEndDataType());
                break;
            }
            default: {
                throw new CICSWSDLException("INTERNAL_ERROR: Value '" + this.getType().getUserType() + "' for UserType not recognised.");
            }
        }
    }
}

