/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.c;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.wsdl.c.Member;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class UserType {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    static final int STRUCT = 0;
    static final int ALIAS = 1;
    static final int PRIMITIVE = 2;
    protected String typeName;
    protected int memberCount = 0;
    protected ICM.ICMDataType icmType = null;
    protected int lar = 0;
    private Map<Integer, Object> members = new TreeMap<Integer, Object>();
    private ICM.VaryingLength mappingStrategy = ICM.VaryingLength.NO_VARYING_STRATEGY;

    public ICM.VaryingLength getMappingStrategy() {
        return this.mappingStrategy;
    }

    public void setMappingStrategy(ICM.VaryingLength mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    public final void setTypeName(String tag) {
        this.typeName = tag;
    }

    public final ICM.ICMDataType getICMType() {
        return this.icmType;
    }

    public final int getLAR() {
        return this.lar;
    }

    public final void addMember(Member member) {
        while (this.members.containsKey(this.memberCount)) {
            ++this.memberCount;
        }
        this.members.put(this.memberCount, member);
        ++this.memberCount;
    }

    public final void addMember(Member member, int position) {
        Integer ordinalPos = position;
        Object memberAtPos = this.members.get(ordinalPos);
        if (memberAtPos != null) {
            if (memberAtPos instanceof List) {
                List clashList = (List)memberAtPos;
                clashList.add(member);
            } else {
                ArrayList<Object> clashList = new ArrayList<Object>();
                clashList.add(memberAtPos);
                clashList.add(member);
                this.members.put(ordinalPos, clashList);
            }
        } else {
            this.members.put(ordinalPos, member);
        }
    }

    public final List<Member> getOrderedMembers() {
        ArrayList<Member> orderedMembers = new ArrayList<Member>();
        for (Object item : this.members.values()) {
            if (item instanceof List) {
                List clashList = (List)item;
                Iterator clashIt = clashList.iterator();
                while (clashIt.hasNext()) {
                    orderedMembers.add((Member)clashIt.next());
                }
                continue;
            }
            orderedMembers.add((Member)item);
        }
        return orderedMembers;
    }

    abstract int getUserType();

    abstract List<Integer> getDimensions();
}

