/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.cobol;

import com.ibm.cics.gen.api.IPlatform;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CobolDataType {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String DISPLAY = "DISPLAY";
    private static final String PACKEDDECIMAL = "DECIMAL";
    private static final String BINARY = "BINARY";
    private static final String FLOAT = "FLOAT";
    private static final String DOUBLE = "DOUBLE";
    private static final String UNSUPPORTED = "UNSUPPORTED";
    private ICM.ICMDataType type = null;
    private int fractionDigits = 0;
    private int length = 0;
    private int minLength;
    private int maxOccurs = 1;
    private int minOccurs = 1;
    private String odoTarget = null;
    private boolean hasData = false;
    private boolean isSignLeading;
    private boolean isSignSeparate;
    private ICM.VaryingLength mappingStrategy = ICM.VaryingLength.NO_VARYING_STRATEGY;
    private int mappingLevel = 0;
    private static List<String> NOT_SUPPORTED_KEYWORDS = new ArrayList<String>();
    private static List<String> IGNORED_KEYWORDS;
    private static final Pattern simplePureDbcsPattern;
    private static final Pattern simpleNationalDbcsPattern;
    private static final Pattern bracketedPureDbcsPattern;
    private static final Pattern bracketedNationalDbcsPattern;
    private static final Pattern simpleCharsPattern;
    private static final Pattern bracketedCharsPattern;
    private static final Pattern simpleSignedNumberPattern;
    private static final Pattern simpleUnsignedNumberPattern;
    private static final Pattern bracketedSignedNumberPattern;
    private static final Pattern bracketedUnsignedNumberPattern;
    private static final Pattern simpleDecimalSignedNumberPattern;
    private static final Pattern simpleDecimalUnsignedNumberPattern;
    private static final Pattern bracketedDecimalSignedNumberPattern;
    private static final Pattern bracketedDecimalUnsignedNumberPattern;
    private static final Pattern mixedBracketedFirstDecimalSignedNumberPattern;
    private static final Pattern mixedBracketedFirstDecimalUnsignedNumberPattern;
    private static final Pattern mixedBracketedLastDecimalSignedNumberPattern;
    private static final Pattern mixedBracketedLastDecimalUnsignedNumberPattern;
    private static final Pattern unSignedVNineBracketedQ;
    private static final Pattern unSignedNineBracketedPV;
    private static final Pattern signedVNineBracketedQ;
    private static final Pattern signedNineBracketedPV;
    private static final Pattern unSignedVNines;
    private static final Pattern unSignedNinesV;
    private static final Pattern signedVNines;
    private static final Pattern signedNinesV;
    private String fileName = null;
    private boolean synced = false;
    private boolean useAbstimeDates = false;
    private ICM.VaryingLength defaultMappingStrategy;
    private Properties props;
    private ICM.EncodingType encodingOverride = ICM.EncodingType.SBCS;
    private String unmodifiedFieldName;
    private IPlatform platform;

    CobolDataType(String xmlName, StringTokenizer tokens, ICM.VaryingLength defaultMappingStrategy, int mappingLevel, String fileName, boolean useAbstimeDates, Properties props, String unmodifiedFieldName, IPlatform platform) throws CICSWSDLException {
        this.mappingStrategy = ICM.VaryingLength.NO_VARYING_STRATEGY;
        this.mappingLevel = mappingLevel;
        this.isSignLeading = false;
        this.isSignSeparate = false;
        this.fileName = fileName;
        this.useAbstimeDates = useAbstimeDates;
        this.defaultMappingStrategy = defaultMappingStrategy;
        this.props = props;
        this.unmodifiedFieldName = unmodifiedFieldName;
        this.platform = platform;
        this.parseTokens(tokens, xmlName);
    }

    private void parseTokens(StringTokenizer tokens, String fieldNameXML) throws CICSWSDLException {
        String line = this.makeString(tokens).toUpperCase(Locale.ENGLISH);
        int idx = line.indexOf(" PIC ");
        if (idx == -1) {
            idx = line.indexOf(" PICTURE ");
        }
        if (idx != -1) {
            if (this.findPictureType(line, fieldNameXML)) {
                this.hasData = true;
                this.applyMappingStrategy(this.defaultMappingStrategy);
            }
        } else {
            String cat = this.categoryRecogniser(line);
            if (cat.equals(FLOAT) || cat.equals(DOUBLE)) {
                this.hasData = true;
                if (cat.equals(FLOAT)) {
                    this.type = this.platform != null && IPlatform.FloatStyle.IEEE_754_FLOAT.equals((Object)this.platform.getFloatStyle()) ? ICM.ICMDataType.BFP_FLOAT : ICM.ICMDataType.HFP_SHORT;
                } else if (cat.equals(DOUBLE)) {
                    this.type = this.platform != null && IPlatform.FloatStyle.IEEE_754_FLOAT.equals((Object)this.platform.getFloatStyle()) ? ICM.ICMDataType.BFP_DOUBLE : ICM.ICMDataType.HFP_LONG;
                }
            }
        }
        if ((idx = line.indexOf(" OCCURS ")) != -1) {
            this.findOccurs(line.substring(idx));
        }
        this.notHonoured(line);
        this.notSupported(line);
        if (line.indexOf(" SYNC ") != -1 || line.indexOf(" SYNCHRONIZED ") != -1) {
            this.synced = true;
        }
    }

    private void applyMappingStrategy(ICM.VaryingLength defaultMappingStrategy) {
        if (this.type.equals((Object)ICM.ICMDataType.CHAR_ARRAY) || this.type.equals((Object)ICM.ICMDataType.WIDE_CHAR_ARRAY) || this.type.equals((Object)ICM.ICMDataType.UTF16_CHAR_ARRAY)) {
            this.mappingStrategy = defaultMappingStrategy;
            if (this.mappingStrategy.equals((Object)ICM.VaryingLength.NULL_TERMINATED_CHAR_ARRAY)) {
                --this.length;
                if (this.length == 0) {
                    this.length = 1;
                    this.mappingStrategy = ICM.VaryingLength.FIXED_LENGTH_ARRAY;
                }
            }
        }
    }

    protected ICM.VaryingLength getMappingStrategy() {
        return this.mappingStrategy;
    }

    private boolean findPictureType(String line, String fieldName) throws CICSWSDLException {
        StringTokenizer t = new StringTokenizer(line);
        String dataType = "";
        String cat = DISPLAY;
        cat = this.categoryRecogniser(line);
        if (!cat.equals(UNSUPPORTED)) {
            while (t.hasMoreTokens() && !(dataType = t.nextToken()).equalsIgnoreCase("PIC") && !dataType.equalsIgnoreCase("PICTURE")) {
            }
            if (t.hasMoreTokens()) {
                dataType = t.nextToken();
            }
            if (dataType.equalsIgnoreCase("USAGE") && t.hasMoreTokens()) {
                dataType = t.nextToken();
            }
            if (dataType.equalsIgnoreCase("IS") && t.hasMoreTokens()) {
                dataType = t.nextToken();
            }
            if (this.pictureFormatRecogniser(dataType, cat, fieldName)) {
                this.hasData = true;
            }
        }
        return this.hasData;
    }

    private String makeString(StringTokenizer t) {
        StringBuilder s = new StringBuilder(" ");
        while (t.hasMoreTokens()) {
            s.append(" ");
            s.append(t.nextToken());
        }
        s.append(" ");
        return s.toString();
    }

    private String categoryRecogniser(String s) {
        String category = DISPLAY;
        if ((s = s.toUpperCase(Locale.ENGLISH) + " ").indexOf("COMP-4") >= 0 || s.indexOf("COMPUTATIONAL-4") >= 0 || s.indexOf("COMP ") >= 0 || s.indexOf("COMPUTATIONAL-4") >= 0 || s.indexOf("COMPUTATIONAL-5") >= 0 || s.indexOf(BINARY) >= 0 || s.indexOf("COMP-5") >= 0 || s.indexOf("COMPUTATIONAL ") >= 0) {
            category = BINARY;
        } else if (s.indexOf("PACKED-DECIMAL") >= 0 || s.indexOf("COMP-3") >= 0 || s.indexOf("COMPUTATIONAL-3") >= 0) {
            category = PACKEDDECIMAL;
        } else if (s.indexOf("COMP-1") >= 0 || s.indexOf("COMPUTATIONAL-1") >= 0) {
            if (!MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
                Logging.writeMessage(12, "DFHPI9540E", new Object[]{s});
                category = UNSUPPORTED;
            } else {
                category = FLOAT;
            }
        } else if (s.indexOf("COMP-2") >= 0 || s.indexOf("COMPUTATIONAL-2") >= 0) {
            if (!MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
                Logging.writeMessage(12, "DFHPI9540E", new Object[]{s});
                category = UNSUPPORTED;
            } else {
                category = DOUBLE;
            }
        }
        if (s.indexOf("SIGN LEADING") >= 0 || s.indexOf("SIGN IS LEADING") >= 0 || s.indexOf("LEADING") >= 0) {
            if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
                this.isSignLeading = true;
            } else {
                Logging.writeMessage(12, "DFHPI9540E", new Object[]{"SIGN LEADING"});
            }
        }
        if (s.indexOf("SIGN TRAILING") >= 0 || s.indexOf("SIGN IS TRAILING") >= 0 || s.indexOf("TRAILING") >= 0) {
            this.isSignLeading = false;
        }
        if (s.indexOf("SEPARATE CHARACTER") >= 0 || s.indexOf("SEPARATE") >= 0) {
            if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
                this.isSignSeparate = true;
            } else {
                Logging.writeMessage(12, "DFHPI9540E", new Object[]{"SEPARATE CHARACTER"});
            }
        }
        if (s.contains("USAGE IS NATIONAL") || s.contains("USAGE NATIONAL")) {
            this.encodingOverride = ICM.EncodingType.UTF16BE;
        } else if (s.contains("USAGE IS DISPLAY-1") || s.contains("USAGE DISPLAY-1")) {
            this.encodingOverride = ICM.EncodingType.DBCS;
        }
        return category;
    }

    private void findOccurs(String line) throws CICSWSDLException {
        if (line.indexOf(" DEPENDING ") != -1 && !MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel)) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9540E", new Object[]{"DEPENDING"}));
        }
        if (line.indexOf("UNBOUNDED") != -1) {
            throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9720E"));
        }
        StringTokenizer t = new StringTokenizer(line);
        t.nextToken();
        int x = 0;
        int y = 0;
        String s = t.nextToken();
        x = Util.stringToInt(s, -1, true, this.fileName);
        if (t.hasMoreTokens()) {
            s = t.nextToken();
        }
        if (s.equalsIgnoreCase("TO")) {
            s = t.nextToken();
            y = Util.stringToInt(s, -1, true, this.fileName);
            if (t.hasMoreTokens()) {
                s = t.nextToken();
            }
        }
        if (s.equalsIgnoreCase("TIMES") && t.hasMoreTokens()) {
            s = t.nextToken();
        }
        if (s.equalsIgnoreCase("DEPENDING")) {
            if (t.hasMoreTokens()) {
                s = t.nextToken();
            }
            if (s.equals("ON") && t.hasMoreTokens()) {
                s = t.nextToken();
            }
            this.odoTarget = s;
            if (line.indexOf(" OF ") != -1) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9540E", new Object[]{"OF"}));
            }
            if (!"ENABLED".equals(this.props.getProperty("DATA-TRUNCATION"))) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9718E", new Object[0]));
            }
        }
        if (y > 0) {
            this.maxOccurs = y;
            this.minOccurs = MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel) ? x : y;
        } else {
            this.maxOccurs = x;
            this.minOccurs = MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel) && this.odoTarget != null ? 1 : x;
        }
        if (this.minOccurs > this.maxOccurs) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9726E", new Object[]{this.minOccurs, this.maxOccurs}));
        }
        if (this.minOccurs < 0) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9727E", new Object[]{this.minOccurs}));
        }
        if (MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel) && "STRING".equals(this.props.getProperty("CHAR-OCCURS")) && this.length == 1 && (this.type.equals((Object)ICM.ICMDataType.CHAR_ARRAY) || this.type.equals((Object)ICM.ICMDataType.WIDE_CHAR_ARRAY) || this.type.equals((Object)ICM.ICMDataType.UTF16_CHAR_ARRAY))) {
            this.length = this.maxOccurs;
            this.minLength = this.minOccurs == this.maxOccurs ? 0 : this.minOccurs;
            this.maxOccurs = 1;
            this.minOccurs = 1;
            this.applyMappingStrategy(this.defaultMappingStrategy);
        }
    }

    private int getNumberInBrackets(String s) throws CICSWSDLException {
        int num = 0;
        if (!s.matches("^[sS].\\(.+\\)$") && !s.matches("^.\\(.+\\)$")) {
            throw new CICSWSDLException("INTERNAL_ERROR: value does not contain brackets in expected format: " + s);
        }
        String numString = s.substring(s.indexOf("(") + 1, s.indexOf(")"));
        num = Util.stringToInt(numString, -1, true, this.fileName);
        return num;
    }

    private String mergeZ(String orgDataType) throws CICSWSDLException {
        String dataType = orgDataType.replace('Z', '9');
        StringBuilder dataBuf = new StringBuilder();
        int nineCount = 0;
        block6: for (int i = 0; i < dataType.length(); ++i) {
            char c = dataType.charAt(i);
            switch (c) {
                case '9': {
                    ++nineCount;
                    continue block6;
                }
                case '(': {
                    String numString = dataType.substring(i + 1, i + 1 + dataType.substring(i + 1).indexOf(")"));
                    int num = Util.stringToInt(numString, -1, true, this.fileName);
                    nineCount = nineCount - 1 + num;
                    i = i + dataType.substring(i + 1).indexOf(")") + 1;
                    continue block6;
                }
                case ')': {
                    continue block6;
                }
                case 'V': {
                    dataBuf.append("9(" + nineCount + ")V");
                    nineCount = 0;
                    continue block6;
                }
                default: {
                    dataBuf.append(c);
                }
            }
        }
        if (nineCount != 0) {
            dataBuf.append("9(" + nineCount + ")");
        }
        return dataBuf.toString();
    }

    private boolean pictureFormatRecogniser(String dataType, String cat, String fieldName) throws CICSWSDLException {
        StringTokenizer st;
        Matcher m;
        boolean signed = true;
        int numLength = 0;
        boolean alreadyDoneThis = false;
        String originalDataType = dataType;
        if (cat.equals(FLOAT) || cat.equals(DOUBLE)) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9699E", new Object[]{fieldName}));
        }
        boolean matched = false;
        if (dataType.indexOf(90) != -1) {
            dataType = this.mergeZ(dataType);
        }
        if ((m = simpleSignedNumberPattern.matcher(dataType)).matches()) {
            numLength = dataType.length() - 1;
            matched = true;
        }
        if (!matched && (m = simpleUnsignedNumberPattern.matcher(dataType)).matches()) {
            numLength = dataType.length();
            signed = false;
            matched = true;
        }
        if (!matched && (m = bracketedSignedNumberPattern.matcher(dataType)).matches()) {
            numLength = this.getNumberInBrackets(dataType);
            matched = true;
        }
        if (!matched && (m = bracketedUnsignedNumberPattern.matcher(dataType)).matches()) {
            numLength = this.getNumberInBrackets(dataType);
            signed = false;
            matched = true;
        }
        if (matched) {
            if (cat.equals(BINARY)) {
                this.length = 0;
            } else if (cat.equals(DISPLAY)) {
                this.length = numLength;
            } else if (cat.equals(FLOAT) || cat.equals(DOUBLE)) {
                this.length = 0;
            } else {
                this.length = numLength;
                this.fractionDigits = 0;
            }
            if (cat.equals(BINARY) || cat.equals(DISPLAY)) {
                this.type = signed ? (numLength < 5 ? ICM.ICMDataType.SHORT : (numLength < 10 ? ICM.ICMDataType.INT : ICM.ICMDataType.LONG)) : (numLength < 5 ? ICM.ICMDataType.UNSIGNED_SHORT : (numLength < 10 ? ICM.ICMDataType.UNSIGNED_INT : ICM.ICMDataType.UNSIGNED_LONG));
            } else if (cat.equals(PACKEDDECIMAL)) {
                this.type = signed ? ICM.ICMDataType.DECIMAL : ICM.ICMDataType.UNSIGNED_DECIMAL;
            } else if (cat.equals(FLOAT)) {
                this.type = ICM.ICMDataType.HFP_SHORT;
            } else if (cat.equals(DOUBLE)) {
                this.type = ICM.ICMDataType.HFP_LONG;
            }
        }
        if (!matched && (m = bracketedDecimalSignedNumberPattern.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.DECIMAL;
            st = new StringTokenizer(dataType.toUpperCase(Locale.ENGLISH), "V");
            this.length = this.getNumberInBrackets(st.nextToken());
            this.fractionDigits = this.getNumberInBrackets(st.nextToken());
            matched = true;
        }
        if (!matched && (m = unSignedVNineBracketedQ.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.UNSIGNED_DECIMAL;
            this.length = 0;
            this.fractionDigits = this.getNumberInBrackets(dataType.substring(1));
            matched = true;
        }
        if (!matched && (m = unSignedNineBracketedPV.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.UNSIGNED_DECIMAL;
            this.length = this.getNumberInBrackets(dataType.substring(dataType.indexOf("9"), dataType.indexOf(")") + 1));
            this.fractionDigits = 0;
            matched = true;
        }
        if (!matched && (m = signedVNineBracketedQ.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.DECIMAL;
            this.length = 0;
            this.fractionDigits = this.getNumberInBrackets(dataType.substring(dataType.indexOf("9"), dataType.indexOf(")") + 1));
            matched = true;
        }
        if (!matched && (m = signedNineBracketedPV.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.DECIMAL;
            this.length = this.getNumberInBrackets(dataType.substring(dataType.indexOf("9"), dataType.indexOf(")") + 1));
            this.fractionDigits = 0;
            matched = true;
        }
        if (!matched && (m = unSignedVNines.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.UNSIGNED_DECIMAL;
            this.length = 0;
            this.fractionDigits = dataType.length() - 1;
            matched = true;
        }
        if (!matched && (m = unSignedNinesV.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.UNSIGNED_DECIMAL;
            this.length = dataType.length() - 1;
            this.fractionDigits = 0;
            matched = true;
        }
        if (!matched && (m = signedVNines.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.DECIMAL;
            this.length = 0;
            this.fractionDigits = dataType.length() - 2;
            matched = true;
        }
        if (!matched && (m = signedNinesV.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.DECIMAL;
            this.length = dataType.length() - 2;
            this.fractionDigits = 0;
            matched = true;
        }
        if (!matched && (m = bracketedDecimalUnsignedNumberPattern.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.UNSIGNED_DECIMAL;
            st = new StringTokenizer(dataType.toUpperCase(Locale.ENGLISH), "V");
            this.length = this.getNumberInBrackets(st.nextToken());
            this.fractionDigits = this.getNumberInBrackets(st.nextToken());
            matched = true;
        }
        if (!matched && (m = simpleDecimalSignedNumberPattern.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.DECIMAL;
            st = new StringTokenizer(dataType.toUpperCase(Locale.ENGLISH), "V");
            this.length = st.nextToken().length() - 1;
            this.fractionDigits = st.nextToken().length();
            matched = true;
        }
        if (!matched && (m = simpleDecimalUnsignedNumberPattern.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.UNSIGNED_DECIMAL;
            st = new StringTokenizer(dataType.toUpperCase(Locale.ENGLISH), "V");
            this.length = st.nextToken().length();
            this.fractionDigits = st.nextToken().length();
            matched = true;
        }
        if (!matched && (m = mixedBracketedFirstDecimalSignedNumberPattern.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.DECIMAL;
            st = new StringTokenizer(dataType.toUpperCase(Locale.ENGLISH), "V");
            this.length = this.getNumberInBrackets(st.nextToken());
            this.fractionDigits = st.nextToken().length();
            matched = true;
        }
        if (!matched && (m = mixedBracketedFirstDecimalUnsignedNumberPattern.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.UNSIGNED_DECIMAL;
            st = new StringTokenizer(dataType.toUpperCase(Locale.ENGLISH), "V");
            this.length = this.getNumberInBrackets(st.nextToken());
            this.fractionDigits = st.nextToken().length();
            matched = true;
        }
        if (!matched && (m = mixedBracketedLastDecimalSignedNumberPattern.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.DECIMAL;
            st = new StringTokenizer(dataType.toUpperCase(Locale.ENGLISH), "V");
            this.length = st.nextToken().length() - 1;
            this.fractionDigits = this.getNumberInBrackets(st.nextToken());
            matched = true;
        }
        if (!matched && (m = mixedBracketedLastDecimalUnsignedNumberPattern.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.UNSIGNED_DECIMAL;
            st = new StringTokenizer(dataType.toUpperCase(Locale.ENGLISH), "V");
            this.length = st.nextToken().length();
            this.fractionDigits = this.getNumberInBrackets(st.nextToken());
            matched = true;
        }
        if (matched && (this.type.equals((Object)ICM.ICMDataType.DECIMAL) || this.type.equals((Object)ICM.ICMDataType.UNSIGNED_DECIMAL)) && (cat.equals(DISPLAY) && !MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel) || cat.equals(BINARY))) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9553E", new Object[]{originalDataType}));
        }
        if (!matched && (m = simpleCharsPattern.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.CHAR_ARRAY;
            this.length = dataType.length();
            matched = true;
        }
        if (!matched && (m = bracketedCharsPattern.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.CHAR_ARRAY;
            this.length = this.getNumberInBrackets(dataType);
            matched = true;
        }
        if (!matched && (m = simplePureDbcsPattern.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.WIDE_CHAR_ARRAY;
            this.length = dataType.length();
            matched = true;
        }
        if (!matched && (m = bracketedPureDbcsPattern.matcher(dataType)).matches()) {
            this.type = ICM.ICMDataType.WIDE_CHAR_ARRAY;
            this.length = this.getNumberInBrackets(dataType);
            matched = true;
        }
        if (!matched && (m = simpleNationalDbcsPattern.matcher(dataType)).matches()) {
            this.length = dataType.length();
            matched = true;
            if (this.props.get("CHAR-USAGE").equals("DBCS") && this.encodingOverride != ICM.EncodingType.UTF16BE || this.encodingOverride == ICM.EncodingType.DBCS) {
                this.type = ICM.ICMDataType.WIDE_CHAR_ARRAY;
                if (!MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel)) {
                    Logging.writeMessage(4, "DFHPI9616W", new Object[]{dataType});
                }
            } else if (MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel)) {
                this.props.setProperty("UTF-16", Boolean.TRUE.toString());
                this.type = ICM.ICMDataType.UTF16_CHAR_ARRAY;
            } else {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9540E", new Object[]{"USAGE NATIONAL"}));
            }
        }
        if (!matched && (m = bracketedNationalDbcsPattern.matcher(dataType)).matches()) {
            this.length = this.getNumberInBrackets(dataType);
            matched = true;
            if (this.props.get("CHAR-USAGE").equals("DBCS") && this.encodingOverride != ICM.EncodingType.UTF16BE || this.encodingOverride == ICM.EncodingType.DBCS) {
                this.type = ICM.ICMDataType.WIDE_CHAR_ARRAY;
                if (!MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel)) {
                    Logging.writeMessage(4, "DFHPI9616W", new Object[]{dataType});
                }
            } else if (MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel)) {
                this.props.setProperty("UTF-16", Boolean.TRUE.toString());
                this.type = ICM.ICMDataType.UTF16_CHAR_ARRAY;
            } else {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9540E", new Object[]{"USAGE NATIONAL"}));
            }
        }
        if (this.type != null && (this.type.equals((Object)ICM.ICMDataType.CHAR_ARRAY) || this.type.equals((Object)ICM.ICMDataType.WIDE_CHAR_ARRAY)) && this.length < 1) {
            Logging.writeMessage(12, "DFHPI9574E", new Object[]{dataType});
            this.length = 1;
        }
        if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel) && cat.equals(DISPLAY)) {
            if (this.type == ICM.ICMDataType.DECIMAL) {
                this.type = ICM.ICMDataType.ZONED;
            } else if (this.type == ICM.ICMDataType.UNSIGNED_DECIMAL) {
                this.type = ICM.ICMDataType.UNSIGNED_ZONED;
            }
        }
        if (this.type != null && this.type.equals((Object)ICM.ICMDataType.DECIMAL) && this.length == 15 && MappingLevelHelper.supportsMappingLevel_3_0(this.mappingLevel) && this.useAbstimeDates) {
            this.type = ICM.ICMDataType.ABSTIME;
        }
        if ((this.type == ICM.ICMDataType.DECIMAL || this.type == ICM.ICMDataType.UNSIGNED_DECIMAL || this.type == ICM.ICMDataType.LONG || this.type == ICM.ICMDataType.UNSIGNED_LONG) && this.length + this.fractionDigits > 31) {
            Logging.writeMessage(12, "DFHPI9567E", new Object[]{this.length + this.fractionDigits});
        }
        if (!matched && !alreadyDoneThis) {
            Logging.writeMessage(12, "DFHPI9554E", new Object[]{originalDataType});
        }
        return matched;
    }

    protected final ICM.ICMDataType getType() {
        return this.type;
    }

    protected final int getFractions() {
        return this.fractionDigits;
    }

    protected final int getLAR() {
        return this.length;
    }

    protected final int getMaxOccurs() {
        return this.maxOccurs;
    }

    protected final int getMinOccurs() {
        return this.minOccurs;
    }

    protected final boolean getSync() {
        return this.synced;
    }

    protected final boolean hasData() {
        return this.hasData;
    }

    protected final boolean isSignLeading() {
        return this.isSignLeading;
    }

    protected final boolean isSignSeparate() {
        return this.isSignSeparate;
    }

    protected final int getMinLength() {
        return this.minLength;
    }

    protected final String getOdoTarget() {
        return this.odoTarget;
    }

    protected final String getUnmodifiedFieldName() {
        return this.unmodifiedFieldName;
    }

    private void notHonoured(String line) {
        line = " " + line + " ";
        String word = "";
        for (int i = 0; i < IGNORED_KEYWORDS.size(); ++i) {
            word = IGNORED_KEYWORDS.get(i);
            if (line.indexOf(word) <= -1) continue;
            Logging.writeMessage(4, "DFHPI9544W", new Object[]{word});
        }
    }

    private void notSupported(String line) {
        line = " " + line + " ";
        String word = "";
        for (int i = 0; i < NOT_SUPPORTED_KEYWORDS.size(); ++i) {
            word = NOT_SUPPORTED_KEYWORDS.get(i);
            if (line.indexOf(word) <= -1) continue;
            Logging.writeMessage(12, "DFHPI9540E", new Object[]{word});
        }
    }

    static {
        NOT_SUPPORTED_KEYWORDS.add(" FUNCTION-POINTER ");
        NOT_SUPPORTED_KEYWORDS.add(" POINTER ");
        NOT_SUPPORTED_KEYWORDS.add(" OBJECT REFERENCE ");
        NOT_SUPPORTED_KEYWORDS.add(" PROCEDURE-POINTER ");
        NOT_SUPPORTED_KEYWORDS.add(" REDEFINES ");
        NOT_SUPPORTED_KEYWORDS.add(" RENAMES ");
        NOT_SUPPORTED_KEYWORDS.add(" DATE FORMAT ");
        IGNORED_KEYWORDS = new ArrayList<String>();
        IGNORED_KEYWORDS.add(" BLANK WHEN ZERO");
        IGNORED_KEYWORDS.add(" BLANK ZERO");
        IGNORED_KEYWORDS.add(" JUSTIFIED ");
        IGNORED_KEYWORDS.add(" JUST ");
        IGNORED_KEYWORDS.add(" VALUE ");
        simplePureDbcsPattern = Pattern.compile("^[Gg]+$");
        simpleNationalDbcsPattern = Pattern.compile("^[Nn]+$");
        bracketedPureDbcsPattern = Pattern.compile("^[Gg]\\(\\d+\\)$");
        bracketedNationalDbcsPattern = Pattern.compile("^[Nn]\\(\\d+\\)$");
        simpleCharsPattern = Pattern.compile("^[AaXx]+$");
        bracketedCharsPattern = Pattern.compile("^[AaXx]\\(\\d+\\)$");
        simpleSignedNumberPattern = Pattern.compile("^[Ss]9+$");
        simpleUnsignedNumberPattern = Pattern.compile("^9+$");
        bracketedSignedNumberPattern = Pattern.compile("^[Ss]9\\(\\d+\\)$");
        bracketedUnsignedNumberPattern = Pattern.compile("^9\\(\\d+\\)$");
        simpleDecimalSignedNumberPattern = Pattern.compile("^[Ss]9+[Vv]9+$");
        simpleDecimalUnsignedNumberPattern = Pattern.compile("^9+[Vv]9+$");
        bracketedDecimalSignedNumberPattern = Pattern.compile("^[Ss]9\\(\\d+\\)[Vv]9\\(\\d+\\)$");
        bracketedDecimalUnsignedNumberPattern = Pattern.compile("^9\\(\\d+\\)[Vv]9\\(\\d+\\)$");
        mixedBracketedFirstDecimalSignedNumberPattern = Pattern.compile("^[Ss]9\\(\\d+\\)[Vv]9+$");
        mixedBracketedFirstDecimalUnsignedNumberPattern = Pattern.compile("^9\\(\\d+\\)[Vv]9+$");
        mixedBracketedLastDecimalSignedNumberPattern = Pattern.compile("^[Ss]9+[Vv]9\\(\\d+\\)$");
        mixedBracketedLastDecimalUnsignedNumberPattern = Pattern.compile("^9+[Vv]9\\(\\d+\\)$");
        unSignedVNineBracketedQ = Pattern.compile("^[Vv]9\\(\\d+\\)$");
        unSignedNineBracketedPV = Pattern.compile("^9\\(\\d+\\)[Vv]$");
        signedVNineBracketedQ = Pattern.compile("^[Ss][Vv]9\\(\\d+\\)$");
        signedNineBracketedPV = Pattern.compile("^[Ss]9\\(\\d+\\)[Vv]$");
        unSignedVNines = Pattern.compile("^[Vv]9+$");
        unSignedNinesV = Pattern.compile("^9+[Vv]$");
        signedVNines = Pattern.compile("^[Ss][Vv]9+$");
        signedNinesV = Pattern.compile("^[Ss]9+[Vv]$");
    }
}

