/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.cobol;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMInputArrayEndDataType;
import com.ibm.cics.schema.ICMInputArrayStartDataType;
import com.ibm.cics.schema.ICMInputContainerDataType;
import com.ibm.cics.schema.ICMInputField;
import com.ibm.cics.schema.ICMInputSimpleDataType;
import com.ibm.cics.schema.ICMInputStructureEndDataType;
import com.ibm.cics.schema.ICMInputStructureStartDataType;
import com.ibm.cics.schema.impl.Factory;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.cobol.CobolDataType;
import com.ibm.cics.wsdl.cobol.MakeCobol;
import com.ibm.cics.wsdl.cobol.StructDetails;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.ls2ws.LangStruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LangStruct_Cobol
extends LangStruct {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private boolean firstDataLine;
    private static final int COBOL_COMMENT_POSITION = 6;
    private static final int COBOL_LINE_LENGTH = 72;
    private Stack<StructDetails> stack = new Stack();
    private int subscript = 1;
    private ICMInputField odoFound;
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("(\\,|\\;)+(\\s|$)");
    private static final Pattern SKIP_PATTERN = Pattern.compile("SKIP[1-3]");

    public LangStruct_Cobol(boolean useAbstimeDates) {
        super(false, useAbstimeDates);
        this.stack.push(new StructDetails());
    }

    @Override
    protected void processLangStructure(String s, String structureName, String fileName) throws CICSWSDLException {
        this.log.println("Input to process function: " + s);
        this.firstDataLine = true;
        ArrayList<ICMInputField> cobolParsingEvents = new ArrayList<ICMInputField>();
        StringTokenizer st = new StringTokenizer(s, ".'\"", true);
        StringBuilder line = new StringBuilder();
        char currentBracket = '\u0000';
        while (st.hasMoreElements()) {
            String token = (String)st.nextElement();
            if (token.equals("'") || token.equals("\"")) {
                char bracketFound = token.charAt(0);
                if (currentBracket == '\u0000') {
                    currentBracket = bracketFound;
                } else if (currentBracket == bracketFound) {
                    currentBracket = '\u0000';
                }
                line.append(bracketFound);
                continue;
            }
            if (token.equals(".")) {
                if (currentBracket != '\u0000') {
                    line.append(token);
                    continue;
                }
                String lineStr = line.toString().trim();
                if (lineStr.length() > 0) {
                    this.parseLine(lineStr, fileName, cobolParsingEvents);
                }
                line.delete(0, line.length());
                continue;
            }
            line.append(token);
        }
        String lineStr = line.toString().trim();
        if (lineStr.length() > 0) {
            this.parseLine(lineStr, fileName, cobolParsingEvents);
        }
        this.closeStructuresToLevel(0, cobolParsingEvents);
        this.processEventsList(cobolParsingEvents);
    }

    private void processEventsList(List<ICMInputField> parsingEvents) throws CICSWSDLException {
        Stack<ICMInputArrayStartDataType> arrayStack = new Stack<ICMInputArrayStartDataType>();
        this.odoFound = null;
        for (ICMInputField event : parsingEvents) {
            if (event instanceof ICMInputSimpleDataType) {
                this.checkForODOError(arrayStack, event);
                this.addDataElementEntry((ICMInputSimpleDataType)event);
                continue;
            }
            if (event instanceof ICMInputContainerDataType) {
                this.checkForODOError(arrayStack, event);
                this.addContainer((ICMInputContainerDataType)event);
                continue;
            }
            if (event instanceof ICMInputArrayStartDataType) {
                arrayStack.push((ICMInputArrayStartDataType)event);
                this.checkForODOError(arrayStack, event);
                this.addFixedRepeatEntry((ICMInputArrayStartDataType)event);
                continue;
            }
            if (event instanceof ICMInputArrayEndDataType) {
                this.checkForODOError(arrayStack, event);
                arrayStack.pop();
                this.addEndRepeatEntry((ICMInputArrayEndDataType)event);
                continue;
            }
            if (event instanceof ICMInputStructureStartDataType) {
                this.checkForODOError(arrayStack, event);
                this.sendStructStart((ICMInputStructureStartDataType)event);
                continue;
            }
            if (event instanceof ICMInputStructureEndDataType) {
                this.sendStructEnd((ICMInputStructureEndDataType)event);
                continue;
            }
            throw new RuntimeException("Unexpected COBOL Event type: " + event.getClass());
        }
    }

    private void checkForODOError(Stack<ICMInputArrayStartDataType> arrayStack, ICMInputField field) throws CICSWSDLException {
        if (field.getODOTarget() != null) {
            if (this.odoFound != null) {
                this.handleODOError(this.odoFound);
            }
            this.odoFound = field;
        } else if (this.odoFound != null) {
            if (this.odoFound instanceof ICMInputArrayStartDataType) {
                if (arrayStack.contains(this.odoFound)) {
                    return;
                }
                this.handleODOError(this.odoFound);
            }
            this.handleODOError(this.odoFound);
        }
    }

    private void handleODOError(ICMInputField odo) throws CICSWSDLException {
        CICSWSDLException newEx = odo instanceof ICMInputArrayStartDataType ? new CICSWSDLException(MessageHandler.buildMessage("DFHPI9719E", new Object[]{((ICMInputArrayStartDataType)odo).getName()})) : new CICSWSDLException(MessageHandler.buildMessage("DFHPI9717E", new Object[]{((ICMInputSimpleDataType)odo).getName()}));
        throw newEx;
    }

    protected final void parseLine(String linePassedIn, String fileName, List<ICMInputField> cobolParsingEvents) throws CICSWSDLException {
        String name = null;
        String line = SEPARATOR_PATTERN.matcher(linePassedIn).replaceAll(" ");
        this.log.println("Parsing data description entry: " + line);
        StringTokenizer tokens = new StringTokenizer(line);
        if (tokens.countTokens() > 0) {
            ICMInputField field;
            String nextToken = tokens.nextToken();
            String upperCaseToken = nextToken.toUpperCase(Locale.ENGLISH);
            Matcher SKIP_MATCHER = SKIP_PATTERN.matcher(upperCaseToken);
            while (SKIP_MATCHER.matches()) {
                if (tokens.hasMoreTokens()) {
                    nextToken = tokens.nextToken();
                    upperCaseToken = nextToken.toUpperCase(Locale.ENGLISH);
                    SKIP_MATCHER.reset(upperCaseToken);
                    continue;
                }
                return;
            }
            int thisLevel = this.getLevel(nextToken, fileName);
            if (thisLevel == 88) {
                return;
            }
            if (!tokens.hasMoreTokens()) {
                CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9688E", new Object[]{line, fileName}));
                throw newEx;
            }
            name = tokens.nextToken();
            if (MakeCobol.internalKeywords.get(name) != null) {
                name = "FILLER";
                tokens = new StringTokenizer(line);
                tokens.nextToken();
            }
            boolean filler = false;
            if (name.equalsIgnoreCase("FILLER")) {
                name = name + this.subscript;
                ++this.subscript;
                filler = true;
            }
            String initialName = name;
            this.closeStructuresToLevel(thisLevel, cobolParsingEvents);
            Set<String> uniqueNameSet = this.stack.peek().getUniqueNameSet();
            name = this.ensureValidXMLString(name, uniqueNameSet);
            CobolDataType data = new CobolDataType(name, tokens, this.mappingStrategy, this.mappingLevel, fileName, this.useAbstimeDates, this.props, initialName, this.platform);
            if (data.getMaxOccurs() > 1) {
                field = Factory.createICMArrayStartDataType(name, data.getMinOccurs(), data.getMaxOccurs(), !data.hasData());
                field.setSuppressed(filler);
                String odoTarget = data.getOdoTarget();
                if (odoTarget != null) {
                    this.processODO(field, odoTarget, cobolParsingEvents);
                }
                cobolParsingEvents.add(field);
                this.stack.push(new StructDetails(thisLevel, true));
            }
            if (data.hasData()) {
                ICM.ICMDataType icmType = data.getType();
                ICMInputSimpleDataType field2 = Factory.createICMSimpleDataType(name, icmType);
                field2.setLar(data.getLAR());
                field2.setFractionDigits(data.getFractions());
                field2.setAligned(data.getSync());
                field2.setSignLeading(data.isSignLeading());
                field2.setSeparateCharacter(data.isSignSeparate());
                field2.setSuppressed(filler);
                field2.setMappingStrategy(data.getMappingStrategy());
                field2.setMinLength(data.getMinLength());
                field2.setOriginalFieldName(initialName);
                String odoTarget = data.getOdoTarget();
                if (odoTarget != null && data.getMaxOccurs() <= 1) {
                    this.processODO(field2, odoTarget, cobolParsingEvents);
                }
                cobolParsingEvents.add(field2);
            }
            if (!data.hasData() && data.getMaxOccurs() <= 1) {
                field = Factory.createICMStructureStartDataType(name, ICM.StructureType.STRUCTURE_STANDARD);
                field.setSuppressed(filler);
                cobolParsingEvents.add(field);
                this.stack.push(new StructDetails(thisLevel, false));
            }
        }
    }

    private void processODO(ICMInputField sourceField, String odoTargetName, List<ICMInputField> cobolParsingEvents) throws CICSWSDLException {
        boolean found = false;
        for (int i = 0; i < cobolParsingEvents.size(); ++i) {
            int nextCursor;
            int prevCursor;
            ICMInputSimpleDataType targetDataType;
            ICMInputField field = cobolParsingEvents.get(i);
            if (!(field instanceof ICMInputSimpleDataType) || !(targetDataType = (ICMInputSimpleDataType)field).getOriginalFieldName().equalsIgnoreCase(odoTargetName)) continue;
            found = true;
            targetDataType.setSuppressed(true);
            sourceField.setODOTarget(targetDataType);
            targetDataType.setODOTarget(true);
            for (prevCursor = i - 1; prevCursor > 0 && cobolParsingEvents.get(prevCursor).isSuppressed(); --prevCursor) {
            }
            for (nextCursor = i + 1; nextCursor < cobolParsingEvents.size() - 1 && cobolParsingEvents.get(nextCursor).isSuppressed(); ++nextCursor) {
            }
            if (nextCursor == cobolParsingEvents.size()) break;
            ICMInputField prev = cobolParsingEvents.get(prevCursor);
            ICMInputField next = cobolParsingEvents.get(nextCursor);
            if (!(prev instanceof ICMInputStructureStartDataType) || !(next instanceof ICMInputStructureEndDataType)) break;
            prev.setSuppressed(true);
            next.setSuppressed(true);
            break;
        }
        if (!found) {
            String name = "";
            if (sourceField instanceof ICMInputSimpleDataType) {
                name = ((ICMInputSimpleDataType)sourceField).getName();
            } else if (sourceField instanceof ICMInputArrayStartDataType) {
                name = ((ICMInputArrayStartDataType)sourceField).getName();
            }
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9716E", new Object[]{odoTargetName, name}));
        }
    }

    private void closeStructuresToLevel(int targetLevel, List<ICMInputField> cobolParsingEvents) throws CICSWSDLException {
        int topOfStack = this.stack.peek().getLevel();
        while (targetLevel <= topOfStack) {
            if (topOfStack == 0) {
                return;
            }
            StructDetails sd = this.stack.pop();
            if (sd.isArray()) {
                cobolParsingEvents.add(Factory.createICMArrayEndDataType());
            } else {
                cobolParsingEvents.add(Factory.createICMStructureEndDataType());
            }
            topOfStack = this.stack.peek().getLevel();
        }
    }

    private int getLevel(String s, String fileName) throws CICSWSDLException {
        int level = 0;
        level = Util.stringToInt(s, -1, true, fileName);
        if (level == 1 && !this.firstDataLine) {
            Logging.writeMessage(12, "DFHPI9555E", null);
        }
        this.firstDataLine = false;
        return level;
    }

    @Override
    protected final String preProcessLine(String s1) {
        String line = null;
        String s = "";
        if (s1.length() >= 6) {
            s = s1.substring(6);
        }
        if ((s = "      " + s).indexOf("*") == 6) {
            line = "";
        } else if (s.indexOf("-") == 6) {
            int charIndex;
            int totalLen = s.length();
            for (charIndex = 7; charIndex < totalLen && Character.isWhitespace(s.charAt(charIndex)); ++charIndex) {
            }
            if (charIndex == totalLen) {
                line = "";
            } else {
                int endIndex = 71;
                if (endIndex > totalLen - 1) {
                    endIndex = totalLen - 1;
                }
                while (endIndex >= charIndex && Character.isWhitespace(s.charAt(endIndex))) {
                    --endIndex;
                }
                line = s.substring(charIndex, endIndex + 1);
            }
        } else if (s.length() > 72) {
            line = s.substring(6, 72).trim();
            if (!line.equals("")) {
                line = " " + line;
            }
        } else if (s.length() > 6) {
            line = s.substring(6).trim();
            if (!line.equals("")) {
                line = " " + line;
            }
        } else {
            line = "";
        }
        return line;
    }
}

