/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.cobol;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMFixedRepeatEntry;
import com.ibm.cics.schema.ICMRepeatEntry;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.ws2ls.MakeLang;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class MakeCobol
extends MakeLang {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final Pattern underscorePattern = Pattern.compile("_");
    private static final Pattern illegalCharsPattern = Pattern.compile("[^a-zA-Z0-9-]");
    private static final Pattern firstCharPattern = Pattern.compile("^[^a-zA-Z]");
    private static final Pattern hyphenPattern = Pattern.compile("-$");
    private static final int NAME_SIZE = 30;
    private static final int LANGSTRUCT_INDENT = 7;
    private static final int MAX_LINE_LENGTH = 71;
    private static final String COMMENT_START = "      * ";
    public static final int MAX_VARIABLE_LENGTH = 30;
    private static final int COMMENT_FORMAT_ADJUSTMENT = 8;
    private static final String LINE_TERMINATOR = ".";
    private static final String NATURAL_SEPERATOR = "-";
    static final Map<String, Boolean> internalKeywords = new HashMap<String, Boolean>();

    public MakeCobol(ICM.XMLContentType messageType, QName artifactName, String pdsName, String structName, int mappingLevel, int mep, int langStructIncrement, boolean runZOS, int tool, Map<QName, String> typeMemberNameMap, Properties theInputParms, boolean response) {
        super(messageType, artifactName, pdsName, structName, internalKeywords, false, mappingLevel, mep, langStructIncrement, runZOS, tool, typeMemberNameMap, theInputParms, response);
    }

    @Override
    protected final void gotFixedRepeat(ICMFixedRepeatEntry fixRepeat, boolean isStructural) throws CICSWSDLException {
        if (MappingLevelHelper.requiresMappingLevel_1(this.mappingLevel)) {
            super.gotFixedRepeat(fixRepeat, isStructural, 0);
        } else {
            super.gotFixedRepeat(fixRepeat, isStructural, 1);
        }
    }

    @Override
    protected String buildDataLine(String name, ICM.ICMDataType type, int lar, int fractions, boolean aligned, int level, Stack<ICMFixedRepeatEntry> repeatStack, ICM.VaryingLength mappingStrategy, boolean signLeading, boolean separateChar, String odoTargetFieldName, int minLength) throws CICSWSDLException {
        String cobol = this.buildCobol(type, lar, fractions, aligned, signLeading, separateChar, odoTargetFieldName, minLength);
        String levelValue = this.formatLevel(level);
        StringBuilder formattedName = new StringBuilder(name);
        formattedName.append(" ");
        while (!repeatStack.empty()) {
            int dimension = repeatStack.pop().getOccurances();
            formattedName.append(this.formatOccurs(dimension));
        }
        String formattedNameString = this.formatName(formattedName.toString());
        return levelValue + formattedNameString + cobol + LINE_TERMINATOR;
    }

    @Override
    protected void buildStructLine(String name, int level, Stack<ICMFixedRepeatEntry> repeatStack) throws CICSWSDLException {
        String levelValue = this.formatLevel(level);
        StringBuilder formattedName = new StringBuilder(name);
        formattedName.append(" ");
        while (!repeatStack.empty()) {
            ICMFixedRepeatEntry fr = repeatStack.pop();
            if (fr.getODOTarget() != null) {
                formattedName.append("OCCURS ");
                formattedName.append(fr.getMinOccurance());
                formattedName.append(" TO ");
                formattedName.append(fr.getMaxOccurance());
                formattedName.append(" DEPENDING ON ");
                formattedName.append(fr.getODOTarget().getLocalName());
                continue;
            }
            formattedName.append(this.formatOccurs(fr.getOccurances()));
        }
        String formattedNameString = this.formatName(formattedName.toString());
        String line = levelValue + formattedNameString.trim() + LINE_TERMINATOR;
        this.block.addElement(line);
    }

    @Override
    protected String buildContainerNumberLine(String contid, int level, ICMRepeatEntry varRepeat) throws CICSWSDLException {
        String cobol = "PIC S9(9) COMP-5 SYNC";
        String varName = this.getContainerOccurencesUniqueFieldName(contid, true, varRepeat);
        return this.formatLevel(level) + this.formatName(varName) + cobol + LINE_TERMINATOR;
    }

    @Override
    protected String buildContainerNameLine(String contid, int level) throws CICSWSDLException {
        String cobol = "PIC X(16)";
        String varName = this.getContainerUniqueFieldName(contid, true);
        return this.formatLevel(level) + this.formatName(varName) + cobol + LINE_TERMINATOR;
    }

    @Override
    protected String buildDescriminatorNameLine(String contid, int level) throws CICSWSDLException {
        String cobol = "PIC X DISPLAY";
        String varName = this.getDescriminatorUniqueFieldName(contid, true);
        return this.formatLevel(level) + this.formatName(varName) + cobol + LINE_TERMINATOR;
    }

    private String formatName(String name) {
        StringBuilder localName = new StringBuilder(name);
        int currentLength = name.length();
        int amountToAdd = 30 - currentLength;
        if (amountToAdd > 0) {
            for (int i = 0; i < amountToAdd; ++i) {
                localName.append(" ");
            }
        } else {
            localName.append(" ");
        }
        return localName.toString();
    }

    private String formatLevel88Name(String name) {
        String localName = name;
        localName = this.ensureValidName(localName, false, true, false);
        localName = this.formatName(localName);
        return localName;
    }

    private String formatLevel(int level) throws CICSWSDLException {
        DecimalFormat myFormatter = new DecimalFormat("00");
        int number = 1;
        if (level > 1) {
            number = (level - 1) * this.langstructIncrement;
        }
        String output = myFormatter.format(number);
        if (number > 49) {
            String increment = myFormatter.format(this.langstructIncrement);
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9739E", new Object[]{increment, output}));
        }
        int numToIndent = 7 + 2 * level;
        for (int i = 0; i < numToIndent; ++i) {
            output = " " + output;
        }
        return output + " ";
    }

    @Override
    protected String formatOccurs(int o) {
        String s = "";
        if (o > 1) {
            s = "OCCURS " + o;
        }
        return s;
    }

    private String buildCobol(ICM.ICMDataType type, int lar, int fractions, boolean aligned, boolean signLeading, boolean separateChar, String odoTargetFieldName, int minLength) throws CICSWSDLException {
        String result = null;
        switch (type) {
            case DECIMAL: 
            case ZONED: 
            case UNSIGNED_DECIMAL: 
            case UNSIGNED_ZONED: 
            case ABSTIME: {
                if (fractions != 0) {
                    result = lar != 0 ? "9(" + lar + ")V9(" + fractions + ")" : "V9(" + fractions + ")";
                } else if (lar != 0) {
                    result = "9(" + lar + ")";
                } else {
                    throw new CICSWSDLException("INTERNAL_ERROR: 0 length signed data type required");
                }
                if (type.equals((Object)ICM.ICMDataType.DECIMAL) || type.equals((Object)ICM.ICMDataType.UNSIGNED_DECIMAL) || type.equals((Object)ICM.ICMDataType.ABSTIME)) {
                    result = result + " COMP-3";
                } else {
                    result = result + " DISPLAY";
                    if (signLeading) {
                        result = result + " LEADING";
                    }
                    if (separateChar) {
                        result = result + " SEPARATE";
                    }
                }
                if (type.equals((Object)ICM.ICMDataType.DECIMAL) || type.equals((Object)ICM.ICMDataType.ZONED) || type.equals((Object)ICM.ICMDataType.ABSTIME)) {
                    result = "S" + result;
                }
                result = "PIC " + result;
                break;
            }
            case CHAR_ARRAY: 
            case HEX_ARRAY: 
            case BASE64_ARRAY: {
                if (odoTargetFieldName != null) {
                    result = "PIC X OCCURS " + minLength + " TO " + lar + " DEPENDING ON " + odoTargetFieldName;
                    break;
                }
                result = "PIC X(" + lar + ")";
                break;
            }
            case WIDE_CHAR_ARRAY: {
                result = "PIC G(" + lar + ") DISPLAY-1";
                break;
            }
            case UTF16_CHAR_ARRAY: {
                result = "PIC N(" + lar + ") USAGE NATIONAL";
                break;
            }
            case BYTE: 
            case BOOLEAN: 
            case UNSIGNED_BYTE: {
                result = "PIC X DISPLAY";
                break;
            }
            case SHORT: {
                result = lar == 0 ? "PIC S9999 COMP-5" : "PIC S9(" + lar + ") DISPLAY";
                if (!aligned || lar != 0) break;
                result = result + " SYNC";
                break;
            }
            case UNSIGNED_SHORT: {
                result = lar == 0 ? "PIC 9999 COMP-5" : "PIC 9(" + lar + ") DISPLAY";
                if (!aligned || lar != 0) break;
                result = result + " SYNC";
                break;
            }
            case INT: {
                result = lar == 0 ? "PIC S9(9) COMP-5" : "PIC S9(" + lar + ") DISPLAY";
                if (!aligned || lar != 0) break;
                result = result + " SYNC";
                break;
            }
            case UNSIGNED_INT: {
                result = lar == 0 ? "PIC 9(9) COMP-5" : "PIC 9(" + lar + ") DISPLAY";
                if (!aligned || lar != 0) break;
                result = result + " SYNC";
                break;
            }
            case LONG: {
                result = lar == 0 ? "PIC S9(18) COMP-5" : "PIC S9(" + lar + ") DISPLAY";
                if (!aligned || lar != 0) break;
                result = result + " SYNC";
                break;
            }
            case UNSIGNED_LONG: {
                result = lar == 0 ? "PIC 9(18) COMP-5" : "PIC 9(" + lar + ") DISPLAY";
                if (!aligned || lar != 0) break;
                result = result + " SYNC";
                break;
            }
            case HFP_SHORT: 
            case BFP_FLOAT: {
                result = "COMP-1";
                if (!aligned) break;
                result = result + " SYNC";
                break;
            }
            case HFP_LONG: 
            case BFP_DOUBLE: {
                result = "COMP-2";
                if (!aligned) break;
                result = result + " SYNC";
                break;
            }
            default: {
                throw new CICSWSDLException("INTERNAL_ERROR: ICM Type '" + (Object)((Object)type) + "' not recognised.");
            }
        }
        return result;
    }

    @Override
    protected void markEnd() {
    }

    @Override
    protected final String ensureValidInLang(String basename) {
        String validName = basename;
        if (MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel) || this.inputParms.getProperty("UNDERSCORES-AS-HYPHENS") != null && this.inputParms.getProperty("UNDERSCORES-AS-HYPHENS") == "YES") {
            Matcher underscoreMatcher = underscorePattern.matcher(basename);
            validName = underscoreMatcher.replaceAll(NATURAL_SEPERATOR);
            validName = this.ensureNotKeyword(validName);
        }
        Matcher illegalMatcher = illegalCharsPattern.matcher(validName);
        validName = illegalMatcher.replaceAll("X");
        Matcher firstCharMatcher = firstCharPattern.matcher(validName);
        validName = firstCharMatcher.replaceAll("X");
        Matcher hyphenMatcher = hyphenPattern.matcher(validName);
        validName = hyphenMatcher.replaceAll("X");
        return validName;
    }

    @Override
    protected final String ensureValidVariableLength(String basename) {
        return this.shrinkToFit(basename, 28);
    }

    @Override
    protected final String ensureValidContainerIDLength(String basename) {
        int RESERVED_SPACE = 7;
        return this.shrinkToFit(basename, 30 - RESERVED_SPACE);
    }

    @Override
    protected final int getInitialNestingLevel() {
        return 1;
    }

    @Override
    protected final String generateIndentForComments() {
        return "        ";
    }

    @Override
    protected final int getMaxLineLength() {
        return 71;
    }

    @Override
    protected final List<String> removeCommentsFromStringList(List<String> input) {
        ArrayList<String> output = new ArrayList<String>();
        for (String line : input) {
            if (line.startsWith(COMMENT_START)) continue;
            output.add(line);
        }
        output.add(0, "      * ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        return output;
    }

    @Override
    protected final List<String> addHeaderFormatting(List<String> input) {
        for (int i = 0; i < input.size(); ++i) {
            String line = input.get(i);
            if (!line.startsWith(COMMENT_START)) {
                line = line.startsWith("        ") ? COMMENT_START + line.substring(8) : COMMENT_START + line;
            }
            input.set(i, line);
        }
        input.add(0, "      * ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        return input;
    }

    @Override
    protected String getTopLevelStrucName(String baseName) {
        return this.getMemberName() + NATURAL_SEPERATOR + baseName;
    }

    @Override
    protected String getContentName(String baseName) {
        baseName = this.shrinkToFit(baseName, 20);
        return baseName + "-value";
    }

    @Override
    protected String getAttributeName(String localName, String elName, boolean nil) {
        localName = this.shrinkToFit(localName, 17);
        if (nil) {
            elName = this.shrinkToFit(elName, 13);
            return "attr-" + localName + NATURAL_SEPERATOR + elName + "-value";
        }
        return "attr-" + localName + "-value";
    }

    @Override
    protected String getAttributeExistenceByteName(String localName, String elName, boolean nil) {
        localName = this.shrinkToFit(localName, 17);
        if (nil) {
            elName = this.shrinkToFit(elName, 13);
            return "attr-" + localName + NATURAL_SEPERATOR + elName + "-exist";
        }
        return "attr-" + localName + "-exist";
    }

    @Override
    protected String getContainerFieldName(String baseName) {
        if (MappingLevelHelper.supportsMappingLevel_1_1(this.mappingLevel)) {
            int maxLength = 26;
            if (this.inputParms.getProperty("ZOS-CONNECT-EE").equals("true")) {
                String containerName = this.inputParms.getProperty("CONTAINER-NAME-SUFFIX");
                if (containerName != null) {
                    baseName = this.shrinkToFit(baseName, maxLength -= containerName.length()) + NATURAL_SEPERATOR + containerName;
                } else {
                    maxLength = 18;
                    baseName = this.shrinkToFit(baseName, maxLength) + "-dataarea";
                }
            } else {
                maxLength = 22;
                baseName = this.shrinkToFit(baseName, maxLength) + "-cont";
            }
        }
        return baseName;
    }

    @Override
    protected String getDescriminatorFieldName(String baseName) {
        baseName = this.shrinkToFit(baseName, 22);
        return baseName + "-enum";
    }

    @Override
    protected String buildEnumerationValueLine(String name, String value) throws CICSWSDLException {
        String levelNum = this.formatLevel(this.block.getNestingLevel() + 2);
        levelNum = levelNum.substring(0, levelNum.length() - 3) + "88 ";
        String shortName = name.substring(name.indexOf(45) + 1);
        if (shortName.equalsIgnoreCase("empty")) {
            return levelNum + this.formatName(shortName) + "VALUE X'" + value + "'" + LINE_TERMINATOR;
        }
        return levelNum + this.formatLevel88Name(shortName) + "VALUE X'" + value + "'" + LINE_TERMINATOR;
    }

    @Override
    protected String getContainerOccurencesFieldName(String baseName, ICMRepeatEntry varRepeat) {
        if (MappingLevelHelper.supportsMappingLevel_1_1(this.mappingLevel)) {
            String originalName = baseName;
            baseName = this.shrinkToFit(baseName, 22) + "-num";
            if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                if (this.inputParms.getProperty("ZOS-CONNECT-EE").equals("true") && !varRepeat.isOptionalArray() && Util.isResponseCodeEntity(originalName)) {
                    baseName = this.shrinkToFit(originalName, 16) + "-existence";
                } else if (varRepeat.getMinOccurance() == 0 && varRepeat.getMaxOccurance() == 1) {
                    baseName = this.shrinkToFit(originalName, 16) + "-existence";
                }
            }
        }
        return baseName;
    }

    @Override
    protected void addComment(String comment) {
        String[] lines = comment.split("\r\n|\r|\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i != 0) {
                line = line.trim();
            }
            this.block.addElement(COMMENT_START + line);
        }
    }

    @Override
    protected int getCommentAdjustment() {
        return 8;
    }

    @Override
    protected String getLineTerminator() {
        return LINE_TERMINATOR;
    }

    @Override
    protected String getNaturalSeperator() {
        return NATURAL_SEPERATOR;
    }

    @Override
    protected void buildOuterStructLine(String name) throws CICSWSDLException {
        this.block.addElement(this.formatLevel(this.block.getNestingLevel()) + name + LINE_TERMINATOR);
    }

    @Override
    protected void closeOuterBlock() {
    }

    @Override
    protected void closeInnerBlock() {
    }

    @Override
    protected boolean mustBeUnique(String varName) {
        return !"FILLER".equalsIgnoreCase(varName);
    }

    @Override
    protected String getVaryingLengthCountName(String baseName) {
        baseName = this.shrinkToFit(baseName, 20);
        return baseName + "-length";
    }

    @Override
    protected boolean supportsPureDBCS() {
        return MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel);
    }

    @Override
    protected boolean supportsNameClashes() {
        return this.inputParms.getProperty("NO-ARRAY-NAME-INDEXING") == "YES";
    }

    @Override
    protected int getLanguageType() {
        return 1;
    }

    static {
        internalKeywords.put("ACCEPT", Boolean.TRUE);
        internalKeywords.put("ACCESS", Boolean.TRUE);
        internalKeywords.put("ADD", Boolean.TRUE);
        internalKeywords.put("ADDRESS", Boolean.TRUE);
        internalKeywords.put("ADVANCING", Boolean.TRUE);
        internalKeywords.put("AFTER", Boolean.TRUE);
        internalKeywords.put("ALL", Boolean.TRUE);
        internalKeywords.put("ALLOWING", Boolean.TRUE);
        internalKeywords.put("ALPHABET", Boolean.TRUE);
        internalKeywords.put("ALPHABETIC", Boolean.TRUE);
        internalKeywords.put("ALPHABETIC-LOWER", Boolean.TRUE);
        internalKeywords.put("ALPHABETIC-UPPER", Boolean.TRUE);
        internalKeywords.put("ALPHANUMERIC", Boolean.TRUE);
        internalKeywords.put("ALPHANUMERIC-EDITED", Boolean.TRUE);
        internalKeywords.put("ALSO", Boolean.TRUE);
        internalKeywords.put("ALTER", Boolean.TRUE);
        internalKeywords.put("ALTERNATE", Boolean.TRUE);
        internalKeywords.put("AND", Boolean.TRUE);
        internalKeywords.put("ANY", Boolean.TRUE);
        internalKeywords.put("APPLY", Boolean.TRUE);
        internalKeywords.put("ARE", Boolean.TRUE);
        internalKeywords.put("AREA", Boolean.TRUE);
        internalKeywords.put("AREAS", Boolean.TRUE);
        internalKeywords.put("ARITHMETIC", Boolean.TRUE);
        internalKeywords.put("ASCENDING", Boolean.TRUE);
        internalKeywords.put("ASSIGN", Boolean.TRUE);
        internalKeywords.put("AT", Boolean.TRUE);
        internalKeywords.put("AUTHOR", Boolean.TRUE);
        internalKeywords.put("AUTOMATIC", Boolean.TRUE);
        internalKeywords.put("B-AND", Boolean.TRUE);
        internalKeywords.put("B-EXOR", Boolean.TRUE);
        internalKeywords.put("B-LESS", Boolean.TRUE);
        internalKeywords.put("B-NOT", Boolean.TRUE);
        internalKeywords.put("B-OR", Boolean.TRUE);
        internalKeywords.put("BASIS", Boolean.TRUE);
        internalKeywords.put("BEFORE", Boolean.TRUE);
        internalKeywords.put("BEGINNING", Boolean.TRUE);
        internalKeywords.put("BINARY", Boolean.TRUE);
        internalKeywords.put("BIT", Boolean.TRUE);
        internalKeywords.put("BITS", Boolean.TRUE);
        internalKeywords.put("BLANK", Boolean.TRUE);
        internalKeywords.put("BLOCK", Boolean.TRUE);
        internalKeywords.put("BOOLEAN", Boolean.TRUE);
        internalKeywords.put("BOTTOM", Boolean.TRUE);
        internalKeywords.put("BY", Boolean.TRUE);
        internalKeywords.put("CALL", Boolean.TRUE);
        internalKeywords.put("CANCEL", Boolean.TRUE);
        internalKeywords.put("CBL", Boolean.TRUE);
        internalKeywords.put("CD", Boolean.TRUE);
        internalKeywords.put("CF", Boolean.TRUE);
        internalKeywords.put("CH", Boolean.TRUE);
        internalKeywords.put("CHARACTER", Boolean.TRUE);
        internalKeywords.put("CHARACTERS", Boolean.TRUE);
        internalKeywords.put("CLASS", Boolean.TRUE);
        internalKeywords.put("CLASS-ID", Boolean.TRUE);
        internalKeywords.put("CLOCK-UNITS", Boolean.TRUE);
        internalKeywords.put("CLOSE", Boolean.TRUE);
        internalKeywords.put("COBOL", Boolean.TRUE);
        internalKeywords.put("CODE", Boolean.TRUE);
        internalKeywords.put("CODE-SET", Boolean.TRUE);
        internalKeywords.put("COLLATING", Boolean.TRUE);
        internalKeywords.put("COLUMN", Boolean.TRUE);
        internalKeywords.put("COM-REG", Boolean.TRUE);
        internalKeywords.put("COMMA", Boolean.TRUE);
        internalKeywords.put("COMMIT", Boolean.TRUE);
        internalKeywords.put("COMMON", Boolean.TRUE);
        internalKeywords.put("COMMUNICATION", Boolean.TRUE);
        internalKeywords.put("COMP", Boolean.TRUE);
        internalKeywords.put("COMP-1", Boolean.TRUE);
        internalKeywords.put("COMP-2", Boolean.TRUE);
        internalKeywords.put("COMP-3", Boolean.TRUE);
        internalKeywords.put("COMP-4", Boolean.TRUE);
        internalKeywords.put("COMP-5", Boolean.TRUE);
        internalKeywords.put("COMP-6", Boolean.TRUE);
        internalKeywords.put("COMP-7", Boolean.TRUE);
        internalKeywords.put("COMP-8", Boolean.TRUE);
        internalKeywords.put("COMP-9", Boolean.TRUE);
        internalKeywords.put("COMPUTATIONAL", Boolean.TRUE);
        internalKeywords.put("COMPUTATIONAL-1", Boolean.TRUE);
        internalKeywords.put("COMPUTATIONAL-2", Boolean.TRUE);
        internalKeywords.put("COMPUTATIONAL-3", Boolean.TRUE);
        internalKeywords.put("COMPUTATIONAL-4", Boolean.TRUE);
        internalKeywords.put("COMPUTATIONAL-5", Boolean.TRUE);
        internalKeywords.put("COMPUTATIONAL-6", Boolean.TRUE);
        internalKeywords.put("COMPUTATIONAL-7", Boolean.TRUE);
        internalKeywords.put("COMPUTATIONAL-8", Boolean.TRUE);
        internalKeywords.put("COMPUTATIONAL-9", Boolean.TRUE);
        internalKeywords.put("COMPUTE", Boolean.TRUE);
        internalKeywords.put("CONFIGURATION", Boolean.TRUE);
        internalKeywords.put("CONNECT", Boolean.TRUE);
        internalKeywords.put("CONTAINED", Boolean.TRUE);
        internalKeywords.put("CONTAINS", Boolean.TRUE);
        internalKeywords.put("CONTENT", Boolean.TRUE);
        internalKeywords.put("CONTINUE", Boolean.TRUE);
        internalKeywords.put("CONTROL", Boolean.TRUE);
        internalKeywords.put("CONTROLS", Boolean.TRUE);
        internalKeywords.put("CONVERTING", Boolean.TRUE);
        internalKeywords.put("COPY", Boolean.TRUE);
        internalKeywords.put("CORR", Boolean.TRUE);
        internalKeywords.put("CORRESPONDING", Boolean.TRUE);
        internalKeywords.put("COUNT", Boolean.TRUE);
        internalKeywords.put("CURRENCY", Boolean.TRUE);
        internalKeywords.put("CURRENT", Boolean.TRUE);
        internalKeywords.put("CYCLE", Boolean.TRUE);
        internalKeywords.put("DATA", Boolean.TRUE);
        internalKeywords.put("DATE", Boolean.TRUE);
        internalKeywords.put("DATE-COMPILED", Boolean.TRUE);
        internalKeywords.put("DATE-WRITTEN", Boolean.TRUE);
        internalKeywords.put("DAY", Boolean.TRUE);
        internalKeywords.put("DAY-OF-WEEK", Boolean.TRUE);
        internalKeywords.put("DB", Boolean.TRUE);
        internalKeywords.put("DB-ACCESS-CONTROL-KEY", Boolean.TRUE);
        internalKeywords.put("DB-DATA-NAME", Boolean.TRUE);
        internalKeywords.put("DB-EXCEPTION", Boolean.TRUE);
        internalKeywords.put("DB-RECORD-NAME", Boolean.TRUE);
        internalKeywords.put("DB-SET-NAME", Boolean.TRUE);
        internalKeywords.put("DB-STATUS", Boolean.TRUE);
        internalKeywords.put("DBCS", Boolean.TRUE);
        internalKeywords.put("DE", Boolean.TRUE);
        internalKeywords.put("DEBUG-CONTENTS", Boolean.TRUE);
        internalKeywords.put("DEBUG-ITEM", Boolean.TRUE);
        internalKeywords.put("DEBUG-LINE", Boolean.TRUE);
        internalKeywords.put("DEBUG-NAME", Boolean.TRUE);
        internalKeywords.put("DEBUG-SUB-1", Boolean.TRUE);
        internalKeywords.put("DEBUG-SUB-2", Boolean.TRUE);
        internalKeywords.put("DEBUG-SUB-3", Boolean.TRUE);
        internalKeywords.put("DEBUGGING", Boolean.TRUE);
        internalKeywords.put("DECIMAL-POINT", Boolean.TRUE);
        internalKeywords.put("DECLARATIVES", Boolean.TRUE);
        internalKeywords.put("DEFAULT", Boolean.TRUE);
        internalKeywords.put("DELETE", Boolean.TRUE);
        internalKeywords.put("DELIMITED", Boolean.TRUE);
        internalKeywords.put("DELIMITER", Boolean.TRUE);
        internalKeywords.put("DEPENDING", Boolean.TRUE);
        internalKeywords.put("DESCENDING", Boolean.TRUE);
        internalKeywords.put("DESTINATION", Boolean.TRUE);
        internalKeywords.put("DETAIL", Boolean.TRUE);
        internalKeywords.put("DISABLE", Boolean.TRUE);
        internalKeywords.put("DISCONNECT", Boolean.TRUE);
        internalKeywords.put("DISPLAY", Boolean.TRUE);
        internalKeywords.put("DISPLAY-1", Boolean.TRUE);
        internalKeywords.put("DISPLAY-2", Boolean.TRUE);
        internalKeywords.put("DISPLAY-3", Boolean.TRUE);
        internalKeywords.put("DISPLAY-4", Boolean.TRUE);
        internalKeywords.put("DISPLAY-5", Boolean.TRUE);
        internalKeywords.put("DISPLAY-6", Boolean.TRUE);
        internalKeywords.put("DISPLAY-7", Boolean.TRUE);
        internalKeywords.put("DISPLAY-8", Boolean.TRUE);
        internalKeywords.put("DISPLAY-9", Boolean.TRUE);
        internalKeywords.put("DIVIDE", Boolean.TRUE);
        internalKeywords.put("DIVISION", Boolean.TRUE);
        internalKeywords.put("DOWN", Boolean.TRUE);
        internalKeywords.put("DUPLICATE", Boolean.TRUE);
        internalKeywords.put("DUPLICATES", Boolean.TRUE);
        internalKeywords.put("DYNAMIC", Boolean.TRUE);
        internalKeywords.put("EGCS", Boolean.TRUE);
        internalKeywords.put("EGI", Boolean.TRUE);
        internalKeywords.put("EJECT", Boolean.TRUE);
        internalKeywords.put("ELSE", Boolean.TRUE);
        internalKeywords.put("EMI", Boolean.TRUE);
        internalKeywords.put("EMPTY", Boolean.TRUE);
        internalKeywords.put("ENABLE", Boolean.TRUE);
        internalKeywords.put("END", Boolean.TRUE);
        internalKeywords.put("END-ADD", Boolean.TRUE);
        internalKeywords.put("END-CALL", Boolean.TRUE);
        internalKeywords.put("END-COMPUTE", Boolean.TRUE);
        internalKeywords.put("END-DELETE", Boolean.TRUE);
        internalKeywords.put("END-DISABLE", Boolean.TRUE);
        internalKeywords.put("END-DIVIDE", Boolean.TRUE);
        internalKeywords.put("END-ENABLE", Boolean.TRUE);
        internalKeywords.put("END-EVALUATE", Boolean.TRUE);
        internalKeywords.put("END-EXEC", Boolean.TRUE);
        internalKeywords.put("END-IF", Boolean.TRUE);
        internalKeywords.put("END-INVOKE", Boolean.TRUE);
        internalKeywords.put("END-MULTIPLY", Boolean.TRUE);
        internalKeywords.put("END-OF-PAGE", Boolean.TRUE);
        internalKeywords.put("END-PERFORM", Boolean.TRUE);
        internalKeywords.put("END-READ", Boolean.TRUE);
        internalKeywords.put("END-RECEIVE", Boolean.TRUE);
        internalKeywords.put("END-RETURN", Boolean.TRUE);
        internalKeywords.put("END-REWRITE", Boolean.TRUE);
        internalKeywords.put("END-SEARCH", Boolean.TRUE);
        internalKeywords.put("END-SEND", Boolean.TRUE);
        internalKeywords.put("END-START", Boolean.TRUE);
        internalKeywords.put("END-STRING", Boolean.TRUE);
        internalKeywords.put("END-SUBTRACT", Boolean.TRUE);
        internalKeywords.put("END-TRANSCEIVE", Boolean.TRUE);
        internalKeywords.put("END-UNSTRING", Boolean.TRUE);
        internalKeywords.put("END-WRITE", Boolean.TRUE);
        internalKeywords.put("END-XML", Boolean.TRUE);
        internalKeywords.put("ENDING", Boolean.TRUE);
        internalKeywords.put("ENTER", Boolean.TRUE);
        internalKeywords.put("ENTRY", Boolean.TRUE);
        internalKeywords.put("ENVIRONMENT", Boolean.TRUE);
        internalKeywords.put("EOP", Boolean.TRUE);
        internalKeywords.put("EQUAL", Boolean.TRUE);
        internalKeywords.put("EQUALS", Boolean.TRUE);
        internalKeywords.put("ERASE", Boolean.TRUE);
        internalKeywords.put("ERROR", Boolean.TRUE);
        internalKeywords.put("ESI", Boolean.TRUE);
        internalKeywords.put("EVALUATE", Boolean.TRUE);
        internalKeywords.put("EVERY", Boolean.TRUE);
        internalKeywords.put("EXACT", Boolean.TRUE);
        internalKeywords.put("EXCEEDS", Boolean.TRUE);
        internalKeywords.put("EXCEPTION", Boolean.TRUE);
        internalKeywords.put("EXCLUSIVE", Boolean.TRUE);
        internalKeywords.put("EXEC", Boolean.TRUE);
        internalKeywords.put("EXECUTE", Boolean.TRUE);
        internalKeywords.put("EXIT", Boolean.TRUE);
        internalKeywords.put("EXTEND", Boolean.TRUE);
        internalKeywords.put("EXTERNAL", Boolean.TRUE);
        internalKeywords.put("FACTORY", Boolean.TRUE);
        internalKeywords.put("FALSE", Boolean.TRUE);
        internalKeywords.put("FD", Boolean.TRUE);
        internalKeywords.put("FETCH", Boolean.TRUE);
        internalKeywords.put("FILE", Boolean.TRUE);
        internalKeywords.put("FILE-CONTROL", Boolean.TRUE);
        internalKeywords.put("FINAL", Boolean.TRUE);
        internalKeywords.put("FIND", Boolean.TRUE);
        internalKeywords.put("FINISH", Boolean.TRUE);
        internalKeywords.put("FIRST", Boolean.TRUE);
        internalKeywords.put("FOOTING", Boolean.TRUE);
        internalKeywords.put("FOR", Boolean.TRUE);
        internalKeywords.put("FORM", Boolean.TRUE);
        internalKeywords.put("FORMAT", Boolean.TRUE);
        internalKeywords.put("FREE", Boolean.TRUE);
        internalKeywords.put("FROM", Boolean.TRUE);
        internalKeywords.put("FUNCTION", Boolean.TRUE);
        internalKeywords.put("FUNCTION-POINTERL", Boolean.TRUE);
        internalKeywords.put("GENERATE", Boolean.TRUE);
        internalKeywords.put("GET", Boolean.TRUE);
        internalKeywords.put("GIVING", Boolean.TRUE);
        internalKeywords.put("GLOBAL", Boolean.TRUE);
        internalKeywords.put("GO", Boolean.TRUE);
        internalKeywords.put("GOBACK", Boolean.TRUE);
        internalKeywords.put("GREATER", Boolean.TRUE);
        internalKeywords.put("GROUP", Boolean.TRUE);
        internalKeywords.put("GROUP-USAGE", Boolean.TRUE);
        internalKeywords.put("HEADING", Boolean.TRUE);
        internalKeywords.put("HIGH-VALUE", Boolean.TRUE);
        internalKeywords.put("HIGH-VALUES", Boolean.TRUE);
        internalKeywords.put("I-O", Boolean.TRUE);
        internalKeywords.put("I-O-CONTROL", Boolean.TRUE);
        internalKeywords.put("ID", Boolean.TRUE);
        internalKeywords.put("IDENTIFICATION", Boolean.TRUE);
        internalKeywords.put("IF", Boolean.TRUE);
        internalKeywords.put("IN", Boolean.TRUE);
        internalKeywords.put("INDEX", Boolean.TRUE);
        internalKeywords.put("INDEX-1", Boolean.TRUE);
        internalKeywords.put("INDEX-2", Boolean.TRUE);
        internalKeywords.put("INDEX-3", Boolean.TRUE);
        internalKeywords.put("INDEX-4", Boolean.TRUE);
        internalKeywords.put("INDEX-5", Boolean.TRUE);
        internalKeywords.put("INDEX-6", Boolean.TRUE);
        internalKeywords.put("INDEX-7", Boolean.TRUE);
        internalKeywords.put("INDEX-8", Boolean.TRUE);
        internalKeywords.put("INDEX-9", Boolean.TRUE);
        internalKeywords.put("INDEXED", Boolean.TRUE);
        internalKeywords.put("INDICATE", Boolean.TRUE);
        internalKeywords.put("INHERITS", Boolean.TRUE);
        internalKeywords.put("INITIAL", Boolean.TRUE);
        internalKeywords.put("INITIALIZE", Boolean.TRUE);
        internalKeywords.put("INITIATE", Boolean.TRUE);
        internalKeywords.put("INPUT", Boolean.TRUE);
        internalKeywords.put("INPUT-OUTPUT", Boolean.TRUE);
        internalKeywords.put("INSERT", Boolean.TRUE);
        internalKeywords.put("INSPECT", Boolean.TRUE);
        internalKeywords.put("INSTALLATION", Boolean.TRUE);
        internalKeywords.put("INTO", Boolean.TRUE);
        internalKeywords.put("INVALID", Boolean.TRUE);
        internalKeywords.put("INVOKE", Boolean.TRUE);
        internalKeywords.put("IS", Boolean.TRUE);
        internalKeywords.put("JNIENVPTR", Boolean.TRUE);
        internalKeywords.put("JUST", Boolean.TRUE);
        internalKeywords.put("JUSTIFIED", Boolean.TRUE);
        internalKeywords.put("KANJI", Boolean.TRUE);
        internalKeywords.put("KEEP", Boolean.TRUE);
        internalKeywords.put("KEY", Boolean.TRUE);
        internalKeywords.put("LABEL", Boolean.TRUE);
        internalKeywords.put("LAST", Boolean.TRUE);
        internalKeywords.put("LD", Boolean.TRUE);
        internalKeywords.put("LEADING", Boolean.TRUE);
        internalKeywords.put("LEFT", Boolean.TRUE);
        internalKeywords.put("LENGTH", Boolean.TRUE);
        internalKeywords.put("LESS", Boolean.TRUE);
        internalKeywords.put("LIMIT", Boolean.TRUE);
        internalKeywords.put("LIMITS", Boolean.TRUE);
        internalKeywords.put("LINAGE", Boolean.TRUE);
        internalKeywords.put("LINAGE-COUNTER", Boolean.TRUE);
        internalKeywords.put("LINE", Boolean.TRUE);
        internalKeywords.put("LINE-COUNTER", Boolean.TRUE);
        internalKeywords.put("LINES", Boolean.TRUE);
        internalKeywords.put("LINKAGE", Boolean.TRUE);
        internalKeywords.put("LOCALLY", Boolean.TRUE);
        internalKeywords.put("LOCAL-STORAGE", Boolean.TRUE);
        internalKeywords.put("LOCK", Boolean.TRUE);
        internalKeywords.put("LOW-VALUE", Boolean.TRUE);
        internalKeywords.put("LOW-VALUES", Boolean.TRUE);
        internalKeywords.put("MEMBER", Boolean.TRUE);
        internalKeywords.put("MEMORY", Boolean.TRUE);
        internalKeywords.put("MERGE", Boolean.TRUE);
        internalKeywords.put("MESSAGE", Boolean.TRUE);
        internalKeywords.put("METACLASS", Boolean.TRUE);
        internalKeywords.put("METHOD", Boolean.TRUE);
        internalKeywords.put("METHOD-ID", Boolean.TRUE);
        internalKeywords.put("MODE", Boolean.TRUE);
        internalKeywords.put("MODIFY", Boolean.TRUE);
        internalKeywords.put("MODULES", Boolean.TRUE);
        internalKeywords.put("MORE-LABELS", Boolean.TRUE);
        internalKeywords.put("MOVE", Boolean.TRUE);
        internalKeywords.put("MULTIPLE", Boolean.TRUE);
        internalKeywords.put("MULTIPLY", Boolean.TRUE);
        internalKeywords.put("NATIVE", Boolean.TRUE);
        internalKeywords.put("NATIONAL", Boolean.TRUE);
        internalKeywords.put("NATIONAL-EDITED", Boolean.TRUE);
        internalKeywords.put("NEGATIVE", Boolean.TRUE);
        internalKeywords.put("NEXT", Boolean.TRUE);
        internalKeywords.put("NO", Boolean.TRUE);
        internalKeywords.put("NORMAL", Boolean.TRUE);
        internalKeywords.put("NOT", Boolean.TRUE);
        internalKeywords.put("NULL", Boolean.TRUE);
        internalKeywords.put("NULLS", Boolean.TRUE);
        internalKeywords.put("NUMBER", Boolean.TRUE);
        internalKeywords.put("NUMERIC", Boolean.TRUE);
        internalKeywords.put("NUMERIC-EDITED", Boolean.TRUE);
        internalKeywords.put("OBJECT", Boolean.TRUE);
        internalKeywords.put("OBJECT-COMPUTER", Boolean.TRUE);
        internalKeywords.put("OCCURS", Boolean.TRUE);
        internalKeywords.put("OF", Boolean.TRUE);
        internalKeywords.put("OFF", Boolean.TRUE);
        internalKeywords.put("OMITTED", Boolean.TRUE);
        internalKeywords.put("ON", Boolean.TRUE);
        internalKeywords.put("ONLY", Boolean.TRUE);
        internalKeywords.put("OPEN", Boolean.TRUE);
        internalKeywords.put("OPTIONAL", Boolean.TRUE);
        internalKeywords.put("OR", Boolean.TRUE);
        internalKeywords.put("ORDER", Boolean.TRUE);
        internalKeywords.put("ORGANIZATION", Boolean.TRUE);
        internalKeywords.put("OTHER", Boolean.TRUE);
        internalKeywords.put("OUTPUT", Boolean.TRUE);
        internalKeywords.put("OVERFLOW", Boolean.TRUE);
        internalKeywords.put("OVERRIDE", Boolean.TRUE);
        internalKeywords.put("OWNER", Boolean.TRUE);
        internalKeywords.put("PACKED-DECIMAL", Boolean.TRUE);
        internalKeywords.put("PADDING", Boolean.TRUE);
        internalKeywords.put("PAGE", Boolean.TRUE);
        internalKeywords.put("PAGE-COUNTER", Boolean.TRUE);
        internalKeywords.put("PARAGRAPH", Boolean.TRUE);
        internalKeywords.put("PASSWORD", Boolean.TRUE);
        internalKeywords.put("PERFORM", Boolean.TRUE);
        internalKeywords.put("PF", Boolean.TRUE);
        internalKeywords.put("PH", Boolean.TRUE);
        internalKeywords.put("PIC", Boolean.TRUE);
        internalKeywords.put("PICTURE", Boolean.TRUE);
        internalKeywords.put("PLUS", Boolean.TRUE);
        internalKeywords.put("POINTER", Boolean.TRUE);
        internalKeywords.put("POSITION", Boolean.TRUE);
        internalKeywords.put("POSITIVE", Boolean.TRUE);
        internalKeywords.put("PRESENT", Boolean.TRUE);
        internalKeywords.put("PREVIOUS", Boolean.TRUE);
        internalKeywords.put("PRINTING", Boolean.TRUE);
        internalKeywords.put("PRIOR", Boolean.TRUE);
        internalKeywords.put("PROCEDURE", Boolean.TRUE);
        internalKeywords.put("PROCEDURE-POINTER", Boolean.TRUE);
        internalKeywords.put("PROCEDURES", Boolean.TRUE);
        internalKeywords.put("PROCEED", Boolean.TRUE);
        internalKeywords.put("PROCESSING", Boolean.TRUE);
        internalKeywords.put("PROGRAM", Boolean.TRUE);
        internalKeywords.put("PROGRAM-ID", Boolean.TRUE);
        internalKeywords.put("PROTECTED", Boolean.TRUE);
        internalKeywords.put("PURGE", Boolean.TRUE);
        internalKeywords.put("QUEUE", Boolean.TRUE);
        internalKeywords.put("QUOTE", Boolean.TRUE);
        internalKeywords.put("QUOTES", Boolean.TRUE);
        internalKeywords.put("RANDOM", Boolean.TRUE);
        internalKeywords.put("RD", Boolean.TRUE);
        internalKeywords.put("READ", Boolean.TRUE);
        internalKeywords.put("READY", Boolean.TRUE);
        internalKeywords.put("REALM", Boolean.TRUE);
        internalKeywords.put("RECEIVE", Boolean.TRUE);
        internalKeywords.put("RECONNECT", Boolean.TRUE);
        internalKeywords.put("RECORD", Boolean.TRUE);
        internalKeywords.put("RECORD-NAME", Boolean.TRUE);
        internalKeywords.put("RECORDING", Boolean.TRUE);
        internalKeywords.put("RECORDS", Boolean.TRUE);
        internalKeywords.put("RECURSIVE", Boolean.TRUE);
        internalKeywords.put("REDEFINES", Boolean.TRUE);
        internalKeywords.put("REEL", Boolean.TRUE);
        internalKeywords.put("REFERENCE", Boolean.TRUE);
        internalKeywords.put("REFERENCES", Boolean.TRUE);
        internalKeywords.put("RELATION", Boolean.TRUE);
        internalKeywords.put("RELATIVE", Boolean.TRUE);
        internalKeywords.put("RELEASE", Boolean.TRUE);
        internalKeywords.put("RELOAD", Boolean.TRUE);
        internalKeywords.put("REMAINDER", Boolean.TRUE);
        internalKeywords.put("REMOVAL", Boolean.TRUE);
        internalKeywords.put("RENAMES", Boolean.TRUE);
        internalKeywords.put("REPEATED", Boolean.TRUE);
        internalKeywords.put("REPLACE", Boolean.TRUE);
        internalKeywords.put("REPLACING", Boolean.TRUE);
        internalKeywords.put("REPORT", Boolean.TRUE);
        internalKeywords.put("REPORTING", Boolean.TRUE);
        internalKeywords.put("REPORTS", Boolean.TRUE);
        internalKeywords.put("REPOSITORY", Boolean.TRUE);
        internalKeywords.put("RERUN", Boolean.TRUE);
        internalKeywords.put("RESERVE", Boolean.TRUE);
        internalKeywords.put("RESET", Boolean.TRUE);
        internalKeywords.put("RETAINING", Boolean.TRUE);
        internalKeywords.put("RETRIEVAL", Boolean.TRUE);
        internalKeywords.put("RETURN", Boolean.TRUE);
        internalKeywords.put("RETURN-CODE", Boolean.TRUE);
        internalKeywords.put("RETURNING", Boolean.TRUE);
        internalKeywords.put("REVERSED", Boolean.TRUE);
        internalKeywords.put("REWIND", Boolean.TRUE);
        internalKeywords.put("REWRITE", Boolean.TRUE);
        internalKeywords.put("RF", Boolean.TRUE);
        internalKeywords.put("RH", Boolean.TRUE);
        internalKeywords.put("RIGHT", Boolean.TRUE);
        internalKeywords.put("ROLLBACK", Boolean.TRUE);
        internalKeywords.put("ROUNDED", Boolean.TRUE);
        internalKeywords.put("RUN", Boolean.TRUE);
        internalKeywords.put("SAME", Boolean.TRUE);
        internalKeywords.put("SD", Boolean.TRUE);
        internalKeywords.put("SEARCH", Boolean.TRUE);
        internalKeywords.put("SECTION", Boolean.TRUE);
        internalKeywords.put("SECURITY", Boolean.TRUE);
        internalKeywords.put("SEGMENT", Boolean.TRUE);
        internalKeywords.put("SEGMENT-LIMIT", Boolean.TRUE);
        internalKeywords.put("SELECT", Boolean.TRUE);
        internalKeywords.put("SELF", Boolean.TRUE);
        internalKeywords.put("SEND", Boolean.TRUE);
        internalKeywords.put("SENTENCE", Boolean.TRUE);
        internalKeywords.put("SEPARATE", Boolean.TRUE);
        internalKeywords.put("SEQUENCE", Boolean.TRUE);
        internalKeywords.put("SEQUENTIAL", Boolean.TRUE);
        internalKeywords.put("SERVICE", Boolean.TRUE);
        internalKeywords.put("SESSION-ID", Boolean.TRUE);
        internalKeywords.put("SET", Boolean.TRUE);
        internalKeywords.put("SHARED", Boolean.TRUE);
        internalKeywords.put("SHIFT-IN", Boolean.TRUE);
        internalKeywords.put("SHIFT-OUT", Boolean.TRUE);
        internalKeywords.put("SIGN", Boolean.TRUE);
        internalKeywords.put("SIZE", Boolean.TRUE);
        internalKeywords.put("SKIP1", Boolean.TRUE);
        internalKeywords.put("SKIP2", Boolean.TRUE);
        internalKeywords.put("SKIP3", Boolean.TRUE);
        internalKeywords.put("SORT", Boolean.TRUE);
        internalKeywords.put("SORT-CONTROL", Boolean.TRUE);
        internalKeywords.put("SORT-CORE-SIZE", Boolean.TRUE);
        internalKeywords.put("SORT-FILE-SIZE", Boolean.TRUE);
        internalKeywords.put("SORT-MERGE", Boolean.TRUE);
        internalKeywords.put("SORT-MESSAGE", Boolean.TRUE);
        internalKeywords.put("SORT-MODE-SIZE", Boolean.TRUE);
        internalKeywords.put("SORT-RETURN", Boolean.TRUE);
        internalKeywords.put("SOURCE", Boolean.TRUE);
        internalKeywords.put("SOURCE-COMPUTER", Boolean.TRUE);
        internalKeywords.put("SPACE", Boolean.TRUE);
        internalKeywords.put("SPACES", Boolean.TRUE);
        internalKeywords.put("SPECIAL-NAMES", Boolean.TRUE);
        internalKeywords.put("SQL", Boolean.TRUE);
        internalKeywords.put("STANDARD", Boolean.TRUE);
        internalKeywords.put("STANDARD-1", Boolean.TRUE);
        internalKeywords.put("STANDARD-2", Boolean.TRUE);
        internalKeywords.put("STANDARD-3", Boolean.TRUE);
        internalKeywords.put("STANDARD-4", Boolean.TRUE);
        internalKeywords.put("START", Boolean.TRUE);
        internalKeywords.put("STATUS", Boolean.TRUE);
        internalKeywords.put("STOP", Boolean.TRUE);
        internalKeywords.put("STORE", Boolean.TRUE);
        internalKeywords.put("STRING", Boolean.TRUE);
        internalKeywords.put("SUB-QUEUE-1", Boolean.TRUE);
        internalKeywords.put("SUB-QUEUE-2", Boolean.TRUE);
        internalKeywords.put("SUB-QUEUE-3", Boolean.TRUE);
        internalKeywords.put("SUB-SCHEMA", Boolean.TRUE);
        internalKeywords.put("SUBTRACT", Boolean.TRUE);
        internalKeywords.put("SUM", Boolean.TRUE);
        internalKeywords.put("SUPER", Boolean.TRUE);
        internalKeywords.put("SUPPRESS", Boolean.TRUE);
        internalKeywords.put("SYMBOLIC", Boolean.TRUE);
        internalKeywords.put("SYNC", Boolean.TRUE);
        internalKeywords.put("SYNCHRONIZED", Boolean.TRUE);
        internalKeywords.put("TABLE", Boolean.TRUE);
        internalKeywords.put("TALLY", Boolean.TRUE);
        internalKeywords.put("TALLYING", Boolean.TRUE);
        internalKeywords.put("TAPE", Boolean.TRUE);
        internalKeywords.put("TENANT", Boolean.TRUE);
        internalKeywords.put("TERMINAL", Boolean.TRUE);
        internalKeywords.put("TERMINATE", Boolean.TRUE);
        internalKeywords.put("TEST", Boolean.TRUE);
        internalKeywords.put("TEXT", Boolean.TRUE);
        internalKeywords.put("THAN", Boolean.TRUE);
        internalKeywords.put("THEN", Boolean.TRUE);
        internalKeywords.put("THROUGH", Boolean.TRUE);
        internalKeywords.put("THRU", Boolean.TRUE);
        internalKeywords.put("TIME", Boolean.TRUE);
        internalKeywords.put("TIMEOUT", Boolean.TRUE);
        internalKeywords.put("TIMES", Boolean.TRUE);
        internalKeywords.put("TITLE", Boolean.TRUE);
        internalKeywords.put("TO", Boolean.TRUE);
        internalKeywords.put("TOP", Boolean.TRUE);
        internalKeywords.put("TRACE", Boolean.TRUE);
        internalKeywords.put("TRAILING", Boolean.TRUE);
        internalKeywords.put("TRANSCEIVE", Boolean.TRUE);
        internalKeywords.put("TRUE", Boolean.TRUE);
        internalKeywords.put("TYPE", Boolean.TRUE);
        internalKeywords.put("UNEQUAL", Boolean.TRUE);
        internalKeywords.put("UNIT", Boolean.TRUE);
        internalKeywords.put("UNSTRING", Boolean.TRUE);
        internalKeywords.put("UNTIL", Boolean.TRUE);
        internalKeywords.put("UP", Boolean.TRUE);
        internalKeywords.put("UPDATE", Boolean.TRUE);
        internalKeywords.put("UPON", Boolean.TRUE);
        internalKeywords.put("USAGE", Boolean.TRUE);
        internalKeywords.put("USAGE-MODE", Boolean.TRUE);
        internalKeywords.put("USE", Boolean.TRUE);
        internalKeywords.put("USING", Boolean.TRUE);
        internalKeywords.put("VALID", Boolean.TRUE);
        internalKeywords.put("VALIDATE", Boolean.TRUE);
        internalKeywords.put("VALUE", Boolean.TRUE);
        internalKeywords.put("VALUES", Boolean.TRUE);
        internalKeywords.put("VARYING", Boolean.TRUE);
        internalKeywords.put("WAIT", Boolean.TRUE);
        internalKeywords.put("WHEN", Boolean.TRUE);
        internalKeywords.put("WHEN-COMPILED", Boolean.TRUE);
        internalKeywords.put("WITH", Boolean.TRUE);
        internalKeywords.put("WITHIN", Boolean.TRUE);
        internalKeywords.put("WORDS", Boolean.TRUE);
        internalKeywords.put("WORKING-STORAGE", Boolean.TRUE);
        internalKeywords.put("WRITE", Boolean.TRUE);
        internalKeywords.put("WRITE-ONLY", Boolean.TRUE);
        internalKeywords.put("XML", Boolean.TRUE);
        internalKeywords.put("XML-CODE", Boolean.TRUE);
        internalKeywords.put("XML-EVENT", Boolean.TRUE);
        internalKeywords.put("XML-NTEXT", Boolean.TRUE);
        internalKeywords.put("XML-TEXT", Boolean.TRUE);
        internalKeywords.put("ZERO", Boolean.TRUE);
        internalKeywords.put("ZEROES", Boolean.TRUE);
        internalKeywords.put("ZEROS", Boolean.TRUE);
    }
}

