/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.gen.api.IAssistantResponse;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class AssistantResponse
implements IAssistantResponse {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2005, 2010 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private List<String> status;
    private List<String> informational = new LinkedList<String>();
    private List<String> warning = new LinkedList<String>();
    private List<String> error = new LinkedList<String>();
    private int returnCode = 0;
    private Map<Object, String> REQMEMs = null;
    private Map<Object, String> RESPMEMs = null;
    private Map<Object, String> PDSMEMs = null;
    private List<String> operationNames = null;
    private List<QName> elementQNames = null;
    private List<QName> typeQNames = null;

    public AssistantResponse() {
        this.status = new LinkedList<String>();
    }

    public void setOperationNames(List<String> operationNames) {
        this.operationNames = operationNames;
    }

    public void setElementQNames(List<QName> elementQNames) {
        this.elementQNames = elementQNames;
    }

    public void setTypeQNames(List<QName> typeQNames) {
        this.typeQNames = typeQNames;
    }

    public void setREQMEMs(Map<Object, String> REQMEMs) {
        this.REQMEMs = REQMEMs;
    }

    public void setRESPMEMs(Map<Object, String> RESPMEMs) {
        this.RESPMEMs = RESPMEMs;
    }

    public void setPDSMEMs(Map<Object, String> PDSMEMs) {
        this.PDSMEMs = PDSMEMs;
    }

    public void addStatus(String message) {
        if (!this.status.contains(message)) {
            this.status.add(message);
        }
    }

    public void addInformation(String message) {
        if (!this.informational.contains(message)) {
            this.informational.add(message);
        }
    }

    public void addWarning(String message) {
        if (!this.warning.contains(message)) {
            this.warning.add(message);
        }
    }

    public void addError(String message) {
        if (!this.error.contains(message)) {
            this.error.add(message);
        }
    }

    public void setReturnCode(int rc) {
        this.returnCode = rc;
    }

    @Override
    public String[] getStatusMessages() {
        return this.createStringArray(this.status);
    }

    @Override
    public String[] getInformationalMessages() {
        return this.createStringArray(this.informational);
    }

    @Override
    public String[] getWarningMessages() {
        return this.createStringArray(this.warning);
    }

    @Override
    public String[] getErrorMessages() {
        return this.createStringArray(this.error);
    }

    @Override
    public String[] getAllMessages() {
        LinkedList<String> all = new LinkedList<String>();
        all.addAll(this.status);
        all.addAll(this.informational);
        all.addAll(this.warning);
        all.addAll(this.error);
        return this.createStringArray(all);
    }

    @Override
    public int getReturnCode() {
        return this.returnCode;
    }

    private String[] createStringArray(List<String> messages) {
        String[] result = new String[messages.size()];
        System.arraycopy(messages.toArray(), 0, result, 0, result.length);
        return result;
    }

    @Override
    public String getREQMEMForOperation(String operationName) {
        return this.REQMEMs.get(operationName);
    }

    @Override
    public String getRESPMEMForOperation(String operationName) {
        return this.RESPMEMs.get(operationName);
    }

    @Override
    public List<String> getOperationNames() {
        return this.operationNames;
    }

    @Override
    public List<QName> getElementQNames() {
        return this.elementQNames;
    }

    @Override
    public String getPDSMEMForElement(QName elementQName) {
        return this.PDSMEMs.get(elementQName);
    }

    @Override
    public List<QName> getTypeQNames() {
        return this.typeQNames;
    }

    @Override
    public String getPDSMEMForType(QName typeQName) {
        return this.PDSMEMs.get(typeQName);
    }
}

