/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.gen.api.IAssistantParameters;
import com.ibm.cics.gen.api.IAssistantResponse;
import com.ibm.cics.gen.api.IBottomUpHelper;
import com.ibm.cics.gen.api.ICICSJSONAssistant;
import com.ibm.cics.gen.api.ICICSWebServicesAssistant;
import com.ibm.cics.gen.api.ICICSXMLAssistant;
import com.ibm.cics.gen.api.IDFHLS2JSHelper;
import com.ibm.cics.gen.api.IDFHLS2SCHelper;
import com.ibm.cics.gen.api.IDFHLS2WSHelper;
import com.ibm.cics.gen.api.IPlatform;
import com.ibm.cics.gen.api.IWSBindFile;
import com.ibm.cics.schema.ICMInterceptor;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.AssistantResponse;
import com.ibm.cics.wsdl.common.GenericSetup;
import com.ibm.cics.wsdl.common.ICICSEPImportAssistant;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.ParmChecker;
import com.ibm.cics.wsdl.common.WSBindProcessor;
import com.ibm.cics.wsdl.ls2ws.ls2js;
import com.ibm.cics.wsdl.ls2ws.ls2sc;
import com.ibm.cics.wsdl.ls2ws.ls2ws;
import com.ibm.cics.wsdl.ws2ls.js2ls;
import com.ibm.cics.wsdl.ws2ls.sc2ls;
import com.ibm.cics.wsdl.ws2ls.ws2ls;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CICSAssistant
implements ICICSWebServicesAssistant,
ICICSXMLAssistant,
ICICSEPImportAssistant,
ICICSJSONAssistant {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2005, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private boolean nonZOSPlatform = false;
    ICMInterceptor interceptor = null;
    IPlatform targetPlatform = null;

    @Override
    public synchronized IAssistantResponse DFHLS2WS(IAssistantParameters ap) {
        return this.callWSAssistant(ap, 1, null);
    }

    @Override
    public synchronized IAssistantResponse DFHWS2LS(IAssistantParameters ap) {
        return this.callWSAssistant(ap, 0, null);
    }

    private synchronized IAssistantResponse callWSAssistant(IAssistantParameters ap, int tool, IBottomUpHelper agent) {
        String localPlatform = System.getProperty("os.name").toUpperCase(Locale.ENGLISH);
        if (localPlatform.indexOf("WINDOWS") > -1) {
            this.nonZOSPlatform = true;
        } else if (localPlatform.indexOf("Z/OS") > -1 || localPlatform.indexOf("ZOS") > -1) {
            this.nonZOSPlatform = false;
            if (ap.getParamPDSLIB() != null && ap.getParamPDSLIB().startsWith("/") && !ap.getParamPDSLIB().startsWith("//")) {
                this.nonZOSPlatform = true;
            }
        } else {
            this.nonZOSPlatform = true;
        }
        Properties props = new Properties();
        if (ap.getParamCONTID() != null) {
            props.setProperty("CONTID", ap.getParamCONTID());
        }
        if (ap.getParamHTTPPROXY() != null) {
            props.setProperty("HTTPPROXY", ap.getParamHTTPPROXY());
        }
        if (ap.getParamHTTPPROXY_USERNAME() != null) {
            props.setProperty("HTTPPROXY-USERNAME", ap.getParamHTTPPROXY_USERNAME());
        }
        if (ap.getParamHTTPPROXY_PASSWORD() != null) {
            props.setProperty("HTTPPROXY-PASSWORD", ap.getParamHTTPPROXY_PASSWORD());
        }
        if (ap.getParamLANG() != null) {
            props.setProperty("LANG", ap.getParamLANG());
        }
        if (ap.getParamPDSLIB() != null) {
            props.setProperty("PDSLIB", ap.getParamPDSLIB());
        }
        if (ap.getParamPGMINT() != null) {
            props.setProperty("PGMINT", ap.getParamPGMINT());
        }
        if (ap.getParamPGMNAME() != null) {
            props.setProperty("PGMNAME", ap.getParamPGMNAME());
        }
        if (ap.getParamREQMEM() != null) {
            props.setProperty("REQMEM", ap.getParamREQMEM());
        }
        if (ap.getParamRESPMEM() != null) {
            props.setProperty("RESPMEM", ap.getParamRESPMEM());
        }
        if (ap.getParamSERVICE() != null) {
            props.setProperty("SERVICE", ap.getParamSERVICE());
        }
        if (ap.getParamSTRUCTURE() != null) {
            props.setProperty("STRUCTURE", ap.getParamSTRUCTURE());
        }
        if (ap.getParamURI() != null) {
            props.setProperty("URI", ap.getParamURI());
        }
        if (ap.getParamWSBIND() != null) {
            props.setProperty("WSBIND", ap.getParamWSBIND());
        }
        if (ap.getParamWSDL() != null) {
            props.setProperty("WSDL", ap.getParamWSDL());
        }
        if (ap.getParamWSDLCP() != null) {
            props.setProperty("WSDLCP", ap.getParamWSDLCP());
        }
        if (ap.getParamSYNCONRETURN() != null) {
            props.setProperty("SYNCONRETURN", ap.getParamSYNCONRETURN());
        }
        if (ap.getParamOVERWRITE_OUTPUT() != null) {
            props.setProperty("OVERWRITE-OUTPUT", ap.getParamOVERWRITE_OUTPUT());
        }
        if (ap.getParamWIDE_COMP3() != null) {
            props.setProperty("WIDE-COMP3", ap.getParamWIDE_COMP3());
        }
        if (ap.getParamDEFAULT_FRACTION_DIGITS() != null) {
            props.setProperty("DEFAULT-FRACTION-DIGITS", ap.getParamDEFAULT_FRACTION_DIGITS());
        }
        if (ap.getParamLOGFILE() != null) {
            props.setProperty("LOGFILE", ap.getParamLOGFILE());
        }
        if (ap.getParamBINDING() != null) {
            props.setProperty("BINDING", ap.getParamBINDING());
        }
        if (ap.getParamPDSCP() != null) {
            props.setProperty("PDSCP", ap.getParamPDSCP());
        }
        if (ap.getParamMAPPING_LEVEL() != null) {
            props.setProperty("MAPPING-LEVEL", ap.getParamMAPPING_LEVEL());
        }
        if (ap.getParamMAPPING_OVERRIDES() != null) {
            props.setProperty("MAPPING-OVERRIDES", ap.getParamMAPPING_OVERRIDES());
        }
        if (ap.getParamMINIMUM_RUNTIME_LEVEL() != null) {
            props.setProperty("MINIMUM-RUNTIME-LEVEL", ap.getParamMINIMUM_RUNTIME_LEVEL());
        }
        if (ap.getParamCCSID() != null) {
            props.setProperty("CCSID", ap.getParamCCSID());
        }
        if (ap.getParamCHAR_VARYING() != null) {
            props.setProperty("CHAR-VARYING", ap.getParamCHAR_VARYING());
        }
        if (ap.getParamCHAR_WHITESPACE() != null) {
            props.setProperty("CHAR-WHITESPACE", ap.getParamCHAR_WHITESPACE());
        }
        if (ap.getParamCHAR_VARYING_LIMIT() != null) {
            props.setProperty("CHAR-VARYING-LIMIT", ap.getParamCHAR_VARYING_LIMIT());
        }
        if (ap.getParamINLINE_MAXOCCURS_LIMIT() != null) {
            props.setProperty("INLINE-MAXOCCURS-LIMIT", ap.getParamINLINE_MAXOCCURS_LIMIT());
        }
        if (ap.getParamDEFAULT_CHAR_MAXLENGTH() != null) {
            props.setProperty("DEFAULT-CHAR-MAXLENGTH", ap.getParamDEFAULT_CHAR_MAXLENGTH());
        }
        if (ap.getParamDEFAULT_ARRAY_MAXITEMS() != null) {
            props.setProperty("DEFAULT-ARRAY-MAXITEMS", ap.getParamDEFAULT_ARRAY_MAXITEMS());
        }
        if (ap.getParamCHAR_MULTIPLIER() != null) {
            props.setProperty("CHAR-MULTIPLIER", ap.getParamCHAR_MULTIPLIER());
        }
        if (ap.getParamCHAR_OCCURS() != null) {
            props.setProperty("CHAR-OCCURS", ap.getParamCHAR_OCCURS());
        }
        if (ap.getParamCHAR_USAGE() != null) {
            props.setProperty("CHAR-USAGE", ap.getParamCHAR_USAGE());
        }
        if (ap.getParamTRANSACTION() != null) {
            props.setProperty("TRANSACTION", ap.getParamTRANSACTION());
        }
        if (ap.getParamUSERID() != null) {
            props.setProperty("USERID", ap.getParamUSERID());
        }
        if (ap.getVendorConverterName() != null) {
            props.setProperty("VENDOR-CONVERTER-NAME", ap.getVendorConverterName());
        }
        if (ap.getVendorConverterApplicationInterfaceLength() != 0) {
            props.setProperty("VENDOR-APP-INTERFACE-LENGTH", Integer.toString(ap.getVendorConverterApplicationInterfaceLength()));
        }
        if (ap.getParamOPERATIONS() != null) {
            props.setProperty("OPERATIONS", ap.getParamOPERATIONS());
        }
        if (ap.getParamOPERATION_NAME() != null) {
            props.setProperty("OPERATION-NAME", ap.getParamOPERATION_NAME());
        }
        if (ap.getParamWSDL_1_1() != null) {
            props.setProperty("WSDL_1.1", ap.getParamWSDL_1_1());
        }
        if (ap.getParamWSDL_2_0() != null) {
            props.setProperty("WSDL_2.0", ap.getParamWSDL_2_0());
        }
        if (ap.getParamSOAPVER() != null) {
            props.setProperty("SOAPVER", ap.getParamSOAPVER());
        }
        if (ap.getParamWSDL_SERVICE() != null) {
            props.setProperty("WSDL-SERVICE", ap.getParamWSDL_SERVICE());
        }
        if (ap.getParamWSDL_NAMESPACE() != null) {
            props.setProperty("WSDL-NAMESPACE", ap.getParamWSDL_NAMESPACE());
        }
        if (ap.getParamREQUEST_NAMESPACE() != null) {
            props.setProperty("REQUEST-NAMESPACE", ap.getParamREQUEST_NAMESPACE());
        }
        if (ap.getParamRESPONSE_NAMESPACE() != null) {
            props.setProperty("RESPONSE-NAMESPACE", ap.getParamRESPONSE_NAMESPACE());
        }
        if (ap.getParamXML_ONLY() != null) {
            props.setProperty("XML-ONLY", ap.getParamXML_ONLY());
        }
        if (ap.getParamNAMESPACE() != null) {
            props.setProperty("NAMESPACE", ap.getParamNAMESPACE());
        }
        if (ap.getParamXSDBIND() != null) {
            props.setProperty("XSDBIND", ap.getParamXSDBIND());
        }
        if (ap.getParamSCHEMA() != null) {
            props.setProperty("SCHEMA", ap.getParamSCHEMA());
        }
        if (ap.getParamXMLCP() != null) {
            props.setProperty("XMLCP", ap.getParamXMLCP());
        }
        if (ap.getParamELEMENTS() != null) {
            props.setProperty("ELEMENTS", ap.getParamELEMENTS());
        }
        if (ap.getParamTYPES() != null) {
            props.setProperty("TYPES", ap.getParamTYPES());
        }
        if (ap.getParamPDSMEM() != null) {
            props.setProperty("PDSMEM", ap.getParamPDSMEM());
        }
        if (ap.getParamREQUEST_CHANNEL() != null) {
            props.setProperty("REQUEST-CHANNEL", ap.getParamREQUEST_CHANNEL());
        }
        if (ap.getParamRESPONSE_CHANNEL() != null) {
            props.setProperty("RESPONSE-CHANNEL", ap.getParamRESPONSE_CHANNEL());
        }
        if (ap.getParamWSADDR_EPR_ANY() != null) {
            props.setProperty("WSADDR-EPR-ANY", ap.getParamWSADDR_EPR_ANY());
        }
        if (ap.getParamBUNDLE() != null) {
            props.setProperty("BUNDLE", ap.getParamBUNDLE());
        }
        if (ap.getParamSSL_KEYSTORE() != null) {
            props.setProperty("SSL-KEYSTORE", ap.getParamSSL_KEYSTORE());
        }
        if (ap.getParamSSL_KEYPWD() != null) {
            props.setProperty("SSL-KEYPWD", ap.getParamSSL_KEYPWD());
        }
        if (ap.getParamSSL_TRUSTSTORE() != null) {
            props.setProperty("SSL-TRUSTSTORE", ap.getParamSSL_TRUSTSTORE());
        }
        if (ap.getParamSSL_TRUSTPWD() != null) {
            props.setProperty("SSL-TRUSTPWD", ap.getParamSSL_TRUSTPWD());
        }
        if (ap.getParamWSRR_DESCRIPTION() != null) {
            props.setProperty("WSRR-DESCRIPTION", ap.getParamWSRR_DESCRIPTION());
        }
        if (ap.getParamWSRR_ENCODING() != null) {
            props.setProperty("WSRR-ENCODING", ap.getParamWSRR_ENCODING());
        }
        if (ap.getParamWSRR_LOCATION() != null) {
            props.setProperty("WSRR-LOCATION", ap.getParamWSRR_LOCATION());
        }
        if (ap.getParamWSRR_NAME() != null) {
            props.setProperty("WSRR-NAME", ap.getParamWSRR_NAME());
        }
        if (ap.getParamWSRR_NAMESPACE() != null) {
            props.setProperty("WSRR-NAMESPACE", ap.getParamWSRR_NAMESPACE());
        }
        if (ap.getParamWSRR_PASSWORD() != null) {
            props.setProperty("WSRR-PASSWORD", ap.getParamWSRR_PASSWORD());
        }
        if (ap.getParamWSRR_SERVER() != null) {
            props.setProperty("WSRR-SERVER", ap.getParamWSRR_SERVER());
        }
        if (ap.getParamWSRR_USERNAME() != null) {
            props.setProperty("WSRR-USERNAME", ap.getParamWSRR_USERNAME());
        }
        if (ap.getParamWSRR_VERSION() != null) {
            props.setProperty("WSRR-VERSION", ap.getParamWSRR_VERSION());
        }
        if (ap.getParamWSRR_CUSTOM() != null) {
            Map<String, String> wsrrCustom = ap.getParamWSRR_CUSTOM();
            Set<Map.Entry<String, String>> entries = wsrrCustom.entrySet();
            for (Map.Entry<String, String> customEntry : entries) {
                props.setProperty(customEntry.getKey(), customEntry.getValue());
            }
        }
        if (ap.getParamDATETIME() != null) {
            props.setProperty("DATETIME", ap.getParamDATETIME());
        }
        if (ap.getParamDATA_TRUNCATION() != null) {
            props.setProperty("DATA-TRUNCATION", ap.getParamDATA_TRUNCATION());
        }
        if (ap.getParamDATA_SCREENING() != null) {
            props.setProperty("DATA-SCREENING", ap.getParamDATA_SCREENING());
        }
        if (ap.getParamTRUNCATE_NULL_ARRAYS() != null) {
            props.setProperty("TRUNCATE-NULL-ARRAYS", ap.getParamTRUNCATE_NULL_ARRAYS());
        }
        if (ap.getParamTRUNCATE_NULL_ARRAY_VALUES() != null) {
            props.setProperty("TRUNCATE-NULL-ARRAY-VALUES", ap.getParamTRUNCATE_NULL_ARRAY_VALUES());
        }
        if (ap.getParamNAME_TRUNCATION() != null) {
            props.setProperty("NAME-TRUNCATION", ap.getParamNAME_TRUNCATION());
        }
        if (ap.getParamJSON_SCHEMA() != null) {
            props.setProperty("JSON-SCHEMA", ap.getParamJSON_SCHEMA());
        }
        if (ap.getParamJSON_SCHEMA_CODEPAGE() != null) {
            props.setProperty("JSON-SCHEMA-CODEPAGE", ap.getParamJSON_SCHEMA_CODEPAGE());
        }
        if (ap.getParamJSON_SCHEMA_REQUEST() != null) {
            props.setProperty("JSON-SCHEMA-REQUEST", ap.getParamJSON_SCHEMA_REQUEST());
        }
        if (ap.getParamJSON_SCHEMA_RESPONSE() != null) {
            props.setProperty("JSON-SCHEMA-RESPONSE", ap.getParamJSON_SCHEMA_RESPONSE());
        }
        if (ap.getParamJSON_SCHEMA_RESTFUL() != null) {
            props.setProperty("JSON-SCHEMA-RESTFUL", ap.getParamJSON_SCHEMA_RESTFUL());
        }
        if (ap.getParamJSONTRANSFRM() != null) {
            props.setProperty("JSONTRANSFRM", ap.getParamJSONTRANSFRM());
        }
        if (ap.getParamHTTP_METHODS() != null) {
            props.setProperty("HTTP-METHODS", ap.getParamHTTP_METHODS());
        }
        if (ap.getAllowNonEBCDICEncodings()) {
            props.setProperty("ALLOW-NON-EBCDIC", "true");
        }
        if (ap.getParamBINDING_NAME() != null) {
            props.setProperty("BINDING-NAME", ap.getParamBINDING_NAME());
        }
        if (ap.getParamPORT_NAME() != null) {
            props.setProperty("PORT-NAME", ap.getParamPORT_NAME());
        }
        if (ap.getParamSERVICE_NAME() != null) {
            props.setProperty("SERVICE-NAME", ap.getParamSERVICE_NAME());
        }
        if (ap.getDisableUseOfContainers()) {
            props.setProperty("DISABLE-CONTAINERS", "true");
        }
        if (ap.getParamADDITIONAL_PROPERTIES_DEFAULT() != null) {
            props.setProperty("ADDITIONAL-PROPERTIES-DEFAULT", ap.getParamADDITIONAL_PROPERTIES_DEFAULT());
        }
        if (ap.getParamADDITIONAL_PROPERTIES_MAX() != null) {
            props.setProperty("ADDITIONAL-PROPERTIES-MAX", ap.getParamADDITIONAL_PROPERTIES_MAX());
        }
        if (ap.getParamADDITIONAL_PROPERTIES_SIZE() != null) {
            props.setProperty("ADDITIONAL-PROPERTIES-SIZE", ap.getParamADDITIONAL_PROPERTIES_SIZE());
        }
        if (ap.getParamZOS_CONNECT_EE() != null) {
            props.setProperty("ZOS-CONNECT-EE", ap.getParamZOS_CONNECT_EE());
        }
        if (ap.getParamLANGUAGE_COUNTRY() != null) {
            props.setProperty("LANGUAGE-COUNTRY", ap.getParamLANGUAGE_COUNTRY());
        }
        if (ap.getParamCONTAINER_NAME_SUFFIX() != null) {
            props.setProperty("CONTAINER-NAME-SUFFIX", ap.getParamCONTAINER_NAME_SUFFIX());
        }
        AssistantResponse ar = new AssistantResponse();
        Logging.reset();
        GenericSetup assistant = null;
        switch (tool) {
            case 0: {
                assistant = new ws2ls();
                break;
            }
            case 1: {
                assistant = new ls2ws();
                ((ls2ws)assistant).setAgent((IDFHLS2WSHelper)agent);
                break;
            }
            case 3: {
                assistant = new ls2sc();
                ((ls2sc)assistant).setAgent((IDFHLS2SCHelper)agent);
                break;
            }
            case 2: {
                assistant = new sc2ls();
                break;
            }
            case 4: {
                assistant = new ls2js();
                ((ls2js)assistant).setAgent((IDFHLS2JSHelper)agent);
                break;
            }
            case 5: {
                assistant = new js2ls();
                break;
            }
            default: {
                throw new RuntimeException("INTERNAL ERROR: Unsupported tool variety - " + tool);
            }
        }
        assistant.setApiResp(ar);
        assistant.setProperties(props);
        assistant.setMetaData(ap.getVendorMetaData());
        assistant.setInterceptor(this.interceptor);
        assistant.setPlatform(this.targetPlatform);
        if (this.nonZOSPlatform) {
            assistant.run(new String[]{"NOOP", "RUNONWINDOWS"});
        } else {
            assistant.run(new String[]{"NOOP"});
        }
        return assistant.getApiResp();
    }

    @Override
    public String getVersionInformation() {
        String level = ParmChecker.BUILD_LEVEL_RELEASE;
        if (level.startsWith("@")) {
            level = "Unknown";
        }
        return level;
    }

    @Override
    public IWSBindFile readWSBindFile(InputStream is) throws IOException {
        try {
            return new WSBindProcessor(is, false);
        }
        catch (CICSWSDLException e) {
            IOException ioe = new IOException(e.getLocalizedMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public IAssistantResponse DFHLS2WS(IAssistantParameters ap, IDFHLS2WSHelper agent) {
        return this.callWSAssistant(ap, 1, agent);
    }

    @Override
    public IAssistantResponse DFHLS2SC(IAssistantParameters ap) {
        return this.callWSAssistant(ap, 3, null);
    }

    @Override
    public IAssistantResponse DFHLS2SC(IAssistantParameters ap, IDFHLS2SCHelper agent) {
        return this.callWSAssistant(ap, 3, agent);
    }

    @Override
    public IAssistantResponse DFHSC2LS(IAssistantParameters ap) {
        return this.callWSAssistant(ap, 2, null);
    }

    @Override
    public synchronized void setICMInterceptor(ICMInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Override
    public IAssistantResponse DFHLS2JS(IAssistantParameters ap) {
        return this.callWSAssistant(ap, 4, null);
    }

    @Override
    public IAssistantResponse DFHLS2JS(IAssistantParameters ap, IDFHLS2JSHelper agent) {
        return this.callWSAssistant(ap, 4, agent);
    }

    @Override
    public IAssistantResponse DFHJS2LS(IAssistantParameters ap) {
        return this.callWSAssistant(ap, 5, null);
    }

    @Override
    public synchronized void setTargetDeploymentPlatform(IPlatform platform) {
        this.targetPlatform = platform;
    }
}

