/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.schema.util.ByteArray;
import java.io.Serializable;
import java.util.Comparator;

public class EBCDICComparator
implements Comparator<String>,
Serializable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final long serialVersionUID = 42L;

    @Override
    public int compare(String o1, String o2) {
        String a = o1;
        String b = o2;
        if (a.equals(b)) {
            return 0;
        }
        try {
            byte[] a_bytes = ByteArray.toEBCDICByteArray(a, -1);
            byte[] b_bytes = ByteArray.toEBCDICByteArray(b, -1);
            for (int pos = 0; pos < a_bytes.length; ++pos) {
                int valB;
                if (pos >= b_bytes.length) {
                    return 1;
                }
                int valA = a_bytes[pos];
                if (valA < 0) {
                    valA += 256;
                }
                if ((valB = b_bytes[pos]) < 0) {
                    valB += 256;
                }
                if (valA > valB) {
                    return 1;
                }
                if (valA >= valB) continue;
                return -1;
            }
            return -1;
        }
        catch (Exception e) {
            this.throwException(e, o1, o2);
            return 0;
        }
    }

    private void throwException(Exception e, Object o1, Object o2) {
        throw new RuntimeException("INTERNAL ERROR: Compare of '" + o1 + "' and '" + o2 + "' failed in byte conversion.");
    }
}

