/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.wsdl.common.Logging;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class ErrorReportingFileOutputStream
extends FileOutputStream {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2007, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private String filename = null;
    private boolean exceptionThrown = false;

    public ErrorReportingFileOutputStream(String filename) throws FileNotFoundException {
        super(filename);
        this.filename = filename;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException ioe) {
            this.logError(ioe);
            throw ioe;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            super.flush();
        }
        catch (IOException ioe) {
            this.logError(ioe);
            throw ioe;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            super.write(b, off, len);
        }
        catch (IOException ioe) {
            this.logError(ioe);
            throw ioe;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            super.write(b);
        }
        catch (IOException ioe) {
            this.logError(ioe);
            throw ioe;
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            super.write(b);
        }
        catch (IOException ioe) {
            this.logError(ioe);
            throw ioe;
        }
    }

    private void logError(Exception e) {
        if (!this.exceptionThrown) {
            this.exceptionThrown = true;
            Logging.writeMessage(12, "DFHPI9556E", new Object[]{this.filename, e.getLocalizedMessage()});
            Logging.handleExc(e);
        }
    }
}

