/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.gen.api.IBottomUpHelper;
import com.ibm.cics.gen.api.IMappingData;
import com.ibm.cics.gen.api.IPlatform;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMInterceptor;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.WSDLInvalidParamsException;
import com.ibm.cics.wsdl.c.LangStruct_C;
import com.ibm.cics.wsdl.cobol.LangStruct_Cobol;
import com.ibm.cics.wsdl.common.AssistantResponse;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.ParmChecker;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.common.WrappingOutputStream;
import com.ibm.cics.wsdl.ls2ws.LangStruct;
import com.ibm.cics.wsdl.ls2ws.ls2js;
import com.ibm.cics.wsdl.ls2ws.ls2scProxyForJSON;
import com.ibm.cics.wsdl.pl1.LangStruct_PL1;
import com.ibm.cics.wsdl.ws2ls.sc2lsProxyForJSON;
import com.ibm.cics.wsrr.client.ServiceRegistryClient;
import com.ibm.cics.wsrr.client.ServiceRegistryClientImpl;
import java.io.PrintStream;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class GenericSetup
implements IBottomUpHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    protected AssistantResponse apiResp = null;
    protected Properties p;
    protected int mappingLevel = 0;
    protected byte wsBindVer = (byte)3;
    protected int inlineMaxOccursLimit = 0;
    protected int charVaryingLimit = Short.MAX_VALUE;
    protected ICM.VaryingLength charVarying = ICM.VaryingLength.NO_VARYING_STRATEGY;
    protected int defaultCharMaxlength = 255;
    protected int defaultArrayMaxItems = -1;
    protected int charMultiplier = 1;
    protected boolean useHexFloat = true;
    protected boolean vendorBindFileNeeded = false;
    protected int lang = -1;
    protected boolean useAbstimeDates = false;
    protected boolean dataTruncationSupported = false;
    protected boolean allowsContainers = true;
    protected int defaultFractionDigits = 3;
    protected boolean syncOnReturn = false;
    protected byte[] vendorMetaData = null;
    protected ParmChecker checker = null;
    protected Date timestamp = new Date();
    protected List<String> operationNames = null;
    private boolean apiUsed = false;
    protected ServiceRegistryClient registryClient = null;
    protected ICMInterceptor interceptor = null;
    protected IPlatform platform = null;

    protected GenericSetup() {
    }

    public void setInterceptor(ICMInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setPlatform(IPlatform platform) {
        this.platform = platform;
    }

    protected abstract void run(String[] var1);

    protected abstract void doAssistantSpecificProcessing() throws CICSWSDLException;

    protected void commonExecute(String[] args, int tool, Date timestamp) {
        int rc = 0;
        try {
            System.setProperty("jettison.json.jsontokener.use_bigdecimal", "true");
            boolean delegated = this.setUp(rc, args, tool, timestamp);
            if (!delegated) {
                this.doAssistantSpecificProcessing();
            }
            if (Logging.getError()) {
                rc = 12;
            }
        }
        catch (WSDLInvalidParamsException e) {
            Logging.setErrorTrue();
            rc = 8;
        }
        catch (Exception e) {
            rc = 12;
            Logging.handleExc(e);
        }
        if (Logging.getWarning() && !Logging.getError()) {
            rc = 4;
        }
        if (Logging.getError() && rc == 0) {
            rc = 12;
        }
        if (tool == 0 || tool == 2) {
            String filename = this.getFileName();
            if (Logging.getError()) {
                if (Logging.getWarning()) {
                    Logging.writeMessage(12, "DFHPI9557E", new Object[]{filename});
                } else {
                    Logging.writeMessage(12, "DFHPI9558E", new Object[]{filename});
                }
            } else if (Logging.getWarning()) {
                Logging.writeMessage(4, "DFHPI9608W", new Object[]{filename});
                rc = 4;
            }
        }
        if (rc == 0) {
            Logging.writeMessage(1, "DFHPI9587I", new Object[]{ParmChecker.TOOL_NAMES[tool]});
        }
        if (Logging.getPrintStream() != null) {
            Logging.getPrintStream().close();
        }
        if (this.apiResp == null) {
            System.exit(rc);
        } else {
            this.apiResp.setReturnCode(rc);
        }
    }

    public abstract String getFileName();

    public boolean setUp(int rc, String[] args, int direction, Date timestamp) throws CICSWSDLException {
        String wsrrEndpoint;
        if (!this.apiUsed && this.isZOS()) {
            System.setOut(new PrintStream(new WrappingOutputStream(System.out)));
            System.setErr(new PrintStream(new WrappingOutputStream(System.err)));
        }
        if (args.length != 1 && !this.apiUsed) {
            System.out.println("Usage is: java parameterFile");
            throw new WSDLInvalidParamsException("Usage is: java parameterFile");
        }
        if (this.p == null) {
            String paramsFile = args[0];
            this.checker = new ParmChecker(paramsFile, direction, this.vendorMetaData, this.platform);
        } else {
            this.checker = new ParmChecker(this.p, direction, this.vendorMetaData, this.platform);
        }
        this.p = this.checker.getProperties();
        this.p = this.checker.checkAssistantParms(timestamp);
        GenericSetup.setProxy(this.p.getProperty("HTTPPROXY"));
        this.mappingLevel = this.checker.getMappingLevel();
        this.wsBindVer = this.checker.getWSBindVerNumber();
        this.charVaryingLimit = this.checker.getCharVaryingLimit();
        this.inlineMaxOccursLimit = this.checker.getInlineMaxOccursLimit();
        this.charVarying = this.checker.getCharVarying();
        this.defaultCharMaxlength = this.checker.getDefaultCharMaxLength();
        this.defaultArrayMaxItems = this.checker.getDefaultArrayMaxItems();
        this.charMultiplier = this.checker.getCharMultiplier();
        this.useHexFloat = this.checker.isHexFloat();
        this.vendorBindFileNeeded = this.checker.isVendorBindFile();
        this.operationNames = this.checker.getOperationNames();
        this.syncOnReturn = this.checker.isSyncOnReturn();
        this.defaultFractionDigits = this.checker.getDefaultFractionDigits();
        this.lang = Util.getLanguage(this.p.getProperty("LANG"));
        if (this.checker.getICMInterceptor() != null) {
            this.interceptor = this.checker.getICMInterceptor();
        }
        this.useAbstimeDates = false;
        if ("PACKED15".equals(this.p.getProperty("DATETIME"))) {
            this.useAbstimeDates = true;
        }
        this.dataTruncationSupported = false;
        if ("ENABLED".equals(this.p.getProperty("DATA-TRUNCATION"))) {
            this.dataTruncationSupported = true;
        }
        this.allowsContainers = true;
        if ("COMMAREA".equals(this.p.getProperty("PGMINT"))) {
            this.allowsContainers = false;
        }
        if ((wsrrEndpoint = this.p.getProperty("WSRR-SERVER")) != null) {
            this.registryClient = new ServiceRegistryClientImpl();
            this.registryClient.setServiceRegistryServer(wsrrEndpoint);
        }
        return false;
    }

    protected boolean handleJSONAPIDelegation(String[] args) {
        if (!Logging.getError() && this.p.getProperty("BUNDLE") != null) {
            GenericSetup proxy;
            this.p.remove("SOAPVER");
            if (this instanceof ls2js) {
                this.p.remove("CHAR-MULTIPLIER");
                this.p.remove("CHAR-VARYING-LIMIT");
                this.p.remove("INLINE-MAXOCCURS-LIMIT");
                this.p.remove("DEFAULT-CHAR-MAXLENGTH");
                this.p.remove("NAME-TRUNCATION");
                this.p.remove("MAPPING-OVERRIDES");
                this.p.remove("WIDE-COMP3");
                this.p.remove("SAME-AS-MAPPING-LEVEL");
                this.p.remove("DEFAULT-ARRAY-MAXITEMS");
                this.p.remove("ZOS-CONNECT-EE");
                if (MappingLevelHelper.supportsMappingLevel_4_2(this.mappingLevel)) {
                    this.p.remove("ADDITIONAL-PROPERTIES-DEFAULT");
                    this.p.remove("ADDITIONAL-PROPERTIES-MAX");
                    this.p.remove("ADDITIONAL-PROPERTIES-SIZE");
                }
                proxy = new ls2scProxyForJSON();
            } else {
                this.p.remove("TRUNCATE-NULL-ARRAYS");
                this.p.remove("TRUNCATE-NULL-ARRAY-VALUES");
                this.p.remove("DEFAULT-ARRAY-MAXITEMS");
                if (!MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                    this.p.remove("ZOS-CONNECT-EE");
                }
                proxy = new sc2lsProxyForJSON();
            }
            proxy.setApiResp(this.getApiResp());
            proxy.setProperties(this.p);
            ((GenericSetup)proxy).run(args);
            return true;
        }
        return false;
    }

    private static void setProxy(String s) throws WSDLInvalidParamsException {
        if (s != null) {
            StringTokenizer t = new StringTokenizer(s, ":");
            if (t.countTokens() == 2) {
                String host = t.nextToken();
                String port = t.nextToken();
                Properties systemProps = System.getProperties();
                systemProps.setProperty("http.proxyHost", host);
                systemProps.setProperty("http.proxyPort", port);
                systemProps.setProperty("http.nonProxyHosts", "localhost");
                System.setProperties(systemProps);
            } else {
                throw new WSDLInvalidParamsException(MessageHandler.getMessage("DFHPI9501E"));
            }
        }
    }

    public AssistantResponse getApiResp() {
        return this.apiResp;
    }

    public void setApiResp(AssistantResponse apiResp) {
        if (apiResp != null) {
            this.apiResp = apiResp;
            Logging.setMessagesProxy(apiResp);
        }
    }

    public void setProperties(Properties props) {
        this.p = props;
        this.apiUsed = true;
    }

    public void setMetaData(byte[] vendorMetaData) {
        if (vendorMetaData == null) {
            this.vendorMetaData = null;
            return;
        }
        this.vendorMetaData = new byte[vendorMetaData.length];
        System.arraycopy(vendorMetaData, 0, this.vendorMetaData, 0, vendorMetaData.length);
    }

    public boolean isZOS() {
        String osArch = System.getProperty("os.arch");
        return osArch.indexOf("390") >= 0;
    }

    public boolean usePDSFiles() {
        return this.checker.usePDSFiles();
    }

    protected LangStruct getLangStruct(int lang) {
        LangStruct ls = null;
        switch (lang) {
            case 1: {
                ls = new LangStruct_Cobol(this.useAbstimeDates);
                break;
            }
            case 2: {
                ls = new LangStruct_PL1(false, this.useAbstimeDates);
                break;
            }
            case 6: {
                ls = new LangStruct_PL1(true, this.useAbstimeDates);
                break;
            }
            case 3: 
            case 4: {
                ls = new LangStruct_C(this.useAbstimeDates);
                break;
            }
            default: {
                throw new RuntimeException("INTERNAL ERROR: unknown language code - " + lang);
            }
        }
        return ls;
    }

    @Override
    public void processField(IMappingData fieldInfo) {
        if (fieldInfo.isFiller()) {
            fieldInfo.setSuppressed(true);
        }
    }

    public String getFileNameStub(String memberName, boolean trailingDot) {
        String stub = "";
        if (memberName != null) {
            int firstDot = memberName.indexOf(".");
            stub = firstDot > -1 ? memberName.substring(0, firstDot) : memberName;
            if (trailingDot) {
                stub = stub + ".";
            }
        }
        return stub;
    }

    protected boolean isUTF8RequiredForXML(String inputParmToCheck) {
        boolean utf8 = false;
        String parmValue = this.p.getProperty(inputParmToCheck);
        if ("UTF-8".equalsIgnoreCase(parmValue)) {
            this.checker.setWSDLEncodingRequired(true);
            utf8 = true;
        } else if (!this.isZOS() && (parmValue == null || "LOCAL".equalsIgnoreCase(parmValue))) {
            utf8 = true;
        }
        return utf8;
    }

    protected boolean isUsEBCDICRequiredForXML(String inputParmToCheck) {
        boolean usEbcdic = false;
        String parmValue = this.p.getProperty(inputParmToCheck);
        if ("EBCDIC-CP-US".equalsIgnoreCase(parmValue)) {
            this.checker.setWSDLEncodingRequired(true);
            usEbcdic = true;
        }
        return usEbcdic;
    }

    protected boolean isRegistryClientSetup() {
        return this.registryClient != null;
    }
}

