/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.util.CodePageHelper;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.ParmChecker;
import com.ibm.cics.wsdl.common.XSDBind;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;

public class JSBind
extends XSDBind {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public JSBind(boolean outputInUTF8, boolean outputInUsEBCDIC, boolean setEncoding) {
        super(outputInUTF8, outputInUsEBCDIC, setEncoding);
    }

    @Override
    public File buildXSDBindFile(String bindFileName, String schemaName, String runtimeLevel, Date timestamp, String ccsid, String altCcsid, List<QName> elementQNames, List<ICM> elementICMs, List<QName> typeQNames, List<ICM> typeICMs, String mappingLevel, String bundleName, File schemaFile, String vendorProgram, byte[] vendorMetaData) throws IOException, CICSWSDLException, JAXBException, ICMException {
        int i;
        StringBuilder output = this.createXMLDocument();
        output.append("<JSBind runtimeLevel=\"");
        output.append(runtimeLevel);
        if (!"Not Found".equals(ParmChecker.BUILD_LEVEL_NAME)) {
            output.append("\" build=\"");
            output.append(this.truncateString(ParmChecker.BUILD_LEVEL_NAME, 20));
        }
        if (!"Not Found".equals(ParmChecker.BUILD_LEVEL_RELEASE)) {
            output.append("\" release=\"");
            output.append(this.truncateString(ParmChecker.BUILD_LEVEL_RELEASE, 10));
        }
        output.append("\" xmlns=\"http://www.ibm.com/software/htp/cics/jsbind\"");
        output.append(">" + LINE_SEPARATOR);
        output.append("  <schema>");
        output.append(schemaName);
        output.append("</schema>" + LINE_SEPARATOR);
        output.append("  <timestamp>");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        output.append(sdf.format(timestamp));
        output.append("</timestamp>" + LINE_SEPARATOR);
        if (vendorProgram != null) {
            output.append("  <vendorProgramName>");
            output.append(vendorProgram);
            output.append("</vendorProgramName>" + LINE_SEPARATOR);
            if (vendorMetaData != null) {
                output.append("  <vendorProgramMetadata>" + LINE_SEPARATOR);
                output.append(ByteArray.byteArrayToBase64Binary(vendorMetaData));
                output.append(LINE_SEPARATOR);
                output.append("  </vendorProgramMetadata>" + LINE_SEPARATOR);
            }
        }
        if (elementQNames != null) {
            for (i = 0; i < elementQNames.size(); ++i) {
                QName element = elementQNames.get(i);
                output.append("  <object name=\"");
                output.append(element.getLocalPart());
                output.append("\">" + LINE_SEPARATOR);
                output.append("    <metadata mappingLevel=\"");
                output.append(mappingLevel);
                output.append("\">" + LINE_SEPARATOR);
                output.append(ByteArray.byteArrayToBase64Binary(elementICMs.get(i).toByteArray()));
                output.append(LINE_SEPARATOR);
                output.append("    </metadata>");
                output.append(LINE_SEPARATOR);
                output.append("  </object>");
                output.append(LINE_SEPARATOR);
            }
        }
        if (typeQNames != null) {
            for (i = 0; i < typeQNames.size(); ++i) {
                QName type = typeQNames.get(i);
                output.append("  <type localname=\"");
                output.append(type.getLocalPart());
                output.append("\" namespace=\"");
                output.append(type.getNamespaceURI());
                output.append("\">" + LINE_SEPARATOR);
                output.append("    <metadata mappingLevel=\"");
                output.append(mappingLevel);
                output.append("\">" + LINE_SEPARATOR);
                output.append(ByteArray.byteArrayToBase64Binary(typeICMs.get(i).toByteArray()));
                output.append(LINE_SEPARATOR);
                output.append("    </metadata>");
                output.append(LINE_SEPARATOR);
                output.append("  </type>");
                output.append(LINE_SEPARATOR);
            }
        }
        output.append("  <applicationCCSID>");
        output.append(CodePageHelper.getApplicationCCSID(ccsid));
        output.append("</applicationCCSID>" + LINE_SEPARATOR);
        if (altCcsid != null) {
            output.append("  <alternativeCCSID>");
            output.append(CodePageHelper.getApplicationCCSID(altCcsid));
            output.append("</alternativeCCSID>" + LINE_SEPARATOR);
        }
        output.append("</JSBind>");
        return this.saveBindFile(bindFileName, output, bundleName, schemaFile);
    }

    @Override
    public String getBindFileExtension() {
        return ".jsbind";
    }

    @Override
    public String getBundleSubDirectory() {
        return "jsbinds/";
    }

    @Override
    public String getBundleResourceType() {
        return "JSONTRANSFRM";
    }
}

