/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.AssistantResponse;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Logging {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    public static final int SUCCESS = 0;
    public static final int INVALID_PARAMS = 8;
    public static final int WARNING = 4;
    public static final int ERROR = 12;
    public static final int MSG_PARM_ERROR = 8;
    public static final int MSG_ERROR = 12;
    public static final int MSG_WARNING = 4;
    public static final int MSG_INFO = 1;
    private static ThreadLocal<MessagesStore> messagesStoreByThread = new ThreadLocal<MessagesStore>(){

        @Override
        protected synchronized MessagesStore initialValue() {
            return new MessagesStore();
        }
    };

    private static final void setWarning(boolean value) {
        MessagesStore ms = messagesStoreByThread.get();
        ms.setWarningIssued(value);
    }

    public static final void setErrorTrue() {
        MessagesStore ms = messagesStoreByThread.get();
        ms.setErrorIssued(true);
    }

    private static final void setError(boolean value) {
        MessagesStore ms = messagesStoreByThread.get();
        ms.setErrorIssued(value);
    }

    public static final boolean getWarning() {
        return messagesStoreByThread.get().isWarningIssued();
    }

    public static final boolean getError() {
        return messagesStoreByThread.get().isErrorIssued();
    }

    public static final void setPrintStream(PrintStream printStream) {
        MessagesStore ms = messagesStoreByThread.get();
        ms.setLogPrintStream(printStream);
        if (printStream == null) {
            ms.getPreLogFileMsgs();
        }
    }

    public static final void addPreLogFileMsgsToLog() {
        MessagesStore ms = messagesStoreByThread.get();
        String[] msgs = ms.getPreLogFileMsgs();
        for (int i = 0; i < msgs.length; ++i) {
            ms.getLogPrintStream().println(msgs[i]);
        }
    }

    protected static final void setMessagesProxy(AssistantResponse proxy) {
        MessagesStore ms = messagesStoreByThread.get();
        ms.setProxy(proxy);
        ms.setAPI(true);
    }

    public static final PrintStream getPrintStream() {
        MessagesStore ms = messagesStoreByThread.get();
        PrintStream out = ms.getLogPrintStream();
        if (out == null) {
            out = System.err;
        }
        return out;
    }

    public static void handleExc(Exception e) {
        Logging.setError(true);
        MessagesStore ms = messagesStoreByThread.get();
        PrintStream logger = ms.getLogPrintStream();
        if (logger != null) {
            logger.println(" ");
            logger.println("Error Details:");
            logger.println("--------------");
            e.printStackTrace(logger);
        } else {
            e.printStackTrace();
        }
        Logging.handleNestedExc(e, false, null);
    }

    public static void handleNestedExc(Throwable t, boolean expected, String parentMsg) {
        boolean localExpected = expected;
        if (t instanceof CICSWSDLException) {
            CICSWSDLException cwe = (CICSWSDLException)t;
            String[] errors = cwe.getMessages();
            for (int i = 0; i < errors.length; ++i) {
                Logging.writePreFormattedMessage(12, Logging.addPrefix(12, errors[i]));
            }
            localExpected = true;
        } else {
            String message = t.getLocalizedMessage();
            if (message == null) {
                message = t.getMessage();
            }
            if (message != null && message.startsWith("DFHPI")) {
                Logging.writePreFormattedMessage(12, Logging.addPrefix(12, message));
                localExpected = true;
            } else if (t instanceof FileNotFoundException) {
                Logging.writePreFormattedMessage(12, Logging.addPrefix(12, message));
            } else {
                if (message != null && (parentMsg == null || parentMsg.indexOf(message) == -1)) {
                    Logging.writePreFormattedMessage(12, Logging.addPrefix(12, message));
                }
                if (!localExpected) {
                    Logging.writeMessage(12, "DFHPI9500E", new Object[0]);
                }
            }
        }
        if (t.getCause() != null) {
            Logging.handleNestedExc(t.getCause(), localExpected, t.getLocalizedMessage());
        }
    }

    public static final void writeMessage(int msgType, String msgKey, Object[] msgParms) {
        String msg = null;
        msg = msgParms != null ? MessageHandler.buildMessage(msgKey, msgParms) : MessageHandler.getMessage(msgKey);
        Logging.writePreFormattedMessage(msgType, msg);
    }

    public static String addPrefix(int msgType, String msg) {
        if (msgType == 0) {
            // empty if block
        }
        return msg;
    }

    public static final void writePreFormattedMessage(int msgType, String msg) {
        PrintStream logger;
        if (msg == null) {
            return;
        }
        switch (msgType) {
            case 12: {
                Logging.setError(true);
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 4: {
                Logging.setWarning(true);
                break;
            }
            default: {
                msg = "INTERNAL ERROR: invalid message type \"" + msgType + "\" requested for message \"" + msg + "\".";
            }
        }
        MessagesStore ms = messagesStoreByThread.get();
        msg = Logging.addPrefix(msgType, msg);
        if (ms.isAPISet()) {
            switch (msgType) {
                case 8: 
                case 12: {
                    ms.addErrorMessage(msg);
                    break;
                }
                case 4: {
                    ms.addWarningMessage(msg);
                    break;
                }
                case 1: {
                    ms.addInformationMessage(msg);
                    break;
                }
            }
        } else if (!ms.messageIssuedAlready(msg)) {
            System.out.println(msg);
            ms.registerMessage(msg);
        }
        if ((logger = ms.getLogPrintStream()) != null) {
            logger.println(msg);
        } else {
            ms.addPreLogFileMsg(msg);
        }
    }

    protected static final void reset() {
        Logging.setWarning(false);
        Logging.setError(false);
        MessagesStore ms = messagesStoreByThread.get();
        ms.emptyMessageCache();
    }

    static class MessagesStore {
        private boolean warningIssued = false;
        private boolean errorIssued = false;
        private boolean APISet = false;
        private PrintStream logPrintStream = null;
        private AssistantResponse proxy = null;
        private List<String> preLogFileMsgs = new LinkedList<String>();
        private Set<String> allMessages = new HashSet<String>();

        MessagesStore() {
        }

        void addPreLogFileMsg(String msg) {
            this.preLogFileMsgs.add(msg);
        }

        String[] getPreLogFileMsgs() {
            String[] msgs = this.preLogFileMsgs.toArray(new String[this.preLogFileMsgs.size()]);
            this.preLogFileMsgs.clear();
            return msgs;
        }

        void setProxy(AssistantResponse proxy) {
            this.proxy = proxy;
        }

        final void addInformationMessage(String msg) {
            this.proxy.addInformation(msg);
        }

        final void addWarningMessage(String msg) {
            this.proxy.addWarning(msg);
        }

        final void addErrorMessage(String msg) {
            this.proxy.addError(msg);
        }

        boolean isAPISet() {
            return this.APISet;
        }

        void setAPI(boolean set) {
            this.APISet = set;
        }

        boolean isErrorIssued() {
            return this.errorIssued;
        }

        void setErrorIssued(boolean errorIssued) {
            this.errorIssued = errorIssued;
        }

        PrintStream getLogPrintStream() {
            return this.logPrintStream;
        }

        void setLogPrintStream(PrintStream logPrintStream) {
            this.logPrintStream = logPrintStream;
        }

        boolean isWarningIssued() {
            return this.warningIssued;
        }

        void setWarningIssued(boolean warningIssued) {
            this.warningIssued = warningIssued;
        }

        void registerMessage(String msg) {
            this.allMessages.add(msg);
        }

        boolean messageIssuedAlready(String msg) {
            return this.allMessages.contains(msg.intern());
        }

        void emptyMessageCache() {
            this.allMessages.clear();
        }
    }
}

