/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.wsdl.common.Logging;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class PDSAccessor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int PDSLIB_RECORD_LENGTH = 80;
    private static final int MAX_RECORD_LENGTH = 80;
    private static PDSTest PDS_AVAILABLE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPDSAccessPossible() {
        if (PDS_AVAILABLE != null) {
            return PDS_AVAILABLE == PDSTest.AVAILABLE;
        }
        PrintStream tmp = System.err;
        PrintStream ps = null;
        boolean response = false;
        try {
            ps = new PrintStream(new ByteArrayOutputStream());
            System.setErr(ps);
            String jzosVersion = ZUtil.getJzosDllVersion();
            if (jzosVersion != null) {
                response = true;
                PDS_AVAILABLE = PDSTest.AVAILABLE;
            }
        }
        catch (UnsatisfiedLinkError jzosVersion) {
        }
        catch (NoClassDefFoundError jzosVersion) {
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            System.setErr(tmp);
            if (ps != null) {
                ps.close();
            }
            if (PDS_AVAILABLE == null) {
                PDS_AVAILABLE = PDSTest.UNAVAILABLE;
            }
        }
        return response;
    }

    public static boolean exists(String name) {
        boolean exists = false;
        try {
            exists = ZFile.dsExists((String)name);
        }
        catch (ZFileException zFileException) {
            // empty catch block
        }
        return exists;
    }

    public static boolean checkPDSReadPermission(String pdsLib) {
        try {
            if (!ZFile.dsExists((String)pdsLib)) {
                Logging.writeMessage(12, "DFHPI9515E", new Object[]{pdsLib});
                return false;
            }
        }
        catch (ZFileException ze) {
            if (ze.getAbendCode() == 2323) {
                Logging.writeMessage(12, "DFHPI9516E", new Object[]{pdsLib});
                return false;
            }
            PDSAccessor.handleZFileExc(ze);
            return false;
        }
        return true;
    }

    public static boolean checkPDSReadWritePermission(String pdsLib) {
        boolean rc = PDSAccessor.checkPDSReadPermission(pdsLib);
        return rc;
    }

    public static boolean checkPDSMemberReadPermission(String memberName) {
        ZFile zf = PDSAccessor.getPDSMemberForRead(memberName);
        if (zf != null) {
            try {
                zf.close();
            }
            catch (ZFileException ze) {
                PDSAccessor.handleZFileExc(ze);
            }
            return true;
        }
        Logging.writeMessage(12, "DFHPI9528E", new Object[]{memberName});
        return false;
    }

    public static ZFile getPDSMemberForRead(String memberName) {
        if (!PDSAccessor.checkPDSAccessPossible()) {
            return null;
        }
        try {
            if (ZFile.dsExists((String)memberName)) {
                ZFile zf = new ZFile(memberName, "rb,type=record,noseek");
                if (!zf.getRecfm().equalsIgnoreCase("FB") || zf.getLrecl() != 80) {
                    Logging.writeMessage(12, "DFHPI9521E", new Object[]{memberName});
                    return null;
                }
                return zf;
            }
        }
        catch (ZFileException ze) {
            if (ze.getAbendCode() == 2323) {
                Logging.writeMessage(12, "DFHPI9522E", new Object[]{memberName});
                return null;
            }
            PDSAccessor.handleZFileExc(ze);
        }
        return null;
    }

    public static ZFile getPDSMemberForWrite(String fullName) {
        if (!PDSAccessor.checkPDSAccessPossible()) {
            return null;
        }
        try {
            int posOfFirstBracket = fullName.indexOf(40);
            String pdsName = fullName.substring(3, posOfFirstBracket);
            String cmd = "alloc fi(MYDD) da(" + pdsName + ") reuse shr msg(2)";
            ZFile.bpxwdyn((String)cmd);
            String memberName = "//DD:MYDD(" + fullName.substring(posOfFirstBracket + 1, fullName.length() - 2) + ")";
            ZFile zf = new ZFile(memberName, "wb,type=record,noseek");
            if (zf.getLrecl() < 80) {
                Logging.writeMessage(4, "DFHPI9518W", new Object[]{fullName});
            }
            return zf;
        }
        catch (ZFileException ze) {
            if (ze.getAbendCode() == 2323) {
                Logging.writeMessage(12, "DFHPI9524E", new Object[]{fullName});
                return null;
            }
            if (ze.getErrno() == 61) {
                Logging.writeMessage(12, "DFHPI9524E", new Object[]{fullName});
                return null;
            }
            PDSAccessor.handleZFileExc(ze);
            return null;
        }
    }

    private static void handleZFileExc(ZFileException ze) {
        Logging.handleExc((Exception)((Object)ze));
        PrintStream out = Logging.getPrintStream();
        out.println("Addditional Diagnostics: ");
        out.println("   AbendCode:     " + ze.getAbendCode());
        out.println("   AbendRC:       " + ze.getAbendRc());
        out.println("   Errno:         " + ze.getErrno());
        out.println("   Errno2:        " + ze.getErrno2());
        out.println("   ErrorCode:     " + ze.getErrorCode());
        out.println("   FeedbackFdbk:  " + ze.getFeedbackFdbk());
        out.println("   FeedbackFtncd: " + ze.getFeedbackFtncd());
        out.println("   FeedbackRC:    " + ze.getFeedbackRc());
        out.println("   FileName:      " + ze.getFileName());
        out.println("   LastOp:        " + ze.getLastOp());
    }

    public static boolean checkPDSMemberWritePermission(String memberName) {
        return true;
    }

    public static InputStream getInputStreamForPDSMember(String memberName) throws FileNotFoundException, SecurityException {
        if (!PDSAccessor.checkPDSMemberReadPermission(memberName)) {
            throw new FileNotFoundException(memberName);
        }
        ZFile zf = PDSAccessor.getPDSMemberForRead(memberName);
        return new JZOSInputStream(zf);
    }

    public static OutputStream getOutputStreamForPDSMember(String memberName) throws FileNotFoundException, IOException {
        ZFile zf = PDSAccessor.getPDSMemberForWrite(memberName);
        if (zf == null) {
            return null;
        }
        return new JZOSOutputStream(zf);
    }

    public static String prepareLibraryNameForJZOS(String libraryName) {
        if (!libraryName.startsWith("//")) {
            libraryName = libraryName.startsWith("'") ? "//" + libraryName : "//'" + libraryName + "'";
        } else if (!libraryName.startsWith("//'")) {
            libraryName = "//'" + libraryName.substring(2) + "'";
        }
        return libraryName;
    }

    private static class JZOSOutputStream
    extends OutputStream {
        static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private static final String SCCSID = "%Z% %W% %I% %E% %U%";
        ZFile zf = null;

        public JZOSOutputStream(ZFile target) {
            this.zf = target;
        }

        @Override
        public void close() throws IOException {
            this.zf.close();
            ZFile.bpxwdyn((String)"free fi(MYDD) msg(2)");
        }

        @Override
        public void write(int b) throws IOException {
            throw new RuntimeException("InternalError: read() method not implemented.");
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.zf.write(bytes);
        }
    }

    private static class JZOSInputStream
    extends InputStream {
        static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private static final String SCCSID = "%Z% %W% %I% %E% %U%";
        ZFile zf = null;

        public JZOSInputStream(ZFile source) {
            this.zf = source;
        }

        @Override
        public int read() throws IOException {
            throw new RuntimeException("InternalError: read() method not implemented.");
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return this.zf.read(bytes);
        }

        @Override
        public void close() throws IOException {
            this.zf.close();
        }
    }

    private static enum PDSTest {
        AVAILABLE,
        UNAVAILABLE;

    }
}

