/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.gen.api.IPlatform;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMInterceptor;
import com.ibm.cics.schema.util.CodePageHelper;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.schema.utils.RuntimeLevelHelper;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.WSDLInvalidParamsException;
import com.ibm.cics.wsdl.common.ErrorReportingFileOutputStream;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.PDSAccessor;
import com.ibm.cics.wsdl.common.TimeStampedPrintStream;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.common.WSBind;
import com.ibm.cics.wsdl.ls2ws.LangStruct;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParmChecker {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2020 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static String BUILD_LEVEL_RELEASE = "5.6.14";
    public static String BUILD_LEVEL_NAME = "5.6.14";
    protected static final String BUILD_LEVEL_UNKNOWN = "Not Found";
    private static final String LINE_SEPARATOR;
    private PrintStream log;
    private int mappingLevel = 0;
    private byte wsBindVerNumber = 0;
    private static final int MAX_PROGRAM_LENGTH = 8;
    private static final int MAX_JSONTRANSFRM_LENGTH = 16;
    private static final int MAX_CONTID_LENGTH = 16;
    private static final int BOTTOM_UP_PDSMEM_LEN = 8;
    private static final int TOP_DOWN_PDSMEM_LEN = 6;
    private static final int MAX_LINE_LENGTH = 72;
    private static final int WSBIND_FILE_MAX = 32;
    public static final int NOT_APPLIC = 0;
    public static final int OPTIONAL = 1;
    public static final int MANDATORY = 2;
    public static final int MAX_CHAR_ARRAY_LENGTH = Short.MAX_VALUE;
    public static final int MAX_CHAR_ARRAY_LENGTH_LARGE = 0xFFFFFE;
    private static final int MIN_DEFAULT_FRACTION_DIGITS = 0;
    private static final int MAX_DEFAULT_FRACTION_DIGITS = 17;
    private static final int MAX_DEFAULT_FRACTION_DIGITS_WIDE = 30;
    public static final int DEFAULT_FRACTION_DIGITS_DEFAULT = 3;
    public static final String OPT_ADDITIONAL_PROPERTIES_DEFAULT = "ADDITIONAL-PROPERTIES-DEFAULT";
    public static final String OPT_ADDITIONAL_PROPERTIES_MAX = "ADDITIONAL-PROPERTIES-MAX";
    public static final String OPT_ADDITIONAL_PROPERTIES_SIZE = "ADDITIONAL-PROPERTIES-SIZE";
    public static final String OPT_BINDING = "BINDING";
    public static final String OPT_BUNDLE = "BUNDLE";
    public static final String OPT_CCSID = "CCSID";
    public static final String OPT_CHAR_MULTIPLIER = "CHAR-MULTIPLIER";
    public static final String OPT_CHAR_OCCURS = "CHAR-OCCURS";
    public static final String OPT_CHAR_USAGE = "CHAR-USAGE";
    public static final String OPT_CHAR_VARYING = "CHAR-VARYING";
    public static final String OPT_CHAR_VARYING_LIMIT = "CHAR-VARYING-LIMIT";
    public static final String OPT_CHAR_WHITESPACE = "CHAR-WHITESPACE";
    public static final String OPT_CONTID = "CONTID";
    public static final String OPT_DATA_TRUNCATION = "DATA-TRUNCATION";
    public static final String OPT_DATA_SCREENING = "DATA-SCREENING";
    public static final String OPT_DATETIME = "DATETIME";
    public static final String OPT_DEFAULT_CHAR_MAXLENGTH = "DEFAULT-CHAR-MAXLENGTH";
    public static final String OPT_DEFAULT_ARRAY_MAXITEMS = "DEFAULT-ARRAY-MAXITEMS";
    public static final String OPT_DISABLE_CONTAINERS = "DISABLE-CONTAINERS";
    public static final String OPT_ELEMENTS = "ELEMENTS";
    public static final String OPT_ENDPOINT = "ENDPOINT";
    public static final String OPT_HTTP_METHODS = "HTTP-METHODS";
    public static final String OPT_HTTPPROXY = "HTTPPROXY";
    public static final String OPT_HTTPPROXY_USERNAME = "HTTPPROXY-USERNAME";
    public static final String OPT_HTTPPROXY_PASSWORD = "HTTPPROXY-PASSWORD";
    public static final String OPT_INLINE_MAXOCCURS_LIMIT = "INLINE-MAXOCCURS-LIMIT";
    public static final String OPT_INTERNAL_PGMNAME = "INTERNAL_PGMNAME";
    public static final String OPT_INTERNAL_TOOLNAME = "INTERNAL_TOOLNAME";
    public static final String OPT_JSON_SCHEMA = "JSON-SCHEMA";
    public static final String OPT_JSON_SCHEMA_CODEPAGE = "JSON-SCHEMA-CODEPAGE";
    public static final String OPT_JSON_SCHEMA_REQUEST = "JSON-SCHEMA-REQUEST";
    public static final String OPT_JSON_SCHEMA_RESPONSE = "JSON-SCHEMA-RESPONSE";
    public static final String OPT_JSON_SCHEMA_RESTFUL = "JSON-SCHEMA-RESTFUL";
    public static final String OPT_JSONTRANSFRM = "JSONTRANSFRM";
    public static final String OPT_LANG = "LANG";
    public static final String OPT_LOGFILE = "LOGFILE";
    public static final String OPT_MAPPING_LEVEL = "MAPPING-LEVEL";
    public static final String OPT_MAPPING_OVERRIDES = "MAPPING-OVERRIDES";
    public static final String OPT_MINIMUM_RUNTIME_LEVEL = "MINIMUM-RUNTIME-LEVEL";
    public static final String OPT_NAME_TRUNCATION = "NAME-TRUNCATION";
    public static final String OPT_NAMESPACE = "NAMESPACE";
    public static final String OPT_OPERATIONS = "OPERATIONS";
    public static final String OPT_OPERATION_NAME = "OPERATION-NAME";
    public static final String OPT_PDSCP = "PDSCP";
    public static final String OPT_PDSLIB = "PDSLIB";
    public static final String OPT_PDSMEM = "PDSMEM";
    public static final String OPT_PGMINT = "PGMINT";
    public static final String OPT_PGMNAME = "PGMNAME";
    public static final String OPT_REQMEM = "REQMEM";
    public static final String OPT_REQUEST_CHANNEL = "REQUEST-CHANNEL";
    public static final String OPT_REQUEST_NAMESPACE = "REQUEST-NAMESPACE";
    public static final String OPT_REQUEST_STRUCT = "REQUEST_STRUCT";
    public static final String OPT_RESPMEM = "RESPMEM";
    public static final String OPT_RESPONSE_CHANNEL = "RESPONSE-CHANNEL";
    public static final String OPT_RESPONSE_NAMESPACE = "RESPONSE-NAMESPACE";
    public static final String OPT_RESPONSE_STRUCT = "RESPONSE_STRUCT";
    public static final String OPT_SCHEMA = "SCHEMA";
    public static final String OPT_SERVICE = "SERVICE";
    public static final String OPT_SOAPVER = "SOAPVER";
    public static final String OPT_STRUCTURE = "STRUCTURE";
    public static final String OPT_STYLE = "STYLE";
    public static final String OPT_SYNCONRETURN = "SYNCONRETURN";
    public static final String OPT_TRANSACTION = "TRANSACTION";
    public static final String OPT_TRUNCATE_NULL_ARRAYS = "TRUNCATE-NULL-ARRAYS";
    public static final String OPT_TRUNCATE_NULL_ARRAY_VALUES = "TRUNCATE-NULL-ARRAY-VALUES";
    public static final String OPT_TYPES = "TYPES";
    public static final String OPT_URI = "URI";
    public static final String OPT_URI_ABSOLUTE = "URI_ABSOLUTE";
    public static final String OPT_URI_RELATIVE = "URI_RELATIVE";
    public static final String OPT_USERID = "USERID";
    public static final String OPT_WSADDR_EPR_ANY = "WSADDR-EPR-ANY";
    public static final String OPT_WSBIND = "WSBIND";
    public static final String OPT_WSDL = "WSDL";
    public static final String OPT_WSDLCP = "WSDLCP";
    public static final String OPT_WSDL_NAMESPACE = "WSDL-NAMESPACE";
    public static final String OPT_WSDL_SERVICE = "WSDL-SERVICE";
    public static final String OPT_WSDL_1_1 = "WSDL_1.1";
    public static final String OPT_WSDL_2_0 = "WSDL_2.0";
    public static final String OPT_XMLCP = "XMLCP";
    public static final String OPT_XML_ONLY = "XML-ONLY";
    public static final String OPT_XSDBIND = "XSDBIND";
    public static final String OPT_SSL_KEYSTORE = "SSL-KEYSTORE";
    public static final String OPT_SSL_KEYPWD = "SSL-KEYPWD";
    public static final String OPT_SSL_TRUSTSTORE = "SSL-TRUSTSTORE";
    public static final String OPT_SSL_TRUSTPWD = "SSL-TRUSTPWD";
    public static final String OPT_WSRR_SERVER = "WSRR-SERVER";
    public static final String OPT_WSRR_NAME = "WSRR-NAME";
    public static final String OPT_WSRR_NAMESPACE = "WSRR-NAMESPACE";
    public static final String OPT_WSRR_VERSION = "WSRR-VERSION";
    public static final String OPT_WSRR_USERNAME = "WSRR-USERNAME";
    public static final String OPT_WSRR_PASSWORD = "WSRR-PASSWORD";
    public static final String OPT_WSRR_DESCRIPTION = "WSRR-DESCRIPTION";
    public static final String OPT_WSRR_ENCODING = "WSRR-ENCODING";
    public static final String OPT_WSRR_PREFIX = "WSRR-CUSTOM-";
    public static final String OPT_WSRR_LOCATION = "WSRR-LOCATION";
    public static final String OPT_OVERWRITE_OUTPUT = "OVERWRITE-OUTPUT";
    public static final String OPT_WIDE_COMP3 = "WIDE-COMP3";
    public static final String OPT_DEFAULT_FRACTION_DIGITS = "DEFAULT-FRACTION-DIGITS";
    public static final String OPT_ALLOW_NON_EBCDIC = "ALLOW-NON-EBCDIC";
    public static final String OPT_BINDING_NAME = "BINDING-NAME";
    public static final String OPT_PORT_NAME = "PORT-NAME";
    public static final String OPT_SERVICE_NAME = "SERVICE-NAME";
    public static final String OPT_VENDOR_CONV_NAME = "VENDOR-CONVERTER-NAME";
    public static final String OPT_VENDOR_INTF_LENGTH = "VENDOR-APP-INTERFACE-LENGTH";
    public static final String OPT_VENDOR_META_DATA = "VENDOR-META-DATA";
    public static final String OPT_SAME_AS_MAPPING_LEVEL = "SAME-AS-MAPPING-LEVEL";
    public static final String OPT_UNDERSCORES_AS_HYPHENS = "UNDERSCORES-AS-HYPHENS";
    public static final String OPT_JSON_INTEGER_AS_PIC9 = "INTEGER-AS-PIC9";
    public static final String OPT_VALUE_LESS_DUP_NAMES = "LESS-DUP-NAMES";
    public static final String OPT_NO_ARRAY_NAME_INDEXING = "NO-ARRAY-NAME-INDEXING";
    public static final String OPT_HYPHENS_AS_UNDERSCORES = "HYPHENS-AS-UNDERSCORES";
    public static final String OPT_ZOS_CONNECT_EE = "ZOS-CONNECT-EE";
    public static final String OPT_LANGUAGE_COUNTRY = "LANGUAGE-COUNTRY";
    public static final String OPT_CONTAINER_NAME_SUFFIX = "CONTAINER-NAME-SUFFIX";
    public static final String[] VALID_MAPPING_OVERRIDES_VALUES;
    private int toolInUse = 6;
    public static final int WS2LS = 0;
    public static final int LS2WS = 1;
    public static final int SC2LS = 2;
    public static final int LS2SC = 3;
    public static final int LS2JS = 4;
    public static final int JS2LS = 5;
    public static final String TOOL_DFHWS2LS = "DFHWS2LS";
    public static final String TOOL_DFHLS2WS = "DFHLS2WS";
    public static final String TOOL_DFHSC2LS = "DFHSC2LS";
    public static final String TOOL_DFHLS2SC = "DFHLS2SC";
    public static final String TOOL_DFHLS2JS = "DFHLS2JS";
    public static final String TOOL_DFHJS2LS = "DFHJS2LS";
    static final String[] TOOL_NAMES;
    static final Set<String> allValidParms;
    private static List<ParameterRules> PARM_VALID_FOR_TOOL;
    private static final String DEFAULT_CONTID = "DFHWS-DATA";
    public static final String WSDLCP_LOCAL_CP = "LOCAL";
    public static final String WSDLCP_UTF8_CP = "UTF-8";
    public static final String WSDLCP_US_EBCDIC_CP = "EBCDIC-CP-US";
    public static final String[] VALID_WSDLCP_VALUES;
    private Properties p;
    private Properties wsrrProps;
    private int lang = -1;
    private int charVaryingLimit = Short.MAX_VALUE;
    private int defaultCharMaxLength = 255;
    private int defaultArrayMaxItems = -1;
    private int charMultiplier = 1;
    private String charOccurs = null;
    private int inlineMaxOccursLimit = 0;
    private boolean vendorBindFile = false;
    private List<String> operationNames = null;
    private List<String> schemaTypes = null;
    private List<String> schemaElements = null;
    private boolean syncOnReturn = false;
    private boolean usePDSFiles = true;
    private boolean xmlOnly = false;
    private boolean bundleSet = false;
    private int defaultFractionDigits = 3;
    public static final String OPT_VALUE_SERVICE_TIMESTAMPS = "TIMESTAMPS";
    public static final String OPT_VALUE_SERVICE_LEVELINC = "LEVELINC";
    public static final String OPT_VALUE_SERVICE_SPECIFY_ENCODING = "SETENCODING";
    public static final String OPT_VALUE_SERVICE_BOOTSTRAP_ICM = "BOOTSTRAP_ICM";
    public static final String OPT_VALUE_SERVICE_ICM_INTERCEPTOR = "ICM_INTERCEPTOR";
    public static final String OPT_VALUE_CHANNEL = "CHANNEL";
    public static final String OPT_VALUE_COMMAREA = "COMMAREA";
    public static final String OPT_VALUE_NOT_APPLIC = "NA";
    public static final String OPT_VALUE_RPC = "RPC";
    public static final String OPT_VALUE_DOC = "DOC";
    public static final String OPT_VALUE_WRAPPED = "WRAPPED";
    public static final String OPT_VALUE_COBOL = "COBOL";
    public static final String OPT_VALUE_PLI_ENTERPRISE = "PLI-ENTERPRISE";
    public static final String OPT_VALUE_PLI_OTHER = "PLI-OTHER";
    public static final String OPT_VALUE_C = "C";
    public static final String OPT_VALUE_CPP = "CPP";
    public static final String OPT_VALUE_PLX = "PLX";
    public static final String OPT_VALUE_YES = "YES";
    public static final String OPT_VALUE_NO = "NO";
    public static final String OPT_VALUE_NULL = "NULL";
    public static final String OPT_VALUE_COLLAPSE = "COLLAPSE";
    public static final String OPT_VALUE_BINARY = "BINARY";
    public static final String OPT_VALUE_FULL = "FULL";
    public static final String OPT_VALUE_REPLACE = "REPLACE";
    public static final String OPT_VALUE_PRESERVE = "PRESERVE";
    public static final String[] VALID_CHAR_WHITESPACE_VALUES;
    public static final String[] VALID_SYNCONRETURN_VALUES;
    public static final String[] VALID_OVERWRITE_OUTPUT_VALUES;
    public static final String[] VALID_WIDE_COMP3_VALUES;
    public static final String OPT_VALUE_MINIMUM = "MINIMUM";
    public static final String OPT_VALUE_CURRENT = "CURRENT";
    public static final String OPT_VALUE_SOAP_1_1 = "1.1";
    public static final String OPT_VALUE_SOAP_1_2 = "1.2";
    public static final String OPT_VALUE_SOAP_ALL = "ALL";
    public static final String OPT_VALUE_ALL = "ALL";
    private static final String EMPTY_STR = "";
    private static final String ONE_CHAR_STRING = " ";
    public static final String OPT_VALUE_STRING = "STRING";
    public static final String OPT_VALUE_PACKED15 = "PACKED15";
    public static final String OPT_VALUE_UNUSED = "UNUSED";
    public static final String[] VALID_DATETIME_VALUES_TOP_DOWN;
    public static final String[] VALID_DATETIME_VALUES_BOTTOM_UP;
    public static final String OPT_VALUE_ENABLED = "ENABLED";
    public static final String OPT_VALUE_DISABLED = "DISABLED";
    public static final String[] VALID_DATA_TRUNCATION_VALUES;
    public static final String[] VALID_DATA_SCREENING_VALUES;
    public static final String[] VALID_TRUNCATE_NULL_ARRAYS_VALUES;
    public static final String OPT_VALUE_SPACE = "SPACE";
    public static final String OPT_VALUE_ZERO = "ZERO";
    public static final String OPT_VALUE_PACKEDZERO = "PACKEDZERO";
    public static final String[] VALID_TRUNCATE_NULL_ARRAY_VALUES_VALUES;
    public static final String OPT_VALUE_LEFT = "LEFT";
    public static final String OPT_VALUE_RIGHT = "RIGHT";
    public static final String[] VALID_NAME_TRUNCATION_VALUES;
    public static final String OPT_VALUE_GET = "GET";
    public static final String OPT_VALUE_POST = "POST";
    public static final String OPT_VALUE_PUT = "PUT";
    public static final String OPT_VALUE_DELETE = "DELETE";
    public static final String OPT_VALUE_HEAD = "HEAD";
    public static final String[] VALID_HTTP_METHODS_VALUES;
    public static final String OPT_VALUE_ARRAY = "ARRAY";
    public static final String[] VALID_CHAR_OCCURS_VALUES;
    public static final String OPT_VALUE_DBCS = "DBCS";
    public static final String OPT_VALUE_NATIONAL = "NATIONAL";
    public static final String[] VALID_CHAR_USAGE_VALUES;
    public static final String OPT_VALUE_TRUE = "TRUE";
    public static final String OPT_VALUE_FALSE = "FALSE";
    public static final String[] VALID_ADDITIONAL_PROPERTIES_DEFAULT_VALUES;
    public static final String OPT_VALUE_UNBOUNDED = "UNBOUNDED";
    private static final String SUPPRESSED_VALUE = "********";
    private static final String MIN_JAVA_VERSION = "1.6";
    private static final String MOST_RECENT_MAPPING_LEVEL = "4.3";
    private boolean minimumRuntimeIsSet = false;
    private byte[] metaData = null;
    private boolean timestampedLog = false;
    private int levelIncrementSize = 5;
    private boolean specifyEncoding = false;
    private String bootStrapICM = null;
    private static final Pattern transactionPattern;
    private static final Pattern programNamePattern;
    private static final Pattern useridPattern;
    public static final int RUNTIME_CHANGE_WSDL_2_0 = 3;
    public static final String JMS_RELATIVE_URI_IDENTIFIER = "targetService=";
    public static final String UTF16_PROPERTY = "UTF-16";
    private ICMInterceptor interceptor = null;
    private IPlatform platform = null;
    private boolean launchedUsingAPI = false;

    protected ParmChecker(String paramsFile, int toolInUse, byte[] vendorMetaData, IPlatform platform) throws CICSWSDLException {
        this.readFile(paramsFile);
        this.toolInUse = toolInUse;
        this.metaData = vendorMetaData;
        this.platform = platform;
        this.launchedUsingAPI = false;
    }

    protected ParmChecker(Properties props, int toolInUse, byte[] vendorMetaData, IPlatform platform) {
        this.p = props;
        this.toolInUse = toolInUse;
        this.metaData = vendorMetaData;
        this.platform = platform;
        this.launchedUsingAPI = true;
    }

    private boolean checkJavaVersionGood() {
        String java_version = System.getProperty("java.version");
        if (MIN_JAVA_VERSION.compareTo(java_version) > 0) {
            Logging.writeMessage(12, "DFHPI9615E", new Object[]{java_version, MIN_JAVA_VERSION});
            return false;
        }
        return true;
    }

    protected final Properties checkAssistantParms(Date timestamp) throws WSDLInvalidParamsException, CICSWSDLException {
        this.setDefaults();
        this.p.setProperty(OPT_INTERNAL_TOOLNAME, TOOL_NAMES[this.toolInUse]);
        boolean logFileOK = this.checkLogfile(this.p.getProperty(OPT_LOGFILE));
        String codepage = this.p.getProperty(OPT_PDSCP);
        Charset resolvedCCSID = null;
        try {
            resolvedCCSID = CodePageHelper.resolveCCSID(codepage);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (resolvedCCSID != null) {
            codepage = resolvedCCSID.name();
        }
        if (!this.checkJavaVersionGood() || !this.checkParametersCompatibleWithTool(this.p, this.toolInUse) | !this.checkLanguageCountry(this.p.getProperty(OPT_LANGUAGE_COUNTRY)) | !this.checkVendorConverterName(this.p.getProperty(OPT_VENDOR_CONV_NAME)) | !this.checkVendorInerfaceLen(this.p.getProperty(OPT_VENDOR_INTF_LENGTH)) | !this.checkVendorMetaData(this.metaData) | !this.checkMinRuntimeLevel(this.p.getProperty(OPT_MINIMUM_RUNTIME_LEVEL)) | !this.checkMappingLevel(this.p.getProperty(OPT_MAPPING_LEVEL)) | !this.checkMappingOverrides(this.p.getProperty(OPT_MAPPING_OVERRIDES)) | !this.checkBundle(this.p.getProperty(OPT_BUNDLE)) | !this.checkCCSID(this.p.getProperty(OPT_CCSID), this.p.getProperty(OPT_ALLOW_NON_EBCDIC)) | !this.checkWSDL(this.p.getProperty(OPT_WSDL), this.p.getProperty(OPT_WSDL_1_1), this.p.getProperty(OPT_WSDL_2_0)) | !this.checkBinding(this.p.getProperty(OPT_BINDING)) | !this.checkLang(this.p.getProperty(OPT_LANG)) | !this.checkPgmName(this.p.getProperty(OPT_PGMNAME)) | !this.checkURI(this.p.getProperty(OPT_URI)) | !this.checkPgmInterface(this.p.getProperty(OPT_PGMINT)) | !this.checkContainerID(this.p.getProperty(OPT_PGMINT), this.p.getProperty(OPT_CONTID)) | !this.checkWSBind(this.p.getProperty(OPT_WSBIND)) | !this.checkPdslib(this.p.getProperty(OPT_PDSLIB)) | !this.checkPdsCp(codepage) | !this.checkReqmem(this.p.getProperty(OPT_REQMEM), this.p.getProperty(OPT_REQUEST_CHANNEL)) | !this.checkRespmem(this.p.getProperty(OPT_RESPMEM), this.p.getProperty(OPT_RESPONSE_CHANNEL)) | !this.checkStructure(this.p.getProperty(OPT_STRUCTURE)) | !this.checkReqAndRespDifferent(this.p.getProperty(OPT_REQMEM), this.p.getProperty(OPT_RESPMEM)) | !this.checkRequestAndResponseChannel(this.p.getProperty(OPT_REQUEST_CHANNEL), this.p.getProperty(OPT_RESPONSE_CHANNEL)) | !this.checkDefaultCharMaxLength(this.p.getProperty(OPT_DEFAULT_CHAR_MAXLENGTH)) | !this.checkDefaultArrayMaxItems(this.p.getProperty(OPT_DEFAULT_ARRAY_MAXITEMS)) | !this.checkCharMultiplier(this.p.getProperty(OPT_CHAR_MULTIPLIER)) | !this.checkCharOccurs(this.p.getProperty(OPT_CHAR_OCCURS)) | !this.checkCharUsage(this.p.getProperty(OPT_CHAR_USAGE)) | !this.checkCharVarying(this.p.getProperty(OPT_CHAR_VARYING)) | !this.checkCharVaryingLimit(this.p.getProperty(OPT_CHAR_VARYING_LIMIT)) | !this.checkCharWhitespace(this.p.getProperty(OPT_CHAR_WHITESPACE)) | !this.checkInlineMaxOccursLimit(this.p.getProperty(OPT_INLINE_MAXOCCURS_LIMIT)) | !this.checkTransaction(this.p.getProperty(OPT_TRANSACTION)) | !this.checkUserid(this.p.getProperty(OPT_USERID)) | !this.checkWSDLNamespace(this.p.getProperty(OPT_WSDL_NAMESPACE)) | !this.checkWSDLService(this.p.getProperty(OPT_WSDL_SERVICE)) | !this.checkOperations(this.p.getProperty(OPT_OPERATIONS)) | !this.checkOperationName(this.p.getProperty(OPT_OPERATION_NAME)) | !this.checkSoapVer(this.p.getProperty(OPT_SOAPVER)) | !this.checkService(this.p.getProperty(OPT_SERVICE)) | !this.checkNameSpaces(this.p.getProperty(OPT_REQUEST_NAMESPACE), this.p.getProperty(OPT_RESPONSE_NAMESPACE)) | !this.setProxy(this.p.getProperty(OPT_HTTPPROXY)) | !this.checkProxyAuthentication(this.p.getProperty(OPT_HTTPPROXY), this.p.getProperty(OPT_HTTPPROXY_USERNAME), this.p.getProperty(OPT_HTTPPROXY_PASSWORD)) | !this.checkXmlOnly(this.p.getProperty(OPT_XML_ONLY)) | !this.checkWSDLCP(this.p.getProperty(OPT_WSDLCP)) | !this.checkSyncOnReturn(this.p.getProperty(OPT_SYNCONRETURN)) | !this.checkOverwriteOutput(this.p.getProperty(OPT_OVERWRITE_OUTPUT)) | !this.checkWideComp3(this.p.getProperty(OPT_WIDE_COMP3)) | !this.checkDefaultFractionDigits(this.p.getProperty(OPT_DEFAULT_FRACTION_DIGITS)) | !this.checkPdsmem(this.p.getProperty(OPT_PDSMEM)) | !this.checkXSDBind(this.p.getProperty(OPT_XSDBIND)) | !this.checkSchema(this.p.getProperty(OPT_SCHEMA)) | !this.checkXmlCP(this.p.getProperty(OPT_XMLCP)) | !this.checkElements(this.p.getProperty(OPT_ELEMENTS)) | !this.checkTypes(this.p.getProperty(OPT_TYPES)) | !this.checkWsAddrEprAny(this.p.getProperty(OPT_WSADDR_EPR_ANY)) | !this.checkSSL(this.p.getProperty(OPT_SSL_TRUSTSTORE), this.p.getProperty(OPT_SSL_TRUSTPWD), this.p.getProperty(OPT_SSL_KEYSTORE), this.p.getProperty(OPT_SSL_KEYPWD)) | !this.checkDATETIME(this.p.getProperty(OPT_DATETIME)) | !this.checkDataTruncation(this.p.getProperty(OPT_DATA_TRUNCATION)) | !this.checkDataScreening(this.p.getProperty(OPT_DATA_SCREENING)) | !this.checkNameTruncation(this.p.getProperty(OPT_NAME_TRUNCATION)) | !this.checkJSONSchemaParms(this.p.getProperty(OPT_JSON_SCHEMA_REQUEST), this.p.getProperty(OPT_JSON_SCHEMA_RESPONSE), this.p.getProperty(OPT_JSON_SCHEMA_RESTFUL), this.p.getProperty(OPT_JSON_SCHEMA)) | !this.checkJSONTransform(this.p.getProperty(OPT_JSONTRANSFRM)) | !this.checkHTTPMethods(this.p.getProperty(OPT_HTTP_METHODS)) | !this.checkJSONSchemaCodepage(this.p.getProperty(OPT_JSON_SCHEMA_CODEPAGE)) | !this.checkBindingName(this.p.getProperty(OPT_BINDING_NAME)) | !this.checkPortName(this.p.getProperty(OPT_PORT_NAME)) | !this.checkServiceName(this.p.getProperty(OPT_SERVICE_NAME)) | !this.checkTruncateNullArrays(this.p.getProperty(OPT_TRUNCATE_NULL_ARRAYS)) | !this.checkTruncateNullArrayValues(this.p.getProperty(OPT_TRUNCATE_NULL_ARRAY_VALUES)) | !this.checkAdditionalProperties(this.p.getProperty(OPT_ADDITIONAL_PROPERTIES_DEFAULT), this.p.getProperty(OPT_ADDITIONAL_PROPERTIES_MAX), this.p.getProperty(OPT_ADDITIONAL_PROPERTIES_SIZE)) | !this.checkZosConnectEE(this.p.getProperty(OPT_ZOS_CONNECT_EE)) | !this.checkContainerNameSuffix(this.p.getProperty(OPT_CONTAINER_NAME_SUFFIX)) | !logFileOK) {
            if (logFileOK) {
                this.logParams(timestamp, this.p.getProperty(OPT_LOGFILE));
            }
            throw new WSDLInvalidParamsException(MessageHandler.getMessage("DFHPI9502E"));
        }
        this.logParams(timestamp, this.p.getProperty(OPT_LOGFILE));
        this.processWSRRParms();
        if (this.p.getProperty(OPT_HTTPPROXY) != null) {
            this.setProxy(this.p.getProperty(OPT_HTTPPROXY));
            String proxyUsername = this.p.getProperty(OPT_HTTPPROXY_USERNAME);
            String proxyPassword = this.p.getProperty(OPT_HTTPPROXY_PASSWORD);
            if (proxyUsername != null) {
                this.setProxyAuthentication(proxyUsername, proxyPassword);
            }
        }
        if (this.p.getProperty(OPT_SSL_KEYSTORE) != null) {
            this.setSSL();
        }
        return this.p;
    }

    private void processWSRRParms() throws WSDLInvalidParamsException {
        if (this.toolInUse != 1 && this.toolInUse != 0) {
            return;
        }
        Object propValue = this.p.getProperty(OPT_WSRR_SERVER);
        if (propValue == null) {
            return;
        }
        if (EMPTY_STR.equals(propValue)) {
            Logging.writeMessage(8, "DFHPI9822E", new Object[]{OPT_WSRR_SERVER, propValue});
            throw new WSDLInvalidParamsException(MessageHandler.getMessage("DFHPI9502E"));
        }
        Object server = propValue;
        int i = ((String)server).indexOf(":") + 1;
        if (i < ((String)server).length() && i > 0) {
            String hostnamePort = ((String)server).substring(i);
            i = i + hostnamePort.indexOf(":") + 1;
            int j = -1;
            if (i < ((String)server).length() && i > 0) {
                Integer testPortNo = null;
                try {
                    String portNo = ((String)server).substring(i);
                    if (portNo.endsWith("/")) {
                        portNo = portNo.replace("/", EMPTY_STR);
                    }
                    testPortNo = Integer.valueOf(portNo);
                    j = testPortNo;
                }
                catch (NumberFormatException nfe) {
                    Logging.writeMessage(8, "DFHPI9822E", new Object[]{OPT_WSRR_SERVER, propValue});
                    throw new WSDLInvalidParamsException(MessageHandler.getMessage("DFHPI9502E"));
                }
                if (j < 0 || j > 65535) {
                    Logging.writeMessage(8, "DFHPI9822E", new Object[]{OPT_WSRR_SERVER, propValue});
                    throw new WSDLInvalidParamsException(MessageHandler.getMessage("DFHPI9502E"));
                }
            }
        }
        this.wsrrProps = new Properties();
        propValue = this.p.getProperty(OPT_WSRR_USERNAME);
        if (propValue != null && (propValue = this.p.getProperty(OPT_WSRR_PASSWORD)) == null) {
            Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_WSRR_PASSWORD});
            throw new WSDLInvalidParamsException(MessageHandler.getMessage("DFHPI9502E"));
        }
        if (this.toolInUse == 0) {
            if (this.p.getProperty(OPT_WSRR_NAME) == null) {
                Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_WSRR_NAME});
                throw new WSDLInvalidParamsException(MessageHandler.getMessage("DFHPI9502E"));
            }
        } else if (this.toolInUse == 1) {
            propValue = this.p.getProperty(OPT_WSRR_DESCRIPTION);
            if (propValue != null) {
                this.wsrrProps.put(OPT_WSRR_DESCRIPTION, propValue);
            }
            if ((propValue = this.p.getProperty(OPT_WSRR_ENCODING)) != null) {
                this.wsrrProps.put(OPT_WSRR_ENCODING, propValue);
            }
            if ((propValue = this.p.getProperty(OPT_WSRR_LOCATION)) != null) {
                this.wsrrProps.put(OPT_WSRR_LOCATION, propValue);
            }
            Enumeration<Object> keys = this.p.keys();
            String aKey = EMPTY_STR;
            while (keys.hasMoreElements()) {
                aKey = (String)keys.nextElement();
                if (!aKey.startsWith(OPT_WSRR_PREFIX) || aKey.length() <= OPT_WSRR_PREFIX.length()) continue;
                propValue = this.p.get(aKey);
                this.wsrrProps.put(aKey.replaceFirst(OPT_WSRR_PREFIX, EMPTY_STR), propValue);
                this.p.remove(aKey);
            }
        }
    }

    private void logWSRRCustomParms() {
        if (this.wsrrProps == null) {
            return;
        }
        Enumeration<Object> keys = this.wsrrProps.keys();
        while (keys.hasMoreElements()) {
            Object name = keys.nextElement();
            if (((String)name).equals(OPT_WSRR_DESCRIPTION) || ((String)name).equals(OPT_WSRR_ENCODING)) continue;
            this.log.println(MessageHandler.buildMessage("DFHPI9818I", new Object[]{name, this.wsrrProps.get(name)}));
        }
    }

    public Properties getUserProperties() {
        return this.wsrrProps;
    }

    private boolean checkSSL(String truststore, String trustpwd, String keystore, String keypwd) {
        if (truststore == null && keystore == null) {
            return true;
        }
        if (truststore == null) {
            Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_SSL_TRUSTSTORE});
            return false;
        }
        if (keystore == null && keypwd != null) {
            Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_SSL_KEYSTORE});
            return false;
        }
        return true;
    }

    private void setSSL() {
        String truststoreProp = this.p.getProperty(OPT_SSL_TRUSTSTORE);
        String keystoreProp = this.p.getProperty(OPT_SSL_KEYSTORE);
        if (truststoreProp != null && truststoreProp.toLowerCase().startsWith("safkeyring://") || keystoreProp != null && keystoreProp.toLowerCase().startsWith("safkeyring://")) {
            System.setProperty("java.protocol.handler.pkgs", "com.ibm.crypto.provider");
            System.setProperty("javax.net.ssl.trustStoreType", "JCERACFKS");
            System.setProperty("javax.net.ssl.keyStoreType", "JCERACFKS");
        }
        if (truststoreProp != null) {
            System.setProperty("javax.net.ssl.trustStore", this.p.getProperty(OPT_SSL_TRUSTSTORE));
            truststoreProp = this.p.getProperty(OPT_SSL_TRUSTPWD);
            if (truststoreProp != null) {
                System.setProperty("javax.net.ssl.trustStorePassword", this.p.getProperty(OPT_SSL_TRUSTPWD));
            } else {
                System.setProperty("javax.net.ssl.trustStorePassword", "password");
            }
        }
        if (keystoreProp != null) {
            System.setProperty("javax.net.ssl.keyStore", this.p.getProperty(OPT_SSL_KEYSTORE));
            keystoreProp = this.p.getProperty(OPT_SSL_KEYPWD);
            if (keystoreProp != null) {
                System.setProperty("javax.net.ssl.keyStorePassword", this.p.getProperty(OPT_SSL_KEYPWD));
            } else {
                System.setProperty("javax.net.ssl.keyStorePassword", "password");
            }
        }
    }

    private boolean checkParametersCompatibleWithTool(Properties p, int currentTool) {
        boolean errors = false;
        for (ParameterRules PR : PARM_VALID_FOR_TOOL) {
            String inputValue;
            boolean worked = PR.validate(currentTool, inputValue = p.getProperty(PR.getParmName()));
            if (worked) continue;
            errors = true;
        }
        return !errors;
    }

    private boolean setProxy(String proxy) {
        boolean rc = true;
        if (proxy != null) {
            StringTokenizer t = new StringTokenizer(proxy, ":");
            if (t.countTokens() == 2) {
                String host = t.nextToken();
                String port = t.nextToken();
                Properties systemProps = System.getProperties();
                systemProps.setProperty("http.proxyHost", host);
                systemProps.setProperty("http.proxyPort", port);
                systemProps.setProperty("http.nonProxyHosts", "localhost");
                System.setProperties(systemProps);
            } else {
                Logging.writeMessage(8, "DFHPI9501E", null);
                rc = false;
            }
        }
        return rc;
    }

    private void setDefaults() {
        Logging.setPrintStream(null);
        if (this.toolInUse == 3 || this.toolInUse == 2) {
            return;
        }
        String programInterface = this.p.getProperty(OPT_PGMINT, OPT_VALUE_NOT_APPLIC);
        this.p.setProperty(OPT_PGMINT, programInterface);
        if (programInterface.equalsIgnoreCase(OPT_VALUE_CHANNEL)) {
            String programName;
            String contID = this.p.getProperty(OPT_CONTID, DEFAULT_CONTID);
            if (contID.equals(EMPTY_STR)) {
                contID = DEFAULT_CONTID;
            }
            if ((programName = this.p.getProperty(OPT_PGMNAME)) != null && !EMPTY_STR.equals(programName)) {
                this.p.setProperty(OPT_CONTID, contID);
            }
        }
        if (this.toolInUse == 1 || this.toolInUse == 4) {
            this.p.setProperty(OPT_STYLE, "DOCUMENT");
        }
    }

    private boolean checkWSDL(String wsdl, String wsdl_1_1, String wsdl_2_0) {
        if (this.toolInUse != 1 && this.toolInUse != 0) {
            return true;
        }
        if (!(wsdl != null && wsdl.length() != 0 || wsdl_1_1 != null && wsdl_1_1.length() != 0 || wsdl_2_0 != null && wsdl_2_0.length() != 0)) {
            Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_WSDL});
            return false;
        }
        if (wsdl != null && wsdl.length() > 0 && wsdl_1_1 != null && wsdl_1_1.length() > 0) {
            Logging.writeMessage(4, "DFHPI9626W", new Object[]{OPT_WSDL, OPT_WSDL_1_1});
            this.p.remove(OPT_WSDL);
        }
        if (this.toolInUse == 0 && wsdl_1_1 != null && wsdl_1_1.length() > 0) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_WSDL_1_1, TOOL_DFHWS2LS});
            this.p.remove(OPT_WSDL_1_1);
            return false;
        }
        if (this.toolInUse == 0 && wsdl_2_0 != null && wsdl_2_0.length() > 0) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_WSDL_2_0, TOOL_DFHWS2LS});
            this.p.remove(OPT_WSDL_2_0);
            return false;
        }
        if (this.toolInUse == 1 && wsdl_2_0 != null && wsdl_2_0.length() > 0 && (wsdl_1_1 != null && wsdl_1_1.length() > 0 && wsdl_1_1.equals(wsdl_2_0) || wsdl != null && wsdl.length() > 0 && wsdl.equals(wsdl_2_0))) {
            String badparm = OPT_WSDL;
            if (wsdl_1_1 != null && wsdl_1_1.length() > 0) {
                badparm = OPT_WSDL_1_1;
            }
            Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_WSDL_2_0, badparm});
            this.p.remove(OPT_WSDL_1_1);
            return false;
        }
        if (wsdl_2_0 != null && wsdl_2_0.length() > 0) {
            return this.checkMinRuntimeLevel_2_0(OPT_WSDL_2_0);
        }
        return true;
    }

    private boolean checkWSDLCP(String wsdlCP) {
        if (this.toolInUse != 1) {
            return true;
        }
        return this.checkCodePage(wsdlCP, OPT_WSDLCP);
    }

    private boolean checkXmlCP(String xmlCP) {
        if (this.toolInUse != 3 && this.toolInUse != 2) {
            return true;
        }
        return this.checkCodePage(xmlCP, OPT_XMLCP);
    }

    private boolean checkJSONSchemaCodepage(String jsonCP) {
        if (this.toolInUse != 4) {
            return true;
        }
        return this.checkCodePage(jsonCP, OPT_JSON_SCHEMA_CODEPAGE);
    }

    private boolean checkCodePage(String codePageValue, String parmToCheck) {
        boolean rc = true;
        if (codePageValue != null) {
            rc = false;
            for (int i = 0; !rc && i < VALID_WSDLCP_VALUES.length; ++i) {
                rc = VALID_WSDLCP_VALUES[i].equalsIgnoreCase(codePageValue);
            }
            if (!rc) {
                String validValuesStr = Util.join(VALID_WSDLCP_VALUES);
                Object[] messageParms = new Object[]{parmToCheck, validValuesStr};
                Logging.writeMessage(8, "DFHPI9664E", messageParms);
            }
        }
        return rc;
    }

    private boolean checkSchema(String schema) {
        String wsdl;
        if (this.toolInUse != 2) {
            return true;
        }
        if (EMPTY_STR.equals(schema)) {
            schema = null;
        }
        if (EMPTY_STR.equals(wsdl = this.p.getProperty(OPT_WSDL))) {
            wsdl = null;
        }
        if (wsdl == null && schema == null) {
            Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_SCHEMA});
            return false;
        }
        if (schema != null && wsdl != null) {
            Logging.writeMessage(4, "DFHPI9626W", new Object[]{OPT_WSDL, OPT_SCHEMA});
            this.p.remove(OPT_WSDL);
        }
        return true;
    }

    private boolean checkWSDLService(String wsdlService) {
        if (this.toolInUse == 1 && wsdlService != null) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_WSDL_SERVICE, TOOL_DFHLS2WS});
            return false;
        }
        return true;
    }

    private boolean checkOperations(String operations) {
        if (this.toolInUse != 0 && operations != null) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_OPERATIONS, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        this.operationNames = this.processListOption(operations);
        return true;
    }

    private boolean checkOperationName(String operation_name) {
        if (this.toolInUse != 1 && operation_name != null) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_OPERATION_NAME, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        return true;
    }

    private boolean checkElements(String elements) {
        String types = this.p.getProperty(OPT_TYPES);
        if ((elements == null || EMPTY_STR.equals(elements)) && types == null || EMPTY_STR.equals(types)) {
            elements = "ALL";
        }
        this.schemaElements = this.processListOption(elements);
        return true;
    }

    private boolean checkTypes(String types) {
        this.schemaTypes = this.processListOption(types);
        return true;
    }

    private List<String> processListOption(String listItems) {
        LinkedList<String> items = new LinkedList<String>();
        if (listItems != null) {
            StringTokenizer st = new StringTokenizer(listItems, ", ", false);
            while (st.hasMoreTokens()) {
                String item = st.nextToken();
                items.add(item);
            }
        }
        return items;
    }

    private boolean checkSoapVer(String soapVer) {
        if (this.toolInUse != 1 && soapVer != null) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_SOAPVER, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        if (soapVer == null) {
            if (this.p.getProperty(OPT_WSDL_1_1) != null || this.p.getProperty(OPT_WSDL) != null) {
                soapVer = OPT_VALUE_SOAP_1_1;
            }
            if (this.p.getProperty(OPT_WSDL_2_0) != null) {
                soapVer = soapVer != OPT_VALUE_SOAP_1_1 ? OPT_VALUE_SOAP_1_2 : "ALL";
            }
            if (soapVer == null) {
                soapVer = OPT_VALUE_SOAP_1_1;
            }
            this.p.setProperty(OPT_SOAPVER, soapVer);
        }
        if (!(soapVer.equals(OPT_VALUE_SOAP_1_1) || soapVer.equals(OPT_VALUE_SOAP_1_2) || soapVer.equals("ALL"))) {
            Logging.writeMessage(8, "DFHPI9633E", null);
            return false;
        }
        return true;
    }

    private boolean checkBinding(String binding) {
        boolean rc = true;
        if (this.toolInUse != 0 && binding != null) {
            if (binding.length() == 0) {
                return true;
            }
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_BINDING, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        if (binding != null && binding.length() == 0) {
            Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_BINDING});
            rc = false;
        }
        return rc;
    }

    private boolean checkLang(String language) {
        boolean rc = true;
        this.lang = Util.getLanguage(language);
        if (this.lang == -1 && !this.vendorBindFile) {
            Logging.writeMessage(8, "DFHPI9505E", null);
            rc = false;
        }
        if (this.lang == 7) {
            if (this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) {
                Logging.writePreFormattedMessage(4, "WARNING: PL/X is an experimental un-supported language option.");
            } else {
                Logging.writeMessage(8, "DFHPI9505E", null);
                rc = false;
            }
        }
        if (this.lang == 6 && MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel) && CodePageHelper.getCurrentCodePage().equals(CodePageHelper.UTF_16BE_CHARSET)) {
            Logging.writeMessage(8, "DFHPI9723E", null);
            rc = false;
        }
        return rc;
    }

    private boolean checkPgmName(String pgmName) {
        boolean rc = true;
        if (this.toolInUse != 1 && this.toolInUse != 0 && this.toolInUse != 4 && this.toolInUse != 5) {
            return true;
        }
        if (this.toolInUse == 4 || this.toolInUse == 5) {
            if (this.bundleSet) {
                if (pgmName != null) {
                    Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_PGMNAME});
                    return false;
                }
                return true;
            }
            if (this.toolInUse == 4 && pgmName == null) {
                Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_PGMNAME});
                return false;
            }
            if (this.toolInUse == 5 && pgmName == null && !this.bundleSet && !this.launchedUsingAPI) {
                Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_PGMNAME});
                return false;
            }
        }
        if (pgmName != null && !pgmName.equals(EMPTY_STR)) {
            Matcher m;
            if (pgmName.length() > 8) {
                Logging.writeMessage(8, "DFHPI9506E", new Object[]{OPT_PGMNAME, "8", pgmName});
                rc = false;
            }
            if (!(m = programNamePattern.matcher(pgmName)).matches()) {
                Logging.writeMessage(12, "DFHPI9509E", new Object[]{OPT_PGMNAME});
                return false;
            }
            this.p.setProperty(OPT_INTERNAL_PGMNAME, pgmName.toUpperCase(Locale.ENGLISH));
            pgmName = LangStruct.ensureValidXML(pgmName, new HashSet<String>(), false, ICM.XMLContentType.XML_ELEMENT, "ParmChecker", this.mappingLevel);
            this.p.setProperty(OPT_PGMNAME, pgmName.toUpperCase(Locale.ENGLISH));
        } else {
            if (this.toolInUse == 1 || this.toolInUse == 4) {
                Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_PGMNAME});
                rc = false;
            }
            this.p.setProperty(OPT_PGMNAME, ONE_CHAR_STRING);
        }
        return rc;
    }

    private boolean checkURI(String uri) {
        boolean rc = true;
        if (this.toolInUse != 1 && this.toolInUse != 0 && this.toolInUse != 4 && this.toolInUse != 5) {
            return true;
        }
        if ((this.toolInUse == 4 || this.toolInUse == 5) && this.bundleSet) {
            if (uri != null) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_URI});
                return false;
            }
            return true;
        }
        if (uri != null) {
            String pgmName = this.p.getProperty(OPT_PGMNAME);
            if (ONE_CHAR_STRING.equals(pgmName)) {
                Logging.writeMessage(4, "DFHPI9507W", new Object[]{OPT_PGMNAME, OPT_URI});
                this.p.setProperty(OPT_URI, ONE_CHAR_STRING);
                this.p.setProperty(OPT_URI_RELATIVE, ONE_CHAR_STRING);
                return rc;
            }
            try {
                String localURI = null;
                URI theURI = new URI(uri);
                if (theURI.isAbsolute()) {
                    String query;
                    this.p.setProperty(OPT_URI_ABSOLUTE, uri);
                    if (theURI.getScheme().toUpperCase(Locale.ENGLISH).equals("JMS") && (query = theURI.getQuery()) != null && query.indexOf(JMS_RELATIVE_URI_IDENTIFIER) > -1) {
                        int startIndex = query.indexOf(JMS_RELATIVE_URI_IDENTIFIER) + JMS_RELATIVE_URI_IDENTIFIER.length();
                        int endIndex = query.indexOf(38, startIndex);
                        if (endIndex == -1) {
                            endIndex = query.length();
                        }
                        localURI = query.substring(startIndex, endIndex);
                    }
                    if (localURI == null) {
                        localURI = theURI.getPath();
                    }
                } else {
                    localURI = uri;
                }
                if (localURI == null) {
                    localURI = ONE_CHAR_STRING;
                } else if (localURI.indexOf(47) != 0) {
                    localURI = "/" + localURI;
                }
                if (localURI.length() > 255) {
                    Logging.writeMessage(8, "DFHPI9506E", new Object[]{OPT_URI, "255", localURI});
                    return false;
                }
                this.p.setProperty(OPT_URI_RELATIVE, localURI);
            }
            catch (URISyntaxException e) {
                Logging.writeMessage(8, "DFHPI9632E", new Object[]{uri, e.getLocalizedMessage()});
                return false;
            }
            if (!Util.isValidURIChars(uri)) {
                Logging.writeMessage(8, "DFHPI9509E", new Object[]{OPT_URI});
                rc = false;
            }
        } else {
            this.p.setProperty(OPT_URI, ONE_CHAR_STRING);
            this.p.setProperty(OPT_URI_RELATIVE, ONE_CHAR_STRING);
        }
        return rc;
    }

    private boolean checkPgmInterface(String programInterface) {
        boolean rc = true;
        if (this.toolInUse == 3 || this.toolInUse == 2) {
            return rc;
        }
        if ((this.toolInUse == 4 || this.toolInUse == 5) && this.bundleSet) {
            if (programInterface != OPT_VALUE_NOT_APPLIC) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_PGMINT});
                return false;
            }
            return true;
        }
        String pgmName = this.p.getProperty(OPT_PGMNAME);
        if (ONE_CHAR_STRING.equals(pgmName)) {
            if (!programInterface.equalsIgnoreCase(OPT_VALUE_NOT_APPLIC)) {
                Logging.writeMessage(4, "DFHPI9507W", new Object[]{OPT_PGMNAME, OPT_PGMINT});
                this.p.setProperty(OPT_PGMINT, OPT_VALUE_NOT_APPLIC);
            }
        } else if (!programInterface.equalsIgnoreCase(OPT_VALUE_CHANNEL) && !programInterface.equalsIgnoreCase(OPT_VALUE_COMMAREA)) {
            Logging.writeMessage(4, "DFHPI9510W", null);
            this.p.setProperty(OPT_PGMINT, OPT_VALUE_CHANNEL);
            if ((this.p.getProperty(OPT_CONTID) == null || this.p.getProperty(OPT_CONTID).equals(EMPTY_STR)) && this.p.getProperty(OPT_REQUEST_CHANNEL) == null && this.p.getProperty(OPT_RESPONSE_CHANNEL) == null) {
                this.p.setProperty(OPT_CONTID, DEFAULT_CONTID);
                Logging.writeMessage(4, "DFHPI9511W", new Object[]{DEFAULT_CONTID});
            }
        }
        return rc;
    }

    private boolean checkContainerID(String pgmint, String contID) {
        boolean rc = true;
        if (this.toolInUse == 3 || this.toolInUse == 2) {
            return rc;
        }
        if ((this.toolInUse == 4 || this.toolInUse == 5) && this.bundleSet) {
            if (contID != null) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_CONTID});
                return false;
            }
            return true;
        }
        String pgmName = this.p.getProperty(OPT_PGMNAME);
        if (ONE_CHAR_STRING.equals(pgmName) && contID != null) {
            Logging.writeMessage(4, "DFHPI9507W", new Object[]{OPT_PGMNAME, OPT_CONTID});
            this.p.setProperty(OPT_CONTID, ONE_CHAR_STRING);
        }
        if (contID != null) {
            if (contID.length() > 16) {
                Logging.writeMessage(8, "DFHPI9506E", new Object[]{OPT_CONTID, "16", contID});
                rc = false;
            }
            if (!Util.isValidContainerName(contID)) {
                Logging.writeMessage(8, "DFHPI9509E", new Object[]{OPT_CONTID});
                rc = false;
            }
        }
        if (pgmint.equalsIgnoreCase(OPT_VALUE_COMMAREA)) {
            if (contID != null) {
                Logging.writeMessage(4, "DFHPI9512W", null);
            }
            this.p.put(OPT_CONTID, ONE_CHAR_STRING);
        }
        return rc;
    }

    private boolean checkWSBind(String wsbind) {
        boolean rc = true;
        if (this.toolInUse == 3 || this.toolInUse == 2) {
            return rc;
        }
        if ((this.toolInUse == 4 || this.toolInUse == 5) && this.bundleSet) {
            if (wsbind != null) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_WSBIND});
                return false;
            }
            return true;
        }
        return this.checkBindingFile(wsbind, "wsbind", OPT_WSBIND);
    }

    private boolean checkXSDBind(String xsdbind) {
        boolean rc = true;
        if (this.toolInUse != 3 && this.toolInUse != 2) {
            return rc;
        }
        return this.checkBindingFile(xsdbind, "xsdbind", OPT_XSDBIND);
    }

    private boolean checkBindingFile(String bindFileName, String defaultExtension, String parameterName) {
        boolean rc = true;
        if (bindFileName == null || EMPTY_STR.equals(bindFileName)) {
            Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_WSBIND});
            return false;
        }
        int endOfPCPath = bindFileName.lastIndexOf("\\");
        int endOfUnixPath = bindFileName.lastIndexOf("/");
        int endOfPath = endOfUnixPath > endOfPCPath ? endOfUnixPath + 1 : endOfPCPath + 1;
        String filename = bindFileName.substring(endOfPath);
        int extensionPos = filename.lastIndexOf(46) + 1;
        if (extensionPos == 0) {
            bindFileName = bindFileName + "." + defaultExtension;
            this.p.setProperty(parameterName, bindFileName);
            Logging.writeMessage(4, "DFHPI9513W", new String[]{parameterName, "." + defaultExtension});
        } else {
            String extension = filename.substring(extensionPos);
            if (!extension.toUpperCase(Locale.ENGLISH).equals(defaultExtension.toUpperCase(Locale.ENGLISH))) {
                Logging.writeMessage(4, "DFHPI9514W", new String[]{parameterName, "." + defaultExtension});
            }
            filename = filename.substring(0, extensionPos - 1);
        }
        if (filename.length() > 32) {
            Logging.writeMessage(8, "DFHPI9506E", new Object[]{parameterName, 32, filename});
            rc = false;
        }
        return rc;
    }

    private boolean checkPdslib(String pdsLib) {
        boolean rc = true;
        if (this.vendorBindFile) {
            this.usePDSFiles = false;
            return true;
        }
        if ((this.toolInUse == 1 || this.toolInUse == 4 && this.p.getProperty(OPT_BUNDLE) == null) && this.p.getProperty(OPT_REQMEM) == null && this.p.getProperty(OPT_RESPMEM) == null) {
            return true;
        }
        if (pdsLib == null || pdsLib.length() == 0) {
            Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_PDSLIB});
            rc = false;
            this.usePDSFiles = false;
        } else if (this.usePDSFiles) {
            try {
                File tmp = new File(pdsLib);
                if (tmp.exists()) {
                    this.usePDSFiles = false;
                } else if (!PDSAccessor.checkPDSAccessPossible()) {
                    this.usePDSFiles = false;
                } else {
                    pdsLib = PDSAccessor.prepareLibraryNameForJZOS(pdsLib);
                    this.p.setProperty(OPT_PDSLIB, pdsLib);
                    if (this.toolInUse == 1 || this.toolInUse == 3 || this.toolInUse == 4) {
                        rc = PDSAccessor.checkPDSReadPermission(pdsLib);
                    } else if (this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) {
                        rc = PDSAccessor.checkPDSReadWritePermission(pdsLib);
                    }
                }
            }
            catch (NoClassDefFoundError ncdfe) {
                this.usePDSFiles = false;
            }
        }
        return rc;
    }

    private boolean checkPdsCp(String codepage) {
        if (codepage == null) {
            return true;
        }
        if (codepage.equals(EMPTY_STR)) {
            this.p.remove(OPT_PDSCP);
            return true;
        }
        try {
            new String(new byte[0], 0, 0, codepage);
        }
        catch (UnsupportedEncodingException usee) {
            Logging.writeMessage(12, "DFHPI9519E", new Object[]{codepage});
            return false;
        }
        return true;
    }

    private boolean checkMinRuntimeLevel(String minRuntimeLevel) throws CICSWSDLException {
        if (minRuntimeLevel == null || minRuntimeLevel.equals(EMPTY_STR)) {
            this.wsBindVerNumber = this.toolInUse == 0 || this.toolInUse == 1 || this.toolInUse == 5 || this.toolInUse == 4 ? (byte)0 : (byte)6;
            this.minimumRuntimeIsSet = false;
            this.p.put(OPT_MINIMUM_RUNTIME_LEVEL, OPT_VALUE_MINIMUM);
            return true;
        }
        if (minRuntimeLevel.equalsIgnoreCase(OPT_VALUE_MINIMUM)) {
            this.wsBindVerNumber = this.toolInUse == 0 || this.toolInUse == 1 ? (byte)0 : (byte)6;
            this.minimumRuntimeIsSet = false;
        } else if (minRuntimeLevel.equalsIgnoreCase(OPT_VALUE_CURRENT)) {
            this.wsBindVerNumber = WSBind.getWSBindMajorVersionNumberToUse(this.getMappingLevel(MOST_RECENT_MAPPING_LEVEL));
            this.minimumRuntimeIsSet = true;
        } else {
            int runtimeLevel = this.getMappingLevel(minRuntimeLevel);
            if (runtimeLevel == -1 || runtimeLevel == 13 && (this.p.getProperty(OPT_ZOS_CONNECT_EE) == null || this.p.getProperty(OPT_ZOS_CONNECT_EE) != null && !this.p.getProperty(OPT_ZOS_CONNECT_EE).equalsIgnoreCase("true"))) {
                Logging.writeMessage(12, "DFHPI9627E", new Object[]{minRuntimeLevel});
                return false;
            }
            this.wsBindVerNumber = WSBind.getWSBindMajorVersionNumberToUse(runtimeLevel);
            if (!(this.toolInUse != 2 && this.toolInUse != 3 || RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.wsBindVerNumber))) {
                Logging.writeMessage(12, "DFHPI9627E", new Object[]{minRuntimeLevel});
                return false;
            }
            this.minimumRuntimeIsSet = true;
        }
        return true;
    }

    private int getMappingLevel(String mappingLevelStr) {
        int mappingLevelInt = -1;
        mappingLevelInt = mappingLevelStr.equals("1") || mappingLevelStr.equals("1.0") ? 3 : (mappingLevelStr.equals(OPT_VALUE_SOAP_1_1) ? 2 : (mappingLevelStr.equals(OPT_VALUE_SOAP_1_2) ? 4 : (mappingLevelStr.equals("2") || mappingLevelStr.equals("2.0") ? 1 : (mappingLevelStr.equals("2.1") ? 5 : (mappingLevelStr.equals("2.2") ? 6 : (mappingLevelStr.equals("3") || mappingLevelStr.equals("3.0") ? 7 : (mappingLevelStr.equals("4") || mappingLevelStr.equals("4.0") ? 8 : (mappingLevelStr.equals("4.1") ? 9 : (mappingLevelStr.equals("4.2") ? 10 : (mappingLevelStr.equals(MOST_RECENT_MAPPING_LEVEL) ? 11 : (mappingLevelStr.equals("5.0") ? 13 : -1)))))))))));
        return mappingLevelInt;
    }

    private boolean checkMappingLevel(String mappingLevelStr) throws CICSWSDLException {
        if (this.vendorBindFile) {
            this.mappingLevel = 0;
            return true;
        }
        if (this.toolInUse == 2 && mappingLevelStr == null) {
            Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_MAPPING_LEVEL});
            return false;
        }
        if (mappingLevelStr == null || mappingLevelStr.equals(EMPTY_STR)) {
            this.mappingLevel = 0;
            Logging.writeMessage(1, "DFHPI9614I", new Object[]{"1.0", MOST_RECENT_MAPPING_LEVEL});
            this.p.put(OPT_MAPPING_LEVEL, ICM.MAPPING_LEVELS[3]);
            return true;
        }
        this.mappingLevel = this.getMappingLevel(mappingLevelStr);
        if (this.mappingLevel == 13 && (this.p.getProperty(OPT_ZOS_CONNECT_EE) == null || this.p.getProperty(OPT_ZOS_CONNECT_EE) != null && !this.p.getProperty(OPT_ZOS_CONNECT_EE).equalsIgnoreCase("true"))) {
            Logging.writeMessage(12, "DFHPI9613E", new Object[]{mappingLevelStr});
            return false;
        }
        if (this.mappingLevel != this.getMappingLevel(MOST_RECENT_MAPPING_LEVEL) && this.mappingLevel != 13) {
            Logging.writeMessage(1, "DFHPI9614I", new Object[]{mappingLevelStr, MOST_RECENT_MAPPING_LEVEL});
        }
        if (this.mappingLevel == -1) {
            Logging.writeMessage(12, "DFHPI9613E", new Object[]{mappingLevelStr});
            this.mappingLevel = 0;
            return false;
        }
        if (!this.minimumRuntimeIsSet) {
            byte tmp = WSBind.getWSBindMajorVersionNumberToUse(this.mappingLevel);
            if (this.wsBindVerNumber < tmp) {
                this.wsBindVerNumber = tmp;
            }
        } else {
            boolean runtimeMismatch = false;
            if (this.mappingLevel == 2 && this.wsBindVerNumber == 0) {
                runtimeMismatch = true;
            } else if (this.mappingLevel == 4 && (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1)) {
                runtimeMismatch = true;
            } else if (this.mappingLevel == 1 && (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1 || this.wsBindVerNumber == 2)) {
                runtimeMismatch = true;
            } else if (this.mappingLevel == 5 && (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1 || this.wsBindVerNumber == 2 || this.wsBindVerNumber == 3)) {
                runtimeMismatch = true;
            } else if (this.mappingLevel == 6 && (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1 || this.wsBindVerNumber == 2 || this.wsBindVerNumber == 3 || this.wsBindVerNumber == 4)) {
                runtimeMismatch = true;
            } else if (this.mappingLevel == 7 && (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1 || this.wsBindVerNumber == 2 || this.wsBindVerNumber == 3 || this.wsBindVerNumber == 4 || this.wsBindVerNumber == 5)) {
                runtimeMismatch = true;
            } else if (this.mappingLevel == 8 && (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1 || this.wsBindVerNumber == 2 || this.wsBindVerNumber == 3 || this.wsBindVerNumber == 4 || this.wsBindVerNumber == 5 || this.wsBindVerNumber == 6)) {
                runtimeMismatch = true;
            } else if (this.mappingLevel == 9 && (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1 || this.wsBindVerNumber == 2 || this.wsBindVerNumber == 3 || this.wsBindVerNumber == 4 || this.wsBindVerNumber == 5 || this.wsBindVerNumber == 6 || this.wsBindVerNumber == 7)) {
                runtimeMismatch = true;
            } else if (this.mappingLevel == 10 && (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1 || this.wsBindVerNumber == 2 || this.wsBindVerNumber == 3 || this.wsBindVerNumber == 4 || this.wsBindVerNumber == 5 || this.wsBindVerNumber == 6 || this.wsBindVerNumber == 7 || this.wsBindVerNumber == 8)) {
                runtimeMismatch = true;
            } else if (this.mappingLevel == 11 && (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1 || this.wsBindVerNumber == 2 || this.wsBindVerNumber == 3 || this.wsBindVerNumber == 4 || this.wsBindVerNumber == 5 || this.wsBindVerNumber == 6 || this.wsBindVerNumber == 7 || this.wsBindVerNumber == 8 || this.wsBindVerNumber == 9)) {
                runtimeMismatch = true;
            } else if (this.mappingLevel == 12 && (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1 || this.wsBindVerNumber == 2 || this.wsBindVerNumber == 3 || this.wsBindVerNumber == 4 || this.wsBindVerNumber == 5 || this.wsBindVerNumber == 6 || this.wsBindVerNumber == 7 || this.wsBindVerNumber == 8 || this.wsBindVerNumber == 9 || this.wsBindVerNumber == 10)) {
                runtimeMismatch = true;
            } else if (this.mappingLevel == 13 && (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1 || this.wsBindVerNumber == 2 || this.wsBindVerNumber == 3 || this.wsBindVerNumber == 4 || this.wsBindVerNumber == 5 || this.wsBindVerNumber == 6 || this.wsBindVerNumber == 7 || this.wsBindVerNumber == 8 || this.wsBindVerNumber == 9 || this.wsBindVerNumber == 10 || this.wsBindVerNumber == 11)) {
                runtimeMismatch = true;
            }
            if (runtimeMismatch) {
                Logging.writeMessage(12, "DFHPI9628E", new Object[]{"MAPPING-LEVEL=" + mappingLevelStr});
                return false;
            }
        }
        if (MappingLevelHelper.supportsMappingLevel_2(this.mappingLevel)) {
            this.levelIncrementSize = 3;
        }
        return true;
    }

    private boolean checkMappingOverrides(String mappingOverrides) {
        boolean allParameterArgsValid = true;
        if (mappingOverrides == null || mappingOverrides.equalsIgnoreCase(EMPTY_STR)) {
            if (this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) {
                this.p.put(OPT_SAME_AS_MAPPING_LEVEL, OPT_VALUE_YES);
            }
        } else {
            if (this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) {
                this.p.put(OPT_SAME_AS_MAPPING_LEVEL, OPT_VALUE_NO);
            }
            if (this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) {
                this.p.put(OPT_UNDERSCORES_AS_HYPHENS, OPT_VALUE_NO);
            }
            if (this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) {
                if (!MappingLevelHelper.supportsMappingLevel_4_2(this.mappingLevel)) {
                    this.p.put(OPT_VALUE_LESS_DUP_NAMES, OPT_VALUE_NO);
                } else {
                    this.p.put(OPT_VALUE_LESS_DUP_NAMES, OPT_VALUE_YES);
                }
            }
            if (this.toolInUse == 5) {
                this.p.put(OPT_JSON_INTEGER_AS_PIC9, OPT_VALUE_NO);
            }
            if (this.toolInUse == 0 || this.toolInUse == 2) {
                this.p.put(OPT_NO_ARRAY_NAME_INDEXING, OPT_VALUE_NO);
            }
            if (this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) {
                this.p.put(OPT_HYPHENS_AS_UNDERSCORES, OPT_VALUE_NO);
            }
            int parmNumber = 0;
            StringTokenizer st = new StringTokenizer(mappingOverrides.toUpperCase(Locale.ENGLISH), ",", false);
            while (st.hasMoreTokens()) {
                String LANG2;
                Object[] messageParms;
                String token = st.nextToken();
                if (token.indexOf(OPT_SAME_AS_MAPPING_LEVEL) > -1) {
                    this.p.put(OPT_SAME_AS_MAPPING_LEVEL, OPT_VALUE_YES);
                    if (parmNumber > 0 || st.hasMoreTokens()) {
                        allParameterArgsValid = false;
                        messageParms = new Object[]{OPT_MAPPING_OVERRIDES, Util.join(VALID_MAPPING_OVERRIDES_VALUES) + ". (" + OPT_SAME_AS_MAPPING_LEVEL + " must be exclusive)"};
                        Logging.writeMessage(8, "DFHPI9664E", messageParms);
                    }
                } else if (token.indexOf(OPT_UNDERSCORES_AS_HYPHENS) > -1) {
                    this.p.put(OPT_UNDERSCORES_AS_HYPHENS, OPT_VALUE_YES);
                    LANG2 = (String)this.p.get(OPT_LANG);
                    if (LANG2 != null && !LANG2.equalsIgnoreCase(OPT_VALUE_COBOL)) {
                        allParameterArgsValid = false;
                        Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_UNDERSCORES_AS_HYPHENS, OPT_LANG});
                    }
                } else if (token.indexOf(OPT_VALUE_LESS_DUP_NAMES) > -1) {
                    this.p.put(OPT_VALUE_LESS_DUP_NAMES, OPT_VALUE_YES);
                } else if (token.indexOf(OPT_JSON_INTEGER_AS_PIC9) > -1) {
                    this.p.put(OPT_JSON_INTEGER_AS_PIC9, OPT_VALUE_YES);
                } else if (token.indexOf(OPT_NO_ARRAY_NAME_INDEXING) > -1) {
                    this.p.put(OPT_NO_ARRAY_NAME_INDEXING, OPT_VALUE_YES);
                } else if (token.indexOf(OPT_HYPHENS_AS_UNDERSCORES) > -1) {
                    this.p.put(OPT_HYPHENS_AS_UNDERSCORES, OPT_VALUE_YES);
                    LANG2 = (String)this.p.get(OPT_LANG);
                    if (LANG2 != null && !LANG2.equalsIgnoreCase(OPT_VALUE_PLI_ENTERPRISE) && !LANG2.equalsIgnoreCase(OPT_VALUE_PLI_OTHER)) {
                        allParameterArgsValid = false;
                        Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_HYPHENS_AS_UNDERSCORES, OPT_LANG});
                    }
                } else {
                    allParameterArgsValid = false;
                    messageParms = new Object[]{OPT_MAPPING_OVERRIDES, Util.join(VALID_MAPPING_OVERRIDES_VALUES) + ". (" + OPT_SAME_AS_MAPPING_LEVEL + " must be exclusive)"};
                    Logging.writeMessage(8, "DFHPI9664E", messageParms);
                }
                ++parmNumber;
            }
        }
        return allParameterArgsValid;
    }

    private boolean checkReqmem(String reqMem, String reqCDD) {
        if (this.toolInUse == 3 || this.toolInUse == 2) {
            return true;
        }
        if (this.toolInUse == 4 || this.toolInUse == 5) {
            if (!this.bundleSet) {
                if (this.p.getProperty(OPT_JSON_SCHEMA_RESTFUL) != null) {
                    if (reqMem != null) {
                        Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_JSON_SCHEMA_RESTFUL, OPT_REQMEM});
                        return false;
                    }
                } else if (reqMem == null & reqCDD == null) {
                    Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_REQMEM});
                    return false;
                }
            } else if (reqMem != null) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_REQMEM});
                return false;
            }
        }
        return this.checkPDSMemberName(reqMem, OPT_REQMEM);
    }

    private boolean checkRespmem(String respMem, String respCDD) {
        if (this.toolInUse == 3 || this.toolInUse == 2) {
            return true;
        }
        if (this.toolInUse == 4 || this.toolInUse == 5) {
            if (!this.bundleSet) {
                if (this.p.getProperty(OPT_JSON_SCHEMA_RESTFUL) != null) {
                    if (respMem != null) {
                        Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_JSON_SCHEMA_RESTFUL, OPT_RESPMEM});
                        return false;
                    }
                } else if (respMem == null && respCDD == null) {
                    Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_RESPMEM});
                    return false;
                }
            } else if (respMem != null) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_RESPMEM});
                return false;
            }
        }
        return this.checkPDSMemberName(respMem, OPT_RESPMEM);
    }

    private boolean checkPdsmem(String pdsMem) {
        if (this.toolInUse == 1 || this.toolInUse == 0) {
            return true;
        }
        if (this.toolInUse == 5 || this.toolInUse == 4) {
            if (this.bundleSet) {
                if (pdsMem == null) {
                    Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_PDSMEM});
                    return false;
                }
            } else if (this.p.getProperty(OPT_JSON_SCHEMA_RESTFUL) != null) {
                if (pdsMem == null) {
                    Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_PDSMEM});
                    return false;
                }
            } else if (pdsMem != null) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_JSON_SCHEMA_REQUEST, OPT_PDSMEM});
                return false;
            }
        }
        return this.checkPDSMemberName(pdsMem, OPT_PDSMEM);
    }

    private boolean checkPDSMemberName(String memberName, String parmName) {
        boolean rc = true;
        if ((this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) && (memberName != null && memberName.length() == 0 || memberName == null && !this.vendorBindFile && this.toolInUse == 2)) {
            Logging.writeMessage(8, "DFHPI9503E", new Object[]{parmName});
            rc = false;
        }
        if (memberName != null) {
            int maxChars = this.toolInUse == 1 || this.toolInUse == 3 || this.toolInUse == 4 ? 8 : 6;
            if (memberName.length() > maxChars) {
                int ext;
                int respMemLen = memberName.length();
                String name = null;
                if (!this.usePDSFiles && (ext = memberName.lastIndexOf(".")) != -1) {
                    name = memberName.substring(0, ext);
                    respMemLen = name.length();
                }
                if (respMemLen > maxChars && (this.toolInUse != 3 && this.toolInUse != 1 && this.toolInUse != 4 || this.usePDSFiles)) {
                    Logging.writeMessage(8, "DFHPI9506E", new Object[]{parmName, maxChars, name});
                    rc = false;
                }
            }
        }
        if (this.usePDSFiles && memberName != null) {
            if (this.toolInUse == 1 || this.toolInUse == 3 || this.toolInUse == 4) {
                if (!this.checkPDSFileforBottomUp(memberName)) {
                    rc = false;
                }
            } else if (!this.checkPDSFileforTopDown(memberName)) {
                rc = false;
            }
        }
        return rc;
    }

    private boolean checkReqAndRespDifferent(String req, String resp) {
        boolean rc = true;
        if ((this.toolInUse == 0 || this.toolInUse == 5) && req != null && resp != null && req.equalsIgnoreCase(resp)) {
            Logging.writeMessage(12, "DFHPI9520E", null);
            rc = false;
        }
        return rc;
    }

    private boolean checkRequestAndResponseChannel(String reqCha, String respCha) {
        if (reqCha == null && respCha == null) {
            return true;
        }
        String oldParm = null;
        if (this.p.getProperty(OPT_REQMEM) != null) {
            oldParm = OPT_REQMEM;
        }
        if (oldParm == null && this.p.getProperty(OPT_RESPMEM) != null) {
            oldParm = OPT_RESPMEM;
        }
        String newParm = null;
        if (reqCha != null) {
            newParm = OPT_REQUEST_CHANNEL;
        }
        if (newParm == null) {
            newParm = OPT_RESPONSE_CHANNEL;
        }
        if (this.toolInUse == 4 && this.bundleSet) {
            boolean rc = true;
            if (reqCha != null) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_REQUEST_CHANNEL});
                rc = false;
            }
            if (respCha != null) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_RESPONSE_CHANNEL});
                rc = false;
            }
            return rc;
        }
        if (oldParm != null) {
            Logging.writeMessage(4, "DFHPI9626W", new Object[]{newParm, oldParm});
            this.p.remove(OPT_REQUEST_CHANNEL);
            this.p.remove(OPT_RESPONSE_CHANNEL);
            return true;
        }
        if (!OPT_VALUE_CHANNEL.equals(this.p.getProperty(OPT_PGMINT))) {
            Logging.writeMessage(4, "DFHPI9626W", new Object[]{newParm, "PGMINT=COMMAREA"});
            this.p.remove(OPT_REQUEST_CHANNEL);
            this.p.remove(OPT_RESPONSE_CHANNEL);
            return true;
        }
        if (!MappingLevelHelper.supportsMappingLevel_3_0(this.mappingLevel)) {
            Logging.writeMessage(12, "DFHPI9619E", new Object[]{newParm, ICM.MAPPING_LEVELS[this.mappingLevel]});
            return false;
        }
        if (this.p.getProperty(OPT_CONTID) != null && !DEFAULT_CONTID.equals(this.p.getProperty(OPT_CONTID))) {
            Logging.writeMessage(4, "DFHPI9626W", new Object[]{OPT_CONTID, newParm});
        }
        this.p.put(OPT_CONTID, "not-applicable");
        return true;
    }

    private boolean checkPDSFileforBottomUp(String file) {
        boolean rc = true;
        String libname = this.p.getProperty(OPT_PDSLIB);
        String filename = libname.substring(0, libname.length() - 1) + "(" + file + ")'";
        try {
            rc = PDSAccessor.checkPDSMemberReadPermission(filename);
        }
        catch (Exception e) {
            Logging.writeMessage(12, "DFHPI9523E", new Object[]{filename, e.toString()});
            e.printStackTrace(Logging.getPrintStream());
            rc = false;
        }
        return rc;
    }

    private boolean checkPDSFileforTopDown(String file) {
        boolean rc = true;
        String libname = this.p.getProperty(OPT_PDSLIB);
        String filename = libname.substring(0, libname.length() - 1) + "(" + file + ")'";
        try {
            rc = PDSAccessor.checkPDSMemberWritePermission(filename);
        }
        catch (Exception e) {
            Logging.writeMessage(12, "DFHPI9523E", new Object[]{filename, e.toString()});
            e.printStackTrace(Logging.getPrintStream());
            rc = false;
        }
        return rc;
    }

    private boolean checkLogfile(String logFile) {
        boolean rc = true;
        if (logFile == null || logFile.length() == 0) {
            Logging.writeMessage(12, "DFHPI9503E", new Object[]{OPT_LOGFILE});
            return false;
        }
        File f = new File(logFile);
        if (f.isDirectory()) {
            Logging.writeMessage(12, "DFHPI9523E", new Object[]{f, "The specified Log File is a Directory"});
            return false;
        }
        if (!f.getParentFile().exists()) {
            Logging.writeMessage(12, "DFHPI9525E", new Object[]{f.getParentFile()});
            return false;
        }
        if (!f.getParentFile().canWrite()) {
            Logging.writeMessage(12, "DFHPI9526E", new Object[]{f.getParentFile()});
            return false;
        }
        if (f.exists() && !f.canWrite()) {
            Logging.writeMessage(12, "DFHPI9527E", new Object[]{logFile});
            return false;
        }
        return rc;
    }

    private boolean checkService(String service) {
        this.timestampedLog = false;
        this.specifyEncoding = false;
        if (service != null) {
            StringTokenizer st = new StringTokenizer(service, ",=\"", false);
            while (st.hasMoreTokens()) {
                String value;
                String token = st.nextToken();
                if (token.indexOf(OPT_VALUE_SERVICE_TIMESTAMPS) > -1) {
                    this.timestampedLog = true;
                }
                if (token.indexOf(OPT_VALUE_SERVICE_LEVELINC) > -1) {
                    value = st.nextToken();
                    this.levelIncrementSize = Integer.parseInt(value);
                }
                if (token.indexOf(OPT_VALUE_SERVICE_SPECIFY_ENCODING) > -1) {
                    this.specifyEncoding = true;
                }
                if (token.indexOf(OPT_VALUE_SERVICE_BOOTSTRAP_ICM) > -1) {
                    this.bootStrapICM = value = st.nextToken();
                }
                if (token.indexOf(OPT_VALUE_SERVICE_ICM_INTERCEPTOR) <= -1) continue;
                value = st.nextToken();
                try {
                    this.interceptor = (ICMInterceptor)Thread.currentThread().getContextClassLoader().loadClass(value).newInstance();
                }
                catch (Exception e) {
                    RuntimeException re = new RuntimeException("Problem encountered loading an ICMInterceptor class");
                    re.initCause(e);
                    throw re;
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties readFile(String paramsFile) throws CICSWSDLException {
        this.p = new Properties();
        try {
            boolean deleted;
            File inputFile = new File(paramsFile);
            if (!inputFile.exists() || !inputFile.canRead()) {
                Logging.writeMessage(12, "DFHPI9528E", new Object[]{inputFile.getName()});
            }
            FileInputStream fis = new FileInputStream(inputFile);
            InputStreamReader isr = !this.usePDSFiles ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, "Cp037");
            String normalized = this.formatParamsFile(isr);
            ByteArrayInputStream in = new ByteArrayInputStream(normalized.getBytes("ISO8859-1"));
            this.p.load(in);
            isr.close();
            fis.close();
            if (this.usePDSFiles && (deleted = inputFile.delete())) return this.p;
        }
        catch (IOException e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{paramsFile, e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        return this.p;
    }

    private String formatParamsFile(Reader fr) throws IOException {
        String thisLine = null;
        String savedLine = EMPTY_STR;
        BufferedReader in = new BufferedReader(fr);
        StringWriter out = new StringWriter();
        while ((thisLine = in.readLine()) != null) {
            if ((thisLine = thisLine.trim()).length() > 72) {
                Logging.writeMessage(4, "DFHPI9529W", new Object[]{72, thisLine});
                thisLine = savedLine + thisLine.substring(0, 72).trim();
            } else {
                thisLine = savedLine + thisLine.trim();
            }
            savedLine = thisLine.endsWith("*") ? thisLine.substring(0, thisLine.length() - 1) : EMPTY_STR;
            if (thisLine.endsWith(",")) {
                thisLine = thisLine.substring(0, thisLine.length() - 1);
            }
            out.write(thisLine + LINE_SEPARATOR);
        }
        return out.toString();
    }

    private void logParams(Date timestamp, String logFile) throws CICSWSDLException {
        try {
            BufferedOutputStream buf = new BufferedOutputStream(new ErrorReportingFileOutputStream(logFile));
            PrintStream ps = null;
            ps = this.timestampedLog ? new TimeStampedPrintStream(buf) : new PrintStream(buf);
            Logging.setPrintStream(ps);
        }
        catch (FileNotFoundException e) {
            Logging.handleExc(e);
        }
        this.log = Logging.getPrintStream();
        this.log.println("Log file from: " + TOOL_NAMES[this.toolInUse]);
        if (this.toolInUse == 1 || this.toolInUse == 0) {
            this.log.println("WSBind file: " + this.p.getProperty(OPT_WSBIND));
            StringBuilder minor_bind_version_buffer = new StringBuilder(EMPTY_STR);
            for (int i = 0; i < WSBind.getWSBindMinorVersionNumberToUse(this.wsBindVerNumber).length; ++i) {
                minor_bind_version_buffer.append(WSBind.getWSBindMinorVersionNumberToUse(this.wsBindVerNumber)[i]);
            }
            String minor_bind_version = minor_bind_version_buffer.toString();
            if (!this.vendorBindFile) {
                this.log.println("WSBind version: 1." + this.wsBindVerNumber + "." + minor_bind_version);
            }
        } else {
            this.log.println("XSDBind file: " + this.p.getProperty(OPT_XSDBIND));
        }
        if (!this.vendorBindFile) {
            if (this.mappingLevel != -1) {
                this.log.println("Mapping level: " + ICM.MAPPING_LEVELS_FOR_DISPLAY[this.mappingLevel]);
            } else {
                this.log.println("Mapping level: UNKNOWN");
            }
        } else {
            this.log.println("WSBind/XSDBind version: VENDOR");
            this.log.println("Mapping Level: VENDOR");
        }
        if (this.toolInUse == 1 || this.toolInUse == 0) {
            boolean providerMode;
            String pgmName = this.p.getProperty(OPT_PGMNAME);
            boolean bl = providerMode = pgmName != null && !pgmName.equals(EMPTY_STR) && !pgmName.equals(ONE_CHAR_STRING);
            if (providerMode) {
                this.log.println("Mode: Provider");
            } else {
                this.log.println("Mode: Requester");
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy HH:mm");
        this.log.println("Created: " + sdf.format(timestamp));
        this.log.println("Release: " + BUILD_LEVEL_RELEASE);
        this.log.println("Build-Level: " + BUILD_LEVEL_NAME);
        this.log.println("Platform: " + System.getProperty("os.name") + " version " + System.getProperty("os.version") + "  (architecture " + System.getProperty("os.arch") + ")");
        if (System.getProperty("os.name").startsWith("Mac")) {
            this.log.println("Java version: " + System.getProperty("java.runtime.version"));
        } else {
            this.log.println("Java version: " + System.getProperty("java.fullversion"));
        }
        this.log.println("Target Platform: " + this.platform);
        this.log.println("--------------------------");
        this.log.println(ONE_CHAR_STRING);
        for (ParameterRules PR : PARM_VALID_FOR_TOOL) {
            String lang;
            String name = PR.getParmName();
            boolean dontShow = !PR.parmValid(this.toolInUse);
            Object propValue = this.p.get(name);
            if (propValue != null && PR.getSuppressValue()) {
                propValue = SUPPRESSED_VALUE;
            }
            if (name.equals(OPT_PGMINT) && OPT_VALUE_NOT_APPLIC.equals(this.p.getProperty(name))) {
                dontShow = true;
            }
            if (!MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel) && (name.equals(OPT_CHAR_MULTIPLIER) || name.equals(OPT_CHAR_VARYING) || name.equals(OPT_CHAR_VARYING_LIMIT) || name.equals(OPT_DEFAULT_CHAR_MAXLENGTH))) {
                dontShow = true;
            }
            if (!MappingLevelHelper.supportsMappingLevel_2_1(this.mappingLevel) && (name.equals(OPT_INLINE_MAXOCCURS_LIMIT) || name.equals(OPT_XML_ONLY))) {
                dontShow = true;
            }
            if (!MappingLevelHelper.supportsMappingLevel_3_0(this.mappingLevel) && (name.equals(OPT_WSADDR_EPR_ANY) || name.equals(OPT_DATETIME) || name.equals(OPT_DATA_TRUNCATION))) {
                dontShow = true;
            }
            if (!MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel) && name.equals(OPT_CHAR_OCCURS)) {
                dontShow = true;
            }
            if (!MappingLevelHelper.supportsMappingLevel_4_1(this.mappingLevel) && (name.equals(OPT_TRUNCATE_NULL_ARRAYS) || name.equals(OPT_TRUNCATE_NULL_ARRAY_VALUES))) {
                dontShow = true;
            }
            if (!MappingLevelHelper.supportsMappingLevel_4_2(this.mappingLevel) && (name.equals(OPT_ADDITIONAL_PROPERTIES_DEFAULT) || name.equals(OPT_ADDITIONAL_PROPERTIES_MAX) || name.equals(OPT_ADDITIONAL_PROPERTIES_SIZE))) {
                dontShow = true;
            }
            if (!MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                if (name.equals(OPT_ZOS_CONNECT_EE)) {
                    dontShow = true;
                }
                if (name.equals(OPT_CONTAINER_NAME_SUFFIX)) {
                    dontShow = true;
                }
            }
            if ((lang = this.p.getProperty(OPT_LANG)) != null && lang.equalsIgnoreCase(OPT_VALUE_PLI_ENTERPRISE) && name.equals(OPT_CHAR_VARYING) && (this.toolInUse == 1 || this.toolInUse == 3)) {
                dontShow = true;
            }
            if (!(dontShow || name.equals("*/") || name.equals(OPT_ALLOW_NON_EBCDIC) || name.equals(OPT_DISABLE_CONTAINERS) || name.equals(OPT_REQUEST_STRUCT) || name.equals(OPT_RESPONSE_STRUCT) || name.equals(OPT_STYLE) || name.equals(OPT_INTERNAL_PGMNAME) || name.equals(OPT_INTERNAL_TOOLNAME) || name.equals(OPT_VENDOR_CONV_NAME) || name.equals(OPT_VENDOR_INTF_LENGTH) || name.equals(OPT_VENDOR_META_DATA) || name.equals(OPT_URI_ABSOLUTE) || name.equals(OPT_URI_RELATIVE) || name.equals(OPT_SERVICE))) {
                Logging.writeMessage(1, "DFHPI9609I", new Object[]{name, propValue});
                continue;
            }
            this.log.println(MessageHandler.buildMessage("DFHPI9609I", new Object[]{name, propValue}));
        }
        this.logWSRRCustomParms();
        if (this.metaData != null) {
            this.log.println(MessageHandler.buildMessage("DFHPI9609I", new Object[]{"VENDOR-META-DATA Length", Integer.toString(this.metaData.length)}));
        }
        Enumeration<Object> keys = this.p.keys();
        while (keys.hasMoreElements()) {
            Object thisKey = keys.nextElement();
            if (thisKey.equals("*/") || allValidParms.contains(thisKey) || ((String)thisKey).startsWith(OPT_WSRR_PREFIX)) continue;
            Logging.writeMessage(1, "DFHPI9530I", new Object[]{thisKey});
        }
        Logging.addPreLogFileMsgsToLog();
    }

    private boolean checkStructure(String structure) {
        boolean rc = true;
        if (structure == null || structure.length() == 0) {
            return true;
        }
        if (this.toolInUse != 3 && this.toolInUse != 2 && (this.toolInUse != 5 && this.toolInUse != 4 || this.p.getProperty(OPT_PDSMEM) == null)) {
            if (structure.indexOf("(") >= 1 || structure.indexOf(")") != -1 && structure.indexOf(")") != structure.length() - 1) {
                Logging.writeMessage(12, "DFHPI9531E", null);
                return false;
            }
            structure = structure.replaceAll("\\(", EMPTY_STR);
            int commaPos = (structure = structure.replaceAll("\\)", EMPTY_STR)).indexOf(",");
            if (commaPos == -1) {
                Logging.writeMessage(12, "DFHPI9532E", null);
                rc = false;
            } else {
                String req = structure.substring(0, commaPos);
                String resp = structure.substring(commaPos + 1);
                this.p.put(OPT_REQUEST_STRUCT, req.trim());
                this.p.put(OPT_RESPONSE_STRUCT, resp.trim());
            }
        } else if (structure.indexOf(44) > -1 || structure.indexOf(40) > -1 || structure.indexOf(41) > -1) {
            Logging.writeMessage(12, "DFHPI9509E", new String[]{OPT_STRUCTURE});
            rc = false;
        } else {
            this.p.put(OPT_REQUEST_STRUCT, structure.trim());
        }
        return rc;
    }

    protected Properties getProperties() {
        return this.p;
    }

    protected int getMappingLevel() {
        return this.mappingLevel;
    }

    public byte getWSBindVerNumber() {
        return this.wsBindVerNumber;
    }

    private boolean checkCCSID(String CCSID, String allowNonEBCDIC) {
        if (CCSID == null) {
            CodePageHelper.setCurrentCodePage(CodePageHelper.getDefaultCodePage());
            return true;
        }
        Charset resolvedCCSID = null;
        try {
            resolvedCCSID = CodePageHelper.resolveCCSID(CCSID);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (resolvedCCSID == null) {
            Logging.writeMessage(12, "DFHPI9620E", new Object[]{CCSID});
            return false;
        }
        if (!CodePageHelper.isEBCDICCCSID(CCSID)) {
            if (resolvedCCSID.equals(CodePageHelper.UTF_16BE_CHARSET) && MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel)) {
                if (this.toolInUse == 4 || this.toolInUse == 3 || this.toolInUse == 4) {
                    Logging.writeMessage(4, "DFHPI9721W", new Object[]{TOOL_NAMES[this.toolInUse]});
                    CodePageHelper.setCurrentCodePage(CodePageHelper.getDefaultCodePage());
                    return true;
                }
            } else if (!"true".equals(allowNonEBCDIC)) {
                Logging.writeMessage(4, "DFHPI9621W", new Object[]{CCSID});
            }
        }
        CodePageHelper.setCurrentCodePage(resolvedCCSID);
        return this.checkMinRuntimeLevel_1_2(OPT_CCSID);
    }

    private boolean checkMinRuntimeLevel_1_2(String parameter) {
        if (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1) {
            if (this.processMessagesForRuntimeLevelIncrease(parameter)) {
                this.wsBindVerNumber = (byte)2;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean checkMinRuntimeLevel_2_0(String parameter) {
        if (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1 || this.wsBindVerNumber == 2) {
            if (this.processMessagesForRuntimeLevelIncrease(parameter)) {
                this.wsBindVerNumber = (byte)3;
                return true;
            }
            return false;
        }
        return true;
    }

    public void checkMinRuntimeLevel_2_0(int reason) throws CICSWSDLException {
        String badRuntimeLevelMsg = null;
        String runtimeLevelChangedMsg = null;
        if (this.wsBindVerNumber == 0 || this.wsBindVerNumber == 1 || this.wsBindVerNumber == 2) {
            switch (reason) {
                case 3: {
                    if (this.minimumRuntimeIsSet) {
                        badRuntimeLevelMsg = "DFHPI9639E";
                    }
                    runtimeLevelChangedMsg = "DFHPI9638W";
                    this.wsBindVerNumber = (byte)3;
                    break;
                }
                default: {
                    throw new CICSWSDLException("INTERNAL ERROR: unexpected reason code: " + reason);
                }
            }
            if (badRuntimeLevelMsg != null) {
                throw new CICSWSDLException(MessageHandler.buildMessage(badRuntimeLevelMsg, null));
            }
            if (runtimeLevelChangedMsg != null) {
                Logging.writeMessage(4, runtimeLevelChangedMsg, null);
            }
        }
    }

    private boolean processMessagesForRuntimeLevelIncrease(String parameter) {
        if (this.minimumRuntimeIsSet) {
            Logging.writeMessage(12, "DFHPI9628E", new Object[]{parameter});
            return false;
        }
        if (!this.vendorBindFile) {
            Logging.writeMessage(4, "DFHPI9630W", new Object[]{parameter});
        }
        return true;
    }

    private boolean checkDefaultCharMaxLength(String defCharMaxLength) {
        if (defCharMaxLength == null) {
            this.defaultCharMaxLength = 255;
            this.p.put(OPT_DEFAULT_CHAR_MAXLENGTH, "255");
            return true;
        }
        if (!MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
            Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_DEFAULT_CHAR_MAXLENGTH, ICM.MAPPING_LEVELS[this.mappingLevel]});
            return false;
        }
        if (this.toolInUse == 1 || this.toolInUse == 3) {
            Logging.writeMessage(12, "DFHPI9504E", new Object[]{OPT_DEFAULT_CHAR_MAXLENGTH, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        long charLengthInt = -1L;
        try {
            charLengthInt = Long.parseLong(defCharMaxLength);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (charLengthInt < 1L || charLengthInt > Integer.MAX_VALUE) {
            Logging.writeMessage(12, "DFHPI9622E", new Object[]{OPT_DEFAULT_CHAR_MAXLENGTH, "1", Integer.toString(Integer.MAX_VALUE)});
            return false;
        }
        this.defaultCharMaxLength = (int)charLengthInt;
        return true;
    }

    protected int getDefaultCharMaxLength() {
        return this.defaultCharMaxLength;
    }

    private boolean checkDefaultArrayMaxItems(String defArrayMaxItems) {
        if (defArrayMaxItems == null) {
            this.defaultArrayMaxItems = -1;
            this.p.put(OPT_DEFAULT_ARRAY_MAXITEMS, "-1");
            return true;
        }
        long arrayBoundsInt = -1L;
        try {
            arrayBoundsInt = Long.parseLong(defArrayMaxItems);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (arrayBoundsInt < 1L || arrayBoundsInt > Integer.MAX_VALUE) {
            Logging.writeMessage(12, "DFHPI9622E", new Object[]{OPT_DEFAULT_ARRAY_MAXITEMS, "1", Integer.toString(Integer.MAX_VALUE)});
            return false;
        }
        this.defaultArrayMaxItems = (int)arrayBoundsInt;
        return true;
    }

    protected int getDefaultArrayMaxItems() {
        return this.defaultArrayMaxItems;
    }

    private boolean checkCharMultiplier(String charMult) {
        if (charMult == null) {
            this.charMultiplier = 1;
            this.p.put(OPT_CHAR_MULTIPLIER, "1");
            return true;
        }
        if (!MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
            Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_CHAR_MULTIPLIER, ICM.MAPPING_LEVELS[this.mappingLevel]});
            return false;
        }
        if (this.toolInUse == 1 || this.toolInUse == 3) {
            Logging.writeMessage(12, "DFHPI9504E", new Object[]{OPT_CHAR_MULTIPLIER, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        long charMultInt = -1L;
        try {
            charMultInt = Long.parseLong(charMult);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (charMultInt < 1L || charMultInt > Integer.MAX_VALUE) {
            Logging.writeMessage(12, "DFHPI9622E", new Object[]{OPT_CHAR_MULTIPLIER, "1", Integer.toString(Integer.MAX_VALUE)});
            return false;
        }
        if (CodePageHelper.getCurrentCodePage().equals(CodePageHelper.UTF_16BE_CHARSET) && charMultInt != 2L && charMultInt != 4L) {
            Logging.writeMessage(12, "DFHPI9722E", new Object[]{charMult});
            return false;
        }
        this.charMultiplier = (int)charMultInt;
        return true;
    }

    protected int getCharMultiplier() {
        return this.charMultiplier;
    }

    private boolean checkCharOccurs(String charOccurs) {
        if (this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) {
            return true;
        }
        if (charOccurs == null) {
            if (this.lang == 1) {
                this.charOccurs = OPT_VALUE_ARRAY;
                this.p.put(OPT_CHAR_OCCURS, OPT_VALUE_ARRAY);
                if (MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel)) {
                    this.charOccurs = OPT_VALUE_STRING;
                    this.p.put(OPT_CHAR_OCCURS, OPT_VALUE_STRING);
                }
            }
            return true;
        }
        if (!MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel)) {
            if (OPT_VALUE_ARRAY.equals(charOccurs)) {
                return true;
            }
            Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_CHAR_OCCURS, ICM.MAPPING_LEVELS[this.mappingLevel]});
            return false;
        }
        if (this.lang != 1) {
            Logging.writeMessage(4, "DFHPI9507W", new Object[]{"LANG=COBOL", OPT_CHAR_OCCURS});
        }
        boolean rc = false;
        for (int i = 0; !rc && i < VALID_CHAR_OCCURS_VALUES.length; ++i) {
            rc = VALID_CHAR_OCCURS_VALUES[i].equalsIgnoreCase(charOccurs);
        }
        if (!rc) {
            String validValuesStr = Util.join(VALID_CHAR_OCCURS_VALUES);
            Object[] messageParms = new Object[]{OPT_CHAR_OCCURS, validValuesStr};
            Logging.writeMessage(8, "DFHPI9664E", messageParms);
        }
        return rc;
    }

    private boolean checkCharUsage(String charUsage) {
        if (this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) {
            return true;
        }
        if (charUsage == null) {
            if (this.lang == 1) {
                if (MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel)) {
                    this.p.put(OPT_CHAR_USAGE, OPT_VALUE_NATIONAL);
                } else {
                    this.p.put(OPT_CHAR_USAGE, OPT_VALUE_DBCS);
                }
            }
            return true;
        }
        if (!MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel)) {
            if (OPT_VALUE_DBCS.equals(charUsage)) {
                return true;
            }
            Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_CHAR_USAGE, ICM.MAPPING_LEVELS[this.mappingLevel]});
            return false;
        }
        if (this.lang != 1) {
            Logging.writeMessage(4, "DFHPI9507W", new Object[]{"LANG=COBOL", OPT_CHAR_USAGE});
        }
        boolean rc = false;
        for (int i = 0; !rc && i < VALID_CHAR_USAGE_VALUES.length; ++i) {
            rc = VALID_CHAR_USAGE_VALUES[i].equalsIgnoreCase(charUsage);
        }
        if (!rc) {
            String validValuesStr = Util.join(VALID_CHAR_USAGE_VALUES);
            Object[] messageParms = new Object[]{OPT_CHAR_USAGE, validValuesStr};
            Logging.writeMessage(8, "DFHPI9664E", messageParms);
        }
        return rc;
    }

    protected String getCharOccurs() {
        return this.charOccurs;
    }

    private boolean checkCharVaryingLimit(String charVaryingLimit) {
        int maxCharVaryingLimit = Short.MAX_VALUE;
        if (charVaryingLimit == null) {
            this.charVaryingLimit = maxCharVaryingLimit;
            this.p.put(OPT_CHAR_VARYING_LIMIT, String.valueOf(maxCharVaryingLimit));
            return true;
        }
        if (!MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
            Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_CHAR_VARYING_LIMIT, ICM.MAPPING_LEVELS[this.mappingLevel]});
            return false;
        }
        if (this.toolInUse == 1 || this.toolInUse == 3) {
            Logging.writeMessage(12, "DFHPI9504E", new Object[]{OPT_CHAR_VARYING_LIMIT, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        int charVarLimInt = -1;
        try {
            charVarLimInt = Integer.parseInt(charVaryingLimit);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        maxCharVaryingLimit = ParmChecker.getMaxCharArraySize(this.p);
        if (charVarLimInt < 0 || charVarLimInt > maxCharVaryingLimit) {
            charVarLimInt = -1;
        }
        if (charVarLimInt == -1) {
            Logging.writeMessage(12, "DFHPI9622E", new Object[]{OPT_CHAR_VARYING_LIMIT, "0", String.valueOf(maxCharVaryingLimit)});
            return false;
        }
        this.charVaryingLimit = charVarLimInt;
        return true;
    }

    protected int getCharVaryingLimit() {
        return this.charVaryingLimit;
    }

    private boolean checkCharVarying(String charVarying) {
        if (this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) {
            if (!(charVarying == null || charVarying.equalsIgnoreCase(OPT_VALUE_NULL) || charVarying.equalsIgnoreCase(OPT_VALUE_NO) || charVarying.equalsIgnoreCase(OPT_VALUE_YES))) {
                Logging.writeMessage(12, "DFHPI9623E", null);
                return false;
            }
        } else if (!(charVarying == null || charVarying.equalsIgnoreCase(OPT_VALUE_NULL) || charVarying.equalsIgnoreCase(OPT_VALUE_NO) || charVarying.equalsIgnoreCase(OPT_VALUE_COLLAPSE) || charVarying.equalsIgnoreCase(OPT_VALUE_BINARY))) {
            Logging.writeMessage(12, "DFHPI9625E", null);
            return false;
        }
        if (!MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
            if (charVarying != null) {
                Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_CHAR_VARYING, ICM.MAPPING_LEVELS[this.mappingLevel]});
                return false;
            }
            this.p.put(OPT_CHAR_VARYING, OPT_VALUE_NO);
            return true;
        }
        if (this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) {
            if (charVarying == null) {
                if (this.lang == 3 || this.lang == 4) {
                    this.p.put(OPT_CHAR_VARYING, OPT_VALUE_NULL);
                } else {
                    this.p.put(OPT_CHAR_VARYING, OPT_VALUE_YES);
                }
            }
        } else {
            if (charVarying == null) {
                if (!MappingLevelHelper.supportsMappingLevel_2_1(this.mappingLevel)) {
                    this.p.put(OPT_CHAR_VARYING, OPT_VALUE_NO);
                    return true;
                }
                if (this.lang == 3 || this.lang == 4) {
                    this.p.put(OPT_CHAR_VARYING, OPT_VALUE_NULL);
                } else {
                    this.p.put(OPT_CHAR_VARYING, OPT_VALUE_COLLAPSE);
                }
                return true;
            }
            if (this.lang == 2 && !charVarying.equalsIgnoreCase(OPT_VALUE_COLLAPSE) && !charVarying.equalsIgnoreCase(OPT_VALUE_BINARY)) {
                Logging.writeMessage(4, "DFHPI9626W", new Object[]{"CHAR-VARYING=" + charVarying.toUpperCase(Locale.ENGLISH), "LANG=PLI-ENTERPRISE"});
            }
        }
        return true;
    }

    protected ICM.VaryingLength getCharVarying() {
        String charVarStr = this.p.getProperty(OPT_CHAR_VARYING);
        if (OPT_VALUE_NO.equalsIgnoreCase(charVarStr)) {
            return ICM.VaryingLength.FIXED_LENGTH_ARRAY;
        }
        if (OPT_VALUE_YES.equalsIgnoreCase(charVarStr)) {
            return ICM.VaryingLength.VARYING_ARRAY;
        }
        if (OPT_VALUE_NULL.equalsIgnoreCase(charVarStr)) {
            return ICM.VaryingLength.NULL_TERMINATED_CHAR_ARRAY;
        }
        if (OPT_VALUE_COLLAPSE.equalsIgnoreCase(charVarStr)) {
            return ICM.VaryingLength.WHITESPACE_COLLAPSE;
        }
        if (OPT_VALUE_BINARY.equalsIgnoreCase(charVarStr)) {
            return ICM.VaryingLength.FIXED_LENGTH_BINARY;
        }
        return ICM.VaryingLength.NO_VARYING_STRATEGY;
    }

    private boolean checkCharWhitespace(String charWhitespace) {
        if (this.toolInUse != 5 && charWhitespace != null) {
            Logging.writeMessage(12, "DFHPI9504E", new Object[]{OPT_CHAR_WHITESPACE, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        if (charWhitespace == null) {
            if (this.toolInUse == 5) {
                this.p.put(OPT_CHAR_WHITESPACE, OPT_VALUE_COLLAPSE);
            }
        } else if (!(charWhitespace.equalsIgnoreCase(OPT_VALUE_COLLAPSE) || charWhitespace.equalsIgnoreCase(OPT_VALUE_REPLACE) || charWhitespace.equalsIgnoreCase(OPT_VALUE_PRESERVE))) {
            String validValuesString = Util.join(VALID_CHAR_WHITESPACE_VALUES);
            Object[] messageParms = new Object[]{OPT_CHAR_WHITESPACE, validValuesString};
            Logging.writeMessage(8, "DFHPI9664E", messageParms);
            return false;
        }
        return true;
    }

    private boolean checkInlineMaxOccursLimit(String inlineMaxOccursLimit) {
        if (inlineMaxOccursLimit == null) {
            this.inlineMaxOccursLimit = MappingLevelHelper.supportsMappingLevel_2_1(this.mappingLevel) ? 1 : 0;
            this.p.put(OPT_INLINE_MAXOCCURS_LIMIT, Integer.toString(this.inlineMaxOccursLimit));
            return true;
        }
        if (!MappingLevelHelper.supportsMappingLevel_2_1(this.mappingLevel)) {
            Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_INLINE_MAXOCCURS_LIMIT, ICM.MAPPING_LEVELS[this.mappingLevel]});
            return false;
        }
        if (this.toolInUse == 1 || this.toolInUse == 3 || this.toolInUse == 4) {
            Logging.writeMessage(12, "DFHPI9504E", new Object[]{OPT_INLINE_MAXOCCURS_LIMIT, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        int inlineInt = -1;
        try {
            inlineInt = Integer.parseInt(inlineMaxOccursLimit);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (inlineInt < 0 || inlineInt > Short.MAX_VALUE) {
            inlineInt = -1;
        }
        if (inlineInt == -1) {
            Logging.writeMessage(12, "DFHPI9622E", new Object[]{OPT_INLINE_MAXOCCURS_LIMIT, "0", "32767"});
            return false;
        }
        this.inlineMaxOccursLimit = inlineInt;
        return true;
    }

    protected int getInlineMaxOccursLimit() {
        return this.inlineMaxOccursLimit;
    }

    private boolean checkTransaction(String transaction) {
        if (transaction == null) {
            return true;
        }
        if (this.toolInUse == 3 || this.toolInUse == 2) {
            return true;
        }
        if ((this.toolInUse == 4 || this.toolInUse == 5) && this.bundleSet) {
            Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_TRANSACTION});
            return false;
        }
        String uriName = this.p.getProperty(OPT_URI);
        if (uriName == null || EMPTY_STR.equals(uriName) || ONE_CHAR_STRING.equals(uriName)) {
            Logging.writeMessage(4, "DFHPI9507W", new Object[]{OPT_URI, OPT_TRANSACTION});
            this.p.setProperty(OPT_TRANSACTION, EMPTY_STR);
            return true;
        }
        if (transaction.length() > 4) {
            Logging.writeMessage(12, "DFHPI9506E", new Object[]{OPT_TRANSACTION, "4", transaction});
            return false;
        }
        Matcher m = transactionPattern.matcher(transaction);
        if (!m.matches()) {
            Logging.writeMessage(12, "DFHPI9509E", new Object[]{OPT_TRANSACTION});
            return false;
        }
        return true;
    }

    private boolean checkUserid(String userid) {
        if (userid == null) {
            return true;
        }
        if (this.toolInUse == 3 || this.toolInUse == 2) {
            return true;
        }
        if ((this.toolInUse == 4 || this.toolInUse == 5) && this.bundleSet) {
            Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_USERID});
            return false;
        }
        String uriName = this.p.getProperty(OPT_URI);
        if (uriName == null || EMPTY_STR.equals(uriName) || ONE_CHAR_STRING.equals(uriName)) {
            Logging.writeMessage(4, "DFHPI9507W", new Object[]{OPT_URI, OPT_USERID});
            this.p.setProperty(OPT_USERID, EMPTY_STR);
            return true;
        }
        if (userid.length() > 8) {
            Logging.writeMessage(12, "DFHPI9506E", new Object[]{OPT_USERID, "8", userid});
            return false;
        }
        Matcher m = useridPattern.matcher(userid);
        if (!m.matches()) {
            Logging.writeMessage(12, "DFHPI9509E", new Object[]{OPT_USERID});
            return false;
        }
        if (Character.isDigit(userid.charAt(0))) {
            Logging.writeMessage(12, "DFHPI9533E", new Object[]{OPT_USERID, Character.toString(userid.charAt(0)), "1", userid});
            return false;
        }
        return true;
    }

    private boolean checkBundle(String bundle) {
        if (bundle != null && !EMPTY_STR.equals(bundle)) {
            this.bundleSet = true;
        }
        return true;
    }

    protected boolean isHexFloat() {
        if (this.platform == null) {
            return true;
        }
        return this.platform.getFloatStyle().equals((Object)IPlatform.FloatStyle.IBM_HEX_FLOAT);
    }

    protected boolean checkVendorConverterName(String converterName) {
        if (converterName != null && !EMPTY_STR.equals(converterName)) {
            if (this.toolInUse == 1 || this.toolInUse == 3 || this.toolInUse == 4) {
                Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_VENDOR_CONV_NAME, TOOL_NAMES[this.toolInUse]});
                return false;
            }
            if (converterName.length() > 8) {
                Logging.writeMessage(8, "DFHPI9506E", new Object[]{OPT_VENDOR_CONV_NAME, "8", converterName});
                return false;
            }
            Matcher m = programNamePattern.matcher(converterName);
            if (!m.matches()) {
                Logging.writeMessage(12, "DFHPI9509E", new Object[]{OPT_VENDOR_CONV_NAME});
                return false;
            }
            this.vendorBindFile = true;
        }
        return true;
    }

    protected boolean checkVendorInerfaceLen(String length) {
        if (!(length == null || EMPTY_STR.equals(length) || this.toolInUse != 1 && this.toolInUse != 3 && this.toolInUse != 4)) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_VENDOR_INTF_LENGTH, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        return true;
    }

    protected boolean checkVendorMetaData(byte[] metaData) {
        if (metaData != null) {
            if (this.toolInUse == 1 || this.toolInUse == 3 || this.toolInUse == 4) {
                Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_VENDOR_META_DATA, TOOL_NAMES[this.toolInUse]});
                return false;
            }
            return this.checkMinRuntimeLevel_1_2(OPT_VENDOR_META_DATA);
        }
        return true;
    }

    protected boolean isVendorBindFile() {
        return this.vendorBindFile;
    }

    protected List<String> getOperationNames() {
        return this.operationNames;
    }

    public List<String> getSchemaElements() {
        return this.schemaElements;
    }

    public List<String> getSchemaTypes() {
        return this.schemaTypes;
    }

    public int getLevelIncrementSize() {
        return this.levelIncrementSize;
    }

    public boolean getWSDLEncodingRequired() {
        return this.specifyEncoding;
    }

    public void setWSDLEncodingRequired(boolean encoding) {
        this.specifyEncoding = encoding;
    }

    protected boolean checkNameSpaces(String reqNS, String respNS) {
        boolean bothValid = true;
        if (this.toolInUse != 1 && this.toolInUse != 0) {
            return true;
        }
        if (reqNS != null && !EMPTY_STR.equals(reqNS) && this.toolInUse == 0) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_REQUEST_NAMESPACE, TOOL_DFHWS2LS});
            bothValid = false;
        }
        if (respNS != null && !EMPTY_STR.equals(respNS) && this.toolInUse == 0) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_RESPONSE_NAMESPACE, TOOL_DFHWS2LS});
            bothValid = false;
        }
        return bothValid;
    }

    protected boolean checkWSDLNamespace(String wsdlNS) {
        if (wsdlNS != null && !EMPTY_STR.equals(wsdlNS) && this.toolInUse == 0) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_WSDL_NAMESPACE, TOOL_DFHWS2LS});
            return false;
        }
        return true;
    }

    protected boolean checkProxyAuthentication(String proxy, String username, String password) {
        boolean passwordSpecified;
        boolean result = true;
        boolean usernameSpecified = username != null && !username.equals(EMPTY_STR);
        boolean bl = passwordSpecified = password != null && !password.equals(EMPTY_STR);
        if (this.toolInUse == 3) {
            if (usernameSpecified) {
                Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_HTTPPROXY_USERNAME, TOOL_NAMES[this.toolInUse]});
                result = false;
            }
            if (passwordSpecified) {
                Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_HTTPPROXY_PASSWORD, TOOL_NAMES[this.toolInUse]});
                result = false;
            }
        } else {
            boolean proxySpecified;
            boolean bl2 = proxySpecified = proxy != null && !proxy.equals(EMPTY_STR);
            if (!proxySpecified && (usernameSpecified || passwordSpecified)) {
                Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_HTTPPROXY, TOOL_NAMES[this.toolInUse]});
                result = false;
            }
            if (usernameSpecified) {
                if (!passwordSpecified) {
                    Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_HTTPPROXY_PASSWORD, TOOL_NAMES[this.toolInUse]});
                    result = false;
                }
            } else if (passwordSpecified) {
                Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_HTTPPROXY_USERNAME, TOOL_NAMES[this.toolInUse]});
                result = false;
            }
        }
        return result;
    }

    private void setProxyAuthentication(String username, String password) {
        HTTPAuthenticator auth = new HTTPAuthenticator(username, password);
        Authenticator.setDefault(auth);
    }

    private boolean checkXmlOnly(String xmlOnly) {
        if (xmlOnly == null || xmlOnly.equals(EMPTY_STR)) {
            this.p.put(OPT_XML_ONLY, (Object)false);
            return true;
        }
        if (this.toolInUse != 0) {
            Logging.writeMessage(12, "DFHPI9504E", new Object[]{OPT_XML_ONLY, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        try {
            if (!RuntimeLevelHelper.supportsRuntimeLevel_2_1(this.wsBindVerNumber)) {
                Logging.writeMessage(12, "DFHPI9628E", new Object[]{OPT_XML_ONLY, WSBind.MAJOR_VER_AS_STRING[this.wsBindVerNumber]});
                return false;
            }
        }
        catch (CICSWSDLException cICSWSDLException) {
            // empty catch block
        }
        if (xmlOnly.equalsIgnoreCase("true") || xmlOnly.equalsIgnoreCase("false")) {
            this.p.put(OPT_XML_ONLY, Boolean.valueOf(xmlOnly));
            this.xmlOnly = Boolean.valueOf(xmlOnly);
            return true;
        }
        Logging.writeMessage(12, "DFHPI9668E", new Object[0]);
        return false;
    }

    public boolean isXmlOnly() {
        return this.xmlOnly;
    }

    private boolean checkWsAddrEprAny(String wsAddrEprAny) {
        if (wsAddrEprAny == null || wsAddrEprAny.equals(EMPTY_STR)) {
            this.p.put(OPT_WSADDR_EPR_ANY, (Object)false);
            return true;
        }
        if (this.toolInUse != 0) {
            Logging.writeMessage(12, "DFHPI9504E", new Object[]{OPT_WSADDR_EPR_ANY, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        try {
            if (!RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.wsBindVerNumber)) {
                Logging.writeMessage(12, "DFHPI9628E", new Object[]{OPT_WSADDR_EPR_ANY, WSBind.MAJOR_VER_AS_STRING[this.wsBindVerNumber]});
                return false;
            }
        }
        catch (CICSWSDLException cICSWSDLException) {
            // empty catch block
        }
        if (wsAddrEprAny.equalsIgnoreCase("true") || wsAddrEprAny.equalsIgnoreCase("false")) {
            this.p.put(OPT_WSADDR_EPR_ANY, Boolean.valueOf(wsAddrEprAny));
            return true;
        }
        Logging.writeMessage(12, "DFHPI9681E", new Object[0]);
        return false;
    }

    private boolean checkSyncOnReturn(String sync) {
        boolean rc = true;
        if (this.toolInUse == 3 || this.toolInUse == 2) {
            return true;
        }
        if ((this.toolInUse == 4 || this.toolInUse == 5) && this.bundleSet) {
            if (sync != null) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_SYNCONRETURN});
                return false;
            }
            return true;
        }
        if (sync != null) {
            if (sync.equalsIgnoreCase(OPT_VALUE_YES)) {
                this.syncOnReturn = true;
            } else if (!sync.equalsIgnoreCase(OPT_VALUE_NO)) {
                String validValuesStr = Util.join(VALID_SYNCONRETURN_VALUES);
                Object[] messageParms = new Object[]{OPT_SYNCONRETURN, validValuesStr};
                Logging.writeMessage(8, "DFHPI9664E", messageParms);
                rc = false;
            }
        }
        return rc;
    }

    private boolean checkOverwriteOutput(String owOutput) {
        File bundle;
        boolean rc = true;
        if (this.toolInUse == 1 || this.toolInUse == 0) {
            return true;
        }
        if (owOutput != null) {
            if (owOutput.equalsIgnoreCase(OPT_VALUE_NO) || owOutput.equalsIgnoreCase(OPT_VALUE_YES)) {
                rc = true;
            } else {
                rc = false;
                String validValuesStr = Util.join(VALID_OVERWRITE_OUTPUT_VALUES);
                Object[] messageParms = new Object[]{OPT_OVERWRITE_OUTPUT, validValuesStr};
                Logging.writeMessage(8, "DFHPI9664E", messageParms);
            }
        } else if (this.toolInUse == 3 || this.toolInUse == 2) {
            this.p.put(OPT_OVERWRITE_OUTPUT, OPT_VALUE_NO);
        } else {
            return true;
        }
        String bundleName = this.p.getProperty(OPT_BUNDLE);
        String overwriteOutput = this.p.getProperty(OPT_OVERWRITE_OUTPUT);
        if (bundleName != null && (bundle = new File(bundleName)).exists()) {
            if (overwriteOutput.equalsIgnoreCase("yes")) {
                Logging.writeMessage(4, "DFHPI9683W", new Object[]{bundle});
                rc = true;
            } else {
                Logging.writeMessage(8, "DFHPI9689E", new Object[]{bundle});
                rc = false;
            }
        }
        return rc;
    }

    private boolean checkWideComp3(String parameterValue) {
        if (this.toolInUse == 1 || this.toolInUse == 3 || this.toolInUse == 4) {
            this.p.put(OPT_WIDE_COMP3, OPT_VALUE_YES);
            return true;
        }
        if (parameterValue == null || parameterValue.equals(EMPTY_STR)) {
            this.p.put(OPT_WIDE_COMP3, OPT_VALUE_NO);
            return true;
        }
        if (!(parameterValue.equalsIgnoreCase(OPT_VALUE_NO) || parameterValue.equalsIgnoreCase(OPT_VALUE_YES) || parameterValue.equalsIgnoreCase(OPT_VALUE_FULL))) {
            String validValuesStr = Util.join(VALID_WIDE_COMP3_VALUES);
            Object[] messageParms = new Object[]{OPT_WIDE_COMP3, validValuesStr};
            Logging.writeMessage(8, "DFHPI9664E", messageParms);
            return false;
        }
        return true;
    }

    private boolean checkDefaultFractionDigits(String parameterValue) {
        if (this.toolInUse != 0 && this.toolInUse != 2 && this.toolInUse != 5 || parameterValue == null) {
            return true;
        }
        int fractionDigitsInt = -1;
        try {
            fractionDigitsInt = Integer.parseInt(parameterValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.p.get(OPT_WIDE_COMP3).equals(OPT_VALUE_NO) && this.p.get(OPT_LANG).equals(OPT_VALUE_COBOL)) {
            if (fractionDigitsInt < 0 || fractionDigitsInt > 17) {
                fractionDigitsInt = -1;
            }
        } else if (fractionDigitsInt < 0 || fractionDigitsInt > 30) {
            fractionDigitsInt = -1;
        }
        if (fractionDigitsInt == -1 && this.p.get(OPT_WIDE_COMP3).equals(OPT_VALUE_NO) && this.p.get(OPT_LANG).equals(OPT_VALUE_COBOL)) {
            Logging.writeMessage(12, "DFHPI9622E", new Object[]{OPT_DEFAULT_FRACTION_DIGITS, "0", "17"});
            return false;
        }
        if (fractionDigitsInt == -1) {
            Logging.writeMessage(12, "DFHPI9622E", new Object[]{OPT_DEFAULT_FRACTION_DIGITS, "0", "30"});
            return false;
        }
        this.defaultFractionDigits = fractionDigitsInt;
        return true;
    }

    protected int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    private boolean checkDATETIME(String datetime) {
        if (datetime == null || datetime.equals(EMPTY_STR) || datetime.equals(OPT_VALUE_UNUSED)) {
            if (this.toolInUse == 0 || this.toolInUse == 2 || this.toolInUse == 5) {
                if (MappingLevelHelper.supportsMappingLevel_3_0(this.mappingLevel)) {
                    this.p.put(OPT_DATETIME, OPT_VALUE_PACKED15);
                } else {
                    this.p.put(OPT_DATETIME, OPT_VALUE_STRING);
                }
            } else {
                this.p.put(OPT_DATETIME, OPT_VALUE_UNUSED);
            }
            return true;
        }
        if (!MappingLevelHelper.supportsMappingLevel_3_0(this.mappingLevel)) {
            Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_DATETIME, ICM.MAPPING_LEVELS[this.mappingLevel]});
            return false;
        }
        if (!(this.toolInUse != 2 && this.toolInUse != 0 || datetime.equalsIgnoreCase(OPT_VALUE_STRING) || datetime.equalsIgnoreCase(OPT_VALUE_PACKED15))) {
            String validValuesStr = Util.join(VALID_DATETIME_VALUES_TOP_DOWN);
            Object[] messageParms = new Object[]{OPT_DATETIME, validValuesStr};
            Logging.writeMessage(8, "DFHPI9664E", messageParms);
            return false;
        }
        if (!(this.toolInUse != 3 && this.toolInUse != 1 || datetime.equalsIgnoreCase(OPT_VALUE_UNUSED) || datetime.equalsIgnoreCase(OPT_VALUE_PACKED15))) {
            String validValuesStr = Util.join(VALID_DATETIME_VALUES_BOTTOM_UP);
            Object[] messageParms = new Object[]{OPT_DATETIME, validValuesStr};
            Logging.writeMessage(8, "DFHPI9664E", messageParms);
            return false;
        }
        return true;
    }

    private boolean checkDataTruncation(String dataTruncation) {
        if (dataTruncation == null || dataTruncation.equals(EMPTY_STR) || dataTruncation.equalsIgnoreCase(OPT_VALUE_DISABLED)) {
            this.p.put(OPT_DATA_TRUNCATION, OPT_VALUE_DISABLED);
            return true;
        }
        if (!MappingLevelHelper.supportsMappingLevel_3_0(this.mappingLevel)) {
            Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_DATA_TRUNCATION, ICM.MAPPING_LEVELS[this.mappingLevel]});
            return false;
        }
        if (!dataTruncation.equalsIgnoreCase(OPT_VALUE_ENABLED) && !dataTruncation.equalsIgnoreCase(OPT_VALUE_DISABLED)) {
            String validValuesStr = Util.join(VALID_DATA_TRUNCATION_VALUES);
            Object[] messageParms = new Object[]{OPT_DATA_TRUNCATION, validValuesStr};
            Logging.writeMessage(8, "DFHPI9664E", messageParms);
            return false;
        }
        return true;
    }

    private boolean checkDataScreening(String dataScreening) {
        if (dataScreening == null || dataScreening.equals(EMPTY_STR) || dataScreening.equalsIgnoreCase(OPT_VALUE_ENABLED)) {
            this.p.put(OPT_DATA_SCREENING, OPT_VALUE_ENABLED);
            return true;
        }
        if (!dataScreening.equalsIgnoreCase(OPT_VALUE_ENABLED) && !dataScreening.equalsIgnoreCase(OPT_VALUE_DISABLED)) {
            String validValuesStr = Util.join(VALID_DATA_SCREENING_VALUES);
            Object[] messageParms = new Object[]{OPT_DATA_SCREENING, validValuesStr};
            Logging.writeMessage(8, "DFHPI9664E", messageParms);
            return false;
        }
        return true;
    }

    private boolean checkTruncateNullArrays(String truncateArrays) {
        if (truncateArrays == null || truncateArrays.equals(EMPTY_STR) || truncateArrays.equalsIgnoreCase(OPT_VALUE_DISABLED)) {
            this.p.put(OPT_TRUNCATE_NULL_ARRAYS, OPT_VALUE_DISABLED);
            return true;
        }
        if (!MappingLevelHelper.supportsMappingLevel_4_1(this.mappingLevel)) {
            Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_TRUNCATE_NULL_ARRAYS, ICM.MAPPING_LEVELS[this.mappingLevel]});
            return false;
        }
        if (!truncateArrays.equalsIgnoreCase(OPT_VALUE_ENABLED) && !truncateArrays.equalsIgnoreCase(OPT_VALUE_DISABLED)) {
            String validValuesStr = Util.join(VALID_TRUNCATE_NULL_ARRAYS_VALUES);
            Object[] messageParms = new Object[]{OPT_TRUNCATE_NULL_ARRAYS, validValuesStr};
            Logging.writeMessage(8, "DFHPI9664E", messageParms);
            return false;
        }
        return true;
    }

    private boolean checkTruncateNullArrayValues(String truncateArrayValues) {
        if (truncateArrayValues == null || truncateArrayValues.equals(EMPTY_STR) || truncateArrayValues.equalsIgnoreCase(OPT_VALUE_NULL)) {
            this.p.put(OPT_TRUNCATE_NULL_ARRAY_VALUES, OPT_VALUE_NULL);
            return true;
        }
        if (!MappingLevelHelper.supportsMappingLevel_4_1(this.mappingLevel)) {
            Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_TRUNCATE_NULL_ARRAY_VALUES, ICM.MAPPING_LEVELS[this.mappingLevel]});
            return false;
        }
        if (!OPT_VALUE_ENABLED.equalsIgnoreCase(this.p.getProperty(OPT_TRUNCATE_NULL_ARRAYS))) {
            Logging.writeMessage(4, "DFHPI9626W", new Object[]{OPT_TRUNCATE_NULL_ARRAY_VALUES, "TRUNCATE-NULL-ARRAYS=DISABLED"});
            this.p.put(OPT_TRUNCATE_NULL_ARRAY_VALUES, OPT_VALUE_NULL);
            return true;
        }
        boolean allParameterArgsValid = true;
        StringTokenizer st = new StringTokenizer(truncateArrayValues.toUpperCase(Locale.ENGLISH), ",", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            token = token.trim();
            Object[] messageParms = new Object[]{OPT_TRUNCATE_NULL_ARRAY_VALUES, Util.join(VALID_TRUNCATE_NULL_ARRAY_VALUES_VALUES)};
            if (OPT_VALUE_NULL.equals(token) || OPT_VALUE_SPACE.equals(token) || OPT_VALUE_ZERO.equals(token) || OPT_VALUE_PACKEDZERO.equals(token)) continue;
            allParameterArgsValid = false;
            Logging.writeMessage(8, "DFHPI9664E", messageParms);
        }
        this.p.setProperty(OPT_TRUNCATE_NULL_ARRAY_VALUES, truncateArrayValues.toUpperCase(Locale.ENGLISH));
        return allParameterArgsValid;
    }

    private boolean checkNameTruncation(String nameTruncation) {
        if (nameTruncation == null || nameTruncation.equals(EMPTY_STR)) {
            this.p.put(OPT_NAME_TRUNCATION, OPT_VALUE_RIGHT);
            return true;
        }
        if (!nameTruncation.equalsIgnoreCase(OPT_VALUE_LEFT) && !nameTruncation.equalsIgnoreCase(OPT_VALUE_RIGHT)) {
            String validValuesStr = Util.join(VALID_NAME_TRUNCATION_VALUES);
            Object[] messageParms = new Object[]{OPT_NAME_TRUNCATION, validValuesStr};
            Logging.writeMessage(8, "DFHPI9664E", messageParms);
            return false;
        }
        return true;
    }

    protected boolean isSyncOnReturn() {
        return this.syncOnReturn;
    }

    public boolean checkJSONSchemaParms(String requestValue, String responseValue, String restfulValue, String simpleValue) {
        if (this.toolInUse != 5 && this.toolInUse != 4) {
            return true;
        }
        if (this.bundleSet) {
            boolean error = false;
            if (simpleValue == null) {
                Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_JSON_SCHEMA});
                error = true;
            }
            if (requestValue != null) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_JSON_SCHEMA_REQUEST});
                error = true;
            }
            if (responseValue != null) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_JSON_SCHEMA_RESPONSE});
                error = true;
            }
            if (restfulValue != null) {
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_BUNDLE, OPT_JSON_SCHEMA_RESTFUL});
                error = true;
            }
            if (error) {
                return false;
            }
        } else {
            if (simpleValue != null) {
                Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_BUNDLE});
                return false;
            }
            if (this.toolInUse == 4) {
                if (requestValue == null) {
                    Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_JSON_SCHEMA_REQUEST});
                    return false;
                }
                if (responseValue == null) {
                    Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_JSON_SCHEMA_RESPONSE});
                    return false;
                }
                if (requestValue.equals(responseValue)) {
                    Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_JSON_SCHEMA_REQUEST, OPT_JSON_SCHEMA_RESPONSE});
                    return false;
                }
            } else {
                if (restfulValue != null && (responseValue != null || requestValue != null)) {
                    if (requestValue != null) {
                        Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_JSON_SCHEMA_RESTFUL, OPT_JSON_SCHEMA_REQUEST});
                        return false;
                    }
                    Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_JSON_SCHEMA_RESTFUL, OPT_JSON_SCHEMA_RESPONSE});
                    return false;
                }
                if (requestValue != null && responseValue == null) {
                    Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_JSON_SCHEMA_RESPONSE});
                    return false;
                }
                if (responseValue != null && requestValue == null) {
                    Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_JSON_SCHEMA_REQUEST});
                    return false;
                }
                if (responseValue == null && requestValue == null && restfulValue == null) {
                    Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_JSON_SCHEMA_REQUEST});
                    return false;
                }
            }
        }
        return true;
    }

    public boolean checkJSONTransform(String value) {
        if (this.toolInUse != 5 && this.toolInUse != 4) {
            return true;
        }
        if (this.bundleSet) {
            if (value == null) {
                Logging.writeMessage(8, "DFHPI9503E", new Object[]{OPT_JSONTRANSFRM});
                return false;
            }
            if (value.length() > 16) {
                Logging.writeMessage(8, "DFHPI9506E", new Object[]{OPT_JSONTRANSFRM, Integer.toString(16), value});
                return false;
            }
        } else if (value != null) {
            Logging.writeMessage(8, "DFHPI9651E", new Object[]{OPT_JSON_SCHEMA_REQUEST, OPT_JSONTRANSFRM});
            return false;
        }
        return true;
    }

    public boolean checkHTTPMethods(String value) {
        if (this.toolInUse != 5) {
            return true;
        }
        if (value != null) {
            if (this.p.getProperty(OPT_JSON_SCHEMA_RESTFUL) == null) {
                String parm = OPT_JSON_SCHEMA_REQUEST;
                if (this.p.get(OPT_BUNDLE) != null) {
                    parm = OPT_BUNDLE;
                }
                Logging.writeMessage(8, "DFHPI9651E", new Object[]{parm, OPT_HTTP_METHODS});
                return false;
            }
            boolean allParameterArgsValid = true;
            StringTokenizer st = new StringTokenizer(value.toUpperCase(Locale.ENGLISH), ",", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                token = token.trim();
                Object[] messageParms = new Object[]{OPT_HTTP_METHODS, Util.join(VALID_HTTP_METHODS_VALUES)};
                if (OPT_VALUE_GET.equals(token) || OPT_VALUE_POST.equals(token) || OPT_VALUE_PUT.equals(token) || OPT_VALUE_DELETE.equals(token) || OPT_VALUE_HEAD.equals(token)) continue;
                allParameterArgsValid = false;
                Logging.writeMessage(8, "DFHPI9664E", messageParms);
            }
            this.p.setProperty(OPT_HTTP_METHODS, value.toUpperCase(Locale.ENGLISH));
            return allParameterArgsValid;
        }
        if (this.p.getProperty(OPT_JSON_SCHEMA_RESTFUL) != null) {
            this.p.setProperty(OPT_HTTP_METHODS, "GET,POST,PUT,DELETE");
        }
        return true;
    }

    private boolean checkBindingName(String binding_name) {
        if (this.toolInUse != 1 && binding_name != null) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_BINDING_NAME, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        return true;
    }

    private boolean checkPortName(String port_name) {
        if (this.toolInUse != 1 && port_name != null) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_PORT_NAME, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        return true;
    }

    public static int getMaxCharArraySize(Properties props) {
        if (props != null) {
            boolean zosConnect;
            boolean bl = zosConnect = props.getProperty(OPT_ZOS_CONNECT_EE) != null && props.getProperty(OPT_ZOS_CONNECT_EE).equalsIgnoreCase("true");
            if ((OPT_VALUE_TRUE.equalsIgnoreCase(props.getProperty(OPT_DISABLE_CONTAINERS)) || zosConnect) && (OPT_VALUE_NO.equalsIgnoreCase(props.getProperty(OPT_CHAR_VARYING)) || OPT_VALUE_NULL.equalsIgnoreCase(props.getProperty(OPT_CHAR_VARYING)))) {
                return 0xFFFFFE;
            }
        }
        return Short.MAX_VALUE;
    }

    private boolean checkServiceName(String service_name) {
        if (this.toolInUse != 1 && service_name != null) {
            Logging.writeMessage(8, "DFHPI9504E", new Object[]{OPT_SERVICE_NAME, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        return true;
    }

    private boolean checkAdditionalProperties(String apDefault, String apMax, String apSize) {
        boolean apSizeSet;
        boolean apDefaultSet = apDefault != null && !EMPTY_STR.equals(apDefault);
        boolean apMaxSet = apMax != null && !EMPTY_STR.equals(apMax);
        boolean bl = apSizeSet = apSize != null && !EMPTY_STR.equals(apSize);
        if (!MappingLevelHelper.supportsMappingLevel_4_2(this.mappingLevel)) {
            if (apDefaultSet) {
                Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_ADDITIONAL_PROPERTIES_DEFAULT, ICM.MAPPING_LEVELS[this.mappingLevel]});
                return false;
            }
            if (apMaxSet) {
                Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_ADDITIONAL_PROPERTIES_MAX, ICM.MAPPING_LEVELS[this.mappingLevel]});
                return false;
            }
            if (apSizeSet) {
                Logging.writeMessage(12, "DFHPI9619E", new Object[]{OPT_ADDITIONAL_PROPERTIES_SIZE, ICM.MAPPING_LEVELS[this.mappingLevel]});
                return false;
            }
            return true;
        }
        if (!apDefaultSet) {
            apDefault = OPT_VALUE_FALSE;
            this.p.setProperty(OPT_ADDITIONAL_PROPERTIES_DEFAULT, apDefault);
        }
        if (!apMaxSet) {
            apMax = OPT_VALUE_UNBOUNDED;
            this.p.setProperty(OPT_ADDITIONAL_PROPERTIES_MAX, apMax);
        }
        if (!apSizeSet) {
            apSize = "255";
            this.p.setProperty(OPT_ADDITIONAL_PROPERTIES_SIZE, apSize);
        }
        boolean rc = this.validateToken(apDefault, VALID_ADDITIONAL_PROPERTIES_DEFAULT_VALUES, OPT_ADDITIONAL_PROPERTIES_DEFAULT);
        if (!OPT_VALUE_UNBOUNDED.equalsIgnoreCase(apMax)) {
            int max = -1;
            try {
                max = Integer.parseInt(apMax);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (max < 0 || max > 20) {
                max = -1;
            }
            if (max == -1) {
                Logging.writeMessage(12, "DFHPI9622E", new Object[]{OPT_ADDITIONAL_PROPERTIES_MAX, "0", "20"});
                rc = false;
            }
        }
        int size = -1;
        try {
            size = Integer.parseInt(apSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (size < 16 || size > Short.MAX_VALUE) {
            size = -1;
        }
        if (size == -1) {
            Logging.writeMessage(12, "DFHPI9622E", new Object[]{OPT_ADDITIONAL_PROPERTIES_SIZE, "16", "32767"});
            rc = false;
        }
        return rc;
    }

    private boolean checkZosConnectEE(String zosConnectEE) {
        if (zosConnectEE == null || zosConnectEE.equals(EMPTY_STR)) {
            this.p.put(OPT_ZOS_CONNECT_EE, Boolean.valueOf(false).toString());
            return true;
        }
        if (this.toolInUse != 5 && this.toolInUse != 4) {
            Logging.writeMessage(12, "DFHPI9504E", new Object[]{OPT_ZOS_CONNECT_EE, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        try {
            if (!RuntimeLevelHelper.supportsRuntimeLevel_5_0(this.wsBindVerNumber)) {
                Logging.writeMessage(12, "DFHPI9628E", new Object[]{OPT_ZOS_CONNECT_EE, WSBind.MAJOR_VER_AS_STRING[this.wsBindVerNumber]});
                return false;
            }
        }
        catch (CICSWSDLException cICSWSDLException) {
            // empty catch block
        }
        if (zosConnectEE.equalsIgnoreCase("true") || zosConnectEE.equalsIgnoreCase("false")) {
            this.p.put(OPT_ZOS_CONNECT_EE, Boolean.valueOf(zosConnectEE).toString());
            return true;
        }
        Logging.writeMessage(12, "DFHPI9760E", new Object[0]);
        return false;
    }

    private boolean checkLanguageCountry(String languageCountry) {
        if (languageCountry == null || languageCountry.equals(EMPTY_STR)) {
            return true;
        }
        String language = EMPTY_STR;
        String country = EMPTY_STR;
        boolean valid = true;
        if (languageCountry.length() != 2 && languageCountry.length() != 5) {
            valid = false;
        }
        if (valid && languageCountry.length() == 5 && languageCountry.charAt(2) != '_') {
            valid = false;
        }
        if (valid) {
            language = languageCountry.substring(0, 2);
            if (languageCountry.length() == 5) {
                country = languageCountry.substring(3);
            }
            if (!language.equals(language.toLowerCase())) {
                valid = false;
            } else if (!country.equals(country.toUpperCase())) {
                valid = false;
            }
        }
        if (!valid) {
            Logging.writeMessage(12, "DFHPI9761E", new Object[0]);
            return false;
        }
        valid = false;
        for (SupportedLanguages l : SupportedLanguages.values()) {
            if (!l.name().equals(languageCountry)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            Logging.writeMessage(12, "DFHPI9762E", new Object[0]);
            return false;
        }
        this.p.put(OPT_LANGUAGE_COUNTRY, languageCountry);
        MessageHandler.setLocal(language, country);
        return true;
    }

    private boolean checkContainerNameSuffix(String containerNameSuffix) {
        if (containerNameSuffix == null || containerNameSuffix.equals(EMPTY_STR)) {
            return true;
        }
        if (this.toolInUse != 5) {
            Logging.writeMessage(12, "DFHPI9504E", new Object[]{OPT_CONTAINER_NAME_SUFFIX, TOOL_NAMES[this.toolInUse]});
            return false;
        }
        try {
            if (!RuntimeLevelHelper.supportsRuntimeLevel_5_0(this.wsBindVerNumber)) {
                Logging.writeMessage(12, "DFHPI9628E", new Object[]{OPT_CONTAINER_NAME_SUFFIX, WSBind.MAJOR_VER_AS_STRING[this.wsBindVerNumber]});
                return false;
            }
        }
        catch (CICSWSDLException cICSWSDLException) {
            // empty catch block
        }
        if (containerNameSuffix.length() < 9 && containerNameSuffix.matches("[a-zA-Z0-9]*")) {
            this.p.put(OPT_CONTAINER_NAME_SUFFIX, containerNameSuffix);
            return true;
        }
        Logging.writeMessage(12, "DFHPI9764E", new Object[]{containerNameSuffix});
        return false;
    }

    private boolean validateToken(String value, String[] validValues, String propertyName) {
        boolean rc = false;
        for (int i = 0; !rc && i < validValues.length; ++i) {
            rc = validValues[i].equalsIgnoreCase(value);
        }
        if (!rc) {
            String validValuesStr = Util.join(validValues);
            Object[] messageParms = new Object[]{propertyName, validValuesStr};
            Logging.writeMessage(8, "DFHPI9664E", messageParms);
        }
        return rc;
    }

    public String getBootStrapICM() {
        return this.bootStrapICM;
    }

    public boolean usePDSFiles() {
        return this.usePDSFiles;
    }

    public ICMInterceptor getICMInterceptor() {
        return this.interceptor;
    }

    static {
        if (BUILD_LEVEL_NAME.indexOf("BUILD_DATE") > -1) {
            BUILD_LEVEL_NAME = BUILD_LEVEL_UNKNOWN;
            BUILD_LEVEL_RELEASE = BUILD_LEVEL_UNKNOWN;
        }
        LINE_SEPARATOR = System.getProperty("line.separator");
        VALID_MAPPING_OVERRIDES_VALUES = new String[]{OPT_NO_ARRAY_NAME_INDEXING, OPT_SAME_AS_MAPPING_LEVEL, OPT_UNDERSCORES_AS_HYPHENS, OPT_VALUE_LESS_DUP_NAMES, OPT_JSON_INTEGER_AS_PIC9, OPT_HYPHENS_AS_UNDERSCORES};
        TOOL_NAMES = new String[]{TOOL_DFHWS2LS, TOOL_DFHLS2WS, TOOL_DFHSC2LS, TOOL_DFHLS2SC, TOOL_DFHLS2JS, TOOL_DFHJS2LS, "UNKNOWN TOOL CODE"};
        allValidParms = new HashSet<String>();
        PARM_VALID_FOR_TOOL = new ArrayList<ParameterRules>();
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_ADDITIONAL_PROPERTIES_DEFAULT, 0, 0, 0, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_ADDITIONAL_PROPERTIES_MAX, 0, 0, 0, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_ADDITIONAL_PROPERTIES_SIZE, 0, 0, 0, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_ALLOW_NON_EBCDIC, 1, 1, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_BINDING, 1, 0, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_BUNDLE, 0, 0, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_CCSID, 1, 1, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_CHAR_MULTIPLIER, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_CHAR_OCCURS, 0, 1, 0, 1, 0, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_CHAR_USAGE, 0, 1, 0, 1, 0, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_CHAR_VARYING, 1, 1, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_CHAR_VARYING_LIMIT, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_CHAR_WHITESPACE, 0, 0, 0, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_CONTID, 1, 1, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_DATA_TRUNCATION, 1, 1, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_DATA_SCREENING, 1, 1, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_DATETIME, 1, 1, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_DEFAULT_CHAR_MAXLENGTH, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_DEFAULT_ARRAY_MAXITEMS, 0, 0, 0, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_DEFAULT_FRACTION_DIGITS, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_DISABLE_CONTAINERS, 0, 0, 0, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_ELEMENTS, 0, 0, 1, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_HTTP_METHODS, 0, 0, 0, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_HTTPPROXY, 1, 1, 1, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_HTTPPROXY_USERNAME, 1, 1, 1, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_HTTPPROXY_PASSWORD, 1, 1, 1, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_INLINE_MAXOCCURS_LIMIT, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_JSON_SCHEMA, 0, 0, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_JSON_SCHEMA_CODEPAGE, 0, 0, 0, 0, 0, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_JSON_SCHEMA_REQUEST, 0, 0, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_JSON_SCHEMA_RESPONSE, 0, 0, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_JSON_SCHEMA_RESTFUL, 0, 0, 0, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_JSONTRANSFRM, 0, 0, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_LANG, 1, 2, 1, 2, 1, 2));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_LOGFILE, 2, 2, 2, 2, 2, 2));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_MAPPING_LEVEL, 1, 1, 1, 2, 2, 2));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_MAPPING_OVERRIDES, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_MINIMUM_RUNTIME_LEVEL, 1, 1, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_NAME_TRUNCATION, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_NAMESPACE, 0, 0, 0, 1, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_OPERATIONS, 1, 0, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_OPERATION_NAME, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_OVERWRITE_OUTPUT, 0, 0, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_PDSCP, 1, 1, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_PDSLIB, 1, 1, 1, 2, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_PDSMEM, 1, 0, 1, 2, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_PGMINT, 1, 1, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_PGMNAME, 1, 2, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_REQMEM, 1, 1, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_REQUEST_CHANNEL, 0, 1, 0, 0, 0, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_REQUEST_NAMESPACE, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_RESPMEM, 1, 1, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_RESPONSE_CHANNEL, 0, 1, 0, 0, 0, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_RESPONSE_NAMESPACE, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_SCHEMA, 0, 0, 1, 2, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_TRUNCATE_NULL_ARRAYS, 0, 1, 0, 1, 0, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_TRUNCATE_NULL_ARRAY_VALUES, 0, 1, 0, 1, 0, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_XMLCP, 0, 0, 1, 1, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_SERVICE, 1, 1, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_SOAPVER, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_STRUCTURE, 1, 1, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_SYNCONRETURN, 1, 1, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_TRANSACTION, 1, 1, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_TYPES, 0, 0, 1, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_URI, 1, 1, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_USERID, 1, 1, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_VENDOR_CONV_NAME, 1, 0, 1, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_VENDOR_INTF_LENGTH, 1, 0, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_VENDOR_META_DATA, 1, 0, 1, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSADDR_EPR_ANY, 1, 0, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSBIND, 2, 2, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSDL, 2, 1, 1, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSDLCP, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSDL_NAMESPACE, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSDL_SERVICE, 1, 0, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSDL_1_1, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSDL_2_0, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_XML_ONLY, 1, 0, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_XSDBIND, 0, 0, 2, 2, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_SSL_TRUSTSTORE, 1, 1, 1, 1, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_SSL_TRUSTPWD, true, 1, 1, 1, 1, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_SSL_KEYSTORE, 1, 1, 1, 1, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_SSL_KEYPWD, true, 1, 1, 1, 1, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSRR_SERVER, 1, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSRR_NAME, 1, 0, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSRR_NAMESPACE, 1, 0, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSRR_VERSION, 1, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSRR_USERNAME, 1, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSRR_PASSWORD, true, 1, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSRR_DESCRIPTION, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSRR_ENCODING, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WSRR_LOCATION, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_BINDING_NAME, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_PORT_NAME, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_SERVICE_NAME, 0, 1, 0, 0, 0, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_WIDE_COMP3, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_SAME_AS_MAPPING_LEVEL, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_UNDERSCORES_AS_HYPHENS, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_VALUE_LESS_DUP_NAMES, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_JSON_INTEGER_AS_PIC9, 0, 0, 0, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_NO_ARRAY_NAME_INDEXING, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_HYPHENS_AS_UNDERSCORES, 1, 0, 1, 0, 1, 0));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_ZOS_CONNECT_EE, 0, 0, 0, 0, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_LANGUAGE_COUNTRY, 1, 1, 1, 1, 1, 1));
        PARM_VALID_FOR_TOOL.add(new ParameterRules(OPT_CONTAINER_NAME_SUFFIX, 0, 0, 0, 0, 1, 0));
        allValidParms.add(OPT_REQUEST_STRUCT);
        allValidParms.add(OPT_RESPONSE_STRUCT);
        allValidParms.add(OPT_STYLE);
        allValidParms.add(OPT_INTERNAL_PGMNAME);
        allValidParms.add(OPT_INTERNAL_TOOLNAME);
        allValidParms.add(OPT_URI_ABSOLUTE);
        allValidParms.add(OPT_URI_RELATIVE);
        VALID_WSDLCP_VALUES = new String[]{WSDLCP_LOCAL_CP, WSDLCP_UTF8_CP, WSDLCP_US_EBCDIC_CP};
        VALID_CHAR_WHITESPACE_VALUES = new String[]{OPT_VALUE_COLLAPSE, OPT_VALUE_REPLACE, OPT_VALUE_PRESERVE};
        VALID_SYNCONRETURN_VALUES = new String[]{OPT_VALUE_YES, OPT_VALUE_NO};
        VALID_OVERWRITE_OUTPUT_VALUES = new String[]{OPT_VALUE_YES, OPT_VALUE_NO};
        VALID_WIDE_COMP3_VALUES = new String[]{OPT_VALUE_YES, OPT_VALUE_NO, OPT_VALUE_FULL};
        VALID_DATETIME_VALUES_TOP_DOWN = new String[]{OPT_VALUE_STRING, OPT_VALUE_PACKED15};
        VALID_DATETIME_VALUES_BOTTOM_UP = new String[]{OPT_VALUE_UNUSED, OPT_VALUE_PACKED15};
        VALID_DATA_TRUNCATION_VALUES = new String[]{OPT_VALUE_ENABLED, OPT_VALUE_DISABLED};
        VALID_DATA_SCREENING_VALUES = new String[]{OPT_VALUE_ENABLED, OPT_VALUE_DISABLED};
        VALID_TRUNCATE_NULL_ARRAYS_VALUES = new String[]{OPT_VALUE_ENABLED, OPT_VALUE_DISABLED};
        VALID_TRUNCATE_NULL_ARRAY_VALUES_VALUES = new String[]{OPT_VALUE_NULL, OPT_VALUE_SPACE, OPT_VALUE_ZERO, OPT_VALUE_PACKEDZERO};
        VALID_NAME_TRUNCATION_VALUES = new String[]{OPT_VALUE_LEFT, OPT_VALUE_RIGHT};
        VALID_HTTP_METHODS_VALUES = new String[]{OPT_VALUE_GET, OPT_VALUE_POST, OPT_VALUE_PUT, OPT_VALUE_DELETE, OPT_VALUE_HEAD};
        VALID_CHAR_OCCURS_VALUES = new String[]{OPT_VALUE_STRING, OPT_VALUE_ARRAY};
        VALID_CHAR_USAGE_VALUES = new String[]{OPT_VALUE_DBCS, OPT_VALUE_NATIONAL};
        VALID_ADDITIONAL_PROPERTIES_DEFAULT_VALUES = new String[]{OPT_VALUE_TRUE, OPT_VALUE_FALSE};
        transactionPattern = Pattern.compile("^[a-zA-Z0-9\u00a3$\u00a5@#<>_]+$");
        programNamePattern = Pattern.compile("^[a-zA-Z0-9\u00a3$\u00a5@#]+$");
        useridPattern = Pattern.compile("^[a-zA-Z0-9\u00a3$\u00a5@#]+$");
    }

    private static class ParameterRules {
        static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2020 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private static final String SCCSID = "%Z% %W% %I% %E% %U%";
        private int[] validationRules = new int[TOOL_NAMES.length];
        private String parmName = null;
        private boolean suppressValue = false;

        public ParameterRules(String parmName, int ws2ls2, int ls2ws2, int sc2ls2, int ls2sc2, int js2ls2, int ls2js2) {
            this.parmName = parmName;
            this.suppressValue = false;
            this.validationRules[0] = ws2ls2;
            this.validationRules[1] = ls2ws2;
            this.validationRules[2] = sc2ls2;
            this.validationRules[3] = ls2sc2;
            this.validationRules[5] = js2ls2;
            this.validationRules[4] = ls2js2;
            allValidParms.add(parmName);
        }

        public ParameterRules(String parmName, boolean suppressValue, int ws2ls2, int ls2ws2, int sc2ls2, int ls2sc2, int js2ls2, int ls2js2) {
            this.parmName = parmName;
            this.suppressValue = suppressValue;
            this.validationRules[0] = ws2ls2;
            this.validationRules[1] = ls2ws2;
            this.validationRules[2] = sc2ls2;
            this.validationRules[3] = ls2sc2;
            this.validationRules[5] = js2ls2;
            this.validationRules[4] = ls2js2;
            allValidParms.add(parmName);
        }

        public String getParmName() {
            return this.parmName;
        }

        public boolean validate(int tool, String value) {
            if (value != null && !ParmChecker.EMPTY_STR.equals(value) && this.validationRules[tool] == 0) {
                Logging.writeMessage(12, "DFHPI9504E", new Object[]{this.parmName, TOOL_NAMES[tool]});
                return false;
            }
            if ((value == null || ParmChecker.EMPTY_STR.equals(value)) && this.validationRules[tool] == 2) {
                Logging.writeMessage(8, "DFHPI9503E", new Object[]{this.parmName});
                return false;
            }
            return true;
        }

        public boolean parmValid(int tool) {
            return this.validationRules[tool] != 0;
        }

        public boolean getSuppressValue() {
            return this.suppressValue;
        }
    }

    private static class HTTPAuthenticator
    extends Authenticator {
        static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2007, 2020 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private static final String SCCSID = "%Z% %W% %I% %E% %U%";
        private String username;
        private String password;

        public HTTPAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }

    private static enum SupportedLanguages {
        cs,
        de,
        en,
        es,
        fr,
        hu,
        it,
        ja,
        ko,
        pl,
        pt_BR,
        ro,
        ru,
        zh_CN,
        zh_TW,
        zh;

    }
}

