/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.gen.api.IPlatform;
import java.util.HashMap;
import java.util.Map;

public class Platform
implements IPlatform {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2005, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private IPlatform.FloatStyle floatStyle;
    private Map<IPlatform.AlignableDataType, IPlatform.AlignmentLevel> alignments = new HashMap<IPlatform.AlignableDataType, IPlatform.AlignmentLevel>();
    private IPlatform.EndianType endianType;
    private IPlatform.ZonedEncodingType zonedEncodingType;

    public Platform() {
        this.floatStyle = IPlatform.FloatStyle.IBM_HEX_FLOAT;
        this.alignments.put(IPlatform.AlignableDataType.SHORT, IPlatform.AlignmentLevel.TWO_BYTES);
        this.alignments.put(IPlatform.AlignableDataType.INT, IPlatform.AlignmentLevel.FOUR_BYTES);
        this.alignments.put(IPlatform.AlignableDataType.LONG, IPlatform.AlignmentLevel.EIGHT_BYTES);
        this.alignments.put(IPlatform.AlignableDataType.FLOAT, IPlatform.AlignmentLevel.FOUR_BYTES);
        this.alignments.put(IPlatform.AlignableDataType.DOUBLE, IPlatform.AlignmentLevel.EIGHT_BYTES);
        this.endianType = IPlatform.EndianType.BIG_ENDIAN;
        this.zonedEncodingType = IPlatform.ZonedEncodingType.ZONED_EBCDIC;
    }

    @Override
    public void setFloatStyle(IPlatform.FloatStyle floatStyle) {
        this.floatStyle = floatStyle;
    }

    @Override
    public IPlatform.FloatStyle getFloatStyle() {
        return this.floatStyle;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Endian=" + (Object)((Object)this.endianType));
        sb.append(" Float=" + (Object)((Object)this.getFloatStyle()));
        sb.append(" Zoned=" + (Object)((Object)this.getZonedEncoding()));
        for (IPlatform.AlignableDataType adt : IPlatform.AlignableDataType.values()) {
            sb.append(" " + (Object)((Object)adt) + "=" + (Object)((Object)this.alignments.get((Object)adt)));
        }
        return sb.toString();
    }

    @Override
    public void setAlignment(IPlatform.AlignableDataType dataType, IPlatform.AlignmentLevel alignment) {
        this.alignments.put(dataType, alignment);
    }

    @Override
    public IPlatform.AlignmentLevel getAlignment(IPlatform.AlignableDataType dataType) {
        return this.alignments.get((Object)dataType);
    }

    @Override
    public void setEndian(IPlatform.EndianType endianness) {
        this.endianType = endianness;
    }

    @Override
    public IPlatform.EndianType getEndianness() {
        return this.endianType;
    }

    @Override
    public void setZonedEncoding(IPlatform.ZonedEncodingType zoned) {
        this.zonedEncodingType = zoned;
    }

    @Override
    public IPlatform.ZonedEncodingType getZonedEncoding() {
        return this.zonedEncodingType;
    }
}

