/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final Pattern illegalURICharsPattern = Pattern.compile("[ <>#\"{}|\\^\\[\\]`\u00dd\u00a8]");
    private static final Pattern invalidCharsPattern = Pattern.compile("[ \\{}^\\[\\]`]");

    public static ICM.BindingStyle getStyle(String style, boolean forIndex) {
        ICM.BindingStyle soapStyle = null;
        String upperStyle = style.toUpperCase(Locale.ENGLISH);
        if (upperStyle.indexOf("RPC") > -1) {
            soapStyle = ICM.BindingStyle.RPC_STYLE;
        } else {
            if (upperStyle.indexOf("DOC") > -1) {
                soapStyle = ICM.BindingStyle.DOCUMENT_STYLE;
            }
            if (upperStyle.indexOf("WRAPPED") > -1) {
                soapStyle = forIndex ? ICM.BindingStyle.RPC_STYLE : ICM.BindingStyle.WRAPPED_STYLE;
            }
        }
        return soapStyle;
    }

    public static int getPgmInterface(String pgmint) {
        int programInterface = 0;
        if (pgmint.equals("CHANNEL")) {
            programInterface = 1;
        } else if (pgmint.equals("COMMAREA")) {
            programInterface = 2;
        } else if (pgmint.equals("NA")) {
            programInterface = 3;
        }
        return programInterface;
    }

    public static int getLanguage(String language) {
        int lang = -1;
        if (language != null) {
            if (language.equalsIgnoreCase("COBOL")) {
                lang = 1;
            } else if (language.equalsIgnoreCase("PLI-ENTERPRISE")) {
                lang = 2;
            } else if (language.equalsIgnoreCase("PL/I-ENTERPRISE")) {
                lang = 2;
            } else if (language.equalsIgnoreCase("PLI-OTHER")) {
                lang = 6;
            } else if (language.equalsIgnoreCase("PL/I-OTHER")) {
                lang = 6;
            } else if (language.equalsIgnoreCase("C")) {
                lang = 3;
            } else if (language.equalsIgnoreCase("CPP")) {
                lang = 4;
            } else if (language.equalsIgnoreCase("PLX")) {
                lang = 7;
            }
        }
        return lang;
    }

    public static byte[] padBytes(byte[] bytes) {
        byte[] b = bytes;
        for (int i = b.length - 1; i > 0 && b[i] == 0; --i) {
            b[i] = 64;
        }
        return b;
    }

    protected static boolean isValidURIChars(String s) {
        boolean valid = true;
        Matcher matcher = illegalURICharsPattern.matcher(s);
        while (matcher.find()) {
            Logging.writeMessage(8, "DFHPI9533E", new Object[]{"URI", matcher.group(), matcher.start() + 1, s});
            valid = false;
        }
        return valid;
    }

    protected static boolean isValidContainerName(String s) {
        boolean valid = true;
        Matcher matcher = invalidCharsPattern.matcher(s);
        while (matcher.find()) {
            Logging.writeMessage(8, "DFHPI9533E", new Object[]{"CONTID", matcher.group(), matcher.start() + 1, s});
            valid = false;
        }
        return valid;
    }

    public static int stringToInt(String numberStr, int defaultNum, boolean throwEx, String fileName) throws CICSWSDLException {
        int num = defaultNum;
        try {
            num = Integer.parseInt(numberStr);
        }
        catch (NumberFormatException e) {
            if (!throwEx) {
                Logging.writeMessage(12, "DFHPI9552E", new Object[]{numberStr, fileName});
                num = defaultNum;
            }
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9552E", new Object[]{numberStr, fileName}));
            newEx.initCause(e);
            throw newEx;
        }
        return num;
    }

    public static int stringToInt(String numberStr, int defaultNum, String fileName) {
        try {
            return Util.stringToInt(numberStr, defaultNum, false, fileName);
        }
        catch (CICSWSDLException CWE) {
            throw new RuntimeException(CWE);
        }
    }

    public static String join(String[] stringArr) {
        return Util.join(stringArr, ", ");
    }

    public static String join(String[] stringArr, String delim) {
        StringBuilder sb = new StringBuilder();
        int arrLength = stringArr.length;
        if (arrLength != 0) {
            int lastIndex = arrLength - 1;
            for (int i = 0; i < lastIndex; ++i) {
                sb.append(stringArr[i]);
                sb.append(delim);
            }
            sb.append(stringArr[lastIndex]);
        }
        return sb.toString();
    }

    public static void checkXMLEncoding(String wsdlFile, PrintStream logger, boolean runZOS) throws CICSWSDLException, FileNotFoundException {
        File scanFile = new File(wsdlFile);
        FileInputStream inputStream = new FileInputStream(scanFile);
        Util.checkXMLEncoding(inputStream, logger, runZOS, wsdlFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkXMLEncoding(InputStream wsdlFileStream, PrintStream logger, boolean runZOS, String displayName) throws CICSWSDLException, FileNotFoundException {
        InputStreamReader read = null;
        if (runZOS) {
            try {
                read = new InputStreamReader(wsdlFileStream, "Cp037");
            }
            catch (UnsupportedEncodingException uee) {
                return;
            }
        } else {
            read = new InputStreamReader(wsdlFileStream);
        }
        BufferedReader reader = new BufferedReader(read);
        StringBuilder data = new StringBuilder("");
        boolean closeTagFound = false;
        try {
            String stream;
            while ((stream = reader.readLine()) != null) {
                data.append(stream);
                if (stream.indexOf(">") == -1) continue;
                closeTagFound = true;
                break;
            }
            wsdlFileStream.close();
        }
        catch (IOException e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{displayName, e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            return;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace(logger);
            }
        }
        if (data.toString().substring(0, 2).indexOf("<") == -1) {
            return;
        }
        if (!closeTagFound) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9604E", new Object[]{displayName}));
        }
        String upperData = data.toString().toUpperCase(Locale.ENGLISH);
        int encodingPos = upperData.indexOf("ENCODING");
        if (encodingPos != -1) {
            int quote;
            int openQuotePos = (upperData = upperData.substring(encodingPos)).indexOf(quote = 34) + 1;
            if (openQuotePos == 0) {
                quote = 39;
                openQuotePos = upperData.indexOf(quote) + 1;
            }
            if (openQuotePos == 0) {
                return;
            }
            int closeQuotePos = (upperData = upperData.substring(openQuotePos)).indexOf(quote);
            if (closeQuotePos == -1) {
                return;
            }
            if ((upperData = upperData.substring(0, closeQuotePos)).indexOf("EBCDIC") == -1 && upperData.indexOf("CP037") == -1) {
                if (runZOS) {
                    throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9606E"));
                }
            } else if (!runZOS) {
                throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9605E"));
            }
        }
    }

    public static File confirmFileForOutput(String fileName) throws CICSWSDLException {
        File file = new File(fileName);
        File parentDirectory = null;
        if (file.getParent() != null) {
            parentDirectory = new File(file.getParent());
        }
        Util.checkDirExistsAndIsWritable(parentDirectory);
        return file;
    }

    public static void checkDirExistsAndIsWritable(File directory) throws CICSWSDLException {
        if (directory == null || !directory.exists()) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9525E", new Object[]{directory}));
        }
        if (!directory.canWrite()) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9526E", new Object[]{directory}));
        }
    }

    public static boolean isResponseCodeEntity(String name) {
        if (name.length() == 15 && name.equals("responseCodeDef")) {
            return true;
        }
        return name.length() == 15 && name.substring(0, 12).equals("responseCode") && name.charAt(12) >= '2' && name.charAt(12) < '6' && (name.charAt(13) >= '0' && name.charAt(13) <= '9' || name.charAt(13) == 'X') && (name.charAt(14) >= '0' && name.charAt(14) <= '9' || name.charAt(14) == 'X');
    }
}

