/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.util.CodePageHelper;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.schema.utils.RuntimeLevelHelper;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.common.WSBindAbstractTypeEntry;
import com.ibm.cics.wsdl.common.WSBindOperationEntry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class WSBind {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int VALIDATION = 0;
    private static final String BLANK_SPACE = " ";
    protected static final Charset US_EBCDIC = Charset.forName("Cp037");
    protected static final char SUPPLIED_ACTION = 'S';
    protected static final int LENGTH_OF_EYECATCHER = 8;
    protected static final String EYE_CATCHER = ">WSBIND<";
    protected static final int LENGTH_OF_WSBIND_LENGTH = 4;
    protected static final int OFFSET_OF_WSBIND_LENGTH = 8;
    protected static final int LENGTH_OF_TIMESTAMP = 12;
    protected static final int OFFSET_OF_TIMESTAMP = 12;
    protected static final int LENGTH_OF_TYPE_NAME = 255;
    protected static final int OFFSET_OF_TYPE_NAME = 0;
    protected static final int LENGTH_OF_TYPE_NAME_NAMESPACE = 255;
    protected static final int OFFSET_OF_TYPE_NAME_NAMESPACE = 255;
    public static final byte CICS_PRODUCT_NUMBER = 1;
    protected static final int VENDOR_PRODUCT_NUMBER = -16777216;
    public static final byte VENDOR_PRODUCT_NUMBER_ORIG = -1;
    public static final byte VENDOR_PRODUCT_NUMBER_1_2 = -2;
    private static final int LENGTH_OF_PRODUCT_NUMBER = 1;
    protected static final int OFFSET_OF_PRODUCT_NUMBER = 24;
    public static final byte MAJOR_VERSION_1 = 0;
    public static final byte MAJOR_VERSION_1_1 = 1;
    public static final byte MAJOR_VERSION_1_2 = 2;
    public static final byte MAJOR_VERSION_2 = 3;
    public static final byte MAJOR_VERSION_2_1 = 4;
    public static final byte MAJOR_VERSION_2_2 = 5;
    public static final byte MAJOR_VERSION_3_0 = 6;
    public static final byte MAJOR_VERSION_4_0 = 7;
    public static final byte MAJOR_VERSION_4_1 = 8;
    public static final byte MAJOR_VERSION_4_2 = 9;
    public static final byte MAJOR_VERSION_4_3 = 10;
    public static final byte MAJOR_VERSION_4_4 = 11;
    public static final byte MAJOR_VERSION_5_0 = 12;
    private static final int LENGTH_OF_MAJOR_VERSION = 1;
    protected static final byte OFFSET_OF_MAJOR_VERSION = 25;
    public static final String[] MAJOR_VER_AS_STRING = new String[]{"1.0", "1.1", "1.2", "2.0", "2.1", "2.2", "3.0", "4.0", "4.1", "4.2", "4.3", "4.4", "5.0"};
    protected static final byte[] MINOR_VERSION_1 = new byte[]{0, 1};
    protected static final byte[] MINOR_VERSION_1_1 = new byte[]{0, 0};
    protected static final byte[] MINOR_VERSION_1_2 = new byte[]{0, 0};
    protected static final byte[] MINOR_VERSION_2 = new byte[]{0, 0};
    protected static final byte[] MINOR_VERSION_2_1 = new byte[]{0, 0};
    protected static final byte[] MINOR_VERSION_2_2 = new byte[]{0, 0};
    protected static final byte[] MINOR_VERSION_3_0 = new byte[]{0, 0};
    protected static final byte[] MINOR_VERSION_4_0 = new byte[]{0, 0};
    protected static final byte[] MINOR_VERSION_4_1 = new byte[]{0, 0};
    protected static final byte[] MINOR_VERSION_4_2 = new byte[]{0, 0};
    protected static final byte[] MINOR_VERSION_4_3 = new byte[]{0, 0};
    protected static final byte[] MINOR_VERSION_4_4 = new byte[]{0, 0};
    protected static final byte[] MINOR_VERSION_5_0 = new byte[]{0, 0};
    protected static final int OFFSET_OF_MINOR_VERSION = 26;
    private static final int LENGTH_OF_MINOR_VERSION = 2;
    protected static final int LENGTH_OF_WSBIND_NAME = 255;
    protected static final int OFFSET_OF_WSBIND_NAME = 28;
    private static final int LENGTH_OF_FLAGS_BYTE = 1;
    protected static final int OFFSET_OF_FLAGS_BYTE = 283;
    private static final int LENGTH_OF_INDEX_OFFSET = 4;
    protected static final int OFFSET_OF_INDEX_OFFSET = 284;
    protected static final int LENGTH_OF_NUM_ENTRIES = 4;
    protected static final int OFFSET_OF_NUM_ENTRIES = 288;
    private static final int LENGTH_OF_SOAP_STYLE = 1;
    protected static final int OFFSET_OF_SOAP_STYLE = 292;
    protected static final int LENGTH_OF_WSDL_NAME = 255;
    protected static final int OFFSET_OF_WSDL_NAME = 293;
    protected static final int LENGTH_OF_BINDING_NAME = 255;
    protected static final int OFFSET_OF_BINDING_NAME = 548;
    protected static final int LENGTH_OF_PGMNAME = 8;
    protected static final int OFFSET_OF_PGMNAME = 803;
    protected static final int LENGTH_OF_URI = 255;
    protected static final int OFFSET_OF_URI = 811;
    protected static final int LENGTH_OF_ENDPOINT = 255;
    protected static final int OFFSET_OF_ENDPOINT = 1066;
    public static final byte PGMINT_CHANNEL = 1;
    public static final byte PGMINT_COMMAREA = 2;
    public static final byte PGMINT_NOTAPPLIC = 3;
    private static final int LENGTH_OF_PGMINTERFACE = 1;
    protected static final int OFFSET_OF_PGMINTERFACE = 1321;
    protected static final int LENGTH_OF_CONTID = 16;
    protected static final int OFFSET_OF_CONTID = 1322;
    private static final int LENGTH_OF_VALIDATION = 1;
    protected static final int OFFSET_OF_VALIDATION = 1338;
    protected static final int LENGTH_OF_LAST_MODIFIED = 8;
    protected static final int OFFSET_OF_LAST_MODIFIED = 1339;
    protected static final int LENGTH_OF_TRANID = 4;
    protected static final int OFFSET_OF_TRANID = 1347;
    protected static final int LENGTH_OF_SECID = 8;
    protected static final int OFFSET_OF_SECID = 1351;
    protected static final int LENGTH_OF_PIPELINE = 8;
    protected static final int OFFSET_OF_PIPELINE = 1359;
    protected static final int LENGTH_OF_URIMAP = 8;
    protected static final int OFFSET_OF_URIMAP = 1367;
    private static final int LENGTH_OF_STATE = 1;
    protected static final int OFFSET_OF_STATE = 1375;
    private static final int LENGTH_OF_HEADER_SECTION = 1376;
    protected static final int LENGTH_OF_CCSID = 4;
    protected static final int OFFSET_OF_CCSID = 1376;
    private static final int LENGTH_OF_EMPTY_SPACE_1_2 = 772;
    private static final int LENGTH_OF_VER_BYTE = 1;
    protected static final int OFFSET_OF_VER_BYTE = 1380;
    protected static final int LENGTH_OF_WSDL_NAME_2_0 = 255;
    protected static final int OFFSET_OF_WSDL_NAME_2_0 = 1381;
    protected static final int LENGTH_OF_WSDL_NAMESPACE = 255;
    protected static final int OFFSET_OF_WSDL_NAMESPACE = 1636;
    protected static final int LENGTH_OF_PORT_NS_NAME = 255;
    protected static final int OFFSET_OF_PORT_NS_NAME = 1891;
    protected static final int LENGTH_OF_ENDPOINT_LENGTH = 2;
    protected static final int OFFSET_OF_ENDPOINT_LENGTH = 2146;
    protected static final int LENGTH_OF_ENDPOINT_OFFSET = 4;
    protected static final int OFFSET_OF_ENDPOINT_OFFSET = 2148;
    private static final int LENGTH_OF_EMPTY_SPACE_2_0 = 516;
    private static final int OFFSET_OF_EMPTY_SPACE_2_0 = 1636;
    private static final int LENGTH_OF_EMPTY_SPACE_2_1 = 6;
    protected static final int LENGTH_OF_VENDOR_CONVERTER_NAME = 8;
    protected static final int OFFSET_OF_VENDOR_CONVERTER_NAME = 2152;
    protected static final int LENGTH_OF_VENDOR_BUFFER_LENGTH = 4;
    protected static final int OFFSET_OF_VENDOR_BUFFER_LENGTH = 2160;
    private static final int LENGTH_OF_VENDOR_META_DATA_LENGTH = 4;
    protected static final int OFFSET_OF_VENDOR_META_DATA_LENGTH = 2164;
    private static final int LENGTH_OF_OFFSET_OF_VENDOR_META_DATA = 4;
    protected static final int OFFSET_OF_OFFSET_OF_VENDOR_META_DATA = 2168;
    private static final int LENGTH_OF_VENDOR_RESERVED = 30;
    private static final int OFFSET_OF_VENDOR_RESERVED = 2172;
    private static final int TOTAL_LENGTH_OF_VENDOR_BYTES = 50;
    private static final int LENGTH_OF_POST_VENDOR_PADDING_BYTES = 6;
    private static final int OFFSET_OF_POST_VENDOR_PADDING_BYTES = 2202;
    protected static final int LENGTH_OF_REQ_CHANNEL_DESCRIPTION_FILE = 256;
    protected static final int OFFSET_OF_REQ_CHANNEL_DESCRIPTION_FILE = 2208;
    protected static final int LENGTH_OF_RESP_CHANNEL_DESCRIPTION_FILE = 256;
    protected static final int OFFSET_OF_RESP_CHANNEL_DESCRIPTION_FILE = 2464;
    protected static final int LENGTH_OF_REQ_CHANNEL_NAME = 16;
    protected static final int OFFSET_OF_REQ_CHANNEL_NAME = 2720;
    protected static final int LENGTH_OF_RESP_CHANNEL_NAME = 16;
    protected static final int OFFSET_OF_RESP_CHANNEL_NAME = 2736;
    protected static final int LENGTH_OF_ALT_CCSID = 4;
    protected static final int OFFSET_OF_ALT_CCSID = 2752;
    protected static final int LENGTH_OF_OPERATION_NAME = 255;
    protected static final int OFFSET_OF_OPERATION_NAME = 0;
    protected static final int LENGTH_OF_OPERATION_SIGNATURE = 255;
    protected static final int OFFSET_OF_OPERATION_SIGNATURE = 255;
    private static final int LENGTH_OF_HTTP_BITS = 1;
    protected static final int OFFSET_OF_HTTP_BITS = 510;
    protected static final int LENGTH_OF_MEP_BITS = 1;
    protected static final int OFFSET_OF_MEP_BITS = 511;
    private static final int LENGTH_OF_INPUT_ICM_OFFSET = 4;
    protected static final int OFFSET_OF_INPUT_ICM_OFFSET = 512;
    protected static final int LENGTH_OF_OUTPUT_ICM_OFFSET = 4;
    protected static final int OFFSET_OF_OUTPUT_ICM_OFFSET = 516;
    protected static final int LENGTH_OF_SOAPACTION = 255;
    protected static final int OFFSET_OF_SOAPACTION = 520;
    private static final int LENGTH_OF_PADDING_BYTE1 = 1;
    protected static final int OFFSET_OF_PADDING_BYTE1 = 775;
    protected static final int LENGTH_OF_INPUTACTION = 255;
    protected static final int OFFSET_OF_INPUTACTION = 776;
    private static final int LENGTH_OF_INPUT_FLAG_BYTE = 1;
    protected static final int OFFSET_OF_INPUT_FLAG_BYTE = 1031;
    protected static final int LENGTH_OF_OUTPUTACTION = 255;
    protected static final int OFFSET_OF_OUTPUTACTION = 1032;
    private static final int LENGTH_OF_OUTPUT_FLAG_BYTE = 1;
    protected static final int OFFSET_OF_OUTPUT_FLAG_BYTE = 1287;
    protected static final int LENGTH_OF_FAULTACTION = 255;
    protected static final int OFFSET_OF_FAULTACTION = 1288;
    private static final int LENGTH_OF_FAULT_FLAG_BYTE = 1;
    protected static final int OFFSET_OF_FAULT_FLAG_BYTE = 1543;
    protected static final int LENGTH_OF_ONE_INDEX_ENTRY = 776;
    protected static final int LENGTH_OF_ONE_INDEX_ENTRY_3_0 = 1544;
    protected static final int LENGTH_OF_FAULTACTION_TABLE_LENGTH = 4;
    protected static final int OFFSET_OF_FAULTACTION_TABLE = 1544;
    private Properties p;
    private List<WSBindOperationEntry> operations;
    private File wsbindFile = null;
    private PrintStream log = Logging.getPrintStream();
    private byte bindFileVersionNumber = 0;
    private boolean vendorWSBindFile = false;
    private byte[] vendorMetaData = null;
    private boolean syncOnReturn = false;
    private int soapVersion = 0;
    public static final int SOAP_VER_UNSPECIFIED = 0;
    public static final int SOAP_VER_1_1 = 1;
    public static final int SOAP_VER_1_2 = 2;
    private static final String[] SOAP_VER_AS_STRING = new String[]{"1.1", "1.1", "1.2"};
    private int WSDLVersion = 0;
    public static final int WSDL_VER_UNSPECIFIED = 0;
    public static final int WSDL_VER_1_1 = 1;
    public static final int WSDL_VER_2_0 = 2;
    public static final int WSDL_VER_1_1_and_2_0 = 3;
    private int mappingLevel = -1;
    private String endpointReference = null;
    private String requestChannelName = null;
    private String responseChannelName = null;
    private int ccsid;
    private int altCcsid;

    public WSBind(Properties props, byte bindFileVersionNumber, boolean vendorWSBindFile, byte[] vendorMetaData, int soapVersion, int WSDLVersion, int mappingLevel, String requestChannelName, String responseChannelName) {
        this.p = props;
        this.bindFileVersionNumber = bindFileVersionNumber;
        this.vendorWSBindFile = vendorWSBindFile;
        this.soapVersion = soapVersion;
        this.WSDLVersion = WSDLVersion;
        this.mappingLevel = mappingLevel;
        this.operations = new ArrayList<WSBindOperationEntry>();
        this.requestChannelName = requestChannelName;
        this.responseChannelName = responseChannelName;
        if (vendorMetaData != null) {
            this.vendorMetaData = new byte[vendorMetaData.length];
            System.arraycopy(vendorMetaData, 0, this.vendorMetaData, 0, vendorMetaData.length);
        } else {
            this.vendorMetaData = null;
        }
        if (props.containsKey("UTF-16")) {
            this.ccsid = 1200;
            this.altCcsid = CodePageHelper.getApplicationCCSID(props.getProperty("CCSID"));
        } else {
            this.ccsid = CodePageHelper.getApplicationCCSID(props.getProperty("CCSID"));
            this.altCcsid = 0;
        }
    }

    public final void addOperation(WSBindOperationEntry operation) {
        this.operations.add(operation);
    }

    public final List<WSBindOperationEntry> getOperations() {
        return this.operations;
    }

    public boolean isSyncOnReturn() {
        return this.syncOnReturn;
    }

    public void setSyncOnReturn(boolean value) {
        this.syncOnReturn = value;
    }

    public final void checkUniqueSigs() throws CICSWSDLException {
        List<WSBindOperationEntry> ops = this.getOperations();
        ArrayList<String> sigs = new ArrayList<String>();
        for (int i = 0; i < ops.size(); ++i) {
            WSBindOperationEntry thisOp = ops.get(i);
            if (thisOp.getMEP() == 254) continue;
            String thisSig = thisOp.getSignature();
            if (sigs.contains(thisSig)) {
                CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9534E", new Object[]{thisSig}));
                throw newEx;
            }
            sigs.add(thisSig);
        }
    }

    public final void deleteFile() {
        if (this.wsbindFile != null) {
            this.log.println("cleaning up WSBind file, '" + this.wsbindFile.getAbsolutePath() + "'");
            boolean deleted = this.wsbindFile.delete();
            if (!deleted) {
                this.log.println("couldn't delete the WSBind file");
            }
        }
    }

    public final void writeToFile(String filename, Date timestamp, String targetNamespace, String portNSName) throws CICSWSDLException {
        OutputStream wsBindFileOS = null;
        FileInputStream fis = null;
        try {
            this.wsbindFile = Util.confirmFileForOutput(filename);
            wsBindFileOS = new FileOutputStream(this.wsbindFile);
            this.createWSBind(timestamp, wsBindFileOS, targetNamespace, portNSName);
            wsBindFileOS.close();
            if (this.wsbindFile.length() < 524288L) {
                this.log.println(LINE_SEPARATOR + LINE_SEPARATOR + LINE_SEPARATOR + "The contents of the WSBind file follow:" + LINE_SEPARATOR);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[10000];
                fis = new FileInputStream(this.wsbindFile);
                int bytesRead = fis.read(buffer, 0, buffer.length);
                while (bytesRead > -1) {
                    baos.write(buffer, 0, bytesRead);
                    bytesRead = fis.read(buffer, 0, buffer.length);
                }
                ByteArray wsBindFileAsBytes = new ByteArray(baos.toByteArray(), true);
                wsBindFileAsBytes.logReadableBinaryData(US_EBCDIC, this.log);
            } else {
                this.log.println(LINE_SEPARATOR + LINE_SEPARATOR + LINE_SEPARATOR + "The WSBind file is too long for inclusion in the log");
            }
        }
        catch (Exception e) {
            try {
                this.wsbindFile.delete();
            }
            catch (Exception exc) {
                exc.printStackTrace(this.log);
            }
            CICSWSDLException newEx = new CICSWSDLException(e.getLocalizedMessage());
            newEx.initCause(e);
            throw newEx;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(this.log);
                }
            }
            if (wsBindFileOS != null) {
                try {
                    wsBindFileOS.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setEndpointReference(String epr) {
        this.endpointReference = epr;
    }

    private int handleICM(int currentOffset, WSBindOperationEntry operation, boolean input) {
        ICM icm = null;
        icm = input ? operation.getInputICM() : operation.getOutputICM();
        if (icm != null) {
            String[] warnings = icm.getMessages();
            for (int j = 0; j < warnings.length; ++j) {
                Logging.writePreFormattedMessage(4, warnings[j]);
            }
            if (input) {
                operation.setInputICMOffset(currentOffset);
            } else {
                operation.setOutputICMOffset(currentOffset);
            }
            currentOffset = (int)((long)currentOffset + icm.getICMLength());
            int rem = currentOffset % 8;
            if (rem > 0) {
                currentOffset += 8 - rem;
            }
        }
        return currentOffset;
    }

    private void addICMToWSBindFile(WSBindOperationEntry operation, boolean input, OutputStream output) throws IOException, ICMException, Exception {
        ICM icm = null;
        icm = input ? operation.getInputICM() : operation.getOutputICM();
        if (icm != null) {
            byte[] icmBytes = icm.toByteArray();
            output.write(icmBytes);
            int rem = icmBytes.length % 8;
            if (rem > 0) {
                output.write(ByteArray.toCodePageByteArray(BLANK_SPACE, 8 - rem, US_EBCDIC));
            }
        }
    }

    protected final void createWSBind(Date timestamp, OutputStream output, String targetNamespace, String portNSName) throws CICSWSDLException, IOException, Exception {
        int remainder;
        int i;
        WSBindOperationEntry oper = null;
        int offsetSoFar = 0;
        for (i = 0; i < this.operations.size(); ++i) {
            oper = this.operations.get(i);
            offsetSoFar = this.handleICM(offsetSoFar, oper, true);
        }
        for (i = 0; i < this.operations.size(); ++i) {
            oper = this.operations.get(i);
            offsetSoFar = this.handleICM(offsetSoFar, oper, false);
        }
        ByteArrayOutputStream index = new ByteArrayOutputStream();
        int indexLength = 0;
        if (RuntimeLevelHelper.supportsRuntimeLevel_4_0(this.bindFileVersionNumber)) {
            for (int i2 = 0; i2 < this.operations.size(); ++i2) {
                try {
                    indexLength += 1548 + this.operations.get(i2).createFaultActionTable().length;
                    continue;
                }
                catch (ICMException exc) {
                    CICSWSDLException newEx = new CICSWSDLException(exc.getLocalizedMessage());
                    newEx.initCause(exc);
                    throw newEx;
                }
            }
        } else {
            indexLength = RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.bindFileVersionNumber) ? 1544 * this.operations.size() : 776 * this.operations.size();
        }
        int headerLength = 1376;
        int startingOffset = headerLength + 50 + indexLength;
        if (RuntimeLevelHelper.supportsRuntimeLevel_1_2(this.bindFileVersionNumber)) {
            headerLength = headerLength + 776 + 50 + 6;
            startingOffset = headerLength + indexLength;
        }
        if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.bindFileVersionNumber)) {
            headerLength = headerLength + 256 + 256 + 16 + 16;
            startingOffset = headerLength + indexLength;
        }
        if (RuntimeLevelHelper.supportsRuntimeLevel_4_0(this.bindFileVersionNumber)) {
            startingOffset = (headerLength += 4) + indexLength;
        }
        if ((remainder = startingOffset % 8) > 0) {
            startingOffset += 8 - remainder;
        }
        try {
            CICSWSDLException newEx;
            int endpointReferenceOffset;
            ByteArrayOutputStream header;
            block131: {
                block130: {
                    for (int i3 = 0; i3 < this.operations.size(); ++i3) {
                        WSBindOperationEntry operation;
                        block128: {
                            block129: {
                                block127: {
                                    operation = this.operations.get(i3);
                                    try {
                                        index.write(ByteArray.toEBCDICByteArray(operation.getName(), 255));
                                        index.write(ByteArray.toEBCDICByteArray(operation.getSignature(), 255));
                                    }
                                    catch (RuntimeException e) {
                                        CICSWSDLException newEx2 = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9535E", new Object[]{operation.getName(), 255}));
                                        newEx2.initCause(e);
                                        throw newEx2;
                                    }
                                    String methods = this.p.getProperty("HTTP-METHODS");
                                    if (methods == null) break block127;
                                    int methodsAsByte = 0;
                                    if (methods.contains("GET")) {
                                        methodsAsByte = (byte)(methodsAsByte | 0x80);
                                    }
                                    if (methods.contains("POST")) {
                                        methodsAsByte = (byte)(methodsAsByte | 0x40);
                                    }
                                    if (methods.contains("PUT")) {
                                        methodsAsByte = (byte)(methodsAsByte | 0x20);
                                    }
                                    if (methods.contains("DELETE")) {
                                        methodsAsByte = (byte)(methodsAsByte | 0x10);
                                    }
                                    if (methods.contains("HEAD")) {
                                        methodsAsByte = (byte)(methodsAsByte | 8);
                                    }
                                    index.write(ByteArray.numToByteArray(methodsAsByte, 1));
                                    index.write(ByteArray.numToByteArray(0L, 1));
                                    break block128;
                                }
                                if (!RuntimeLevelHelper.supportsRuntimeLevel_2_0(this.bindFileVersionNumber)) break block129;
                                switch (operation.getHTTPMethod()) {
                                    case 1: {
                                        index.write(ByteArray.numToByteArray(128L, 1));
                                        break;
                                    }
                                    case 2: {
                                        index.write(ByteArray.numToByteArray(64L, 1));
                                        break;
                                    }
                                    default: {
                                        if (operation.getMEP() == 254) {
                                            index.write(ByteArray.numToByteArray(0L, 1));
                                            break;
                                        }
                                        throw new CICSWSDLException("INTERNAL ERROR: bad HTTP method: " + operation.getHTTPMethod());
                                    }
                                }
                                switch (operation.getMEP()) {
                                    case 2: {
                                        index.write(ByteArray.numToByteArray(1L, 1));
                                        break block128;
                                    }
                                    case 1: {
                                        index.write(ByteArray.numToByteArray(2L, 1));
                                        break block128;
                                    }
                                    case 3: {
                                        index.write(ByteArray.numToByteArray(4L, 1));
                                        break block128;
                                    }
                                    case 4: {
                                        index.write(ByteArray.numToByteArray(8L, 1));
                                        break block128;
                                    }
                                    case 254: {
                                        index.write(ByteArray.numToByteArray(-128L, 1));
                                        break block128;
                                    }
                                    default: {
                                        throw new CICSWSDLException("INTERNAL ERROR: bad MEP: " + operation.getMEP());
                                    }
                                }
                            }
                            index.write(ByteArray.toCodePageByteArray(BLANK_SPACE, 2, US_EBCDIC));
                        }
                        index.write(ByteArray.numToByteArray(operation.getInputICMOffset() + startingOffset, 4));
                        int outputOffset = operation.getOutputICMOffset();
                        if (outputOffset != 0) {
                            index.write(ByteArray.numToByteArray(outputOffset + startingOffset, 4));
                        } else {
                            index.write(ByteArray.numToByteArray(0L, 4));
                        }
                        index.write(ByteArray.toCodePageByteArray("\"" + operation.getSoapAction() + "\"", 255, US_EBCDIC));
                        index.write(ByteArray.toCodePageByteArray(BLANK_SPACE, 1, US_EBCDIC));
                        if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.bindFileVersionNumber) && !(operation instanceof WSBindAbstractTypeEntry)) {
                            index.write(ByteArray.toCodePageByteArray("\"" + operation.getInputAction().substring(1) + "\"", 255, US_EBCDIC));
                            int actionFlag = 0;
                            if (operation.getInputAction().charAt(0) == 'S') {
                                actionFlag = 128;
                            }
                            index.write(ByteArray.numToByteArray(actionFlag, 1));
                            String outAction = "";
                            if (operation.getOutputAction().length() > 1) {
                                outAction = operation.getOutputAction().substring(1);
                            }
                            index.write(ByteArray.toCodePageByteArray("\"" + outAction + "\"", 255, US_EBCDIC));
                            actionFlag = 0;
                            if (operation.getOutputAction().charAt(0) == 'S') {
                                actionFlag = 128;
                            }
                            index.write(ByteArray.numToByteArray(actionFlag, 1));
                            if (RuntimeLevelHelper.supportsRuntimeLevel_4_0(this.bindFileVersionNumber)) {
                                index.write(ByteArray.toCodePageByteArray("", 255, US_EBCDIC));
                                actionFlag = 64;
                                index.write(ByteArray.numToByteArray(actionFlag, 1));
                            } else {
                                String faultAction = operation.getPre_4_0_FaultAction();
                                char controlCharacter = faultAction.charAt(0);
                                if (faultAction.length() > 1) {
                                    faultAction = faultAction.substring(1);
                                }
                                index.write(ByteArray.toCodePageByteArray("\"" + faultAction + "\"", 255, US_EBCDIC));
                                actionFlag = 0;
                                if (controlCharacter == 'S') {
                                    actionFlag = 128;
                                }
                                index.write(ByteArray.numToByteArray(actionFlag, 1));
                            }
                        } else if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.bindFileVersionNumber)) {
                            index.write(new byte[768]);
                        }
                        if (RuntimeLevelHelper.supportsRuntimeLevel_4_0(this.bindFileVersionNumber) && !(operation instanceof WSBindAbstractTypeEntry)) {
                            byte[] faultActionsTable = operation.createFaultActionTable();
                            index.write(ByteArray.numToByteArray(faultActionsTable.length, 4));
                            index.write(faultActionsTable);
                            continue;
                        }
                        if (!RuntimeLevelHelper.supportsRuntimeLevel_4_0(this.bindFileVersionNumber)) continue;
                        index.write(ByteArray.numToByteArray(0L, 4));
                    }
                    if (!RuntimeLevelHelper.supportsRuntimeLevel_1_2(this.bindFileVersionNumber)) {
                        this.addVendorFields(index, startingOffset);
                    }
                    if (remainder > 0) {
                        index.write(ByteArray.toCodePageByteArray(BLANK_SPACE, 8 - remainder, US_EBCDIC));
                    }
                    header = new ByteArrayOutputStream();
                    int totalLength = 0;
                    endpointReferenceOffset = 0;
                    if (this.endpointReference != null) {
                        endpointReferenceOffset = headerLength + index.size() + offsetSoFar;
                        totalLength = endpointReferenceOffset + this.endpointReference.length();
                    } else {
                        totalLength = headerLength + index.size() + offsetSoFar;
                    }
                    if (this.vendorMetaData != null) {
                        totalLength += this.vendorMetaData.length;
                    }
                    header.write(ByteArray.toCodePageByteArray(EYE_CATCHER, 8, US_EBCDIC));
                    header.write(ByteArray.numToByteArray(totalLength, 4));
                    header.write(ByteArray.timeStampToBinary(timestamp, 12, US_EBCDIC));
                    if (this.vendorWSBindFile) break block130;
                    header.write(1);
                    header.write(this.bindFileVersionNumber);
                    switch (this.bindFileVersionNumber) {
                        case 0: {
                            header.write(MINOR_VERSION_1);
                            break block131;
                        }
                        case 1: {
                            header.write(MINOR_VERSION_1_1);
                            break block131;
                        }
                        case 2: {
                            header.write(MINOR_VERSION_1_2);
                            break block131;
                        }
                        case 3: {
                            header.write(MINOR_VERSION_2);
                            break block131;
                        }
                        case 4: {
                            header.write(MINOR_VERSION_2_1);
                            break block131;
                        }
                        case 5: {
                            header.write(MINOR_VERSION_2_2);
                            break block131;
                        }
                        case 6: {
                            header.write(MINOR_VERSION_3_0);
                            break block131;
                        }
                        case 7: {
                            header.write(MINOR_VERSION_4_0);
                            break block131;
                        }
                        case 8: {
                            header.write(MINOR_VERSION_4_1);
                            break block131;
                        }
                        case 9: {
                            header.write(MINOR_VERSION_4_2);
                            break block131;
                        }
                        case 10: {
                            header.write(MINOR_VERSION_4_3);
                            break block131;
                        }
                        case 11: {
                            header.write(MINOR_VERSION_4_4);
                            break block131;
                        }
                        case 12: {
                            header.write(MINOR_VERSION_5_0);
                            break block131;
                        }
                        default: {
                            throw new RuntimeException("INTERNAL ERROR: bad major version - " + this.bindFileVersionNumber);
                        }
                    }
                }
                if (!RuntimeLevelHelper.supportsRuntimeLevel_1_2(this.bindFileVersionNumber)) {
                    header.write(ByteArray.numToByteArray(-16777216L, 4));
                } else {
                    header.write(ByteArray.numToByteArray(-2L, 1));
                    header.write(this.bindFileVersionNumber);
                    switch (this.bindFileVersionNumber) {
                        case 0: {
                            header.write(MINOR_VERSION_1);
                            break;
                        }
                        case 1: {
                            header.write(MINOR_VERSION_1_1);
                            break;
                        }
                        case 2: {
                            header.write(MINOR_VERSION_1_2);
                            break;
                        }
                        case 3: {
                            header.write(MINOR_VERSION_2);
                            break;
                        }
                        case 4: {
                            header.write(MINOR_VERSION_2_1);
                            break;
                        }
                        case 5: {
                            header.write(MINOR_VERSION_2_2);
                            break;
                        }
                        case 6: {
                            header.write(MINOR_VERSION_3_0);
                            break;
                        }
                        default: {
                            throw new RuntimeException("INTERNAL ERROR: bad minor version - " + this.bindFileVersionNumber);
                        }
                    }
                }
            }
            header.write(Util.padBytes(ByteArray.toCodePageByteArray(this.p.getProperty("WSBIND"), 255, US_EBCDIC)));
            int flags = 0;
            if (RuntimeLevelHelper.supportsRuntimeLevel_1_2(this.bindFileVersionNumber) && MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel) && !this.vendorWSBindFile) {
                flags = (byte)(flags | 0x80);
            }
            flags = (byte)(flags | 0x40);
            if (this.isSyncOnReturn()) {
                flags = (byte)(flags | 0x20);
            }
            if (((Boolean)this.p.get("XML-ONLY")).booleanValue()) {
                flags = (byte)(flags | 0x10);
            }
            if (this.p.getProperty("REQUEST-CHANNEL") != null || this.p.getProperty("RESPONSE-CHANNEL") != null) {
                flags = (byte)(flags | 8);
            }
            if (this.p.getProperty("INTERNAL_TOOLNAME") == "DFHJS2LS") {
                flags = (byte)(flags | 4);
            }
            if (this.p.getProperty("JSON-SCHEMA-RESTFUL") != null) {
                flags = (byte)(flags | 2);
            }
            header.write(flags);
            header.write(ByteArray.numToByteArray(headerLength, 4));
            if (!this.vendorWSBindFile) {
                header.write(ByteArray.numToByteArray(this.operations.size(), 4));
            } else if (!RuntimeLevelHelper.supportsRuntimeLevel_1_2(this.bindFileVersionNumber)) {
                header.write(ByteArray.numToByteArray(1L, 4));
            } else {
                header.write(ByteArray.numToByteArray(this.operations.size(), 4));
            }
            header.write(ByteArray.numToByteArray(Util.getStyle(this.p.getProperty("STYLE"), true).getCode(), 1));
            String wsdl11String = this.p.getProperty("WSDL");
            if (wsdl11String == null || "".equals(wsdl11String) || BLANK_SPACE.equals(wsdl11String)) {
                wsdl11String = this.p.getProperty("WSDL_1.1");
            }
            if (this.WSDLVersion == 1 || this.WSDLVersion == 3 || this.WSDLVersion == 0) {
                header.write(Util.padBytes(ByteArray.toCodePageByteArray(wsdl11String, 255, US_EBCDIC)));
            } else {
                header.write(ByteArray.toCodePageByteArray(null, 255, US_EBCDIC));
            }
            header.write(Util.padBytes(ByteArray.toCodePageByteArray(this.p.getProperty("BINDING"), 255, US_EBCDIC)));
            header.write(Util.padBytes(ByteArray.toCodePageByteArray(this.p.getProperty("INTERNAL_PGMNAME"), 8, US_EBCDIC)));
            header.write(Util.padBytes(ByteArray.toCodePageByteArray(this.p.getProperty("URI_RELATIVE"), 255, US_EBCDIC)));
            header.write(Util.padBytes(ByteArray.toCodePageByteArray(this.p.getProperty("ENDPOINT"), 255, US_EBCDIC)));
            header.write(ByteArray.numToByteArray(Util.getPgmInterface(this.p.getProperty("PGMINT")), 1));
            header.write(Util.padBytes(ByteArray.toCodePageByteArray(this.p.getProperty("CONTID"), 16, US_EBCDIC)));
            header.write(ByteArray.numToByteArray(0L, 1));
            header.write(Util.padBytes(ByteArray.toCodePageByteArray(BLANK_SPACE, 8, US_EBCDIC)));
            String transid = this.p.getProperty("TRANSACTION");
            if (transid != null && !"".equals(transid)) {
                header.write(Util.padBytes(ByteArray.toCodePageByteArray(transid, 4, US_EBCDIC)));
            } else {
                header.write(Util.padBytes(ByteArray.toCodePageByteArray(BLANK_SPACE, 4, US_EBCDIC)));
            }
            String userid = this.p.getProperty("USERID");
            if (userid != null && !"".equals(userid)) {
                header.write(Util.padBytes(ByteArray.toCodePageByteArray(userid, 8, US_EBCDIC)));
            } else {
                header.write(Util.padBytes(ByteArray.toCodePageByteArray(BLANK_SPACE, 8, US_EBCDIC)));
            }
            header.write(Util.padBytes(ByteArray.toCodePageByteArray(BLANK_SPACE, 8, US_EBCDIC)));
            header.write(Util.padBytes(ByteArray.toCodePageByteArray(BLANK_SPACE, 8, US_EBCDIC)));
            header.write(ByteArray.numToByteArray(0L, 1));
            if (RuntimeLevelHelper.supportsRuntimeLevel_1_2(this.bindFileVersionNumber)) {
                header.write(ByteArray.numToByteArray(this.ccsid, 4));
                if (!RuntimeLevelHelper.supportsRuntimeLevel_2_0(this.bindFileVersionNumber)) {
                    header.write(ByteArray.toCodePageByteArray(BLANK_SPACE, 772, US_EBCDIC), 0, 772);
                } else {
                    int verflags = 0;
                    switch (this.WSDLVersion) {
                        case 2: {
                            verflags |= 0x80;
                            break;
                        }
                        case 1: {
                            verflags |= 0x40;
                            break;
                        }
                        case 3: {
                            verflags |= 0xC0;
                            break;
                        }
                        case 0: {
                            verflags |= 0x40;
                            break;
                        }
                        default: {
                            throw new CICSWSDLException("INTERNAL ERROR: bad WSDL version: " + this.WSDLVersion);
                        }
                    }
                    switch (this.soapVersion) {
                        case 1: {
                            verflags |= 0x20;
                            break;
                        }
                        case 2: {
                            verflags |= 0x10;
                            break;
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            throw new CICSWSDLException("INTERNAL ERROR: bad SOAP version: " + this.soapVersion);
                        }
                    }
                    header.write(ByteArray.numToByteArray(verflags, 1));
                    String wsdl20String = this.p.getProperty("WSDL_2.0");
                    if (this.WSDLVersion == 2 || this.WSDLVersion == 3) {
                        if (wsdl20String == null || "".equals(wsdl20String)) {
                            wsdl20String = this.p.getProperty("WSDL");
                        }
                        header.write(Util.padBytes(ByteArray.toCodePageByteArray(wsdl20String, 255, US_EBCDIC)));
                    } else {
                        header.write(ByteArray.toCodePageByteArray(null, 255, US_EBCDIC));
                    }
                    if (RuntimeLevelHelper.supportsRuntimeLevel_2_1(this.bindFileVersionNumber)) {
                        header.write(Util.padBytes(ByteArray.toCodePageByteArray(targetNamespace, 255, US_EBCDIC)));
                        header.write(Util.padBytes(ByteArray.toCodePageByteArray(portNSName, 255, US_EBCDIC)));
                    }
                    if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.bindFileVersionNumber)) {
                        int eprLength = 0;
                        if (this.endpointReference != null) {
                            eprLength = this.endpointReference.length();
                        }
                        header.write(ByteArray.numToByteArray(eprLength, 2));
                        header.write(ByteArray.numToByteArray(endpointReferenceOffset, 4));
                    } else if (RuntimeLevelHelper.supportsRuntimeLevel_2_1(this.bindFileVersionNumber)) {
                        header.write(ByteArray.toCodePageByteArray(null, 6, US_EBCDIC));
                    } else {
                        header.write(ByteArray.toCodePageByteArray(null, 516, US_EBCDIC));
                    }
                }
                this.addVendorFields(header, startingOffset);
                header.write(ByteArray.toCodePageByteArray(BLANK_SPACE, 6, US_EBCDIC), 0, 6);
            }
            if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.bindFileVersionNumber)) {
                header.write(ByteArray.toCodePageByteArray(this.p.getProperty("REQUEST-CHANNEL"), 256, US_EBCDIC));
                header.write(ByteArray.toCodePageByteArray(this.p.getProperty("RESPONSE-CHANNEL"), 256, US_EBCDIC));
                header.write(ByteArray.toCodePageByteArray(this.requestChannelName, 16, US_EBCDIC));
                header.write(ByteArray.toCodePageByteArray(this.responseChannelName, 16, US_EBCDIC));
            }
            if (RuntimeLevelHelper.supportsRuntimeLevel_4_0(this.bindFileVersionNumber)) {
                header.write(ByteArray.numToByteArray(this.altCcsid, 4));
            }
            output.write(header.toByteArray());
            output.write(index.toByteArray());
            if (this.vendorMetaData != null) {
                output.write(this.vendorMetaData);
            }
            try {
                int i4;
                for (i4 = 0; i4 < this.operations.size(); ++i4) {
                    oper = this.operations.get(i4);
                    this.addICMToWSBindFile(oper, true, output);
                }
                for (i4 = 0; i4 < this.operations.size(); ++i4) {
                    oper = this.operations.get(i4);
                    this.addICMToWSBindFile(oper, false, output);
                }
            }
            catch (IOException e) {
                newEx = new CICSWSDLException(e.getLocalizedMessage());
                newEx.initCause(e);
                throw newEx;
            }
            catch (ICMException exc) {
                newEx = new CICSWSDLException(exc.getLocalizedMessage());
                newEx.initCause(exc);
                throw newEx;
            }
            if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.bindFileVersionNumber) && this.endpointReference != null) {
                output.write(ByteArray.toCodePageByteArray(this.endpointReference, this.endpointReference.length(), US_EBCDIC));
            }
        }
        catch (ICMException exc) {
            CICSWSDLException newEx = new CICSWSDLException(exc.getLocalizedMessage());
            newEx.initCause(exc);
            throw newEx;
        }
        String minRuntimeLevel = MAJOR_VER_AS_STRING[this.bindFileVersionNumber];
        Logging.writeMessage(1, "DFHPI9629I", new Object[]{minRuntimeLevel});
        String toolInUse = this.p.getProperty("INTERNAL_TOOLNAME");
        if (!"DFHLS2JS".equals(toolInUse) && !"DFHJS2LS".equals(toolInUse)) {
            Logging.writeMessage(1, "DFHPI9640I", new Object[]{SOAP_VER_AS_STRING[this.soapVersion]});
        }
    }

    private void addVendorFields(OutputStream out, int startOfVendorMetaData) throws ICMException, IOException, Exception {
        if (this.vendorWSBindFile) {
            out.write(Util.padBytes(ByteArray.toCodePageByteArray(this.p.getProperty("VENDOR-CONVERTER-NAME"), 8, US_EBCDIC)));
            out.write(ByteArray.numToByteArray(Integer.parseInt(this.p.getProperty("VENDOR-APP-INTERFACE-LENGTH")), 4));
            if (this.vendorMetaData != null) {
                out.write(ByteArray.numToByteArray(this.vendorMetaData.length, 4));
                out.write(ByteArray.numToByteArray(startOfVendorMetaData, 4));
            } else {
                out.write(ByteArray.numToByteArray(0L, 4));
                out.write(ByteArray.numToByteArray(0L, 4));
            }
            out.write(ByteArray.toCodePageByteArray(BLANK_SPACE, 30, US_EBCDIC));
        } else {
            out.write(ByteArray.toCodePageByteArray(BLANK_SPACE, 50, US_EBCDIC));
        }
    }

    protected static byte getWSBindMajorVersionNumberToUse(int mappingLevel) throws CICSWSDLException {
        byte majorVersion = -1;
        switch (mappingLevel) {
            case 0: 
            case 3: {
                majorVersion = 0;
                break;
            }
            case 2: {
                majorVersion = 1;
                break;
            }
            case 4: {
                majorVersion = 2;
                break;
            }
            case 1: {
                majorVersion = 3;
                break;
            }
            case 5: {
                majorVersion = 4;
                break;
            }
            case 6: {
                majorVersion = 5;
                break;
            }
            case 7: {
                majorVersion = 6;
                break;
            }
            case 8: {
                majorVersion = 7;
                break;
            }
            case 9: {
                majorVersion = 8;
                break;
            }
            case 10: {
                majorVersion = 9;
                break;
            }
            case 11: {
                majorVersion = 10;
                break;
            }
            case 12: {
                majorVersion = 11;
                break;
            }
            case 13: {
                majorVersion = 12;
                break;
            }
            default: {
                throw new CICSWSDLException("INTERNAL ERROR: bad mapping level " + mappingLevel);
            }
        }
        return majorVersion;
    }

    protected static byte[] getWSBindMinorVersionNumberToUse(int mappingLevel) throws CICSWSDLException {
        byte[] minorVersion = null;
        switch (mappingLevel) {
            case 0: 
            case 3: {
                minorVersion = MINOR_VERSION_1;
                break;
            }
            case 2: {
                minorVersion = MINOR_VERSION_1_1;
                break;
            }
            case 4: {
                minorVersion = MINOR_VERSION_1_2;
                break;
            }
            case 1: {
                minorVersion = MINOR_VERSION_2;
                break;
            }
            case 5: {
                minorVersion = MINOR_VERSION_2_1;
                break;
            }
            case 6: {
                minorVersion = MINOR_VERSION_2_2;
                break;
            }
            case 7: {
                minorVersion = MINOR_VERSION_3_0;
                break;
            }
            case 8: {
                minorVersion = MINOR_VERSION_4_0;
                break;
            }
            case 9: {
                minorVersion = MINOR_VERSION_4_1;
                break;
            }
            case 10: {
                minorVersion = MINOR_VERSION_4_2;
                break;
            }
            case 11: {
                minorVersion = MINOR_VERSION_4_3;
                break;
            }
            case 12: {
                minorVersion = MINOR_VERSION_4_4;
                break;
            }
            case 13: {
                minorVersion = MINOR_VERSION_5_0;
                break;
            }
            default: {
                throw new CICSWSDLException("INTERNAL ERROR: bad mapping level " + mappingLevel);
            }
        }
        return minorVersion;
    }

    protected static byte[] getWSBindMinorVersionNumberToUse(byte majorVer) throws CICSWSDLException {
        byte[] minorVersion = null;
        switch (majorVer) {
            case 0: {
                minorVersion = MINOR_VERSION_1;
                break;
            }
            case 1: {
                minorVersion = MINOR_VERSION_1_1;
                break;
            }
            case 2: {
                minorVersion = MINOR_VERSION_1_2;
                break;
            }
            case 3: {
                minorVersion = MINOR_VERSION_2;
                break;
            }
            case 4: {
                minorVersion = MINOR_VERSION_2_1;
                break;
            }
            case 5: {
                minorVersion = MINOR_VERSION_2_2;
                break;
            }
            case 6: {
                minorVersion = MINOR_VERSION_3_0;
                break;
            }
            case 7: {
                minorVersion = MINOR_VERSION_4_0;
                break;
            }
            case 8: {
                minorVersion = MINOR_VERSION_4_1;
                break;
            }
            case 9: {
                minorVersion = MINOR_VERSION_4_2;
                break;
            }
            case 10: {
                minorVersion = MINOR_VERSION_4_3;
                break;
            }
            case 11: {
                minorVersion = MINOR_VERSION_4_4;
                break;
            }
            case 12: {
                minorVersion = MINOR_VERSION_5_0;
                break;
            }
            default: {
                throw new CICSWSDLException("INTERNAL ERROR: bad major version " + majorVer);
            }
        }
        return minorVersion;
    }
}

