/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.impl.ICMImplFromWSBind;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.util.CodePageHelper;
import com.ibm.cics.schema.utils.RuntimeLevelHelper;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.WSBind;
import com.ibm.cics.wsdl.ws2ls.WSAddressingFault;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class WSBindOperationEntry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private String opName;
    private byte[] opNameBytes;
    private String signature;
    private Set<String> signatureSet = null;
    private String soapAction;
    private String inputAction;
    private byte inActionFlag;
    private String outputAction;
    private byte outActionFlag;
    private List<WSAddressingFault> faultActions;
    private byte fltActionFlag;
    private ICM inputICM;
    private ICM outputICM;
    private int inputICMOffset;
    private int outputICMOffset;
    private int mep = -1;
    public static final int MEP_UNSPECIFIED = -1;
    public static final int MEP_IN_OUT = 1;
    public static final int MEP_IN_ONLY = 2;
    public static final int MEP_ROBUST_IN_ONLY = 3;
    public static final int MEP_IN_OPTIONAL_OUT = 4;
    public static final byte MEP_IN_ONLY_WSBIND = 1;
    public static final byte MEP_IN_OUT_WSBIND = 2;
    public static final byte MEP_ROBUST_IN_ONLY_WSBIND = 4;
    public static final byte MEP_IN_OPTIONAL_OUT_WSBIND = 8;
    public static final byte MEP_ABSTRACT_TYPE_WSBIND = -128;
    public static final int MEP_ABSTRACT_TYPE = 254;
    private int httpMethod = -1;
    public static final int HTTP_UNSPECIFIED = -1;
    public static final int HTTP_GET = 1;
    public static final int HTTP_POST = 2;
    protected static final int LENGTH_OF_NAME = 255;
    protected static final int LENGTH_OF_SIGNATURE = 255;
    protected static final int LENGTH_OF_SOAPACTION = 255;
    protected static final int LENGTH_OF_INPUTACTION = 255;
    protected static final int LENGTH_OF_OUTPUTACTION = 255;
    protected static final int LENGTH_OF_FAULTACTION = 255;
    protected static final int LENGTH_OF_TYPE_NAME = 255;
    protected static final int LENGTH_OF_TYPE_NAME_NAMESPCAE = 255;
    protected static final int LENGTH_OF_OFFSET = 4;
    protected static final int LENGTH_OF_HTTP_BITS = 1;
    protected static final int LENGTH_OF_MEP_BITS = 1;
    private String typeName;
    private String typeNameNS;
    private ICM typeICM;
    private int typeICMOffset;
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private static final Charset CHARSET_CP037 = Charset.forName("Cp037");
    private static final int LENGTH_OF_NUM_OF_ENTRIES = 3;
    private static final int LENGTH_OF_FAULT_OFFSET = 3;
    private static final int LENGTH_OF_LENGTH = 1;
    private static final int LENGTH_OF_FAULT_INDEX_ENTRY = 12;
    private byte[] faultActionTable = null;

    public WSBindOperationEntry(String OperationName, ICM requestICM, ICM responseICM, int mep, int httpMethod) {
        this.opName = OperationName;
        this.inputICM = requestICM;
        this.outputICM = responseICM;
        this.mep = mep;
        this.httpMethod = httpMethod;
        this.inputICMOffset = 0;
        this.outputICMOffset = 0;
        if (mep == 1 && responseICM == null && requestICM != null) {
            this.mep = 2;
        }
    }

    public String getName() {
        return this.opName;
    }

    public byte[] getNameBytes() {
        return this.opNameBytes;
    }

    public void setSignature(String sig) {
        this.signature = sig;
    }

    public String getSignature() {
        return this.signature;
    }

    public Set<String> getSignatureSet() {
        if (this.signatureSet != null) {
            return this.signatureSet;
        }
        this.signatureSet = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(this.signature, " ");
        while (st.hasMoreTokens()) {
            this.signatureSet.add(st.nextToken());
        }
        return this.signatureSet;
    }

    public void setSoapAction(String sa) {
        this.soapAction = sa;
    }

    protected String getSoapAction() {
        if (this.soapAction == null) {
            return "";
        }
        return this.soapAction;
    }

    public void setInputAction(String sa) {
        this.inputAction = sa;
    }

    protected String getInputAction() {
        if (this.inputAction == null) {
            return "";
        }
        return this.inputAction;
    }

    public void setOutputAction(String sa) {
        this.outputAction = sa;
    }

    protected String getOutputAction() {
        if (this.outputAction == null) {
            return "";
        }
        return this.outputAction;
    }

    public void setFaultActions(List<WSAddressingFault> fa) {
        this.faultActions = fa;
    }

    protected List<WSAddressingFault> getFaultActions() {
        return this.faultActions;
    }

    protected String getPre_4_0_FaultAction() {
        if (this.faultActions.size() > 1) {
            return this.faultActions.get(1).getCICSAddressingAction();
        }
        return this.faultActions.get(0).getCICSAddressingAction();
    }

    protected byte[] createFaultActionTable() throws ICMException, UnsupportedEncodingException, IOException, Exception {
        if (this.faultActionTable != null) {
            return this.faultActionTable;
        }
        ByteArrayOutputStream faultTable = new ByteArrayOutputStream();
        ByteArrayOutputStream dataTable = new ByteArrayOutputStream();
        int numFaultActions = 0;
        if (this.mep == 254) {
            return new byte[0];
        }
        numFaultActions = this.faultActions.size();
        faultTable.write(-29);
        faultTable.write(ByteArray.numToByteArray(numFaultActions, 3));
        int dataTableCursor = 4 + numFaultActions * 12;
        for (int i = 0; i < numFaultActions; ++i) {
            WSAddressingFault currentFault = this.faultActions.get(i);
            String localName = "";
            if (currentFault.getFaultQname() != null) {
                localName = currentFault.getFaultQname().getLocalPart();
            }
            dataTableCursor = this.addStringToFaultTables(faultTable, dataTable, localName, dataTableCursor, CHARSET_UTF8);
            String namespace = "";
            if (currentFault.getFaultQname() != null) {
                namespace = currentFault.getFaultQname().getNamespaceURI();
            }
            dataTableCursor = this.addStringToFaultTables(faultTable, dataTable, namespace, dataTableCursor, CHARSET_UTF8);
            String s = currentFault.getCICSAddressingAction();
            String action = s.charAt(0) + "\"" + s.substring(1) + "\"";
            dataTableCursor = this.addStringToFaultTables(faultTable, dataTable, action, dataTableCursor, WSBind.US_EBCDIC);
        }
        faultTable.write(dataTable.toByteArray());
        this.faultActionTable = faultTable.toByteArray();
        return this.faultActionTable;
    }

    private int addStringToFaultTables(ByteArrayOutputStream faultTable, ByteArrayOutputStream dataTable, String s, int dataTableCursor, Charset encoding) throws ICMException, IOException, Exception {
        faultTable.write(ByteArray.numToByteArray(dataTableCursor, 3));
        byte[] bytes = ByteArray.toCodePageByteArray(s, -1, encoding);
        dataTable.write(bytes);
        faultTable.write(ByteArray.numToByteArray(bytes.length, 1));
        return dataTableCursor + bytes.length;
    }

    public void setInputICM(ICM icm) {
        this.inputICM = icm;
    }

    public ICM getInputICM() {
        return this.inputICM;
    }

    public void setOutputICM(ICM icm) {
        this.outputICM = icm;
    }

    public ICM getOutputICM() {
        return this.outputICM;
    }

    protected void setInputICMOffset(int o) {
        this.inputICMOffset = o;
    }

    public int getInputICMOffset() {
        return this.inputICMOffset;
    }

    protected void setOutputICMOffset(int o) {
        this.outputICMOffset = o;
    }

    public int getOutputICMOffset() {
        return this.outputICMOffset;
    }

    public int getMEP() {
        return this.mep;
    }

    public int getHTTPMethod() {
        return this.httpMethod;
    }

    public WSBindOperationEntry(byte[] WSBindContents, int operationOffset, int operationLength, int mappingLevel, int CCSID, boolean useNamespaces, byte runtimeLevel) throws ICMException, IOException, CICSWSDLException {
        this.mep = WSBindContents[operationOffset + 511];
        Charset current_codepage = CodePageHelper.resolveCCSID(CCSID);
        if (current_codepage == null) {
            current_codepage = CodePageHelper.getDefaultCodePage();
        }
        if (this.mep == -128) {
            this.typeName = ByteArray.byteArrayToString(WSBindContents, operationOffset + 0, 255, current_codepage, true);
            this.typeNameNS = ByteArray.byteArrayToString(WSBindContents, operationOffset + 255, 255, current_codepage, true);
            this.typeICMOffset = ByteArray.byteArrayToInt(WSBindContents, operationOffset + 512);
            this.typeICM = new ICMImplFromWSBind(WSBindContents, this.typeICMOffset, current_codepage, useNamespaces);
            this.inputICM = null;
            this.outputICM = null;
        } else {
            this.opNameBytes = new byte[255];
            System.arraycopy(WSBindContents, operationOffset + 0, this.opNameBytes, 0, 255);
            this.opName = ByteArray.byteArrayToString(WSBindContents, operationOffset + 0, 255, current_codepage, true);
            this.signature = ByteArray.byteArrayToString(WSBindContents, operationOffset + 255, 255, current_codepage, true);
            this.httpMethod = WSBindContents[operationOffset + 510];
            if (mappingLevel == -2 || mappingLevel == -1) {
                this.inputICMOffset = 0;
                this.outputICMOffset = 0;
            } else {
                this.inputICMOffset = ByteArray.byteArrayToInt(WSBindContents, operationOffset + 512);
                this.outputICMOffset = this.mep == 1 ? 0 : ByteArray.byteArrayToInt(WSBindContents, operationOffset + 516);
            }
            if (this.inputICMOffset != 0) {
                ICMImplFromWSBind InputICM = new ICMImplFromWSBind(WSBindContents, this.inputICMOffset, current_codepage, useNamespaces);
                this.inputICM = InputICM;
            } else {
                this.inputICM = null;
            }
            if (this.outputICMOffset != 0) {
                ICMImplFromWSBind OutputICM = new ICMImplFromWSBind(WSBindContents, this.outputICMOffset, current_codepage, useNamespaces);
                this.outputICM = OutputICM;
            } else {
                this.outputICM = null;
            }
            this.typeICM = null;
            this.soapAction = ByteArray.byteArrayToString(WSBindContents, operationOffset + 520, 255, WSBind.US_EBCDIC, true);
        }
        if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(runtimeLevel)) {
            this.inputAction = ByteArray.byteArrayToString(WSBindContents, operationOffset + 776, 255, current_codepage, true);
            this.inActionFlag = WSBindContents[1031];
            this.outputAction = ByteArray.byteArrayToString(WSBindContents, operationOffset + 1032, 255, current_codepage, true);
            this.outActionFlag = WSBindContents[1287];
            if (!RuntimeLevelHelper.supportsRuntimeLevel_4_0(runtimeLevel)) {
                this.faultActions = new ArrayList<WSAddressingFault>(1);
                this.faultActions.add(new WSAddressingFault(null, ByteArray.byteArrayToString(WSBindContents, operationOffset + 1288, 255, current_codepage, true)));
                this.fltActionFlag = WSBindContents[1543];
            }
        }
    }

    public static List<WSAddressingFault> readFaultTable(byte[] source, int offset) throws Exception {
        if (source[offset] != -29) {
            throw new RuntimeException("INTERNAL ERROR: Bad fault table");
        }
        int numFaultTableEntries = ByteArray.byteArrayToInt(source, offset + 1, 3);
        ArrayList<WSAddressingFault> faultActions = new ArrayList<WSAddressingFault>(numFaultTableEntries);
        int offsetOfTableEntry = offset + 4;
        for (int i = 0; i < numFaultTableEntries; ++i) {
            int offsetOfLocalName = ByteArray.byteArrayToInt(source, offsetOfTableEntry, 3);
            int lengthOfLocalName = ByteArray.byteArrayToInt(source, offsetOfTableEntry + 3, 1);
            String localName = new String(source, offset + offsetOfLocalName, lengthOfLocalName, CHARSET_UTF8);
            int offsetOfNS = ByteArray.byteArrayToInt(source, offsetOfTableEntry + 4, 3);
            int lengthOfNS = ByteArray.byteArrayToInt(source, offsetOfTableEntry + 7, 1);
            String ns = new String(source, offset + offsetOfNS, lengthOfNS, CHARSET_UTF8);
            int offsetOfAction = ByteArray.byteArrayToInt(source, offsetOfTableEntry + 8, 3);
            int lengthOfAction = ByteArray.byteArrayToInt(source, offsetOfTableEntry + 11, 1);
            String action = new String(source, offset + offsetOfAction + 2, lengthOfAction - 3, CHARSET_CP037);
            QName faultQName = new QName(ns, localName);
            faultActions.add(new WSAddressingFault(faultQName, action));
            offsetOfTableEntry += 12;
        }
        return faultActions;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeNameNS() {
        return this.typeNameNS;
    }

    public ICM getTypeICM() {
        return this.typeICM;
    }

    public byte getInActionFlag() {
        return this.inActionFlag;
    }

    public byte getOutActionFlag() {
        return this.outActionFlag;
    }

    public byte getFltActionFlag() {
        return this.fltActionFlag;
    }
}

