/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.gen.api.IWSBindFile;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMLengthException;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.utils.RuntimeLevelHelper;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.common.WSBind;
import com.ibm.cics.wsdl.common.WSBindAbstractTypeEntry;
import com.ibm.cics.wsdl.common.WSBindOperationEntry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class WSBindProcessor
implements IWSBindFile {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2007, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private byte[] globalWsBindFileContents = null;
    private Map<QName, WSBindAbstractTypeEntry> dataTypes = null;
    private static final int fiddleFactor = 64;
    private static final Charset EBCDIC37_Codepage = Charset.forName("Cp037");
    private String containerName = null;
    private ByteArray containerNameBytes = null;
    private String endpointURI = null;
    private int mappingLevel = -1;
    private byte mimimumRuntimeLevel;
    private byte targetProgramInterface;
    private String targetProgramName = null;
    private ByteArray targetProgramNameByteArray = null;
    private String timeStamp = null;
    private static boolean TRIM = true;
    private static boolean NOTRIM = false;
    private String tranId = null;
    private String uri = null;
    private String userid = null;
    private String vendorConverterProgramName = null;
    private int vendorConverterInterfaceSize = -1;
    private byte wsbindProductNumber;
    private String wsdlBinding = null;
    private String[] operationNames = null;
    private List<QName> abstractTypes = null;
    private String wsdlFileName = null;
    private String wsdl20FileName = null;
    private boolean syncOnReturn = false;
    private boolean jsonTopDown = false;
    private boolean jsonRESTful = false;
    private String requestChannelFileName = null;
    private String responseChannelFileName = null;
    private String requestChannelName = null;
    private ByteArray requestChannelNameAsByteArray = null;
    private String responseChannelName = null;
    private WSBindOperationEntry[] wsBindOperationEntries = null;
    private byte httpMethods = 0;
    private int offsetOfIndex = -1;
    private int numberOfIndexEntries = -1;
    private SoapStyle soapStyle = null;
    private int ccsid = -1;
    private int altCcsid = -1;
    private boolean useNamespaces = true;

    public byte[] getWsBindFileContents() {
        return this.globalWsBindFileContents;
    }

    public WSBindProcessor(InputStream is, boolean releaseData) throws IOException, CICSWSDLException {
        this(is, releaseData, true);
    }

    public WSBindProcessor(InputStream is, boolean releaseData, boolean useNamespaces) throws IOException, CICSWSDLException {
        this.useNamespaces = useNamespaces;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int bytesRead = is.read(buffer);
        while (bytesRead > -1) {
            baos.write(buffer, 0, bytesRead);
            bytesRead = is.read(buffer);
        }
        byte[] wsBindFileContents = baos.toByteArray();
        if (wsBindFileContents.length < 12) {
            throw new IOException("WSBind file length too short.");
        }
        try {
            byte[] eyecatcher = ByteArray.toCodePageByteArray(">WSBIND<", 8, WSBind.US_EBCDIC);
            for (int i = 0; i < ">WSBIND<".length(); ++i) {
                if (wsBindFileContents[i] == eyecatcher[i]) continue;
                throw new IOException("Not a WSBind file.");
            }
            int lengthStoredInWSBindFile = ByteArray.byteArrayToInt(wsBindFileContents, 8);
            if (lengthStoredInWSBindFile != wsBindFileContents.length & lengthStoredInWSBindFile != wsBindFileContents.length + 64) {
                throw new IOException("WSBind file length is " + wsBindFileContents.length + " but should be " + lengthStoredInWSBindFile);
            }
            this.setWSBindProductNumber(wsBindFileContents);
            this.setTargetProgramName(wsBindFileContents);
            this.setEndPointURI(wsBindFileContents);
            this.setMappingLevel(wsBindFileContents);
            if ((this.mappingLevel < 0 || this.mappingLevel >= 6) & lengthStoredInWSBindFile != wsBindFileContents.length) {
                throw new IOException("WSBind file length is " + wsBindFileContents.length + " but should be " + lengthStoredInWSBindFile);
            }
            this.setMinimumRuntimeLevel(wsBindFileContents);
            this.setTargetProgramInterface(wsBindFileContents);
            this.setContainerName(wsBindFileContents);
            this.setTimeStamp(wsBindFileContents);
            this.setTranId(wsBindFileContents);
            this.setUserid(wsBindFileContents);
            this.setURI(wsBindFileContents);
            this.setVendorConverterProgramName(wsBindFileContents);
            this.setVendorConverterInterfaceSize(wsBindFileContents);
            this.setWSDLBinding(wsBindFileContents);
            this.setWSDLFileName(wsBindFileContents);
            this.setWSDL20FileName(wsBindFileContents);
            this.setFirstIndexOffset(wsBindFileContents);
            this.setSyncOnReturn(wsBindFileContents);
            this.setOperationNames(wsBindFileContents);
            this.setAbstractTypes(wsBindFileContents);
            this.setRequestChannelFileName(wsBindFileContents);
            this.setResponseChannelFileName(wsBindFileContents);
            this.setRequestChannelName(wsBindFileContents);
            this.setResponseChannelName(wsBindFileContents);
            this.setSOAPStyle(wsBindFileContents);
            this.setCCSID(wsBindFileContents);
            this.setNumberOfOperations(wsBindFileContents);
            this.setWSBindOperationEntries(wsBindFileContents);
            this.setJSONBits(wsBindFileContents);
            this.globalWsBindFileContents = wsBindFileContents;
        }
        catch (ICMException icmEx) {
            IOException ioe = new IOException("Problem with WSBind file.");
            ioe.initCause(icmEx);
            throw ioe;
        }
        finally {
            is.close();
            if (releaseData) {
                this.globalWsBindFileContents = null;
            }
        }
    }

    private void setContainerName(byte[] wsBindFileContents) {
        if (this.getTargetProgramInterface() != 1) {
            return;
        }
        if ((wsBindFileContents[283] & 8) == 8) {
            return;
        }
        this.containerName = ByteArray.byteArrayToString(wsBindFileContents, 1322, 16, WSBind.US_EBCDIC, NOTRIM);
        try {
            this.containerNameBytes = new ByteArray(wsBindFileContents, 1322, 16, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected Error", e);
        }
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    public ByteArray getContainerNameBytes() {
        return this.containerNameBytes;
    }

    private void setEndPointURI(byte[] wsBindFileContents) {
        if (!this.getMode()) {
            return;
        }
        this.endpointURI = ByteArray.byteArrayToString(wsBindFileContents, 1066, 255, WSBind.US_EBCDIC, TRIM);
    }

    @Override
    public String getEndpointURI() {
        return this.endpointURI;
    }

    private void setMappingLevel(byte[] wsBindFileContents) {
        if (this.getWSBindProductNumber() != 1) {
            this.mappingLevel = -1;
            return;
        }
        if ((wsBindFileContents[283] & 0x10) == 16) {
            this.mappingLevel = -2;
            return;
        }
        int offsetOfIndexSection = ByteArray.byteArrayToInt(wsBindFileContents, 284);
        int offsetOfOffsetOfFirstRequestICM = offsetOfIndexSection + 512;
        int offsetOfFirstRequestICM = ByteArray.byteArrayToInt(wsBindFileContents, offsetOfOffsetOfFirstRequestICM);
        int offsetOfMappingLevel = offsetOfFirstRequestICM + 11;
        this.mappingLevel = wsBindFileContents[offsetOfMappingLevel];
    }

    @Override
    public int getMappingLevel() {
        return this.mappingLevel;
    }

    private void setMinimumRuntimeLevel(byte[] wsBindFileContents) {
        if (this.getWSBindProductNumber() == -1) {
            this.mimimumRuntimeLevel = 0;
            return;
        }
        this.mimimumRuntimeLevel = wsBindFileContents[25];
    }

    @Override
    public byte getMinimumRuntimeLevel() {
        return this.mimimumRuntimeLevel;
    }

    @Override
    public boolean getMode() {
        return this.getTargetProgramName() == null;
    }

    private void setTargetProgramInterface(byte[] wsBindFileContents) {
        this.targetProgramInterface = wsBindFileContents[1321];
    }

    @Override
    public byte getTargetProgramInterface() {
        return this.targetProgramInterface;
    }

    private void setTargetProgramName(byte[] wsBindFileContents) {
        if (wsBindFileContents[803] == 0) {
            return;
        }
        String name = ByteArray.byteArrayToString(wsBindFileContents, 803, 8, WSBind.US_EBCDIC, NOTRIM);
        if ("".equals(name) || "        ".equals(name)) {
            return;
        }
        this.targetProgramName = name;
    }

    @Override
    public String getTargetProgramName() {
        return this.targetProgramName;
    }

    public ByteArray getTargetProgramNameByteArray() {
        if (this.targetProgramNameByteArray != null) {
            return this.targetProgramNameByteArray;
        }
        try {
            this.targetProgramNameByteArray = new ByteArray(this.getTargetProgramName().getBytes(EBCDIC37_Codepage), true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.targetProgramNameByteArray;
    }

    private void setTimeStamp(byte[] wsBindFileContents) {
        this.timeStamp = ByteArray.byteArrayToString(wsBindFileContents, 12, 12, WSBind.US_EBCDIC, NOTRIM);
    }

    @Override
    public String getTimeStamp() {
        return this.timeStamp;
    }

    private void setTranId(byte[] wsBindFileContents) {
        if (this.getMode()) {
            return;
        }
        String tranid = ByteArray.byteArrayToString(wsBindFileContents, 1347, 4, WSBind.US_EBCDIC, NOTRIM);
        if ("    ".equals(tranid)) {
            return;
        }
        this.tranId = tranid;
    }

    @Override
    public String getTranId() {
        return this.tranId;
    }

    private void setURI(byte[] wsBindFileContents) {
        if (this.getMode()) {
            return;
        }
        this.uri = ByteArray.byteArrayToString(wsBindFileContents, 811, 255, WSBind.US_EBCDIC, TRIM);
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    private void setUserid(byte[] wsBindFileContents) {
        if (this.getMode()) {
            return;
        }
        String userid = ByteArray.byteArrayToString(wsBindFileContents, 1351, 8, WSBind.US_EBCDIC, NOTRIM);
        if ("        ".equals(userid)) {
            return;
        }
        this.userid = userid;
    }

    @Override
    public String getUserId() {
        return this.userid;
    }

    private void setVendorConverterProgramName(byte[] wsBindFileContents) {
        if (this.getWSBindProductNumber() == -1 || this.getWSBindProductNumber() == -2) {
            this.vendorConverterProgramName = ByteArray.byteArrayToString(wsBindFileContents, 2152, 8, WSBind.US_EBCDIC, NOTRIM);
        }
    }

    @Override
    public String getVendorConverterProgramName() {
        return this.vendorConverterProgramName;
    }

    private void setVendorConverterInterfaceSize(byte[] wsBindFileContents) {
        if (this.getWSBindProductNumber() == -1 || this.getWSBindProductNumber() == -2) {
            this.vendorConverterInterfaceSize = ByteArray.byteArrayToInt(wsBindFileContents, 2160);
        }
    }

    @Override
    public int getVendorConverterInterfaceSize() {
        return this.vendorConverterInterfaceSize;
    }

    private void setWSBindProductNumber(byte[] wsBindFileContents) {
        this.wsbindProductNumber = wsBindFileContents[24];
    }

    @Override
    public byte getWSBindProductNumber() {
        return this.wsbindProductNumber;
    }

    private void setWSDLBinding(byte[] wsBindFileContents) {
        this.wsdlBinding = ByteArray.byteArrayToString(wsBindFileContents, 548, 255, WSBind.US_EBCDIC, TRIM);
    }

    @Override
    public String getWSDLBinding() {
        return this.wsdlBinding;
    }

    private void updateWSBindFileForMode(String value, int offset, int length, boolean mode) {
        if (this.getMode() != mode) {
            throw new IllegalStateException("WSBind file has wrong mode");
        }
        this.updateWSBindFile(value, offset, length);
    }

    private void updateWSBindFile(String value, int offset, int length) {
        try {
            byte[] bytes = Util.padBytes(ByteArray.toCodePageByteArray(value, length, WSBind.US_EBCDIC));
            System.arraycopy(bytes, 0, this.globalWsBindFileContents, offset, length);
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException("Unexpected error");
            re.initCause(e);
            throw re;
        }
    }

    @Override
    public void setEndpointURI(String endpointUri) {
        this.updateWSBindFileForMode(endpointUri, 1066, 255, true);
        this.endpointURI = endpointUri;
    }

    @Override
    public void setTargetProgramName(String programName) {
        this.updateWSBindFileForMode(programName, 803, 8, false);
        this.targetProgramName = programName;
    }

    @Override
    public void setTranId(String tranId) {
        this.updateWSBindFileForMode(tranId, 1347, 4, false);
        this.tranId = tranId;
    }

    @Override
    public void setURI(String uri) {
        this.updateWSBindFileForMode(uri, 811, 255, false);
        this.uri = uri;
    }

    @Override
    public void setUserId(String userId) {
        this.updateWSBindFileForMode(userId, 1351, 8, false);
        this.userid = userId;
    }

    @Override
    public void setVendorConverterProgramName(String programName) {
        if (this.getWSBindProductNumber() != -1 && this.getWSBindProductNumber() != -2) {
            throw new IllegalStateException("WSBind file not vendor style");
        }
        this.updateWSBindFile(programName, 2152, 8);
        this.vendorConverterProgramName = programName;
    }

    @Override
    public void saveWSBindFile(OutputStream os) throws IOException {
        os.write(this.globalWsBindFileContents);
        os.close();
    }

    private void setOperationNames(byte[] wsBindFileContents) {
        int i;
        int offsetOfIndex;
        if (this.getWSBindProductNumber() == -1) {
            this.operationNames = new String[0];
            return;
        }
        int numOperationNames = ByteArray.byteArrayToInt(wsBindFileContents, 288);
        ArrayList<String> opList = new ArrayList<String>();
        int offsetOfCurrentEntry = offsetOfIndex = ByteArray.byteArrayToInt(wsBindFileContents, 284);
        for (i = 0; i < numOperationNames; ++i) {
            byte mep = wsBindFileContents[offsetOfCurrentEntry + 511];
            if (mep != -128) {
                opList.add(ByteArray.byteArrayToString(wsBindFileContents, offsetOfCurrentEntry + 0, 255, WSBind.US_EBCDIC, TRIM));
            }
            try {
                if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                    offsetOfCurrentEntry += 1544;
                    if (!RuntimeLevelHelper.supportsRuntimeLevel_4_0(this.getMinimumRuntimeLevel())) continue;
                    int suffixLength = ByteArray.byteArrayToInt(wsBindFileContents, offsetOfCurrentEntry, 4);
                    offsetOfCurrentEntry += suffixLength + 4;
                    continue;
                }
                offsetOfCurrentEntry += 776;
                continue;
            }
            catch (CICSWSDLException e) {
                RuntimeException exc = new RuntimeException("Unexpected error.");
                exc.initCause(e);
                throw exc;
            }
        }
        this.operationNames = new String[opList.size()];
        for (i = 0; i < opList.size(); ++i) {
            this.operationNames[i] = (String)opList.get(i);
        }
    }

    @Override
    public String[] getOperationNames() {
        return this.operationNames;
    }

    private void setAbstractTypes(byte[] wsBindFileContents) {
        ArrayList<QName> typeList = new ArrayList<QName>();
        try {
            if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_2_1(this.getMinimumRuntimeLevel())) {
                int offsetOfIndex;
                int numOperationNames = ByteArray.byteArrayToInt(wsBindFileContents, 288);
                int offsetOfCurrentEntry = offsetOfIndex = ByteArray.byteArrayToInt(wsBindFileContents, 284);
                for (int i = 0; i < numOperationNames; ++i) {
                    byte mep = wsBindFileContents[offsetOfCurrentEntry + 511];
                    if (mep == -128) {
                        String nameSpace = ByteArray.byteArrayToString(wsBindFileContents, offsetOfCurrentEntry + 255, 255, WSBind.US_EBCDIC, TRIM);
                        String localPart = ByteArray.byteArrayToString(wsBindFileContents, offsetOfCurrentEntry + 0, 255, WSBind.US_EBCDIC, TRIM);
                        QName qName = new QName(nameSpace, localPart);
                        typeList.add(qName);
                    }
                    if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                        offsetOfCurrentEntry += 1544;
                        if (!RuntimeLevelHelper.supportsRuntimeLevel_4_0(this.getMinimumRuntimeLevel())) continue;
                        int suffixLength = ByteArray.byteArrayToInt(wsBindFileContents, offsetOfCurrentEntry, 4);
                        offsetOfCurrentEntry += suffixLength + 4;
                        continue;
                    }
                    offsetOfCurrentEntry += 776;
                }
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
        this.abstractTypes = typeList;
    }

    @Override
    public List<QName> getAbstractTypes() {
        return this.abstractTypes;
    }

    private void setWSDLFileName(byte[] wsBindFileContents) {
        this.wsdlFileName = ByteArray.byteArrayToString(wsBindFileContents, 293, 255, WSBind.US_EBCDIC, TRIM);
    }

    @Override
    public String getWSDLFileName() {
        return this.wsdlFileName;
    }

    @Override
    public void setWSDLFileName(String wsdlFilename) {
        this.updateWSBindFile(wsdlFilename, 293, 255);
        this.wsdlFileName = wsdlFilename;
    }

    private void setWSDL20FileName(byte[] wsBindFileContents) {
        String fileName = null;
        try {
            if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_2_0(this.getMinimumRuntimeLevel())) {
                fileName = ByteArray.byteArrayToString(wsBindFileContents, 1381, 255, WSBind.US_EBCDIC, TRIM);
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
        this.wsdl20FileName = fileName;
    }

    @Override
    public String getWSDL20FileName() {
        return this.wsdl20FileName;
    }

    @Override
    public void setWSDL20FileName(String wsdlFilename) {
        try {
            if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_2_0(this.getMinimumRuntimeLevel())) {
                this.updateWSBindFile(wsdlFilename, 1381, 255);
                this.wsdl20FileName = wsdlFilename;
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
    }

    private void setSyncOnReturn(byte[] wsBindFileContents) {
        if ((wsBindFileContents[283] & 0x20) == 32) {
            this.syncOnReturn = true;
        }
    }

    @Override
    public boolean isSyncOnReturn() {
        return this.syncOnReturn;
    }

    @Override
    public void setSyncOnReturn(boolean syncOnReturn) {
        this.globalWsBindFileContents[283] = syncOnReturn ? (byte)(this.globalWsBindFileContents[283] | 0x20) : (byte)(this.globalWsBindFileContents[283] & 0xDF);
        this.syncOnReturn = syncOnReturn;
    }

    private void setJSONBits(byte[] wsBindFileContents) {
        if ((wsBindFileContents[283] & 4) == 4) {
            this.jsonTopDown = true;
        }
        if ((wsBindFileContents[283] & 2) == 2) {
            this.jsonRESTful = true;
        }
    }

    public boolean isJSONTopDown() {
        return this.jsonTopDown;
    }

    public boolean isJSONRESTful() {
        return this.jsonRESTful;
    }

    private void setRequestChannelFileName(byte[] wsBindFileContents) {
        String fileName = null;
        try {
            if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                fileName = ByteArray.byteArrayToString(wsBindFileContents, 2208, 256, WSBind.US_EBCDIC, TRIM);
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
        this.requestChannelFileName = fileName;
    }

    @Override
    public String getRequestChannelFileName() {
        return this.requestChannelFileName;
    }

    private void setResponseChannelFileName(byte[] wsBindFileContents) {
        String fileName = null;
        try {
            if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                fileName = ByteArray.byteArrayToString(wsBindFileContents, 2464, 256, WSBind.US_EBCDIC, TRIM);
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
        this.responseChannelFileName = fileName;
    }

    @Override
    public String getResponseChannelFileName() {
        return this.responseChannelFileName;
    }

    @Override
    public void setRequestChannelFileName(String fileName) {
        try {
            if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                this.updateWSBindFile(fileName, 2208, 256);
                this.requestChannelFileName = fileName;
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
    }

    @Override
    public void setResponseChannelFileName(String fileName) {
        try {
            if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                this.updateWSBindFile(fileName, 2464, 256);
                this.responseChannelFileName = fileName;
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
    }

    private void setRequestChannelName(byte[] wsBindFileContents) {
        String channelName = null;
        try {
            if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                if (this.getFirstIndexOffset() != 2208) {
                    int end = 2736;
                    for (int i = 2720; i < end; ++i) {
                        if (wsBindFileContents[i] != 0) continue;
                        wsBindFileContents[i] = 64;
                    }
                }
                channelName = ByteArray.byteArrayToString(wsBindFileContents, 2720, 16, WSBind.US_EBCDIC, TRIM);
                if (wsBindFileContents[2720] != 0 && wsBindFileContents[2720] != 64) {
                    this.requestChannelNameAsByteArray = new ByteArray(wsBindFileContents, 2720, 16, true);
                }
            }
        }
        catch (Exception e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
        this.requestChannelName = channelName;
    }

    @Override
    public String getRequestChannelName() {
        return this.requestChannelName;
    }

    public ByteArray getRequestChannelNameAsByteArray() {
        return this.requestChannelNameAsByteArray;
    }

    private void setResponseChannelName(byte[] wsBindFileContents) {
        String channelName = null;
        try {
            if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                if (this.getFirstIndexOffset() != 2208) {
                    int end = 2752;
                    for (int i = 2720; i < end; ++i) {
                        if (wsBindFileContents[i] != 0) continue;
                        wsBindFileContents[i] = 64;
                    }
                }
                channelName = ByteArray.byteArrayToString(wsBindFileContents, 2736, 16, WSBind.US_EBCDIC, TRIM);
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
        this.responseChannelName = channelName;
    }

    @Override
    public String getResponseChannelName() {
        return this.responseChannelName;
    }

    @Override
    public void setRequestChannelName(String channelName) {
        try {
            if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                this.updateWSBindFile(channelName, 2720, 16);
                this.requestChannelName = channelName;
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
    }

    @Override
    public void setResponseChannelName(String channelName) {
        try {
            if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                this.updateWSBindFile(channelName, 2736, 16);
                this.responseChannelName = channelName;
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
    }

    @Override
    public IWSBindFile.Mode getModeEnum() {
        if (this.getTargetProgramName() != null) {
            return IWSBindFile.Mode.MODE_PROVIDER;
        }
        return IWSBindFile.Mode.MODE_REQUESTER;
    }

    @Override
    public IWSBindFile.WSBindProductNumber getWSBindProductNumberEnum() {
        byte byteWSBindProductNumber = this.getWSBindProductNumber();
        if (byteWSBindProductNumber == 1) {
            return IWSBindFile.WSBindProductNumber.PRODUCT_CICS;
        }
        if (byteWSBindProductNumber == -1) {
            return IWSBindFile.WSBindProductNumber.PRODUCT_VENDOR_V1;
        }
        if (byteWSBindProductNumber == -2) {
            return IWSBindFile.WSBindProductNumber.PRODUCT_VENDOR_V2;
        }
        return null;
    }

    @Override
    public IWSBindFile.MinimumRuntimeLevel getMinimumRuntimeLevelEnum() {
        if (this.getWSBindProductNumberEnum().equals((Object)IWSBindFile.WSBindProductNumber.PRODUCT_VENDOR_V1)) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_1_0;
        }
        byte byteMinimumRuntimeLevel = this.getMinimumRuntimeLevel();
        if (byteMinimumRuntimeLevel == 0) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_1_0;
        }
        if (byteMinimumRuntimeLevel == 1) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_1_1;
        }
        if (byteMinimumRuntimeLevel == 2) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_1_2;
        }
        if (byteMinimumRuntimeLevel == 3) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_2_0;
        }
        if (byteMinimumRuntimeLevel == 4) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_2_1;
        }
        if (byteMinimumRuntimeLevel == 5) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_2_2;
        }
        if (byteMinimumRuntimeLevel == 6) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_3_0;
        }
        if (byteMinimumRuntimeLevel == 7) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_4_0;
        }
        if (byteMinimumRuntimeLevel == 8) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_4_1;
        }
        if (byteMinimumRuntimeLevel == 9) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_4_2;
        }
        if (byteMinimumRuntimeLevel == 10) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_4_3;
        }
        if (byteMinimumRuntimeLevel == 11) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_4_4;
        }
        if (byteMinimumRuntimeLevel == 12) {
            return IWSBindFile.MinimumRuntimeLevel.RUNTIME_LEVEL_5_0;
        }
        return null;
    }

    @Override
    public IWSBindFile.MappingLevel getMappingLevelEnum() {
        int intMappingLevel = this.getMappingLevel();
        switch (intMappingLevel) {
            case 1: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_1_0;
            }
            case 2: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_1_1;
            }
            case 3: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_1_2;
            }
            case 4: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_2_0;
            }
            case 5: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_2_1;
            }
            case 6: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_2_2;
            }
            case 7: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_3_0;
            }
            case 8: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_4_0;
            }
            case 9: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_4_1;
            }
            case 10: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_4_2;
            }
            case 11: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_4_3;
            }
            case 12: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_4_4;
            }
            case 13: {
                return IWSBindFile.MappingLevel.MAPPING_LEVEL_5_0;
            }
            case -1: {
                return IWSBindFile.MappingLevel.MAPPING_VENDOR;
            }
            case -2: {
                return IWSBindFile.MappingLevel.MAPPING_XML_ONLY;
            }
        }
        return null;
    }

    @Override
    public IWSBindFile.TargetProgramInterface getTargetProgramInterfaceEnum() {
        byte byteTargetProgramInterface = this.getTargetProgramInterface();
        if (byteTargetProgramInterface == 1) {
            return IWSBindFile.TargetProgramInterface.PGMINT_CHANNEL;
        }
        if (byteTargetProgramInterface == 2) {
            return IWSBindFile.TargetProgramInterface.PGMINT_COMMAREA;
        }
        if (byteTargetProgramInterface == 3) {
            return IWSBindFile.TargetProgramInterface.PGMINT_REQUESTER;
        }
        return null;
    }

    private void setWSBindOperationEntries(byte[] wsBindFileContents) throws ICMException, IOException, CICSWSDLException {
        this.processWSBindIndex(wsBindFileContents);
    }

    public WSBindOperationEntry[] getOperations() throws ICMException, CICSWSDLException, IOException {
        return this.wsBindOperationEntries;
    }

    public Map<QName, WSBindAbstractTypeEntry> getDataTypes() throws ICMException, IOException, CICSWSDLException {
        return this.dataTypes;
    }

    private void processWSBindIndex(byte[] wsBindFileContents) throws ICMException, IOException, CICSWSDLException {
        int i;
        this.dataTypes = new HashMap<QName, WSBindAbstractTypeEntry>();
        if (this.getWSBindProductNumber() == -1) {
            this.wsBindOperationEntries = new WSBindOperationEntry[0];
            return;
        }
        int operationNum = this.getNumberOfOperations();
        ArrayList<WSBindOperationEntry> operations = new ArrayList<WSBindOperationEntry>();
        int offsetOfCurrentEntry = this.getFirstIndexOffset();
        int lengthOfOneIndexEntry = 0;
        byte minRuntimeLevel = this.getMinimumRuntimeLevel();
        lengthOfOneIndexEntry = this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_3_0(minRuntimeLevel) ? 1544 : 776;
        for (i = 0; i < operationNum; ++i) {
            WSBindOperationEntry wsbOpEntry;
            byte mep;
            int lengthOfCurrentIndexEntry = lengthOfOneIndexEntry;
            if (RuntimeLevelHelper.supportsRuntimeLevel_4_0(minRuntimeLevel)) {
                int suffixLength = ByteArray.byteArrayToInt(wsBindFileContents, offsetOfCurrentEntry + lengthOfOneIndexEntry, 4);
                lengthOfCurrentIndexEntry += suffixLength + 4;
            }
            if ((mep = wsBindFileContents[offsetOfCurrentEntry + 511]) != -128) {
                wsbOpEntry = new WSBindOperationEntry(wsBindFileContents, offsetOfCurrentEntry, lengthOfCurrentIndexEntry, this.getMappingLevel(), this.getCCSID(), this.useNamespaces, this.getMinimumRuntimeLevel());
                operations.add(wsbOpEntry);
            } else {
                wsbOpEntry = new WSBindAbstractTypeEntry(wsBindFileContents, offsetOfCurrentEntry, lengthOfCurrentIndexEntry, this.getMappingLevel(), this.getCCSID(), this.getMinimumRuntimeLevel());
                this.dataTypes.put(((WSBindAbstractTypeEntry)wsbOpEntry).getQName(), (WSBindAbstractTypeEntry)wsbOpEntry);
            }
            this.httpMethods = wsBindFileContents[offsetOfCurrentEntry + 510];
            offsetOfCurrentEntry += lengthOfCurrentIndexEntry;
        }
        this.wsBindOperationEntries = new WSBindOperationEntry[operations.size()];
        for (i = 0; i < operations.size(); ++i) {
            this.wsBindOperationEntries[i] = (WSBindOperationEntry)operations.get(i);
        }
    }

    public boolean supportsHTTPGet() {
        return (this.httpMethods & 0xFFFFFF80) == -128;
    }

    public boolean supportsHTTPPost() {
        return (this.httpMethods & 0x40) == 64;
    }

    public boolean supportsHTTPPut() {
        return (this.httpMethods & 0x20) == 32;
    }

    public boolean supportsHTTPDelete() {
        return (this.httpMethods & 0x10) == 16;
    }

    public boolean supportsHTTPHead() {
        return (this.httpMethods & 8) == 8;
    }

    public String getWSBindEyeCatcher() {
        return ByteArray.byteArrayToString(this.globalWsBindFileContents, 0, 8, WSBind.US_EBCDIC, TRIM);
    }

    public int getWSBindLength() {
        return ByteArray.byteArrayToInt(this.globalWsBindFileContents, 8);
    }

    public int getMinorVersion() throws ICMLengthException {
        return ByteArray.byteArrayToInt(this.globalWsBindFileContents, 26, 2);
    }

    public String getWSBindName() {
        return ByteArray.byteArrayToString(this.globalWsBindFileContents, 28, 255, WSBind.US_EBCDIC, TRIM);
    }

    public byte getFlagsByte() {
        return this.globalWsBindFileContents[283];
    }

    private void setFirstIndexOffset(byte[] wsBindFileContents) {
        this.offsetOfIndex = ByteArray.byteArrayToInt(wsBindFileContents, 284);
    }

    public int getFirstIndexOffset() {
        return this.offsetOfIndex;
    }

    private void setNumberOfOperations(byte[] wsBindFileContents) {
        this.numberOfIndexEntries = ByteArray.byteArrayToInt(wsBindFileContents, 288);
    }

    public int getNumberOfOperations() {
        return this.numberOfIndexEntries;
    }

    private void setSOAPStyle(byte[] wsBindFileContents) {
        byte soapStyleByte = wsBindFileContents[292];
        switch (soapStyleByte) {
            case 0: {
                this.soapStyle = SoapStyle.RPC;
                break;
            }
            case 1: {
                this.soapStyle = SoapStyle.DOCUMENT;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported SoapStyle: " + soapStyleByte);
            }
        }
    }

    public SoapStyle getSoapStyle() {
        return this.soapStyle;
    }

    public byte getValidation() {
        return this.globalWsBindFileContents[1338];
    }

    public String getLastModify() {
        return ByteArray.byteArrayToString(this.globalWsBindFileContents, 1339, 8, WSBind.US_EBCDIC, TRIM);
    }

    public String getPipelineName() {
        return ByteArray.byteArrayToString(this.globalWsBindFileContents, 1359, 8, WSBind.US_EBCDIC, TRIM);
    }

    public String getURIMap() {
        if (this.getMode()) {
            return null;
        }
        return ByteArray.byteArrayToString(this.globalWsBindFileContents, 1367, 8, WSBind.US_EBCDIC, TRIM);
    }

    public byte getState() {
        return this.globalWsBindFileContents[1375];
    }

    private void setCCSID(byte[] wsBindFileContents) {
        this.ccsid = 0;
        try {
            if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_1_2(this.getMinimumRuntimeLevel())) {
                this.ccsid = ByteArray.byteArrayToInt(wsBindFileContents, 1376);
            }
            if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_4_0(this.getMinimumRuntimeLevel())) {
                this.altCcsid = ByteArray.byteArrayToInt(wsBindFileContents, 2752);
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
    }

    public int getCCSID() throws ICMException, CICSWSDLException {
        return this.ccsid;
    }

    public byte getWSDLSOAPFlags() {
        byte flag = 0;
        try {
            if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_1_2(this.getMinimumRuntimeLevel())) {
                flag = this.globalWsBindFileContents[1380];
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
        return flag;
    }

    public String getOperationNamespace() {
        String operation_namespace = null;
        try {
            if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_2_1(this.getMinimumRuntimeLevel())) {
                operation_namespace = ByteArray.byteArrayToString(this.globalWsBindFileContents, 1636, 255, WSBind.US_EBCDIC, TRIM);
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
        return operation_namespace;
    }

    public String getPortName() {
        String port_name = null;
        try {
            if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_2_1(this.getMinimumRuntimeLevel())) {
                port_name = ByteArray.byteArrayToString(this.globalWsBindFileContents, 1891, 255, WSBind.US_EBCDIC, TRIM);
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
        return port_name;
    }

    public int getWSAEprLength() throws ICMLengthException {
        int wsa_epr_length = 0;
        try {
            if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                wsa_epr_length = ByteArray.byteArrayToInt(this.globalWsBindFileContents, 2146, 2);
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
        return wsa_epr_length;
    }

    public int getWSAEprOffset() {
        int wsa_epr_offset = 0;
        try {
            if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                wsa_epr_offset = ByteArray.byteArrayToInt(this.globalWsBindFileContents, 2148);
            }
        }
        catch (CICSWSDLException e) {
            RuntimeException exc = new RuntimeException("Unexpected error.");
            exc.initCause(e);
            throw exc;
        }
        return wsa_epr_offset;
    }

    public int getVendorMetaLength() {
        if (this.getWSBindProductNumber() == -2) {
            return ByteArray.byteArrayToInt(this.globalWsBindFileContents, 2164);
        }
        return 0;
    }

    public int getVendorMetaOffset() {
        if (this.getWSBindProductNumber() == -2) {
            return ByteArray.byteArrayToInt(this.globalWsBindFileContents, 2168);
        }
        return 0;
    }

    public String getWSRRequestChannelDescFile() {
        String wsr_request_channel_desc_file = null;
        if (this.getMode()) {
            try {
                if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                    wsr_request_channel_desc_file = ByteArray.byteArrayToString(this.globalWsBindFileContents, 2208, 256, WSBind.US_EBCDIC, TRIM);
                }
            }
            catch (CICSWSDLException e) {
                RuntimeException exc = new RuntimeException("Unexpected error.");
                exc.initCause(e);
                throw exc;
            }
        }
        return wsr_request_channel_desc_file;
    }

    public String getWSRRequestChannelName() {
        String wsr_request_channel_name = null;
        if (this.getMode()) {
            try {
                if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                    wsr_request_channel_name = ByteArray.byteArrayToString(this.globalWsBindFileContents, 2720, 16, WSBind.US_EBCDIC, TRIM);
                }
            }
            catch (CICSWSDLException e) {
                RuntimeException exc = new RuntimeException("Unexpected error.");
                exc.initCause(e);
                throw exc;
            }
        }
        return wsr_request_channel_name;
    }

    public String getWSRResponseChannelDescFile() {
        String wsr_response_channel_desc_file = null;
        if (!this.getMode()) {
            try {
                if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                    wsr_response_channel_desc_file = ByteArray.byteArrayToString(this.globalWsBindFileContents, 2464, 256, WSBind.US_EBCDIC, TRIM);
                }
            }
            catch (CICSWSDLException e) {
                RuntimeException exc = new RuntimeException("Unexpected error.");
                exc.initCause(e);
                throw exc;
            }
        }
        return wsr_response_channel_desc_file;
    }

    public String getWSRResponseChannelName() {
        String wsr_response_channel_name = null;
        if (!this.getMode()) {
            try {
                if (this.getWSBindProductNumber() == 1 && RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.getMinimumRuntimeLevel())) {
                    wsr_response_channel_name = ByteArray.byteArrayToString(this.globalWsBindFileContents, 2736, 16, WSBind.US_EBCDIC, TRIM);
                }
            }
            catch (CICSWSDLException e) {
                RuntimeException exc = new RuntimeException("Unexpected error.");
                exc.initCause(e);
                throw exc;
            }
        }
        return wsr_response_channel_name;
    }

    public boolean useNamespaces() {
        return this.useNamespaces;
    }

    public int getAltCCSID() {
        return this.altCcsid;
    }

    public static enum SoapStyle {
        RPC,
        DOCUMENT;

    }
}

