/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class WrappingOutputStream
extends OutputStream {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2010 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final int LINE_LENGTH = 80;
    private static final byte EBCDIC_NL = 21;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private PrintStream target = null;

    public WrappingOutputStream(PrintStream target) {
        this.target = target;
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void flush() {
        this.target.flush();
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int offset, int length) {
        int currentPointer;
        this.buffer.write(b, offset, length);
        byte[] newBuf = this.buffer.toByteArray();
        int endOffset = newBuf.length;
        int startOfLine = currentPointer;
        for (currentPointer = 0; currentPointer < endOffset; ++currentPointer) {
            int bytesInLine;
            if (newBuf[currentPointer] != 21) continue;
            for (bytesInLine = currentPointer - startOfLine; bytesInLine > 80; bytesInLine -= 80) {
                this.target.write(newBuf, startOfLine, 80);
                this.target.println();
                startOfLine += 80;
            }
            this.target.write(newBuf, startOfLine, bytesInLine);
            startOfLine = currentPointer;
        }
        this.buffer.reset();
        this.buffer.write(newBuf, startOfLine, endOffset - startOfLine);
    }

    @Override
    public void write(int b) {
        this.buffer.write(b);
    }
}

