/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.common;

import com.ibm.cics.bundle.Bundle;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.util.CodePageHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.ParmChecker;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.ls2ws.GeneratedXML;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.xml.sax.SAXException;

public class XSDBind
extends GeneratedXML {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public XSDBind(boolean outputInUTF8, boolean outputInUsEBCDIC, boolean setEncoding) {
        super(outputInUTF8, outputInUsEBCDIC, setEncoding);
    }

    public File buildXSDBindFile(String bindFileName, String schemaName, String runtimeLevel, Date timestamp, String ccsid, String altCcsid, List<QName> elementQNames, List<ICM> elementICMs, List<QName> typeQNames, List<ICM> typeICMs, String mappingLevel, String bundleName, File schemaFile, String vendorProgram, byte[] vendorMetaData) throws IOException, ICMException, JAXBException, SAXException, CICSWSDLException {
        int i;
        StringBuilder output = this.createXMLDocument();
        output.append("<XSDBind runtimeLevel=\"");
        output.append(runtimeLevel);
        if (!"Not Found".equals(ParmChecker.BUILD_LEVEL_NAME)) {
            output.append("\" build=\"");
            output.append(this.truncateString(ParmChecker.BUILD_LEVEL_NAME, 20));
        }
        if (!"Not Found".equals(ParmChecker.BUILD_LEVEL_RELEASE)) {
            output.append("\" release=\"");
            output.append(this.truncateString(ParmChecker.BUILD_LEVEL_RELEASE, 10));
        }
        output.append("\" xmlns=\"http://www.ibm.com/software/htp/cics/xsdbind\"");
        output.append(">" + LINE_SEPARATOR);
        output.append("  <schema>");
        output.append(schemaName);
        output.append("</schema>" + LINE_SEPARATOR);
        output.append("  <timestamp>");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        output.append(sdf.format(timestamp));
        output.append("</timestamp>" + LINE_SEPARATOR);
        if (vendorProgram != null) {
            output.append("  <vendorProgramName>");
            output.append(vendorProgram);
            output.append("</vendorProgramName>" + LINE_SEPARATOR);
            if (vendorMetaData != null) {
                output.append("  <vendorProgramMetadata>" + LINE_SEPARATOR);
                output.append(ByteArray.byteArrayToBase64Binary(vendorMetaData));
                output.append(LINE_SEPARATOR);
                output.append("  </vendorProgramMetadata>" + LINE_SEPARATOR);
            }
        }
        if (elementQNames != null) {
            for (i = 0; i < elementQNames.size(); ++i) {
                QName element = elementQNames.get(i);
                output.append("  <element localname=\"");
                output.append(element.getLocalPart());
                output.append("\" namespace=\"");
                output.append(element.getNamespaceURI());
                output.append("\">" + LINE_SEPARATOR);
                output.append("    <metadata mappingLevel=\"");
                output.append(mappingLevel);
                output.append("\">" + LINE_SEPARATOR);
                output.append(ByteArray.byteArrayToBase64Binary(elementICMs.get(i).toByteArray()));
                output.append(LINE_SEPARATOR);
                output.append("    </metadata>");
                output.append(LINE_SEPARATOR);
                output.append("  </element>");
                output.append(LINE_SEPARATOR);
            }
        }
        if (typeQNames != null) {
            for (i = 0; i < typeQNames.size(); ++i) {
                QName type = typeQNames.get(i);
                output.append("  <type localname=\"");
                output.append(type.getLocalPart());
                output.append("\" namespace=\"");
                output.append(type.getNamespaceURI());
                output.append("\">" + LINE_SEPARATOR);
                output.append("    <metadata mappingLevel=\"");
                output.append(mappingLevel);
                output.append("\">" + LINE_SEPARATOR);
                output.append(ByteArray.byteArrayToBase64Binary(typeICMs.get(i).toByteArray()));
                output.append(LINE_SEPARATOR);
                output.append("    </metadata>");
                output.append(LINE_SEPARATOR);
                output.append("  </type>");
                output.append(LINE_SEPARATOR);
            }
        }
        output.append("  <applicationCCSID>");
        output.append(CodePageHelper.getApplicationCCSID(ccsid));
        output.append("</applicationCCSID>" + LINE_SEPARATOR);
        if (altCcsid != null) {
            output.append("  <alternativeCCSID>");
            output.append(CodePageHelper.getApplicationCCSID(altCcsid));
            output.append("</alternativeCCSID>" + LINE_SEPARATOR);
        }
        output.append("</XSDBind>");
        return this.saveBindFile(bindFileName, output, bundleName, schemaFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveBindFile(String bindFileName, StringBuilder bindFileContent, String bundleName, File schemaFile) throws IOException, CICSWSDLException, JAXBException {
        if (bundleName == null) {
            return this.writeToFile(bindFileName, bindFileContent);
        }
        File tempLocation = File.createTempFile("temp", this.getBindFileExtension());
        this.writeToFile(tempLocation, bindFileContent);
        FileInputStream tempIS = new FileInputStream(tempLocation);
        File bundle = null;
        try {
            bundle = this.buildBundle(bundleName, bindFileName, tempIS, schemaFile);
        }
        finally {
            try {
                tempIS.close();
            }
            catch (IOException ioe) {
                Logging.handleExc(ioe);
            }
            if (!tempLocation.delete()) {
                tempLocation.deleteOnExit();
            }
        }
        return bundle;
    }

    private File buildBundle(String bundleName, String bindFileName, InputStream xsdBind, File schemaFile) throws IOException, CICSWSDLException, JAXBException {
        PrintStream log = Logging.getPrintStream();
        log.println("Generating a bundle: " + bundleName);
        OutputStream out = null;
        ZipOutputStream jos = null;
        File bundleFile = null;
        File tmpFile = null;
        InputStream schemaIS = null;
        try {
            int indexOfExtension;
            bundleFile = Util.confirmFileForOutput(bundleName);
            File xsdBindFile = new File(bindFileName);
            String shortBindName = xsdBindFile.getName();
            if (xsdBindFile.getParentFile() != null) {
                Logging.writeMessage(4, "DFHPI9684W", new Object[]{xsdBindFile.getParentFile().getPath()});
            }
            if ((indexOfExtension = shortBindName.lastIndexOf(this.getBindFileExtension())) > -1) {
                shortBindName = shortBindName.substring(0, indexOfExtension);
            }
            boolean zipFileOutput = false;
            String upperCaseBundleName = bundleName.toUpperCase(Locale.ENGLISH);
            if (upperCaseBundleName.endsWith(".ZIP") || upperCaseBundleName.endsWith(".JAR")) {
                out = new FileOutputStream(bundleFile);
                zipFileOutput = true;
                log.println("generating bundle to: " + bundleFile);
            } else {
                tmpFile = File.createTempFile("tmpZipFile", null);
                out = new FileOutputStream(tmpFile);
                log.println("generating bundle to: " + tmpFile);
            }
            jos = new JarOutputStream(out);
            Bundle bundle = new Bundle((JarOutputStream)jos);
            String shortBundleName = bundleName;
            int indexOfDirectoryEnd = shortBundleName.lastIndexOf(47);
            if (indexOfDirectoryEnd > -1) {
                shortBundleName = shortBundleName.substring(indexOfDirectoryEnd + 1);
            }
            if (zipFileOutput) {
                shortBundleName = shortBundleName.substring(0, shortBundleName.length() - 4);
            }
            bundle.setId(shortBundleName.substring(0, Math.min(shortBundleName.length(), 64)));
            bundle.setBundleMajorVer(1);
            bundle.setBundleMinorVer(0);
            bundle.setBundleMicroVer(0);
            String bindFileNameBundle = this.getBundleSubDirectory() + shortBindName + this.getBindFileExtension();
            log.println("adding bind file: " + bindFileNameBundle);
            bundle.addDefine(shortBindName, "http://www.ibm.com/xmlns/prod/cics/bundle/" + this.getBundleResourceType(), bindFileNameBundle, xsdBind);
            String schemaFileNameBundle = this.getBundleSubDirectory() + schemaFile.getName();
            schemaIS = new FileInputStream(schemaFile);
            log.println("adding schema file: " + schemaFileNameBundle);
            bundle.addArchiveFile(schemaFileNameBundle, schemaIS);
            log.println("writing bundle archive");
            bundle.writeArchive();
            jos.close();
            out.close();
            log.println("finished writing bundle");
            if (!zipFileOutput) {
                this.unzip(tmpFile, bundleFile, log);
            }
        }
        catch (UnsupportedEncodingException uee) {
            IOException ioe = new IOException(uee.getLocalizedMessage());
            ioe.initCause(uee);
            throw ioe;
        }
        catch (SAXException e) {
            IOException ioe = new IOException(e.getLocalizedMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            boolean deleted;
            try {
                if (xsdBind != null) {
                    xsdBind.close();
                }
            }
            catch (IOException ioe) {
                Logging.handleExc(ioe);
            }
            try {
                if (jos != null) {
                    jos.close();
                }
            }
            catch (IOException ioe) {
                Logging.handleExc(ioe);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                Logging.handleExc(ioe);
            }
            try {
                if (schemaIS != null) {
                    schemaIS.close();
                }
            }
            catch (IOException ioe) {
                Logging.handleExc(ioe);
            }
            if (tmpFile != null && !(deleted = tmpFile.delete())) {
                tmpFile.deleteOnExit();
            }
        }
        return bundleFile;
    }

    public String getBindFileExtension() {
        return ".xsdbind";
    }

    public String getBundleSubDirectory() {
        return "xsdbinds/";
    }

    public String getBundleResourceType() {
        return "XMLTRANSFORM";
    }

    protected String truncateString(String source, int maxLength) {
        if (source.length() < maxLength) {
            return source;
        }
        return source.substring(0, maxLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unzip(File sourceFile, File outputDirectory, PrintStream log) throws ZipException, IOException, CICSWSDLException {
        log.println("unpacking bundle to: " + outputDirectory);
        Util.checkDirExistsAndIsWritable(outputDirectory.getParentFile());
        if (!outputDirectory.exists()) {
            boolean ignored = outputDirectory.mkdir();
            if (!ignored) {
                // empty if block
            }
        } else {
            if (!outputDirectory.isDirectory()) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9659E", new Object[]{outputDirectory}));
            }
            Logging.writeMessage(4, "DFHPI9683W", new Object[]{outputDirectory});
        }
        try (ZipFile zipFile = new ZipFile(sourceFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    File newDir = new File(outputDirectory, entry.getName());
                    log.println("creating directory: " + newDir);
                    boolean ignored = newDir.mkdir();
                    if (!ignored) continue;
                    continue;
                }
                File newFile = new File(outputDirectory, entry.getName());
                File newFileParent = newFile.getParentFile();
                if (!newFileParent.exists()) {
                    log.println("creating directory: " + newFileParent);
                    boolean ignored = newFileParent.mkdir();
                    if (ignored) {
                        // empty if block
                    }
                }
                log.println("creating file: " + newFile);
                XSDBind.copyStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(newFile)));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyStream(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }
}

