/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ls2ws;

import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.xmlns.prod.cics.channel.Channel;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXParseException;

public class ChannelDescReader {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";

    protected static Channel readChannelDescriptionFile(String filename) throws CICSWSDLException {
        Channel channel = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.cics.channel");
            Unmarshaller u = jc.createUnmarshaller();
            URL schemaURL = Thread.currentThread().getContextClassLoader().getResource("com/ibm/xmlns/prod/cics/channel/channel.xsd");
            Schema channelSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaURL);
            u.setSchema(channelSchema);
            channel = (Channel)u.unmarshal((Reader)new FileReader(filename));
        }
        catch (FileNotFoundException fne) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9528E", new Object[]{filename}));
            newEx.initCause(fne);
            throw newEx;
        }
        catch (JAXBException je) {
            if (je.getLinkedException() != null && je.getLinkedException() instanceof SAXParseException) {
                SAXParseException se = (SAXParseException)je.getLinkedException();
                CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9027E", new Object[]{se.getLocalizedMessage(), se.getLineNumber(), se.getColumnNumber(), filename}));
                throw newEx;
            }
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{filename, je.getMessage()}));
            newEx.initCause(je);
            throw newEx;
        }
        catch (Exception e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{filename, e.getMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        return channel;
    }
}

