/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ls2ws;

import java.io.Writer;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;

public class CustomMappedXMLStreamWriter
extends MappedXMLStreamWriter {
    private static final String REQUIRED_STRING = "required";
    private static final String PROPERTIES_STRING = "properties";

    public CustomMappedXMLStreamWriter(MappedNamespaceConvention convention, Writer writer) {
        super(convention, writer);
    }

    protected void writeJSONObject(JSONObject rootObject) throws XMLStreamException {
        try {
            this.correctSingleRequiredArrays(rootObject);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        super.writeJSONObject(rootObject);
    }

    private void correctSingleRequiredArrays(JSONObject jsonObject) throws JSONException {
        Object requiredObject;
        if (jsonObject.has(REQUIRED_STRING) && (requiredObject = jsonObject.get(REQUIRED_STRING)) instanceof String) {
            jsonObject.put(REQUIRED_STRING, (Object)new JSONArray().put(requiredObject));
        }
        if (jsonObject.has(PROPERTIES_STRING)) {
            Object propertiesObject = jsonObject.get(PROPERTIES_STRING);
            if (propertiesObject instanceof JSONObject) {
                JSONObject properties = (JSONObject)propertiesObject;
                Iterator keys = properties.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Object property = properties.get(key);
                    if (!(property instanceof JSONObject)) continue;
                    this.correctSingleRequiredArrays((JSONObject)property);
                }
            }
        } else if (jsonObject.has("items")) {
            this.correctSingleRequiredArrays(jsonObject.getJSONObject("items"));
        }
    }
}

