/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ls2ws;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.ls2ws.GeneratedXML;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Element;

public class GeneratedWSDL
extends GeneratedXML {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private String httpBindingName = null;
    private String httpBindingName12 = null;
    private static final String REQUEST_MESSAGE_TAIL = "Request";
    private static final String RESPONSE_MESSAGE_TAIL = "Response";
    private static final String REQUEST_NAMESPACE = "reqns";
    private static final String RESPONSE_NAMESPACE = "resns";
    private static final String REQUEST_PART = "RequestPart";
    private static final String RESPONSE_PART = "ResponsePart";
    protected static final String PORTNAME_TAIL = "Port";
    protected static final String INTERFACE_TAIL = "Interface";
    private static final String SERVICE_TAIL = "Service";
    private static final String BINDINGNAME_TAIL = "SoapBinding";
    protected static final String TNS_1 = "http://www.";
    protected static final String TNS_2 = "com";
    private static final String WSDL_1_1_NS = "http://schemas.xmlsoap.org/wsdl/";
    private static final String WSDL_2_0_NS = "http://www.w3.org/ns/wsdl";
    private static final String SOAP_1_1_NS = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String SOAP_1_2_NS = "http://schemas.xmlsoap.org/wsdl/soap12/";
    private static final String SOAP_NS_WSDL_20 = "http://www.w3.org/ns/wsdl/soap";
    private static final String DEFAULT_HOST = MessageHandler.getMessage("DEFAULT_HOST");
    private static final String DEFAULT_PORT = MessageHandler.getMessage("DEFAULT_PORT");
    private static final String DEFAULT_QUEUE = MessageHandler.getMessage("DEFAULT_QUEUE");
    private static final String HTTP_MARKER = DEFAULT_HOST + ":" + DEFAULT_PORT + "/";
    private static final String HTTP_LOCATION_URI = "http://" + HTTP_MARKER;
    private static final String HTTPS_LOCATION_URI = "https://" + HTTP_MARKER;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String cicsPgm;
    private String operationName;
    private String relativeURI = null;
    private String absoluteURI = null;
    private String uniqueStub;
    protected static final String SOAP_11_NSPREFIX = "soap";
    protected static final String SOAP_12_NSPREFIX = "soap12";
    protected static final String SOAP_11_ENDPOINT_SUFFIX = "Endpoint11";
    protected static final String SOAP_12_ENDPOINT_SUFFIX = "Endpoint";
    private static final String WSDL_11_ADDRESS = "soap:address";
    private static final String WSDL_20_ADDRESS = "wsdl:endpoint";
    private String serviceName = null;
    private PrintStream log = Logging.getPrintStream();
    private int mappingLevel = -1;
    private StringBuilder wsdl = new StringBuilder();
    private Properties p;
    public static final int WSDL_11 = 1;
    public static final int WSDL_20 = 2;

    GeneratedWSDL(ICM requestICM, ICM responseICM, String cicsProgram, String theUniqueStub, String opName, int mappingLevel, String soapVer, int wsdlVer, String policyDir, boolean outputInUTF8, boolean outputInUsEBCDIC, boolean setEncoding, Properties p, boolean complexChannelBased) throws CICSWSDLException {
        super(outputInUTF8, outputInUsEBCDIC, setEncoding);
        this.cicsPgm = cicsProgram;
        this.operationName = opName;
        this.mappingLevel = mappingLevel;
        String binding_name = p.getProperty("BINDING-NAME");
        this.httpBindingName = binding_name != null && !binding_name.equals("") ? binding_name : cicsProgram + "HTTP" + BINDINGNAME_TAIL;
        String service_name = p.getProperty("SERVICE-NAME");
        this.serviceName = service_name != null && !service_name.equals("") ? service_name : cicsProgram + SERVICE_TAIL;
        this.outputInUTF8 = outputInUTF8;
        this.httpBindingName12 = "1.2".equals(soapVer) || "ALL".equals(soapVer) ? this.httpBindingName + "12" : null;
        this.absoluteURI = p.getProperty("URI_ABSOLUTE");
        String theRelativeURI = p.getProperty("URI_RELATIVE");
        this.relativeURI = theRelativeURI != null && theRelativeURI.indexOf(47) == 0 ? theRelativeURI.substring(1) : theRelativeURI;
        if (policyDir != null) {
            // empty if block
        }
        this.uniqueStub = theUniqueStub;
        this.p = p;
        this.buildWSDLFromICMs(requestICM, responseICM, soapVer, wsdlVer, complexChannelBased);
    }

    private void buildWSDLFromICMs(ICM requestICM, ICM responseICM, String soapVer, int wsdlVer, boolean complexChannelBased) throws CICSWSDLException {
        String thisNamespace;
        String wsdlNS = null;
        String soap11_NS = null;
        String soap12_NS = null;
        String topLevelTagName = null;
        List<Element> policiesForBinding = null;
        List<Element> policiesForOperation = null;
        List<Element> policiesForReqMsg = null;
        List<Element> policiesForRespMsg = null;
        switch (wsdlVer) {
            case 1: {
                wsdlNS = WSDL_1_1_NS;
                soap11_NS = SOAP_1_1_NS;
                soap12_NS = SOAP_1_2_NS;
                topLevelTagName = "definitions";
                break;
            }
            case 2: {
                wsdlNS = WSDL_2_0_NS;
                soap11_NS = SOAP_NS_WSDL_20;
                soap12_NS = SOAP_NS_WSDL_20;
                topLevelTagName = "description";
                break;
            }
            default: {
                throw new RuntimeException("Internal error: bad WSDL version: " + wsdlVer);
            }
        }
        this.wsdl = this.createXMLDocument();
        if (this.mappingLevel == 0) {
            this.mappingLevel = 3;
        }
        this.wsdl.append("<!--" + MessageHandler.buildMessage("WSDL_COMMENT_MAPPING_LEVEL", new Object[]{"DFHLS2WS", ICM.MAPPING_LEVELS[this.mappingLevel]}) + " -->" + LINE_SEPARATOR);
        this.targetNamespace = thisNamespace = this.p.getProperty("WSDL-NAMESPACE", TNS_1 + this.cicsPgm + "." + this.uniqueStub + TNS_2);
        this.wsdl.append("<" + topLevelTagName + " targetNamespace=\"" + thisNamespace + "\" xmlns=\"" + wsdlNS + "\" ");
        if (requestICM != null) {
            this.wsdl.append("xmlns:reqns=\"" + requestICM.getTargetNameSpace() + "\" ");
        }
        if (responseICM != null) {
            this.wsdl.append("xmlns:resns=\"" + responseICM.getTargetNameSpace() + "\" ");
        }
        if (wsdlVer == 2) {
            this.wsdl.append("xmlns:wsdlx=\"http://www.w3.org/ns/wsdl-extensions\" ");
        }
        if ("1.1".equals(soapVer) || "ALL".equals(soapVer)) {
            this.wsdl.append("xmlns:soap=\"" + soap11_NS + "\" ");
        }
        if ("1.2".equals(soapVer) || "ALL".equals(soapVer)) {
            this.wsdl.append("xmlns:soap12=\"" + soap12_NS + "\" ");
        }
        this.wsdl.append("xmlns:tns=\"" + thisNamespace + "\">" + LINE_SEPARATOR);
        int indent = 3;
        this.addIndent(indent, this.wsdl);
        this.wsdl.append("<types>" + LINE_SEPARATOR);
        indent += 3;
        if (requestICM != null) {
            this.log.println("Building request message");
            this.addIndent(indent, this.wsdl);
            this.formatSchema(this.wsdl, requestICM);
        }
        if (responseICM != null) {
            this.log.println("Building response message");
            this.addIndent(indent, this.wsdl);
            this.formatSchema(this.wsdl, responseICM);
        }
        if (complexChannelBased) {
            InputStream schemaStr = Thread.currentThread().getContextClassLoader().getResourceAsStream("com/ibm/xmlns/prod/cics/channel/channel-instance.xsd");
            BufferedReader schemaRdr = new BufferedReader(new InputStreamReader(schemaStr));
            try {
                String line = schemaRdr.readLine();
                while (line != null) {
                    this.addIndent(indent, this.wsdl);
                    this.wsdl.append(line + LINE_SEPARATOR);
                    line = schemaRdr.readLine();
                }
            }
            catch (IOException ioe) {
                CICSWSDLException ex = new CICSWSDLException(ioe.getMessage());
                ex.initCause(ioe);
                throw ex;
            }
            finally {
                try {
                    schemaRdr.close();
                }
                catch (IOException ioe) {
                    CICSWSDLException ex = new CICSWSDLException(ioe.getMessage());
                    ex.initCause(ioe);
                    throw ex;
                }
            }
        }
        this.addIndent(indent -= 3, this.wsdl);
        this.wsdl.append("</types>" + LINE_SEPARATOR);
        String responseMsgName = null;
        String requestMsgName = this.operationName + REQUEST_MESSAGE_TAIL;
        if (wsdlVer == 1) {
            if (responseICM != null) {
                responseMsgName = this.operationName + RESPONSE_MESSAGE_TAIL;
                this.addMessage_1_1(indent, this.wsdl, responseMsgName, "resns:" + responseICM.getTopLevelElementLocalName(), RESPONSE_PART);
            }
            if (requestICM != null) {
                this.addMessage_1_1(indent, this.wsdl, requestMsgName, "reqns:" + requestICM.getTopLevelElementLocalName(), REQUEST_PART);
            }
        }
        if (wsdlVer == 1) {
            String portTypeName = this.p.getProperty("PORT-NAME");
            if (portTypeName == null || portTypeName.equals("")) {
                portTypeName = this.cicsPgm + PORTNAME_TAIL;
            }
            this.addPortType_1_1(indent, this.wsdl, requestMsgName, requestICM, responseMsgName, responseICM, portTypeName);
            this.addSOAPBindings_1_1(indent, this.wsdl, soapVer, portTypeName, requestMsgName, responseMsgName, policiesForBinding, policiesForOperation, policiesForReqMsg, policiesForRespMsg);
            this.addService_1_1(indent, this.wsdl, soapVer, portTypeName);
        } else if (wsdlVer == 2) {
            String interfaceName = this.cicsPgm + INTERFACE_TAIL;
            this.addInterface_2_0(indent, this.wsdl, requestICM, responseICM, interfaceName);
            this.addSOAPBindings_2_0(indent, this.wsdl, soapVer, interfaceName, policiesForBinding, policiesForOperation);
            this.addService_2_0(indent, this.wsdl, soapVer, interfaceName);
        }
        this.addIndent(indent -= 3, this.wsdl);
        this.wsdl.append("</" + topLevelTagName + ">" + LINE_SEPARATOR);
    }

    private void addInlinePolicies(List<Element> policyList, StringBuilder buffer, int indent) {
        if (policyList == null) {
            return;
        }
        Iterator<Element> policyListIt = policyList.iterator();
        while (policyListIt.hasNext()) {
            this.addIndent(indent, buffer);
            Element policyElement = policyListIt.next();
            this.serialiseXMLElementToBuffer(policyElement, buffer, indent);
        }
    }

    public final String getHttpBindingName() {
        if (this.httpBindingName12 != null) {
            return this.httpBindingName12;
        }
        return this.httpBindingName;
    }

    final void writeToFile(String filename) throws IOException {
        this.writeToFile(filename, this.wsdl);
    }

    private void addIndent(int indent, StringBuilder buffer) {
        for (int i = 0; i < indent; ++i) {
            buffer.append(" ");
        }
    }

    private void addMessage_1_1(int indent, StringBuilder buffer, String name, String partElementQName, String partName) {
        this.addIndent(indent, buffer);
        buffer.append("<message name=\"" + name + "\">" + LINE_SEPARATOR);
        this.addIndent(indent += 3, buffer);
        buffer.append("<part element=\"" + partElementQName + "\" name=\"" + partName + "\"/>" + LINE_SEPARATOR);
        this.addIndent(indent -= 3, buffer);
        buffer.append("</message>" + LINE_SEPARATOR);
    }

    private void addSOAPBinding_1_1(int indent, StringBuilder buffer, String portTypeName, String operationName, String requestMsgName, String requestMsgPartName, String responseMsgName, String responseMsgPartName, String bindingName, String nsPrefix, List<Element> policiesForService, List<Element> policiesForOperation, List<Element> policiesForReqMsg, List<Element> policiesForRespMsg) {
        this.addIndent(indent, buffer);
        buffer.append("<binding name=\"" + bindingName + "\" type=\"tns:" + portTypeName + "\">" + LINE_SEPARATOR);
        this.addIndent(indent += 3, buffer);
        if (SOAP_11_NSPREFIX.equals(nsPrefix)) {
            buffer.append("<!-- " + MessageHandler.getMessage("WSDL_COMMENT_SOAP11") + " -->" + LINE_SEPARATOR);
        } else if (SOAP_12_NSPREFIX.equals(nsPrefix)) {
            buffer.append("<!-- " + MessageHandler.getMessage("WSDL_COMMENT_SOAP12") + " -->" + LINE_SEPARATOR);
        }
        this.addIndent(indent, buffer);
        buffer.append("<" + nsPrefix + ":binding style=\"document\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>" + LINE_SEPARATOR);
        if (policiesForService != null) {
            this.addInlinePolicies(policiesForService, buffer, indent);
        }
        this.addIndent(indent, buffer);
        buffer.append("<operation name=\"" + operationName + "\">" + LINE_SEPARATOR);
        this.addIndent(indent += 3, buffer);
        buffer.append("<" + nsPrefix + ":operation soapAction=\"\" style=\"document\"/>" + LINE_SEPARATOR);
        if (policiesForOperation != null) {
            this.addInlinePolicies(policiesForOperation, buffer, indent);
        }
        if (requestMsgName != null) {
            this.addIndent(indent, buffer);
            buffer.append("<input name=\"" + requestMsgName + "\">" + LINE_SEPARATOR);
            indent += 3;
            if (requestMsgPartName != null) {
                this.addIndent(indent, buffer);
                buffer.append("<" + nsPrefix + ":body parts=\"" + requestMsgPartName + "\" use=\"literal\"/>" + LINE_SEPARATOR);
            }
            if (policiesForReqMsg != null) {
                this.addInlinePolicies(policiesForReqMsg, buffer, indent);
            }
            this.addIndent(indent -= 3, buffer);
            buffer.append("</input>" + LINE_SEPARATOR);
        }
        if (responseMsgName != null) {
            this.addIndent(indent, buffer);
            buffer.append("<output name=\"" + responseMsgName + "\">" + LINE_SEPARATOR);
            indent += 3;
            if (responseMsgPartName != null) {
                this.addIndent(indent, buffer);
                buffer.append("<" + nsPrefix + ":body parts=\"" + responseMsgPartName + "\" use=\"literal\"/>" + LINE_SEPARATOR);
            }
            if (policiesForRespMsg != null) {
                this.addInlinePolicies(policiesForRespMsg, buffer, indent);
            }
            this.addIndent(indent -= 3, buffer);
            buffer.append("</output>" + LINE_SEPARATOR);
        }
        this.addIndent(indent -= 3, buffer);
        buffer.append("</operation>" + LINE_SEPARATOR);
        this.addIndent(indent -= 3, buffer);
        buffer.append("</binding>" + LINE_SEPARATOR);
    }

    private void addSOAPBinding_2_0(int indent, StringBuilder buffer, String interfaceName, String operationName, String bindingName, String nsPrefix, List<Element> policiesForBinding, List<Element> policiesForOperation) {
        this.addIndent(indent, buffer);
        if (SOAP_11_NSPREFIX.equals(nsPrefix)) {
            buffer.append("<!-- " + MessageHandler.getMessage("WSDL_COMMENT_SOAP11") + " -->" + LINE_SEPARATOR);
        } else if (SOAP_12_NSPREFIX.equals(nsPrefix)) {
            buffer.append("<!-- " + MessageHandler.getMessage("WSDL_COMMENT_SOAP12") + " -->" + LINE_SEPARATOR);
        }
        this.addIndent(indent, buffer);
        buffer.append("<binding name=\"" + bindingName + "\"" + LINE_SEPARATOR);
        this.addIndent(indent, buffer);
        buffer.append("         interface=\"tns:" + interfaceName + "\"" + LINE_SEPARATOR);
        this.addIndent(indent, buffer);
        buffer.append("         type=\"http://www.w3.org/ns/wsdl/soap\"" + LINE_SEPARATOR);
        String protocol = null;
        if (SOAP_11_NSPREFIX.equals(nsPrefix)) {
            this.addIndent(indent, buffer);
            buffer.append("         " + nsPrefix + ":version=\"1.1\"" + LINE_SEPARATOR);
            protocol = "http://www.w3.org/2006/01/soap11/bindings/HTTP/";
        } else if (SOAP_12_NSPREFIX.equals(nsPrefix)) {
            protocol = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        this.addIndent(indent, buffer);
        buffer.append("         " + nsPrefix + ":protocol=\"" + protocol + "\">" + LINE_SEPARATOR);
        this.addInlinePolicies(policiesForBinding, buffer, indent += 3);
        this.addIndent(indent, buffer);
        buffer.append("<operation ref=\"tns:" + operationName + "\"/>" + LINE_SEPARATOR);
        indent -= 3;
        if (policiesForOperation != null) {
            this.addInlinePolicies(policiesForOperation, buffer, indent);
        }
        this.addIndent(indent, buffer);
        buffer.append("</binding>" + LINE_SEPARATOR);
    }

    private void addSOAPAddress_1_1(int indent, StringBuilder buffer, String uriAbsolute, String uriRelative, String portTypeName, String bindingName, String nsPrefix) {
        this.addIndent(indent += 3, buffer);
        buffer.append("<port binding=\"tns:" + bindingName + "\" name=\"" + portTypeName + "\">" + LINE_SEPARATOR);
        if (" ".equals(uriRelative)) {
            uriRelative = "";
        }
        indent += 3;
        if (uriAbsolute != null) {
            this.addIndent(indent, buffer);
            buffer.append("<" + nsPrefix + ":address location=\"" + uriAbsolute + "\"/>" + LINE_SEPARATOR);
        } else {
            this.addIndent(indent, buffer);
            buffer.append("<!-- " + MessageHandler.buildMessage("WSDL_COMMENT_HTTP_TRANSPORT", new Object[]{WSDL_11_ADDRESS}) + LINE_SEPARATOR);
            this.addIndent(indent, buffer);
            buffer.append("     " + MessageHandler.buildMessage("WSDL_COMMENT_HTTP_HOSTNAME", new Object[]{DEFAULT_HOST}) + LINE_SEPARATOR);
            this.addIndent(indent, buffer);
            buffer.append("     " + MessageHandler.buildMessage("WSDL_COMMENT_HTTP_PORT", new Object[]{DEFAULT_PORT}) + " -->" + LINE_SEPARATOR);
            this.addIndent(indent, buffer);
            buffer.append("<" + nsPrefix + ":address location=\"" + HTTP_LOCATION_URI + uriRelative + "\"/>" + LINE_SEPARATOR);
            this.addIndent(indent, buffer);
            buffer.append("<!-- " + MessageHandler.buildMessage("WSDL_COMMENT_HTTPS_TRANSPORT", new Object[]{WSDL_11_ADDRESS}) + " -->" + LINE_SEPARATOR);
            this.addIndent(indent, buffer);
            buffer.append("<!-- <" + nsPrefix + ":address location=\"" + HTTPS_LOCATION_URI + uriRelative + "\"/> -->" + LINE_SEPARATOR);
            this.addIndent(indent, buffer);
            buffer.append("<!-- " + MessageHandler.buildMessage("WSDL_COMMENT_MQS_TRANSPORT", new Object[]{WSDL_11_ADDRESS}) + LINE_SEPARATOR);
            this.addIndent(indent, buffer);
            buffer.append("     " + MessageHandler.buildMessage("WSDL_COMMENT_MQS_QUEUE", new Object[]{DEFAULT_QUEUE}) + " -->" + LINE_SEPARATOR);
            this.addIndent(indent, buffer);
            buffer.append("<!-- <" + nsPrefix + ":address location=\"jms:/queue?destination=" + DEFAULT_QUEUE + "&amp;connectionFactory=()&amp;targetService=/" + uriRelative + "&amp;initialContextFactory=com.ibm.mq.jms.Nojndi\" /> -->" + LINE_SEPARATOR);
        }
        this.addIndent(indent -= 3, buffer);
        buffer.append("</port>" + LINE_SEPARATOR);
        indent -= 3;
    }

    private void addSOAPAddress_2_0(int indent, StringBuilder buffer, String uriAbsolute, String uriRelative, String interfaceName, String bindingName, String nsPrefix) {
        String endpointName = null;
        if (SOAP_11_NSPREFIX.equals(nsPrefix)) {
            endpointName = interfaceName + SOAP_11_ENDPOINT_SUFFIX;
        } else if (SOAP_12_NSPREFIX.equals(nsPrefix)) {
            endpointName = interfaceName + SOAP_12_ENDPOINT_SUFFIX;
        }
        indent += 3;
        if (uriAbsolute == null) {
            this.addIndent(indent, buffer);
            buffer.append("<!-- " + MessageHandler.buildMessage("WSDL_COMMENT_HTTP_TRANSPORT", new Object[]{WSDL_20_ADDRESS}) + LINE_SEPARATOR);
            this.addIndent(indent, buffer);
            buffer.append("     " + MessageHandler.buildMessage("WSDL_COMMENT_HTTP_HOSTNAME", new Object[]{DEFAULT_HOST}) + LINE_SEPARATOR);
            this.addIndent(indent, buffer);
            buffer.append("     " + MessageHandler.buildMessage("WSDL_COMMENT_HTTP_PORT", new Object[]{DEFAULT_PORT}) + " -->" + LINE_SEPARATOR);
        }
        this.addIndent(indent, buffer);
        buffer.append("<endpoint binding=\"tns:" + bindingName + "\"" + LINE_SEPARATOR);
        this.addIndent(indent, buffer);
        buffer.append("          name=\"" + interfaceName + endpointName + "\"" + LINE_SEPARATOR);
        this.addIndent(indent, buffer);
        if (uriAbsolute != null) {
            buffer.append("          address=\"" + uriAbsolute + "\"/>" + LINE_SEPARATOR);
        } else {
            buffer.append("          address=\"" + HTTP_LOCATION_URI + uriRelative + "\"/>" + LINE_SEPARATOR);
        }
    }

    private void addPortType_1_1(int indent, StringBuilder buffer, String requestMsgName, ICM requestICM, String responseMsgName, ICM responseICM, String portTypeName) {
        this.addIndent(indent, buffer);
        buffer.append("<portType name=\"" + portTypeName + "\">" + LINE_SEPARATOR);
        this.addIndent(indent += 3, buffer);
        buffer.append("<operation name=\"" + this.operationName + "\">" + LINE_SEPARATOR);
        indent += 3;
        if (requestICM != null) {
            this.addIndent(indent, buffer);
            buffer.append("<input message=\"tns:" + requestMsgName + "\" name=\"" + requestMsgName + "\"/>" + LINE_SEPARATOR);
        }
        if (responseICM != null) {
            this.addIndent(indent, buffer);
            buffer.append("<output message=\"tns:" + responseMsgName + "\" name=\"" + responseMsgName + "\"/>" + LINE_SEPARATOR);
        }
        this.addIndent(indent -= 3, buffer);
        buffer.append("</operation>" + LINE_SEPARATOR);
        this.addIndent(indent -= 3, buffer);
        buffer.append("</portType>" + LINE_SEPARATOR);
    }

    private void addInterface_2_0(int indent, StringBuilder buffer, ICM requestICM, ICM responseICM, String interfaceName) {
        this.addIndent(indent, buffer);
        buffer.append("<interface name=\"" + interfaceName + "\">" + LINE_SEPARATOR);
        this.addIndent(indent += 3, buffer);
        buffer.append("<operation name=\"" + this.operationName + "\"" + LINE_SEPARATOR);
        this.addIndent(indent, buffer);
        if (responseICM != null) {
            buffer.append("           pattern=\"http://www.w3.org/ns/wsdl/in-out\"" + LINE_SEPARATOR);
        } else {
            buffer.append("           pattern=\"http://www.w3.org/ns/wsdl/in-only\"" + LINE_SEPARATOR);
        }
        this.addIndent(indent, buffer);
        buffer.append("           wsdlx:safe=\"false\">" + LINE_SEPARATOR);
        indent += 3;
        if (requestICM != null) {
            this.addIndent(indent, buffer);
            buffer.append("<input messageLabel=\"In\"" + LINE_SEPARATOR);
            this.addIndent(indent, buffer);
            buffer.append("       element=\"reqns:" + requestICM.getTopLevelElementLocalName() + "\"/>" + LINE_SEPARATOR);
        }
        if (responseICM != null) {
            this.addIndent(indent, buffer);
            buffer.append("<output messageLabel=\"Out\"" + LINE_SEPARATOR);
            this.addIndent(indent, buffer);
            buffer.append("       element=\"resns:" + responseICM.getTopLevelElementLocalName() + "\"/>" + LINE_SEPARATOR);
        }
        this.addIndent(indent -= 3, buffer);
        buffer.append("</operation>" + LINE_SEPARATOR);
        this.addIndent(indent -= 3, buffer);
        buffer.append("</interface>" + LINE_SEPARATOR);
    }

    private void addSOAPBindings_1_1(int indent, StringBuilder buffer, String soapVer, String portTypeName, String requestMsgName, String responseMsgName, List<Element> policiesForBinding, List<Element> policiesForOperation, List<Element> policiesForReqMsg, List<Element> policiesForRespMsg) {
        if ("1.1".equals(soapVer) || "ALL".equals(soapVer)) {
            this.addSOAPBinding_1_1(indent, buffer, portTypeName, this.operationName, requestMsgName, REQUEST_PART, responseMsgName, RESPONSE_PART, this.httpBindingName, SOAP_11_NSPREFIX, policiesForBinding, policiesForOperation, policiesForReqMsg, policiesForRespMsg);
        }
        if ("1.2".equals(soapVer) || "ALL".equals(soapVer)) {
            this.addSOAPBinding_1_1(indent, buffer, portTypeName, this.operationName, requestMsgName, REQUEST_PART, responseMsgName, RESPONSE_PART, this.httpBindingName12, SOAP_12_NSPREFIX, policiesForBinding, policiesForOperation, policiesForReqMsg, policiesForRespMsg);
        }
    }

    private void addSOAPBindings_2_0(int indent, StringBuilder buffer, String soapVer, String interfaceName, List<Element> policiesForBinding, List<Element> policiesForOperation) {
        if ("1.1".equals(soapVer) || "ALL".equals(soapVer)) {
            this.addSOAPBinding_2_0(indent, buffer, interfaceName, this.operationName, this.httpBindingName, SOAP_11_NSPREFIX, policiesForBinding, policiesForOperation);
        }
        if ("1.2".equals(soapVer) || "ALL".equals(soapVer)) {
            this.addSOAPBinding_2_0(indent, buffer, interfaceName, this.operationName, this.httpBindingName12, SOAP_12_NSPREFIX, policiesForBinding, policiesForOperation);
        }
    }

    private void addService_1_1(int indent, StringBuilder buffer, String soapVer, String portTypeName) {
        this.addIndent(indent, buffer);
        buffer.append("<service name=\"" + this.serviceName + "\">" + LINE_SEPARATOR);
        if ("1.1".equals(soapVer) || "ALL".equals(soapVer)) {
            this.addSOAPAddress_1_1(indent, buffer, this.absoluteURI, this.relativeURI, portTypeName, this.httpBindingName, SOAP_11_NSPREFIX);
        }
        if ("1.2".equals(soapVer) || "ALL".equals(soapVer)) {
            if ("ALL".equals(soapVer)) {
                portTypeName = portTypeName + "12";
            }
            this.addSOAPAddress_1_1(indent, buffer, this.absoluteURI, this.relativeURI, portTypeName, this.httpBindingName12, SOAP_12_NSPREFIX);
        }
        this.addIndent(indent, buffer);
        buffer.append("</service>" + LINE_SEPARATOR);
    }

    private void addService_2_0(int indent, StringBuilder buffer, String soapVer, String interfaceName) {
        this.addIndent(indent, buffer);
        buffer.append("<service name=\"" + this.serviceName + "\"" + LINE_SEPARATOR);
        this.addIndent(indent, buffer);
        buffer.append("         interface=\"tns:" + interfaceName + "\">" + LINE_SEPARATOR);
        if ("1.1".equals(soapVer) || "ALL".equals(soapVer)) {
            this.addSOAPAddress_2_0(indent, buffer, this.absoluteURI, this.relativeURI, interfaceName, this.httpBindingName, SOAP_11_NSPREFIX);
        }
        if ("1.2".equals(soapVer) || "ALL".equals(soapVer)) {
            this.addSOAPAddress_2_0(indent, buffer, this.absoluteURI, this.relativeURI, interfaceName, this.httpBindingName12, SOAP_12_NSPREFIX);
        }
        this.addIndent(indent, buffer);
        buffer.append("</service>" + LINE_SEPARATOR);
    }
}

