/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ls2ws;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMRuntimeException;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;

public class GeneratedXML {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private PrintStream log = Logging.getPrintStream();
    private String codepage = null;
    private String encoding = null;
    protected String targetNamespace = null;
    boolean outputInUTF8 = false;
    boolean outputInUsEBCDIC = false;

    public GeneratedXML(boolean outputInUTF8, boolean outputInUsEbcdic, boolean setEncoding) {
        this.outputInUTF8 = outputInUTF8;
        this.outputInUsEBCDIC = outputInUsEbcdic;
        this.encoding = null;
        if (outputInUTF8) {
            this.codepage = "UTF-8";
            if (setEncoding) {
                this.encoding = "UTF-8";
            }
        } else if (this.outputInUsEBCDIC) {
            this.codepage = "Cp037";
            if (setEncoding) {
                this.encoding = "EBCDIC-CP-US";
            }
        }
    }

    public File generateXMLSchema(ICM theICM, String filename) throws CICSWSDLException, IOException {
        StringBuilder generatedXML = this.createXMLDocument();
        this.formatSchema(generatedXML, theICM);
        this.targetNamespace = theICM.getTargetNameSpace();
        return this.writeToFile(filename, generatedXML);
    }

    protected StringBuilder createXMLDocument() {
        StringBuilder output = new StringBuilder();
        output.append("<?xml version=\"1.0\" ");
        if (this.encoding != null) {
            output.append("encoding=\"" + this.encoding + "\" ");
        }
        output.append("?>" + LINE_SEPARATOR);
        return output;
    }

    protected final File writeToFile(String filename, StringBuilder outputXML) throws IOException {
        return this.writeToFile(new File(filename), outputXML);
    }

    protected final File writeToFile(File outputFile, StringBuilder outputXML) throws IOException {
        try (FileOutputStream wsdlFile = null;){
            this.log.println();
            this.log.println("Generated XML: " + outputFile.getAbsolutePath());
            this.log.println("--------------");
            this.log.println(outputXML);
            wsdlFile = new FileOutputStream(outputFile);
            if (this.codepage != null) {
                wsdlFile.write(outputXML.toString().getBytes(this.codepage));
            } else if (this.outputInUTF8) {
                wsdlFile.write(outputXML.toString().getBytes("UTF-8"));
            } else if (this.outputInUsEBCDIC) {
                wsdlFile.write(outputXML.toString().getBytes("Cp037"));
            } else {
                wsdlFile.write(outputXML.toString().getBytes());
            }
        }
        return outputFile;
    }

    protected final void serialiseXMLElementToBuffer(Element element, StringBuilder outputBuffer, int indentChars) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StringBuilder indentBuffer = new StringBuilder();
        for (int i = 0; i < indentChars; ++i) {
            indentBuffer.append(' ');
        }
        String indent = indentBuffer.toString();
        String indentAngle = indent + " <";
        if (element != null) {
            try {
                TransformerFactory fact = TransformerFactory.newInstance();
                Transformer trans = fact.newTransformer();
                trans.setOutputProperty("indent", "yes");
                trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
                trans.setOutputProperty("omit-xml-declaration", "yes");
                trans.setOutputProperty("encoding", "UTF-8");
                trans.setOutputProperty("method", "html");
                trans.transform(new DOMSource(element), new StreamResult(baos));
            }
            catch (TransformerConfigurationException e) {
                ICMRuntimeException ire = new ICMRuntimeException("INTERNAL ERROR: XML Transformer Configuration problem");
                ire.initCause(e);
                throw ire;
            }
            catch (TransformerException e) {
                ICMRuntimeException ire = new ICMRuntimeException("INTERNAL ERROR: XML Transformer problem");
                ire.initCause(e);
                throw ire;
            }
        }
        try {
            StringBuilder tmp = new StringBuilder(baos.toString("UTF-8"));
            this.replaceAll(tmp, "&#13;", "");
            this.replaceAll(tmp, " <", indentAngle);
            this.replaceAll(tmp, "</xsd:schema>", indent + "</xsd:schema>");
            outputBuffer.append((CharSequence)tmp);
        }
        catch (UnsupportedEncodingException une) {
            ICMRuntimeException ire = new ICMRuntimeException("INTERNAL ERROR: Codepage problem encountered.");
            ire.initCause(une);
            throw ire;
        }
    }

    private void replaceAll(StringBuilder sb, String token, String replacement) {
        int startIndex = sb.indexOf(token);
        int tokenLength = token.length();
        int replacementLength = replacement.length();
        while (startIndex > -1) {
            sb.replace(startIndex, startIndex + tokenLength, replacement);
            startIndex = sb.indexOf(token, startIndex + replacementLength + 1);
        }
    }

    protected final void formatSchema(StringBuilder outputBuffer, ICM icm) throws CICSWSDLException {
        if (icm != null) {
            try {
                Element icmSchema = icm.toXMLElement();
                this.serialiseXMLElementToBuffer(icmSchema, outputBuffer, 6);
            }
            catch (ICMException exc) {
                CICSWSDLException newEx = icm.getMessages().length < 1 ? new CICSWSDLException(exc.getLocalizedMessage()) : new CICSWSDLException(icm.getMessages());
                newEx.initCause(exc);
                throw newEx;
            }
        }
    }

    protected String getCodepage() {
        if (this.codepage != null) {
            return this.codepage;
        }
        if (this.outputInUTF8) {
            return "UTF-8";
        }
        if (this.outputInUsEBCDIC) {
            return "CP-037";
        }
        return "";
    }

    protected String getTargetNamespace() {
        return this.targetNamespace;
    }
}

