/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ls2ws;

import com.ibm.cics.gen.api.IBottomUpHelper;
import com.ibm.cics.gen.api.IPlatform;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMBuilder;
import com.ibm.cics.schema.ICMCreationParameters;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMInputArrayEndDataType;
import com.ibm.cics.schema.ICMInputArrayStartDataType;
import com.ibm.cics.schema.ICMInputContainerDataType;
import com.ibm.cics.schema.ICMInputSimpleDataType;
import com.ibm.cics.schema.ICMInputStructureEndDataType;
import com.ibm.cics.schema.ICMInputStructureStartDataType;
import com.ibm.cics.schema.ICMInterceptor;
import com.ibm.cics.schema.impl.Factory;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.schema.utils.UniqueNameGenerator;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.PDSAccessor;
import com.ibm.cics.wsdl.ls2ws.MappingData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public abstract class LangStruct {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private ICMBuilder builder;
    private ICM icm;
    protected ICM.XMLContentType msgType;
    protected boolean isCaseSensitiveLanguage;
    private String operationName;
    protected int mappingLevel = -1;
    protected ICM.VaryingLength mappingStrategy = ICM.VaryingLength.NO_VARYING_STRATEGY;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected boolean useHexFloat = true;
    protected PrintStream log = Logging.getPrintStream();
    private IBottomUpHelper agent = null;
    private int currentNestingLevel = 0;
    private int suppressAtNestingLevel = -1;
    protected boolean useAbstimeDates = false;
    protected Properties props;
    protected IPlatform platform;
    private static final String OPERATING_SYSTEM = System.getProperty("os.name").toUpperCase(Locale.ENGLISH);
    private static final boolean ZOS = OPERATING_SYSTEM.indexOf("Z/OS") > -1 || OPERATING_SYSTEM.indexOf("ZOS") > -1;

    protected LangStruct(boolean isCase, boolean useAbstimeDates) {
        this.isCaseSensitiveLanguage = isCase;
        this.useAbstimeDates = useAbstimeDates;
    }

    protected final void createICM(ICM.XMLContentType messageType, String namespace, int language, String operationName, int mappingLevel, boolean soap11, int charVaryingLimit, ICM.VaryingLength defaultCharVarying, int defaultCharMaxLen, int charMultiplier, boolean useHexFloat, int inlineMaxOccusLimit, boolean generatedForWSDL, int lang, ICMInterceptor interceptor, boolean complexChannelBased, boolean useAbstimeDates, boolean dataTruncationSupported, boolean allowsContainers, Properties inputParameters, IPlatform platform) throws CICSWSDLException {
        this.msgType = messageType;
        this.operationName = operationName;
        this.mappingLevel = mappingLevel;
        this.mappingStrategy = defaultCharVarying;
        this.useHexFloat = useHexFloat;
        this.props = inputParameters;
        this.platform = platform;
        String typeStub = null;
        switch (this.msgType) {
            case SOAP_REQUEST: {
                typeStub = "Request";
                break;
            }
            case SOAP_RESPONSE: {
                typeStub = "Response";
                break;
            }
            case XML_ELEMENT: 
            case XML_TYPE: {
                typeStub = "BottomUp";
                break;
            }
            default: {
                throw new RuntimeException("INTERNAL ERROR: unknown message type - " + (Object)((Object)this.msgType));
            }
        }
        try {
            this.builder = Factory.createICMBuilderToWSDL(language, Logging.getPrintStream());
            ICMCreationParameters parms = this.builder.getICMCreationParameters();
            parms.populateParametersObject(typeStub + "ICM", ICM.BindingStyle.WRAPPED_STYLE, new QName(namespace, operationName), this.msgType, mappingLevel, soap11, charVaryingLimit, defaultCharVarying, defaultCharMaxLen, charMultiplier, useHexFloat, inlineMaxOccusLimit, generatedForWSDL, lang, interceptor, complexChannelBased, false, useAbstimeDates, dataTruncationSupported, allowsContainers, inputParameters, 3, this.platform);
            this.icm = this.builder.createICM(parms);
        }
        catch (IOException e) {
            CICSWSDLException newEx = new CICSWSDLException("INTERNAL_ERROR: Failure processing Factory.createICMBuilderToWSDL(). " + e.getLocalizedMessage());
            newEx.initCause(e);
            throw newEx;
        }
        catch (ICMException exc) {
            CICSWSDLException newEx = this.builder.getMessages().length < 1 ? new CICSWSDLException(exc.getLocalizedMessage()) : new CICSWSDLException(this.builder.getMessages());
            newEx.initCause(exc);
            throw newEx;
        }
    }

    public final String readLangStruct(String path, String name, String structureName, String codepage, IBottomUpHelper agent, boolean usePDSFiles) throws CICSWSDLException {
        String filename = "";
        filename = !usePDSFiles ? path + File.separator + name : (path.endsWith("'") ? path.substring(0, path.length() - 1) + "(" + name + ")'" : path + "(" + name + ")");
        return this.readLangStruct(filename, structureName, codepage, agent);
    }

    public final String readLangStruct(String filename, String structureName, String codepage, IBottomUpHelper agent) throws CICSWSDLException {
        this.agent = agent;
        if (!ZOS || !filename.contains("(")) {
            this.icm = this.readLangStructFromPC(filename, structureName);
        } else {
            filename = PDSAccessor.prepareLibraryNameForJZOS(filename);
            this.icm = this.readLangStructFromPDSLib(filename, structureName, codepage);
        }
        if (Logging.getError()) {
            String msg = Logging.getWarning() ? MessageHandler.buildMessage("DFHPI9557E", new Object[]{filename}) : MessageHandler.buildMessage("DFHPI9558E", new Object[]{filename});
            CICSWSDLException newEx = new CICSWSDLException(msg, false);
            throw newEx;
        }
        if (Logging.getWarning()) {
            Logging.writeMessage(4, "DFHPI9608W", new Object[]{filename});
        }
        return filename;
    }

    protected final ICM completeICM(String filename) throws CICSWSDLException {
        try {
            this.log.println("Sending lang-struct end");
            this.callAgent(null, false, false, false, false, false, true, -1, false);
            this.icm.completedICM();
        }
        catch (IOException e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{filename, e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        catch (ICMException exc) {
            CICSWSDLException newEx = this.builder.getMessages().length < 1 ? new CICSWSDLException(exc.getLocalizedMessage()) : new CICSWSDLException(this.builder.getMessages());
            newEx.initCause(exc);
            throw newEx;
        }
        return this.icm;
    }

    protected abstract void processLangStructure(String var1, String var2, String var3) throws CICSWSDLException;

    protected abstract String preProcessLine(String var1);

    private ICM readLangStructFromPC(String filename, String structureName) throws CICSWSDLException {
        StringBuilder data = new StringBuilder();
        this.log.println(LINE_SEPARATOR + "Reading and parsing language structure: " + filename);
        this.log.println("--------------------------------------");
        BufferedReader input = null;
        try {
            String line;
            File inputFile = new File(filename);
            input = new BufferedReader(new FileReader(inputFile.getAbsoluteFile()));
            while ((line = input.readLine()) != null) {
                line = this.preProcessLine(line);
                this.log.println(">|" + line);
                data.append(line);
            }
            this.processLangStructure(data.toString(), structureName, filename);
        }
        catch (IOException e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{filename, e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace(Logging.getPrintStream());
                }
            }
        }
        return this.icm;
    }

    private ICM readLangStructFromPDSLib(String filename, String structureName, String codepage) throws CICSWSDLException {
        StringBuilder data = new StringBuilder();
        this.log.println(LINE_SEPARATOR + "Reading and parsing language structure: " + filename);
        this.log.println("--------------------------------------");
        try {
            InputStream inStream = PDSAccessor.getInputStreamForPDSMember(filename);
            byte[] bytes = new byte[2048];
            int readLen = inStream.read(bytes);
            while (readLen > -1) {
                String line;
                if (codepage != null && !codepage.equals("")) {
                    try {
                        line = new String(bytes, 0, readLen, codepage);
                    }
                    catch (UnsupportedEncodingException uee) {
                        Logging.handleExc(uee);
                        line = new String(bytes, 0, readLen);
                    }
                } else {
                    line = new String(bytes, 0, readLen);
                }
                line = this.preProcessLine(line);
                this.log.println(">|" + line);
                data.append(line);
                readLen = inStream.read(bytes);
            }
            this.processLangStructure(data.toString(), structureName, filename);
            inStream.close();
        }
        catch (NoClassDefFoundError ncdfe) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9528E", new Object[]{filename}));
            newEx.initCause(ncdfe);
            throw newEx;
        }
        catch (FileNotFoundException fnfe) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9528E", new Object[]{filename}));
            newEx.initCause(fnfe);
            throw newEx;
        }
        catch (IOException e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{filename, e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        return this.icm;
    }

    public final String ensureValidXMLString(String refID, Set<String> uniqueNameSet) {
        return LangStruct.ensureValidXML(refID, uniqueNameSet, this.isCaseSensitiveLanguage, this.msgType, this.operationName, this.mappingLevel);
    }

    public static final String ensureValidXML(String refID, Set<String> uniqueNameSet, boolean isCaseSensitive, ICM.XMLContentType msgType, String operationName, int mappingLevel) {
        StringBuilder xsdPath = new StringBuilder();
        StringTokenizer outerTokens = new StringTokenizer(refID, "/");
        while (outerTokens.hasMoreTokens()) {
            String outerToken = outerTokens.nextToken();
            while (outerToken.charAt(0) == '-') {
                outerToken = outerToken.substring(1);
            }
            while (outerToken.charAt(outerToken.length() - 1) == '-') {
                outerToken = outerToken.substring(0, outerToken.length() - 1);
            }
            if (Character.isDigit(outerToken.charAt(0))) {
                outerToken = "_" + outerToken;
            }
            if (outerTokens.hasMoreTokens()) {
                xsdPath.append(outerToken);
                xsdPath.append("/");
                continue;
            }
            xsdPath.append(outerToken);
        }
        int scanPos = 0;
        boolean upperCase = true;
        for (int i = 0; i < xsdPath.length(); ++i) {
            boolean delimiter;
            char current = xsdPath.charAt(i);
            if (current == '-') {
                xsdPath.setCharAt(i, '_');
            }
            boolean bl = delimiter = current == '-' || current == '/';
            if (Character.isLowerCase(current)) {
                upperCase = false;
            }
            if (delimiter && upperCase) {
                for (int j = scanPos; j < i; ++j) {
                    xsdPath.setCharAt(j, Character.toLowerCase(xsdPath.charAt(j)));
                }
                scanPos = i;
            } else if (delimiter) {
                upperCase = true;
                scanPos = i;
            }
            if (i == 0) {
                if (Character.isLetter(current) || current == '_') continue;
                xsdPath.setCharAt(i, 'X');
                Logging.writeMessage(4, "DFHPI9559W", new Object[]{Character.valueOf(current)});
                continue;
            }
            if (Character.isLetterOrDigit(current) || current == '.' || current == '_' || current == '-') continue;
            xsdPath.setCharAt(i, 'X');
            Logging.writeMessage(4, "DFHPI9560W", new Object[]{Character.valueOf(current)});
        }
        if (upperCase) {
            for (int j = scanPos; j < xsdPath.length(); ++j) {
                xsdPath.setCharAt(j, Character.toLowerCase(xsdPath.charAt(j)));
            }
        }
        String valid = xsdPath.toString();
        UniqueNameGenerator.UniqueName uniqueName = UniqueNameGenerator.ensureUnique(uniqueNameSet, valid, isCaseSensitive, mappingLevel, false);
        valid = uniqueName.getName();
        if (uniqueName.getNameClash()) {
            Logging.writeMessage(1, "DFHPI9561I", new Object[]{refID, operationName});
        }
        return valid;
    }

    public void addContainer(ICMInputContainerDataType containerParameters) throws CICSWSDLException {
        this.log.println("Adding container entry, " + containerParameters);
        try {
            this.icm.addContainerEntry(containerParameters);
        }
        catch (ICMException icmEx) {
            this.handleICMException(icmEx);
        }
    }

    public void addDataElementEntry(ICMInputSimpleDataType field) throws CICSWSDLException {
        this.log.println("Adding data entry, " + field);
        MappingData data = this.callAgent(field.getName(), false, false, false, false, false, false, -1, field.isSuppressed());
        try {
            field.setSuppressed(data.isSuppressed());
            field.setName(data.getName());
            this.icm.addDataElementEntry(field);
        }
        catch (ICMException icmEx) {
            this.handleICMException(icmEx);
        }
    }

    public void addFixedRepeatEntry(ICMInputArrayStartDataType arrayParms) throws CICSWSDLException {
        this.log.println("Adding fixed repeat, " + arrayParms);
        MappingData data = this.callAgent(arrayParms.getName(), false, false, false, true, false, false, arrayParms.getOccurs(), arrayParms.isSuppressed());
        arrayParms.setSuppressed(data.isSuppressed());
        arrayParms.setName(data.getName());
        try {
            this.icm.addFixedRepeatEntry(arrayParms);
            this.handleFieldSuppressionStart(data);
        }
        catch (ICMException icmEx) {
            this.handleICMException(icmEx);
        }
    }

    public void addEndRepeatEntry(ICMInputArrayEndDataType parms) throws CICSWSDLException {
        this.log.println("Adding endrepeat");
        MappingData data = this.callAgent(null, false, false, false, false, true, false, -1, false);
        parms.setSuppressed(data.isSuppressed());
        try {
            this.icm.addEndRepeatEntry(parms);
            this.handleFieldSuppressionEnd(data);
        }
        catch (ICMException icmEx) {
            this.handleICMException(icmEx);
        }
    }

    public void sendStructStart(ICMInputStructureStartDataType strucStart) throws CICSWSDLException {
        this.log.println("Sending struct start " + strucStart.getName());
        MappingData data = this.callAgent(strucStart.getName(), false, true, false, false, false, false, -1, strucStart.isSuppressed());
        strucStart.setSuppressed(data.isSuppressed());
        strucStart.setName(data.getName());
        try {
            this.icm.sendStructStart(strucStart);
            this.handleFieldSuppressionStart(data);
        }
        catch (ICMException icmEx) {
            this.handleICMException(icmEx);
        }
    }

    public void sendStructEnd(ICMInputStructureEndDataType structEnd) throws CICSWSDLException {
        this.log.println("Sending struct end");
        MappingData data = this.callAgent(null, false, false, true, false, false, false, -1, false);
        structEnd.setSuppressed(data.isSuppressed());
        try {
            this.icm.sendStructEnd(structEnd);
            this.handleFieldSuppressionEnd(data);
        }
        catch (ICMException icmEx) {
            this.handleICMException(icmEx);
        }
    }

    public String[] getMessages() {
        return this.icm.getMessages();
    }

    public void handleICMException(ICMException e) throws CICSWSDLException {
        if (!Logging.getError()) {
            CICSWSDLException newEx = this.getMessages().length < 1 ? new CICSWSDLException(e.getLocalizedMessage()) : new CICSWSDLException(this.getMessages());
            newEx.initCause(e);
            throw newEx;
        }
        Logging.handleExc(e);
    }

    private MappingData callAgent(String fieldName, boolean suppressed, boolean structural, boolean endOfStructure, boolean array, boolean endOfArray, boolean endOfEntireStructure, int occurence, boolean filler) {
        MappingData data = new MappingData(fieldName, suppressed, structural, endOfStructure, array, endOfArray, endOfEntireStructure, occurence, filler);
        if (this.agent != null) {
            this.agent.processField(data);
        }
        if (this.suppressAtNestingLevel != -1 && this.currentNestingLevel >= this.suppressAtNestingLevel) {
            data.setSuppressed(true);
        }
        return data;
    }

    private void handleFieldSuppressionStart(MappingData data) {
        ++this.currentNestingLevel;
        if (data.isSuppressed() && this.suppressAtNestingLevel == -1) {
            this.suppressAtNestingLevel = this.currentNestingLevel;
        }
    }

    private void handleFieldSuppressionEnd(MappingData data) {
        if (this.suppressAtNestingLevel == this.currentNestingLevel) {
            this.suppressAtNestingLevel = -1;
        }
        --this.currentNestingLevel;
    }
}

