/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ls2ws;

import com.ibm.cics.gen.api.IDFHLS2JSHelper;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.ls2ws.CustomMappedNamespaceConvention;
import com.ibm.cics.wsdl.ls2ws.CustomMappedXMLStreamWriter;
import com.ibm.cics.wsdl.ls2ws.XSDNamespaceContext;
import com.ibm.cics.wsdl.ls2ws.ls2ws;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.codehaus.jettison.AbstractXMLStreamWriter;
import org.codehaus.jettison.mapped.Configuration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ls2js
extends ls2ws
implements IDFHLS2JSHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2013, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Writer schemaWriterRequest = null;
    private Writer schemaWriterResponse = null;
    private Writer schemaStringWriterRequest = null;
    private Writer schemaStringWriterResponse = null;
    private AbstractXMLStreamWriter mappedSchemaWriterRequest = null;
    private AbstractXMLStreamWriter mappedSchemaWriterResponse = null;
    private File jsonRequestFile;
    private File jsonResponseFile;
    private static XPath xPath = XPathFactory.newInstance().newXPath();
    private static XPathExpression interfaceElementsExpression;
    private static XPathExpression cddElementsExpression;
    private static XPathExpression parameterNameExpression;
    private static XPathExpression simpleTypeExpression;
    private static XPathExpression complexTypeTypeExpression;
    private static XPathExpression minOccursExpression;
    private static XPathExpression maxOccursExpression;
    private static XPathExpression complexSequenceParametersExpression;
    private static XPathExpression structuredContainerSequenceParametersExpression;
    private static XPathExpression parameterBaseExpression;
    private static XPathExpression parameterLengthExpression;
    private static XPathExpression parameterMaxLengthExpression;
    private static XPathExpression parameterMinLengthExpression;
    private static XPathExpression parameterMaximumExpression;
    private static XPathExpression parameterMinimumExpression;
    private static XPathExpression parameterTotalDigitsExpression;
    private static XPathExpression parameterFractionDigitsExpression;
    private static XPathExpression charContainerExpression;
    private static XPathExpression bitContainerExpression;
    private static XPathExpression structContainerExpression;

    @Override
    public void run(String[] args) {
        this.commonExecute(args, 4, this.timestamp);
    }

    public static void main(String[] args) {
        ls2js me = new ls2js();
        me.run(args);
    }

    @Override
    public boolean setUp(int rc, String[] args, int direction, Date timestamp) throws CICSWSDLException {
        super.setUp(rc, args, direction, timestamp);
        return this.handleJSONAPIDelegation(args);
    }

    @Override
    public void generateWSDL(ICM requestICM, ICM responseICM, String cicsPgm, String uniqueReq, String operationName, String soapVer) throws CICSWSDLException {
        String requestFileName = this.p.getProperty("JSON-SCHEMA-REQUEST");
        String responseFileName = this.p.getProperty("JSON-SCHEMA-RESPONSE");
        String jsonCodepage = this.p.getProperty("JSON-SCHEMA-CODEPAGE");
        this.jsonRequestFile = ls2js.InitialiseJSONSchemaFile(requestFileName);
        this.jsonResponseFile = ls2js.InitialiseJSONSchemaFile(responseFileName);
        this.schemaWriterRequest = ls2js.OpenJSONSChemaFile(this.jsonRequestFile, jsonCodepage);
        this.schemaWriterResponse = ls2js.OpenJSONSChemaFile(this.jsonResponseFile, jsonCodepage);
        this.schemaStringWriterRequest = new StringWriter();
        this.schemaStringWriterResponse = new StringWriter();
        this.mappedSchemaWriterRequest = ls2js.generateJSON(this.schemaStringWriterRequest, cicsPgm, requestICM, requestFileName, operationName, "Request", this.mappingLevel);
        this.mappedSchemaWriterResponse = ls2js.generateJSON(this.schemaStringWriterResponse, cicsPgm, responseICM, responseFileName, operationName + "Response", "Response", this.mappingLevel);
    }

    public static File InitialiseJSONSchemaFile(String fileName) throws CICSWSDLException {
        File jsonSchemaFile = Util.confirmFileForOutput(fileName);
        return jsonSchemaFile;
    }

    public static Writer OpenJSONSChemaFile(File jsonFile, String codepage) throws CICSWSDLException {
        try {
            FileOutputStream fos = new FileOutputStream(jsonFile);
            Charset targetEncoding = null;
            if ("EBCDIC-CP-US".equals(codepage)) {
                targetEncoding = Charset.forName("Cp037");
            } else if ("UTF-8".equals(codepage)) {
                targetEncoding = Charset.forName("UTF-8");
            }
            OutputStreamWriter osw = targetEncoding != null ? new OutputStreamWriter((OutputStream)fos, targetEncoding.newEncoder()) : new OutputStreamWriter(fos);
            return osw;
        }
        catch (IOException e) {
            CICSWSDLException ex1 = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9556E", new Object[]{jsonFile.getName(), e.getMessage()}));
            ex1.initCause(e);
            throw ex1;
        }
    }

    public static AbstractXMLStreamWriter generateJSON(Writer jsonFileWriter, String name, ICM icm, String fileName, String entryPointName, String direction, int mappingLevel) throws CICSWSDLException {
        CustomMappedNamespaceConvention converterRequest = new CustomMappedNamespaceConvention(new Configuration());
        CustomMappedXMLStreamWriter mappedSchemaWriter = new CustomMappedXMLStreamWriter(converterRequest, jsonFileWriter);
        ls2js.createJSON((AbstractXMLStreamWriter)mappedSchemaWriter, converterRequest, name, direction, icm, fileName, entryPointName, mappingLevel);
        return mappedSchemaWriter;
    }

    private static void createJSON(AbstractXMLStreamWriter mappedSchemaWriter, CustomMappedNamespaceConvention converter, String name, String direction, ICM icm, String fileName, String operationName, int mappingLevel) throws CICSWSDLException {
        try {
            mappedSchemaWriter.writeStartDocument();
            mappedSchemaWriter.writeStartElement("$schema");
            if (MappingLevelHelper.supportsMappingLevel_5_0(mappingLevel)) {
                mappedSchemaWriter.writeCharacters("https://json-schema.org/draft/2020-12/schema");
            } else {
                mappedSchemaWriter.writeCharacters("http://json-schema.org/draft-04/schema#");
            }
            mappedSchemaWriter.writeEndElement();
            mappedSchemaWriter.writeStartElement("description");
            mappedSchemaWriter.writeCharacters(direction + " schema for the " + name + " JSON interface");
            mappedSchemaWriter.writeEndElement();
            mappedSchemaWriter.writeStartElement("type");
            mappedSchemaWriter.writeCharacters("object");
            mappedSchemaWriter.writeEndElement();
            mappedSchemaWriter.writeStartElement("properties");
            if (icm != null) {
                NodeList parameters2;
                mappedSchemaWriter.writeStartElement(operationName);
                mappedSchemaWriter.writeStartElement("type");
                mappedSchemaWriter.writeCharacters("object");
                mappedSchemaWriter.writeEndElement();
                mappedSchemaWriter.writeStartElement("properties");
                XPath xPath = XPathFactory.newInstance().newXPath();
                xPath.setNamespaceContext(new XSDNamespaceContext());
                Element xml = icm.toXMLElement();
                NodeList parameters = (NodeList)interfaceElementsExpression.evaluate(xml, XPathConstants.NODESET);
                if (parameters.getLength() == 0 && (parameters2 = (NodeList)cddElementsExpression.evaluate(xml, XPathConstants.NODESET)).getLength() > 0) {
                    parameters = parameters2;
                }
                List<String> childParameters = ls2js.convertNodeList(mappedSchemaWriter, converter, parameters, mappingLevel);
                mappedSchemaWriter.writeEndElement();
                for (String requiredParameter : childParameters) {
                    mappedSchemaWriter.writeStartElement("required");
                    mappedSchemaWriter.writeCharacters(requiredParameter);
                    mappedSchemaWriter.writeEndElement();
                }
                mappedSchemaWriter.writeEndElement();
                mappedSchemaWriter.writeEndElement();
                mappedSchemaWriter.writeStartElement("required");
                mappedSchemaWriter.writeCharacters(operationName);
                mappedSchemaWriter.writeEndElement();
            } else {
                converter.literalNext();
                mappedSchemaWriter.writeCharacters("{}");
                mappedSchemaWriter.writeEndElement();
            }
            mappedSchemaWriter.writeEndDocument();
        }
        catch (XMLStreamException e) {
            CICSWSDLException ex1 = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9556E", new Object[]{fileName, e.getMessage()}));
            ex1.initCause(e);
            throw ex1;
        }
        catch (XPathExpressionException e) {
            CICSWSDLException ex1 = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9556E", new Object[]{fileName, e.getMessage()}));
            ex1.initCause(e);
            throw ex1;
        }
        catch (ICMException e) {
            CICSWSDLException ex1 = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9556E", new Object[]{fileName, e.getMessage()}));
            ex1.initCause(e);
            throw ex1;
        }
    }

    public static void CloseJSON(AbstractXMLStreamWriter jsonWriter, Writer writer, String jsonString, File jsonFile) throws IOException {
        if (jsonWriter != null) {
            try {
                jsonWriter.close();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        if (writer != null) {
            if (jsonString != null) {
                ls2js.FormatJSONFile(writer, jsonString, jsonFile);
            }
            writer.close();
        }
    }

    public static void FormatJSONFile(Writer writer, String jsonString, File jsonFile) throws IOException {
        PrintStream log = Logging.getPrintStream();
        log.println();
        log.println("Generated JSON Schema: " + jsonFile.getAbsolutePath());
        log.println("----------------------");
        String INDENT = "   ";
        char[] jsonChars = jsonString.toCharArray();
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        boolean notInString = true;
        boolean unescapedChar = true;
        int indents = 0;
        for (char currentChar : jsonChars) {
            int i;
            if (notInString && (currentChar == '}' || currentChar == ']')) {
                ls2js.appendNewlineToFile(bufferedWriter, log);
                --indents;
                for (i = 0; i < indents; ++i) {
                    ls2js.appendToFile(bufferedWriter, "   ", log);
                }
                ls2js.appendToFile(bufferedWriter, currentChar, log);
                continue;
            }
            ls2js.appendToFile(bufferedWriter, currentChar, log);
            if (notInString && (currentChar == '{' || currentChar == '[' || currentChar == ',')) {
                ls2js.appendNewlineToFile(bufferedWriter, log);
                if (currentChar == '{' || currentChar == '[') {
                    ++indents;
                }
                for (i = 0; i < indents; ++i) {
                    ls2js.appendToFile(bufferedWriter, "   ", log);
                }
                continue;
            }
            if (currentChar == '\"' && unescapedChar) {
                notInString = !notInString;
                continue;
            }
            unescapedChar = currentChar != '\\' || !unescapedChar;
        }
        log.println();
        bufferedWriter.close();
    }

    private static void appendNewlineToFile(BufferedWriter bufferedWriter, PrintStream log) throws IOException {
        bufferedWriter.newLine();
        log.println();
    }

    private static void appendToFile(BufferedWriter bufferedWriter, String characters, PrintStream log) throws IOException {
        bufferedWriter.append(characters);
        log.print(characters);
    }

    private static void appendToFile(BufferedWriter bufferedWriter, char currentChar, PrintStream log) throws IOException {
        bufferedWriter.append(currentChar);
        log.print(currentChar);
    }

    @Override
    public void saveWSDL() throws IOException {
        ls2js.CloseJSON(this.mappedSchemaWriterRequest, this.schemaWriterRequest, this.schemaStringWriterRequest.toString(), this.jsonRequestFile);
        ls2js.CloseJSON(this.mappedSchemaWriterResponse, this.schemaWriterResponse, this.schemaStringWriterResponse.toString(), this.jsonResponseFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> convertNodeList(AbstractXMLStreamWriter writer, CustomMappedNamespaceConvention converter, NodeList nodes, int mappingLevel) throws XPathExpressionException, XMLStreamException {
        ArrayList<String> parameters = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            node.getParentNode().removeChild(node);
            String parameterName = parameterNameExpression.evaluate(node);
            String minOccurs = minOccursExpression.evaluate(node);
            if (!minOccurs.equals("0")) {
                parameters.add(parameterName);
            }
            writer.writeStartElement(parameterName);
            writer.writeStartElement("type");
            if (ls2js.isArray(node)) {
                writer.writeCharacters("array");
                writer.writeEndElement();
                writer.writeStartElement("maxItems");
                writer.writeCharacters(maxOccursExpression.evaluate(node));
                writer.writeEndElement();
                writer.writeStartElement("minItems");
                writer.writeCharacters(minOccursExpression.evaluate(node));
                writer.writeEndElement();
                writer.writeStartElement("items");
                writer.writeStartElement("type");
            }
            if (complexTypeTypeExpression.evaluate(node, XPathConstants.NODE) != null) {
                if (charContainerExpression.evaluate(node, XPathConstants.NODE) != null) {
                    writer.writeCharacters("string");
                    writer.writeEndElement();
                } else if (bitContainerExpression.evaluate(node, XPathConstants.NODE) != null) {
                    writer.writeCharacters("string");
                    writer.writeEndElement();
                    if (MappingLevelHelper.supportsMappingLevel_5_0(mappingLevel)) {
                        writer.writeStartElement("contentEncoding");
                        writer.writeCharacters("base64");
                    } else {
                        writer.writeStartElement("format");
                        writer.writeCharacters("base64Binary");
                    }
                    writer.writeEndElement();
                } else {
                    XPathExpression structureContents = complexSequenceParametersExpression;
                    if (structContainerExpression.evaluate(node, XPathConstants.NODE) != null) {
                        structureContents = structuredContainerSequenceParametersExpression;
                    }
                    writer.writeCharacters("object");
                    writer.writeEndElement();
                    writer.writeStartElement("properties");
                    List<String> childParameters = ls2js.convertNodeList(writer, converter, (NodeList)structureContents.evaluate(node, XPathConstants.NODESET), mappingLevel);
                    writer.writeEndElement();
                    for (String requiredParameter : childParameters) {
                        writer.writeStartElement("required");
                        writer.writeCharacters(requiredParameter);
                        writer.writeEndElement();
                    }
                }
            } else {
                String parameterMinimum;
                String parameterMaximum;
                if (simpleTypeExpression.evaluate(node, XPathConstants.NODE) == null) throw new RuntimeException("Unknown child");
                String parameterBase = parameterBaseExpression.evaluate(node).toLowerCase();
                if ("xsd:string".equals(parameterBase)) {
                    String parameterMinLength;
                    writer.writeCharacters("string");
                    writer.writeEndElement();
                    String parameterMaxLength = parameterMaxLengthExpression.evaluate(node);
                    if (parameterMaxLength.length() != 0) {
                        writer.writeStartElement("maxLength");
                        writer.writeCharacters(parameterMaxLength);
                        writer.writeEndElement();
                    }
                    if ((parameterMinLength = parameterMinLengthExpression.evaluate(node)).length() != 0) {
                        writer.writeStartElement("minLength");
                        writer.writeCharacters(parameterMinLength);
                        writer.writeEndElement();
                    }
                } else if ("xsd:boolean".equals(parameterBase)) {
                    writer.writeCharacters("boolean");
                    writer.writeEndElement();
                } else if ("xsd:datetime".equals(parameterBase)) {
                    writer.writeCharacters("string");
                    writer.writeEndElement();
                    writer.writeStartElement("format");
                    writer.writeCharacters("date-time");
                    writer.writeEndElement();
                } else if ("xsd:byte".equals(parameterBase) || "xsd:short".equals(parameterBase) || "xsd:int".equals(parameterBase) || "xsd:long".equals(parameterBase)) {
                    writer.writeCharacters("integer");
                    writer.writeEndElement();
                    parameterMaximum = parameterMaximumExpression.evaluate(node);
                    parameterMinimum = parameterMinimumExpression.evaluate(node);
                    if (parameterMaximum.length() == 0) {
                        if ("xsd:byte".equals(parameterBase)) {
                            parameterMaximum = "127";
                        } else if ("xsd:short".equals(parameterBase)) {
                            parameterMaximum = "32767";
                        } else if ("xsd:int".equals(parameterBase)) {
                            parameterMaximum = "2147483647";
                        } else if ("xsd:long".equals(parameterBase)) {
                            parameterMaximum = "9223372036854775807";
                        }
                    }
                    if (parameterMinimum.length() == 0) {
                        if ("xsd:byte".equals(parameterBase)) {
                            parameterMinimum = "-128";
                        } else if ("xsd:short".equals(parameterBase)) {
                            parameterMinimum = "-32768";
                        } else if ("xsd:int".equals(parameterBase)) {
                            parameterMinimum = "-2147483648";
                        } else if ("xsd:long".equals(parameterBase)) {
                            parameterMinimum = "-9223372036854775808";
                        }
                    }
                    if ("xsd:long".equals(parameterBase)) {
                        try {
                            Long.parseLong(parameterMaximum);
                        }
                        catch (NumberFormatException exc) {
                            converter.literalNext();
                        }
                    }
                    writer.writeStartElement("maximum");
                    writer.writeCharacters(parameterMaximum);
                    writer.writeEndElement();
                    if ("xsd:long".equals(parameterBase)) {
                        try {
                            Long.parseLong(parameterMinimum);
                        }
                        catch (NumberFormatException exc) {
                            converter.literalNext();
                        }
                    }
                    writer.writeStartElement("minimum");
                    writer.writeCharacters(parameterMinimum);
                    writer.writeEndElement();
                } else if ("xsd:unsignedbyte".equals(parameterBase) || "xsd:unsignedshort".equals(parameterBase) || "xsd:unsignedint".equals(parameterBase) || "xsd:unsignedlong".equals(parameterBase)) {
                    writer.writeCharacters("integer");
                    writer.writeEndElement();
                    parameterMaximum = parameterMaximumExpression.evaluate(node);
                    if (parameterMaximum.length() == 0) {
                        if ("xsd:unsignedbyte".equals(parameterBase)) {
                            parameterMaximum = "255";
                        } else if ("xsd:unsignedshort".equals(parameterBase)) {
                            parameterMaximum = "65535";
                        } else if ("xsd:unsignedint".equals(parameterBase)) {
                            parameterMaximum = "4294967295";
                        } else if ("xsd:unsignedlong".equals(parameterBase)) {
                            parameterMaximum = "18446744073709551615";
                        }
                    }
                    if ("xsd:unsignedlong".equals(parameterBase)) {
                        try {
                            Long.parseLong(parameterMaximum);
                        }
                        catch (NumberFormatException exc) {
                            converter.literalNext();
                        }
                    }
                    writer.writeStartElement("maximum");
                    writer.writeCharacters(parameterMaximum);
                    writer.writeEndElement();
                    writer.writeStartElement("minimum");
                    writer.writeCharacters("0");
                    writer.writeEndElement();
                } else if ("xsd:decimal".equals(parameterBase) || "xsd:float".equals(parameterBase) || "xsd:double".equals(parameterBase)) {
                    writer.writeCharacters("number");
                    writer.writeEndElement();
                    writer.writeStartElement("format");
                    if ("xsd:decimal".equals(parameterBase)) {
                        writer.writeCharacters("decimal");
                    } else if ("xsd:float".equals(parameterBase)) {
                        writer.writeCharacters("float");
                    } else if ("xsd:double".equals(parameterBase)) {
                        writer.writeCharacters("double");
                    }
                    writer.writeEndElement();
                    parameterMaximum = parameterMaximumExpression.evaluate(node);
                    parameterMinimum = parameterMinimumExpression.evaluate(node);
                    String parameterTotalDigits = parameterTotalDigitsExpression.evaluate(node);
                    String parameterFractionDigits = parameterFractionDigitsExpression.evaluate(node);
                    StringBuilder maximum = new StringBuilder();
                    if (parameterFractionDigits.length() != 0) {
                        int fractionDigits = Integer.parseInt(parameterFractionDigits);
                        converter.literalNext();
                        writer.writeStartElement("multipleOf");
                        if (fractionDigits > 0) {
                            writer.writeCharacters("0.");
                            for (int digit = 1; digit < fractionDigits; ++digit) {
                                writer.writeCharacters("0");
                            }
                        }
                        writer.writeCharacters("1");
                        writer.writeEndElement();
                        if (parameterTotalDigits.length() != 0) {
                            int totalDigits = Integer.parseInt(parameterTotalDigits);
                            if (totalDigits == fractionDigits) {
                                maximum.append("0");
                            }
                            for (int digit = 0; digit < totalDigits; ++digit) {
                                if (digit == totalDigits - fractionDigits) {
                                    maximum.append(".");
                                }
                                maximum.append("9");
                            }
                        }
                    }
                    if (parameterMaximum.length() != 0) {
                        converter.literalNext();
                        writer.writeStartElement("maximum");
                        writer.writeCharacters(parameterMaximum);
                        writer.writeEndElement();
                    } else if (maximum.length() != 0) {
                        converter.literalNext();
                        writer.writeStartElement("maximum");
                        writer.writeCharacters(maximum.toString());
                        writer.writeEndElement();
                    }
                    if (parameterMinimum.length() != 0) {
                        converter.literalNext();
                        writer.writeStartElement("minimum");
                        writer.writeCharacters(parameterMinimum);
                        writer.writeEndElement();
                    } else if (maximum.length() != 0) {
                        converter.literalNext();
                        writer.writeStartElement("minimum");
                        writer.writeCharacters("-");
                        writer.writeCharacters(maximum.toString());
                        writer.writeEndElement();
                    }
                } else {
                    if (!"xsd:base64binary".equals(parameterBase) && !"xsd:hexbinary".equals(parameterBase)) throw new RuntimeException("Unknown simpleType base");
                    writer.writeCharacters("string");
                    writer.writeEndElement();
                    if ("xsd:base64binary".equals(parameterBase)) {
                        if (MappingLevelHelper.supportsMappingLevel_5_0(mappingLevel)) {
                            writer.writeStartElement("contentEncoding");
                            writer.writeCharacters("base64");
                        } else {
                            writer.writeStartElement("format");
                            writer.writeCharacters("base64Binary");
                        }
                        writer.writeEndElement();
                    } else if ("xsd:hexbinary".equals(parameterBase)) {
                        if (MappingLevelHelper.supportsMappingLevel_5_0(mappingLevel)) {
                            writer.writeStartElement("contentEncoding");
                            writer.writeCharacters("binary");
                        } else {
                            writer.writeStartElement("format");
                            writer.writeCharacters("hexBinary");
                        }
                        writer.writeEndElement();
                    }
                    String parameterLength = parameterLengthExpression.evaluate(node);
                    if (parameterLength.length() != 0) {
                        writer.writeStartElement("maxLength");
                        writer.writeCharacters(parameterLength);
                        writer.writeEndElement();
                        writer.writeStartElement("minLength");
                        writer.writeCharacters(parameterLength);
                        writer.writeEndElement();
                    }
                }
            }
            if (ls2js.isArray(node)) {
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        return parameters;
    }

    private static boolean isArray(Node node) throws XPathExpressionException {
        String maxOccurs = maxOccursExpression.evaluate(node);
        return maxOccurs.length() > 0 && Integer.parseInt(maxOccurs) > 1;
    }

    static {
        xPath.setNamespaceContext(new XSDNamespaceContext());
        try {
            interfaceElementsExpression = xPath.compile("xsd:complexType[@name='ProgramInterface']/xsd:sequence/xsd:element");
            cddElementsExpression = xPath.compile("xsd:complexType[@name='ProgramInterface']/xsd:complexContent/xsd:extension/xsd:sequence/xsd:element");
            parameterNameExpression = xPath.compile("@name");
            simpleTypeExpression = xPath.compile("./xsd:simpleType");
            complexTypeTypeExpression = xPath.compile("./xsd:complexType");
            charContainerExpression = xPath.compile("./xsd:complexType/xsd:complexContent/xsd:extension[@base='cics:charContainerTypeWithAttribute']");
            bitContainerExpression = xPath.compile("./xsd:complexType/xsd:complexContent/xsd:extension[@base='cics:bitContainerTypeWithAttribute']");
            structContainerExpression = xPath.compile("./xsd:complexType/xsd:complexContent/xsd:extension[@base='cics:structuredContainerTypeWithAttribute']");
            minOccursExpression = xPath.compile("@minOccurs");
            maxOccursExpression = xPath.compile("@maxOccurs");
            complexSequenceParametersExpression = xPath.compile("./xsd:complexType/xsd:sequence/xsd:element");
            structuredContainerSequenceParametersExpression = xPath.compile("./xsd:complexType/xsd:complexContent/xsd:extension/xsd:sequence/xsd:element");
            parameterBaseExpression = xPath.compile("./xsd:simpleType/xsd:restriction/@base");
            parameterLengthExpression = xPath.compile("./xsd:simpleType/xsd:restriction/xsd:length/@value");
            parameterMaxLengthExpression = xPath.compile("./xsd:simpleType/xsd:restriction/xsd:maxLength/@value");
            parameterMinLengthExpression = xPath.compile("./xsd:simpleType/xsd:restriction/xsd:minLength/@value");
            parameterMaximumExpression = xPath.compile("./xsd:simpleType/xsd:restriction/xsd:maxInclusive/@value");
            parameterMinimumExpression = xPath.compile("./xsd:simpleType/xsd:restriction/xsd:minInclusive/@value");
            parameterTotalDigitsExpression = xPath.compile("./xsd:simpleType/xsd:restriction/xsd:totalDigits/@value");
            parameterFractionDigitsExpression = xPath.compile("./xsd:simpleType/xsd:restriction/xsd:fractionDigits/@value");
            if (System.getProperty("org.apache.xml.dtm.DTMManager") == null) {
                System.setProperty("org.apache.xml.dtm.DTMManager", "org.apache.xml.dtm.ref.DTMManagerDefault");
            }
        }
        catch (XPathExpressionException exc) {
            throw new RuntimeException(exc);
        }
    }
}

