/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ls2ws;

import com.ibm.cics.gen.api.IDFHLS2SCHelper;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.util.CodePageHelper;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.RuntimeLevelHelper;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.GenericSetup;
import com.ibm.cics.wsdl.common.XSDBind;
import com.ibm.cics.wsdl.ls2ws.GeneratedXML;
import com.ibm.cics.wsdl.ls2ws.LangStruct;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.xml.namespace.QName;

public class ls2sc
extends GenericSetup
implements IDFHLS2SCHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    protected IDFHLS2SCHelper agent = null;

    public void setAgent(IDFHLS2SCHelper agent) {
        this.agent = agent;
    }

    @Override
    public void run(String[] args) {
        this.commonExecute(args, 3, this.timestamp);
    }

    public static void main(String[] args) {
        ls2sc me = new ls2sc();
        me.run(args);
    }

    @Override
    public final void doAssistantSpecificProcessing() throws CICSWSDLException {
        String pdslib = this.p.getProperty("PDSLIB");
        String pdsmem = this.p.getProperty("PDSMEM");
        String stub = this.getFileNameStub(pdsmem, false);
        if (MappingLevelHelper.supportsMappingLevel_2_1(this.mappingLevel) && this.agent == null) {
            this.agent = this;
        }
        LangStruct ls = this.getLangStruct(this.lang);
        String namespace = this.p.getProperty("NAMESPACE", "http://www." + stub + ".com");
        ls.createICM(ICM.XMLContentType.XML_ELEMENT, namespace, this.lang, stub, this.mappingLevel, true, this.charVaryingLimit, this.charVarying, this.defaultCharMaxlength, this.charMultiplier, this.useHexFloat, this.inlineMaxOccursLimit, false, this.lang, this.interceptor, false, this.useAbstimeDates, this.dataTruncationSupported, this.allowsContainers, this.p, this.platform);
        String filename = ls.readLangStruct(pdslib, pdsmem, this.p.getProperty("REQUEST_STRUCT"), this.p.getProperty("PDSCP"), this.agent, this.usePDSFiles());
        if (this.p.containsKey("UTF-16")) {
            CodePageHelper.setCurrentCodePage(CodePageHelper.UTF_16BE_CHARSET);
        }
        ICM icm = ls.completeICM(filename);
        LinkedList<ICM> elementICMs = new LinkedList<ICM>();
        elementICMs.add(icm);
        LinkedList<QName> elementQNames = new LinkedList<QName>();
        elementQNames.add(new QName(namespace, stub));
        XSDBind xsdbind = this.initBindFile();
        try {
            String altCcsid;
            String ccsid;
            File schema = this.generateSchema(icm, stub);
            if (this.p.containsKey("UTF-16")) {
                ccsid = Integer.toString(1200);
                altCcsid = this.p.getProperty("CCSID");
            } else {
                ccsid = this.p.getProperty("CCSID");
                altCcsid = null;
            }
            xsdbind.buildXSDBindFile(this.getBindFileName(), new File(this.getSchemaFileName()).getName(), RuntimeLevelHelper.WSBindMajorVerToRuntimeStr(this.checker.getWSBindVerNumber()), this.timestamp, ccsid, altCcsid, elementQNames, elementICMs, null, null, ICM.MAPPING_LEVELS[this.mappingLevel], this.p.getProperty("BUNDLE"), schema, null, null);
        }
        catch (Exception e) {
            CICSWSDLException newEx = new CICSWSDLException(e.getLocalizedMessage());
            newEx.initCause(e);
            throw newEx;
        }
    }

    public File generateSchema(ICM icm, String shortName) throws CICSWSDLException, IOException {
        GeneratedXML xmlGen = new GeneratedXML(this.isUTF8RequiredForXML("XMLCP"), this.isUsEBCDICRequiredForXML("XMLCP"), this.checker.getWSDLEncodingRequired());
        return xmlGen.generateXMLSchema(icm, this.getSchemaFileName());
    }

    public String getBindFileName() {
        return this.p.getProperty("XSDBIND");
    }

    public XSDBind initBindFile() {
        return new XSDBind(this.isUTF8RequiredForXML("XMLCP"), this.isUsEBCDICRequiredForXML("XMLCP"), this.checker.getWSDLEncodingRequired());
    }

    public String getSchemaFileName() {
        return this.p.getProperty("SCHEMA");
    }

    @Override
    public String getFileName() {
        return null;
    }
}

