/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ls2ws;

import com.ibm.cics.gen.api.IDFHLS2WSHelper;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMInputContainerDataType;
import com.ibm.cics.schema.ICMInputStructureStartDataType;
import com.ibm.cics.schema.impl.Factory;
import com.ibm.cics.schema.util.CodePageHelper;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.schema.utils.RuntimeLevelHelper;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.GenericSetup;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.WSBind;
import com.ibm.cics.wsdl.common.WSBindOperationEntry;
import com.ibm.cics.wsdl.ls2ws.ChannelDescReader;
import com.ibm.cics.wsdl.ls2ws.GeneratedWSDL;
import com.ibm.cics.wsdl.ls2ws.LangStruct;
import com.ibm.cics.wsdl.ws2ls.WSAddressingFault;
import com.ibm.xmlns.prod.cics.channel.Channel;
import com.ibm.xmlns.prod.cics.channel.TypeType;
import com.ibm.xmlns.prod.cics.channel.UseType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;

public class ls2ws
extends GenericSetup
implements IDFHLS2WSHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final long MAX_COMMAREA_SIZE = 32767L;
    protected IDFHLS2WSHelper agent = null;
    private String requestChannelName = null;
    private String responseChannelName = null;
    private static final String CALCULATED_ACTION = "C";
    private int wsdlVer = 0;
    private GeneratedWSDL wsdl_1_1 = null;
    private GeneratedWSDL wsdl_2_0 = null;
    private String wsdl_1_1_filename = null;
    private String wsdl_2_0_filename = null;

    public void setAgent(IDFHLS2WSHelper agent) {
        this.agent = agent;
    }

    @Override
    public void run(String[] args) {
        this.commonExecute(args, 1, this.timestamp);
    }

    public static void main(String[] args) {
        ls2ws me = new ls2ws();
        me.run(args);
    }

    private String processSimpleInput(String memberName, LangStruct ls, String pdslib, String structureProperty) throws CICSWSDLException {
        String filename = "not specified";
        if (memberName != null) {
            filename = ls.readLangStruct(pdslib, memberName, this.p.getProperty(structureProperty), this.p.getProperty("PDSCP"), this.agent, this.usePDSFiles());
        }
        return filename;
    }

    private ICM processLanguageStructure(String cicsPgm, String uniqueName, String operationName, boolean SOAP_1_1, String pdslib, String memberName, ICM.XMLContentType messageType) throws CICSWSDLException {
        LangStruct ls = this.getLangStruct(this.lang);
        String namespaceSuffix = "Request.com";
        String namespaceProperty = "REQUEST-NAMESPACE";
        String structureProperty = "REQUEST_STRUCT";
        String channelFileProperty = "REQUEST-CHANNEL";
        if (messageType.equals((Object)ICM.XMLContentType.SOAP_RESPONSE)) {
            namespaceSuffix = "Response.com";
            namespaceProperty = "RESPONSE-NAMESPACE";
            structureProperty = "RESPONSE_STRUCT";
            channelFileProperty = "RESPONSE-CHANNEL";
        }
        String namespace = this.p.getProperty(namespaceProperty, "http://www." + cicsPgm + "." + uniqueName + namespaceSuffix);
        String filename = this.p.getProperty(channelFileProperty);
        Channel channelDesc = null;
        ls.createICM(messageType, namespace, this.lang, operationName, this.mappingLevel, SOAP_1_1, this.charVaryingLimit, this.charVarying, this.defaultCharMaxlength, this.charMultiplier, this.useHexFloat, this.inlineMaxOccursLimit, true, this.lang, this.interceptor, filename != null, this.useAbstimeDates, this.dataTruncationSupported, this.allowsContainers, this.p, this.platform);
        if (filename != null) {
            channelDesc = ChannelDescReader.readChannelDescriptionFile(filename);
            if (messageType.equals((Object)ICM.XMLContentType.SOAP_REQUEST)) {
                this.requestChannelName = channelDesc.getName();
            } else {
                this.responseChannelName = channelDesc.getName();
            }
            if (channelDesc.getContainer() != null) {
                for (Channel.Container cont : channelDesc.getContainer()) {
                    ICMInputContainerDataType container;
                    if (cont.getName().toUpperCase(Locale.ENGLISH).startsWith("DFH")) {
                        Logging.writeMessage(4, "DFHPI9682W", new Object[]{cont.getName()});
                    }
                    if (cont.getType() == TypeType.CHAR) {
                        container = Factory.createICMContainerDataType(cont.getName(), ICM.ContainerDataType.CONT_TYPE_TEXT, ICM.ContainerUsage.CONT_USE_OPTIONAL);
                        if (cont.getUse() == UseType.REQUIRED) {
                            container.setUsage(ICM.ContainerUsage.CONT_USE_REQUIRED);
                        }
                        ls.addContainer(container);
                        if (cont.getStructure() == null) continue;
                        Logging.writeMessage(4, "DFHPI9686W", new Object[]{cont.getStructure().getLocation(), cont.getName()});
                        continue;
                    }
                    if (cont.getStructure() != null) {
                        ICM.StructureType structureType = ICM.StructureType.STRUCTURE_CONTAINER;
                        if (cont.getUse() == UseType.OPTIONAL) {
                            structureType = ICM.StructureType.STRUCTURE_CONTAINER_OPTIONAL;
                        }
                        ICMInputStructureStartDataType structure = Factory.createICMStructureStartDataType(cont.getName(), structureType);
                        ls.sendStructStart(structure);
                        ls.readLangStruct(cont.getStructure().getLocation(), cont.getStructure().getStructure(), this.p.getProperty("PDSCP"), this.agent);
                        ls.sendStructEnd(Factory.createICMStructureEndDataType());
                        continue;
                    }
                    container = Factory.createICMContainerDataType(cont.getName(), ICM.ContainerDataType.CONT_TYPE_BIT, ICM.ContainerUsage.CONT_USE_OPTIONAL);
                    if (cont.getUse() == UseType.REQUIRED) {
                        container.setUsage(ICM.ContainerUsage.CONT_USE_REQUIRED);
                    }
                    ls.addContainer(container);
                }
            }
        } else {
            filename = this.processSimpleInput(memberName, ls, pdslib, structureProperty);
        }
        if (this.p.containsKey("UTF-16")) {
            CodePageHelper.setCurrentCodePage(CodePageHelper.UTF_16BE_CHARSET);
        }
        ICM icm = ls.completeICM(filename);
        try {
            if (this.p.getProperty("PGMINT").equals("COMMAREA") && icm.getCommAreaLength() > 32767L) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9562E", null));
            }
        }
        catch (ICMException e) {
            CICSWSDLException newEx = icm.getMessages().length < 1 ? new CICSWSDLException(e.getLocalizedMessage()) : new CICSWSDLException(icm.getMessages());
            newEx.initCause(e);
            throw newEx;
        }
        return icm;
    }

    @Override
    public final void doAssistantSpecificProcessing() throws CICSWSDLException {
        ICM requestICM = null;
        ICM responseICM = null;
        String cicsPgm = this.p.getProperty("PGMNAME");
        String pdslib = this.p.getProperty("PDSLIB");
        String req = this.p.getProperty("REQMEM");
        String resp = this.p.getProperty("RESPMEM");
        String uniqueReq = this.getFileNameStub(req, true);
        String uniqueResp = this.getFileNameStub(resp, true);
        if (MappingLevelHelper.supportsMappingLevel_2_1(this.mappingLevel) && this.agent == null) {
            this.agent = this;
        }
        if (!MappingLevelHelper.supportsMappingLevel_2(this.mappingLevel)) {
            if (uniqueReq.equals("")) {
                uniqueReq = uniqueResp;
            } else {
                uniqueResp = uniqueReq;
            }
        }
        String operationName = cicsPgm + "Operation";
        String operation_name = this.p.getProperty("OPERATION-NAME");
        if (operation_name != null && !operation_name.equals("")) {
            operationName = operation_name;
        }
        boolean SOAP_1_1 = true;
        String reqmem = this.p.getProperty("REQMEM");
        requestICM = this.processLanguageStructure(cicsPgm, uniqueReq, operationName, true, pdslib, reqmem, ICM.XMLContentType.SOAP_REQUEST);
        String respmem = this.p.getProperty("RESPMEM");
        String respcha = this.p.getProperty("RESPONSE-CHANNEL");
        if (respmem != null || respcha != null) {
            responseICM = this.processLanguageStructure(cicsPgm, uniqueResp, operationName, true, pdslib, respmem, ICM.XMLContentType.SOAP_RESPONSE);
        }
        String soapVer = this.p.getProperty("SOAPVER");
        this.generateWSDL(requestICM, responseICM, cicsPgm, uniqueReq, operationName, soapVer);
        int soapVerInt = 0;
        String soapVerString = this.p.getProperty("SOAPVER");
        if ("1.1".equals(soapVerString)) {
            soapVerInt = 1;
        } else if ("1.2".equals(soapVerString) || "ALL".equals(soapVerString)) {
            soapVerInt = 2;
        }
        WSBind wsbind = new WSBind(this.p, this.wsBindVer, this.vendorBindFileNeeded, this.vendorMetaData, soapVerInt, this.wsdlVer, this.mappingLevel, this.requestChannelName, this.responseChannelName);
        WSBindOperationEntry op = new WSBindOperationEntry(operationName, requestICM, responseICM, 1, 2);
        wsbind.addOperation(op);
        wsbind.setSyncOnReturn(this.syncOnReturn);
        String thisNamespace = this.p.getProperty("WSDL-NAMESPACE", "http://www." + cicsPgm + "." + uniqueReq + "com");
        String endpoint = "";
        if (this.wsdlVer == 1) {
            String port_name = this.p.getProperty("PORT-NAME");
            endpoint = port_name != null && !port_name.equals("") ? thisNamespace + " " + port_name : thisNamespace + " " + cicsPgm + "Port";
        } else {
            endpoint = cicsPgm + "Interface" + cicsPgm + "Interface";
            endpoint = "1.1".equals(soapVer) || "ALL".equals(soapVer) ? endpoint + "Endpoint11" : endpoint + "Endpoint";
        }
        if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.wsBindVer)) {
            String action = CALCULATED_ACTION + thisNamespace + "/" + endpoint.substring(endpoint.indexOf(32) + 1) + "/" + operationName;
            op.setInputAction(action + "Request");
            op.setOutputAction(action + "Response");
            action = this.wsdlVer == 1 ? action + "/Fault/" : action + "Request/";
            ArrayList<WSAddressingFault> faultActions = new ArrayList<WSAddressingFault>(1);
            faultActions.add(new WSAddressingFault(null, action));
            op.setFaultActions(faultActions);
        }
        wsbind.writeToFile(this.p.getProperty("WSBIND"), this.timestamp, thisNamespace, thisNamespace + " " + endpoint);
        try {
            this.saveWSDL();
        }
        catch (IOException e) {
            wsbind.deleteFile();
            CICSWSDLException newEx = new CICSWSDLException(e.getLocalizedMessage());
            newEx.initCause(e);
            throw newEx;
        }
        if (this.isRegistryClientSetup() && this.wsdl_1_1 != null && this.wsdl_1_1_filename != null) {
            int nameIndex;
            if (this.p.getProperty("WSRR-USERNAME") != null) {
                this.registryClient.setHttpBasicAuthParameter(this.p.getProperty("WSRR-USERNAME"), this.p.getProperty("WSRR-PASSWORD"));
            }
            String shortName = (nameIndex = this.wsdl_1_1_filename.lastIndexOf(System.getProperty("file.separator"))) == -1 ? this.wsdl_1_1_filename : (nameIndex == this.wsdl_1_1_filename.length() ? "NAMENOTSET.wsdl" : this.wsdl_1_1_filename.substring(nameIndex + 1));
            this.registryClient.publishWSDL(this.wsdl_1_1_filename, shortName, this.wsdl_1_1.getTargetNamespace(), this.p.getProperty("WSRR-VERSION"), this.checker.getUserProperties(), this.wsdl_1_1.getCodepage());
        }
        if (this.isRegistryClientSetup() && this.wsdl_2_0 != null && this.wsdl_2_0_filename != null) {
            Logging.writeMessage(4, "DFHPI9823W", new Object[]{this.wsdl_2_0_filename});
        }
    }

    @Override
    public String getFileName() {
        return null;
    }

    public void generateWSDL(ICM requestICM, ICM responseICM, String cicsPgm, String uniqueReq, String operationName, String soapVer) throws CICSWSDLException {
        boolean complexChannelBased = false;
        if (this.p.getProperty("REQUEST-CHANNEL") != null || this.p.getProperty("RESPONSE-CHANNEL") != null) {
            complexChannelBased = true;
        }
        this.wsdl_1_1_filename = this.p.getProperty("WSDL");
        if (this.wsdl_1_1_filename == null || this.wsdl_1_1_filename.equals("")) {
            this.wsdl_1_1_filename = this.p.getProperty("WSDL_1.1");
        }
        this.wsdl_2_0_filename = this.p.getProperty("WSDL_2.0");
        this.wsdlVer = 0;
        if (this.wsdl_1_1_filename != null && !this.wsdl_1_1_filename.equals("")) {
            this.wsdlVer = 1;
            this.wsdl_1_1 = new GeneratedWSDL(requestICM, responseICM, cicsPgm, uniqueReq, operationName, this.mappingLevel, soapVer, 1, "Remove when policy enabled", this.isUTF8RequiredForXML("WSDLCP"), this.isUsEBCDICRequiredForXML("WSDLCP"), this.checker.getWSDLEncodingRequired(), this.p, complexChannelBased);
            this.p.setProperty("BINDING", this.wsdl_1_1.getHttpBindingName());
        }
        if (this.wsdl_2_0_filename != null && !this.wsdl_2_0_filename.equals("")) {
            this.wsdlVer = this.wsdlVer == 0 ? 2 : 3;
            this.wsdl_2_0 = new GeneratedWSDL(requestICM, responseICM, cicsPgm, uniqueReq, operationName, this.mappingLevel, soapVer, 2, "Remove when policy enabled", this.isUTF8RequiredForXML("WSDLCP"), this.isUsEBCDICRequiredForXML("WSDLCP"), this.checker.getWSDLEncodingRequired(), this.p, complexChannelBased);
            this.p.setProperty("BINDING", this.wsdl_2_0.getHttpBindingName());
        }
    }

    public void saveWSDL() throws IOException {
        if (this.wsdl_1_1 != null) {
            this.wsdl_1_1.writeToFile(this.wsdl_1_1_filename);
        }
        if (this.wsdl_2_0 != null) {
            this.wsdl_2_0.writeToFile(this.wsdl_2_0_filename);
        }
    }
}

