/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.pl1;

import com.ibm.cics.wsdl.common.Logging;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ArrayDimensions {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    protected PrintStream log = Logging.getPrintStream();
    List<Integer> values = new ArrayList<Integer>();

    ArrayDimensions(String length) {
        this.interpretDimensions(length);
    }

    private void interpretDimensions(String length) {
        StringTokenizer dimensions = new StringTokenizer(length, ",");
        while (dimensions.hasMoreElements()) {
            String value = (String)dimensions.nextElement();
            int x = 0;
            int y = 0;
            boolean secondTime = false;
            boolean range = false;
            StringTokenizer ranges = new StringTokenizer(value, ":");
            while (ranges.hasMoreElements()) {
                String xString = (String)ranges.nextElement();
                try {
                    Integer xInt = Integer.valueOf(xString);
                    if (!secondTime) {
                        x = xInt;
                        secondTime = true;
                        continue;
                    }
                    y = xInt;
                    range = true;
                }
                catch (NumberFormatException nfe) {
                    Logging.writeMessage(12, "DFHPI9543E", new Object[]{xString});
                }
            }
            int z = Math.abs(x - y);
            if (range) {
                ++z;
            }
            this.log.println("Adding array space of '" + z + "'");
            this.values.add(z);
        }
    }

    protected int getNumValues() {
        return this.values.size();
    }

    protected int getDimension(int index) {
        return this.values.get(index);
    }
}

