/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.pl1;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMInputArrayStartDataType;
import com.ibm.cics.schema.ICMInputSimpleDataType;
import com.ibm.cics.schema.ICMInputStructureStartDataType;
import com.ibm.cics.schema.impl.Factory;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.ls2ws.LangStruct;
import com.ibm.cics.wsdl.pl1.ArrayDimensions;
import com.ibm.cics.wsdl.pl1.PL1DataType;
import com.ibm.cics.wsdl.pl1.PLIWordBreaker;
import com.ibm.cics.wsdl.pl1.StructLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LangStruct_PL1
extends LangStruct {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private ArrayList<Integer> commaPositions = new ArrayList();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private int subscript = 1;
    private boolean oldPLI = false;

    public LangStruct_PL1(boolean oldPLI, boolean useAbstimeDates) {
        super(false, useAbstimeDates);
        this.oldPLI = oldPLI;
    }

    @Override
    protected void processLangStructure(String input, String structureName, String fileName) throws CICSWSDLException {
        this.log.println(LINE_SEPARATOR + "Start processing language structure");
        this.log.println("starting input      : " + input);
        input = this.removeComments(input);
        this.log.println("removed comments    : " + input);
        input = this.removeInitial(input);
        this.log.println("removed INITIAL     : " + input);
        input = this.removeBased(input);
        this.log.println("removed BASED     : " + input);
        input = this.removeUnwantedWhitespace(input);
        this.log.println("removed whitespace  : " + input);
        input = this.addWantedWhitespace(input);
        this.log.println("added whitespace  : " + input);
        input = this.formatBrackets(input);
        this.log.println("formatted brackets  : " + input);
        input = this.markValidCommas(input);
        this.log.println("removed valid commas: " + input);
        List<String> lines = this.getElements(input);
        lines = this.putBackCommas(lines);
        this.log.println("returned commas: " + lines);
        lines = this.expandNames(lines);
        this.log.println("expanded names : " + lines);
        this.checkSyntax(lines);
        for (int i = 0; i < lines.size(); ++i) {
            this.log.println("PLI data element is: " + lines.get(i));
        }
        this.buildICM(lines, fileName);
    }

    private void checkSyntax(List<String> lines) throws CICSWSDLException {
        Pattern p = Pattern.compile("\\(\\d+\\.\\d+\\)");
        for (int i = 0; i < lines.size(); ++i) {
            String s = lines.get(i);
            Matcher m = p.matcher(s);
            if (!m.find()) continue;
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9540E", new Object[]{s}));
        }
    }

    public final String removeInitial(String s) {
        PLIWordBreaker w = new PLIWordBreaker();
        StringBuilder newS = new StringBuilder("");
        int skip = 0;
        while (w.getNextWord(s)) {
            String word = w.getWord();
            if (word.equalsIgnoreCase("INIT") || word.equalsIgnoreCase("INITIAL")) {
                skip = 2;
            } else if ((word.equalsIgnoreCase("TO") || word.equalsIgnoreCase("CALL")) && skip == 1) {
                skip = 3;
            }
            if (skip == 0) {
                newS.append(" ");
                newS.append(word);
            } else {
                --skip;
            }
            s = w.getRemainder();
        }
        newS.append(" ");
        newS.append(s);
        return newS.toString();
    }

    public final String removeBased(String s) {
        PLIWordBreaker w = new PLIWordBreaker();
        StringBuilder newS = new StringBuilder("");
        int skip = 0;
        while (w.getNextWord(s)) {
            String word = w.getWord().trim();
            if (word.equalsIgnoreCase("BASED")) {
                skip = 2;
            }
            if (skip == 0) {
                newS.append(" ");
                newS.append(word);
            } else {
                --skip;
            }
            s = w.getRemainder();
        }
        newS.append(" ");
        newS.append(s);
        return newS.toString();
    }

    private String removeUnwantedWhitespace(String s) {
        this.log.println("entering whitespace remover:" + s);
        StringBuilder newS = new StringBuilder("");
        Pattern p = Pattern.compile("\\([\\s\\d:,-]*?\\s[\\s\\d:,-]*?\\)");
        Matcher m = p.matcher(s);
        while (m.find()) {
            this.log.println("found :" + m.group());
            newS.append(s.substring(0, m.start()));
            newS.append(m.group().replaceAll("\\s", ""));
            s = s.substring(m.end());
            m = p.matcher(s);
        }
        newS.append(s);
        String toReturn = newS.toString();
        this.log.println("returning from whitespace remover:" + toReturn);
        return toReturn;
    }

    private String addWantedWhitespace(String s) {
        this.log.println("entering whitespace adder:" + s);
        s = s.replace("PIC'", "PIC '");
        s = s.replace("PICTURE'", "PICTURE '");
        s = s.replace("PIC\"", "PIC \"");
        s = s.replace("PICTURE\"", "PICTURE \"");
        s = s.replace("Pic'", "PIC '");
        s = s.replace("Picture'", "PICTURE '");
        s = s.replace("Pic\"", "PIC \"");
        s = s.replace("Picture\"", "PICTURE \"");
        this.log.println("returning from whitespace adder:" + s);
        return s;
    }

    private String formatBrackets(String s) {
        StringBuffer firstParse = new StringBuffer();
        Pattern openbracket = Pattern.compile("\\(");
        Matcher m = openbracket.matcher(s);
        while (m.find()) {
            m.appendReplacement(firstParse, " (");
        }
        m.appendTail(firstParse);
        StringBuffer secondParse = new StringBuffer();
        Pattern closebracket = Pattern.compile("\\)");
        m = closebracket.matcher(firstParse.toString());
        while (m.find()) {
            m.appendReplacement(secondParse, ") ");
        }
        m.appendTail(secondParse);
        this.log.println("String returned from formatBrackets function '" + secondParse + "'");
        return secondParse.toString();
    }

    private void buildICM(List<String> list, String fileName) throws CICSWSDLException {
        Stack<StructLevel> stack = new Stack<StructLevel>();
        boolean firstDataLine = true;
        stack.push(new StructLevel());
        for (int i = 0; i < list.size(); ++i) {
            this.log.println(LINE_SEPARATOR + "Parsing " + list.get(i));
            StringTokenizer tokens = new StringTokenizer(list.get(i), " ");
            if (tokens.countTokens() < 2) {
                String previousLine = null;
                if (i > 0) {
                    previousLine = list.get(i - 1);
                }
                if (previousLine != null) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9569E", new Object[]{previousLine}));
                }
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9563E", new Object[]{list.get(i)}));
            }
            String levelString = tokens.nextToken();
            if (levelString.equalsIgnoreCase("DCL") || levelString.equalsIgnoreCase("DECLARE")) {
                levelString = tokens.nextToken();
            }
            int thisLevel = 0;
            thisLevel = Util.stringToInt(levelString, -1, true, fileName);
            if (thisLevel == 1 && !firstDataLine) {
                Logging.writeMessage(12, "DFHPI9555E", null);
            }
            String name = tokens.nextToken();
            boolean filler = false;
            if (name.equals("*")) {
                if (this.oldPLI) {
                    Logging.writeMessage(12, "DFHPI9618E", new Object[]{"*"});
                }
                name = "FILLER" + this.subscript;
                ++this.subscript;
                filler = true;
            }
            int topOfStack = ((StructLevel)stack.peek()).getLevel();
            while (thisLevel <= topOfStack) {
                StructLevel sl = (StructLevel)stack.pop();
                ArrayDimensions ad = sl.getArrayDimensions();
                if (ad != null) {
                    for (int j = 0; j < ad.getNumValues(); ++j) {
                        this.addEndRepeatEntry(Factory.createICMArrayEndDataType());
                    }
                } else {
                    this.sendStructEnd(Factory.createICMStructureEndDataType());
                }
                topOfStack = ((StructLevel)stack.peek()).getLevel();
            }
            Set<String> uniqueNameSet = ((StructLevel)stack.peek()).getUniqueNameSet();
            name = this.ensureValidXMLString(name, uniqueNameSet);
            PL1DataType data = new PL1DataType(name, tokens, this.oldPLI, this.mappingStrategy, this.mappingLevel, this.useHexFloat, fileName, this.useAbstimeDates, this.props);
            if (!Logging.getError()) {
                ArrayDimensions ad = data.getArrayDimensions();
                if (ad != null) {
                    for (int j = 0; j < ad.getNumValues(); ++j) {
                        ICMInputArrayStartDataType field = Factory.createICMArrayStartDataType(name, ad.getDimension(j), !data.hasData());
                        field.setSuppressed(filler);
                        this.addFixedRepeatEntry(field);
                    }
                    stack.push(new StructLevel(thisLevel, ad));
                    if (data.hasData()) {
                        this.addDataToICM(name, data, null, filler);
                    }
                } else if (data.hasData()) {
                    this.addDataToICM(name, data, null, filler);
                } else {
                    ICMInputStructureStartDataType field = Factory.createICMStructureStartDataType(name, ICM.StructureType.STRUCTURE_STANDARD);
                    field.setSuppressed(filler);
                    this.sendStructStart(field);
                    stack.push(new StructLevel(thisLevel, null));
                }
            }
            firstDataLine = false;
        }
        stack.pop();
        while (!stack.isEmpty()) {
            this.sendStructEnd(Factory.createICMStructureEndDataType());
            stack.pop();
        }
    }

    private void addDataToICM(String name, PL1DataType data, String currentEnumName, boolean filler) throws CICSWSDLException {
        ICM.ICMDataType icmType = data.getType();
        ICMInputSimpleDataType field = Factory.createICMSimpleDataType(name, icmType);
        field.setLar(data.getLAR());
        field.setFractionDigits(data.getFractions());
        field.setAligned(data.isAligned());
        field.setSeparateCharacter(false);
        field.setSignLeading(false);
        field.setSuppressed(filler);
        field.setMappingStrategy(data.getMappingStrategy());
        if (icmType.equals((Object)ICM.ICMDataType.DECIMAL) || icmType.equals((Object)ICM.ICMDataType.UNSIGNED_DECIMAL)) {
            field.setLar(data.getLAR() - data.getFractions());
            this.addDataElementEntry(field);
        } else if (icmType.equals((Object)ICM.ICMDataType.ENUM)) {
            if (currentEnumName == null || !currentEnumName.equalsIgnoreCase(name)) {
                field.setType(ICM.ICMDataType.BYTE);
                field.setMappingStrategy(ICM.VaryingLength.NO_VARYING_STRATEGY);
                this.addDataElementEntry(field);
            }
        } else {
            String comments = data.getComments();
            if (comments == null) {
                this.addDataElementEntry(field);
            } else {
                field.setComment(comments);
                this.addDataElementEntry(field);
            }
        }
    }

    private List<String> expandNames(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            int closeBracketPos;
            String rest;
            String element = list.get(i).trim();
            int spacePos = element.indexOf(32);
            if (spacePos == -1 || !(rest = element.substring(spacePos).trim()).startsWith("(") || (closeBracketPos = rest.indexOf(")")) == -1) continue;
            list.remove(i);
            String namestring = rest.substring(1, closeBracketPos);
            StringTokenizer names = new StringTokenizer(namestring, ",");
            String level = element.substring(0, spacePos);
            String data = "";
            if (rest.length() > closeBracketPos) {
                data = rest.substring(closeBracketPos + 1);
            }
            while (names.hasMoreTokens()) {
                String thisName = names.nextToken();
                String newElement = level + " " + thisName + data;
                list.add(i++, newElement);
            }
        }
        return list;
    }

    private List<String> putBackCommas(List<String> list) {
        int storedLength = 0;
        int j = 0;
        for (int i = 0; i < list.size(); ++i) {
            int index;
            String line = list.get(i);
            while (j < this.commaPositions.size() && (index = this.commaPositions.get(j).intValue()) < storedLength + line.length()) {
                int position = index - storedLength;
                line = line.substring(0, position) + "," + line.substring(position + 1);
                ++j;
            }
            list.remove(i);
            list.add(i, line);
            storedLength = storedLength + line.length() + 1;
        }
        return list;
    }

    private String markValidCommas(String line) {
        Pattern brackets = Pattern.compile("\\([^\\)]+,[^\\(]+\\)");
        Matcher m = brackets.matcher(line);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            int pos;
            String sub = m.group();
            while ((pos = sub.indexOf(",")) > 0) {
                sub = sub.substring(0, pos) + " " + sub.substring(pos + 1);
                this.commaPositions.add(m.start() + pos);
            }
            m.appendReplacement(sb, sub);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private List<String> getElements(String line) {
        ArrayList<String> list = new ArrayList<String>();
        int end = line.indexOf(59);
        if (end == -1) {
            Logging.writeMessage(4, "DFHPI9564W", null);
            line = line.endsWith(",") ? line.substring(0, line.length() - 1) + ";" : line + ";";
            end = line.indexOf(59);
        } else if (line.length() > end + 1) {
            Logging.writeMessage(4, "DFHPI9611W", new Object[]{line});
        }
        line = line.substring(0, end + 1);
        StringTokenizer st = new StringTokenizer(line, ";,'\"", true);
        StringBuilder tmpline = new StringBuilder();
        char currentBracket = '\u0000';
        while (st.hasMoreTokens()) {
            String token = (String)st.nextElement();
            if (token.equals("'") || token.equals("\"")) {
                char bracketFound = token.charAt(0);
                if (currentBracket == '\u0000') {
                    currentBracket = bracketFound;
                } else if (currentBracket == bracketFound) {
                    currentBracket = '\u0000';
                }
                tmpline.append(bracketFound);
                continue;
            }
            if (token.equals(",") || token.equals(";")) {
                if (currentBracket != '\u0000') {
                    tmpline.append(token);
                    continue;
                }
                list.add(tmpline.toString());
                tmpline.delete(0, tmpline.length());
                continue;
            }
            tmpline.append(token);
        }
        return list;
    }

    private String removeComments(String input) {
        boolean inQuotes = false;
        boolean inComment = false;
        StringBuffer sb = new StringBuffer(input);
        StringBuffer newsb = new StringBuffer();
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c == '/' && !inQuotes && !inComment && sb.charAt(i + 1) == '*') {
                inComment = true;
                ++i;
            }
            if (!inComment) {
                newsb.append(c);
            }
            if (c == '*' && !inQuotes && inComment && sb.charAt(i + 1) == '/') {
                ++i;
                inComment = false;
            }
            if (c != '\'' || inComment) continue;
            inQuotes = !inQuotes;
        }
        return newsb.toString();
    }

    @Override
    protected final String preProcessLine(String s) {
        s = s.length() > 72 ? s.substring(1, 72).trim() : (s.length() > 1 ? s.substring(1).trim() : "");
        return s + " ";
    }
}

