/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.pl1;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMFixedRepeatEntry;
import com.ibm.cics.schema.ICMRepeatEntry;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.ParmChecker;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.ws2ls.Element;
import com.ibm.cics.wsdl.ws2ls.MakeLang;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class MakePL1
extends MakeLang {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    public static final int MAX_VARIABLE_LENGTH = 31;
    private static final int LANGSTRUCT_INDENT = 2;
    private static final int MAX_LINE_LENGTH = 71;
    private static final int COMMENT_FORMAT_ADJUSTMENT = 3;
    private static final String PLI_OFFSET = " ";
    private static final String STATEMENT_TERMINATOR = ";";
    private static final String LINE_TERMINATOR = ",";
    private static final String NATURAL_SEPERATOR = "_";
    private static final Pattern invalidCharsPattern = Pattern.compile("[^a-zA-Z0-9$@#_]");
    private static final Pattern firstCharAlphabeticPattern = Pattern.compile("^[^a-zA-Z]");
    private static final Pattern underscorePattern = Pattern.compile("_$");
    private static final Pattern hyphenPattern = Pattern.compile("-");
    private static final Map<String, Boolean> internalKeywords = new HashMap<String, Boolean>();
    private PLIType pliType = PLIType.PLI_ENTERPRISE;
    private static final int MAX_CHAR_ARRAY_LENGTH = Short.MAX_VALUE;

    public MakePL1(ICM.XMLContentType messageType, QName artifactName, String pdsName, String structName, PLIType pliType, int mappingLevel, int mep, int langStructIncrement, boolean runZOS, int tool, Map<QName, String> typeMemberNameMap, Properties theInputParms, boolean response) {
        super(messageType, artifactName, pdsName, structName, internalKeywords, false, mappingLevel, mep, langStructIncrement, runZOS, tool, typeMemberNameMap, theInputParms, response);
        this.pliType = pliType;
    }

    @Override
    protected final void gotFixedRepeat(ICMFixedRepeatEntry fixRepeat, boolean isStructural) throws CICSWSDLException {
        if (MappingLevelHelper.requiresMappingLevel_1(this.mappingLevel)) {
            super.gotFixedRepeat(fixRepeat, isStructural, 0);
        } else {
            super.gotFixedRepeat(fixRepeat, isStructural, 1);
        }
    }

    @Override
    protected String buildDataLine(String name, ICM.ICMDataType type, int lar, int fractions, boolean aligned, int level, Stack<ICMFixedRepeatEntry> repeatStack, ICM.VaryingLength mappingStrategy, boolean signLeading, boolean separateChar, String odoTargetFieldName, int minLength) throws CICSWSDLException {
        String pl1 = this.buildPL1(type, lar, fractions, aligned, this.pliType, mappingStrategy, name);
        String levelValue = this.formatLevel(level);
        StringBuilder formattedName = new StringBuilder(name);
        formattedName.append(PLI_OFFSET);
        while (!repeatStack.empty()) {
            int dimension = repeatStack.pop().getOccurances();
            formattedName.append(this.formatOccurs(dimension));
        }
        String formattedNameStr = this.formatName(formattedName.toString());
        return levelValue + formattedNameStr + pl1 + LINE_TERMINATOR;
    }

    @Override
    protected boolean supportsVarMappingAsOneField() {
        return true;
    }

    @Override
    protected void buildStructLine(String name, int level, Stack<ICMFixedRepeatEntry> repeatStack) {
        String levelValue = this.formatLevel(level);
        StringBuilder formattedName = new StringBuilder(name);
        formattedName.append(PLI_OFFSET);
        while (!repeatStack.empty()) {
            int dimension = repeatStack.pop().getOccurances();
            formattedName.append(this.formatOccurs(dimension));
        }
        String formattedNameStr = this.formatName(formattedName.toString());
        String line = levelValue + formattedNameStr.trim() + LINE_TERMINATOR;
        this.block.addElement(line);
    }

    @Override
    protected String buildContainerNumberLine(String contid, int level, ICMRepeatEntry varRepeat) {
        String pl1 = null;
        switch (this.pliType) {
            case PLI_OTHER: {
                pl1 = "FIXED BINARY(31) UNALIGNED";
                break;
            }
            case PLI_ENTERPRISE: {
                pl1 = "UNSIGNED FIXED BINARY(32) UNALIGNED";
                break;
            }
            case PLX: {
                pl1 = "FIXED BIN(32) BDY(BYTE)";
                break;
            }
        }
        String varName = this.getContainerOccurencesUniqueFieldName(contid, true, varRepeat);
        return this.formatLevel(level) + this.formatName(varName) + pl1 + LINE_TERMINATOR;
    }

    @Override
    protected String buildContainerNameLine(String contid, int level) {
        String pl1 = "CHAR(16)";
        String varName = this.getContainerUniqueFieldName(contid, true);
        return this.formatLevel(level) + this.formatName(varName) + pl1 + LINE_TERMINATOR;
    }

    @Override
    protected String buildDescriminatorNameLine(String contid, int level) {
        String pl1 = "CHAR(1)";
        String varName = this.getDescriminatorUniqueFieldName(contid, true);
        return this.formatLevel(level) + this.formatName(varName) + pl1 + LINE_TERMINATOR;
    }

    private String formatName(String name) {
        int currentLength = name.length();
        int amountToAdd = 31 - currentLength;
        StringBuilder localName = new StringBuilder(name);
        for (int i = 0; i < amountToAdd; ++i) {
            localName.append(PLI_OFFSET);
        }
        return localName.toString();
    }

    private String formatLevel(int level) {
        DecimalFormat myFormatter = new DecimalFormat("00");
        int number = 1;
        if (level > 1) {
            number = (level - 1) * this.langstructIncrement;
        }
        String output = myFormatter.format(number);
        if (number == 1) {
            output = "Dcl " + output;
        }
        int numToIndent = 2 + 2 * level;
        for (int i = 0; i < numToIndent; ++i) {
            output = PLI_OFFSET + output;
        }
        return output + PLI_OFFSET;
    }

    @Override
    protected String formatOccurs(int o) {
        String s = "";
        if (o > 1) {
            s = "(" + o + ")";
        }
        return s;
    }

    private void replaceComma() {
        String line;
        int pos;
        if (this.block == null) {
            return;
        }
        Element e = this.block.getLastLineWithCommaAtEnd();
        if (e != null && (pos = (line = e.getLine()).lastIndexOf(44)) > 0) {
            line = line.substring(0, pos) + STATEMENT_TERMINATOR;
            e.setLine(line);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String buildPL1(ICM.ICMDataType type, int lar, int fractions, boolean aligned, PLIType pliType, ICM.VaryingLength mappingStrategy, String name) throws CICSWSDLException {
        int localLAR = lar;
        String result = null;
        block0 : switch (type) {
            case DECIMAL: 
            case UNSIGNED_DECIMAL: 
            case ABSTIME: {
                int totalDigits = lar + fractions;
                switch (pliType) {
                    case PLI_OTHER: 
                    case PLI_ENTERPRISE: {
                        result = "FIXED DECIMAL (" + totalDigits + LINE_TERMINATOR + fractions + ")";
                        break block0;
                    }
                    case PLX: {
                        int packedDecimalDigits = (totalDigits + 1) / 2;
                        result = "CHAR(" + packedDecimalDigits + ")";
                        break block0;
                    }
                }
                break;
            }
            case BIT_ARRAY: {
                result = "BIT (" + lar + ")";
                break;
            }
            case BOOLEAN: 
            case BYTE: {
                switch (pliType) {
                    case PLI_OTHER: {
                        result = "FIXED BINARY (7)";
                        break block0;
                    }
                    case PLI_ENTERPRISE: {
                        result = "SIGNED FIXED BINARY (7)";
                        break block0;
                    }
                    case PLX: {
                        result = "FIXED BIN(7)";
                        break block0;
                    }
                }
                break;
            }
            case UNSIGNED_BYTE: {
                switch (pliType) {
                    case PLI_OTHER: {
                        result = "FIXED BINARY(8)";
                        break block0;
                    }
                    case PLI_ENTERPRISE: {
                        result = "UNSIGNED FIXED BINARY (8)";
                        break block0;
                    }
                    case PLX: {
                        result = "FIXED BIN(8)";
                        break block0;
                    }
                }
                break;
            }
            case WIDE_CHAR_ARRAY: 
            case CHAR_ARRAY: 
            case UTF16_CHAR_ARRAY: {
                String prefix = null;
                prefix = type.equals((Object)ICM.ICMDataType.CHAR_ARRAY) ? "CHAR(" : (type.equals((Object)ICM.ICMDataType.UTF16_CHAR_ARRAY) ? "WIDECHAR(" : "G(");
                int effectiveMaxLength = Short.MAX_VALUE;
                if (mappingStrategy.equals((Object)ICM.VaryingLength.FIXED_LENGTH_ARRAY)) {
                    result = prefix + lar + ")";
                    if (pliType == PLIType.PLI_ENTERPRISE) {
                        effectiveMaxLength = ParmChecker.getMaxCharArraySize(this.inputParms);
                    }
                } else if (mappingStrategy.equals((Object)ICM.VaryingLength.NULL_TERMINATED_CHAR_ARRAY)) {
                    switch (pliType) {
                        case PLI_OTHER: 
                        case PLX: {
                            result = prefix + lar + ")";
                            break;
                        }
                        case PLI_ENTERPRISE: {
                            result = prefix + (lar - 1) + ") VARYINGZ";
                            effectiveMaxLength = ParmChecker.getMaxCharArraySize(this.inputParms);
                            ++effectiveMaxLength;
                            if (!type.equals((Object)ICM.ICMDataType.WIDE_CHAR_ARRAY)) break;
                            ++effectiveMaxLength;
                            break;
                        }
                    }
                } else {
                    if (!mappingStrategy.equals((Object)ICM.VaryingLength.VARYING_ARRAY)) throw new CICSWSDLException("Internal error: unknown mapping strategy: " + (Object)((Object)mappingStrategy));
                    result = prefix + lar + ") VARYING";
                }
                int lenInBytes = localLAR;
                if (type.equals((Object)ICM.ICMDataType.WIDE_CHAR_ARRAY)) {
                    lenInBytes *= 2;
                }
                if (lenInBytes <= effectiveMaxLength) break;
                int lang = 2;
                switch (pliType) {
                    case PLI_ENTERPRISE: {
                        lang = 2;
                        break;
                    }
                    case PLI_OTHER: {
                        lang = 6;
                        break;
                    }
                    case PLX: {
                        lang = 7;
                        break;
                    }
                }
                int max = effectiveMaxLength;
                if (type.equals((Object)ICM.ICMDataType.WIDE_CHAR_ARRAY)) {
                    max /= 2;
                }
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9631E", new Object[]{name, Integer.toString(localLAR), ICM.LANGUAGE_TYPES[lang], Integer.toString(max)}));
            }
            case BASE64_ARRAY: 
            case HEX_ARRAY: {
                if (mappingStrategy.equals((Object)ICM.VaryingLength.FIXED_LENGTH_ARRAY)) {
                    if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel) || lar > 4095) {
                        result = "CHAR(" + lar + ")";
                        break;
                    }
                    result = "BIT(" + lar * 8 + ")";
                    break;
                }
                if (!mappingStrategy.equals((Object)ICM.VaryingLength.VARYING_ARRAY)) throw new CICSWSDLException("INTERNAL_ERROR: unexpected mapping strategy: " + (Object)((Object)mappingStrategy));
                result = "CHAR(" + lar + ") VARYING";
                break;
            }
            case SHORT: {
                switch (pliType) {
                    case PLI_OTHER: {
                        result = "FIXED BINARY (15)";
                        break block0;
                    }
                    case PLI_ENTERPRISE: {
                        result = "SIGNED FIXED BINARY (15)";
                        break block0;
                    }
                    case PLX: {
                        result = "FIXED BIN(15)";
                        break block0;
                    }
                }
                break;
            }
            case UNSIGNED_SHORT: {
                switch (pliType) {
                    case PLI_OTHER: {
                        result = "FIXED BINARY(16)";
                        break block0;
                    }
                    case PLI_ENTERPRISE: {
                        result = "UNSIGNED FIXED BINARY(16)";
                        break block0;
                    }
                    case PLX: {
                        result = "FIXED BIN(16)";
                        break block0;
                    }
                }
                break;
            }
            case INT: {
                switch (pliType) {
                    case PLI_OTHER: {
                        result = "FIXED BINARY(31)";
                        break block0;
                    }
                    case PLI_ENTERPRISE: {
                        result = "SIGNED FIXED BINARY(31)";
                        break block0;
                    }
                    case PLX: {
                        result = "FIXED BIN(31)";
                        break block0;
                    }
                }
                break;
            }
            case UNSIGNED_INT: {
                switch (pliType) {
                    case PLI_OTHER: {
                        result = "BIT(64)";
                        break block0;
                    }
                    case PLI_ENTERPRISE: {
                        result = "UNSIGNED FIXED BINARY(32)";
                        break block0;
                    }
                    case PLX: {
                        result = "FIXED BIN(32)";
                        break block0;
                    }
                }
                break;
            }
            case LONG: {
                switch (pliType) {
                    case PLI_OTHER: {
                        result = "BIT(64)";
                        break block0;
                    }
                    case PLI_ENTERPRISE: {
                        result = "SIGNED FIXED BINARY(63)";
                        break block0;
                    }
                    case PLX: {
                        result = "BIT(64)";
                        break block0;
                    }
                }
                break;
            }
            case UNSIGNED_LONG: {
                switch (pliType) {
                    case PLI_OTHER: {
                        result = "BIT(64)";
                        break block0;
                    }
                    case PLI_ENTERPRISE: {
                        result = "UNSIGNED FIXED BINARY(64)";
                        break block0;
                    }
                    case PLX: {
                        result = "BIT(64)";
                        break block0;
                    }
                }
                break;
            }
            case HFP_SHORT: {
                switch (pliType) {
                    case PLI_OTHER: {
                        result = "DECIMAL FLOAT(6)";
                        break block0;
                    }
                    case PLI_ENTERPRISE: {
                        result = "DECIMAL FLOAT(6) HEXADEC";
                        break block0;
                    }
                    case PLX: {
                        result = "BIT(32)";
                        break block0;
                    }
                }
                break;
            }
            case HFP_LONG: {
                switch (pliType) {
                    case PLI_OTHER: {
                        result = "DECIMAL FLOAT(16)";
                        break block0;
                    }
                    case PLI_ENTERPRISE: {
                        result = "DECIMAL FLOAT(16) HEXADEC";
                        break block0;
                    }
                    case PLX: {
                        result = "BIT(64)";
                        break block0;
                    }
                }
                break;
            }
            case BFP_FLOAT: {
                if (pliType != PLIType.PLI_ENTERPRISE) throw new CICSWSDLException("INTERNAL_ERROR: An attempt has been made to use IEEE floating point numbers in a scenario that doesn't support them");
                if (!MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
                    throw new CICSWSDLException("INTERNAL_ERROR: An attempt has been made to use IEEE floating point numbers in a scenario that doesn't support them");
                }
                result = "DECIMAL FLOAT(6) IEEE";
                break;
            }
            case BFP_DOUBLE: {
                if (pliType != PLIType.PLI_ENTERPRISE) throw new CICSWSDLException("INTERNAL_ERROR: An attempt has been made to use IEEE floating point numbers in a scenario that doesn't support them");
                if (!MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
                    throw new CICSWSDLException("INTERNAL_ERROR: An attempt has been made to use IEEE floating point numbers in a scenario that doesn't support them");
                }
                result = "DECIMAL FLOAT(16) IEEE";
                break;
            }
            default: {
                throw new CICSWSDLException("INTERNAL_ERROR: Internal problem. ICM Type '" + (Object)((Object)type) + "' not recognised.");
            }
        }
        if ((type.equals((Object)ICM.ICMDataType.SHORT) || type.equals((Object)ICM.ICMDataType.UNSIGNED_SHORT) || type.equals((Object)ICM.ICMDataType.INT) || type.equals((Object)ICM.ICMDataType.UNSIGNED_INT) || type.equals((Object)ICM.ICMDataType.LONG) || type.equals((Object)ICM.ICMDataType.UNSIGNED_LONG) || type.equals((Object)ICM.ICMDataType.HFP_SHORT) || type.equals((Object)ICM.ICMDataType.HFP_LONG) || type.equals((Object)ICM.ICMDataType.BFP_FLOAT) || type.equals((Object)ICM.ICMDataType.BFP_DOUBLE)) && lar == 0) {
            if (aligned) {
                if (pliType != PLIType.PLX) {
                    result = result + " ALIGNED";
                }
            } else {
                result = pliType != PLIType.PLX ? result + " UNALIGNED" : result + " BDY(BYTE)";
            }
        }
        if (pliType == PLIType.PLI_OTHER && (type.equals((Object)ICM.ICMDataType.BYTE) || type.equals((Object)ICM.ICMDataType.UNSIGNED_BYTE) || type.equals((Object)ICM.ICMDataType.BOOLEAN) && !MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel))) {
            result = aligned ? result + " ALIGNED" : result + " UNALIGNED";
        }
        if (!type.equals((Object)ICM.ICMDataType.CHAR_ARRAY) && !type.equals((Object)ICM.ICMDataType.BASE64_ARRAY)) {
            if (!type.equals((Object)ICM.ICMDataType.HEX_ARRAY)) return result;
        }
        if (!mappingStrategy.equals((Object)ICM.VaryingLength.VARYING_ARRAY)) return result;
        if (aligned) {
            if (pliType == PLIType.PLX) return result;
            return result + " ALIGNED";
        }
        if (pliType == PLIType.PLX) return result + " BDY(BYTE)";
        return result + " UNALIGNED";
    }

    @Override
    protected final void markEnd() {
        this.replaceComma();
    }

    @Override
    protected final String ensureValidInLang(String basename) {
        if (this.pliType != null) {
            switch (this.pliType) {
                case PLI_OTHER: {
                    break;
                }
                case PLI_ENTERPRISE: 
                case PLX: {
                    if (!"*".equals(basename)) break;
                    return basename;
                }
            }
        }
        String validName = basename;
        if (MappingLevelHelper.supportsMappingLevel_4_2(this.mappingLevel) || this.inputParms.getProperty("HYPHENS-AS-UNDERSCORES") != null && this.inputParms.getProperty("HYPHENS-AS-UNDERSCORES") == "YES") {
            Matcher hyphenMatcher = hyphenPattern.matcher(basename);
            validName = hyphenMatcher.replaceAll(NATURAL_SEPERATOR);
        }
        Matcher invalidMatcher = invalidCharsPattern.matcher(validName);
        validName = invalidMatcher.replaceAll("X");
        Matcher firstCharAlphabeticMatcher = firstCharAlphabeticPattern.matcher(validName);
        validName = firstCharAlphabeticMatcher.replaceAll("X");
        Matcher underscoreMatcher = underscorePattern.matcher(validName);
        validName = underscoreMatcher.replaceAll("X");
        return validName;
    }

    @Override
    protected final String ensureValidVariableLength(String basename) {
        return this.shrinkToFit(basename, 29);
    }

    @Override
    protected final String ensureValidContainerIDLength(String basename) {
        int RESERVED_SPACE = 7;
        return this.shrinkToFit(basename, 31 - RESERVED_SPACE);
    }

    @Override
    protected final int getInitialNestingLevel() {
        return 1;
    }

    @Override
    protected final String generateIndentForComments() {
        int newLevel = this.block.getNestingLevel() + 1;
        int numToIndent = 2 + 2 * newLevel;
        StringBuilder format = new StringBuilder();
        for (int i = 0; i < numToIndent; ++i) {
            format.append(PLI_OFFSET);
        }
        return format.toString();
    }

    @Override
    protected final int getMaxLineLength() {
        return 71;
    }

    @Override
    protected final List<String> removeCommentsFromStringList(List<String> input) {
        ArrayList<String> output = new ArrayList<String>();
        boolean commentStarted = false;
        for (String line : input) {
            if (line.trim().startsWith("/*") || commentStarted) {
                commentStarted = true;
            } else {
                output.add(line);
            }
            if (line.indexOf("*/") == -1) continue;
            commentStarted = false;
        }
        output.add(0, PLI_OFFSET);
        output.add(0, " ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/");
        return output;
    }

    @Override
    protected final List<String> addHeaderFormatting(List<String> input) {
        for (int i = 0; i < input.size(); ++i) {
            String line = input.get(i);
            line = line.replaceAll("/\\*", "<*");
            line = line.replaceAll("\\*/", "*>");
            if ((line = line.replaceAll(STATEMENT_TERMINATOR, "")).startsWith("   ")) {
                line = line.substring(3);
            }
            line = " | " + line;
            input.remove(i);
            input.add(i, line);
        }
        input.add(0, " /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        return input;
    }

    @Override
    protected String getTopLevelStrucName(String baseName) {
        return this.getMemberName() + NATURAL_SEPERATOR + baseName;
    }

    @Override
    protected String getContentName(String baseName) {
        baseName = this.shrinkToFit(baseName, 20);
        return baseName + "_value";
    }

    @Override
    protected String getAttributeName(String localName, String elName, boolean nil) {
        localName = this.shrinkToFit(localName, 17);
        if (nil) {
            elName = this.shrinkToFit(elName, 13);
            return "attr_" + localName + NATURAL_SEPERATOR + elName + "_value";
        }
        return "attr_" + localName + "_value";
    }

    @Override
    protected String getAttributeExistenceByteName(String localName, String elName, boolean nil) {
        localName = this.shrinkToFit(localName, 17);
        if (nil) {
            elName = this.shrinkToFit(elName, 13);
            return "attr_" + localName + NATURAL_SEPERATOR + elName + "_exist";
        }
        return "attr_" + localName + "_exist";
    }

    @Override
    protected String getContainerFieldName(String baseName) {
        if (MappingLevelHelper.supportsMappingLevel_1_1(this.mappingLevel)) {
            int maxLength = 26;
            if (this.inputParms.getProperty("ZOS-CONNECT-EE").equals("true")) {
                String containerName = this.inputParms.getProperty("CONTAINER-NAME-SUFFIX");
                if (containerName != null) {
                    baseName = this.shrinkToFit(baseName, maxLength -= containerName.length()) + NATURAL_SEPERATOR + containerName;
                } else {
                    maxLength = 18;
                    baseName = this.shrinkToFit(baseName, maxLength) + "_dataarea";
                }
            } else {
                maxLength = 22;
                baseName = this.shrinkToFit(baseName, maxLength) + "_cont";
            }
        }
        return baseName;
    }

    @Override
    protected String getDescriminatorFieldName(String baseName) {
        baseName = this.shrinkToFit(baseName, 22);
        return baseName + "_enum";
    }

    @Override
    protected String buildEnumerationValueLine(String name, String value) {
        return null;
    }

    @Override
    protected String getContainerOccurencesFieldName(String baseName, ICMRepeatEntry varRepeat) {
        if (MappingLevelHelper.supportsMappingLevel_1_1(this.mappingLevel)) {
            String originalName = baseName;
            baseName = this.shrinkToFit(baseName, 22) + "_num";
            if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                if (this.inputParms.getProperty("ZOS-CONNECT-EE").equals("true") && !varRepeat.isOptionalArray() && Util.isResponseCodeEntity(originalName)) {
                    baseName = this.shrinkToFit(originalName, 16) + "_existence";
                } else if (varRepeat.getMinOccurance() == 0 && varRepeat.getMaxOccurance() == 1) {
                    baseName = this.shrinkToFit(originalName, 16) + "_existence";
                }
            }
        }
        return baseName;
    }

    @Override
    protected int getCommentAdjustment() {
        return 3;
    }

    @Override
    protected String getLineTerminator() {
        return LINE_TERMINATOR;
    }

    @Override
    protected String getNaturalSeperator() {
        return NATURAL_SEPERATOR;
    }

    @Override
    protected void buildOuterStructLine(String name) {
        if (this.pliType == PLIType.PLX) {
            this.block.addElement(this.formatLevel(this.block.getNestingLevel()) + name + " BASED BDY(DWORD)" + LINE_TERMINATOR);
        } else {
            this.block.addElement(this.formatLevel(this.block.getNestingLevel()) + name + LINE_TERMINATOR);
        }
    }

    @Override
    protected void closeOuterBlock() {
        this.replaceComma();
    }

    @Override
    protected void closeInnerBlock() {
    }

    @Override
    protected String getVaryingLengthCountName(String baseName) {
        baseName = this.shrinkToFit(baseName, 20);
        return baseName + "_length";
    }

    @Override
    protected boolean requiresTwoPartBoolean() {
        return MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel);
    }

    @Override
    protected String getNameToUseForFillerFields() {
        switch (this.pliType) {
            case PLI_OTHER: {
                return "filler";
            }
            case PLI_ENTERPRISE: 
            case PLX: {
                break;
            }
        }
        return "*";
    }

    @Override
    protected boolean mustBeUnique(String varName) {
        return !"*".equals(varName);
    }

    @Override
    protected boolean supportsPureDBCS() {
        return true;
    }

    @Override
    protected int getLanguageType() {
        return 2;
    }

    public static enum PLIType {
        PLI_ENTERPRISE,
        PLI_OTHER,
        PLX;

    }
}

