/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.pl1;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.ParmChecker;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.pl1.ArrayDimensions;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class PL1DataType {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    protected PrintStream log = Logging.getPrintStream();
    private String name;
    private boolean hasData;
    private ICM.ICMDataType type;
    private int lar;
    private int fractions;
    private ArrayDimensions ad;
    private String comments;
    private static List<String> ns = new ArrayList<String>();
    private ICM.VaryingLength mappingStrategy = ICM.VaryingLength.NO_VARYING_STRATEGY;
    private int mappingLevel = 0;
    private boolean useHexFloat = true;
    private boolean useAbstimeDates = false;
    private boolean isAligned = true;
    private Properties props;

    PL1DataType(String name, StringTokenizer tokens, boolean oldPLI, ICM.VaryingLength defaultMappingStrategy, int mappingLevel, boolean useHexFloat, String fileName, boolean useAbstimeDates, Properties props) {
        this.name = name;
        this.hasData = true;
        this.lar = 0;
        this.type = null;
        this.ad = null;
        this.comments = null;
        this.mappingStrategy = ICM.VaryingLength.NO_VARYING_STRATEGY;
        this.mappingLevel = mappingLevel;
        this.useHexFloat = useHexFloat;
        this.useAbstimeDates = useAbstimeDates;
        this.props = props;
        String line = this.getArrayDimensions(tokens, oldPLI);
        this.parseTokens(line, oldPLI, defaultMappingStrategy, fileName);
        this.reportUnsupportedKeywords(line, oldPLI);
    }

    private String getArrayDimensions(StringTokenizer t, boolean oldPLI) {
        String arrayBit = null;
        ArrayList<String> tokens = new ArrayList<String>();
        while (t.hasMoreTokens()) {
            tokens.add(t.nextToken());
        }
        if (tokens.size() > 0) {
            int idx;
            String x = (String)tokens.get(0);
            if (x.matches("\\(.+\\)")) {
                arrayBit = x.replaceAll("[()]", "");
                tokens.remove(0);
            }
            if ((idx = tokens.indexOf("DIMENSION")) == -1) {
                idx = tokens.indexOf("DIM");
            }
            if (idx > -1) {
                x = (String)tokens.get(idx + 1);
                arrayBit = x.replaceAll("[()]", "");
                tokens.remove(idx);
                tokens.remove(idx);
                if (oldPLI) {
                    Logging.writeMessage(12, "DFHPI9618E", new Object[]{"DIMENSION"});
                }
            }
            if (arrayBit != null) {
                this.log.println("found array dimensions : " + arrayBit);
                this.ad = new ArrayDimensions(arrayBit);
            } else {
                this.log.println("No array dimensions for this element");
            }
        }
        StringBuffer remainder = new StringBuffer();
        for (int i = 0; i < tokens.size(); ++i) {
            remainder.append(" ");
            remainder.append((String)tokens.get(i));
        }
        return remainder.toString().trim();
    }

    protected ArrayDimensions getArrayDimensions() {
        return this.ad;
    }

    private void parseTokens(String values, boolean oldPLI, ICM.VaryingLength defaultMappingStrategy, String fileName) {
        values = " " + values + " ";
        if ((values = values.toUpperCase(Locale.ENGLISH)).indexOf(" SIGNED ") > -1 && oldPLI) {
            Logging.writeMessage(12, "DFHPI9618E", new Object[]{"SIGNED"});
        }
        if ((values.indexOf(" NONVARYING ") > -1 || values.indexOf(" NONVAR ") > -1) && oldPLI) {
            Logging.writeMessage(12, "DFHPI9618E", new Object[]{"NONVARYING"});
        }
        if ((values.indexOf(" VARYINGZ ") > -1 || values.indexOf(" VARZ ") > -1) && oldPLI) {
            Logging.writeMessage(12, "DFHPI9618E", new Object[]{"VARYINGZ"});
        }
        if (values.indexOf(" DECIMAL ") != -1 || values.indexOf(" DEC ") != -1) {
            if (values.indexOf(" FIXED ") == -1) {
                if (values.indexOf(" FLOAT ") == -1) {
                    Logging.writeMessage(12, "DFHPI9566E", new Object[]{values});
                    return;
                }
                this.handleFloatingPoint(values, this.useHexFloat, true, oldPLI, fileName);
            } else {
                this.type = ICM.ICMDataType.DECIMAL;
                this.setDECIMALLengths(values, oldPLI, fileName);
                if (values.indexOf(" UNSIGNED ") != -1) {
                    this.type = ICM.ICMDataType.UNSIGNED_DECIMAL;
                    if (oldPLI) {
                        Logging.writeMessage(12, "DFHPI9618E", new Object[]{"UNSIGNED"});
                    }
                }
                this.isAligned = false;
                if (this.type.equals((Object)ICM.ICMDataType.DECIMAL) && this.lar == 15 && MappingLevelHelper.supportsMappingLevel_3_0(this.mappingLevel) && this.useAbstimeDates) {
                    this.type = ICM.ICMDataType.ABSTIME;
                }
            }
        } else if (values.indexOf(" BIN ") > -1 || values.indexOf(" BINARY ") > -1) {
            boolean signed = true;
            if (values.indexOf(" UNSIGNED ") != -1) {
                signed = false;
                if (oldPLI) {
                    Logging.writeMessage(12, "DFHPI9568E", new Object[]{values});
                }
            }
            if (values.indexOf(" FIXED ") == -1) {
                if (values.indexOf(" FLOAT ") == -1) {
                    Logging.writeMessage(12, "DFHPI9566E", new Object[]{values});
                    return;
                }
                this.handleFloatingPoint(values, this.useHexFloat, false, oldPLI, fileName);
            } else {
                int numBytes = this.getBINARYLength(values, signed, fileName);
                if (signed) {
                    if (numBytes == 1) {
                        this.type = ICM.ICMDataType.BYTE;
                    } else if (numBytes == 2) {
                        this.type = ICM.ICMDataType.SHORT;
                    } else if (numBytes == 4) {
                        this.type = ICM.ICMDataType.INT;
                    } else if (numBytes == 8) {
                        this.type = ICM.ICMDataType.LONG;
                    }
                } else if (numBytes == 1) {
                    this.type = ICM.ICMDataType.UNSIGNED_BYTE;
                } else if (numBytes == 2) {
                    this.type = ICM.ICMDataType.UNSIGNED_SHORT;
                } else if (numBytes == 4) {
                    this.type = ICM.ICMDataType.UNSIGNED_INT;
                } else if (numBytes == 8) {
                    this.type = ICM.ICMDataType.UNSIGNED_LONG;
                }
                if (oldPLI && numBytes == 8) {
                    Logging.writeMessage(12, "DFHPI9570E", new Object[]{values});
                }
            }
        } else if (values.indexOf(" BIT ") > -1) {
            this.type = ICM.ICMDataType.HEX_ARRAY;
            this.comments = "Derived from PL/I BIT type";
            int length = this.getSimpleLength(values, fileName);
            if (length % 8 != 0) {
                Logging.writeMessage(12, "DFHPI9573E", new Object[]{values});
            }
            this.lar = length / 8;
            this.isAligned = false;
            this.handleVaryingLengthErrors(values, "BIT(x)");
        } else if (values.indexOf(" CHAR ") > -1 || values.indexOf(" CHARACTER ") > -1) {
            this.type = ICM.ICMDataType.CHAR_ARRAY;
            this.lar = this.getSimpleLength(values, fileName);
            if (this.lar < 1) {
                Logging.writeMessage(12, "DFHPI9574E", new Object[]{values});
            }
            if (oldPLI) {
                if (this.lar > Short.MAX_VALUE) {
                    Logging.writeMessage(12, "DFHPI9631E", new Object[]{this.name, Integer.toString(this.lar), ICM.LANGUAGE_TYPES[6], "32767"});
                }
            } else {
                int maxCharArraySize = ParmChecker.getMaxCharArraySize(this.props);
                if (this.lar > maxCharArraySize) {
                    Logging.writeMessage(12, "DFHPI9631E", new Object[]{this.name, Integer.toString(this.lar), ICM.LANGUAGE_TYPES[2], String.valueOf(maxCharArraySize)});
                }
            }
            this.isAligned = false;
            this.handleVaryingLength(defaultMappingStrategy, oldPLI, values);
        } else if (values.indexOf(" WIDECHAR ") > -1 || values.indexOf(" WCHAR ") > -1 || (values.indexOf(" GRAPHIC ") > -1 || values.indexOf(" G ") > -1) && !MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
            this.type = ICM.ICMDataType.HEX_ARRAY;
            if (values.indexOf(" WIDECHAR ") > -1 || values.indexOf(" WCHAR ") > -1) {
                this.comments = "Derived from PL/I WIDECHAR type";
                if (oldPLI) {
                    Logging.writeMessage(12, "DFHPI9618E", new Object[]{"WIDECHAR"});
                }
                if (MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel)) {
                    this.type = ICM.ICMDataType.UTF16_CHAR_ARRAY;
                    this.props.setProperty("UTF-16", Boolean.TRUE.toString());
                }
            } else {
                this.comments = "Derived from PL/I GRAPHIC type";
            }
            this.lar = this.getSimpleLength(values, fileName);
            if (this.lar > 16383) {
                int lang = 2;
                if (oldPLI) {
                    lang = 6;
                }
                Logging.writeMessage(12, "DFHPI9631E", new Object[]{this.name, Integer.toString(this.lar), ICM.LANGUAGE_TYPES[lang], "16383"});
            }
            if (this.type == ICM.ICMDataType.UTF16_CHAR_ARRAY) {
                this.handleVaryingLength(defaultMappingStrategy, oldPLI, values);
            } else {
                this.lar *= 2;
                this.handleVaryingLengthErrors(values, "WIDECHAR(x)");
            }
            this.isAligned = false;
        } else if ((values.indexOf(" GRAPHIC ") > -1 || values.indexOf(" G ") > -1) && MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
            this.type = ICM.ICMDataType.WIDE_CHAR_ARRAY;
            this.lar = this.getSimpleLength(values, fileName);
            if (this.lar > 16383) {
                int lang = 2;
                if (oldPLI) {
                    lang = 6;
                }
                Logging.writeMessage(12, "DFHPI9631E", new Object[]{this.name, Integer.toString(this.lar), ICM.LANGUAGE_TYPES[lang], "16383"});
            }
            this.isAligned = false;
            this.handleVaryingLength(defaultMappingStrategy, oldPLI, values);
        } else if (values.indexOf(" ORDINAL ") > -1) {
            if (oldPLI) {
                Logging.writeMessage(12, "DFHPI9572E", new Object[]{values});
            }
            this.type = ICM.ICMDataType.ENUM;
            Logging.writeMessage(4, "DFHPI9571W", new Object[]{values});
            this.isAligned = true;
        } else {
            this.hasData = false;
        }
        if (values.indexOf(" ALIGNED ") > -1) {
            this.isAligned = true;
            if (!this.hasData) {
                Logging.writeMessage(12, "DFHPI9565E", null);
            }
        }
        if (values.indexOf(" UNALIGNED ") > -1) {
            this.isAligned = false;
            if (!this.hasData) {
                Logging.writeMessage(12, "DFHPI9565E", null);
            }
        }
    }

    private void handleVaryingLength(ICM.VaryingLength defaultMappingStrategy, boolean oldPLI, String inputDataType) {
        this.mappingStrategy = defaultMappingStrategy;
        if (oldPLI && this.mappingStrategy.equals((Object)ICM.VaryingLength.NULL_TERMINATED_CHAR_ARRAY)) {
            --this.lar;
            if (this.lar == 0) {
                this.lar = 1;
                this.mappingStrategy = ICM.VaryingLength.FIXED_LENGTH_ARRAY;
            }
        }
        if (inputDataType.indexOf(" VARYING ") > -1 || inputDataType.indexOf(" VAR ") > -1) {
            if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
                if (this.mappingStrategy.equals((Object)ICM.VaryingLength.NULL_TERMINATED_CHAR_ARRAY)) {
                    ++this.lar;
                }
                this.mappingStrategy = ICM.VaryingLength.VARYING_ARRAY;
                this.isAligned = false;
            } else {
                Logging.writeMessage(12, "DFHPI9540E", new Object[]{"VARYING"});
            }
        }
        if (inputDataType.indexOf(" VARYINGZ ") > -1 || inputDataType.indexOf(" VARZ ") > -1) {
            if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
                if (this.mappingStrategy.equals((Object)ICM.VaryingLength.NULL_TERMINATED_CHAR_ARRAY)) {
                    ++this.lar;
                }
                this.mappingStrategy = ICM.VaryingLength.NULL_TERMINATED_CHAR_ARRAY;
            } else {
                Logging.writeMessage(12, "DFHPI9540E", new Object[]{"VARYINGZ"});
            }
        }
    }

    private void handleVaryingLengthErrors(String inputDataType, String typeForMessage) {
        if (inputDataType.indexOf(" VARYING ") > -1 || inputDataType.indexOf(" VAR ") > -1) {
            Logging.writeMessage(12, "DFHPI9540E", new Object[]{typeForMessage + " VARYING"});
        } else if (inputDataType.indexOf(" VARYINGZ ") > -1 || inputDataType.indexOf(" VARZ ") > -1) {
            Logging.writeMessage(12, "DFHPI9540E", new Object[]{typeForMessage + " VARYINGZ"});
        }
    }

    private void handleFloatingPoint(String value, boolean localUseHexFloat, boolean decimal, boolean oldPLI, String fileName) {
        int length = this.getSimpleLength(value, fileName);
        this.lar = 0;
        this.isAligned = true;
        if (value.indexOf(" IEEE ") > -1) {
            localUseHexFloat = false;
            if (oldPLI) {
                Logging.writeMessage(12, "DFHPI9618E", new Object[]{"IEEE"});
            }
            if (!MappingLevelHelper.supportsMappingLevel_4_0(length)) {
                Logging.writeMessage(12, "DFHPI9540E", new Object[]{"IEEE"});
            }
        }
        if (value.indexOf(" HEXADEC ") > -1) {
            localUseHexFloat = true;
            if (oldPLI) {
                Logging.writeMessage(12, "DFHPI9618E", new Object[]{"HEXADEC"});
            }
        }
        if (decimal) {
            if (length <= 6 && length > 0) {
                this.type = localUseHexFloat ? ICM.ICMDataType.HFP_SHORT : ICM.ICMDataType.BFP_FLOAT;
            } else if (length <= 16 && length > 0) {
                this.type = localUseHexFloat ? ICM.ICMDataType.HFP_LONG : ICM.ICMDataType.BFP_DOUBLE;
            } else {
                Logging.writeMessage(12, "DFHPI9577E", new Object[]{length, value});
            }
        } else if (length <= 21) {
            this.type = localUseHexFloat ? ICM.ICMDataType.HFP_SHORT : ICM.ICMDataType.BFP_FLOAT;
        } else if (length <= 53) {
            this.type = localUseHexFloat ? ICM.ICMDataType.HFP_LONG : ICM.ICMDataType.BFP_DOUBLE;
        } else {
            Logging.writeMessage(12, "DFHPI9577E", new Object[]{length, value});
        }
    }

    protected ICM.VaryingLength getMappingStrategy() {
        return this.mappingStrategy;
    }

    private int getSimpleLength(String s, String fileName) {
        String lengthBit;
        int closePos;
        int length = 1;
        int openPos = s.indexOf("(");
        if (openPos > -1 && (closePos = s.indexOf(")")) > -1 && (lengthBit = s.substring(openPos + 1, closePos)).indexOf(42) <= -1 && lengthBit.indexOf("REFER") <= -1) {
            length = Util.stringToInt(lengthBit, 1, fileName);
        }
        return length;
    }

    private int getBINARYLength(String s, boolean signed, String fileName) {
        int closePos;
        int p = 31;
        int q = 0;
        int numBytes = 0;
        int openPos = s.indexOf("(");
        if (openPos > -1 && (closePos = s.indexOf(")")) > -1) {
            String lengthBit = s.substring(openPos + 1, closePos);
            if (lengthBit.indexOf(",") > -1) {
                StringTokenizer val = new StringTokenizer(lengthBit, ",");
                String pString = (String)val.nextElement();
                String qString = (String)val.nextElement();
                p = Util.stringToInt(pString, 1, fileName);
                q = Util.stringToInt(qString, 0, fileName);
                if (q != 0) {
                    Logging.writeMessage(12, "DFHPI9576E", new Object[]{s});
                }
            } else {
                p = Util.stringToInt(lengthBit, 1, fileName);
            }
        }
        if (signed) {
            if (p <= 7) {
                numBytes = 1;
            } else if (7 < p && p <= 15) {
                numBytes = 2;
            } else if (15 < p && p <= 31) {
                numBytes = 4;
            } else if (31 < p && p <= 63) {
                numBytes = 8;
            } else {
                Logging.writeMessage(12, "DFHPI9577E", new Object[]{p, s});
            }
        } else if (p <= 8) {
            numBytes = 1;
        } else if (8 < p && p <= 16) {
            numBytes = 2;
        } else if (16 < p && p <= 32) {
            numBytes = 4;
        } else if (32 < p && p <= 64) {
            numBytes = 8;
        } else {
            Logging.writeMessage(12, "DFHPI9577E", new Object[]{p, s});
        }
        return numBytes;
    }

    private void setDECIMALLengths(String s, boolean oldPLI, String fileName) {
        int closePos;
        int p = 31;
        if (oldPLI) {
            p = 15;
        }
        int q = 0;
        int openPos = s.indexOf("(");
        if (openPos > -1 && (closePos = s.indexOf(")")) > -1) {
            String lengthBit = s.substring(openPos + 1, closePos);
            if (lengthBit.indexOf(",") > -1) {
                StringTokenizer val = new StringTokenizer(lengthBit, ",");
                String pString = (String)val.nextElement();
                String qString = (String)val.nextElement();
                p = Util.stringToInt(pString, 1, fileName);
                q = Util.stringToInt(qString, 0, fileName);
                if (q > p) {
                    Logging.writeMessage(12, "DFHPI9578E", new Object[]{s});
                    q = 0;
                } else if (q < 0) {
                    Logging.writeMessage(12, "DFHPI9579E", new Object[]{s});
                    q = 0;
                }
            } else {
                p = Util.stringToInt(lengthBit, 1, fileName);
            }
        }
        if (p > 31) {
            Logging.writeMessage(12, "DFHPI9567E", new Object[]{p});
        }
        if (oldPLI && p > 15) {
            Logging.writeMessage(12, "DFHPI9567E", new Object[]{p});
        }
        this.lar = p;
        this.fractions = q;
    }

    private void reportUnsupportedKeywords(String s, boolean oldPLI) {
        s = s.toUpperCase();
        s = " " + s + " ";
        if ((s.indexOf(" PRECISION") > -1 || s.indexOf(" PREC") > -1) && oldPLI) {
            Logging.writeMessage(12, "DFHPI9618E", new Object[]{"PRECISION"});
        }
        if (!MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel) && s.indexOf(" FLOAT ") != -1) {
            Logging.writeMessage(12, "DFHPI9540E", new Object[]{"FLOAT"});
            return;
        }
        for (int i = 0; i < ns.size(); ++i) {
            String word = ns.get(i);
            if (s.indexOf(word) <= -1) continue;
            Logging.writeMessage(12, "DFHPI9540E", new Object[]{word});
        }
    }

    protected boolean hasData() {
        return this.hasData;
    }

    protected ICM.ICMDataType getType() {
        return this.type;
    }

    protected int getLAR() {
        return this.lar;
    }

    protected int getFractions() {
        return this.fractions;
    }

    protected String getComments() {
        return this.comments;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    static {
        ns.add(" COMPLEX ");
        ns.add(" LIKE ");
        ns.add(" AREA ");
        ns.add(" OFFSET ");
        ns.add(" POINTER ");
        ns.add(" PTR ");
        ns.add(" HANDLE ");
        ns.add(" LABEL ");
        ns.add(" TASK ");
        ns.add(" FILE ");
        ns.add(" REFER ");
        ns.add(" PICTURE ");
        ns.add(" PIC ");
        ns.add(" TYPE ");
        ns.add(" LITTLEENDIAN ");
        ns.add(" BASED ");
    }
}

