/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.pl1;

public class PLIWordBreaker {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private String word;
    private String remainder;

    public String getWord() {
        return this.word;
    }

    public String getRemainder() {
        return this.remainder;
    }

    public boolean getNextWord(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int splitPos = this.findBreakPosition(s);
        if (splitPos < s.length()) {
            this.word = s.substring(0, splitPos);
            this.remainder = s.substring(splitPos).trim();
            return true;
        }
        return false;
    }

    private int findBreakPosition(String s) {
        int i = 0;
        char c = s.charAt(0);
        switch (c) {
            case '(': {
                i = this.findClosingBracket(s);
                break;
            }
            case '\'': {
                i = this.findClosingQuote(s);
                break;
            }
            case ',': 
            case ';': {
                i = 1;
                break;
            }
            default: {
                i = this.findEndOfWord(s);
            }
        }
        return i;
    }

    private int findEndOfWord(String s) {
        boolean stop = false;
        int i = 0;
        for (i = 0; i < s.length() && !stop; ++i) {
            char c = s.charAt(i);
            if (c != ' ' && c != '(' && c != ',' && c != ';') continue;
            stop = true;
        }
        if (stop) {
            --i;
        }
        return i;
    }

    private int findClosingQuote(String s) {
        return s.indexOf(39, 1) + 1;
    }

    private int findClosingBracket(String s) {
        int level = 1;
        boolean stop = false;
        boolean inQuote = false;
        int i = 1;
        for (i = 1; i < s.length() && !stop; ++i) {
            char c = s.charAt(i);
            if (c == '(' && !inQuote) {
                ++level;
            } else if (c == ')' & !inQuote) {
                --level;
            } else if (c == '\'') {
                boolean bl = inQuote = !inQuote;
            }
            if (level != 0) continue;
            stop = true;
        }
        return i;
    }
}

