/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ws2ls;

import com.ibm.cics.schema.ICMFixedRepeatEntry;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.wsdl.ws2ls.Element;
import com.ibm.cics.wsdl.ws2ls.IElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;

public class Block
implements IElement {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2022 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String DFH_WRAPPER = "DFHWrapper";
    private static final String DCL_01 = "Dcl 01";
    private static final int COBOL_COMMENT_COLUMN = 6;
    protected static final boolean INNER_BLOCK = true;
    protected static final boolean OUTER_BLOCK = false;
    private String name;
    private ArrayList<IElement> elements;
    private Block parent;
    private boolean blockType;
    private int nestingLevel;
    private Stack<ICMFixedRepeatEntry> dimensionStack = new Stack();
    private boolean hasData;
    private Properties inputParms;
    private int mappingLevel;
    private int languageType;
    private String pdsName;
    private boolean response;
    private int endNonStrucRepeatsNeeded = 0;
    private static int level = 0;
    private static boolean jsonMessages = false;
    private static final int SKIP_LEVEL = 2;

    Block(String theName, Block theParent, boolean theBlockType, int theNestingLevel, int mappingLevel, Properties inputParms, int languageType, String pdsName, boolean response) {
        this.name = theName;
        this.parent = theParent;
        this.hasData = false;
        this.blockType = theBlockType;
        this.nestingLevel = theNestingLevel;
        this.elements = new ArrayList();
        this.mappingLevel = mappingLevel;
        this.inputParms = inputParms;
        this.languageType = languageType;
        this.pdsName = pdsName;
        this.response = response;
    }

    public final String getName() {
        return this.name;
    }

    public final Block getParent() {
        return this.parent;
    }

    @Override
    public final void getElements(List<String> list) {
        int firstElement = 0;
        int lastElement = this.elements.size();
        if (jsonMessages && ++level == 2) {
            boolean suppressDFHWrapper = true;
            if (lastElement > 0) {
                IElement first = this.elements.get(0);
                if (this.languageType == 3) {
                    first = this.elements.get(lastElement - 2);
                }
                if (first.getType() == 2) {
                    Element firstEl = (Element)first;
                    String firstLine = firstEl.getLine();
                    if (firstLine.contains(" OCCURS ")) {
                        suppressDFHWrapper = false;
                    } else if (firstLine.contains("(")) {
                        suppressDFHWrapper = false;
                    } else if (firstLine.contains("[")) {
                        suppressDFHWrapper = false;
                    }
                }
            }
            if (suppressDFHWrapper) {
                ++firstElement;
                if (this.languageType == 3) {
                    ++firstElement;
                    lastElement -= 2;
                }
            }
        }
        if (jsonMessages && MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && this.inputParms.getProperty("ZOS-CONNECT-EE").equals("true")) {
            firstElement = 0;
            if (this.name.equals(DFH_WRAPPER)) {
                lastElement = this.updatePrimaryStructure(lastElement, this.elements);
            } else if (this.response && this.languageType == 2) {
                boolean inComment = false;
                for (int i = 0; i < this.elements.size(); ++i) {
                    int dcl01;
                    IElement e = this.elements.get(i);
                    if (!(e instanceof Element)) continue;
                    StringBuffer line = new StringBuffer(((Element)e).getLine());
                    if (line.toString().trim().length() > 0 && line.indexOf("/*") > -1) {
                        inComment = true;
                    }
                    if (!inComment && (dcl01 = line.indexOf(DCL_01)) > -1) {
                        int comma = line.indexOf(",");
                        String structName = line.substring(dcl01 + 1 + DCL_01.length(), comma);
                        line.insert(comma, " BASED(" + structName + "_PTR)");
                        ((Element)e).setLine(line.toString());
                        String ptrLine = "    Dcl " + structName + "_PTR PTR;";
                        this.elements.add(i++, new Element(ptrLine));
                        ++lastElement;
                    }
                    if (line.toString().trim().length() <= 0 || line.indexOf("*/") <= -1) continue;
                    inComment = false;
                }
            }
        }
        for (int i = firstElement; i < lastElement; ++i) {
            IElement e = this.elements.get(i);
            e.getElements(list);
        }
    }

    private int updatePrimaryStructure(int lastElement, ArrayList<IElement> blockElements) {
        boolean inComment = false;
        for (int i = 0; i < blockElements.size(); ++i) {
            IElement e = blockElements.get(i);
            if (e instanceof Element) {
                StringBuffer line = new StringBuffer(((Element)e).getLine());
                if (this.languageType == 1) {
                    if (line.toString().trim().length() < 6 || line.charAt(6) == '*') continue;
                    line.delete(0, 1);
                    int pos = line.indexOf(DFH_WRAPPER);
                    if (pos > -1) {
                        line.replace(pos, pos + DFH_WRAPPER.length() + 1, "BAQBASE-" + this.pdsName + ".");
                    }
                    for (pos = 0; pos < line.length(); ++pos) {
                        if (line.charAt(pos) == ' ') continue;
                        int level = Integer.parseInt(line.substring(pos, pos + 2));
                        int newLevel = level == 3 ? 1 : level - 3;
                        line.replace(pos, pos + 2, newLevel < 10 ? "0" + newLevel : "" + newLevel);
                        break;
                    }
                    ((Element)e).setLine(line.toString());
                    continue;
                }
                if (this.languageType != 2) continue;
                if (line.toString().trim().length() > 0 && line.indexOf("/*") > -1) {
                    inComment = true;
                }
                if (!inComment) {
                    line.delete(0, 1);
                    int wrapper = line.indexOf(DFH_WRAPPER);
                    if (wrapper > -1) {
                        if (this.response) {
                            line.replace(wrapper, wrapper + DFH_WRAPPER.length() + 1, "BAQBASE_" + this.pdsName + " BASED(BAQBASE_" + this.pdsName + "_PTR),");
                            String ptrLine = "    Dcl BAQBASE_" + this.pdsName + "_PTR PTR;";
                            blockElements.add(i++, new Element(ptrLine));
                            ++lastElement;
                        } else {
                            line.replace(wrapper, wrapper + DFH_WRAPPER.length() + 1, "BAQBASE_" + this.pdsName + ",");
                        }
                    }
                    for (int pos = 0; pos < line.length(); ++pos) {
                        if (line.charAt(pos) == ' ') continue;
                        int level = Integer.parseInt(line.substring(pos, pos + 2));
                        int newLevel = level == 3 ? 1 : level - 3;
                        line.replace(pos, pos + 2, newLevel < 10 ? "0" + newLevel : "" + newLevel);
                        if (wrapper == -1) break;
                        line.insert(4, "Dcl");
                        break;
                    }
                    ((Element)e).setLine(line.toString());
                }
                if (line.toString().trim().length() <= 0 || line.indexOf("*/") <= -1) continue;
                inComment = false;
                continue;
            }
            Block nextBlock = (Block)e;
            lastElement = this.updatePrimaryStructure(lastElement, nextBlock.elements);
        }
        return lastElement;
    }

    public static void startOuterBlock(boolean forJsonMessages) {
        level = 0;
        jsonMessages = forJsonMessages;
    }

    public final Element getLastLine() {
        if (this.elements.size() == 0) {
            return null;
        }
        IElement elem = this.elements.get(this.elements.size() - 1);
        if (elem.getType() == 2) {
            Element e = (Element)elem;
            String line = e.getLine();
            if (line.equals(" ")) {
                elem = this.elements.get(this.elements.size() - 2);
            }
            if (elem.getType() == 2) {
                return (Element)elem;
            }
        }
        return ((Block)elem).getLastLine();
    }

    public final Element getLastLineWithCommaAtEnd() {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            Element e;
            String line;
            IElement elem = this.elements.get(i);
            if (elem.getType() == 1) {
                return ((Block)elem).getLastLineWithCommaAtEnd();
            }
            if (elem.getType() != 2 || !(line = (e = (Element)elem).getLine()).trim().endsWith(",")) continue;
            return (Element)elem;
        }
        return null;
    }

    public final void addElement(String s) {
        this.elements.add(new Element(s));
    }

    public final void removeBlock(Block b) {
        this.elements.remove(b);
    }

    public final void addDataElement(String s) {
        this.hasData = true;
        this.elements.add(new Element(s));
    }

    public final void addElements(List<String> newElements) {
        Iterator<String> it = newElements.iterator();
        while (it.hasNext()) {
            this.elements.add(new Element(it.next()));
        }
    }

    public final void addBlock(Block b) {
        this.elements.add(b);
    }

    public final void addDimensions(Stack<ICMFixedRepeatEntry> dimensions) {
        while (!dimensions.isEmpty()) {
            this.dimensionStack.push(dimensions.pop());
        }
        this.endNonStrucRepeatsNeeded = this.dimensionStack.size();
    }

    public final void decrementEndNonStrucRepeatsOutstanding() {
        --this.endNonStrucRepeatsNeeded;
    }

    public final boolean isNonStrucRepeatsNeeded() {
        return this.endNonStrucRepeatsNeeded > 0;
    }

    public final Stack<ICMFixedRepeatEntry> getDimensions() {
        return this.dimensionStack;
    }

    public final boolean getBlockType() {
        return this.blockType;
    }

    public final int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public final int getType() {
        return 1;
    }

    public final boolean hasData() {
        boolean rc = false;
        if (this.hasData) {
            rc = true;
        } else {
            for (IElement anElement : this.elements) {
                if (anElement.getType() != 1 || !((Block)anElement).hasData()) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }
}

