/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ws2ls;

import com.ibm.cics.wsdl.ws2ls.Block;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class BlockManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private Block currentBlock = null;
    private List<Block> printOrder = new ArrayList<Block>();
    private boolean jsonMessages = false;
    private int mappingLevel;
    private Properties inputParms;
    private int languageType;
    private String pdsName;
    private boolean response;

    public BlockManager(boolean jsonMessages, int mappingLevel, Properties inputParms, int languageType, String pdsName, boolean response) {
        this.jsonMessages = jsonMessages;
        this.mappingLevel = mappingLevel;
        this.inputParms = inputParms;
        this.languageType = languageType;
        this.pdsName = pdsName;
        this.response = response;
    }

    public final Block newBlock(String name, boolean blockType, int nestingLevel) {
        Block block = new Block(name, this.currentBlock, blockType, nestingLevel, this.mappingLevel, this.inputParms, this.languageType, this.pdsName, this.response);
        if (!blockType) {
            this.printOrder.add(block);
        } else {
            this.currentBlock.addBlock(block);
        }
        this.currentBlock = block;
        return this.currentBlock;
    }

    public final Block closeBlock() {
        Block closingBlock = this.currentBlock;
        this.currentBlock = this.currentBlock.getParent();
        if (!closingBlock.hasData()) {
            this.currentBlock.removeBlock(closingBlock);
            this.printOrder.remove(closingBlock);
        }
        return this.currentBlock;
    }

    public final List<String> getElementsForPrinting() {
        ArrayList<String> all = new ArrayList<String>();
        Iterator<Block> it = this.printOrder.iterator();
        Block.startOuterBlock(this.jsonMessages);
        while (it.hasNext()) {
            Block block = it.next();
            block.getElements(all);
            all.add(" ");
        }
        return all;
    }

    public final void removeTopBlock(Block b) {
        this.printOrder.remove(b);
    }
}

