/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ws2ls;

import com.ibm.cics.wsdl.common.Logging;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.StringTokenizer;

public class BootStrapICM {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private PrintWriter out = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateBootStrapICM(String parameters, byte[] theICM, String schema) {
        OutputStreamWriter wr = null;
        StringTokenizer st = new StringTokenizer(parameters, ";");
        String filename = st.nextToken();
        String modName = st.nextToken();
        String relName = st.nextToken();
        try {
            File f = new File(filename);
            wr = new FileWriter(f);
            this.out = new PrintWriter(wr);
            String entryName = this.writeHeader(modName, relName, schema);
            this.writeBody(theICM);
            this.writeEnd(entryName);
        }
        catch (Exception e) {
            e.printStackTrace(Logging.getPrintStream());
        }
        finally {
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException e) {
                    e.printStackTrace(Logging.getPrintStream());
                }
            }
        }
    }

    private String writeHeader(String modName, String release, String schema) {
        String modCode = modName.substring(3);
        StringBuffer entryName = new StringBuffer();
        if (modName.length() < 8) {
            entryName.append(modName);
            entryName.append("1");
        } else {
            entryName.append(modName.substring(0, 7));
            entryName.append("1");
        }
        StringBuffer modNameBuf = new StringBuffer(modName);
        while (modNameBuf.length() < 8) {
            modNameBuf.append(" ");
        }
        modName = modNameBuf.toString();
        while (entryName.length() < 8) {
            entryName.append(" ");
        }
        String yyyy = Integer.toString(Calendar.getInstance().get(1));
        this.println("***********************************************************************");
        this.blankLine();
        this.println("*    MODULE NAME = " + modName + "                                           *");
        this.blankLine();
        this.println("*    AUTHOR      = AUTO GENERATED / PAUL COOPER                       *");
        this.blankLine();
        this.println("*    DESCRIPTIVE NAME = %PRODUCT    Bootstrap ICM                     *");
        this.blankLine();
        this.println("*                                                                     *");
        this.println("*        IBM Confidential                                             *");
        this.println("*                                                                     *");
        this.println("*        OCO Source Materials                                         *");
        this.println("*                                                                     *");
        this.println("*        5655-S97                                                     *");
        this.println("*                                                                     *");
        this.println("*        (C) Copyright IBM Corp. " + yyyy + "                                 *");
        this.println("*                                                                     *");
        this.println("*        The source code for the program is not published             *");
        this.println("*        or otherwise divested of its trade secrets,                  *");
        this.println("*        irrespective of what has been deposited with the             *");
        this.println("*        U.S. Copyright Office.                                       *");
        this.println("*                                                                     *");
        this.println("*        @{[**]copyright.years=" + yyyy + "}                                  *");
        this.println("*                                                                     *");
        this.blankLine();
        this.println("*    STATUS = %" + release + "0                                                   *");
        this.blankLine();
        this.println("* This is an intermediate file generated from source in CMVC.         *");
        this.println("* Please do not alter this module directly. You should instead        *");
        this.println("* regenerate this file using the DFHSC2LS utility.                    *");
        this.blankLine();
        this.println("* To regenerate a Bootstrap ICM you must call DFHSC2LS with the       *");
        this.println("* following parameters:                                               *");
        this.blankLine();
        this.println("*   LANG=PLX                                                          *");
        this.println("*   SCHEMA=" + schema);
        this.println("*   SERVICE=BOOTSTRAP_ICM=filename;" + modName + ";" + release + "                       *");
        this.blankLine();
        this.println("* See testcase 'bootStrapICM.txt' in CMVC for further details.        *");
        this.blankLine();
        this.println("*=====================================================================*");
        this.println("*    CHANGE ACTIVITY :                                                *");
        this.blankLine();
        this.println("*   $MOD(" + modName + "),COMP(COMMAND),PROD(%PRODUCT):                      *");
        this.blankLine();
        this.println("*     PN= REASON REL YYMMDD HDXIII : REMARKS                          *");
        this.println("*    $L0= 936    %EU 080311 HDHCPC : First Generated                  *");
        this.println("*    $L1= 936    %EU 080416 HDHCPC : Add Copyright info               *");
        this.println("*    $L2= 936    %EU 081125 HDHCPC : Moved to ML domain               *");
        this.println("***********************************************************************");
        this.println(modName + " CSECT");
        this.println(modName + " AMODE 31");
        this.println(modName + " RMODE ANY");
        this.println("         ENTRY " + entryName);
        this.println("         DFHVM " + modCode + ",ENTRY=" + entryName);
        this.println(entryName + " DS 0H");
        return entryName.toString();
    }

    private void writeBody(byte[] data) {
        int i = 0;
        while (i < data.length) {
            int chunksize;
            StringBuilder sb = new StringBuilder();
            for (chunksize = 0; chunksize < 25 && i < data.length; ++chunksize, ++i) {
                int currentval = data[i];
                if (currentval < 0) {
                    currentval = 256 + data[i];
                }
                sb.append(this.toPaddedHexString(currentval));
            }
            this.println("         DC    XL" + chunksize + "'" + sb.toString() + "'");
        }
    }

    private void writeEnd(String entryName) {
        this.println("         END " + entryName);
    }

    private String toPaddedHexString(int input) {
        String ret = Integer.toHexString(input);
        if (ret.length() == 1) {
            return "0" + ret;
        }
        return ret;
    }

    private void blankLine() {
        this.println("*                                                                     *");
    }

    private void println(String line) {
        this.out.write(line);
        this.out.write(LINE_SEPARATOR);
    }
}

