/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ws2ls;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMAbstractTypeEndEntry;
import com.ibm.cics.schema.ICMAbstractTypeOptionEntry;
import com.ibm.cics.schema.ICMAbstractTypeStartEntry;
import com.ibm.cics.schema.ICMAttributeEntry;
import com.ibm.cics.schema.ICMChoiceGroupEndEntry;
import com.ibm.cics.schema.ICMChoiceGroupEntry;
import com.ibm.cics.schema.ICMDataElementEntry;
import com.ibm.cics.schema.ICMEndEntry;
import com.ibm.cics.schema.ICMEndRepeatEntry;
import com.ibm.cics.schema.ICMEntry;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMExtendedDataElementEntry;
import com.ibm.cics.schema.ICMExtendedFixedRepeatEntry;
import com.ibm.cics.schema.ICMExtendedVariableRepeatEntry;
import com.ibm.cics.schema.ICMFixedRepeatEntry;
import com.ibm.cics.schema.ICMRawJSONElementEntry;
import com.ibm.cics.schema.ICMRawXMLElementEntry;
import com.ibm.cics.schema.ICMRepeatEntry;
import com.ibm.cics.schema.ICMStartChoiceGroupEntry;
import com.ibm.cics.schema.ICMVariableRepeatEntry;
import com.ibm.cics.schema.util.ByteArray;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.c.MakeC;
import com.ibm.cics.wsdl.cobol.MakeCobol;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.PDSAccessor;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.pl1.MakePL1;
import com.ibm.cics.wsdl.ws2ls.MakeLang;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.xml.namespace.QName;

public class GeneratedLangStruct {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String pdsName;
    private MakeLang langGenerator;
    private Charset codepage = null;
    private String programInterface;
    protected PrintStream log = Logging.getPrintStream();
    private int mappingLevel = -1;
    private boolean usePDSLibs = true;
    private Stack<ICMRepeatEntry> choiceStructureName = new Stack();
    private String elementName = null;
    private Properties inputParms;
    private static final boolean C = true;
    private static final boolean CPP = false;
    private static final int CONTAINER_NAME_LENGTH = 16;
    private boolean nextDEContent = false;
    private static final Charset CHARSET_CP037 = Charset.forName("Cp037");

    public GeneratedLangStruct(String thePDSName, QName artifactName, String structName, String theProgramInterface, ICM.XMLContentType messageType, int lang, Charset codepage, int mappingLevel, int mep, int langStructIncrement, boolean usePDSLibs, boolean zOSPlatform, int tool, Map<QName, String> typeMemberNameMap, Properties theInputParms, boolean response) throws CICSWSDLException {
        this.pdsName = thePDSName;
        this.codepage = codepage;
        this.mappingLevel = mappingLevel;
        this.usePDSLibs = usePDSLibs;
        this.programInterface = theProgramInterface;
        this.inputParms = theInputParms;
        switch (lang) {
            case 1: {
                this.langGenerator = new MakeCobol(messageType, artifactName, this.pdsName, structName, mappingLevel, mep, langStructIncrement, zOSPlatform, tool, typeMemberNameMap, theInputParms, response);
                break;
            }
            case 2: {
                this.langGenerator = new MakePL1(messageType, artifactName, this.pdsName, structName, MakePL1.PLIType.PLI_ENTERPRISE, mappingLevel, mep, langStructIncrement, zOSPlatform, tool, typeMemberNameMap, theInputParms, response);
                break;
            }
            case 6: {
                this.langGenerator = new MakePL1(messageType, artifactName, this.pdsName, structName, MakePL1.PLIType.PLI_OTHER, mappingLevel, mep, langStructIncrement, zOSPlatform, tool, typeMemberNameMap, theInputParms, response);
                break;
            }
            case 7: {
                this.langGenerator = new MakePL1(messageType, artifactName, this.pdsName, structName, MakePL1.PLIType.PLX, mappingLevel, mep, langStructIncrement, zOSPlatform, tool, typeMemberNameMap, theInputParms, response);
                break;
            }
            case 3: {
                this.langGenerator = new MakeC(messageType, artifactName, this.pdsName, structName, true, mappingLevel, mep, langStructIncrement, zOSPlatform, tool, typeMemberNameMap, theInputParms, response);
                break;
            }
            case 4: {
                this.langGenerator = new MakeC(messageType, artifactName, this.pdsName, structName, false, mappingLevel, mep, langStructIncrement, zOSPlatform, tool, typeMemberNameMap, theInputParms, response);
                break;
            }
            default: {
                throw new CICSWSDLException("INTERNAL_ERROR: illegal value for 'LANG' parameter: " + lang);
            }
        }
    }

    public final void write(String pdslib) throws CICSWSDLException, IOException {
        if (!this.usePDSLibs) {
            this.writeToPC(pdslib);
        } else {
            this.writeToPDSLib(pdslib);
        }
    }

    private void writeToPDSLib(String pdslib) throws CICSWSDLException, IOException {
        String filename = pdslib.endsWith("'") ? pdslib.substring(0, pdslib.length() - 1) + "(" + this.pdsName + ")'" : pdslib + "(" + this.pdsName + ")";
        this.log.println(LINE_SEPARATOR);
        try {
            boolean issueReplacedMemberMessage = PDSAccessor.exists(filename);
            OutputStream rs = PDSAccessor.getOutputStreamForPDSMember(filename);
            if (rs == null) {
                return;
            }
            List<String> output = this.prepareForPrinting();
            for (int i = 0; i < output.size(); ++i) {
                String s = output.get(i);
                byte[] b = null;
                b = this.codepage != null ? Util.padBytes(ByteArray.toCodePageByteArray(s, 80, this.codepage)) : Util.padBytes(ByteArray.toCodePageByteArray(s, 80, CHARSET_CP037));
                rs.write(b);
                this.log.println(s);
            }
            rs.close();
            if (issueReplacedMemberMessage) {
                Logging.writeMessage(1, "DFHPI9580I", new Object[]{filename});
            }
        }
        catch (IOException e) {
            String message = e.getLocalizedMessage();
            if (message == null) {
                message = MessageHandler.buildMessage("DFHPI9581E", null);
                IOException newEx = new IOException(message);
                newEx.initCause(e);
                throw newEx;
            }
            IOException newEx = new IOException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{filename, message}));
            newEx.initCause(e);
            throw newEx;
        }
        catch (IllegalArgumentException e) {
            IOException newEx = new IOException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{filename, e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
    }

    private void writeToPC(String pdslib) throws IOException {
        String filename = pdslib + File.separator + this.pdsName;
        this.log.println(LINE_SEPARATOR);
        try (BufferedWriter bw = null;){
            File outFile = new File(filename);
            boolean issueReplacedMemberMessage = false;
            if (outFile.exists()) {
                issueReplacedMemberMessage = true;
            }
            bw = this.codepage != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), this.codepage)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFile)));
            List<String> output = this.prepareForPrinting();
            for (int i = 0; i < output.size(); ++i) {
                String s = output.get(i);
                bw.write(s + LINE_SEPARATOR);
                this.log.println(s);
            }
            if (issueReplacedMemberMessage) {
                Logging.writeMessage(1, "DFHPI9582I", new Object[]{filename});
            }
        }
    }

    private List<String> prepareForPrinting() {
        List<String> output = this.langGenerator.getElementsForPrinting();
        List<String> uncommentedOutput = this.langGenerator.removeCommentsFromStringList(output);
        for (int currentLine = 0; currentLine < output.size() - 1; ++currentLine) {
            String line = output.get(currentLine);
            String linePlusOne = output.get(currentLine + 1);
            if (!line.endsWith(this.langGenerator.getLineTerminator()) || linePlusOne.endsWith(this.langGenerator.getLineTerminator())) continue;
            output.add(currentLine + 1, "");
        }
        uncommentedOutput = this.langGenerator.splitLongLines(uncommentedOutput, 2, 0, this.langGenerator.getMaxLineLength());
        output = this.langGenerator.splitLongLines(output, 1, 0, this.langGenerator.getMaxLineLength());
        output = this.langGenerator.addHeaderFormatting(output);
        output.addAll(uncommentedOutput);
        return output;
    }

    final void generate(ICM icm) throws CICSWSDLException {
        this.log.println(LINE_SEPARATOR + "Language Elements found in generated ICM");
        this.log.println("----------------------------------------");
        List<ICMEntry> contents = null;
        try {
            contents = icm.getContents();
        }
        catch (ICMException exc) {
            CICSWSDLException newEx = icm.getMessages().length < 1 ? new CICSWSDLException(exc.getLocalizedMessage()) : new CICSWSDLException(icm.getMessages());
            newEx.initCause(exc);
            throw newEx;
        }
        for (int j = 0; j < contents.size(); ++j) {
            ICMEntry e = contents.get(j);
            this.parseRecord(e);
        }
        this.langGenerator.markEnd();
    }

    private void parseRecord(ICMEntry icmEntry) throws CICSWSDLException {
        ICM.ICMRecord type = icmEntry.getTypeEnum();
        switch (type) {
            case DATA_ELEMENT_RECORD_TYPE: {
                ICMDataElementEntry der = (ICMDataElementEntry)icmEntry;
                if (this.nextDEContent && this.inputParms.getProperty("LESS-DUP-NAMES") != null && this.inputParms.getProperty("LESS-DUP-NAMES") == "YES") {
                    this.processDataElement(der, this.langGenerator.getContentUniqueName(der.getLocalName(), false), null);
                    this.nextDEContent = false;
                } else {
                    this.processDataElement(der, null, null);
                }
                if (der instanceof ICMExtendedDataElementEntry) {
                    ICMExtendedDataElementEntry eder = (ICMExtendedDataElementEntry)der;
                    if (eder.getAttributes() == null) break;
                    this.processAttributes(eder.getAttributes(), der.getLocalName(), der.getSimplifiedXPath());
                    break;
                }
                if (this.elementName != null) break;
                this.elementName = der.getLocalName();
                break;
            }
            case FIXED_REPEAT_RECORD_TYPE: {
                ICMExtendedFixedRepeatEntry efrr;
                this.nextDEContent = false;
                ICMFixedRepeatEntry frr = (ICMFixedRepeatEntry)icmEntry;
                boolean structural = frr.isStructural();
                if (!structural) {
                    ICMDataElementEntry nextDEE;
                    List<ICMAttributeEntry> attributes = frr.getLogicalNextEntry().getAttributes();
                    if (attributes != null && attributes.size() > 0) {
                        structural = true;
                    }
                    ICMEntry next = frr.getLogicalNextEntry();
                    ICMEntry nextButOne = next.getLogicalNextEntry();
                    if (next instanceof ICMDataElementEntry && !(nextButOne instanceof ICMEndRepeatEntry) || next instanceof ICMRawXMLElementEntry || next instanceof ICMStartChoiceGroupEntry || next instanceof ICMAbstractTypeStartEntry) {
                        structural = true;
                    }
                    if (next instanceof ICMDataElementEntry && !this.langGenerator.supportsVarMappingAsOneField() && (nextDEE = (ICMDataElementEntry)next).getVariableLengthMappingStrategyEnum().equals((Object)ICM.VaryingLength.VARYING_ARRAY)) {
                        structural = true;
                    }
                    if (next instanceof ICMDataElementEntry && this.langGenerator.requiresTwoPartBoolean() && (nextDEE = (ICMDataElementEntry)next).getDataTypeEnum().equals((Object)ICM.ICMDataType.BOOLEAN)) {
                        structural = true;
                    }
                    if (structural) {
                        this.nextDEContent = true;
                    }
                } else {
                    this.choiceStructureName.push(frr);
                }
                if (structural) {
                    this.log.println("\tSTRUCTURAL FixedRepeat " + frr.getOccurances() + ", structure name: " + frr.getStructureName());
                } else {
                    this.log.println("\tSINGLE FixedRepeat " + frr.getOccurances() + ", structure name: " + frr.getStructureName());
                }
                this.langGenerator.gotFixedRepeat(frr, structural);
                if (!(frr instanceof ICMExtendedFixedRepeatEntry) || (efrr = (ICMExtendedFixedRepeatEntry)frr).getAttributes() == null) break;
                this.processAttributes(efrr.getAttributes(), efrr.getStructureName(), efrr.getSimplifiedXPath());
                break;
            }
            case VARIABLE_REPEAT_RECORD_TYPE: {
                this.nextDEContent = false;
                if (!this.programInterface.equalsIgnoreCase("CHANNEL") && !this.programInterface.equalsIgnoreCase("NA")) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9583E", null));
                }
                if ("true".equals(this.inputParms.getProperty("DISABLE-CONTAINERS"))) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9730E", null));
                }
                ICMVariableRepeatEntry vr = (ICMVariableRepeatEntry)icmEntry;
                this.log.println("\tVariableRepeat, structure name: " + vr.getStructureName());
                this.langGenerator.gotVarRepeat(vr);
                if (vr instanceof ICMExtendedVariableRepeatEntry) {
                    ICMExtendedVariableRepeatEntry evr = (ICMExtendedVariableRepeatEntry)vr;
                    if (vr.getAttributes() != null) {
                        this.processAttributes(evr.getAttributes(), evr.getStructureName(), evr.getSimplifiedXPath());
                    }
                }
                if (!vr.isStructural()) break;
                this.choiceStructureName.push(vr);
                break;
            }
            case END_REPEAT_RECORD_TYPE: {
                ICMEndEntry end;
                this.log.println("\tEndRepeat");
                this.langGenerator.gotEndRepeat();
                if (this.choiceStructureName.size() <= 0 || (end = this.choiceStructureName.peek().getEndEntry()) != icmEntry) break;
                this.choiceStructureName.pop();
                break;
            }
            case END_DATA_SECTION_TYPE: {
                this.log.println("\tEnd Data Section");
                break;
            }
            case RAW_JSON_RECORD_TYPE: {
                ICMRawJSONElementEntry rjson = (ICMRawJSONElementEntry)icmEntry;
                this.processRawJSONElement(rjson);
                break;
            }
            case RAW_XML_RECORD_TYPE: {
                if (!this.programInterface.equalsIgnoreCase("CHANNEL") && !this.programInterface.equalsIgnoreCase("NA")) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9667E", null));
                }
                ICMRawXMLElementEntry rxml = (ICMRawXMLElementEntry)icmEntry;
                this.processRawXMLElement(rxml);
                break;
            }
            case START_CHOICE_GROUP_ENTRY_TYPE: {
                if (!this.programInterface.equalsIgnoreCase("CHANNEL") && !this.programInterface.equalsIgnoreCase("NA")) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9676E", null));
                }
                this.log.println("   Choice Group Started");
                ICMStartChoiceGroupEntry scg = (ICMStartChoiceGroupEntry)icmEntry;
                if (this.choiceStructureName.size() > 0) {
                    scg.setStructureName(this.choiceStructureName.peek().getStructureName());
                }
                this.langGenerator.gotChoiceStart(scg);
                break;
            }
            case CHOICE_GROUP_ENTRY_START_TYPE: {
                this.log.println("   Choice Group Entry Start");
                ICMChoiceGroupEntry cges = (ICMChoiceGroupEntry)icmEntry;
                ICMEntry nextEntry = cges.getLogicalNextEntry();
                if (nextEntry instanceof ICMRepeatEntry) {
                    this.elementName = ((ICMRepeatEntry)nextEntry).getStructureName();
                } else if (nextEntry instanceof ICMDataElementEntry) {
                    this.elementName = ((ICMDataElementEntry)nextEntry).getLocalName();
                } else if (nextEntry instanceof ICMRawXMLElementEntry) {
                    this.elementName = ((ICMRawXMLElementEntry)nextEntry).getLocalName();
                } else if (nextEntry instanceof ICMStartChoiceGroupEntry) {
                    this.elementName = ((ICMStartChoiceGroupEntry)nextEntry).getStructureName();
                } else if (nextEntry instanceof ICMAbstractTypeStartEntry) {
                    this.elementName = ((ICMAbstractTypeStartEntry)nextEntry).getElementName();
                }
                if (this.elementName == null) {
                    this.elementName = "choice";
                }
                cges.setChoiceStructureName(this.elementName);
                this.elementName = null;
                this.langGenerator.gotChoiceMember((ICMChoiceGroupEntry)icmEntry);
                break;
            }
            case CHOICE_GROUP_ENTRY_END_TYPE: {
                this.log.println("   Choice Group Entry End");
                this.langGenerator.gotChoiceMemberEnd((ICMChoiceGroupEndEntry)icmEntry);
                break;
            }
            case END_CHOICE_GROUP_ENTRY_TYPE: {
                this.log.println("   Choice Group Ended");
                this.langGenerator.gotChoiceEnd();
                break;
            }
            case ABSTRACT_TYPE_START_TYPE: {
                this.log.println("   Abstract Type Start");
                this.langGenerator.gotAbstractType((ICMAbstractTypeStartEntry)icmEntry);
                break;
            }
            case ABSTRACT_TYPE_OPTION_TYPE: {
                this.log.println("   Abstract Type Option");
                this.langGenerator.gotAbstractTypeOption((ICMAbstractTypeOptionEntry)icmEntry);
                break;
            }
            case ABSTRACT_TYPE_END_TYPE: {
                this.log.println("   Abstract Type End");
                this.langGenerator.gotAbstractTypeEnd((ICMAbstractTypeEndEntry)icmEntry);
                break;
            }
            default: {
                if (type.getCode() <= ICM.RECORD_TYPES.length) {
                    throw new CICSWSDLException("INTERNAL_ERROR: Unrecognised ICM.EntryType of value '" + ICM.RECORD_TYPES[type.getCode()] + "'");
                }
                throw new CICSWSDLException("INTERNAL_ERROR: Unrecognised ICM.EntryType of value '" + (Object)((Object)type) + "'");
            }
        }
    }

    private void processAttributes(List<ICMAttributeEntry> attributes, String elName, String simplifiedElementXPath) throws CICSWSDLException {
        for (ICMAttributeEntry attr : attributes) {
            LinkedList<String> comments;
            this.log.println("   Attribute, name: " + attr.getLocalName());
            if (attr.isImplied()) {
                comments = new LinkedList<String>();
                if (attr.isNameSpaceRelevant()) {
                    comments.add(MessageHandler.buildMessage("HLL_COMMENT_ATTR_EB_NS", new Object[]{attr.getLocalName(), attr.getNameSpace(), simplifiedElementXPath}));
                } else {
                    comments.add(MessageHandler.buildMessage("HLL_COMMENT_ATTR_EB", new Object[]{attr.getLocalName(), simplifiedElementXPath}));
                }
                comments.add(MessageHandler.getMessage("HLL_COMMENT_ATTR_EB_BOOL"));
                String name = this.langGenerator.getAttributeExistenceUniqueByteName(attr.getLocalName(), elName, attr.isNillable(), false);
                this.callLangGenerator(name, name, ICM.ICMDataType.BOOLEAN, 0, -1, false, comments, ICM.VaryingLength.NO_VARYING_STRATEGY, false, false, null, -1);
            }
            comments = new LinkedList();
            String attrValueComments = null;
            attrValueComments = attr.isImplied() ? (attr.isNameSpaceRelevant() ? MessageHandler.buildMessage("HLL_COMMENT_ATTR_OPT_NS", new Object[]{attr.getLocalName(), attr.getNameSpace(), simplifiedElementXPath}) : MessageHandler.buildMessage("HLL_COMMENT_ATTR_OPT", new Object[]{attr.getLocalName(), simplifiedElementXPath})) : (attr.isNameSpaceRelevant() ? MessageHandler.buildMessage("HLL_COMMENT_ATTR_REQ_NS", new Object[]{attr.getLocalName(), attr.getNameSpace(), simplifiedElementXPath}) : MessageHandler.buildMessage("HLL_COMMENT_ATTR_REQ", new Object[]{attr.getLocalName(), simplifiedElementXPath}));
            comments.add(attrValueComments);
            if (attr.isNillable()) {
                comments.add(MessageHandler.buildMessage("HLL_COMMENT_ATTR_NILL", new String[]{simplifiedElementXPath}));
            }
            ICMDataElementEntry value = attr.getDataElement();
            this.processDataElement(value, this.langGenerator.getAttributeUniqueName(attr.getLocalName(), elName, attr.isNillable(), false), comments);
        }
    }

    private void processDataElement(ICMDataElementEntry der, String name, List<String> extraComments) throws CICSWSDLException {
        if (name == null) {
            name = der.getLocalName();
        }
        this.log.println("   DataElement, name: " + name);
        List<String> comments = this.getFacets(der.getComments());
        if (der.getDefaultValue() != null && !"".equals(der.getDefaultValue())) {
            comments.add(MessageHandler.buildMessage("HLL_COMMENT_DEF_VALUE", new Object[]{der.getDefaultValue()}));
        }
        ICM.ICMDataType dataType = der.getDataTypeEnum();
        ICM.VaryingLength mappingStrategy = der.getVariableLengthMappingStrategyEnum();
        int length = der.getLAR();
        int fractionDigits = der.getFractionDigits();
        if (dataType.equals((Object)ICM.ICMDataType.CHAR_ARRAY) && der.getEncodingType() == ICM.EncodingType.UTF16BE) {
            dataType = ICM.ICMDataType.UTF16_CHAR_ARRAY;
            length /= 2;
        }
        if (mappingStrategy.equals((Object)ICM.VaryingLength.VARYING_CONTAINER)) {
            dataType = ICM.ICMDataType.CHAR_ARRAY;
            mappingStrategy = ICM.VaryingLength.FIXED_LENGTH_ARRAY;
            length = 16;
            name = this.langGenerator.getContainerFieldName(name);
            if (!this.programInterface.equalsIgnoreCase("CHANNEL") && !this.programInterface.equalsIgnoreCase("NA")) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9617E", null));
            }
            if ("true".equals(this.inputParms.getProperty("DISABLE-CONTAINERS"))) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9730E", null));
            }
            comments.add(MessageHandler.getMessage("HLL_COMMENT_CONT_MAPPING"));
        }
        if (dataType.equals((Object)ICM.ICMDataType.HFP_SHORT) || dataType.equals((Object)ICM.ICMDataType.HFP_LONG)) {
            comments.add(MessageHandler.getMessage("HLL_COMMENT_FLOAT_HEX"));
        }
        if (dataType.equals((Object)ICM.ICMDataType.BFP_FLOAT) || dataType.equals((Object)ICM.ICMDataType.BFP_DOUBLE)) {
            comments.add(MessageHandler.getMessage("HLL_COMMENT_FLOAT_IEEE"));
        }
        if (dataType.equals((Object)ICM.ICMDataType.CHAR_ARRAY) && der.isPureDBCS() && this.langGenerator.supportsPureDBCS()) {
            dataType = ICM.ICMDataType.WIDE_CHAR_ARRAY;
            length /= 2;
        }
        if (extraComments != null) {
            comments.addAll(0, extraComments);
        }
        String odoTargetName = null;
        if (der.getODOTarget() != null) {
            odoTargetName = der.getODOTarget().getLocalName();
        }
        this.callLangGenerator(name, name, dataType, length, fractionDigits, der.getAligned(), comments, mappingStrategy, der.isSignLeading(), der.isSeparateChar(), odoTargetName, der.getMinLength());
    }

    private void processRawXMLElement(ICMRawXMLElementEntry rxml) throws CICSWSDLException {
        String name = rxml.getLocalName();
        this.log.println("   Raw XML Element, name: " + name);
        LinkedList<String> comments = new LinkedList<String>();
        comments.add(MessageHandler.buildMessage("HLL_COMMENT_SCHEMA_TYPE", new Object[]{rxml.getAnyType()}));
        this.langGenerator.storeTopDimension();
        String msg = MessageHandler.buildMessage("HLL_COMMENT_CONT_ANY", new Object[0]);
        comments.add(msg);
        String nameParam = name + this.langGenerator.getNaturalSeperator() + "xml" + this.langGenerator.getNaturalSeperator() + "cont";
        this.langGenerator.gotDataRecord(nameParam, nameParam, ICM.ICMDataType.CHAR_ARRAY, 16, 0, false, comments, ICM.VaryingLength.FIXED_LENGTH_ARRAY, false, false, null, -1);
        this.langGenerator.restoreTopDimension();
        comments.remove(msg);
        msg = MessageHandler.buildMessage("HLL_COMMENT_CONT_ANYNS", new Object[0]);
        comments.add(msg);
        nameParam = name + this.langGenerator.getNaturalSeperator() + "xmlns" + this.langGenerator.getNaturalSeperator() + "cont";
        this.langGenerator.gotDataRecord(nameParam, nameParam, ICM.ICMDataType.CHAR_ARRAY, 16, 0, false, comments, ICM.VaryingLength.FIXED_LENGTH_ARRAY, false, false, null, -1);
    }

    private void processRawJSONElement(ICMRawJSONElementEntry rjson) throws CICSWSDLException {
        String name = rjson.getLocalName();
        this.log.println("   Raw JSON Element, name: " + name);
        LinkedList<String> comments = new LinkedList<String>();
        this.langGenerator.storeTopDimension();
        String msg = MessageHandler.buildMessage("HLL_COMMENT_CONT_ANY_JSON", new Object[0]);
        comments.add(msg);
        String nameParam = name + this.langGenerator.getNaturalSeperator() + "json" + this.langGenerator.getNaturalSeperator() + "property";
        ICM.ICMDataType dataType = ICM.ICMDataType.CHAR_ARRAY;
        if (ICM.EncodingType.UTF16BE.equals((Object)rjson.getEncodingType())) {
            dataType = ICM.ICMDataType.UTF16_CHAR_ARRAY;
        }
        this.langGenerator.gotDataRecord(nameParam, nameParam, dataType, rjson.getLengthOfTargetField(), 0, false, comments, ICM.VaryingLength.FIXED_LENGTH_ARRAY, false, false, null, -1);
        this.langGenerator.restoreTopDimension();
    }

    private void callLangGenerator(String name, String nameForComments, ICM.ICMDataType dataType, int length, int fractionDigits, boolean aligned, List<String> comments, ICM.VaryingLength mappingStrategy, boolean signLeading, boolean separateChar, String odoTargetFieldName, int minLength) throws CICSWSDLException {
        if (dataType.equals((Object)ICM.ICMDataType.BOOLEAN)) {
            comments.add(MessageHandler.getMessage("HLL_COMMENT_BOOL"));
            if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel) && this.langGenerator.requiresTwoPartBoolean()) {
                this.callLangGenerator(this.langGenerator.getNameToUseForFillerFields(), name, ICM.ICMDataType.BIT_ARRAY, 7, 0, false, comments, ICM.VaryingLength.NO_VARYING_STRATEGY, false, false, odoTargetFieldName, minLength);
                length = 1;
                dataType = ICM.ICMDataType.BIT_ARRAY;
                comments.clear();
            }
        }
        this.langGenerator.gotDataRecord(name, nameForComments, dataType, length, fractionDigits, aligned, comments, mappingStrategy, signLeading, separateChar, odoTargetFieldName, minLength);
    }

    private List<String> getFacets(List<String> comments) {
        ArrayList<String> output = new ArrayList<String>();
        for (String comment : comments) {
            comment = comment.replace('[', '(');
            comment = comment.replace(']', ')');
            output.add(comment);
        }
        return output;
    }
}

