/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ws2ls;

import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonFile
extends JSONObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2013, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 1L;
    private static final String JSON_KEYWORD_ANCHOR = "$anchor";
    private static final String JSON_KEYWORD_DYNAMIC_ANCHOR = "$dynamicAnchor";
    private static final String JSON_KEYWORD_DYNAMIC_REF = "$dynamicRef";
    private static final Pattern VALID_$ANCHOR = Pattern.compile("^[A-Za-z_][A-Za-z0-9_\\-\\.]*");
    private static Map<String, String> files = new HashMap<String, String>();
    private Map<String, Object> anchorNodes = new HashMap<String, Object>();
    private String fileName = "";

    public JsonFile(File schemaFile) throws CICSWSDLException, JSONException {
        super(JsonFile.readFile(schemaFile));
        this.fileName = schemaFile.getName();
        this.traverseJSONObject(this);
    }

    private static String readFile(File schemaFile) throws CICSWSDLException {
        if (files.containsKey(schemaFile.getAbsolutePath())) {
            return files.get(schemaFile.getAbsolutePath());
        }
        PrintStream logger = Logging.getPrintStream();
        logger.println();
        logger.println("Processing JSON Schema file: " + schemaFile.getAbsoluteFile());
        logger.println("----------------------------");
        logger.println();
        StringBuffer fileContent = new StringBuffer();
        try (BufferedReader bf = new BufferedReader(new FileReader(schemaFile.getAbsoluteFile()));){
            String line = bf.readLine();
            while (line != null) {
                logger.println(line);
                fileContent.append(line);
                fileContent.append(" ");
                line = bf.readLine();
            }
            logger.println();
            bf.close();
        }
        catch (FileNotFoundException e) {
            CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9528E", new Object[]{schemaFile.getAbsolutePath()}));
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9528E", new Object[]{schemaFile.getAbsolutePath()}));
            ex.initCause(e);
            throw ex;
        }
        files.put(schemaFile.getAbsolutePath(), fileContent.toString());
        return fileContent.toString();
    }

    public Map<String, Object> getAnchorNodes() {
        return this.anchorNodes;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void traverseJSONObject(JSONObject jsonObject) throws CICSWSDLException {
        Iterator jsonObjectIterator = jsonObject.keys();
        while (jsonObjectIterator.hasNext()) {
            String key = (String)jsonObjectIterator.next();
            try {
                Object value = jsonObject.get(key);
                this.findAnchor(key, value, jsonObject);
            }
            catch (JSONException jSONException) {}
        }
    }

    private void traverseJSONArray(String key, JSONArray jsonArray) throws CICSWSDLException {
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                Object value = jsonArray.get(i);
                this.findAnchor(key, value, jsonArray);
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    private void findAnchor(String key, Object value, Object parent) throws CICSWSDLException {
        if (value instanceof JSONArray) {
            this.traverseJSONArray(key, (JSONArray)value);
        } else if (value instanceof JSONObject) {
            this.traverseJSONObject((JSONObject)value);
        }
        if (key.equals(JSON_KEYWORD_DYNAMIC_ANCHOR) || key.equals(JSON_KEYWORD_DYNAMIC_REF)) {
            CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9744E", new Object[]{(String)value}));
            throw ex;
        }
        if (key.equals(JSON_KEYWORD_ANCHOR)) {
            if (this.anchorNodes.containsKey(value)) {
                CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9742E", new Object[]{(String)value}));
                throw ex;
            }
            Matcher m = VALID_$ANCHOR.matcher((String)value);
            if (!m.matches()) {
                CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9743E", new Object[]{(String)value}));
                throw ex;
            }
            this.anchorNodes.put((String)value, parent);
        }
    }
}

