/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ws2ls;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.common.WSBindOperationEntry;
import com.ibm.cics.wsdl.ws2ls.GeneratedLangStruct;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;

public class LangStructManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private List<GeneratedLangStruct> langStructs = new ArrayList<GeneratedLangStruct>();
    private boolean usePDSFiles = true;
    private boolean zOSPlatform = true;

    LangStructManager(boolean usePDSFiles, boolean zOSPlatform) {
        this.usePDSFiles = usePDSFiles;
        this.zOSPlatform = zOSPlatform;
    }

    public final List<GeneratedLangStruct> buildWSDLLangStructs(List<WSBindOperationEntry> ops, Properties p, int mappingLevel, Map<Object, String> REQMEMs, Map<Object, String> RESPMEMs, Map<Object, String> PDSMEMs, int langStructIncrement) throws CICSWSDLException {
        WSBindOperationEntry thisOp;
        int i;
        String language = p.getProperty("LANG");
        String requestName = p.getProperty("REQMEM");
        String responseName = p.getProperty("RESPMEM");
        String requestStructName = p.getProperty("REQUEST_STRUCT");
        String responseStructName = p.getProperty("RESPONSE_STRUCT");
        String programInterface = p.getProperty("PGMINT");
        if (p.getProperty("JSON-SCHEMA-RESTFUL") != null) {
            requestName = p.getProperty("PDSMEM");
        }
        requestStructName = this.getStrucName(requestStructName, requestName);
        responseStructName = this.getStrucName(responseStructName, responseName);
        String memberName = p.getProperty("PDSMEM");
        if (memberName == null) {
            memberName = requestName;
        }
        int lang = Util.getLanguage(language);
        HashMap<QName, String> typeMemberNameMap = new HashMap<QName, String>();
        for (i = 0; i < ops.size(); ++i) {
            thisOp = ops.get(i);
            if (thisOp.getMEP() != 254) continue;
            QName qType = new QName(thisOp.getSignature(), thisOp.getName());
            String formattedMemberName = this.formatName(memberName, i, lang);
            typeMemberNameMap.put(qType, formattedMemberName);
        }
        for (i = 0; i < ops.size(); ++i) {
            thisOp = ops.get(i);
            String pdsEncodingName = p.getProperty("PDSCP");
            Charset pdsEncoding = null;
            if (pdsEncodingName != null) {
                pdsEncoding = Charset.forName(pdsEncodingName);
            }
            if (thisOp.getMEP() != 254) {
                this.buildLangStructSetForArtifact(requestName, i, lang, requestStructName, thisOp.getInputICM(), "DFHPI9584E", thisOp.getName(), programInterface, pdsEncoding, mappingLevel, thisOp.getMEP(), langStructIncrement, REQMEMs, ICM.XMLContentType.SOAP_REQUEST, 0, typeMemberNameMap, p, false);
                thisOp.setInputICM(null);
                if (p.getProperty("JSON-SCHEMA-RESTFUL") == null) {
                    this.buildLangStructSetForArtifact(responseName, i, lang, responseStructName, thisOp.getOutputICM(), "DFHPI9585E", thisOp.getName(), programInterface, pdsEncoding, mappingLevel, thisOp.getMEP(), langStructIncrement, RESPMEMs, ICM.XMLContentType.SOAP_RESPONSE, 0, typeMemberNameMap, p, true);
                }
                thisOp.setOutputICM(null);
                continue;
            }
            String strucName = this.getStrucName(p.getProperty("REQUEST_STRUCT"), memberName);
            QName qType = new QName(thisOp.getSignature(), thisOp.getName());
            this.buildLangStructSetForArtifact(memberName, i, lang, strucName, thisOp.getInputICM(), null, qType, "NA", pdsEncoding, mappingLevel, -1, langStructIncrement, PDSMEMs, ICM.XMLContentType.XML_TYPE, 0, typeMemberNameMap, p, false);
            thisOp.setInputICM(null);
        }
        return this.langStructs;
    }

    public String getStrucName(String complexStructureName, String shortStructureName) {
        String strucName = complexStructureName;
        if (strucName == null || strucName.length() == 0) {
            strucName = shortStructureName;
        }
        return strucName;
    }

    public void buildLangStructSetForArtifact(String memberName, int genNumber, int lang, String structureName, ICM theICM, String errorMsg, Object artifactName, String programInterface, Charset codepage, int mappingLevel, int mep, int langStructIncrement, Map<Object, String> mapOfMemberNames, ICM.XMLContentType messageType, int tool, Map<QName, String> typeMemberNameMap, Properties theInputParms, boolean response) throws CICSWSDLException {
        String formattedMemberName = this.formatName(memberName, genNumber, lang);
        String formattedStructureName = this.formatName(structureName, genNumber, lang);
        if (theICM != null) {
            if (memberName == null) {
                throw new CICSWSDLException(MessageHandler.buildMessage(errorMsg, null));
            }
            QName artifactQName = null;
            artifactQName = artifactName instanceof QName ? (QName)artifactName : new QName(null, artifactName.toString());
            this.buildSingleLangStructSet(formattedMemberName, artifactQName, formattedStructureName, programInterface, messageType, lang, codepage, mappingLevel, mep, langStructIncrement, theICM, tool, typeMemberNameMap, theInputParms, response);
            mapOfMemberNames.put(artifactName, formattedMemberName);
        }
    }

    private void buildSingleLangStructSet(String pdsMemName, QName keyName, String structName, String programInterface, ICM.XMLContentType messageType, int lang, Charset pdsCodePage, int mappingLevel, int messageExchangePattern, int langStructIncrement, ICM theICM, int tool, Map<QName, String> typeMemberNameMap, Properties theInputParms, boolean response) throws CICSWSDLException {
        GeneratedLangStruct gls = new GeneratedLangStruct(pdsMemName, keyName, structName, programInterface, messageType, lang, pdsCodePage, mappingLevel, messageExchangePattern, langStructIncrement, this.usePDSFiles, this.zOSPlatform, tool, typeMemberNameMap, theInputParms, response);
        gls.generate(theICM);
        this.langStructs.add(gls);
    }

    public String formatName(String stub, int generationNumber, int lang) throws CICSWSDLException {
        int ext;
        if (stub != null) {
            switch (lang) {
                case 1: {
                    stub = this.checkStub(stub, 30);
                    break;
                }
                case 2: 
                case 6: 
                case 7: {
                    stub = this.checkStub(stub, 31);
                    break;
                }
                case 3: 
                case 4: {
                    stub = this.checkStub(stub, 50);
                    break;
                }
                default: {
                    throw new CICSWSDLException("INTERNAL_ERROR: Language " + lang + " not recognized.");
                }
            }
        }
        DecimalFormat myFormatter = new DecimalFormat("00");
        String opNum = myFormatter.format(generationNumber + 1);
        String formatted = stub + opNum;
        if (this.usePDSFiles && formatted.length() > 8 && stub != null) {
            formatted = stub + this.compressGenerationNumber(generationNumber + 1, 8 - stub.length());
        }
        if (!this.usePDSFiles && stub != null && (ext = stub.lastIndexOf(".")) != -1) {
            formatted = stub.substring(0, ext) + opNum + stub.substring(ext);
        }
        return formatted;
    }

    private String checkStub(String stub, int maxLen) {
        if (stub.length() > maxLen - 2) {
            stub = stub.substring(0, maxLen - 2);
        }
        return stub;
    }

    private String compressGenerationNumber(int number, int maxDigits) throws CICSWSDLException {
        int numbersPerCharacter;
        String maxDecimalValueString = "";
        for (int i = 0; i < maxDigits; ++i) {
            maxDecimalValueString = maxDecimalValueString + "9";
        }
        int maxDecimalValue = Integer.parseInt(maxDecimalValueString);
        int adjustedSuffix = number - maxDecimalValue - 1;
        int characterPrefix = 65 + adjustedSuffix / (numbersPerCharacter = (int)Math.pow(10.0, maxDigits - 1));
        if (characterPrefix > 90) {
            throw new CICSWSDLException("INTERNAL_ERROR: Unable to uniquely name each copybook.");
        }
        String numericSuffix = "" + adjustedSuffix % numbersPerCharacter;
        while (numericSuffix.length() < maxDigits - 1) {
            numericSuffix = "0" + numericSuffix;
        }
        return (char)characterPrefix + "" + numericSuffix;
    }

    public final void writeLangStructs(String pdslib) throws CICSWSDLException, IOException {
        for (int i = 0; i < this.langStructs.size(); ++i) {
            GeneratedLangStruct ls = this.langStructs.get(i);
            ls.write(pdslib);
        }
    }
}

