/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ws2ls;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMAbstractTypeEndEntry;
import com.ibm.cics.schema.ICMAbstractTypeOptionEntry;
import com.ibm.cics.schema.ICMAbstractTypeStartEntry;
import com.ibm.cics.schema.ICMChoiceGroupEndEntry;
import com.ibm.cics.schema.ICMChoiceGroupEntry;
import com.ibm.cics.schema.ICMDataElementEntry;
import com.ibm.cics.schema.ICMEntry;
import com.ibm.cics.schema.ICMFixedRepeatEntry;
import com.ibm.cics.schema.ICMRepeatEntry;
import com.ibm.cics.schema.ICMStartChoiceGroupEntry;
import com.ibm.cics.schema.ICMVariableRepeatEntry;
import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.schema.utils.UniqueNameGenerator;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.ws2ls.Block;
import com.ibm.cics.wsdl.ws2ls.BlockManager;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public abstract class MakeLang {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private List<Set<String>> allVarNamesInScope = new LinkedList<Set<String>>();
    private Set<String> topLevelVarNames = new TreeSet<String>();
    private Set<String> allContainerNames;
    private Map<String, Boolean> keywords;
    protected BlockManager blockManager;
    protected Block block;
    private boolean isCaseSensitiveLanguage;
    private PrintStream log = Logging.getPrintStream();
    private static final String DFHCOMMAREA = "dfhcommarea";
    private String pdsName;
    protected String structName;
    private String operationName;
    protected int langstructIncrement = 5;
    protected static final int COMMENTS = 1;
    protected static final int CODE = 2;
    private Stack<ICMFixedRepeatEntry> repeatStack = new Stack();
    private ICMFixedRepeatEntry dimensionEntry = null;
    private int simpleEndRepeatsExpected = 0;
    protected int mappingLevel = -1;
    protected boolean runZOS = true;
    private static final boolean CLASH_MSG = true;
    protected static final boolean NO_CLASH_MSG = false;
    private Stack<List<String>> listStack = new Stack();
    private Map<QName, String> typeMemberNameMap;
    private Stack<Integer> currentChoiceValue = new Stack();
    protected Properties inputParms = null;
    private boolean jsonMessages;

    public MakeLang(ICM.XMLContentType messageType, QName artifactName, String thePDSName, String theStructName, Map<String, Boolean> theKeywords, boolean isCaseSensitive, int mappingLevel, int mep, int langStructIncrement, boolean runZOS, int tool, Map<QName, String> typeMemberNameMap, Properties theInputParms, boolean response) {
        this.isCaseSensitiveLanguage = isCaseSensitive;
        this.inputParms = theInputParms;
        this.allVarNamesInScope.add(new TreeSet());
        this.allContainerNames = new TreeSet<String>();
        this.keywords = theKeywords;
        this.pdsName = thePDSName;
        this.runZOS = runZOS;
        int dotPos = this.pdsName.indexOf(46);
        if (dotPos > -1) {
            this.pdsName = this.pdsName.substring(0, dotPos);
        }
        this.operationName = artifactName.getLocalPart();
        this.langstructIncrement = langStructIncrement;
        if (theStructName != null) {
            this.structName = this.ensureValidName(theStructName, true, true, false);
        }
        LinkedList<String> comments = new LinkedList<String>();
        String toolName = theInputParms.getProperty("INTERNAL_TOOLNAME");
        this.jsonMessages = toolName.equals("DFHJS2LS");
        switch (messageType) {
            case SOAP_REQUEST: {
                String jsonSchemaName;
                if (this.jsonMessages) {
                    jsonSchemaName = theInputParms.getProperty("JSON-SCHEMA-REQUEST");
                    String messageNumber = "HLL_COMMENT_TITLE_JSON_REQUEST";
                    this.addHeaderComment(comments, theInputParms, messageNumber, jsonSchemaName);
                    break;
                }
                comments.add(MessageHandler.buildMessage("HLL_COMMENT_TITLE_REQ", new Object[]{this.operationName}));
                break;
            }
            case SOAP_RESPONSE: {
                String jsonSchemaName;
                if (this.jsonMessages) {
                    jsonSchemaName = theInputParms.getProperty("JSON-SCHEMA-RESPONSE");
                    String messageNumber = "HLL_COMMENT_TITLE_JSON_RESPONSE";
                    this.addHeaderComment(comments, theInputParms, messageNumber, jsonSchemaName);
                    break;
                }
                comments.add(MessageHandler.buildMessage("HLL_COMMENT_TITLE_RES", new Object[]{this.operationName}));
                break;
            }
            case XML_ELEMENT: {
                String jsonSchemaName;
                if (this.jsonMessages) {
                    jsonSchemaName = theInputParms.getProperty("JSON-SCHEMA");
                    jsonSchemaName = new File(jsonSchemaName).getName();
                    comments.add(MessageHandler.buildMessage("HLL_COMMENT_TITLE_JSON_ELEMENT", new Object[]{jsonSchemaName}));
                    break;
                }
                comments.add(MessageHandler.buildMessage("HLL_COMMENT_TITLE_ELE", new Object[]{artifactName.getLocalPart(), artifactName.getNamespaceURI()}));
                break;
            }
            case XML_TYPE: {
                String jsonSchemaName;
                if (this.jsonMessages) {
                    jsonSchemaName = theInputParms.getProperty("JSON-SCHEMA");
                    jsonSchemaName = new File(jsonSchemaName).getName();
                    comments.add(MessageHandler.buildMessage("HLL_COMMENT_TITLE_JSON_TYPE", new Object[]{jsonSchemaName}));
                    break;
                }
                comments.add(MessageHandler.buildMessage("HLL_COMMENT_TITLE_TYP", new Object[]{artifactName.getLocalPart(), artifactName.getNamespaceURI()}));
                break;
            }
            default: {
                throw new RuntimeException("INTERNAL ERROR: bad message type - " + (Object)((Object)messageType));
            }
        }
        String mepMsg = null;
        if (!this.jsonMessages) {
            switch (mep) {
                case 2: {
                    mepMsg = "HLL_COMMENT_MEP_INONLY";
                    break;
                }
                case 4: {
                    mepMsg = "HLL_COMMENT_MEP_INOPTOUT";
                    break;
                }
                case 1: {
                    mepMsg = "HLL_COMMENT_MEP_INOUT";
                    break;
                }
                case 3: {
                    mepMsg = "HLL_COMMENT_MEP_ROBUST_INONLY";
                    break;
                }
            }
        }
        if (mepMsg != null) {
            comments.add(MessageHandler.buildMessage(mepMsg, new Object[]{null}));
        }
        if (mappingLevel == 0) {
            mappingLevel = 3;
        }
        this.mappingLevel = mappingLevel;
        comments.add(MessageHandler.buildMessage("HLL_COMMENT_MAPPING_LEVEL", new Object[]{toolName, ICM.MAPPING_LEVELS[mappingLevel]}));
        this.blockManager = new BlockManager(this.jsonMessages, mappingLevel, this.inputParms, this.getLanguageType(), this.pdsName, response);
        this.block = this.blockManager.newBlock(DFHCOMMAREA, false, this.getInitialNestingLevel());
        this.addEntireStructureComments(comments);
        this.typeMemberNameMap = typeMemberNameMap;
    }

    private void addHeaderComment(List<String> comments, Properties theInputParms, String messageNumber, String jsonSchemaName) {
        if (jsonSchemaName == null) {
            jsonSchemaName = theInputParms.getProperty("JSON-SCHEMA-RESTFUL");
            messageNumber = "HLL_COMMENT_TITLE_JSON_RESTFUL";
        }
        jsonSchemaName = new File(jsonSchemaName).getName();
        comments.add(MessageHandler.buildMessage(messageNumber, new Object[]{jsonSchemaName}));
    }

    protected final String ensureValidName(String basename, boolean msg, boolean reserve, boolean topLevelName) {
        String varName = null;
        varName = this.ensureNotKeyword(basename);
        varName = this.ensureValidVariableLength(varName);
        if (this.mustBeUnique(varName = this.ensureValidInLang(varName))) {
            Set<String> varNamesAllocated = this.allVarNamesInScope.get(this.allVarNamesInScope.size() - 1);
            if (topLevelName) {
                varNamesAllocated = this.topLevelVarNames;
            }
            UniqueNameGenerator.UniqueName uniqueName = UniqueNameGenerator.ensureUnique(varNamesAllocated, varName, this.isCaseSensitiveLanguage, this.mappingLevel, false, reserve);
            varName = uniqueName.getName();
            if (uniqueName.getNameClash() && msg) {
                Logging.writeMessage(1, "DFHPI9561I", new Object[]{basename, this.operationName});
            }
        }
        return varName;
    }

    protected final String ensureValidContainerID(String basename) {
        String varName = null;
        varName = this.ensureNotKeyword(basename);
        varName = this.ensureValidInLang(varName);
        varName = this.ensureValidContainerIDLength(varName);
        UniqueNameGenerator.UniqueName uniqueName = UniqueNameGenerator.ensureUnique(this.allContainerNames, varName, this.isCaseSensitiveLanguage, this.mappingLevel, false);
        varName = uniqueName.getName();
        return varName;
    }

    protected String ensureNotKeyword(String basename) {
        String localBaseName = basename;
        if (this.keywords == null) {
            this.log.println("INTERNAL WARNING: Keywords not being checked for because Map has not been initialized for this language.");
            return localBaseName;
        }
        if (this.isCaseSensitiveLanguage) {
            if (this.keywords.get(localBaseName) != null) {
                String mangaledName = "X" + localBaseName;
                Logging.writeMessage(4, "DFHPI9586W", new Object[]{localBaseName, mangaledName});
                localBaseName = mangaledName;
            }
        } else if (this.keywords.get(localBaseName.toUpperCase(Locale.ENGLISH)) != null) {
            String mangaledName = "X" + localBaseName;
            Logging.writeMessage(4, "DFHPI9586W", new Object[]{localBaseName, mangaledName});
            localBaseName = mangaledName;
        }
        return localBaseName;
    }

    protected final List<String> getElementsForPrinting() {
        return this.blockManager.getElementsForPrinting();
    }

    protected final String getMemberName() {
        return this.pdsName;
    }

    protected abstract String getTopLevelStrucName(String var1);

    protected String getTopLevelStrucUniqueName(String baseName, boolean reserve) {
        String candidatename = this.getTopLevelStrucName(baseName);
        candidatename = this.ensureValidVariableLength(candidatename);
        return this.ensureValidName(candidatename, false, reserve, true);
    }

    protected abstract String generateIndentForComments();

    protected abstract void gotFixedRepeat(ICMFixedRepeatEntry var1, boolean var2) throws CICSWSDLException;

    protected void addEntireStructureComments(List<String> comments) {
        Iterator<String> it = comments.iterator();
        while (it.hasNext()) {
            this.addComment(it.next());
        }
        this.block.addElement(" ");
    }

    protected abstract void markEnd();

    protected abstract String ensureValidInLang(String var1);

    protected abstract String ensureValidVariableLength(String var1);

    protected abstract String ensureValidContainerIDLength(String var1);

    protected abstract int getInitialNestingLevel();

    protected abstract int getMaxLineLength();

    protected abstract List<String> removeCommentsFromStringList(List<String> var1);

    protected abstract List<String> addHeaderFormatting(List<String> var1);

    protected final List<String> splitLongLines(List<String> input, int linetype, int lineAdjustment, int maxLength) {
        ArrayList<String> returnList = new ArrayList<String>();
        int maxLineLength = maxLength - lineAdjustment;
        for (int i = 0; i < input.size(); ++i) {
            String s = input.get(i);
            if (s == null) continue;
            while (s.length() > maxLineLength) {
                String indent;
                String subMAX = s.substring(0, maxLineLength);
                int lastSpacePos = subMAX.lastIndexOf(" ");
                if (lastSpacePos < (indent = this.generateIndentForComments()).length() + 4) {
                    lastSpacePos = maxLineLength;
                }
                returnList.add(s.substring(0, lastSpacePos));
                if (linetype == 2) {
                    s = indent + "   " + s.substring(lastSpacePos);
                    continue;
                }
                s = indent + s.substring(lastSpacePos);
            }
            returnList.add(s);
        }
        return returnList;
    }

    protected abstract String getAttributeName(String var1, String var2, boolean var3);

    protected String getAttributeUniqueName(String attrName, String elName, boolean nil, boolean reserve) {
        String candidatename = this.getAttributeName(attrName, elName, nil);
        return this.ensureValidName(candidatename, false, reserve, false);
    }

    protected abstract String getVaryingLengthCountName(String var1);

    protected String getVaryingLengthUniqueCountName(String baseName, boolean reserve) {
        String candidatename = this.getVaryingLengthCountName(baseName);
        return this.ensureValidName(candidatename, false, reserve, false);
    }

    protected abstract String getAttributeExistenceByteName(String var1, String var2, boolean var3);

    protected String getAttributeExistenceUniqueByteName(String attrName, String elName, boolean nil, boolean reserve) {
        String candidatename = this.getAttributeExistenceByteName(attrName, elName, nil);
        return this.ensureValidName(candidatename, false, reserve, false);
    }

    protected abstract String getContainerFieldName(String var1);

    protected abstract String getDescriminatorFieldName(String var1);

    protected String getContainerUniqueFieldName(String baseName, boolean reserve) {
        String candidatename = this.getContainerFieldName(baseName);
        return this.ensureValidName(candidatename, false, reserve, false);
    }

    protected String getDescriminatorUniqueFieldName(String baseName, boolean reserve) {
        String candidatename = this.getDescriminatorFieldName(baseName);
        return this.ensureValidName(candidatename, false, reserve, false);
    }

    protected abstract String getContentName(String var1);

    protected String getContentUniqueName(String baseName, boolean reserve) {
        String candidatename = this.getContentName(baseName);
        return this.ensureValidName(candidatename, false, reserve, false);
    }

    protected abstract String getContainerOccurencesFieldName(String var1, ICMRepeatEntry var2);

    protected String getContainerOccurencesUniqueFieldName(String baseName, boolean reserve, ICMRepeatEntry varRepeat) {
        String candidatename = this.getContainerOccurencesFieldName(baseName, varRepeat);
        return this.ensureValidName(candidatename, false, reserve, false);
    }

    protected abstract int getCommentAdjustment();

    protected void addComment(String comment) {
        String lastLine;
        String[] lines = comment.split("\\r\\n|\\r|\\n");
        List<String> commentsList = new LinkedList<String>();
        if (this.block.getLastLine() != null && (lastLine = this.block.getLastLine().getLine()).endsWith("*/")) {
            lastLine = lastLine.substring(0, lastLine.length() - 3);
            this.block.getLastLine().setLine(lastLine);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i != 0) {
                    line = line.trim();
                }
                line = this.generateIndentForComments() + "   " + line;
                if (i == lines.length - 1) {
                    line = line + " */";
                }
                commentsList.add(line);
            }
        }
        if (commentsList.isEmpty()) {
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i == 0) {
                    line = "/* " + line;
                }
                if (i != 0) {
                    line = line.trim();
                }
                line = this.generateIndentForComments() + line;
                if (i == lines.length - 1) {
                    line = line + " */";
                }
                commentsList.add(line);
            }
        }
        if ((commentsList = this.splitLongLines(commentsList, 2, this.getCommentAdjustment(), this.getMaxLineLength())).size() > 1) {
            Iterator<String> comments = commentsList.iterator();
            while (comments.hasNext()) {
                this.block.addElement(comments.next());
            }
        } else {
            this.block.addElement(commentsList.get(0));
        }
    }

    protected abstract String buildDataLine(String var1, ICM.ICMDataType var2, int var3, int var4, boolean var5, int var6, Stack<ICMFixedRepeatEntry> var7, ICM.VaryingLength var8, boolean var9, boolean var10, String var11, int var12) throws CICSWSDLException;

    protected void gotDataRecord(String name, String nameForComments, ICM.ICMDataType dataType, int lar, int fractions, boolean aligned, List<String> comments, ICM.VaryingLength mappingStrategy, boolean signLeading, boolean separateChar, String odoTargetFieldName, int minLength) throws CICSWSDLException {
        String validName = this.ensureValidName(name, true, true, false);
        if (!comments.isEmpty()) {
            if (nameForComments.equals(name)) {
                this.addComment(MessageHandler.buildMessage("HLL_COMMENT_FIELD_COMMENT", new Object[]{validName}));
            } else {
                String validCommentsName = this.ensureValidName(nameForComments, false, true, false);
                Set<String> currentNames = this.allVarNamesInScope.get(this.allVarNamesInScope.size() - 1);
                currentNames.remove(validCommentsName.toUpperCase(Locale.ENGLISH));
                this.addComment(MessageHandler.buildMessage("HLL_COMMENT_FIELD_COMMENT", new Object[]{validCommentsName}));
            }
            for (String comment : comments) {
                this.addComment(comment);
            }
        }
        if (!mappingStrategy.equals((Object)ICM.VaryingLength.FIXED_LENGTH_ARRAY)) {
            if (mappingStrategy.equals((Object)ICM.VaryingLength.NULL_TERMINATED_CHAR_ARRAY)) {
                ++lar;
                this.addComment(MessageHandler.buildMessage("HLL_COMMENT_NULL_TERM_MAPPING", null));
            } else if (mappingStrategy.equals((Object)ICM.VaryingLength.VARYING_ARRAY)) {
                this.addComment(MessageHandler.buildMessage("HLL_COMMENT_VARYING_MAPPING", null));
                if (!this.supportsVarMappingAsOneField()) {
                    String lengthLine = this.buildDataLine(this.getVaryingLengthUniqueCountName(validName, true), ICM.ICMDataType.SHORT, 0, 0, aligned, this.block.getNestingLevel() + 1, this.repeatStack, ICM.VaryingLength.NO_VARYING_STRATEGY, signLeading, separateChar, odoTargetFieldName, minLength);
                    this.block.addDataElement(lengthLine);
                }
            }
        }
        this.simpleEndRepeatsExpected = this.repeatStack.size();
        String line = this.buildDataLine(validName, dataType, lar, fractions, aligned, this.block.getNestingLevel() + 1, this.repeatStack, mappingStrategy, signLeading, separateChar, odoTargetFieldName, minLength);
        this.block.addDataElement(line);
    }

    protected abstract String getLineTerminator();

    protected abstract String getNaturalSeperator();

    protected boolean supportsVarMappingAsOneField() {
        return false;
    }

    protected abstract String buildContainerNumberLine(String var1, int var2, ICMRepeatEntry var3) throws CICSWSDLException;

    protected abstract String buildContainerNameLine(String var1, int var2) throws CICSWSDLException;

    protected abstract String buildDescriminatorNameLine(String var1, int var2) throws CICSWSDLException;

    private String buildContainerLine(String contid, String strucName, ICMRepeatEntry varRepeat) throws CICSWSDLException {
        if (!this.block.getLastLine().getLine().equals(" ")) {
            this.block.addElement(" ");
        }
        String theLine = null;
        if (varRepeat instanceof ICMVariableRepeatEntry) {
            if (this.jsonMessages) {
                String comment;
                String message;
                boolean existence = false;
                boolean dataarea = false;
                if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && this.inputParms.getProperty("ZOS-CONNECT-EE").equals("true")) {
                    String name;
                    dataarea = true;
                    if (this.inputParms.containsKey("CONTAINER-NAME-SUFFIX") && !this.inputParms.getProperty("CONTAINER-NAME-SUFFIX").equals("dataarea")) {
                        dataarea = false;
                    }
                    if ((name = strucName.substring(strucName.indexOf(45) + 1)).length() == this.structName.length()) {
                        name = strucName.substring(strucName.indexOf(95) + 1);
                    }
                    if (!varRepeat.isOptionalArray() && Util.isResponseCodeEntity(name)) {
                        existence = true;
                    } else if (varRepeat.getMinOccurance() == 0 && varRepeat.getMaxOccurance() == 1) {
                        existence = true;
                    }
                }
                if (existence) {
                    message = dataarea ? "HLL_COMMENT_JSON_DATAAREA_EXISTENCE" : "HLL_COMMENT_JSON_CONT_EXISTENCE";
                    comment = MessageHandler.buildMessage(message, new Object[]{this.getContainerUniqueFieldName(contid, false), strucName, varRepeat.getJsonKeyword()});
                } else {
                    message = dataarea ? "HLL_COMMENT_JSON_DATAAREA" : "HLL_COMMENT_JSON_CONT";
                    comment = MessageHandler.buildMessage(message, new Object[]{this.getContainerUniqueFieldName(contid, false), this.getContainerOccurencesUniqueFieldName(contid, false, varRepeat), strucName, varRepeat.getJsonKeyword()});
                }
                this.addComment(comment);
            } else {
                this.addComment(MessageHandler.buildMessage("HLL_COMMENT_CONT", new Object[]{this.getContainerUniqueFieldName(contid, false), this.getContainerOccurencesUniqueFieldName(contid, false, varRepeat), strucName, varRepeat.getSimplifiedXPath()}));
            }
        } else if (this.jsonMessages) {
            if (varRepeat.getMaxOccurance() == 1 && varRepeat.getMinOccurance() == 0) {
                if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                    this.addComment(MessageHandler.buildMessage("HLL_COMMENT_JSON_OPT_EXISTENCE", new Object[]{varRepeat.getJsonKeyword(), this.getContainerOccurencesUniqueFieldName(contid, false, varRepeat)}));
                } else {
                    this.addComment(MessageHandler.buildMessage("HLL_COMMENT_JSON_OPT", new Object[]{varRepeat.getJsonKeyword(), this.getContainerOccurencesUniqueFieldName(contid, false, varRepeat)}));
                }
            } else {
                this.addComment(MessageHandler.buildMessage("HLL_COMMENT_JSON_ARRAY", new Object[]{strucName, varRepeat.getJsonKeyword(), this.getContainerOccurencesUniqueFieldName(contid, false, varRepeat)}));
            }
        } else {
            this.addComment(MessageHandler.buildMessage("HLL_COMMENT_ARRAY", new Object[]{strucName, varRepeat.getSimplifiedXPath(), this.getContainerOccurencesUniqueFieldName(contid, false, varRepeat)}));
        }
        if (varRepeat.isPartOfAChoiceGroup()) {
            this.addComment(MessageHandler.buildMessage("HLL_COMMENT_CHOICE_NUM", new Object[]{varRepeat.getOptionNumber(), varRepeat.getTotalNumberOfOptions()}));
            this.addComment(MessageHandler.getMessage("HLL_COMMENT_CHOICE_ONE"));
            this.addComment(MessageHandler.getMessage("HLL_COMMENT_CHOICE_CARD"));
        }
        if (varRepeat.isPartOfOptionalModelGroup()) {
            this.addComment(MessageHandler.buildMessage("HLL_COMMENT_OPTIONAL_NUM", new Object[]{varRepeat.getOptionNumber(), varRepeat.getTotalNumberOfOptions()}));
            this.addComment(MessageHandler.getMessage("HLL_COMMENT_OPTIONAL_ALL_NONE"));
            this.addComment(MessageHandler.getMessage("HLL_COMMENT_CHOICE_CARD"));
        }
        boolean displayMinMaxMessage = true;
        if (varRepeat.getMinOccurance() == 0 && varRepeat.getMaxOccurance() == 1 && MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
            displayMinMaxMessage = false;
        }
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && this.inputParms.getProperty("ZOS-CONNECT-EE").equals("true")) {
            String name = strucName.substring(strucName.indexOf(45) + 1);
            if (name.length() == this.structName.length()) {
                name = strucName.substring(strucName.indexOf(95) + 1);
            }
            if (!varRepeat.isOptionalArray() && Util.isResponseCodeEntity(name)) {
                displayMinMaxMessage = false;
            }
        }
        if (displayMinMaxMessage) {
            this.addComment(MessageHandler.buildMessage("HLL_COMMENT_VAR_MIN", new Object[]{varRepeat.getMinOccurance()}));
            if (varRepeat.getMaxOccurance() == -1) {
                this.addComment(MessageHandler.buildMessage("HLL_COMMENT_VAR_MAX2", new Object[]{varRepeat.getMaxOccurance()}));
            } else {
                this.addComment(MessageHandler.buildMessage("HLL_COMMENT_VAR_MAX", new Object[]{varRepeat.getMaxOccurance()}));
            }
        }
        theLine = this.buildContainerNumberLine(contid, this.block.getNestingLevel() + 1, varRepeat);
        this.block.addElement(theLine);
        String containerName = null;
        if (varRepeat instanceof ICMVariableRepeatEntry) {
            containerName = this.getContainerUniqueFieldName(contid, false);
            theLine = this.buildContainerNameLine(contid, this.block.getNestingLevel() + 1);
            this.block.addDataElement(theLine);
        }
        this.block.addElement(" ");
        return containerName;
    }

    protected abstract void buildOuterStructLine(String var1) throws CICSWSDLException;

    protected abstract String buildEnumerationValueLine(String var1, String var2) throws CICSWSDLException;

    protected void gotVarRepeat(ICMVariableRepeatEntry varRepeat) throws CICSWSDLException {
        String uniqueName = null;
        if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel) && !varRepeat.isStructural()) {
            ICMEntry next = varRepeat.getLogicalNextEntry();
            if (next instanceof ICMFixedRepeatEntry) {
                ICMFixedRepeatEntry nextFR = (ICMFixedRepeatEntry)next;
                uniqueName = this.ensureValidContainerID(nextFR.getStructureName());
            }
            if (next instanceof ICMDataElementEntry) {
                ICMDataElementEntry nextDE = (ICMDataElementEntry)next;
                uniqueName = this.ensureValidContainerID(nextDE.getLocalName());
            }
        }
        if (uniqueName == null) {
            uniqueName = this.ensureValidContainerID(varRepeat.getStructureName());
        }
        String strucName = this.getTopLevelStrucUniqueName(uniqueName, true);
        String containerNameVar = this.buildContainerLine(uniqueName, strucName, varRepeat);
        this.block = this.blockManager.newBlock(uniqueName, false, 1);
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && this.inputParms.getProperty("ZOS-CONNECT-EE").equals("true")) {
            this.addComment(MessageHandler.buildMessage("HLL_COMMENT_STRUC_COMMENT_ZCEE", new Object[]{containerNameVar}));
        } else {
            this.addComment(MessageHandler.buildMessage("HLL_COMMENT_STRUC_COMMENT", new Object[]{containerNameVar}));
        }
        if (varRepeat.isPartOfAChoiceGroup()) {
            this.addComment(MessageHandler.getMessage("HLL_COMMENT_CHOICE_OPTION"));
        }
        if (varRepeat.isPartOfOptionalModelGroup()) {
            this.addComment(MessageHandler.getMessage("HLL_COMMENT_OPTIONAL_OPTION"));
        }
        this.buildOuterStructLine(strucName);
        if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel)) {
            this.allVarNamesInScope.add(new TreeSet());
        }
    }

    protected final void gotFixedRepeat(ICMFixedRepeatEntry fixRepeat, boolean isStructural, int mergeLevel) throws CICSWSDLException {
        String localName = null;
        if (fixRepeat.isVariablyRepeating()) {
            localName = this.ensureValidName(fixRepeat.getStructureName(), true, false, false);
            this.buildContainerLine(localName, localName, fixRepeat);
        }
        if (isStructural || mergeLevel <= this.repeatStack.size()) {
            localName = this.ensureValidName(fixRepeat.getStructureName(), true, true, false);
            this.block = this.blockManager.newBlock(localName, true, this.block.getNestingLevel() + 1);
            this.repeatStack.push(fixRepeat);
            this.block.addDimensions(this.repeatStack);
            this.buildStructLine(localName, this.block.getNestingLevel(), this.block.getDimensions());
            this.block.decrementEndNonStrucRepeatsOutstanding();
            if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel) && this.supportsNameClashes()) {
                this.allVarNamesInScope.add(new TreeSet());
            }
        } else {
            this.repeatStack.push(fixRepeat);
        }
    }

    protected void gotChoiceStart(ICMStartChoiceGroupEntry scg) throws CICSWSDLException {
        this.block.addDataElement(" ");
        String lsName = scg.getStructureName();
        if (lsName == null) {
            lsName = this.pdsName;
        }
        String lsEnum = this.getDescriminatorUniqueFieldName(lsName, false);
        String lsCont = this.getContainerUniqueFieldName(lsName, false);
        this.addComment(MessageHandler.buildMessage("HLL_COMMENT_CHOICE_START", new Object[]{lsEnum, lsCont}));
        this.addComment(MessageHandler.getMessage("HLL_COMMENT_CHOICE_EMPTY"));
        ArrayList<String> enumList = new ArrayList<String>();
        enumList.add(lsName);
        this.listStack.push(enumList);
        String enumLine = this.buildEnumerationValueLine("empty", "00");
        if (enumLine != null) {
            enumList.add(enumLine);
        }
        this.currentChoiceValue.push(-1);
    }

    protected void gotChoiceEnd() throws CICSWSDLException {
        int currentChoiceVal = this.currentChoiceValue.pop();
        if (currentChoiceVal != -1) {
            this.closeChoiceMember();
        }
        List<String> enumList = this.listStack.pop();
        String lsName = enumList.get(0);
        enumList.remove(0);
        Iterator<String> i = enumList.iterator();
        this.block.addDataElement(this.buildDescriminatorNameLine(lsName, this.block.getNestingLevel() + 1));
        while (i.hasNext()) {
            this.block.addElement(i.next());
        }
        this.block.addDataElement(this.buildContainerNameLine(lsName, this.block.getNestingLevel() + 1));
    }

    private void closeChoiceMember() {
        this.closeOuterBlock();
        this.block = this.blockManager.closeBlock();
        this.allVarNamesInScope.remove(this.allVarNamesInScope.size() - 1);
        this.currentChoiceValue.pop();
    }

    protected void gotChoiceMember(ICMChoiceGroupEntry cge) throws CICSWSDLException {
        String uniqueName = this.ensureValidContainerID(cge.getChoiceStructureName());
        String strucName = this.getTopLevelStrucUniqueName(uniqueName, true);
        String hexString = Integer.toHexString(cge.getChoiceValue());
        if (hexString.length() == 1) {
            hexString = "0" + hexString;
        }
        int intCurrentChoiceValue = this.currentChoiceValue.peek();
        if (cge.isMgWithinChoice()) {
            if (intCurrentChoiceValue == cge.getChoiceValue()) {
                return;
            }
            strucName = cge.getMgName();
            if (strucName == null) {
                strucName = "xsdseq";
            }
            strucName = this.getTopLevelStrucUniqueName(strucName, true);
        }
        if (intCurrentChoiceValue != -1) {
            this.closeChoiceMember();
        }
        this.currentChoiceValue.push(cge.getChoiceValue());
        this.addComment(MessageHandler.buildMessage("HLL_COMMENT_CHOICE_ENUM", new Object[]{hexString, strucName}));
        String enumLine = this.buildEnumerationValueLine(strucName, hexString);
        if (enumLine != null) {
            List<String> enumList = this.listStack.peek();
            enumList.add(enumLine);
        }
        this.block = this.blockManager.newBlock(uniqueName, false, 1);
        ICMStartChoiceGroupEntry scg = cge.getStartChoiceGroupEntry();
        String lsName = null;
        if (scg != null) {
            lsName = scg.getStructureName();
        }
        if (lsName == null) {
            lsName = this.pdsName;
        }
        this.addComment(MessageHandler.buildMessage("HLL_COMMENT_CHOICE_STRUCTURE", new Object[]{this.getDescriminatorUniqueFieldName(lsName, false), hexString}));
        this.buildOuterStructLine(strucName);
        this.allVarNamesInScope.add(new TreeSet());
    }

    protected void gotChoiceMemberEnd(ICMChoiceGroupEndEntry cgee) {
        if (this.currentChoiceValue.peek() == -1) {
            this.currentChoiceValue.pop();
        }
    }

    protected void gotAbstractType(ICMAbstractTypeStartEntry ads) throws CICSWSDLException {
        this.block.addDataElement(" ");
        String lsEnum = this.getDescriminatorUniqueFieldName(ads.getElementName(), false);
        String lsCont = this.getContainerUniqueFieldName(ads.getElementName(), false);
        this.addComment(MessageHandler.buildMessage("HLL_COMMENT_CHOICE_START", new Object[]{lsEnum, lsCont}));
        this.addComment(MessageHandler.getMessage("HLL_COMMENT_CHOICE_EMPTY"));
        ArrayList<String> enumList = new ArrayList<String>();
        this.listStack.push(enumList);
        String enumLine = this.buildEnumerationValueLine("empty", "00");
        if (enumLine != null) {
            enumList.add(enumLine);
        }
    }

    protected void gotAbstractTypeOption(ICMAbstractTypeOptionEntry adt) throws CICSWSDLException {
        String pdsName;
        String typeName;
        String enumLine;
        String hexString = Integer.toHexString(adt.getNumericValue());
        if (hexString.length() == 1) {
            hexString = "0" + hexString;
        }
        if ((enumLine = this.buildEnumerationValueLine(typeName = adt.getTypeQName().toString().substring(adt.getTypeQName().toString().indexOf(125) + 1), hexString)) != null) {
            List<String> enumList = this.listStack.peek();
            enumList.add(enumLine);
        }
        if ((pdsName = this.typeMemberNameMap.get(adt.getTypeQName())) == null) {
            pdsName = "UNKNOWN";
        }
        this.addComment(MessageHandler.buildMessage("HLL_COMMENT_ABSTRACT_ENUM", new Object[]{hexString, typeName, pdsName}));
    }

    protected void gotAbstractTypeEnd(ICMAbstractTypeEndEntry ade) throws CICSWSDLException {
        this.block.addDataElement(this.buildDescriminatorNameLine(ade.getElementName(), this.block.getNestingLevel() + 1));
        List<String> enumList = this.listStack.pop();
        Iterator<String> i = enumList.iterator();
        while (i.hasNext()) {
            this.block.addElement(i.next());
        }
        this.block.addDataElement(this.buildContainerNameLine(ade.getElementName(), this.block.getNestingLevel() + 1));
    }

    public final void gotEndRepeat() {
        if (this.simpleEndRepeatsExpected > 0) {
            --this.simpleEndRepeatsExpected;
            return;
        }
        boolean noData = false;
        String emptyBlockName = null;
        if (!this.block.getBlockType()) {
            this.closeOuterBlock();
            if (!this.block.hasData()) {
                emptyBlockName = this.block.getName();
                noData = true;
            }
            if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel) && this.allVarNamesInScope.size() > 1) {
                this.allVarNamesInScope.remove(this.allVarNamesInScope.size() - 1);
            }
        } else {
            if (this.block.isNonStrucRepeatsNeeded()) {
                this.block.decrementEndNonStrucRepeatsOutstanding();
                return;
            }
            this.closeInnerBlock();
            if (MappingLevelHelper.supportsMappingLevel_1_2(this.mappingLevel) && this.allVarNamesInScope.size() > 1 && this.supportsNameClashes()) {
                this.allVarNamesInScope.remove(this.allVarNamesInScope.size() - 1);
            }
        }
        this.block = this.blockManager.closeBlock();
        if (noData) {
            this.addComment(MessageHandler.buildMessage("HLL_COMMENT_EMPTY_STRUC", new Object[]{emptyBlockName}));
        }
    }

    protected abstract void buildStructLine(String var1, int var2, Stack<ICMFixedRepeatEntry> var3) throws CICSWSDLException;

    protected abstract void closeOuterBlock();

    protected abstract void closeInnerBlock();

    protected abstract String formatOccurs(int var1);

    protected boolean mustBeUnique(String varName) {
        return true;
    }

    protected boolean requiresTwoPartBoolean() {
        return false;
    }

    protected String getNameToUseForFillerFields() {
        return "filler";
    }

    protected abstract boolean supportsPureDBCS();

    protected boolean supportsNameClashes() {
        return true;
    }

    protected void storeTopDimension() {
        if (this.repeatStack.size() > 0) {
            this.dimensionEntry = this.repeatStack.peek();
        }
    }

    protected void restoreTopDimension() {
        if (this.dimensionEntry != null) {
            this.repeatStack.push(this.dimensionEntry);
            this.dimensionEntry = null;
        }
    }

    protected String shrinkToFit(String source, int maxLen) {
        int currentLen = source.length();
        String response = currentLen <= maxLen ? source : (this.inputParms.getProperty("NAME-TRUNCATION").equals("LEFT") ? source.substring(currentLen - maxLen) : source.substring(0, maxLen));
        return response;
    }

    protected abstract int getLanguageType();
}

