/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ws2ls;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.WSDLZipHandler;
import com.ibm.cics.wsdl.common.EBCDICComparator;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.ws2ls.WSAddressingFault;
import com.ibm.wsdl.extensions.schema.SchemaImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12BindingImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.woden.ErrorHandler;
import org.apache.woden.ErrorInfo;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.DOMXMLElement;
import org.apache.woden.schema.ImportedSchema;
import org.apache.woden.schema.Schema;
import org.apache.woden.wsdl20.BindingMessageReference;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.InterfaceFaultReference;
import org.apache.woden.wsdl20.InterfaceMessageReference;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.enumeration.Direction;
import org.apache.woden.wsdl20.enumeration.MessageLabel;
import org.apache.woden.wsdl20.extensions.ComponentExtensionContext;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.UnknownExtensionElement;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPModule;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.ImportElement;
import org.apache.woden.wsdl20.xml.IncludeElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.woden.xml.XMLAttr;
import org.eclipse.emf.common.util.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WSDLFile
implements ErrorHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Definition wsdl_1_1_definition = null;
    private Description wsdl_2_0_description = null;
    private Binding binding_1_1 = null;
    private org.apache.woden.wsdl20.Binding binding_2_0 = null;
    private String bindingLocalName = null;
    private Interface interface_2_0 = null;
    private SOAPBindingImpl wsdl_1_1_soapBinding = null;
    private SOAP12BindingImpl wsdl_1_2_soapBinding = null;
    private Element wsdl_1_1_soap_1_2_soapBinding = null;
    private String endPointURI = null;
    private QName serviceQName = null;
    private Port thePort_1_1 = null;
    private int soapVersion = 0;
    private static final int SOAP_VERSION_NOT_ALLOCATED = 0;
    private static final int SOAP_VERSION_1_1 = 1;
    private static final int SOAP_VERSION_1_2 = 2;
    private static final String[] SOAP_VERSION_AS_TEXT = new String[]{"UNKNOWN", "1.1", "1.2"};
    private String defaultStyle = null;
    private static final String USE_LITERAL = "literal";
    private static final String STYLE_DOCUMENT = "document";
    private static final String STYLE_RPC = "rpc";
    private static final String CALCULATED_ACTION = "C";
    private static final String SUPPLIED_ACTION = "S";
    private String errorMsg_2_0 = null;
    private String filename = null;
    private String zipfilename = null;
    private String dirName = null;
    private WSDLZipHandler zh = null;
    private boolean providerMode = true;
    private boolean runZOS = true;
    private boolean xmlOnly = false;
    private PrintStream log = Logging.getPrintStream();
    private static final String WSDL_1_1_SOAP_1_1 = "http://schemas.xmlsoap.org/soap/http";
    private static final String WSDL_1_1_SOAP_1_1_HTTPS = "https://schemas.xmlsoap.org/soap/http";
    private static String WSDL_1_1_SOAP_1_1_SLASH = "http://schemas.xmlsoap.org/soap/http/";
    private static String WSDL_1_1_SOAP_1_1_HTTPS_SLASH = "https://schemas.xmlsoap.org/soap/http/";
    private static final String WSDL_1_1_SOAP_1_1_EXTENSIBILITY = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String WSDL_1_1_SOAP_1_2 = "http://www.w3.org/2003/05/soap-http";
    private static final String WSDL_1_1_SOAP_1_2_HTTPS = "https://www.w3.org/2003/05/soap-http";
    private static java.net.URI WSDL_2_0_SOAP_1_1_BINDING_URI = null;
    private static final String WSDL_2_0_SOAP_1_1_BINDING = "http://www.w3.org/2006/01/soap11/bindings/HTTP/";
    private static java.net.URI WSDL_2_0_SOAP_1_2_BINDING_URI = null;
    private static final String WSDL_2_0_SOAP_1_2_BINDING = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    private static final String WSDL_2_0_SOAP_BINDING = "http://www.w3.org/ns/wsdl/soap";
    private static java.net.URI WSDL_2_0_SOAP_BINDING_URI = null;
    private static final String MEP_IN_ONLY = "http://www.w3.org/ns/wsdl/in-only";
    public static java.net.URI MEP_IN_ONLY_URI = null;
    private static final String MEP_ROBUST_IN_ONLY = "http://www.w3.org/ns/wsdl/robust-in-only";
    public static java.net.URI MEP_ROBUST_IN_ONLY_URI = null;
    private static final String MEP_IN_OUT = "http://www.w3.org/ns/wsdl/in-out";
    public static java.net.URI MEP_IN_OUT_URI = null;
    private static final String MEP_IN_OPTIONAL_OUT = "http://www.w3.org/ns/wsdl/in-opt-out";
    public static java.net.URI MEP_IN_OPTIONAL_OUT_URI = null;
    private static final String SOAP_MEP_HTTP_GET = "http://www.w3.org/2003/05/soap/mep/soap-response/";
    private static java.net.URI SOAP_MEP_HTTP_GET_URI = null;
    private static final String SOAP_MEP_HTTP_POST = "http://www.w3.org/2003/05/soap/mep/request-response/";
    private static final String NEW_WSDL_1_1_SOAP_1_2_NS = "http://schemas.xmlsoap.org/wsdl/soap12/";
    private static final String NEW_WSDL_1_1_SOAP_1_2_LOCAL_BIND = "binding";
    private static final String NEW_WSDL_1_1_SOAP_1_2_LOCAL_OP = "operation";
    private static final String NEW_WSDL_1_1_SOAP_1_2_LOCAL_ADDR = "address";
    private static final String NEW_WSDL_1_1_SOAP_1_2_LOCAL_BODY = "body";
    private static final String WS_POLICY_NS = "http://www.w3.org/2006/07/ws-policy";
    private static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String WSDL_SCHEMA_HTTP_NS = "http://schemas.xmlsoap.org/wsdl/http/";
    private static final String WS_ADDRESSING_METADATA_NS = "http://www.w3.org/2007/05/addressing/metadata";
    private static final String WS_ADDRESSING_NS = "http://www.w3.org/2005/08/addressing";
    private static final String WS_ADDRESSING_SUBS_NS = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final String WS_ADDRESSING_IDENTITY_NS = "http://schemas.xmlsoap.org/ws/2006/02/addressingidentity";
    private static final String WS_ADDRESSING_ACTION = "Action";
    private static final String WS_ADDRESSING_EPR = "EndpointReference";
    private static final String WS_ADDRESSING_ADDRESS = "Address";
    private static final String WS_ADDRESSING_METADATA = "Metadata";
    private static final String WS_ADDRESSING_REFPARAM = "ReferenceParameters";
    private static final String WS_ADDRESSING_META_INTERFACE = "InterfaceName";
    private static final String WS_ADDRESSING_META_SERVICE = "ServiceName";
    private static final String WS_ADDRESSING_REFPROP = "ReferenceProperties";
    private static final String WS_ADDRESSING_PORT_TYPE = "PortType";
    private static final String WS_ADDRESSING_SERVICE_NAME = "ServiceName";
    private static final String WS_ADDRESSING_POLICY = "Policy";
    private static final String WS_ADDRESSING_IDENTITY = "Identity";
    protected static final int MESSAGE_INPUT = 1;
    protected static final int MESSAGE_OUTPUT = 2;
    protected static final int MESSAGE_NA = -1;
    private static final int FEATURE_TYPE_SERVICE = 0;
    private static final int FEATURE_TYPE_OPERATION = 1;
    private static final int FEATURE_TYPE_REQUEST_MESSAGE = 2;
    private static final int FEATURE_TYPE_RESPONSE_MESSAGE = 3;

    public WSDLFile(String filename, boolean providerMode, String policyDir, String wsBindName, boolean runZOS, boolean xmlOnly, boolean disableLogging) throws CICSWSDLException {
        this(filename, providerMode, policyDir, wsBindName, runZOS, xmlOnly, "", disableLogging);
    }

    public WSDLFile(String filename, boolean providerMode, String policyDir, String wsBindName, boolean runZOS, boolean xmlOnly, String zipFileName, boolean disableLogging) throws CICSWSDLException {
        this.filename = filename;
        this.zipfilename = zipFileName;
        this.providerMode = providerMode;
        this.runZOS = runZOS;
        this.xmlOnly = xmlOnly;
        this.dirName = "";
        if (zipFileName != null && !zipFileName.equalsIgnoreCase("")) {
            this.zh = new WSDLZipHandler(this.zipfilename);
            try {
                this.zh.extractAll();
                this.filename = this.zh.getBaseWSDLLocation();
            }
            catch (IOException ioe) {
                throw new CICSWSDLException("Unable to extract " + this.zipfilename);
            }
        }
        this.readWSDLFromFile(this.filename);
        if (disableLogging) {
            this.log = null;
        }
    }

    protected void finalize() throws Throwable {
        this.cleanUp();
        super.finalize();
    }

    public final List<String> getOperationNames(List<String> userOperationNames, String serviceName, boolean commareaInterface) throws CICSWSDLException {
        List<String> operationNames = new LinkedList<String>();
        if (this.binding_1_1 != null) {
            PortType pt = this.binding_1_1.getPortType();
            for (Operation op : pt.getOperations()) {
                operationNames.add(op.getName());
            }
        } else if (this.binding_2_0 != null) {
            if (this.binding_2_0.getInterface() != null) {
                this.interface_2_0 = this.binding_2_0.getInterface();
                this.addAllOperationsToList_2_0(this.binding_2_0.getInterface(), operationNames);
            } else {
                QName service = this.getServiceQName(serviceName);
                if (service == null) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9635E", new Object[]{this.bindingLocalName}));
                }
                this.interface_2_0 = this.getServiceFromQName_2_0(service).getInterface();
                this.addAllOperationsToList_2_0(this.interface_2_0, operationNames);
            }
        } else {
            this.throwInternalError("getOperationNames");
        }
        for (String userOpName : userOperationNames) {
            if (operationNames.contains(userOpName)) continue;
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9636E", new Object[]{userOpName}));
        }
        if (userOperationNames.size() > 0) {
            if (this.providerMode && userOperationNames.size() != operationNames.size()) {
                Logging.writeMessage(4, "DFHPI9637W", null);
            }
            operationNames = userOperationNames;
        }
        if (this.log != null) {
            this.log.println("Operations:");
            for (String name : operationNames) {
                this.log.println("  " + name);
                this.log.println("   WSDL MEP - " + this.getMEP(name, commareaInterface));
                this.log.println("   Soap Action - " + this.getSoapAction(name));
                if (this.useHTTP_POST(name)) {
                    this.log.println("   HTTP Method - POST");
                    continue;
                }
                this.log.println("   HTTP Method - GET");
            }
        }
        if (operationNames.size() == 0) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9588E", new Object[]{this.bindingLocalName}));
        }
        return operationNames;
    }

    public List<Element> getSchemas() throws CICSWSDLException {
        LinkedList<Element> allSchemas = new LinkedList<Element>();
        if (this.binding_1_1 != null) {
            this.getSchemas_1_1(allSchemas, this.wsdl_1_1_definition);
        } else if (this.binding_2_0 != null) {
            this.getSchemas_2_0(allSchemas, this.wsdl_2_0_description.toElement());
        } else {
            this.throwInternalError("getSchemas");
        }
        return allSchemas;
    }

    private void getSchemas_1_1(List<Element> allSchemas, Definition currentDef) {
        Map allImports = currentDef.getImports();
        Types typesEl = currentDef.getTypes();
        if (typesEl != null) {
            Iterator types = typesEl.getExtensibilityElements().iterator();
            while (types.hasNext()) {
                Element schema = null;
                Object extensibilityElement = types.next();
                if (extensibilityElement instanceof UnknownExtensibilityElement) {
                    schema = ((UnknownExtensibilityElement)extensibilityElement).getElement();
                } else if (extensibilityElement instanceof SchemaImpl) {
                    schema = ((SchemaImpl)extensibilityElement).getElement();
                } else {
                    throw new RuntimeException("INTERNAL ERROR: Unknown extensibility element: " + extensibilityElement.getClass().getName());
                }
                allSchemas.add(schema);
            }
        }
        Iterator importIterator = allImports.keySet().iterator();
        while (importIterator.hasNext()) {
            Vector imports = (Vector)allImports.get(importIterator.next());
            for (Import anImport : imports) {
                Definition nestedDef = anImport.getDefinition();
                this.getSchemas_1_1(allSchemas, nestedDef);
            }
        }
    }

    private void getSchemas_2_0(List<Element> allSchemas, DescriptionElement currentDescription) {
        Schema[] allWodenSchemas = currentDescription.getTypesElement().getSchemas();
        for (int i = 0; i < allWodenSchemas.length; ++i) {
            Element theSchema;
            if (!(allWodenSchemas[i].getXMLElement().getSource() instanceof Element) || !(theSchema = (Element)allWodenSchemas[i].getXMLElement().getSource()).getNamespaceURI().equals(XML_SCHEMA_NS) || !theSchema.getLocalName().equals("schema")) continue;
            allSchemas.add(theSchema);
        }
        ImportElement[] importedWSDLElements = currentDescription.getImportElements();
        for (int i = 0; i < importedWSDLElements.length; ++i) {
            this.getSchemas_2_0(allSchemas, importedWSDLElements[i].getDescriptionElement());
        }
        IncludeElement[] includedWSDLElements = currentDescription.getIncludeElements();
        for (int i = 0; i < includedWSDLElements.length; ++i) {
            this.getSchemas_2_0(allSchemas, importedWSDLElements[i].getDescriptionElement());
        }
    }

    private void addAllOperationsToList_2_0(Interface intf, List<String> operationNames) {
        InterfaceOperation[] operations = intf.getInterfaceOperations();
        for (int i = 0; i < operations.length; ++i) {
            String localOpName = operations[i].getName().getLocalPart();
            if (operationNames.contains(localOpName)) continue;
            operationNames.add(operations[i].getName().getLocalPart());
        }
        Interface[] superInterfaces = intf.getExtendedInterfaces();
        for (int i = 0; i < superInterfaces.length; ++i) {
            this.addAllOperationsToList_2_0(superInterfaces[i], operationNames);
        }
    }

    private Service getServiceFromQName_2_0(QName service) {
        Service[] services = this.wsdl_2_0_description.getServices();
        for (int i = 0; i < services.length; ++i) {
            if (!services[i].getName().equals(service)) continue;
            return services[i];
        }
        return null;
    }

    public boolean responseMessageRequired(String operationName, boolean commareaInterface) throws CICSWSDLException {
        if (this.binding_1_1 != null) {
            Operation op = this.getOperation_1_1(operationName);
            return op.getOutput() != null;
        }
        if (this.binding_2_0 != null) {
            InterfaceOperation op = this.getOperation_2_0(operationName);
            this.checkMEP_2_0(op, commareaInterface);
            java.net.URI mep = op.getMessageExchangePattern();
            return !mep.equals(MEP_IN_ONLY_URI) && !mep.equals(MEP_ROBUST_IN_ONLY_URI);
        }
        this.throwInternalError("responseMessageExpected");
        return false;
    }

    public boolean requestMessageRequired(String operationName) throws CICSWSDLException {
        if (this.binding_1_1 != null) {
            return this.getMessage_1_1(operationName, ICM.XMLContentType.SOAP_REQUEST) != null;
        }
        if (this.binding_2_0 != null) {
            return true;
        }
        this.throwInternalError("requestMessageExpected");
        return false;
    }

    public boolean useHTTP_POST(String operationName) throws CICSWSDLException {
        if (this.binding_1_1 != null) {
            return true;
        }
        if (this.binding_2_0 != null) {
            java.net.URI tmp;
            SOAPBindingExtensions soapBind = this.getSOAPBinding_2_0();
            java.net.URI soapMEP = soapBind.getSoapMepDefault();
            SOAPBindingOperationExtensions sop = this.getSOAPBindingOperation_2_0(operationName);
            if (sop != null && (tmp = sop.getSoapMep()) != null) {
                soapMEP = tmp;
            }
            if (soapMEP != null && soapMEP.equals(SOAP_MEP_HTTP_GET_URI)) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9663E", new Object[]{operationName, SOAP_MEP_HTTP_GET_URI, SOAP_MEP_HTTP_POST}));
            }
            return true;
        }
        this.throwInternalError("useHTTP_POST");
        return true;
    }

    public java.net.URI getMEP(String operationName, boolean commareaInterface) throws CICSWSDLException {
        if (this.binding_1_1 != null) {
            if (this.responseMessageRequired(operationName, commareaInterface)) {
                return MEP_IN_OUT_URI;
            }
            return MEP_IN_ONLY_URI;
        }
        if (this.binding_2_0 != null) {
            InterfaceOperation op = this.getOperation_2_0(operationName);
            return op.getMessageExchangePattern();
        }
        this.throwInternalError("getMEP");
        return null;
    }

    private Operation getOperation_1_1(String operationName) throws CICSWSDLException {
        PortType pt = this.binding_1_1.getPortType();
        for (Operation op : pt.getOperations()) {
            if (!op.getName().equals(operationName)) continue;
            return op;
        }
        throw new CICSWSDLException("INTERNAL ERROR: operation " + operationName + " not found.");
    }

    private Message getMessage_1_1(String operationName, ICM.XMLContentType messageType) throws CICSWSDLException {
        Operation op = this.getOperation_1_1(operationName);
        switch (messageType) {
            case SOAP_REQUEST: {
                if (op.getInput() == null) break;
                return op.getInput().getMessage();
            }
            case SOAP_RESPONSE: {
                if (op.getOutput() == null) break;
                return op.getOutput().getMessage();
            }
            default: {
                this.throwInternalError("getMessage_1_1", messageType);
            }
        }
        return null;
    }

    private InterfaceOperation getOperation_2_0(String operationName) throws CICSWSDLException {
        InterfaceOperation operation = this.getOperation_2_0(operationName, this.interface_2_0);
        if (operation == null) {
            throw new CICSWSDLException("INTERNAL ERROR: operation " + operationName + " not found.");
        }
        return operation;
    }

    private InterfaceOperation getOperation_2_0(String operationName, Interface intf) throws CICSWSDLException {
        InterfaceOperation[] operations = intf.getInterfaceOperations();
        for (int i = 0; i < operations.length; ++i) {
            if (!operations[i].getName().getLocalPart().equals(operationName)) continue;
            return operations[i];
        }
        Interface[] interfaces = intf.getExtendedInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            InterfaceOperation found = this.getOperation_2_0(operationName, interfaces[i]);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private org.apache.woden.wsdl20.BindingOperation getBindingOperation_2_0(String operationName) {
        org.apache.woden.wsdl20.BindingOperation[] operations = this.binding_2_0.getBindingOperations();
        for (int i = 0; i < operations.length; ++i) {
            InterfaceOperation operation = operations[i].getInterfaceOperation();
            if (operation == null || operation.getName() == null || operation.getName().getLocalPart() == null || !operation.getName().getLocalPart().equals(operationName)) continue;
            return operations[i];
        }
        return null;
    }

    private SOAPBindingOperationExtensions getSOAPBindingOperation_2_0(String operationName) {
        ComponentExtensionContext o;
        org.apache.woden.wsdl20.BindingOperation bop = this.getBindingOperation_2_0(operationName);
        if (bop != null && (o = bop.getComponentExtensionContext(WSDL_2_0_SOAP_BINDING_URI)) != null && o instanceof SOAPBindingOperationExtensions) {
            return (SOAPBindingOperationExtensions)o;
        }
        return null;
    }

    private boolean checkMEP_2_0(InterfaceOperation operation, boolean commareaInterface) throws CICSWSDLException {
        java.net.URI mep = operation.getMessageExchangePattern();
        if (mep.equals(MEP_IN_ONLY_URI) || mep.equals(MEP_ROBUST_IN_ONLY_URI) || mep.equals(MEP_IN_OUT_URI) || mep.equals(MEP_IN_OPTIONAL_OUT_URI)) {
            if (mep.equals(MEP_IN_OPTIONAL_OUT_URI) && commareaInterface) {
                Logging.writeMessage(12, "DFHPI9655E", null);
            }
            return true;
        }
        throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9642E", new Object[]{mep, operation.getName().getLocalPart()}));
    }

    private final String getMessageName(String operationName, ICM.XMLContentType messageType) throws CICSWSDLException {
        if (this.binding_1_1 != null) {
            Message msg = this.getMessage_1_1(operationName, messageType);
            if (msg != null) {
                return msg.getQName().getLocalPart();
            }
            return null;
        }
        if (this.binding_2_0 != null) {
            switch (messageType) {
                case SOAP_REQUEST: {
                    return operationName + "RequestMessage";
                }
                case SOAP_RESPONSE: {
                    return operationName + "ResponseMessage";
                }
            }
            this.throwInternalError("getMessageName", messageType);
            return null;
        }
        this.throwInternalError("getMessageName");
        return null;
    }

    public final String getInputMessageName(String operationName) throws CICSWSDLException {
        return this.getMessageName(operationName, ICM.XMLContentType.SOAP_REQUEST);
    }

    public final String getOutputMessageName(String operationName) throws CICSWSDLException {
        return this.getMessageName(operationName, ICM.XMLContentType.SOAP_RESPONSE);
    }

    public final String getBindingName(String suggested) throws CICSWSDLException {
        String bindingName = null;
        if (this.wsdl_1_1_definition != null) {
            bindingName = this.getBinding_1_1(suggested);
        } else if (this.wsdl_2_0_description != null) {
            bindingName = this.getBinding_2_0(suggested);
        }
        if (this.log != null) {
            this.log.println("Binding name is: " + bindingName);
        }
        return bindingName;
    }

    public final String getRuntimeSignature(String operationName) throws CICSWSDLException {
        ArrayList<String> partsToInclude = new ArrayList<String>();
        String elementValue = null;
        List<Object> parts = this.getMethodSignatureParts(operationName, ICM.XMLContentType.SOAP_REQUEST, false);
        for (int i = 0; i < parts.size(); ++i) {
            QName elementName;
            Object thePart = parts.get(i);
            String partName = this.getMessagePartName(thePart);
            if (!this.defaultStyle.equalsIgnoreCase("RPC") && (elementName = this.getMessagePartElement(thePart)) != null) {
                elementValue = elementName.getLocalPart();
            }
            if (!this.defaultStyle.equalsIgnoreCase("RPC")) {
                partsToInclude.add(elementValue);
                continue;
            }
            partsToInclude.add(partName);
        }
        StringBuilder sig = new StringBuilder("");
        if (!partsToInclude.isEmpty()) {
            Collections.sort(partsToInclude, new EBCDICComparator());
            for (int i = 0; i < partsToInclude.size(); ++i) {
                if (!sig.toString().equals("")) {
                    sig.append(" ");
                }
                sig.append((String)partsToInclude.get(i));
            }
        }
        return sig.toString();
    }

    public final List<Object> getMethodSignatureParts(String operationName, ICM.XMLContentType type, boolean silentErrors) throws CICSWSDLException {
        if (this.binding_1_1 != null) {
            return this.getMethodSignatureParts_1_1(operationName, type, silentErrors);
        }
        if (this.binding_2_0 != null) {
            return this.getMethodSignatureParts_2_0(operationName, type);
        }
        this.throwInternalError("getMethodSignatureParts");
        return null;
    }

    private final List<Object> getMethodSignatureParts_1_1(String operationName, ICM.XMLContentType type, boolean silentErrors) throws CICSWSDLException {
        Operation op = this.getOperation_1_1(operationName);
        ArrayList<Object> partsToInclude = new ArrayList<Object>();
        Message theMessage = null;
        List<String> partsDefinedInBinding = null;
        switch (type) {
            case SOAP_REQUEST: {
                partsDefinedInBinding = this.getBindingInputParts_1_1(op.getName(), silentErrors);
                break;
            }
            case SOAP_RESPONSE: {
                partsDefinedInBinding = this.getBindingOutputParts_1_1(op.getName(), silentErrors);
                break;
            }
            default: {
                this.throwInternalError("getMethodSignatureParts_1_1", type);
            }
        }
        theMessage = this.getMessage_1_1(operationName, type);
        if (theMessage == null) {
            return null;
        }
        List userOrderedParts = op.getParameterOrdering();
        List orderedParts = theMessage.getOrderedParts(userOrderedParts);
        List naturalOrderParts = theMessage.getOrderedParts(null);
        Iterator userIT = orderedParts.iterator();
        while (userIT.hasNext()) {
            naturalOrderParts.remove(userIT.next());
        }
        Iterator naturalIT = naturalOrderParts.iterator();
        while (naturalIT.hasNext()) {
            orderedParts.add(naturalIT.next());
        }
        for (int i = 0; i < orderedParts.size(); ++i) {
            Part thePart = (Part)orderedParts.get(i);
            boolean includeThisPart = true;
            if (partsDefinedInBinding != null && !partsDefinedInBinding.contains(thePart.getName())) {
                includeThisPart = false;
            }
            if (!includeThisPart) continue;
            MessagePart newPart = new MessagePart(thePart.getName());
            newPart.setElementName(thePart.getElementName());
            newPart.setElementType(thePart.getTypeName());
            partsToInclude.add(newPart);
        }
        return partsToInclude;
    }

    private String getDelimiterForURI(String uri) {
        if (uri.length() >= 4 && uri.substring(0, 4).toUpperCase(Locale.ENGLISH).equals("URN:")) {
            return ":";
        }
        return "/";
    }

    public String getTargetNameSpaceNoSlash() throws CICSWSDLException {
        String tns = this.getTargetNameSpace();
        if (tns.charAt(tns.length() - 1) == '/') {
            tns = tns.substring(0, tns.length() - 1);
        }
        return tns;
    }

    public String getTargetNameSpace() throws CICSWSDLException {
        if (this.binding_1_1 != null) {
            return this.wsdl_1_1_definition.getTargetNamespace();
        }
        if (this.binding_2_0 != null) {
            return this.wsdl_2_0_description.toElement().getTargetNamespace().toString();
        }
        this.throwInternalError("getOperationNameSpace");
        return null;
    }

    private final List<Object> getMethodSignatureParts_2_0(String operationName, ICM.XMLContentType type) throws CICSWSDLException {
        InterfaceOperation op = this.getOperation_2_0(operationName);
        ArrayList<Object> partsToInclude = new ArrayList<Object>();
        InterfaceMessageReference[] theMessages = op.getInterfaceMessageReferences();
        InterfaceMessageReference theMessage = null;
        for (int i = 0; i < theMessages.length; ++i) {
            if (theMessages[i].getMessageLabel().equals((Object)MessageLabel.IN) && type.equals((Object)ICM.XMLContentType.SOAP_REQUEST)) {
                theMessage = theMessages[i];
                continue;
            }
            if (!theMessages[i].getMessageLabel().equals((Object)MessageLabel.OUT) || !type.equals((Object)ICM.XMLContentType.SOAP_RESPONSE)) continue;
            theMessage = theMessages[i];
        }
        if (theMessage == null) {
            throw new RuntimeException("INTERNAL_ERROR no message found for operation " + operationName + ".");
        }
        String contentModel = theMessage.getMessageContentModel().toUpperCase(Locale.ENGLISH);
        if (!"#ELEMENT".equals(contentModel) && !"#NONE".equals(contentModel)) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9641E", new Object[]{theMessage.getMessageContentModel(), operationName}));
        }
        if (theMessage.getElementDeclaration() != null) {
            MessagePart newPart = new MessagePart("<Unnamed Part>");
            newPart.setElementName(theMessage.getElementDeclaration().getName());
            partsToInclude.add(newPart);
        }
        return partsToInclude;
    }

    private BindingOperation getBindingOperation_1_1(String operationName) throws CICSWSDLException {
        BindingOperation bindingOperation = null;
        try {
            bindingOperation = this.binding_1_1.getBindingOperation(operationName, null, null);
        }
        catch (Exception e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9607E", new Object[]{operationName, e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        return bindingOperation;
    }

    public final boolean moreThanOneOperations() throws CICSWSDLException {
        if (this.binding_1_1 != null) {
            return this.binding_1_1.getBindingOperations().size() > 1;
        }
        if (this.binding_2_0 != null) {
            return this.binding_2_0.getBindingOperations().length > 1;
        }
        this.throwInternalError("moreThanOneOperations");
        return false;
    }

    private final List<String> getBindingInputParts_1_1(String operationName, boolean silentErrors) throws CICSWSDLException {
        List<String> partsDefinedInBinding = null;
        BindingOperation bindingOperation = this.getBindingOperation_1_1(operationName);
        if (bindingOperation != null) {
            boolean worked;
            boolean worked2;
            BindingInput bindingInput = bindingOperation.getBindingInput();
            BindingOutput bindingOutput = bindingOperation.getBindingOutput();
            if (bindingInput == null) {
                if (silentErrors) {
                    return new LinkedList<String>();
                }
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9596E", new Object[]{bindingOperation.getName()}));
            }
            Operation op = this.getOperation_1_1(operationName);
            Input opInput = op.getInput();
            if (opInput != null && !(worked2 = this.checkBindingOpMessage(opInput.getName(), bindingInput.getName(), bindingOperation.getName(), silentErrors))) {
                return new LinkedList<String>();
            }
            Output opOutput = op.getOutput();
            if (opOutput != null && bindingOutput != null && !(worked = this.checkBindingOpMessage(opOutput.getName(), bindingOutput.getName(), bindingOperation.getName(), silentErrors))) {
                return new LinkedList<String>();
            }
            List elements = bindingInput.getExtensibilityElements();
            partsDefinedInBinding = this.getMessagePartsFromBinding_1_1(elements, silentErrors);
        }
        return partsDefinedInBinding;
    }

    private boolean checkBindingOpMessage(String messageName, String bindingMessageName, String operationName, boolean silentErrors) throws CICSWSDLException {
        if (messageName != null && !messageName.equals(bindingMessageName) || messageName == null && bindingMessageName != null) {
            if (silentErrors) {
                return false;
            }
            String expectedName = null;
            expectedName = messageName == null ? "<anonymous>" : messageName;
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9665E", new Object[]{operationName, bindingMessageName, expectedName}));
        }
        return true;
    }

    private final List<String> getBindingOutputParts_1_1(String operationName, boolean silentErrors) throws CICSWSDLException {
        BindingOutput bindingOutput;
        List<String> partsDefinedInBinding = null;
        BindingOperation bindingOperation = this.getBindingOperation_1_1(operationName);
        if (bindingOperation != null && (bindingOutput = bindingOperation.getBindingOutput()) != null) {
            List elems = bindingOutput.getExtensibilityElements();
            partsDefinedInBinding = this.getMessagePartsFromBinding_1_1(elems, silentErrors);
        }
        return partsDefinedInBinding;
    }

    private List<String> getMessagePartsFromBinding_1_1(List<ExtensibilityElement> elems, boolean silentErrors) throws CICSWSDLException {
        LinkedList<String> partsDefinedInBinding = null;
        String use = null;
        for (int i = 0; i < elems.size(); ++i) {
            Element soapBody;
            ExtensibilityElement thisElement = elems.get(i);
            if (thisElement instanceof SOAPBody) {
                partsDefinedInBinding = ((SOAPBody)thisElement).getParts();
                use = ((SOAPBody)thisElement).getUse();
            } else if (thisElement instanceof SOAP12Body) {
                partsDefinedInBinding = ((SOAP12Body)thisElement).getParts();
                use = ((SOAP12Body)thisElement).getUse();
            } else if (this.wsdl_1_1_soap_1_2_soapBinding != null && (soapBody = this.getWSDL_1_1_SOAP_1_2_bodyElement(thisElement)) != null) {
                String parts = this.getAttributeValue(soapBody, "parts");
                if (parts != null) {
                    partsDefinedInBinding = new LinkedList<String>();
                    StringTokenizer st = new StringTokenizer(parts, " ", false);
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        partsDefinedInBinding.add(token);
                    }
                }
                use = this.getAttributeValue(soapBody, "use");
            }
            if (use == null) {
                use = USE_LITERAL;
            }
            if (use.equalsIgnoreCase(USE_LITERAL) || silentErrors || this.xmlOnly) continue;
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9597E", new Object[]{use}));
            throw newEx;
        }
        return partsDefinedInBinding;
    }

    public boolean isWSDL_1_1_withOldStyleBindings() {
        return this.wsdl_1_1_definition != null && this.wsdl_1_1_soapBinding != null;
    }

    public final boolean isSOAP_1_1_OverHttp() throws CICSWSDLException {
        if (this.soapVersion == 0) {
            if (this.binding_1_1 != null) {
                this.getSOAPVersion_1_1();
            } else if (this.binding_2_0 != null) {
                this.getSOAPVersion_2_0();
            } else {
                this.throwInternalError("isSOAP_1_1_OverHttp");
            }
        }
        return this.soapVersion == 1;
    }

    public final boolean isSOAP_1_2_OverHttp() throws CICSWSDLException {
        if (this.soapVersion == 0) {
            if (this.binding_1_1 != null) {
                this.getSOAPVersion_1_1();
            } else if (this.binding_2_0 != null) {
                this.getSOAPVersion_2_0();
            } else {
                this.throwInternalError("isSOAP_1_2_OverHttp");
            }
        }
        return this.soapVersion == 2;
    }

    public final boolean isSOAPOverHttp() throws CICSWSDLException {
        if (this.soapVersion == 0) {
            if (this.binding_1_1 != null) {
                this.getSOAPVersion_1_1();
            } else if (this.binding_2_0 != null) {
                this.getSOAPVersion_2_0();
            } else {
                this.throwInternalError("isSOAPOverHttp");
            }
        }
        return this.soapVersion != 0;
    }

    private final void getSOAPVersion_1_1() throws CICSWSDLException {
        boolean found = false;
        String transport = null;
        if (this.wsdl_1_1_soapBinding != null) {
            transport = this.wsdl_1_1_soapBinding.getTransportURI();
        } else if (this.wsdl_1_2_soapBinding != null) {
            transport = this.wsdl_1_2_soapBinding.getTransportURI();
        } else if (this.wsdl_1_1_soap_1_2_soapBinding != null) {
            transport = this.getAttributeValue(this.wsdl_1_1_soap_1_2_soapBinding, "transport");
        }
        List topElements = this.binding_1_1.getExtensibilityElements();
        for (int i = 0; i < topElements.size(); ++i) {
            ExtensibilityElement thisElement = (ExtensibilityElement)topElements.get(i);
            if (!thisElement.getElementType().getLocalPart().equalsIgnoreCase(NEW_WSDL_1_1_SOAP_1_2_LOCAL_BIND)) continue;
            if (found) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9598E", new Object[]{this.binding_1_1.getQName()}));
            }
            found = true;
        }
        if (!found) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9599E", new Object[]{this.binding_1_1.getQName()}));
        }
        if (transport == null) {
            throw new RuntimeException("INTERNAL_ERROR transport cannot be determined.");
        }
        if ((transport = transport.trim()).equals(WSDL_1_1_SOAP_1_1) || transport.equals(WSDL_1_1_SOAP_1_1_HTTPS) || transport.equals(WSDL_1_1_SOAP_1_1_SLASH) || transport.equals(WSDL_1_1_SOAP_1_1_HTTPS_SLASH)) {
            this.soapVersion = 1;
        } else if (transport.equals(WSDL_1_1_SOAP_1_2) || transport.equals(WSDL_1_1_SOAP_1_2_HTTPS)) {
            this.soapVersion = 2;
        }
        if (this.wsdl_1_1_soap_1_2_soapBinding != null || this.wsdl_1_2_soapBinding != null) {
            this.soapVersion = 2;
        }
        if (this.log != null) {
            this.log.println("SOAP version required is: " + SOAP_VERSION_AS_TEXT[this.soapVersion]);
        }
    }

    private String getAttributeValue(Element theElement, String attrName) {
        String attrValue = null;
        Attr attrNode = theElement.getAttributeNode(attrName);
        if (attrNode != null) {
            attrValue = attrNode.getNodeValue();
        }
        return attrValue;
    }

    private final void getSOAPVersion_2_0() throws CICSWSDLException {
        SOAPBindingExtensions soapBind = this.getSOAPBinding_2_0();
        java.net.URI protocol = soapBind.getSoapUnderlyingProtocol();
        if (protocol != null && protocol.equals(WSDL_2_0_SOAP_1_1_BINDING_URI)) {
            this.soapVersion = 1;
        } else if (protocol != null && protocol.equals(WSDL_2_0_SOAP_1_2_BINDING_URI)) {
            this.soapVersion = 2;
        }
        if (this.log != null) {
            this.log.println("SOAP version required is: " + SOAP_VERSION_AS_TEXT[this.soapVersion]);
        }
    }

    private SOAPBindingExtensions getSOAPBinding_2_0() throws CICSWSDLException {
        ComponentExtensionContext o = this.binding_2_0.getComponentExtensionContext(WSDL_2_0_SOAP_BINDING_URI);
        if (o != null && o instanceof SOAPBindingExtensions) {
            SOAPBindingExtensions soapBind = (SOAPBindingExtensions)o;
            return soapBind;
        }
        throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9599E", new Object[]{this.bindingLocalName}));
    }

    public final String getSoapAction(String operationName) throws CICSWSDLException {
        if (this.binding_1_1 != null) {
            return this.getSoapAction_1_1(operationName);
        }
        if (this.binding_2_0 != null) {
            return this.getSoapAction_2_0(operationName);
        }
        this.throwInternalError("getSoapAction");
        return null;
    }

    private final String getSoapAction_1_1(String operationName) throws CICSWSDLException {
        String action = null;
        BindingOperation bindingOperation = this.getBindingOperation_1_1(operationName);
        if (bindingOperation != null) {
            List elements = bindingOperation.getExtensibilityElements();
            for (int i = 0; i < elements.size(); ++i) {
                Element soapOp;
                ExtensibilityElement thisElement = (ExtensibilityElement)elements.get(i);
                if (thisElement instanceof SOAPOperation) {
                    action = ((SOAPOperation)thisElement).getSoapActionURI();
                    continue;
                }
                if (thisElement instanceof SOAP12Operation) {
                    action = ((SOAP12Operation)thisElement).getSoapActionURI();
                    continue;
                }
                if (this.wsdl_1_1_soap_1_2_soapBinding == null || (soapOp = this.getWSDL_1_1_SOAP_1_2_operationElement(thisElement)) == null) continue;
                action = this.getAttributeValue(soapOp, "soapAction");
            }
        }
        return action;
    }

    private final void processExtensibilityElements_1_1(List<ExtensibilityElement> extensibilityElements, String operationName, int messageType) {
        if (extensibilityElements == null) {
            return;
        }
        for (ExtensibilityElement element : extensibilityElements) {
            String elNs = element.getElementType().getNamespaceURI();
            if (elNs.equals(WSDL_1_1_SOAP_1_1_EXTENSIBILITY) || elNs.equals(NEW_WSDL_1_1_SOAP_1_2_NS) || elNs.equals(WS_POLICY_NS) || element.getRequired() == null || !element.getRequired().booleanValue()) continue;
            Logging.writeMessage(4, "DFHPI9652W", new Object[]{element.getElementType()});
        }
    }

    private final void getPolicyAttachmentsForMessage_1_1(String operationName, int message) throws CICSWSDLException {
        BindingOperation bop = this.getBindingOperation_1_1(operationName);
        if (bop != null) {
            BindingInput bin = bop.getBindingInput();
            BindingOutput bout = bop.getBindingOutput();
            Operation theOp = bop.getOperation();
            List extensibilityElements = null;
            List messageSpecificElements = null;
            switch (message) {
                case 1: {
                    Input theOpInput;
                    if (bin == null) break;
                    extensibilityElements = bin.getExtensibilityElements();
                    if (theOp == null || theOp.getInput() == null || (theOpInput = theOp.getInput()).getMessage() == null) break;
                    messageSpecificElements = theOpInput.getMessage().getExtensibilityElements();
                    break;
                }
                case 2: {
                    Output theOpOutput;
                    if (bout == null) break;
                    extensibilityElements = bout.getExtensibilityElements();
                    if (theOp == null || theOp.getOutput() == null || (theOpOutput = theOp.getOutput()).getMessage() == null) break;
                    messageSpecificElements = theOpOutput.getMessage().getExtensibilityElements();
                    break;
                }
                default: {
                    throw new CICSWSDLException("INTERNAL ERROR: bad message type: " + message);
                }
            }
            this.processExtensibilityElements_1_1(extensibilityElements, operationName, message);
            this.processExtensibilityElements_1_1(messageSpecificElements, operationName, message);
        }
    }

    private final void getPolicyAttachmentsForMessage_2_0(String operationName, int message) {
    }

    public final void getPolicyAttachmentsForMessage(String operationName, int message) throws CICSWSDLException {
        if (this.wsdl_1_1_definition != null) {
            this.getPolicyAttachmentsForMessage_1_1(operationName, message);
        } else if (this.wsdl_2_0_description != null) {
            this.getPolicyAttachmentsForMessage_2_0(operationName, message);
        } else {
            this.throwInternalError("getPolicyAttachmentsForMessage");
        }
    }

    private final void getPolicyAttachmentsForOperation_1_1(String operationName) throws CICSWSDLException {
        BindingOperation bind;
        Operation op = this.getOperation_1_1(operationName);
        if (op != null) {
            this.processExtensibilityElements_1_1(op.getExtensibilityElements(), operationName, -1);
        }
        if ((bind = this.getBindingOperation_1_1(operationName)) != null) {
            this.processExtensibilityElements_1_1(bind.getExtensibilityElements(), operationName, -1);
        }
    }

    private final void getPolicyAttachmentsForOperation_2_0(String operationName) {
    }

    public final void getPolicyAttachmentsForOperation(String operationName) throws CICSWSDLException {
        if (this.wsdl_1_1_definition != null) {
            this.getPolicyAttachmentsForOperation_1_1(operationName);
        } else if (this.wsdl_2_0_description != null) {
            this.getPolicyAttachmentsForOperation_2_0(operationName);
        } else {
            this.throwInternalError("getPolicyAttachmentsForOperation");
        }
    }

    private final void getPolicyAttachmentsForService_1_1() {
        javax.wsdl.Service service;
        if (this.serviceQName != null && (service = this.wsdl_1_1_definition.getService(this.serviceQName)) != null) {
            this.processExtensibilityElements_1_1(service.getExtensibilityElements(), null, -1);
            if (this.thePort_1_1 != null) {
                this.processExtensibilityElements_1_1(this.thePort_1_1.getExtensibilityElements(), null, -1);
            }
        }
        this.processExtensibilityElements_1_1(this.binding_1_1.getExtensibilityElements(), null, -1);
    }

    private final void getPolicyAttachmentsForService_2_0() {
    }

    public final void getPolicyAttachmentsForService() throws CICSWSDLException {
        if (this.wsdl_1_1_definition != null) {
            this.getPolicyAttachmentsForService_1_1();
        } else if (this.wsdl_2_0_description != null) {
            this.getPolicyAttachmentsForService_2_0();
        } else {
            this.throwInternalError("getPolicyAttachmentsForService");
        }
    }

    private final String getSoapAction_2_0(String operationName) {
        SOAPBindingOperationExtensions sopb = this.getSOAPBindingOperation_2_0(operationName);
        if (sopb != null && sopb.getSoapAction() != null) {
            return sopb.getSoapAction().toString();
        }
        return null;
    }

    public List<Object> getURIsForTypeSections(String currentURI, String parentURI) throws CICSWSDLException {
        ArrayList<Object> allTypesSections = new ArrayList<Object>();
        if (this.wsdl_1_1_definition != null) {
            this.getURIsForTypeSections_1_1(allTypesSections, this.wsdl_1_1_definition, currentURI, parentURI);
        } else if (this.wsdl_2_0_description != null) {
            java.net.URI URIForParent = null;
            try {
                if (!currentURI.startsWith("http")) {
                    File tmp = new File(currentURI);
                    URIForParent = tmp.toURI();
                } else {
                    URIForParent = new java.net.URI(currentURI);
                }
            }
            catch (URISyntaxException e) {
                CICSWSDLException exc = new CICSWSDLException("INTERNAL ERROR: URI cannot be understood: " + currentURI);
                exc.initCause(e);
                throw exc;
            }
            this.getURIsForTypeSections_2_0(allTypesSections, this.wsdl_2_0_description.toElement(), URIForParent);
        } else {
            this.throwInternalError("getURIsForTypeSections");
        }
        if (this.log != null) {
            this.log.println();
            this.log.println("URIs for 'types' sections are: ");
            Iterator typesIt = allTypesSections.iterator();
            while (typesIt.hasNext()) {
                this.log.println("  URI: " + typesIt.next());
            }
        }
        return allTypesSections;
    }

    private void getURIsForTypeSections_2_0(List<Object> allTypeSections, DescriptionElement currentDef, java.net.URI parentURI) {
        int i;
        if (currentDef == null) {
            return;
        }
        TypesElement types = currentDef.getTypesElement();
        if (types != null) {
            ImportedSchema[] schemas;
            if (types.getInlinedSchemas() != null && types.getInlinedSchemas().length > 0) {
                allTypeSections.add(parentURI);
            }
            if ((schemas = types.getImportedSchemas()) != null) {
                for (i = 0; i < schemas.length; ++i) {
                    java.net.URI currentURI = schemas[i].getSchemaLocation();
                    if (!currentURI.isAbsolute()) {
                        currentURI = parentURI.resolve(currentURI);
                    }
                    if (currentURI.toString().equals("http://www.w3.org/2001/XMLSchema.xsd")) continue;
                    allTypeSections.add(currentURI);
                }
            }
        }
        ImportElement[] importedWSDLElements = currentDef.getImportElements();
        for (i = 0; i < importedWSDLElements.length; ++i) {
            this.getURIsForTypeSections_2_0(allTypeSections, importedWSDLElements[i].getDescriptionElement(), importedWSDLElements[i].getLocation());
        }
        IncludeElement[] includedWSDLElements = currentDef.getIncludeElements();
        for (int i2 = 0; i2 < includedWSDLElements.length; ++i2) {
            this.getURIsForTypeSections_2_0(allTypeSections, includedWSDLElements[i2].getDescriptionElement(), includedWSDLElements[i2].getLocation());
        }
    }

    private void getURIsForTypeSections_1_1(List<Object> allTypeSections, Definition currentDef, String currentURI, String parentURI) {
        Map allImports = currentDef.getImports();
        if (!(currentURI.startsWith("http:") || currentURI.startsWith("https:") || currentURI.startsWith("C:") || currentURI.startsWith("/") || parentURI == null)) {
            int slashPos = parentURI.lastIndexOf(47);
            if (slashPos == -1) {
                slashPos = parentURI.lastIndexOf(92);
            }
            if (slashPos > -1) {
                currentURI = parentURI.substring(0, slashPos).concat("/").concat(currentURI);
            }
        }
        if (currentDef.getTypes() != null) {
            allTypeSections.add(currentURI);
        }
        Iterator importIterator = allImports.keySet().iterator();
        while (importIterator.hasNext()) {
            Vector imports = (Vector)allImports.get(importIterator.next());
            for (Import anImport : imports) {
                Definition nestedDef = anImport.getDefinition();
                this.getURIsForTypeSections_1_1(allTypeSections, nestedDef, anImport.getLocationURI(), currentURI);
            }
        }
    }

    private String getBinding_1_1(String bindingRequested) throws CICSWSDLException {
        Map.Entry entry;
        HashMap<QName, Binding> bindings = new HashMap<QName, Binding>();
        this.getAllBindings_1_1(bindings, this.wsdl_1_1_definition);
        if (bindings.size() > 1 && bindingRequested == null) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.getMessage("DFHPI9600E"));
            throw newEx;
        }
        Iterator bindIT = bindings.entrySet().iterator();
        if (bindings.size() == 1 && bindingRequested == null) {
            entry = bindIT.next();
            this.binding_1_1 = (Binding)entry.getValue();
        } else {
            while (bindIT.hasNext()) {
                entry = bindIT.next();
                QName bindQName = (QName)entry.getKey();
                if (!bindQName.getLocalPart().equalsIgnoreCase(bindingRequested)) continue;
                this.binding_1_1 = (Binding)entry.getValue();
                break;
            }
        }
        if (this.binding_1_1 == null) {
            CICSWSDLException newEx;
            Iterator it = bindings.keySet().iterator();
            StringBuilder bindingsInsert = new StringBuilder();
            while (it.hasNext()) {
                QName qname = (QName)it.next();
                bindingsInsert.append(qname.getLocalPart());
                bindingsInsert.append(", ");
            }
            if (bindingsInsert.length() > 1) {
                bindingsInsert.replace(bindingsInsert.length() - 2, bindingsInsert.length(), "");
                newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9601E", new Object[]{bindingRequested, bindingsInsert}));
                throw newEx;
            }
            newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9656E", null));
            throw newEx;
        }
        if (this.log != null) {
            this.log.println(LINE_SEPARATOR + "Parsing WSDL 1.1");
            this.log.println("----------------");
            this.log.println("Using " + this.binding_1_1.toString());
        }
        this.bindingLocalName = this.binding_1_1.getQName().getLocalPart();
        List elements = this.binding_1_1.getExtensibilityElements();
        boolean gotSOAPBinding = false;
        for (int i = 0; i < elements.size(); ++i) {
            ExtensibilityElement thisElement = (ExtensibilityElement)elements.get(i);
            if (thisElement instanceof SOAPBindingImpl) {
                gotSOAPBinding = true;
                this.wsdl_1_1_soapBinding = (SOAPBindingImpl)thisElement;
                continue;
            }
            if (thisElement instanceof SOAP12BindingImpl) {
                gotSOAPBinding = true;
                this.wsdl_1_2_soapBinding = (SOAP12BindingImpl)thisElement;
                continue;
            }
            Element soap12 = this.getWSDL_1_1_SOAP_1_2_bindingElement(thisElement);
            if (soap12 == null) continue;
            gotSOAPBinding = true;
            this.wsdl_1_1_soap_1_2_soapBinding = soap12;
        }
        if (!gotSOAPBinding) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9602E", new Object[]{this.bindingLocalName}));
        }
        if (this.binding_1_1.getPortType() != null && this.binding_1_1.getPortType().isUndefined()) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9588E", new Object[]{this.bindingLocalName}));
        }
        return this.bindingLocalName;
    }

    private Element getWSDL_1_1_SOAP_1_2_bindingElement(ExtensibilityElement ee) {
        UnknownExtensibilityElement uee;
        Element el;
        if (ee instanceof UnknownExtensibilityElement && NEW_WSDL_1_1_SOAP_1_2_NS.equals((el = (uee = (UnknownExtensibilityElement)ee).getElement()).getNamespaceURI()) && NEW_WSDL_1_1_SOAP_1_2_LOCAL_BIND.equals(el.getLocalName())) {
            return el;
        }
        return null;
    }

    private Element getWSDL_1_1_SOAP_1_2_operationElement(ExtensibilityElement ee) {
        UnknownExtensibilityElement uee;
        Element el;
        if (ee instanceof UnknownExtensibilityElement && NEW_WSDL_1_1_SOAP_1_2_NS.equals((el = (uee = (UnknownExtensibilityElement)ee).getElement()).getNamespaceURI()) && NEW_WSDL_1_1_SOAP_1_2_LOCAL_OP.equals(el.getLocalName())) {
            return el;
        }
        return null;
    }

    private Element getWSDL_1_1_SOAP_1_2_addressElement(ExtensibilityElement ee) {
        UnknownExtensibilityElement uee;
        Element el;
        if (ee instanceof UnknownExtensibilityElement && NEW_WSDL_1_1_SOAP_1_2_NS.equals((el = (uee = (UnknownExtensibilityElement)ee).getElement()).getNamespaceURI()) && NEW_WSDL_1_1_SOAP_1_2_LOCAL_ADDR.equals(el.getLocalName())) {
            return el;
        }
        return null;
    }

    private Element getWSDL_1_1_SOAP_1_2_bodyElement(ExtensibilityElement ee) {
        UnknownExtensibilityElement uee;
        Element el;
        if (ee instanceof UnknownExtensibilityElement && NEW_WSDL_1_1_SOAP_1_2_NS.equals((el = (uee = (UnknownExtensibilityElement)ee).getElement()).getNamespaceURI()) && NEW_WSDL_1_1_SOAP_1_2_LOCAL_BODY.equals(el.getLocalName())) {
            return el;
        }
        return null;
    }

    private String getBinding_2_0(String bindingRequested) throws CICSWSDLException {
        java.net.URI bindingType;
        org.apache.woden.wsdl20.Binding[] allBindings = this.wsdl_2_0_description.getBindings();
        if (allBindings.length > 1 && bindingRequested == null) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.getMessage("DFHPI9600E"));
            throw newEx;
        }
        if (allBindings.length == 1 && bindingRequested == null) {
            this.binding_2_0 = allBindings[0];
        } else {
            for (int i = 0; i < allBindings.length; ++i) {
                QName bindQName = allBindings[i].getName();
                if (!bindQName.getLocalPart().equalsIgnoreCase(bindingRequested)) continue;
                this.binding_2_0 = allBindings[i];
                break;
            }
        }
        if (this.binding_2_0 == null) {
            StringBuilder bindingsInsert = new StringBuilder();
            for (int i = 0; i < allBindings.length; ++i) {
                QName qname = allBindings[i].getName();
                bindingsInsert.append(qname.getLocalPart());
                bindingsInsert.append(", ");
            }
            if (bindingsInsert.length() > 2) {
                bindingsInsert.replace(bindingsInsert.length() - 2, bindingsInsert.length(), "");
            }
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9601E", new Object[]{bindingRequested, bindingsInsert}));
            throw newEx;
        }
        this.bindingLocalName = this.binding_2_0.getName().getLocalPart();
        if (this.log != null) {
            this.log.println(LINE_SEPARATOR + "Parsing WSDL 2.0");
            this.log.println("----------------");
            this.log.println("Using " + this.binding_2_0.toString());
        }
        if (!(bindingType = this.binding_2_0.getType()).toString().equals(WSDL_2_0_SOAP_BINDING)) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9602E", new Object[]{this.bindingLocalName}));
        }
        return this.bindingLocalName;
    }

    public boolean isDocWrappedStyle() {
        if (!this.getStyle().equals(STYLE_DOCUMENT)) {
            return false;
        }
        try {
            List<String> operationNames = this.getOperationNames(new LinkedList<String>(), null, false);
            if (operationNames.size() < 2) {
                return false;
            }
            for (String opName : operationNames) {
                List<Object> parts = this.getMethodSignatureParts(opName, ICM.XMLContentType.SOAP_REQUEST, true);
                if (parts == null || parts.size() != 1) {
                    return false;
                }
                QName partTarget = this.getMessagePartElement(parts.get(0));
                if (partTarget == null) {
                    return false;
                }
                if (partTarget.getLocalPart().equals(opName)) continue;
                return false;
            }
        }
        catch (CICSWSDLException e) {
            return false;
        }
        return true;
    }

    public final String getStyle() {
        if (this.wsdl_2_0_description != null) {
            this.defaultStyle = STYLE_DOCUMENT;
            return this.defaultStyle;
        }
        if (this.defaultStyle != null) {
            return this.defaultStyle;
        }
        if (this.wsdl_1_1_soap_1_2_soapBinding != null) {
            this.defaultStyle = this.getAttributeValue(this.wsdl_1_1_soap_1_2_soapBinding, "style");
        } else {
            if (this.wsdl_1_1_soapBinding != null) {
                this.defaultStyle = this.wsdl_1_1_soapBinding.getStyle();
            }
            if (this.wsdl_1_2_soapBinding != null) {
                this.defaultStyle = this.wsdl_1_2_soapBinding.getStyle();
            }
        }
        if (!STYLE_DOCUMENT.equals(this.defaultStyle) && !STYLE_RPC.equals(this.defaultStyle)) {
            this.defaultStyle = STYLE_DOCUMENT;
        }
        if (this.log != null) {
            this.log.println("Binding style is: " + this.defaultStyle);
        }
        return this.defaultStyle;
    }

    public boolean isStyleSetForOperation(String operationName) throws CICSWSDLException {
        if (this.binding_1_1 != null) {
            Operation op = this.getOperation_1_1(operationName);
            return op.toString().indexOf("style=") != -1 || this.defaultStyle != null;
        }
        this.throwInternalError("isStyleSetForOperation");
        return false;
    }

    public final void setStyle(String styleOveride) {
        this.defaultStyle = styleOveride;
    }

    QName getServiceQName(String serviceName) throws CICSWSDLException {
        boolean serviceFound = false;
        QName service = null;
        if (serviceName != null) {
            service = this.getQualifiedServiceName(serviceName);
            if (service == null) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9634E", new Object[]{serviceName}));
            }
            return service;
        }
        Iterator<Object> serviceIT = null;
        if (this.wsdl_1_1_definition != null) {
            Map services = this.wsdl_1_1_definition.getServices();
            serviceIT = services.keySet().iterator();
        } else {
            LinkedList<QName> allServiceQNames = new LinkedList<QName>();
            Service[] services = this.wsdl_2_0_description.getServices();
            for (int i = 0; i < services.length; ++i) {
                allServiceQNames.add(services[i].getName());
            }
            serviceIT = allServiceQNames.iterator();
        }
        while (serviceIT.hasNext()) {
            QName currentService = (QName)serviceIT.next();
            String currentEndpoint = this.getEndPointForService(currentService, false);
            if (currentEndpoint == null) continue;
            if (serviceFound && !this.providerMode) {
                throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9603E"));
            }
            serviceFound = true;
            service = currentService;
        }
        return service;
    }

    public final String getEndpoint(String serviceName) throws CICSWSDLException {
        if (this.endPointURI != null) {
            return this.endPointURI;
        }
        String endpoint = null;
        QName service = this.getServiceQName(serviceName);
        if (service != null) {
            endpoint = this.getEndPointForService(service, true);
            this.serviceQName = service;
        }
        if (endpoint == null) {
            endpoint = " ";
        }
        this.endPointURI = endpoint;
        if (this.log != null) {
            this.log.println("WSDL end-point address is: " + endpoint);
        }
        return endpoint;
    }

    public final String getEndpointName(String serviceName, String bindingName) throws CICSWSDLException {
        String endpoint = null;
        QName service = this.getServiceQName(serviceName);
        if (service != null) {
            if (this.wsdl_1_1_definition != null) {
                javax.wsdl.Service s = this.wsdl_1_1_definition.getService(service);
                if (s == null) {
                    return null;
                }
                Map ports = s.getPorts();
                if (ports.size() == 1) {
                    Iterator portsIT = ports.keySet().iterator();
                    endpoint = (String)portsIT.next();
                } else if (ports.size() > 1) {
                    for (Port p : ports.values()) {
                        if (!p.getBinding().getQName().getLocalPart().equals(bindingName)) continue;
                        endpoint = p.getName();
                    }
                }
            } else {
                Service serviceW = this.getServiceFromQName_2_0(service);
                if (serviceW == null) {
                    return null;
                }
                Endpoint[] endPoints = serviceW.getEndpoints();
                if (endPoints.length == 1) {
                    endpoint = endPoints[0].getName().toString();
                } else if (endPoints.length > 1) {
                    for (int i = 0; i < endPoints.length; ++i) {
                        if (!endPoints[i].getBinding().getName().getLocalPart().equals(bindingName)) continue;
                        endpoint = endPoints[i].getName().toString();
                    }
                }
            }
        }
        if (endpoint == null) {
            endpoint = " ";
        }
        if (this.log != null) {
            this.log.println("WSDL end-point name is: " + endpoint);
        }
        return endpoint;
    }

    public void handleAllFeatures(List<String> operationNames) {
        if (this.wsdl_1_1_definition != null) {
            return;
        }
        this.handleAllFeatures_2_0(operationNames);
    }

    private void handleAllFeatures_2_0(List<String> operationNames) {
        ComponentExtensionContext o = this.binding_2_0.getComponentExtensionContext(WSDL_2_0_SOAP_BINDING_URI);
        if (o instanceof SOAPBindingExtensions) {
            SOAPBindingExtensions sbe = (SOAPBindingExtensions)o;
            this.handleSOAPModules(sbe.getSoapModules(), 0, null);
        }
        org.apache.woden.wsdl20.BindingOperation[] bops = this.binding_2_0.getBindingOperations();
        for (int i = 0; i < bops.length; ++i) {
            String opName;
            InterfaceOperation io = bops[i].getInterfaceOperation();
            if (io == null || !operationNames.contains(opName = io.getName().getLocalPart())) continue;
            o = bops[i].getComponentExtensionContext(WSDL_2_0_SOAP_BINDING_URI);
            if (o instanceof SOAPBindingOperationExtensions) {
                SOAPBindingOperationExtensions sboe = (SOAPBindingOperationExtensions)o;
                this.handleSOAPModules(sboe.getSoapModules(), 1, opName);
            }
            BindingMessageReference[] bmrs = bops[i].getBindingMessageReferences();
            for (int j = 0; j < bmrs.length; ++j) {
                o = bmrs[j].getComponentExtensionContext(WSDL_2_0_SOAP_BINDING_URI);
                SOAPModule[] modules = null;
                if (o instanceof SOAPBindingMessageReferenceExtensions) {
                    SOAPBindingMessageReferenceExtensions sbmre = (SOAPBindingMessageReferenceExtensions)o;
                    modules = sbmre.getSoapModules();
                }
                if (bmrs[j].getInterfaceMessageReference().getDirection().equals(Direction.IN)) {
                    if (modules == null) continue;
                    this.handleSOAPModules(modules, 2, opName);
                    continue;
                }
                if (modules == null) continue;
                this.handleSOAPModules(modules, 3, opName);
            }
        }
    }

    private void handleSOAPModules(SOAPModule[] modules, int type, String name) {
        for (int i = 0; i < modules.length; ++i) {
            SOAPModule module = modules[i];
            java.net.URI uri = module.getRef();
            boolean required = module.isRequired();
            this.issueMessageForFeatureOrSoapModule(required, type, uri, name);
        }
    }

    private void issueMessageForFeatureOrSoapModule(boolean required, int type, java.net.URI uri, String name) {
        if (this.providerMode) {
            required = true;
        }
        switch (type) {
            case 0: {
                if (required) {
                    Logging.writeMessage(1, "DFHPI9643I", new Object[]{uri});
                    break;
                }
                Logging.writeMessage(1, "DFHPI9644I", new Object[]{uri});
                break;
            }
            case 1: {
                if (required) {
                    Logging.writeMessage(1, "DFHPI9645I", new Object[]{name, uri});
                    break;
                }
                Logging.writeMessage(1, "DFHPI9646I", new Object[]{name, uri});
                break;
            }
            case 2: {
                if (required) {
                    Logging.writeMessage(1, "DFHPI9647I", new Object[]{name, uri});
                    break;
                }
                Logging.writeMessage(1, "DFHPI9648I", new Object[]{name, uri});
                break;
            }
            case 3: {
                if (required) {
                    Logging.writeMessage(1, "DFHPI9649I", new Object[]{name, uri});
                    break;
                }
                Logging.writeMessage(1, "DFHPI9650I", new Object[]{name, uri});
                break;
            }
        }
    }

    private String getEndPointForService(QName serviceName, boolean cache) {
        java.net.URI endpoint = null;
        endpoint = this.wsdl_1_1_definition != null ? this.getEndPointForService_1_1(serviceName) : this.getEndPointForService_2_0(serviceName, cache);
        if (endpoint != null) {
            return endpoint.toASCIIString();
        }
        return null;
    }

    private java.net.URI getEndPointForService_1_1(QName serviceName) {
        javax.wsdl.Service s = this.wsdl_1_1_definition.getService(serviceName);
        if (s == null) {
            return null;
        }
        Map ports = s.getPorts();
        Iterator portsIT = ports.keySet().iterator();
        java.net.URI endpoint = null;
        while (portsIT.hasNext()) {
            String portsName = (String)portsIT.next();
            Port port = s.getPort(portsName);
            Binding bindingOp = port.getBinding();
            if (!bindingOp.getQName().getLocalPart().equals(this.binding_1_1.getQName().getLocalPart())) continue;
            List list = port.getExtensibilityElements();
            for (int i = 0; i < list.size(); ++i) {
                Element soapBind;
                SOAPAddress address;
                ExtensibilityElement pe = (ExtensibilityElement)list.get(i);
                String endPointStr = null;
                if (pe instanceof SOAPAddress) {
                    address = (SOAPAddress)pe;
                    endPointStr = address.getLocationURI();
                } else if (pe instanceof SOAP12Address) {
                    address = (SOAP12Address)pe;
                    endPointStr = address.getLocationURI();
                } else if (this.wsdl_1_1_soap_1_2_soapBinding != null && (soapBind = this.getWSDL_1_1_SOAP_1_2_addressElement(pe)) != null) {
                    endPointStr = this.getAttributeValue(soapBind, "location");
                }
                try {
                    if (endPointStr == null) continue;
                    endpoint = new java.net.URI(endPointStr);
                    this.thePort_1_1 = port;
                    continue;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace(this.log);
                    Logging.writeMessage(12, "DFHPI9632E", new Object[]{endPointStr, e.getLocalizedMessage()});
                }
            }
        }
        return endpoint;
    }

    private QName getQualifiedServiceName(String localName) {
        if (this.wsdl_1_1_definition != null) {
            return this.getQualifiedServiceName_1_1(localName);
        }
        return this.getQualifiedServiceName_2_0(localName);
    }

    private QName getQualifiedServiceName_1_1(String localName) {
        Map services = this.wsdl_1_1_definition.getServices();
        for (QName serviceName : services.keySet()) {
            if (!serviceName.getLocalPart().equals(localName)) continue;
            return serviceName;
        }
        return null;
    }

    private QName getQualifiedServiceName_2_0(String localName) {
        Service[] services = this.wsdl_2_0_description.getServices();
        for (int i = 0; i < services.length; ++i) {
            QName serviceName = services[i].getName();
            if (!serviceName.getLocalPart().equals(localName)) continue;
            return serviceName;
        }
        return null;
    }

    private java.net.URI getEndPointForService_2_0(QName serviceName, boolean cache) {
        Service service = this.getServiceFromQName_2_0(serviceName);
        if (service == null) {
            return null;
        }
        java.net.URI endpoint = null;
        Endpoint[] endPoints = service.getEndpoints();
        for (int ep = 0; ep < endPoints.length; ++ep) {
            java.net.URI address;
            if (!this.binding_2_0.equals((WSDLComponent)endPoints[ep].getBinding())) continue;
            endpoint = address = endPoints[ep].getAddress();
        }
        return endpoint;
    }

    private void readWSDLFromFile(String wsdlFileName) throws CICSWSDLException {
        boolean mustLogWsdlFile = true;
        try {
            javax.wsdl.factory.WSDLFactory w = javax.wsdl.factory.WSDLFactory.newInstance();
            javax.wsdl.xml.WSDLReader r = w.newWSDLReader();
            r.setFeature("javax.wsdl.verbose", true);
            r.setFeature("javax.wsdl.importDocuments", true);
            Util.checkXMLEncoding(wsdlFileName, this.log, this.runZOS);
            File f = new File(wsdlFileName);
            FileInputStream fis = new FileInputStream(f);
            InputSource is = new InputSource(fis);
            File f2 = f.getParentFile();
            if (f2 != null) {
                this.dirName = f2.getCanonicalPath();
            }
            try {
                this.wsdl_1_1_definition = r.readWSDL(wsdlFileName, is);
            }
            catch (javax.wsdl.WSDLException e) {
                this.closeInputStream(fis);
                if (e.getFaultCode() == "INVALID_WSDL" && e.getLocation().equals("/description")) {
                    this.readWSDL_2_0_fromFile(wsdlFileName);
                }
                throw e;
            }
            this.closeInputStream(fis);
            mustLogWsdlFile = false;
        }
        catch (javax.wsdl.WSDLException e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{wsdlFileName, e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        catch (FileNotFoundException fne) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9528E", new Object[]{wsdlFileName}));
            newEx.initCause(fne);
            throw newEx;
        }
        catch (WSDLException wsdl20Exc) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{wsdlFileName, wsdl20Exc.getLocalizedMessage()}));
            newEx.initCause(wsdl20Exc);
            throw newEx;
        }
        catch (CICSWSDLException cwe) {
            CICSWSDLException newEx = new CICSWSDLException(cwe.getLocalizedMessage());
            newEx.initCause(cwe);
            throw newEx;
        }
        catch (Exception e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{wsdlFileName, e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        finally {
            if (mustLogWsdlFile) {
                try {
                    FileReader fr = new FileReader(new File(wsdlFileName).getAbsoluteFile());
                    BufferedReader bf = new BufferedReader(fr);
                    String line = bf.readLine();
                    while (line != null) {
                        line = bf.readLine();
                    }
                    bf.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void closeInputStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace(Logging.getPrintStream());
        }
    }

    private void readWSDL_2_0_fromFile(String wsdlFileName) throws WSDLException, CICSWSDLException {
        Description descComp;
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("http://ws.apache.org/woden/features/validation", true);
        URI uri = URI.createFileURI((String)wsdlFileName);
        reader.getErrorReporter().setErrorHandler((ErrorHandler)this);
        DescriptionElement desc = reader.readWSDL(uri.toString()).toElement();
        if (this.errorMsg_2_0 != null) {
            throw new CICSWSDLException(this.errorMsg_2_0);
        }
        this.wsdl_2_0_description = descComp = desc.toComponent();
    }

    private void getAllBindings_1_1(Map<QName, Binding> allBindings, Definition currentDef) {
        Map allImports = currentDef.getImports();
        allBindings.putAll(currentDef.getBindings());
        Iterator importIterator = allImports.keySet().iterator();
        while (importIterator.hasNext()) {
            List imports = (List)allImports.get(importIterator.next());
            for (Import anImport : imports) {
                Definition nestedDef = anImport.getDefinition();
                this.getAllBindings_1_1(allBindings, nestedDef);
            }
        }
    }

    public final String checkConsistentStyle() throws CICSWSDLException {
        if (this.binding_2_0 != null) {
            return STYLE_DOCUMENT;
        }
        String bindingStyle = this.getStyle();
        List bindingOperations = this.binding_1_1.getBindingOperations();
        boolean consistent = true;
        boolean styleSet = false;
        String lastStyle = null;
        String thisStyle = null;
        for (BindingOperation bindOp : bindingOperations) {
            for (ExtensibilityElement thisElement : bindOp.getExtensibilityElements()) {
                Element soapOp;
                if (thisElement instanceof SOAPOperation) {
                    thisStyle = ((SOAPOperation)thisElement).getStyle();
                    break;
                }
                if (thisElement instanceof SOAP12Operation) {
                    thisStyle = ((SOAP12Operation)thisElement).getStyle();
                    break;
                }
                if (this.wsdl_1_1_soap_1_2_soapBinding == null || (soapOp = this.getWSDL_1_1_SOAP_1_2_operationElement(thisElement)) == null) continue;
                thisStyle = this.getAttributeValue(soapOp, "style");
                break;
            }
            if (thisStyle == null) {
                thisStyle = bindingStyle;
            }
            if (styleSet) {
                if (thisStyle != null && !thisStyle.equalsIgnoreCase(lastStyle)) {
                    consistent = false;
                }
            } else {
                styleSet = true;
            }
            lastStyle = thisStyle;
        }
        if (!consistent) {
            throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9595E"));
        }
        return lastStyle;
    }

    private void throwInternalError(String methodName) throws CICSWSDLException {
        throw new CICSWSDLException("INTERNAL ERROR: bad WSDL version in " + methodName + ".");
    }

    private void throwInternalError(String methodName, ICM.XMLContentType icmType) throws CICSWSDLException {
        throw new CICSWSDLException("INTERNAL ERROR: bad ICM type " + (Object)((Object)icmType) + " in " + methodName + ".");
    }

    public String getRPCNameSpaceForOperation(String operationName, ICM.XMLContentType type) throws CICSWSDLException {
        if (this.wsdl_1_1_definition != null) {
            Message msg = this.getMessage_1_1(operationName, type);
            BindingOperation bop = this.getBindingOperation_1_1(operationName);
            List extensibilityElements = null;
            switch (type) {
                case SOAP_REQUEST: {
                    BindingInput bin;
                    if (bop == null || (bin = bop.getBindingInput()) == null) break;
                    extensibilityElements = bin.getExtensibilityElements();
                    break;
                }
                case SOAP_RESPONSE: {
                    BindingOutput bout;
                    if (bop == null || (bout = bop.getBindingOutput()) == null) break;
                    extensibilityElements = bout.getExtensibilityElements();
                    break;
                }
                default: {
                    this.throwInternalError("getRPCNameSpaceForOperation", type);
                }
            }
            if (extensibilityElements != null) {
                for (int i = 0; i < extensibilityElements.size(); ++i) {
                    Element bodyBind;
                    ExtensibilityElement thisElement = (ExtensibilityElement)extensibilityElements.get(i);
                    if (this.wsdl_1_1_soap_1_2_soapBinding != null) {
                        String ns;
                        bodyBind = this.getWSDL_1_1_SOAP_1_2_bodyElement(thisElement);
                        if (bodyBind == null || (ns = this.getAttributeValue(bodyBind, "namespace")) == null) continue;
                        return ns;
                    }
                    if (!(thisElement instanceof SOAPBody ? (bodyBind = (SOAPBody)thisElement).getNamespaceURI() != null : thisElement instanceof SOAP12Body && (bodyBind = (SOAP12Body)thisElement).getNamespaceURI() != null)) continue;
                    return bodyBind.getNamespaceURI();
                }
            }
            if (msg != null) {
                return msg.getQName().getNamespaceURI();
            }
            return this.binding_1_1.getQName().getNamespaceURI();
        }
        if (this.wsdl_2_0_description != null) {
            return null;
        }
        this.throwInternalError("getNameSpaceForWSDL");
        return null;
    }

    public final String getZipfilename() {
        return this.zipfilename;
    }

    public final String getInputAction(String operationName, int mep) throws CICSWSDLException {
        String action = null;
        if (this.wsdl_1_1_definition != null) {
            action = this.getInputAction_1_1(operationName, mep);
        } else if (this.wsdl_2_0_description != null) {
            action = this.getInputAction_2_0(operationName, mep);
        } else {
            this.throwInternalError("getInputAction");
        }
        return action;
    }

    public final String getInputAction_1_1(String operationName, int mep) throws CICSWSDLException {
        Input input;
        String action = CALCULATED_ACTION;
        String delimiter = "/";
        Operation op = this.getOperation_1_1(operationName);
        if (op != null && (input = op.getInput()) != null) {
            String attrLocalPart;
            String attrURI;
            QName q = new QName(WS_ADDRESSING_METADATA_NS, WS_ADDRESSING_ACTION);
            QName attr = (QName)input.getExtensionAttribute(q);
            if (attr != null) {
                attrURI = attr.getNamespaceURI();
                attrLocalPart = attr.getLocalPart();
                action = attrURI != null && attrURI.length() > 0 && attrLocalPart != null && attrLocalPart.length() > 0 && attrURI.equals(WSDL_SCHEMA_HTTP_NS) ? "Shttp:" + attrLocalPart : SUPPLIED_ACTION + attr.getLocalPart();
            }
            if (attr == null && (attr = (QName)input.getExtensionAttribute(q = new QName(WS_ADDRESSING_SUBS_NS, WS_ADDRESSING_ACTION))) != null) {
                attrURI = attr.getNamespaceURI();
                attrLocalPart = attr.getLocalPart();
                action = attrURI != null && attrURI.length() > 0 && attrLocalPart != null && attrLocalPart.length() > 0 && attrURI.equals(WSDL_SCHEMA_HTTP_NS) ? "Shttp:" + attrLocalPart : SUPPLIED_ACTION + attr.getLocalPart();
            }
            if (action == CALCULATED_ACTION) {
                String tns = this.getTargetNameSpaceNoSlash();
                delimiter = this.getDelimiterForURI(tns);
                String portTypeName = this.binding_1_1.getPortType().getQName().getLocalPart();
                String inputName = input.getName();
                if (inputName == null) {
                    inputName = op.getName();
                    if (mep != 2) {
                        inputName = inputName + "Request";
                    }
                }
                action = action + tns + delimiter + portTypeName + delimiter + inputName;
            }
        }
        return action;
    }

    public final String getInputAction_2_0(String operationName, int mep) throws CICSWSDLException {
        String action = CALCULATED_ACTION;
        String delimiter = "/";
        InterfaceOperation op = this.getOperation_2_0(operationName);
        if (op != null) {
            InterfaceMessageReference[] irm = op.getInterfaceMessageReferences();
            for (int i = 0; i < irm.length; ++i) {
                QName q;
                if (irm[i].getDirection() != Direction.IN) continue;
                InterfaceMessageReferenceElement irme = irm[i].toElement();
                XMLAttr attr = irme.getExtensionAttribute(q = new QName(WS_ADDRESSING_METADATA_NS, WS_ADDRESSING_ACTION));
                if (attr != null) {
                    action = SUPPLIED_ACTION + attr.toExternalForm();
                }
                if (attr != null || (attr = irme.getExtensionAttribute(q = new QName(WS_ADDRESSING_SUBS_NS, WS_ADDRESSING_ACTION))) == null) continue;
                action = SUPPLIED_ACTION + attr.toExternalForm();
            }
            if (action.equals(CALCULATED_ACTION)) {
                String tns = this.getTargetNameSpaceNoSlash();
                delimiter = this.getDelimiterForURI(tns);
                String interfaceName = ((Interface)op.getParent()).getName().getLocalPart();
                String directionToken = "";
                switch (mep) {
                    case 2: 
                    case 3: {
                        directionToken = "";
                        break;
                    }
                    case 1: 
                    case 4: {
                        directionToken = "Request";
                        break;
                    }
                    default: {
                        this.throwInternalError("getInputAction_2_0");
                    }
                }
                action = action + tns + delimiter + interfaceName + delimiter + operationName + directionToken;
            }
        }
        return action;
    }

    public final String getOutputAction(String operationName, int mep) throws CICSWSDLException {
        String action = null;
        if (this.wsdl_1_1_definition != null) {
            action = this.getOutputAction_1_1(operationName, mep);
        } else if (this.wsdl_2_0_description != null) {
            action = this.getOutputAction_2_0(operationName, mep);
        } else {
            this.throwInternalError("getOutputAction");
        }
        return action;
    }

    public final String getOutputAction_1_1(String operationName, int mep) throws CICSWSDLException {
        Output output;
        String action = CALCULATED_ACTION;
        String delimiter = "/";
        Operation op = this.getOperation_1_1(operationName);
        if (op != null && (output = op.getOutput()) != null) {
            String attrLocalPart;
            String attrURI;
            QName q = new QName(WS_ADDRESSING_METADATA_NS, WS_ADDRESSING_ACTION);
            QName attr = (QName)output.getExtensionAttribute(q);
            if (attr != null) {
                attrURI = attr.getNamespaceURI();
                attrLocalPart = attr.getLocalPart();
                action = attrURI != null && attrURI.length() > 0 && attrLocalPart != null && attrLocalPart.length() > 0 && attrURI.equals(WSDL_SCHEMA_HTTP_NS) ? "Shttp:" + attrLocalPart : SUPPLIED_ACTION + attr.getLocalPart();
            }
            if (attr == null && (attr = (QName)output.getExtensionAttribute(q = new QName(WS_ADDRESSING_SUBS_NS, WS_ADDRESSING_ACTION))) != null) {
                attrURI = attr.getNamespaceURI();
                attrLocalPart = attr.getLocalPart();
                action = attrURI != null && attrURI.length() > 0 && attrLocalPart != null && attrLocalPart.length() > 0 && attrURI.equals(WSDL_SCHEMA_HTTP_NS) ? "Shttp:" + attrLocalPart : SUPPLIED_ACTION + attr.getLocalPart();
            }
            if (action == CALCULATED_ACTION) {
                String tns = this.getTargetNameSpaceNoSlash();
                delimiter = this.getDelimiterForURI(tns);
                String portTypeName = this.binding_1_1.getPortType().getQName().getLocalPart();
                String outputName = output.getName();
                if (outputName == null) {
                    outputName = op.getName();
                    if (mep != 2) {
                        outputName = outputName + "Response";
                    }
                }
                action = action + tns + delimiter + portTypeName + delimiter + outputName;
            }
        }
        return action;
    }

    public final String getOutputAction_2_0(String operationName, int mep) throws CICSWSDLException {
        String action = CALCULATED_ACTION;
        String delimiter = "/";
        InterfaceOperation op = this.getOperation_2_0(operationName);
        if (op != null) {
            InterfaceMessageReference[] irm = op.getInterfaceMessageReferences();
            for (int i = 0; i < irm.length; ++i) {
                QName q;
                if (irm[i].getDirection() != Direction.OUT) continue;
                InterfaceMessageReferenceElement irme = irm[i].toElement();
                XMLAttr attr = irme.getExtensionAttribute(q = new QName(WS_ADDRESSING_METADATA_NS, WS_ADDRESSING_ACTION));
                if (attr != null) {
                    action = SUPPLIED_ACTION + attr.toExternalForm();
                }
                if (attr != null || (attr = irme.getExtensionAttribute(q = new QName(WS_ADDRESSING_SUBS_NS, WS_ADDRESSING_ACTION))) == null) continue;
                action = SUPPLIED_ACTION + attr.toExternalForm();
            }
            if (action.equals(CALCULATED_ACTION)) {
                String tns = this.getTargetNameSpaceNoSlash();
                delimiter = this.getDelimiterForURI(tns);
                String interfaceName = ((Interface)op.getParent()).getName().getLocalPart();
                String directionToken = "";
                switch (mep) {
                    case 2: 
                    case 3: {
                        directionToken = "";
                        break;
                    }
                    case 1: 
                    case 4: {
                        directionToken = "Response";
                        break;
                    }
                    default: {
                        this.throwInternalError("getOutputAction_2_0");
                    }
                }
                action = action + tns + delimiter + interfaceName + delimiter + operationName + directionToken;
            }
        }
        return action;
    }

    public final List<WSAddressingFault> getFaultAction(String operationName, int mep) throws CICSWSDLException {
        List<WSAddressingFault> faultActions = null;
        if (this.wsdl_1_1_definition != null) {
            faultActions = this.getFaultActions_1_1(operationName);
        } else if (this.wsdl_2_0_description != null) {
            faultActions = this.getFaultActions_2_0(operationName, mep);
        } else {
            this.throwInternalError("getFaultAction");
            return null;
        }
        return faultActions;
    }

    public final List<WSAddressingFault> getFaultActions_1_1(String operationName) throws CICSWSDLException {
        Map faults;
        ArrayList<WSAddressingFault> faultActions = new ArrayList<WSAddressingFault>();
        String portTypeName = this.binding_1_1.getPortType().getQName().getLocalPart();
        faultActions.add(this.createDefaultFaultAction_1_1(portTypeName, operationName));
        Operation op = this.getOperation_1_1(operationName);
        if (op != null && (faults = op.getFaults()) != null && !faults.isEmpty()) {
            Collection c = faults.values();
            for (Fault wsdlFault : c) {
                WSAddressingFault faultAction = this.calculateWSAddressingAction_1_1(wsdlFault, new QName(WS_ADDRESSING_METADATA_NS, WS_ADDRESSING_ACTION));
                if (faultAction == null) {
                    faultAction = this.calculateWSAddressingAction_1_1(wsdlFault, new QName(WS_ADDRESSING_SUBS_NS, WS_ADDRESSING_ACTION));
                }
                if (faultAction == null) continue;
                faultActions.add(faultAction);
            }
        }
        return faultActions;
    }

    private WSAddressingFault calculateWSAddressingAction_1_1(Fault theSOAPFault, QName addressingActionAttribute) {
        QName attr = (QName)theSOAPFault.getExtensionAttribute(addressingActionAttribute);
        if (attr != null) {
            String attrURI = attr.getNamespaceURI();
            String attrLocalPart = attr.getLocalPart();
            String action = attrURI != null && attrURI.length() > 0 && attrLocalPart != null && attrLocalPart.length() > 0 && attrURI.equals(WSDL_SCHEMA_HTTP_NS) ? "Shttp:" + attrLocalPart : SUPPLIED_ACTION + attrLocalPart;
            Map faultParts = theSOAPFault.getMessage().getParts();
            Map.Entry firstKey = faultParts.entrySet().iterator().next();
            return new WSAddressingFault(((Part)firstKey.getValue()).getElementName(), action);
        }
        return null;
    }

    private WSAddressingFault createDefaultFaultAction_1_1(String portTypeName, String operationName) throws CICSWSDLException {
        String tns = this.getTargetNameSpaceNoSlash();
        String delimiter = this.getDelimiterForURI(tns);
        String action = CALCULATED_ACTION + tns + delimiter + portTypeName + delimiter + operationName + delimiter + "Fault" + delimiter;
        return new WSAddressingFault(null, action);
    }

    public final List<WSAddressingFault> getFaultActions_2_0(String operationName, int mep) throws CICSWSDLException {
        ArrayList<WSAddressingFault> faultActions = new ArrayList<WSAddressingFault>();
        InterfaceOperation op = this.getOperation_2_0(operationName);
        String interfaceName = ((Interface)op.getParent()).getName().getLocalPart();
        faultActions.add(this.createDefaultFaultAction_2_0(interfaceName, operationName, mep));
        InterfaceFaultReference[] ifm = op.getInterfaceFaultReferences();
        for (int i = 0; i < ifm.length; ++i) {
            WSAddressingFault faultAction = this.calculateWSAddressingAction_2_0(ifm[i], new QName(WS_ADDRESSING_METADATA_NS, WS_ADDRESSING_ACTION));
            if (faultAction == null) {
                faultAction = this.calculateWSAddressingAction_2_0(ifm[i], new QName(WS_ADDRESSING_SUBS_NS, WS_ADDRESSING_ACTION));
            }
            if (faultAction == null) continue;
            faultActions.add(faultAction);
        }
        return faultActions;
    }

    private WSAddressingFault calculateWSAddressingAction_2_0(InterfaceFaultReference theSOAPFault, QName addressingActionAttribute) {
        InterfaceFaultReferenceElement el = theSOAPFault.toElement();
        XMLAttr attr = el.getExtensionAttribute(addressingActionAttribute);
        if (attr != null) {
            String action = SUPPLIED_ACTION + attr.toExternalForm();
            return new WSAddressingFault(theSOAPFault.getInterfaceFault().getElementDeclaration().getName(), action);
        }
        return null;
    }

    private WSAddressingFault createDefaultFaultAction_2_0(String interfaceName, String operationName, int mep) throws CICSWSDLException {
        String tns = this.getTargetNameSpaceNoSlash();
        String delimiter = this.getDelimiterForURI(tns);
        String directionToken = "";
        switch (mep) {
            case 2: 
            case 3: {
                directionToken = "";
                break;
            }
            case 1: 
            case 4: {
                directionToken = "Request";
                break;
            }
            default: {
                this.throwInternalError("getFaultAction_2_0");
            }
        }
        String action = CALCULATED_ACTION + tns + delimiter + interfaceName + delimiter + operationName + directionToken + delimiter;
        return new WSAddressingFault(null, action);
    }

    public final String getEndpointEPRAddress(String serviceName, String bindingName) throws CICSWSDLException {
        String address = null;
        if (this.wsdl_1_1_definition != null) {
            address = this.getEndpointEPRAddress_1_1(serviceName, bindingName);
        } else if (this.wsdl_2_0_description != null) {
            address = this.getEndpointEPRAddress_2_0(serviceName);
        } else {
            this.throwInternalError("getEndpointEPRAddress");
        }
        return address;
    }

    public final String getEndpointEPRAddress_1_1(String serviceName, String bindingName) throws CICSWSDLException {
        javax.wsdl.Service service;
        String address = null;
        String bName = this.getBindingName(bindingName);
        QName serviceQN = this.getServiceQName(serviceName);
        if (serviceQN != null && (service = this.wsdl_1_1_definition.getService(serviceQN)) != null) {
            Map ports = service.getPorts();
            block0: for (String portsName : ports.keySet()) {
                Port port = service.getPort(portsName);
                Binding bindingOp = port.getBinding();
                if (!bindingOp.getQName().getLocalPart().equals(bName)) continue;
                List list = port.getExtensibilityElements();
                for (int i = 0; i < list.size(); ++i) {
                    UnknownExtensibilityElement uElement;
                    QName type;
                    Object obj = list.get(i);
                    if (!(obj instanceof UnknownExtensibilityElement) || !(type = (uElement = (UnknownExtensibilityElement)obj).getElementType()).getNamespaceURI().equals(WS_ADDRESSING_NS) && !type.getNamespaceURI().equals(WS_ADDRESSING_SUBS_NS) || !type.getLocalPart().equals(WS_ADDRESSING_EPR)) continue;
                    Element domElement = uElement.getElement();
                    NodeList nodeList = domElement.getElementsByTagNameNS(type.getNamespaceURI(), WS_ADDRESSING_ADDRESS);
                    if (nodeList.getLength() > 0) {
                        Node node = nodeList.item(0);
                        Node text = node.getFirstChild();
                        if (text == null) continue;
                        address = text.getNodeValue();
                        continue block0;
                    }
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9679E", new Object[0]));
                }
            }
        }
        return address;
    }

    public final String getEndpointEPRAddress_2_0(String serviceName) throws CICSWSDLException {
        Service service;
        String address = null;
        QName serviceQN = this.getServiceQName(serviceName);
        if (serviceQN != null && (service = this.getServiceFromQName_2_0(serviceQN)) != null) {
            Endpoint[] endPoints = service.getEndpoints();
            for (int ep = 0; ep < endPoints.length; ++ep) {
                if (!this.binding_2_0.equals((WSDLComponent)endPoints[ep].getBinding())) continue;
                QName type = new QName(WS_ADDRESSING_NS, WS_ADDRESSING_EPR);
                ExtensionElement[] eElements = endPoints[ep].toElement().getExtensionElementsOfType(type);
                if (eElements == null || eElements.length == 0) {
                    type = new QName(WS_ADDRESSING_SUBS_NS, WS_ADDRESSING_EPR);
                    eElements = endPoints[ep].toElement().getExtensionElementsOfType(type);
                }
                for (int i = 0; i < eElements.length; ++i) {
                    if (!(eElements[i] instanceof UnknownExtensionElement)) continue;
                    UnknownExtensionElement uElement = (UnknownExtensionElement)eElements[i];
                    XMLElement xmlElement = uElement.getElement();
                    XMLElement[] xmlElements = xmlElement.getChildElements();
                    for (int j = 0; j < xmlElements.length; ++j) {
                        type = xmlElements[j].getQName();
                        if (!type.getNamespaceURI().equals(WS_ADDRESSING_NS) && !type.getNamespaceURI().equals(WS_ADDRESSING_SUBS_NS) || !type.getLocalPart().equals(WS_ADDRESSING_ADDRESS)) continue;
                        Element element = (Element)xmlElements[j].getSource();
                        Node text = element.getFirstChild();
                        if (text == null) break;
                        address = text.getNodeValue();
                        break;
                    }
                    if (address != null && !address.equals("")) continue;
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9679E", new Object[0]));
                }
            }
        }
        return address;
    }

    public final String getEndpointEPR(String serviceName, String bindingName) throws CICSWSDLException {
        String epr = null;
        if (this.wsdl_1_1_definition != null) {
            epr = this.getEndpointEPR_1_1(serviceName, bindingName);
        } else if (this.wsdl_2_0_description != null) {
            epr = this.getEndpointEPR_2_0(serviceName);
        } else {
            this.throwInternalError("getEndpointEPR");
        }
        return epr;
    }

    public final String getEndpointEPR_1_1(String serviceName, String bindingName) throws CICSWSDLException {
        javax.wsdl.Service service;
        String epr = null;
        String addressingNSPrefix = "";
        String metadataNSPrefix = "";
        String namespace = "";
        String bName = this.getBindingName(bindingName);
        QName serviceQN = this.getServiceQName(serviceName);
        if (serviceQN != null && (service = this.wsdl_1_1_definition.getService(serviceQN)) != null) {
            Map ports = service.getPorts();
            for (String portsName : ports.keySet()) {
                Port port = service.getPort(portsName);
                Binding bindingOp = port.getBinding();
                if (!bindingOp.getQName().getLocalPart().equals(bName)) continue;
                List list = port.getExtensibilityElements();
                boolean foundEPR = false;
                for (int i = 0; i < list.size(); ++i) {
                    Node node;
                    UnknownExtensibilityElement uElement;
                    QName type;
                    Object obj = list.get(i);
                    if (!(obj instanceof UnknownExtensibilityElement) || !(type = (uElement = (UnknownExtensibilityElement)obj).getElementType()).getNamespaceURI().equals(WS_ADDRESSING_NS) && !type.getNamespaceURI().equals(WS_ADDRESSING_SUBS_NS) || !type.getLocalPart().equals(WS_ADDRESSING_EPR)) continue;
                    if (foundEPR) {
                        throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9675E", new Object[0]));
                    }
                    this.validateEPR_1_1(type.getNamespaceURI(), uElement);
                    String nodeName = uElement.getElement().getNodeName();
                    addressingNSPrefix = nodeName.substring(0, nodeName.indexOf(58) + 1);
                    namespace = type.getNamespaceURI();
                    foundEPR = true;
                    Element domElement = uElement.getElement();
                    NodeList nodeList = domElement.getElementsByTagNameNS(WS_ADDRESSING_METADATA_NS, WS_ADDRESSING_META_INTERFACE);
                    if (nodeList.getLength() > 0) {
                        node = nodeList.item(0);
                        metadataNSPrefix = node.getPrefix() + ":";
                    }
                    if ((nodeList = domElement.getElementsByTagNameNS(WS_ADDRESSING_METADATA_NS, "ServiceName")).getLength() <= 0) continue;
                    node = nodeList.item(0);
                    metadataNSPrefix = node.getPrefix() + ":";
                }
            }
        }
        if (serviceQN != null) {
            try {
                StringWriter stringWrt = new StringWriter();
                javax.wsdl.factory.WSDLFactory factory = javax.wsdl.factory.WSDLFactory.newInstance();
                WSDLWriter wsdlWrt = factory.newWSDLWriter();
                wsdlWrt.writeWSDL(this.wsdl_1_1_definition, (Writer)stringWrt);
                epr = stringWrt.toString();
            }
            catch (javax.wsdl.WSDLException ex) {
                this.throwInternalError("getEndpointEPR_1_1");
            }
            if (epr != null) {
                int serviceLoc = epr.indexOf("service name=\"" + serviceQN.getLocalPart() + "\"");
                epr = epr.substring(serviceLoc);
                int bindingLoc = epr.indexOf(this.bindingLocalName);
                int eprLoc = (epr = epr.substring(bindingLoc)).indexOf("<" + addressingNSPrefix + WS_ADDRESSING_EPR);
                if (eprLoc != -1) {
                    epr = epr.substring(eprLoc);
                    epr = epr.substring(0, epr.indexOf("</" + addressingNSPrefix + "EndpointReference>") + ("</" + addressingNSPrefix + "EndpointReference>").length());
                    addressingNSPrefix = addressingNSPrefix.substring(0, addressingNSPrefix.length() - 1);
                    String nameSpaceTags = " xmlns:" + addressingNSPrefix + "=\"" + namespace + "\"";
                    if (!metadataNSPrefix.equals("")) {
                        metadataNSPrefix = metadataNSPrefix.substring(0, metadataNSPrefix.length() - 1);
                        nameSpaceTags = nameSpaceTags + " xmlns:" + metadataNSPrefix + "=\"" + WS_ADDRESSING_METADATA_NS + "\"";
                    }
                    epr = epr.replaceFirst(">", nameSpaceTags + ">");
                    epr = epr.replaceAll("\\s+", " ");
                    epr = epr.trim();
                } else {
                    epr = null;
                }
            }
        }
        return epr;
    }

    private void validateEPR_1_1(String targetNamespace, UnknownExtensibilityElement uxElement) throws CICSWSDLException {
        Element element = uxElement.getElement();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String name = node.getLocalName();
            String ns = node.getNamespaceURI();
            if (ns == null && name == null || targetNamespace.equals(ns) && name.equals(WS_ADDRESSING_ADDRESS) || targetNamespace.equals(ns) && name.equals(WS_ADDRESSING_REFPARAM) || targetNamespace.equals(ns) && WS_ADDRESSING_NS.equals(ns) && name.equals(WS_ADDRESSING_METADATA) || targetNamespace.equals(ns) && WS_ADDRESSING_SUBS_NS.equals(ns) && name.equals(WS_ADDRESSING_REFPROP) || targetNamespace.equals(ns) && WS_ADDRESSING_SUBS_NS.equals(ns) && name.equals("ServiceName") || targetNamespace.equals(ns) && WS_ADDRESSING_SUBS_NS.equals(ns) && name.equals(WS_ADDRESSING_PORT_TYPE) || targetNamespace.equals(WS_POLICY_NS) && name.equals(WS_ADDRESSING_POLICY) || targetNamespace.equals(WS_ADDRESSING_NS) && WS_ADDRESSING_IDENTITY_NS.equals(ns) && name.equals(WS_ADDRESSING_IDENTITY)) continue;
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9677E", new Object[]{ns + ":" + name}));
        }
    }

    public final String getEndpointEPR_2_0(String serviceName) throws CICSWSDLException {
        Service service;
        String epr = null;
        String addressingNSPrefix = "";
        String metadataNSPrefix = "";
        String namespace = WS_ADDRESSING_NS;
        DOMXMLElement domElement = null;
        QName serviceQN = this.getServiceQName(serviceName);
        if (serviceQN != null && (service = this.getServiceFromQName_2_0(serviceQN)) != null) {
            Endpoint[] endPoints = service.getEndpoints();
            block2: for (int ep = 0; ep < endPoints.length; ++ep) {
                if (!this.binding_2_0.equals((WSDLComponent)endPoints[ep].getBinding())) continue;
                QName type = new QName(WS_ADDRESSING_NS, WS_ADDRESSING_EPR);
                ExtensionElement[] eElements = endPoints[ep].toElement().getExtensionElementsOfType(type);
                if (eElements == null || eElements.length == 0) {
                    type = new QName(WS_ADDRESSING_SUBS_NS, WS_ADDRESSING_EPR);
                    eElements = endPoints[ep].toElement().getExtensionElementsOfType(type);
                    namespace = WS_ADDRESSING_SUBS_NS;
                }
                if (eElements.length > 1) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9675E", new Object[0]));
                }
                if (!(eElements[0] instanceof UnknownExtensionElement)) continue;
                UnknownExtensionElement uElement = (UnknownExtensionElement)eElements[0];
                domElement = (DOMXMLElement)uElement.getElement();
                this.validateEPR_2_0(uElement);
                addressingNSPrefix = ((Element)domElement.getSource()).getPrefix() + ":";
                XMLElement[] xmlElements = uElement.getElement().getChildElements();
                for (int j = 0; j < xmlElements.length; ++j) {
                    QName qName = xmlElements[j].getQName();
                    if (!qName.getNamespaceURI().equals(WS_ADDRESSING_NS) || !qName.getLocalPart().equals(WS_ADDRESSING_METADATA)) continue;
                    XMLElement[] metadataElements = xmlElements[j].getChildElements();
                    for (int k = 0; k < metadataElements.length; ++k) {
                        qName = metadataElements[k].getQName();
                        if (!qName.getNamespaceURI().equals(WS_ADDRESSING_METADATA_NS) || !qName.getLocalPart().equals(WS_ADDRESSING_META_INTERFACE) && !qName.getLocalPart().equals("ServiceName")) continue;
                        metadataNSPrefix = ((Element)metadataElements[k].getSource()).getPrefix() + ":";
                        break block2;
                    }
                }
            }
        }
        if (serviceQN != null && domElement != null) {
            try {
                StringWriter stringWrt = new StringWriter();
                Element element = (Element)domElement.getSource();
                TransformerFactory fact = TransformerFactory.newInstance();
                Transformer trans = fact.newTransformer();
                trans.setOutputProperty("indent", "yes");
                trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                trans.setOutputProperty("encoding", "UTF-8");
                trans.transform(new DOMSource(element), new StreamResult(stringWrt));
                epr = stringWrt.toString();
                epr = epr.substring(epr.indexOf(62) + 1);
            }
            catch (Exception ex) {
                this.throwInternalError("getEndpointEPR_2_0");
            }
            if (epr != null) {
                addressingNSPrefix = addressingNSPrefix.substring(0, addressingNSPrefix.length() - 1);
                String nameSpaceTags = " xmlns:" + addressingNSPrefix + "=\"" + namespace + "\"";
                if (!metadataNSPrefix.equals("")) {
                    metadataNSPrefix = metadataNSPrefix.substring(0, metadataNSPrefix.length() - 1);
                    nameSpaceTags = nameSpaceTags + " xmlns:" + metadataNSPrefix + "=\"" + WS_ADDRESSING_METADATA_NS + "\"";
                }
                epr = epr.replaceFirst(">", nameSpaceTags + ">");
                epr = epr.replaceAll("\\s+", " ");
                epr = epr.trim();
            }
        }
        return epr;
    }

    private void validateEPR_2_0(UnknownExtensionElement uxElement) throws CICSWSDLException {
        DOMXMLElement element = (DOMXMLElement)uxElement.getElement();
        XMLElement[] childElements = element.getChildElements();
        String targetNamespace = uxElement.getElement().getQName().getNamespaceURI();
        for (int i = 0; i < childElements.length; ++i) {
            String name = childElements[i].getLocalName();
            String ns = childElements[i].getQName().getNamespaceURI();
            if (ns == null && name == null || targetNamespace.equals(ns) && name.equals(WS_ADDRESSING_ADDRESS) || targetNamespace.equals(ns) && name.equals(WS_ADDRESSING_REFPARAM) || targetNamespace.equals(ns) && WS_ADDRESSING_NS.equals(ns) && name.equals(WS_ADDRESSING_METADATA) || targetNamespace.equals(ns) && WS_ADDRESSING_SUBS_NS.equals(ns) && name.equals(WS_ADDRESSING_REFPROP) || targetNamespace.equals(ns) && WS_ADDRESSING_SUBS_NS.equals(ns) && name.equals("ServiceName") || targetNamespace.equals(ns) && WS_ADDRESSING_SUBS_NS.equals(ns) && name.equals(WS_ADDRESSING_PORT_TYPE) || targetNamespace.equals(WS_POLICY_NS) && name.equals(WS_ADDRESSING_POLICY) || targetNamespace.equals(WS_ADDRESSING_NS) && WS_ADDRESSING_IDENTITY_NS.equals(ns) && name.equals(WS_ADDRESSING_IDENTITY)) continue;
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9677E", new Object[]{ns + ":" + name}));
        }
    }

    public String getMessagePartName(Object o) {
        MessagePart mp = (MessagePart)o;
        return mp.getPartName();
    }

    public QName getMessagePartElement(Object o) {
        MessagePart mp = (MessagePart)o;
        return mp.getElementName();
    }

    public boolean isWSDL_1_1() {
        return this.wsdl_1_1_definition != null;
    }

    public boolean isWSDL_2_0() {
        return this.wsdl_2_0_description != null;
    }

    public QName getMessagePartType(Object o) {
        MessagePart mp = (MessagePart)o;
        return mp.getTypeName();
    }

    public void warning(ErrorInfo warning) {
        this.handleError(warning, true);
    }

    public void error(ErrorInfo error) {
        this.handleError(error, false);
    }

    public void fatalError(ErrorInfo fatalError) {
        this.handleError(fatalError, false);
    }

    private void handleError(ErrorInfo error, boolean warning) {
        if (warning) {
            Logging.writePreFormattedMessage(1, error.getMessage());
            return;
        }
        String msg = MessageHandler.buildMessage("DFHPI9523E", new Object[]{this.filename, error.getMessage()});
        if (this.errorMsg_2_0 == null) {
            this.errorMsg_2_0 = msg;
            return;
        }
        Logging.writePreFormattedMessage(12, msg);
    }

    public String getWSDLFileLocation() {
        return this.filename;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void cleanUp() {
        if (this.zh != null) {
            this.zh.deleteAllExtracted();
            this.zh = null;
        }
    }

    static {
        try {
            WSDL_2_0_SOAP_BINDING_URI = new java.net.URI(WSDL_2_0_SOAP_BINDING);
            WSDL_2_0_SOAP_1_1_BINDING_URI = new java.net.URI(WSDL_2_0_SOAP_1_1_BINDING);
            WSDL_2_0_SOAP_1_2_BINDING_URI = new java.net.URI(WSDL_2_0_SOAP_1_2_BINDING);
            MEP_IN_ONLY_URI = new java.net.URI(MEP_IN_ONLY);
            MEP_ROBUST_IN_ONLY_URI = new java.net.URI(MEP_ROBUST_IN_ONLY);
            MEP_IN_OUT_URI = new java.net.URI(MEP_IN_OUT);
            MEP_IN_OPTIONAL_OUT_URI = new java.net.URI(MEP_IN_OPTIONAL_OUT);
            SOAP_MEP_HTTP_GET_URI = new java.net.URI(SOAP_MEP_HTTP_GET);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static class MessagePart {
        private QName elementName = null;
        private QName elementType = null;
        private String partName = null;

        public MessagePart(String partName) {
            this.partName = partName;
        }

        public void setElementName(QName uri) {
            this.elementName = uri;
        }

        public void setElementType(QName uri) {
            this.elementType = uri;
        }

        public String getPartName() {
            return this.partName;
        }

        public QName getElementName() {
            return this.elementName;
        }

        public QName getTypeName() {
            return this.elementType;
        }
    }
}

