/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ws2ls;

import com.ibm.cics.gen.api.IPlatform;
import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMBuilder;
import com.ibm.cics.schema.ICMCreationParameters;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.ICMInterceptor;
import com.ibm.cics.schema.ICMRuntimeException;
import com.ibm.cics.schema.impl.Factory;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.QNameComparator;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.common.WSBindAbstractTypeEntry;
import com.ibm.cics.wsdl.ws2ls.WSDLFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class WSDLToICM {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private static Map<String, QName> typesFromWSDL = new HashMap<String, QName>();
    private static Map<String, QName> elementsFromWSDL = new HashMap<String, QName>();
    private ICMBuilder builder;
    private String operationName;
    private WSDLFile wsdl;
    private String wsdlFilename;
    private ICM.BindingStyle soapStyle;
    private int language;
    private int mappingLevel = -1;
    private boolean soap11 = true;
    private int charVaryingLimit = Short.MAX_VALUE;
    private ICM.VaryingLength defaultCharVarying = ICM.VaryingLength.NO_VARYING_STRATEGY;
    private int defaultCharMaxLen = 255;
    private int charMultiplier = 1;
    private boolean useHexFloat = true;
    private boolean commareaInterface = false;
    private int inlineMaxOccursLimit = 0;
    private Properties p = null;
    private boolean useAbstimeDates = false;
    private boolean dataTruncationSupported = false;
    private int defaultFractionDigits;
    private ICMInterceptor interceptor = null;
    private List<QName> globalElements = new LinkedList<QName>();
    private List<QName> globalTypes = new LinkedList<QName>();
    private IPlatform platform;
    private static final boolean ELEMENT = true;
    private static final boolean TYPE = false;
    private Set<QName> enabledAsNillable = new TreeSet<QName>(new QNameComparator());

    WSDLToICM(WSDLFile wsdlFile, String operationName, Properties p, int mappingLevel, boolean soap11, int charVaryingLimit, ICM.VaryingLength defaultCharVarying, int defaultCharMaxLen, int charMultiplier, boolean useHexFloat, boolean commareaInterface, int inlineMaxOccursLimit, ICMInterceptor interceptor, boolean useAbstimeDates, boolean dataTruncationSupported, int defaultFractionDigits, IPlatform platform) {
        this.operationName = operationName;
        this.wsdl = wsdlFile;
        this.p = p;
        this.wsdlFilename = p.getProperty("WSDL");
        this.soapStyle = Util.getStyle(p.getProperty("STYLE"), false);
        this.language = Util.getLanguage(p.getProperty("LANG"));
        this.mappingLevel = mappingLevel;
        this.soap11 = soap11;
        this.charVaryingLimit = charVaryingLimit;
        this.defaultCharVarying = defaultCharVarying;
        this.defaultCharMaxLen = defaultCharMaxLen;
        this.charMultiplier = charMultiplier;
        this.useHexFloat = useHexFloat;
        this.commareaInterface = commareaInterface;
        this.inlineMaxOccursLimit = inlineMaxOccursLimit;
        this.interceptor = interceptor;
        this.useAbstimeDates = useAbstimeDates;
        this.dataTruncationSupported = dataTruncationSupported;
        this.defaultFractionDigits = defaultFractionDigits;
        this.platform = platform;
    }

    public final ICM getOperationICM(ICM.XMLContentType type) throws CICSWSDLException {
        ICM icm = null;
        String msgName = null;
        switch (type) {
            case SOAP_REQUEST: {
                msgName = this.wsdl.getInputMessageName(this.operationName);
                break;
            }
            case SOAP_RESPONSE: {
                msgName = this.wsdl.getOutputMessageName(this.operationName);
                break;
            }
            default: {
                throw new RuntimeException("INTERNAL ERROR: bad ICM type - " + (Object)((Object)type));
            }
        }
        boolean icmNeeded = true;
        if (type.equals((Object)ICM.XMLContentType.SOAP_RESPONSE) && !this.wsdl.responseMessageRequired(this.operationName, this.commareaInterface)) {
            icmNeeded = false;
        }
        if (icmNeeded) {
            List<Object> partsToInclude = this.wsdl.getMethodSignatureParts(this.operationName, type, true);
            try {
                icm = this.processMessage(msgName, type, this.operationName, this.wsdlFilename, partsToInclude, this.language, this.wsdl);
            }
            catch (IOException e) {
                CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{this.wsdlFilename, e.getLocalizedMessage()}));
                newEx.initCause(e);
                throw newEx;
            }
            catch (ICMException exc) {
                CICSWSDLException newEx = this.builder.getMessages().length < 1 ? new CICSWSDLException(exc.getLocalizedMessage()) : new CICSWSDLException(this.builder.getMessages());
                newEx.initCause(exc);
                throw newEx;
            }
            catch (ICMRuntimeException exc) {
                CICSWSDLException newEx = this.builder.getMessages().length < 1 ? new CICSWSDLException(exc.getLocalizedMessage()) : new CICSWSDLException(this.builder.getMessages());
                newEx.initCause(exc);
                throw newEx;
            }
        }
        return icm;
    }

    private ICM processMessage(String messageName, ICM.XMLContentType messageType, String operationName, String wsdlFile, List<Object> parts, int lang, WSDLFile wsdl) throws ICMException, IOException, CICSWSDLException {
        if (parts == null) {
            return null;
        }
        if (this.builder == null) {
            this.builder = Factory.createICMBuilderFromWSDL(wsdlFile, lang, Logging.getPrintStream());
            List<Object> allTypesSections = wsdl.getURIsForTypeSections(wsdlFile, null);
            this.builder.addURIs(allTypesSections);
        }
        String messageNameSpaceForRPC = wsdl.getRPCNameSpaceForOperation(operationName, messageType);
        ICMCreationParameters parms = this.builder.getICMCreationParameters();
        parms.populateParametersObject(messageName, this.soapStyle, new QName(messageNameSpaceForRPC, operationName), messageType, this.mappingLevel, this.soap11, this.charVaryingLimit, this.defaultCharVarying, this.defaultCharMaxLen, this.charMultiplier, this.useHexFloat, this.inlineMaxOccursLimit, true, this.language, this.interceptor, false, (Boolean)this.p.get("WSADDR-EPR-ANY"), this.useAbstimeDates, this.dataTruncationSupported, !this.commareaInterface, this.p, this.defaultFractionDigits, this.platform);
        ICM currentICM = this.builder.createICM(parms);
        for (int i = 0; i < parts.size(); ++i) {
            String key;
            Object thisPart = parts.get(i);
            String thisPartName = wsdl.getMessagePartName(thisPart);
            QName name = wsdl.getMessagePartElement(thisPart);
            if (name != null) {
                currentICM.addElementDeclaration(messageNameSpaceForRPC, thisPartName, name, true);
                key = name.getNamespaceURI() + name.getLocalPart();
                if (!elementsFromWSDL.containsKey(key)) {
                    elementsFromWSDL.put(key, name);
                }
            } else {
                name = wsdl.getMessagePartType(thisPart);
                if (name != null) {
                    currentICM.addTypeDefinition(messageNameSpaceForRPC, thisPartName, name);
                    key = name.getNamespaceURI() + name.getLocalPart();
                    if (!typesFromWSDL.containsKey(key)) {
                        typesFromWSDL.put(key, name);
                    }
                }
            }
            if (name != null) continue;
            throw new CICSWSDLException("INTERNAL_ERROR: " + thisPart.toString() + " - could not be resolved.");
        }
        currentICM.completedICM();
        currentICM.toByteArray();
        return currentICM;
    }

    protected void resetBuilder() {
        this.builder = null;
    }

    public List<WSBindAbstractTypeEntry> getAbstractTypes() throws CICSWSDLException {
        List<WSBindAbstractTypeEntry> types;
        try {
            this.builder = Factory.createICMBuilderFromWSDL(this.wsdlFilename, this.language, Logging.getPrintStream());
            List<Object> allTypesSections = this.wsdl.getURIsForTypeSections(this.wsdlFilename, null);
            this.builder.addURIs(allTypesSections);
            ICMCreationParameters parms = this.initialiseBuilderForICM(this.builder);
            List<QName> elementsFromSchema = this.builder.getGlobalElements();
            List<QName> typesFromSchema = this.builder.getGlobalTypes();
            Iterator<Map.Entry<String, QName>> i = elementsFromWSDL.entrySet().iterator();
            ArrayList<QName> elementsFromWSDLList = new ArrayList<QName>();
            while (i.hasNext()) {
                elementsFromWSDLList.add(i.next().getValue());
            }
            this.processGlobalElements(elementsFromWSDLList, elementsFromSchema, this.builder, parms);
            i = typesFromWSDL.entrySet().iterator();
            ArrayList<QName> typesFromWSDLList = new ArrayList<QName>();
            while (i.hasNext()) {
                typesFromWSDLList.add(i.next().getValue());
            }
            this.processGlobalTypes(typesFromWSDLList, typesFromSchema, this.builder, parms);
            types = this.processAbstractSubTypes(this.builder, parms);
        }
        catch (IOException e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{this.wsdlFilename, e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        catch (ICMException exc) {
            CICSWSDLException newEx = this.builder.getMessages().length < 1 ? new CICSWSDLException(exc.getLocalizedMessage()) : new CICSWSDLException(this.builder.getMessages());
            newEx.initCause(exc);
            throw newEx;
        }
        return types;
    }

    private ICMCreationParameters initialiseBuilderForICM(ICMBuilder builder) throws IOException, ICMException {
        ICMCreationParameters parms = builder.getICMCreationParameters();
        parms.populateParametersObject("TMP", ICM.BindingStyle.DOCUMENT_STYLE, new QName("", ""), ICM.XMLContentType.XML_ELEMENT, this.mappingLevel, true, this.charVaryingLimit, this.defaultCharVarying, this.defaultCharMaxLen, this.charMultiplier, this.useHexFloat, this.inlineMaxOccursLimit, false, this.language, null, false, (Boolean)this.p.get("WSADDR-EPR-ANY"), this.useAbstimeDates, this.dataTruncationSupported, !this.commareaInterface, this.p, this.defaultFractionDigits, this.platform);
        builder.createICM(parms);
        return parms;
    }

    private int processGlobalElements(List<QName> elementsFromUser, List<QName> elementsFromSchema, ICMBuilder builder, ICMCreationParameters parms) throws ICMException, IOException, CICSWSDLException {
        return this.processGlobalItems(elementsFromUser, elementsFromSchema, builder, parms, true);
    }

    private int processGlobalTypes(List<QName> typesFromUser, List<QName> typesFromSchema, ICMBuilder builder, ICMCreationParameters parms) throws ICMException, IOException, CICSWSDLException {
        return this.processGlobalItems(typesFromUser, typesFromSchema, builder, parms, false);
    }

    private int processGlobalItems(List<QName> itemsFromUser, List<QName> itemsFromSchema, ICMBuilder builder, ICMCreationParameters parms, boolean elements) throws ICMException, IOException, CICSWSDLException {
        boolean enableAllItems = false;
        int numProcessed = 0;
        for (int genNumber = 0; genNumber < itemsFromSchema.size(); ++genNumber) {
            QName qname = itemsFromSchema.get(genNumber);
            if (elements) {
                Logging.getPrintStream().println("Found ICM Element: " + qname);
            } else {
                Logging.getPrintStream().println("Found ICM Type: " + qname);
            }
            if (!enableAllItems && !itemsFromUser.contains(qname)) continue;
            this.createGlobalICM(qname, builder, parms, elements, false);
            itemsFromUser.remove(qname);
            ++numProcessed;
        }
        return numProcessed;
    }

    private ICM createGlobalICM(QName qname, ICMBuilder builder, ICMCreationParameters parms, boolean elements, boolean nillableType) throws ICMException, IOException, CICSWSDLException {
        if (elements) {
            Logging.getPrintStream().println("Processing ICM Element: " + qname);
        } else {
            Logging.getPrintStream().println("Processing ICM Type: " + qname);
        }
        parms.setName(qname.getLocalPart());
        ICM icm = builder.createICM(parms);
        if (elements) {
            icm.addElementDeclaration(null, null, qname, true);
        } else {
            icm.addGlobalTypeDefinition(qname, nillableType);
        }
        if (elements) {
            this.globalElements.add(qname);
        } else {
            this.globalTypes.add(qname);
        }
        icm.completedICM();
        try {
            if (this.p.getProperty("PGMINT").equals("COMMAREA") && icm.getCommAreaLength() > 32767L) {
                throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9589E"));
            }
        }
        catch (ICMException e) {
            CICSWSDLException newEx = icm.getMessages().length < 1 ? new CICSWSDLException(e.getLocalizedMessage()) : new CICSWSDLException(icm.getMessages());
            newEx.initCause(e);
            throw newEx;
        }
        return icm;
    }

    private List<WSBindAbstractTypeEntry> processAbstractSubTypes(ICMBuilder builder, ICMCreationParameters parms) throws ICMException, IOException, CICSWSDLException {
        ArrayList<WSBindAbstractTypeEntry> abstractTypes = new ArrayList<WSBindAbstractTypeEntry>();
        Set<QName> typesToProcess = this.findTypesToEnable(builder);
        do {
            for (QName typeName : typesToProcess) {
                boolean nillable = builder.getNillableAbstractSubTypes().contains(typeName);
                ICM icm = this.createGlobalICM(typeName, builder, parms, false, nillable);
                WSBindAbstractTypeEntry entry = new WSBindAbstractTypeEntry(typeName, icm);
                abstractTypes.add(entry);
            }
        } while (!(typesToProcess = this.findTypesToEnable(builder)).isEmpty());
        Collections.sort(abstractTypes);
        return abstractTypes;
    }

    private Set<QName> findTypesToEnable(ICMBuilder builder) {
        TreeSet<QName> typesToProcess = new TreeSet<QName>(new QNameComparator());
        TreeSet<QName> newNillables = new TreeSet<QName>(new QNameComparator());
        newNillables.addAll(builder.getNillableAbstractSubTypes());
        newNillables.removeAll(this.enabledAsNillable);
        for (QName newNillableName : newNillables) {
            int indexInGlobalList = this.globalTypes.indexOf(newNillableName);
            if (indexInGlobalList <= -1) continue;
            this.globalTypes.remove(indexInGlobalList);
        }
        typesToProcess.addAll(builder.getAbstractSubTypes());
        typesToProcess.removeAll(this.globalTypes);
        this.enabledAsNillable.addAll(newNillables);
        return typesToProcess;
    }
}

