/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ws2ls;

import com.ibm.cics.schema.utils.MappingLevelHelper;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.ws2ls.JsonFile;
import com.ibm.cics.wsdl.ws2ls.ws2ls;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.eclipse.emf.common.util.URI;

public class js2ls
extends ws2ls {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2013, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final boolean KEEP_WSDL = false;
    private static final String THIRD_INDENT = "  ";
    private static final String INDENT = "      ";
    private static final String NAME_ATTRIBUTE = "name=\"";
    private static final String TAG_REQUEST_SCHEMA = "[RequestSchema]";
    private static final String TAG_RESPONSE_SCHEMA = "[ResponseSchema]";
    public static final String INPUT_DATA = "InputData";
    public static final String OUTPUT_DATA = "OutputData";
    private static String[] wsdlTemplate = new String[]{"<?xml version=\"1.0\" ?>", "<wsdl:definitions name=\"WSDLTemplate\" ", "\t\ttargetNamespace=\"http://www.example.org/WSDLTemplate/\"", "\t\txmlns:tns=\"http://www.example.org/WSDLTemplate/\" ", "\t\txmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" ", "\t\txmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" ", "\t\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"", "\t\txmlns:request=\"http://www.example.org/WSDLTemplate/RequestMessageData\"", "\t\txmlns:response=\"http://www.example.org/WSDLTemplate/ResponseMessageData\">", "  <wsdl:types>", "    <xsd:schema targetNamespace=\"http://www.example.org/WSDLTemplate/RequestMessageData\">", "      <xsd:element name=\"DFHWrapper\">", "        [RequestSchema]", "      </xsd:element>      ", "    </xsd:schema>", "    <xsd:schema targetNamespace=\"http://www.example.org/WSDLTemplate/ResponseMessageData\">", "      <xsd:element name=\"DFHWrapper\">", "        [ResponseSchema]", "      </xsd:element>", "    </xsd:schema>", "  </wsdl:types>", "  <wsdl:message name=\"WSDLTemplateOperationRequest\">", "    <wsdl:part element=\"request:DFHWrapper\" name=\"parameters\"/>", "  </wsdl:message>", "  <wsdl:message name=\"WSDLTemplateOperationResponse\">", "    <wsdl:part element=\"response:DFHWrapper\" name=\"parameters\"/>", "  </wsdl:message>", "  <wsdl:portType name=\"WSDLTemplatePortType\">", "    <wsdl:operation name=\"InputData\">", "      <wsdl:input message=\"tns:WSDLTemplateOperationRequest\"/>", "      <wsdl:output message=\"tns:WSDLTemplateOperationResponse\"/>", "    </wsdl:operation>", "  </wsdl:portType>  ", "  <wsdl:binding name=\"WSDLTemplateBindingJSON\" type=\"tns:WSDLTemplatePortType\">", "    <soap:binding style=\"document\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>", "    <wsdl:operation name=\"InputData\">", "      <soap:operation soapAction=\"http://www.example.org/WSDLTemplate/WSDLTemplateOperation\"/>", "      <wsdl:input>", "        <soap:body use=\"literal\"/>", "      </wsdl:input>", "      <wsdl:output>", "        <soap:body use=\"literal\"/>", "      </wsdl:output>", "    </wsdl:operation>", "  </wsdl:binding>", "</wsdl:definitions>"};
    private static final String MAKE_OPTIONAL = " minOccurs=\"0\" maxOccurs=\"1\"";
    private static final String MAKE_UNBOUNDED = " minOccurs=\"0\" maxOccurs=\"unbounded\"";
    private static final BigInteger MAX_SIGNED_BYTE = new BigInteger(Byte.toString((byte)127));
    private static final BigInteger MAX_SIGNED_SHORT = new BigInteger(Short.toString((short)Short.MAX_VALUE));
    private static final BigInteger MAX_SIGNED_INTEGER = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    private static final BigInteger MAX_SIGNED_LONG = new BigInteger(Long.toString(Long.MAX_VALUE));
    private static final BigInteger MIN_SIGNED_BYTE = new BigInteger(Byte.toString((byte)-128));
    private static final BigInteger MIN_SIGNED_SHORT = new BigInteger(Short.toString((short)Short.MIN_VALUE));
    private static final BigInteger MIN_SIGNED_INTEGER = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    private static final BigInteger MIN_SIGNED_LONG = new BigInteger(Long.toString(Long.MIN_VALUE));
    private static final BigInteger MAX_UNSIGNED_BYTE = js2ls.unsignedValue(MAX_SIGNED_BYTE);
    private static final BigInteger MAX_UNSIGNED_SHORT = js2ls.unsignedValue(MAX_SIGNED_SHORT);
    private static final BigInteger MAX_UNSIGNED_INTEGER = js2ls.unsignedValue(MAX_SIGNED_INTEGER);
    private static final BigInteger MAX_UNSIGNED_LONG = js2ls.unsignedValue(MAX_SIGNED_LONG);
    private static final String JSON_FORMAT_DOUBLE = "double";
    private static final String JSON_FORMAT_FLOAT = "float";
    private static final String JSON_FORMAT_DECIMAL = "decimal";
    private static final String JSON_FORMAT_HEX_BINARY = "hexBinary";
    private static final String JSON_FORMAT_BASE64_BINARY = "base64Binary";
    private static final String JSON_FORMAT_DATE_TIME = "date-time";
    private static final String JSON_FORMAT_EMAIL = "email";
    private static final String JSON_FORMAT_HOSTNAME = "hostname";
    private static final String JSON_FORMAT_IPV4 = "ipv4";
    private static final String JSON_FORMAT_IPV6 = "ipv6";
    private static final String JSON_FORMAT_URI = "uri";
    private static final String JSON_FORMAT_URI_REF = "uriref";
    private static final String JSON_FORMAT_DATE = "date";
    private static final String JSON_FORMAT_TIME = "time";
    private static final String JSON_FORMAT_DURATION = "duration";
    private static final String JSON_FORMAT_IDN_EMAIL = "idn-email";
    private static final String JSON_FORMAT_IDN_HOSTNAME = "idn-hostname";
    private static final String JSON_FORMAT_IRI = "iri";
    private static final String JSON_FORMAT_IRI_REFERENCE = "iri-reference";
    private static final String JSON_FORMAT_UUID = "uuid";
    private static final String JSON_FORMAT_URI_TEMPLATE = "uri-template";
    private static final String JSON_FORMAT_URI_REFERENCE = "uri-reference";
    private static final String JSON_FORMAT_JSON_POINTER = "json-pointer";
    private static final String JSON_FORMAT_RELATIVE_JSON_POINTER = "relative-json-pointer";
    private static final String JSON_FORMAT_REGEX = "regex";
    private static final String JSON_KEYWORD_$SCHEMA = "$schema";
    private static final String JSON_KEYWORD_$REF = "$ref";
    private static final String JSON_KEYWORD_ID = "id";
    private static final String JSON_KEYWORD_TITLE = "title";
    private static final String JSON_KEYWORD_DESCRIPTION = "description";
    private static final String JSON_KEYWORD_REQUIRED = "required";
    private static final String JSON_KEYWORD_PROPERTIES = "properties";
    private static final String JSON_KEYWORD_ADDITIONAL_PROPERTIES = "additionalProperties";
    private static final String JSON_KEYWORD_PATTERN_PROPERTIES = "patternProperties";
    private static final String JSON_KEYWORD_MAX_PROPERTIES = "maxProperties";
    private static final String JSON_KEYWORD_MIN_PROPERTIES = "minProperties";
    private static final String JSON_KEYWORD_DEPENDENCIES = "dependencies";
    private static final String JSON_KEYWORD_ITEMS = "items";
    private static final String JSON_KEYWORD_MAX_ITEMS = "maxItems";
    private static final String JSON_KEYWORD_MIN_ITEMS = "minItems";
    private static final String JSON_KEYWORD_UNIQUE_ITEMS = "uniqueItems";
    private static final String JSON_KEYWORD_DEFINITIONS = "definitions";
    private static final String JSON_KEYWORD_ALL_OF = "allOf";
    private static final String JSON_KEYWORD_ANY_OF = "anyOf";
    private static final String JSON_KEYWORD_ONE_OF = "oneOf";
    private static final String JSON_KEYWORD_NONE_OF = "noneOf";
    private static final String JSON_KEYWORD_NOT = "not";
    private static final String JSON_KEYWORD_ENUM = "enum";
    private static final String JSON_KEYWORD_ADDITIONAL_ITEMS = "additionalItems";
    private static final String JSON_KEYWORD_FORMAT = "format";
    private static final String JSON_KEYWORD_TYPE = "type";
    private static final String JSON_KEYWORD_MAX_LENGTH = "maxLength";
    private static final String JSON_KEYWORD_MIN_LENGTH = "minLength";
    private static final String JSON_KEYWORD_PATTERN = "pattern";
    public static final String JSON_KEYWORD_EXCLUSIVE_MINIMUM = "exclusiveMinimum";
    private static final String JSON_KEYWORD_MIN_EXCLUSIVE = "minExclusive";
    public static final String JSON_KEYWORD_EXCLUSIVE_MAXIMUM = "exclusiveMaximum";
    private static final String JSON_KEYWORD_MAX_EXCLUSIVE = "maxExclusive";
    private static final String JSON_KEYWORD_MINIMUM = "minimum";
    private static final String JSON_KEYWORD_MAXIMUM = "maximum";
    private static final String JSON_KEYWORD_MULTIPLE_OF = "multipleOf";
    private static final String JSON_KEYWORD_$ID = "$id";
    private static final String JSON_KEYWORD_$VOCABULARLY = "$vocabulary";
    private static final String JSON_KEYWORD_$ANCHOR = "$anchor";
    private static final String JSON_KEYWORD_$DYNAMIC_ANCHOR = "$dynamicAnchor";
    private static final String JSON_KEYWORD_$DYNAMIC_REF = "$dynamicRef";
    private static final String JSON_KEYWORD_$DEFS = "$defs";
    private static final String JSON_KEYWORD_$COMMENT = "$comment";
    private static final String JSON_KEYWORD_EXAMPLES = "examples";
    private static final String JSON_KEYWORD_DEPRECATED = "deprecated";
    private static final String JSON_KEYWORD_READ_ONLY = "readOnly";
    private static final String JSON_KEYWORD_WRITE_ONLY = "writeOnly";
    private static final String JSON_KEYWORD_CONTENT_ENCODING = "contentEncoding";
    private static final String JSON_KEYWORD_CONTENT_MEDIA_TYPE = "contentMediaType";
    private static final String JSON_KEYWORD_CONTENT_SCHEMA = "contentSchema";
    private static final String JSON_KEYWORD_DEFAULT = "default";
    private static final String JSON_KEYWORD_CONST = "const";
    private static final String JSON_KEYWORD_PREFIX_ITEMS = "prefixItems";
    private static final String JSON_KEYWORD_UNEVALUATED_ITEMS = "unevaluatedItems";
    private static final String JSON_KEYWORD_CONTAINS = "contains";
    private static final String JSON_KEYWORD_MIN_CONTAINS = "minContains";
    private static final String JSON_KEYWORD_MAX_CONTAINS = "maxContains";
    private static final String JSON_KEYWORD_IF = "if";
    private static final String JSON_KEYWORD_THEN = "then";
    private static final String JSON_KEYWORD_ELSE = "else";
    private static final String JSON_KEYWORD_DEPENDENT_SCHEMAS = "dependentSchemas";
    private static final String JSON_KEYWORD_PROPERTY_NAMES = "propertyNames";
    private static final String JSON_KEYWORD_UNEVALUATED_PROPERTIES = "unevaluatedProperties";
    private static final String JSON_KEYWORD_DEPENDENT_REQUIRED = "dependentRequired";
    private static final String JSON_CONTENT_ENCODING_BINARY = "binary";
    private static final String JSON_CONTENT_ENCODING_BASE64 = "base64";
    private static final String JSON_DEFINITIONS_PREFIX_ROOT = "#/";
    private static final String JSON_DEFINITIONS_PREFIX_ABSOLUTE = "/";
    private static final String JSON_DEFINITIONS_PREFIX_ANCHOR = "#";
    private static final String JSON_DEFINITIONS_NULL = "null";
    private static final String[] JSON_ANNOTATION_KEYWORDS = new String[]{"id", "$id", "title", "description"};
    private static final String[] JSON_LOGICAL_COMBINATORS = new String[]{"allOf", "anyOf", "oneOf"};
    private static final String[] JSON_IF_THEN_ELSE_COMBINATORS = new String[]{"if", "then", "else"};
    private static final String[] JSON_UNSUPPORTED_KEYWORDS = new String[]{"noneOf"};
    private static final String[] JSON_UNSUPPORTED_KEYWORDS_2020_12 = new String[0];
    private static final String[] JSON_OBJECT_UNSUPPORTED_KEYWORDS = new String[]{"maxProperties", "minProperties", "dependencies", "patternProperties"};
    private static final String[] JSON_OBJECT_UNSUPPORTED_KEYWORDS_2020_12 = new String[]{"dependentSchemas", "dependentRequired", "patternProperties"};
    private static final String[] JSON_INTEGER_UNSUPPORTED_KEYWORDS = new String[0];
    private static final String[] JSON_FORMAT_UNSUPPORTED_KEYWORDS = new String[]{"maxLength", "minLength"};
    private JSONObject rootSchema = null;
    private JsonFile schemaRequest;
    private JsonFile schemaResponse;
    private JsonFile currentSchema;
    private String schemaLocation;
    private List<String> visitedPointers = new ArrayList<String>();
    private Map<String, String> deprecatedReference = new HashMap<String, String>();
    private static final String NULL_PREFIX = "DFHNULL_";
    private int surrogateCount = 0;
    private static Pattern NCNAME_VALIDATOR = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_.-]*");

    public static void main(String[] args) {
        js2ls me = new js2ls();
        me.run(args);
    }

    @Override
    public void run(String[] args) {
        if (this.apiResp != null) {
            this.apiResp.setREQMEMs(this.REQMEMs);
            this.apiResp.setRESPMEMs(this.RESPMEMs);
        }
        this.commonExecute(args, 5, this.timestamp);
    }

    protected void setMappingLevel(int mappingLevel) {
        this.mappingLevel = mappingLevel;
    }

    @Override
    public void doAssistantSpecificProcessing() throws CICSWSDLException {
        String operationName;
        this.schemaLocation = this.p.getProperty("JSON-SCHEMA-RESTFUL");
        if (this.schemaLocation == null) {
            this.schemaLocation = this.p.getProperty("JSON-SCHEMA-REQUEST");
        }
        if ("".equals(operationName = this.p.getProperty("PGMNAME")) || " ".equals(operationName)) {
            operationName = "JSON";
        }
        if (this.schemaLocation == null) {
            this.schemaLocation = this.p.getProperty("JSON-SCHEMA-RESPONSE");
        }
        File tempWSDL = this.createTemporaryWsdlFile(this.schemaLocation, this.p.getProperty("JSON-SCHEMA-RESPONSE"), operationName);
        this.p.setProperty("WSDL", tempWSDL.getAbsolutePath());
        super.doAssistantSpecificProcessing();
        tempWSDL.delete();
    }

    @Override
    public boolean setUp(int rc, String[] args, int direction, Date timestamp) throws CICSWSDLException {
        super.setUp(rc, args, direction, timestamp);
        return this.handleJSONAPIDelegation(args);
    }

    public File createTemporaryWsdlFile(String requestJSONSchemaLocation, String responseJSONSchemaLocation, String operationName) throws CICSWSDLException {
        this.schemaRequest = (JsonFile)this.readJSONSchema(requestJSONSchemaLocation);
        this.schemaResponse = null;
        if (responseJSONSchemaLocation != null) {
            this.schemaResponse = (JsonFile)this.readJSONSchema(responseJSONSchemaLocation);
        }
        ArrayList<String> generatedWsdl = new ArrayList<String>();
        for (String line : wsdlTemplate) {
            if (line.contains(TAG_REQUEST_SCHEMA)) {
                this.currentSchema = this.schemaRequest;
                this.appendRootSchemaToWsdl(generatedWsdl, this.schemaRequest);
                continue;
            }
            if (line.contains(TAG_RESPONSE_SCHEMA)) {
                this.currentSchema = this.schemaResponse;
                this.appendRootSchemaToWsdl(generatedWsdl, this.schemaResponse);
                continue;
            }
            if (line.contains(INPUT_DATA)) {
                generatedWsdl.add(line.replace(INPUT_DATA, operationName));
                continue;
            }
            if (line.contains(OUTPUT_DATA)) {
                generatedWsdl.add(line.replace(OUTPUT_DATA, operationName + "Response"));
                continue;
            }
            if (line.contains(INPUT_DATA)) {
                generatedWsdl.add(line.replace(INPUT_DATA, operationName));
                continue;
            }
            if (line.contains(OUTPUT_DATA)) {
                generatedWsdl.add(line.replace(OUTPUT_DATA, operationName + "Response"));
                continue;
            }
            generatedWsdl.add(line);
        }
        File tempWsdl = new File(requestJSONSchemaLocation + ".wsdl");
        try {
            tempWsdl = File.createTempFile("DFHLS2JS", ".wsdl");
            tempWsdl.deleteOnExit();
            PrintWriter pw = new PrintWriter(tempWsdl, "UTF-8");
            for (String line : generatedWsdl) {
                pw.println(line);
            }
            pw.close();
        }
        catch (IOException e) {
            CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9556E", new Object[]{tempWsdl.getAbsolutePath(), e.getLocalizedMessage()}));
            ex.initCause(e);
            throw ex;
        }
        return tempWsdl;
    }

    private JSONObject readJSONSchema(String schemaLocation) throws CICSWSDLException {
        JsonFile schema = null;
        File schemaFilename = new File(schemaLocation);
        try {
            schema = new JsonFile(schemaFilename);
        }
        catch (JSONException e) {
            CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9690E", new Object[]{schemaFilename.getAbsolutePath(), e.getLocalizedMessage()}));
            ex.initCause(e);
            throw ex;
        }
        return schema;
    }

    private void appendRootSchemaToWsdl(ArrayList<String> generatedWsdl, JSONObject schema) throws CICSWSDLException {
        List<JsonType> mainTypes;
        if (schema == null) {
            return;
        }
        this.rootSchema = schema;
        String rootName = "root";
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && schema.optBoolean(JSON_KEYWORD_DEPRECATED)) {
            Logging.writeMessage(4, "DFHPI9747W", new Object[]{this.currentSchema.getFileName()});
        }
        if ((mainTypes = this.getSchemasType(schema, rootName)).size() > 1) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9757E", new Object[0]));
        }
        this.checkForUnsuportedKeywords(schema, mainTypes);
        JsonType mainType = mainTypes.get(0);
        if (mainType.equals((Object)JsonType.TNullableArray) || mainType.equals((Object)JsonType.TNullableObject)) {
            String lastWSDL = generatedWsdl.get(generatedWsdl.size() - 1);
            lastWSDL = lastWSDL.replaceFirst(">", " nillable=\"true\">");
            generatedWsdl.remove(generatedWsdl.size() - 1);
            generatedWsdl.add(lastWSDL);
        }
        String prefix = "        ";
        int minItems = -1;
        int maxItems = -1;
        String arrayName = null;
        if (mainType.equals((Object)JsonType.Tarray) || mainType.equals((Object)JsonType.TNullableArray)) {
            arrayName = "DFHWrapper";
            if (this.resolveStringFromObject(schema, JSON_KEYWORD_MAX_ITEMS, rootName, true, MismatchingTypesStrategy.MismatchTOLERATE).length() > 0) {
                maxItems = this.resolveIntFromObject(schema, JSON_KEYWORD_MAX_ITEMS, rootName, NumberAccumulationStrategy.PreferBIG);
            }
            if (this.resolveStringFromObject(schema, JSON_KEYWORD_MIN_ITEMS, rootName, true, MismatchingTypesStrategy.MismatchTOLERATE).length() > 0) {
                minItems = this.resolveIntFromObject(schema, JSON_KEYWORD_MIN_ITEMS, rootName, NumberAccumulationStrategy.PreferSMALL);
            }
            if (maxItems == -1 && this.defaultArrayMaxItems > 1) {
                maxItems = this.defaultArrayMaxItems;
            }
        }
        int elementLineNumber = -1;
        this.appendAnnotations(generatedWsdl, schema, prefix, true, minItems, maxItems, null, arrayName);
        if (mainType.equals((Object)JsonType.Tarray) || mainType.equals((Object)JsonType.TNullableArray)) {
            JSONObject arrayItems;
            if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                arrayItems = this.resolveAndCombineJSONObjectFromObject(schema, arrayName, JSON_KEYWORD_ITEMS);
                if (arrayItems == null) {
                    arrayItems = this.resolveAndCombineJSONObjectFromObject(schema, arrayName, JSON_KEYWORD_PREFIX_ITEMS);
                }
            } else {
                arrayItems = this.resolveAndCombineJSONObjectFromObject(schema, arrayName, JSON_KEYWORD_ITEMS);
            }
            if (arrayItems == null) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9698E", new Object[]{rootName}));
            }
            List<JsonType> schemaTypes = this.getSchemasType(arrayItems, rootName);
            if (schemaTypes.size() > 1) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9757E", new Object[0]));
            }
            JsonType schemaType = schemaTypes.get(0);
            this.appendSchemaToWsdl(generatedWsdl, arrayItems, prefix, false, elementLineNumber, rootName, null, false, new ArrayList<String>(), schemaTypes, schemaType, false);
        } else if (mainType.equals((Object)JsonType.Tobject) || mainType.equals((Object)JsonType.TNullableObject)) {
            this.appendObjectToWsdl(generatedWsdl, schema, prefix, rootName, new ArrayList<String>(), true);
        } else {
            throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9691E"));
        }
    }

    private List<JsonType> getSchemasType(JSONObject schema, String objectName) throws CICSWSDLException {
        ArrayList<JsonType> returnTypes = new ArrayList<JsonType>();
        JsonType mainType = null;
        String typeValue = null;
        boolean nullType = false;
        JSONArray typeArray = this.resolveJSONArrayFromObject(schema, JSON_KEYWORD_TYPE);
        if (typeArray != null) {
            if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                Object t2;
                int i;
                if (typeArray.length() == 0) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9755E", new Object[]{objectName}));
                }
                for (i = 0; i < typeArray.length(); ++i) {
                    try {
                        t2 = typeArray.get(i);
                        if (!(t2 instanceof String) || !((String)t2).equals(JSON_DEFINITIONS_NULL)) continue;
                        nullType = true;
                        continue;
                    }
                    catch (JSONException t2) {
                        // empty catch block
                    }
                }
                typeArray.remove((Object)JSON_DEFINITIONS_NULL);
                if (typeArray.length() == 0) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9694E", new Object[]{JSON_DEFINITIONS_NULL}));
                }
                for (i = 0; i < typeArray.length(); ++i) {
                    try {
                        t2 = typeArray.get(i);
                        if (!(t2 instanceof String)) continue;
                        String type = (String)t2;
                        mainType = JsonType.valueOf("T" + type);
                        if (nullType) {
                            mainType = mainType.getNullableVariant();
                        }
                        if (returnTypes.contains((Object)mainType)) {
                            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9756E", new Object[]{objectName}));
                        }
                        returnTypes.add(mainType);
                        continue;
                    }
                    catch (JSONException t3) {
                        // empty catch block
                    }
                }
                if (!(typeArray.length() <= 1 || schema.optString(JSON_KEYWORD_CONST).equals("") && schema.optString(JSON_KEYWORD_DEFAULT).equals(""))) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9759E", new Object[]{objectName}));
                }
                return returnTypes;
            }
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9692E", new Object[]{objectName}));
        }
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
            typeValue = this.resolveStringFromObject(schema, JSON_KEYWORD_TYPE, objectName, true, MismatchingTypesStrategy.MismatchREJECTExceptNull);
            if (typeValue.startsWith(NULL_PREFIX)) {
                nullType = true;
                typeValue = typeValue.substring(NULL_PREFIX.length());
            }
        } else {
            typeValue = this.resolveStringFromObject(schema, JSON_KEYWORD_TYPE, objectName, true, MismatchingTypesStrategy.MismatchREJECT);
        }
        if (typeValue.length() == 0) {
            mainType = this.inferTypeFromEnum(schema, objectName);
            if (mainType == null) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9692E", new Object[]{objectName}));
            }
            returnTypes.add(mainType);
            return returnTypes;
        }
        try {
            mainType = JsonType.valueOf("T" + typeValue);
            if (nullType) {
                mainType = mainType.getNullableVariant();
            }
        }
        catch (Exception e) {
            CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9693E", new Object[]{typeValue}));
            ex.initCause(e);
            throw ex;
        }
        returnTypes.add(mainType);
        return returnTypes;
    }

    private JsonType inferTypeFromEnum(JSONObject object, String objectName) throws CICSWSDLException {
        JSONArray enumArray = this.getEnumValues(object, objectName, null);
        if (enumArray == null || enumArray.length() == 0) {
            return null;
        }
        try {
            JsonType typeOfEnumOption;
            int i;
            JsonType type = this.inferJsonTypeForEnumFromClass(enumArray.get(0).getClass(), objectName);
            if (JsonType.Tnull.equals((Object)type) && enumArray.length() > 1) {
                type = this.inferJsonTypeForEnumFromClass(enumArray.get(1).getClass(), objectName);
            }
            for (i = 0; i < enumArray.length(); ++i) {
                typeOfEnumOption = this.inferJsonTypeForEnumFromClass(enumArray.get(i).getClass(), objectName);
                if (!typeOfEnumOption.equals((Object)JsonType.Tnull)) continue;
                type = type.getNullableVariant();
            }
            if (type.equals((Object)JsonType.Tinteger) || type.equals((Object)JsonType.TNullableInteger)) {
                for (i = 0; i < enumArray.length(); ++i) {
                    typeOfEnumOption = this.inferJsonTypeForEnumFromClass(enumArray.get(i).getClass(), objectName);
                    if (!typeOfEnumOption.equals((Object)JsonType.Tnumber)) continue;
                    if (type.isNullSupported()) {
                        type = JsonType.TNullableNumber;
                        break;
                    }
                    type = JsonType.Tnumber;
                    break;
                }
            }
            return type;
        }
        catch (JSONException e) {
            CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9693E", new Object[]{objectName, e.getMessage()}));
            ex.initCause(e);
            throw ex;
        }
    }

    private JSONArray getEnumValues(JSONObject object, String objectName, JsonType ownerType) throws CICSWSDLException {
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && object.opt(JSON_KEYWORD_CONST) != null) {
            JSONArray constEnum = new JSONArray();
            switch (ownerType) {
                case Tstring: 
                case TNullableString: {
                    String constString = object.optString(JSON_KEYWORD_CONST);
                    constEnum.put((Object)constString);
                    break;
                }
                case Tnumber: 
                case TNullableNumber: {
                    double constDecimal = object.optDouble(JSON_KEYWORD_CONST);
                    try {
                        constEnum.put(constDecimal);
                        break;
                    }
                    catch (JSONException e) {
                        CICSWSDLException cwe = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9750E", new Object[]{"" + constDecimal, objectName}));
                        cwe.initCause(e);
                        throw cwe;
                    }
                }
                case Tinteger: 
                case TNullableInteger: {
                    int constInteger = object.optInt(JSON_KEYWORD_CONST);
                    constEnum.put(constInteger);
                    break;
                }
                case Tboolean: 
                case TNullableBoolean: {
                    boolean constBoolean = object.optBoolean(JSON_KEYWORD_CONST);
                    constEnum.put(constBoolean);
                    break;
                }
            }
            return constEnum;
        }
        JSONArray enumArray = this.resolveJSONArrayFromObject(object, JSON_KEYWORD_ENUM);
        if (enumArray == null) {
            return null;
        }
        int length = enumArray.length();
        if (length < 1) {
            CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9731E", new Object[]{objectName}));
            throw ex;
        }
        JsonType type = ownerType;
        try {
            if (type == null && JsonType.Tnull.equals((Object)(type = this.inferJsonTypeForEnumFromClass(enumArray.get(0).getClass(), objectName))) && length > 1) {
                type = this.inferJsonTypeForEnumFromClass(enumArray.get(1).getClass(), objectName);
            }
            for (int i = 0; i < length; ++i) {
                JsonType typeOfEnumOption = this.inferJsonTypeForEnumFromClass(enumArray.get(i).getClass(), objectName);
                if (typeOfEnumOption.equals((Object)JsonType.Tinteger) && (type.equals((Object)JsonType.Tnumber) || type.equals((Object)JsonType.TNullableNumber))) continue;
                if (ownerType == null && typeOfEnumOption.equals((Object)JsonType.Tnumber) && (type.equals((Object)JsonType.Tinteger) || type.equals((Object)JsonType.TNullableInteger))) {
                    type = JsonType.Tnumber;
                    continue;
                }
                if (typeOfEnumOption.equals((Object)JsonType.Tnull)) {
                    type = type.getNullableVariant();
                    continue;
                }
                if (typeOfEnumOption.getNullableVariant().equals((Object)type.getNullableVariant())) {
                    type = type.getNullableVariant();
                    continue;
                }
                if (typeOfEnumOption.equals((Object)type)) continue;
                CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9733E", new Object[]{objectName}));
                throw ex;
            }
        }
        catch (JSONException e) {
            CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9693E", new Object[]{objectName}));
            ex.initCause(e);
            throw ex;
        }
        return enumArray;
    }

    private JsonType inferJsonTypeForEnumFromClass(Class<?> clazz, String objectName) throws CICSWSDLException {
        if (String.class.equals(clazz)) {
            return JsonType.Tstring;
        }
        if (Integer.class.equals(clazz)) {
            return JsonType.Tinteger;
        }
        if (BigDecimal.class.equals(clazz)) {
            return JsonType.Tnumber;
        }
        if (Boolean.class.equals(clazz)) {
            return JsonType.Tboolean;
        }
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && JSONObject.NULL.getClass().equals(clazz)) {
            return JsonType.Tnull;
        }
        CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9732E", new Object[]{clazz.getSimpleName().toString(), objectName}));
        throw ex;
    }

    private JSONArray resolveJSONArrayFromObject(JSONObject object, String name) throws CICSWSDLException {
        JSONArray array = object.optJSONArray(name);
        this.visitedPointers.clear();
        while (!"".equals(object.optString(JSON_KEYWORD_$REF))) {
            JSONArray temp = (object = this.resolveJSONPointerToObject(object, this.visitedPointers)).optJSONArray(name);
            if (temp == null) continue;
            array = temp;
        }
        return array;
    }

    private JSONObject resolveJSONObjectFromObject(JSONObject object, String name) throws CICSWSDLException {
        JSONObject objectOut = object.optJSONObject(name);
        this.visitedPointers.clear();
        while (!"".equals(object.optString(JSON_KEYWORD_$REF))) {
            JSONObject temp = (object = this.resolveJSONPointerToObject(object, this.visitedPointers)).optJSONObject(name);
            if (temp == null) continue;
            objectOut = temp;
        }
        return objectOut;
    }

    private JSONObject resolveAndCombineJSONObjectFromObject(JSONObject object, String objectName, String keyName) throws CICSWSDLException {
        JSONObject objectOut = this.resolveJSONObjectFromObject(object, keyName);
        objectOut = this.resolveObjectUsingLogicalComposition(object, objectOut, objectName, keyName);
        objectOut = this.resolveObjectUsingThenElseComposition(object, objectOut, objectName, keyName);
        return objectOut;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONObject resolveAndCombineJSONObjectFromObject(JSONObject object, JSONObject mergeTarget, String objectName, String keyName) throws CICSWSDLException {
        JSONObject objectOut = this.resolveJSONObjectFromObject(object, keyName);
        if (mergeTarget == null) {
            try {
                if (objectOut == null) return this.resolveObjectUsingLogicalComposition(object, mergeTarget, objectName, JSON_KEYWORD_PROPERTIES);
                mergeTarget = new JSONObject(objectOut.toString());
                return this.resolveObjectUsingLogicalComposition(object, mergeTarget, objectName, JSON_KEYWORD_PROPERTIES);
            }
            catch (JSONException e) {
                CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9500E", new Object[]{objectOut, e.getMessage()}));
                ex.initCause(e);
                throw ex;
            }
        } else {
            if (objectOut == null) return this.resolveObjectUsingLogicalComposition(object, mergeTarget, objectName, JSON_KEYWORD_PROPERTIES);
            Iterator keys = objectOut.keys();
            while (keys.hasNext()) {
                Object propertyValue2;
                String key = (String)keys.next();
                JSONObject value = objectOut.optJSONObject(key);
                if (value != null) {
                    try {
                        JSONObject tmp = mergeTarget.optJSONObject(key);
                        if (tmp != null) {
                            Logging.writeMessage(4, "DFHPI9737W", new Object[]{key, objectName});
                            value = this.resolveAndCombineJSONObjectFromObject(objectOut, tmp, objectName, key);
                        }
                        mergeTarget.put(key, (Object)value);
                        continue;
                    }
                    catch (JSONException e) {
                        CICSWSDLException ex = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9736E", new Object[]{objectName, e.getMessage()}));
                        ex.initCause(e);
                        throw ex;
                    }
                }
                Object propertyValue1 = objectOut.opt(key);
                if (propertyValue1.equals(propertyValue2 = mergeTarget.opt(key))) continue;
                Logging.writeMessage(4, "DFHPI9738W", new Object[]{key, keyName, propertyValue1, propertyValue2});
            }
            return this.resolveObjectUsingLogicalComposition(object, mergeTarget, objectName, JSON_KEYWORD_PROPERTIES);
        }
    }

    private JSONObject resolveObjectUsingLogicalComposition(JSONObject currentObject, JSONObject mergeTarget, String objectName, String keyName) throws CICSWSDLException {
        if (currentObject == null || currentObject.length() == 0) {
            return mergeTarget;
        }
        for (int combinator = 0; combinator < JSON_LOGICAL_COMBINATORS.length; ++combinator) {
            JSONArray currentArray = this.resolveJSONArrayFromObject(currentObject, JSON_LOGICAL_COMBINATORS[combinator]);
            if (currentArray == null) continue;
            for (int i = 0; i < currentArray.length(); ++i) {
                JSONObject obj = currentArray.optJSONObject(i);
                if (obj == null) continue;
                mergeTarget = this.resolveAndCombineJSONObjectFromObject(obj, mergeTarget, objectName, keyName);
            }
        }
        return mergeTarget;
    }

    private JSONObject resolveObjectUsingThenElseComposition(JSONObject currentObject, JSONObject mergeTarget, String objectName, String keyName) throws CICSWSDLException {
        if (currentObject == null || currentObject.length() == 0) {
            return mergeTarget;
        }
        boolean ifFound = false;
        for (int combinator = 0; combinator < JSON_IF_THEN_ELSE_COMBINATORS.length; ++combinator) {
            JSONObject ifThenElseObject = this.resolveJSONObjectFromObject(currentObject, JSON_IF_THEN_ELSE_COMBINATORS[combinator]);
            if (ifThenElseObject == null) continue;
            if (combinator == 0) {
                ifFound = true;
                continue;
            }
            if (!ifFound) {
                return mergeTarget;
            }
            mergeTarget = this.resolveAndCombineJSONObjectFromObject(ifThenElseObject, mergeTarget, objectName, keyName);
        }
        return mergeTarget;
    }

    private String resolveStringFromObject(JSONObject object, String name, String parentName, boolean searchInLogicalExtensions, MismatchingTypesStrategy mismatchStrategy) throws CICSWSDLException {
        String string = object.optString(name);
        boolean nullFound = false;
        this.visitedPointers.clear();
        while (!"".equals(object.optString(JSON_KEYWORD_$REF))) {
            String temp = (object = this.resolveJSONPointerToObject(object, this.visitedPointers)).optString(name);
            if ("".equals(temp)) continue;
            string = temp;
        }
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && JSON_DEFINITIONS_NULL.equals(string) && MismatchingTypesStrategy.MismatchREJECTExceptNull.equals((Object)mismatchStrategy)) {
            nullFound = true;
            string = "";
        }
        if (searchInLogicalExtensions) {
            String string2 = this.findStringUsingLogicalComposition(object, name, parentName, mismatchStrategy);
            if (string2.startsWith(NULL_PREFIX)) {
                string2 = string2.substring(NULL_PREFIX.length());
                nullFound = true;
            }
            if (!("".equals(string) || "".equals(string2) || string.equals(string2))) {
                Logging.writeMessage(4, "DFHPI9738W", new Object[]{name, parentName});
            }
            if ("".equals(string)) {
                string = string2;
            }
        }
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && nullFound && MismatchingTypesStrategy.MismatchREJECTExceptNull.equals((Object)mismatchStrategy)) {
            string = NULL_PREFIX + string;
        }
        return string;
    }

    private String findStringUsingLogicalComposition(JSONObject currentObject, String keyName, String objectName, MismatchingTypesStrategy mismatchStrategy) throws CICSWSDLException {
        if (currentObject == null || currentObject.length() == 0) {
            return "";
        }
        String returnValue = "";
        boolean nullFound = false;
        for (int combinator = 0; combinator < JSON_LOGICAL_COMBINATORS.length; ++combinator) {
            JSONArray currentArray = this.resolveJSONArrayFromObject(currentObject, JSON_LOGICAL_COMBINATORS[combinator]);
            if (currentArray == null) continue;
            for (int i = 0; i < currentArray.length(); ++i) {
                JSONObject obj = currentArray.optJSONObject(i);
                if (obj == null) continue;
                String resolvedValue = this.resolveStringFromObject(obj, keyName, objectName, true, mismatchStrategy);
                if (NULL_PREFIX.equals(resolvedValue) && MismatchingTypesStrategy.MismatchREJECTExceptNull.equals((Object)mismatchStrategy)) {
                    resolvedValue = "";
                    nullFound = true;
                }
                if ("".equals(resolvedValue)) continue;
                if ("".equals(returnValue) || returnValue.equals(resolvedValue)) {
                    returnValue = resolvedValue;
                    continue;
                }
                if (!resolvedValue.equals(returnValue) && MismatchingTypesStrategy.MismatchREJECT.equals((Object)mismatchStrategy)) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9735E", new Object[]{keyName, objectName, returnValue, resolvedValue}));
                }
                Logging.writeMessage(4, "DFHPI9738W", new Object[]{keyName, objectName});
            }
        }
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && nullFound && MismatchingTypesStrategy.MismatchREJECTExceptNull.equals((Object)mismatchStrategy)) {
            returnValue = NULL_PREFIX + returnValue;
        }
        return returnValue;
    }

    private boolean resolveBooleanFromObject(JSONObject object, String name) throws CICSWSDLException {
        boolean bool = object.optBoolean(name);
        this.visitedPointers.clear();
        while (!"".equals(object.optString(JSON_KEYWORD_$REF))) {
            object = this.resolveJSONPointerToObject(object, this.visitedPointers);
            try {
                bool = object.getBoolean(name);
            }
            catch (JSONException jSONException) {}
        }
        return bool;
    }

    private int resolveIntFromObject(JSONObject object, String name, String parentName, NumberAccumulationStrategy accumulationStrategy) throws CICSWSDLException {
        int i = object.optInt(name);
        boolean valueFound = false;
        String s = object.optString(name);
        if (!"".equals(s)) {
            valueFound = true;
        }
        this.visitedPointers.clear();
        while (!"".equals(object.optString(JSON_KEYWORD_$REF))) {
            object = this.resolveJSONPointerToObject(object, this.visitedPointers);
            try {
                i = object.getInt(name);
                valueFound = true;
            }
            catch (JSONException jSONException) {}
        }
        i = this.findIntUsingLogicalComposition(object, name, parentName, i, accumulationStrategy, valueFound);
        return i;
    }

    private BigDecimal resolveDecimalFromObject(JSONObject object, String name, String parentName, NumberAccumulationStrategy accumulationStrategy) throws CICSWSDLException {
        BigDecimal result = null;
        boolean valueFound = false;
        String s = object.optString(name);
        if (!"".equals(s)) {
            valueFound = true;
            try {
                result = new BigDecimal(s);
            }
            catch (NumberFormatException e) {
                CICSWSDLException cwe = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9750E", new Object[]{s, name}));
                cwe.initCause(e);
                throw cwe;
            }
        }
        this.visitedPointers.clear();
        while (!"".equals(object.optString(JSON_KEYWORD_$REF))) {
            object = this.resolveJSONPointerToObject(object, this.visitedPointers);
            try {
                s = object.getString(name);
                valueFound = true;
                result = new BigDecimal(s);
            }
            catch (NumberFormatException e) {
                CICSWSDLException cwe = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9750E", new Object[]{s, name}));
                cwe.initCause(e);
                throw cwe;
            }
            catch (JSONException jSONException) {
            }
        }
        result = this.findDecimalUsingLogicalComposition(object, name, parentName, result, accumulationStrategy, valueFound);
        return result;
    }

    private BigInteger resolveIntegerFromObject(JSONObject object, String name, String parentName, NumberAccumulationStrategy accumulationStrategy) throws CICSWSDLException {
        BigInteger result = null;
        boolean valueFound = false;
        String s = object.optString(name);
        if (!"".equals(s)) {
            valueFound = true;
            try {
                result = new BigInteger(s);
            }
            catch (NumberFormatException e) {
                CICSWSDLException cwe = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9750E", new Object[]{s, name}));
                cwe.initCause(e);
                throw cwe;
            }
        }
        this.visitedPointers.clear();
        while (!"".equals(object.optString(JSON_KEYWORD_$REF))) {
            object = this.resolveJSONPointerToObject(object, this.visitedPointers);
            try {
                s = object.getString(name);
                valueFound = true;
                result = new BigInteger(s);
            }
            catch (NumberFormatException e) {
                CICSWSDLException cwe = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9750E", new Object[]{s, name}));
                cwe.initCause(e);
                throw cwe;
            }
            catch (JSONException jSONException) {
            }
        }
        result = this.findIntegerUsingLogicalComposition(object, name, parentName, result, accumulationStrategy, valueFound);
        return result;
    }

    private int findIntUsingLogicalComposition(JSONObject currentObject, String keyName, String objectName, int candidate, NumberAccumulationStrategy accumulationStrategy, boolean valueFound) throws CICSWSDLException {
        if (currentObject == null || currentObject.length() == 0) {
            return candidate;
        }
        int returnValue = candidate;
        for (int combinator = 0; combinator < JSON_LOGICAL_COMBINATORS.length; ++combinator) {
            JSONArray currentArray = this.resolveJSONArrayFromObject(currentObject, JSON_LOGICAL_COMBINATORS[combinator]);
            if (currentArray == null) continue;
            for (int i = 0; i < currentArray.length(); ++i) {
                JSONObject obj = currentArray.optJSONObject(i);
                if (obj == null) continue;
                int resolvedValue = this.resolveIntFromObject(obj, keyName, objectName, accumulationStrategy);
                boolean foundNewValue = false;
                String s = this.resolveStringFromObject(obj, keyName, objectName, true, MismatchingTypesStrategy.MismatchTOLERATE);
                if (!"".equals(s)) {
                    foundNewValue = true;
                }
                if (accumulationStrategy.equals((Object)NumberAccumulationStrategy.PreferBIG) && foundNewValue && resolvedValue > returnValue) {
                    returnValue = resolvedValue;
                    continue;
                }
                if (accumulationStrategy.equals((Object)NumberAccumulationStrategy.PreferSMALL) && foundNewValue && resolvedValue < returnValue) {
                    returnValue = resolvedValue;
                    continue;
                }
                if (!(foundNewValue & !valueFound)) continue;
                returnValue = resolvedValue;
                valueFound = true;
            }
        }
        return returnValue;
    }

    private BigDecimal findDecimalUsingLogicalComposition(JSONObject currentObject, String keyName, String objectName, BigDecimal candidate, NumberAccumulationStrategy accumulationStrategy, boolean valueFound) throws CICSWSDLException {
        if (currentObject == null || currentObject.length() == 0) {
            return candidate;
        }
        BigDecimal returnValue = candidate;
        for (int combinator = 0; combinator < JSON_LOGICAL_COMBINATORS.length; ++combinator) {
            JSONArray currentArray = this.resolveJSONArrayFromObject(currentObject, JSON_LOGICAL_COMBINATORS[combinator]);
            if (currentArray == null) continue;
            for (int i = 0; i < currentArray.length(); ++i) {
                JSONObject obj = currentArray.optJSONObject(i);
                if (obj == null) continue;
                BigDecimal resolvedValue = this.resolveDecimalFromObject(obj, keyName, objectName, accumulationStrategy);
                boolean foundNewValue = false;
                String s = this.resolveStringFromObject(obj, keyName, objectName, true, MismatchingTypesStrategy.MismatchTOLERATE);
                if (!"".equals(s)) {
                    foundNewValue = true;
                }
                if (returnValue == null && foundNewValue) {
                    returnValue = resolvedValue;
                    continue;
                }
                if (accumulationStrategy.equals((Object)NumberAccumulationStrategy.PreferBIG) && foundNewValue && resolvedValue.compareTo(returnValue) > 0) {
                    returnValue = resolvedValue;
                    continue;
                }
                if (accumulationStrategy.equals((Object)NumberAccumulationStrategy.PreferSMALL) && foundNewValue && resolvedValue.compareTo(returnValue) < 0) {
                    returnValue = resolvedValue;
                    continue;
                }
                if (!(foundNewValue & !valueFound)) continue;
                returnValue = resolvedValue;
                valueFound = true;
            }
        }
        return returnValue;
    }

    private BigInteger findIntegerUsingLogicalComposition(JSONObject currentObject, String keyName, String objectName, BigInteger candidate, NumberAccumulationStrategy accumulationStrategy, boolean valueFound) throws CICSWSDLException {
        if (currentObject == null || currentObject.length() == 0) {
            return candidate;
        }
        BigInteger returnValue = candidate;
        for (int combinator = 0; combinator < JSON_LOGICAL_COMBINATORS.length; ++combinator) {
            JSONArray currentArray = this.resolveJSONArrayFromObject(currentObject, JSON_LOGICAL_COMBINATORS[combinator]);
            if (currentArray == null) continue;
            for (int i = 0; i < currentArray.length(); ++i) {
                JSONObject obj = currentArray.optJSONObject(i);
                if (obj == null) continue;
                BigInteger resolvedValue = this.resolveIntegerFromObject(obj, keyName, objectName, accumulationStrategy);
                boolean foundNewValue = false;
                String s = this.resolveStringFromObject(obj, keyName, objectName, true, MismatchingTypesStrategy.MismatchTOLERATE);
                if (!"".equals(s)) {
                    foundNewValue = true;
                }
                if (returnValue == null && foundNewValue) {
                    returnValue = resolvedValue;
                    continue;
                }
                if (accumulationStrategy.equals((Object)NumberAccumulationStrategy.PreferBIG) && foundNewValue && resolvedValue.compareTo(returnValue) > 0) {
                    returnValue = resolvedValue;
                    continue;
                }
                if (accumulationStrategy.equals((Object)NumberAccumulationStrategy.PreferSMALL) && foundNewValue && resolvedValue.compareTo(returnValue) < 0) {
                    returnValue = resolvedValue;
                    continue;
                }
                if (!(foundNewValue & !valueFound)) continue;
                returnValue = resolvedValue;
                valueFound = true;
            }
        }
        return returnValue;
    }

    private String unescapeJSONPointerToken(String pointer) {
        pointer = pointer.replaceAll("~1", JSON_DEFINITIONS_PREFIX_ABSOLUTE);
        pointer = pointer.replaceAll("~0", "~");
        return pointer;
    }

    private Object resolvePointer(Object currentContext, String token, String fullReference) throws CICSWSDLException {
        JSONObject result = null;
        token = this.unescapeJSONPointerToken(token);
        if (currentContext instanceof JSONObject) {
            JSONObject localContext = (JSONObject)currentContext;
            try {
                result = localContext.getJSONObject(token);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (result == null) {
                try {
                    result = localContext.getJSONArray(token);
                }
                catch (JSONException jSONException) {}
            }
        } else if (currentContext instanceof JSONArray) {
            JSONArray localContext = (JSONArray)currentContext;
            int tokenInt = -1;
            try {
                tokenInt = Integer.parseInt(token);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (tokenInt > -1) {
                try {
                    result = localContext.getJSONObject(tokenInt);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                if (result == null) {
                    try {
                        result = localContext.getJSONArray(tokenInt);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
            }
        }
        if (result == null) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9729E", new Object[]{fullReference}));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONObject resolveJSONPointerToObject(JSONObject object, List<String> alreadyVisited) throws CICSWSDLException {
        JSONObject returnObject = object;
        String reference = object.optString(JSON_KEYWORD_$REF);
        if (reference != null) {
            String localReference = reference;
            localReference = URI.decode((String)localReference);
            boolean resolvesLocally = true;
            if (localReference.startsWith(JSON_DEFINITIONS_PREFIX_ROOT)) {
                localReference = localReference.substring(JSON_DEFINITIONS_PREFIX_ROOT.length());
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && localReference.startsWith(JSON_DEFINITIONS_PREFIX_ANCHOR)) {
                localReference = localReference.substring(JSON_DEFINITIONS_PREFIX_ANCHOR.length());
            } else {
                resolvesLocally = false;
            }
            if (localReference.endsWith(JSON_DEFINITIONS_PREFIX_ABSOLUTE)) {
                localReference = localReference.substring(0, localReference.length() - 1);
            }
            if (alreadyVisited.contains(localReference)) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9024E", new Object[]{reference}));
            }
            alreadyVisited.add(localReference);
            if (resolvesLocally) {
                if (reference.startsWith(JSON_DEFINITIONS_PREFIX_ROOT)) {
                    JSONObject localContext = this.rootSchema;
                    returnObject = this.getJSONObjectViaRef(object, reference, localReference, localContext);
                } else {
                    if (!MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) || !reference.startsWith(JSON_DEFINITIONS_PREFIX_ANCHOR)) throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9729E", new Object[]{reference}));
                    returnObject = (JSONObject)this.currentSchema.getAnchorNodes().get(localReference);
                    if (returnObject == null) {
                        throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9745E", new Object[]{reference}));
                    }
                }
            } else {
                if (!MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9728E", new Object[]{reference}));
                }
                String path = "";
                String ref = "";
                if (reference.startsWith(JSON_DEFINITIONS_PREFIX_ABSOLUTE)) {
                    if (reference.indexOf(JSON_DEFINITIONS_PREFIX_ROOT) > -1) {
                        path = reference.substring(0, reference.indexOf(JSON_DEFINITIONS_PREFIX_ROOT));
                        ref = reference.substring(reference.indexOf(JSON_DEFINITIONS_PREFIX_ROOT) + JSON_DEFINITIONS_PREFIX_ROOT.length());
                    } else if (reference.indexOf(JSON_DEFINITIONS_PREFIX_ANCHOR) > -1) {
                        path = reference.substring(0, reference.indexOf(JSON_DEFINITIONS_PREFIX_ANCHOR));
                        ref = reference.substring(reference.indexOf(JSON_DEFINITIONS_PREFIX_ANCHOR) + JSON_DEFINITIONS_PREFIX_ANCHOR.length());
                    } else {
                        path = reference;
                    }
                } else {
                    if (reference.indexOf(JSON_DEFINITIONS_PREFIX_ROOT) > -1) {
                        path = reference.substring(0, reference.indexOf(JSON_DEFINITIONS_PREFIX_ROOT));
                        ref = reference.substring(reference.indexOf(JSON_DEFINITIONS_PREFIX_ROOT) + JSON_DEFINITIONS_PREFIX_ROOT.length());
                    } else if (reference.indexOf(JSON_DEFINITIONS_PREFIX_ANCHOR) > -1) {
                        path = reference.substring(0, reference.indexOf(JSON_DEFINITIONS_PREFIX_ANCHOR));
                        ref = reference.substring(reference.indexOf(JSON_DEFINITIONS_PREFIX_ANCHOR) + JSON_DEFINITIONS_PREFIX_ANCHOR.length());
                    } else {
                        path = reference;
                    }
                    path = this.schemaLocation.substring(0, this.schemaLocation.lastIndexOf(47)) + path;
                }
                JSONObject subschema = this.readJSONSchema(path);
                if (ref.contentEquals("")) {
                    returnObject = subschema;
                } else if (reference.indexOf(JSON_DEFINITIONS_PREFIX_ROOT) > -1) {
                    returnObject = this.getJSONObjectViaRef(object, reference, ref, subschema);
                } else {
                    returnObject = (JSONObject)((JsonFile)subschema).getAnchorNodes().get(ref);
                    if (returnObject == null) {
                        throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9745E", new Object[]{reference}));
                    }
                }
            }
        }
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && returnObject.optBoolean(JSON_KEYWORD_DEPRECATED) && !this.deprecatedReference.containsKey(reference)) {
            Logging.writeMessage(4, "DFHPI9748W", new Object[]{reference});
            this.deprecatedReference.put(reference, "");
        }
        if (!MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) return returnObject;
        return this.resolveSiblings(object, returnObject);
    }

    private JSONObject resolveSiblings(JSONObject parent, JSONObject $refObject) throws CICSWSDLException {
        try {
            $refObject = new JSONObject($refObject.toString());
        }
        catch (JSONException e) {
            CICSWSDLException exc = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9500E", new Object[0]));
            exc.initCause(e);
            throw exc;
        }
        Iterator i = parent.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (key.equals(JSON_KEYWORD_$REF)) continue;
            try {
                $refObject.put(key, parent.get(key));
            }
            catch (JSONException jSONException) {}
        }
        return $refObject;
    }

    private JSONObject getJSONObjectViaRef(JSONObject object, String reference, String localReference, Object localContext) throws CICSWSDLException {
        int nextSlash = localReference.indexOf(JSON_DEFINITIONS_PREFIX_ABSOLUTE);
        while (nextSlash > -1) {
            String token = localReference.substring(0, nextSlash);
            localContext = this.resolvePointer(localContext, token, reference);
            localReference = localReference.substring(nextSlash + 1);
            nextSlash = localReference.indexOf(JSON_DEFINITIONS_PREFIX_ABSOLUTE);
        }
        try {
            object = (JSONObject)this.resolvePointer(localContext, localReference, reference);
        }
        catch (Exception e) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9729E", new Object[]{reference}));
        }
        return object;
    }

    private void appendObjectToWsdl(ArrayList<String> generatedWsdl, JSONObject schema, String prefix, String objectName, ArrayList<String> schemaReferencesFollowed, boolean rootObject) throws CICSWSDLException {
        boolean additionalProperties;
        JSONObject additionalPropertiesObj;
        String invalidArray;
        generatedWsdl.add(prefix + "<xsd:complexType>");
        generatedWsdl.add(prefix + THIRD_INDENT + "<xsd:sequence>");
        JSONArray keywordArray = this.resolveJSONArrayFromObject(schema, JSON_KEYWORD_REQUIRED);
        if (keywordArray == null && (invalidArray = this.resolveStringFromObject(schema, JSON_KEYWORD_REQUIRED, objectName, false, MismatchingTypesStrategy.MismatchTOLERATE)) != null && invalidArray.length() > 0) {
            throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9697E"));
        }
        Set<String> required = js2ls.jsonArrayToSet(keywordArray);
        if (keywordArray != null && required.size() == 0) {
            throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9697E"));
        }
        JSONObject mainProperties = this.resolveAndCombineJSONObjectFromObject(schema, objectName, JSON_KEYWORD_PROPERTIES);
        if (mainProperties == null) {
            mainProperties = new JSONObject();
        }
        if ((additionalPropertiesObj = this.resolveJSONObjectFromObject(schema, JSON_KEYWORD_ADDITIONAL_PROPERTIES)) == null) {
            additionalProperties = this.resolveBooleanFromObject(schema, JSON_KEYWORD_ADDITIONAL_PROPERTIES);
            if ("".equals(this.resolveStringFromObject(schema, JSON_KEYWORD_ADDITIONAL_PROPERTIES, objectName, true, MismatchingTypesStrategy.MismatchTOLERATE))) {
                String value = this.p.getProperty("ADDITIONAL-PROPERTIES-DEFAULT");
                additionalProperties = "TRUE".equalsIgnoreCase(value);
            }
        } else {
            additionalProperties = true;
        }
        if (additionalProperties && !MappingLevelHelper.supportsMappingLevel_4_2(this.mappingLevel)) {
            throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9700E"));
        }
        Iterator it = mainProperties.keys();
        while (it.hasNext()) {
            String elementName = (String)it.next();
            boolean optional = false;
            if (required.contains(elementName)) {
                required.remove(elementName);
            } else {
                optional = true;
            }
            JSONObject propertyObject = this.resolveJSONObjectFromObject(mainProperties, elementName);
            if (propertyObject == null) {
                throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9696E"));
            }
            if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && propertyObject.optBoolean(JSON_KEYWORD_READ_ONLY) && this.currentSchema == this.schemaRequest || MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && propertyObject.optBoolean(JSON_KEYWORD_WRITE_ONLY) && this.currentSchema == this.schemaResponse) continue;
            String constValue = "";
            String defaultValue = "";
            if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                constValue = propertyObject.optString(JSON_KEYWORD_CONST);
                defaultValue = propertyObject.optString(JSON_KEYWORD_DEFAULT);
                if (!constValue.equals("") && !defaultValue.equals("")) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9752E", new Object[]{objectName}));
                }
            }
            List<JsonType> schemaTypes = this.getSchemasType(propertyObject, elementName);
            String originalElementName = elementName;
            for (JsonType schemaType : schemaTypes) {
                elementName = originalElementName;
                if (schemaTypes.size() > 1) {
                    optional = true;
                    String typeName = schemaType.name().substring(1).replaceFirst("Nullable", "");
                    typeName = Character.toLowerCase(typeName.charAt(0)) + typeName.substring(1);
                    elementName = elementName + "-" + typeName;
                }
                String nillable = "false";
                if (schemaType.isNullSupported()) {
                    nillable = "true";
                }
                String xsdElement = prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:element name=\"" + elementName + "\" nillable=\"" + nillable + "\" ";
                String overrideName = null;
                if (!NCNAME_VALIDATOR.matcher(elementName).matches()) {
                    xsdElement = prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:element name=\"" + "DFH_SURROGATE_NAME_" + this.surrogateCount + "\" nillable=\"" + nillable + "\" ";
                    ++this.surrogateCount;
                    overrideName = elementName;
                }
                if (!constValue.equals("")) {
                    xsdElement = xsdElement + " default=\"" + constValue + "\"";
                }
                if (!defaultValue.equals("")) {
                    xsdElement = xsdElement + " default=\"" + defaultValue + "\"";
                }
                xsdElement = xsdElement + " >";
                generatedWsdl.add(xsdElement);
                this.appendSchemaToWsdl(generatedWsdl, propertyObject, prefix, true, generatedWsdl.size() - 1, elementName, overrideName, optional, schemaReferencesFollowed, schemaTypes, schemaType, rootObject);
                generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "</xsd:element>");
            }
        }
        if (additionalProperties) {
            String bound = "unbounded";
            String max = this.p.getProperty("ADDITIONAL-PROPERTIES-MAX");
            if (!"UNBOUNDED".equalsIgnoreCase(max) && !"".equalsIgnoreCase(max)) {
                bound = max;
            }
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:any minOccurs=\"0\" maxOccurs=\"" + bound + "\" namespace=\"##other\">");
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + "<xsd:annotation>");
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + "<xsd:documentation>Additional JSON Properties</xsd:documentation>");
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + "<xsd:appinfo source=\"" + "http://www.ibm.com/software/htp/cics/annotations" + "\">");
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + "com.ibm.cics.wsdl.properties.jsonAny" + "=true");
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + "</xsd:appinfo>");
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + "</xsd:annotation>");
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "</xsd:any>");
        } else if (required.size() > 0) {
            String missing = null;
            for (String element : required) {
                if (missing == null) {
                    missing = "[\"" + element + "\"";
                    continue;
                }
                missing = missing + ", \"" + element + "\"";
            }
            missing = missing + "]";
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9705E", new Object[]{missing}));
        }
        generatedWsdl.add(prefix + THIRD_INDENT + "</xsd:sequence>");
        generatedWsdl.add(prefix + "</xsd:complexType>");
    }

    private void checkForUnsuportedKeywords(JSONObject schema, List<JsonType> types) throws CICSWSDLException {
        JSONArray keywordArray = schema.names();
        Set<String> keywords = js2ls.jsonArrayToSet(keywordArray);
        keywords.remove(JSON_KEYWORD_TYPE);
        for (JsonType type : types) {
            switch (type) {
                case Tobject: 
                case TNullableObject: {
                    keywords.remove(JSON_KEYWORD_REQUIRED);
                    keywords.remove(JSON_KEYWORD_PROPERTIES);
                    keywords.remove(JSON_KEYWORD_ADDITIONAL_PROPERTIES);
                    if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                        keywords.remove(JSON_KEYWORD_PROPERTY_NAMES);
                        keywords.remove(JSON_KEYWORD_UNEVALUATED_PROPERTIES);
                        keywords.remove(JSON_KEYWORD_MIN_PROPERTIES);
                        keywords.remove(JSON_KEYWORD_MAX_PROPERTIES);
                        keywords.remove(JSON_KEYWORD_IF);
                        keywords.remove(JSON_KEYWORD_THEN);
                        keywords.remove(JSON_KEYWORD_ELSE);
                    }
                    if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                        js2ls.catchUnsupportedKeywords(keywords, JSON_OBJECT_UNSUPPORTED_KEYWORDS_2020_12);
                        break;
                    }
                    js2ls.catchUnsupportedKeywords(keywords, JSON_OBJECT_UNSUPPORTED_KEYWORDS);
                    break;
                }
                case Tarray: 
                case TNullableArray: {
                    if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                        JSONObject prefixItems;
                        if (keywords.contains(JSON_KEYWORD_PREFIX_ITEMS) && keywords.contains(JSON_KEYWORD_ITEMS) && (prefixItems = this.resolveJSONObjectFromObject(schema, JSON_KEYWORD_PREFIX_ITEMS)) != null) {
                            Logging.writeMessage(4, "DFHPI9753W", new Object[0]);
                        }
                        keywords.remove(JSON_KEYWORD_PREFIX_ITEMS);
                        keywords.remove(JSON_KEYWORD_ITEMS);
                        keywords.remove(JSON_KEYWORD_UNEVALUATED_ITEMS);
                        keywords.remove(JSON_KEYWORD_CONTAINS);
                        keywords.remove(JSON_KEYWORD_MIN_CONTAINS);
                        keywords.remove(JSON_KEYWORD_MAX_CONTAINS);
                    }
                    keywords.remove(JSON_KEYWORD_ITEMS);
                    keywords.remove(JSON_KEYWORD_MAX_ITEMS);
                    keywords.remove(JSON_KEYWORD_MIN_ITEMS);
                    if (!MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && keywords.contains(JSON_KEYWORD_ADDITIONAL_ITEMS)) {
                        JSONObject additionalItems = this.resolveJSONObjectFromObject(schema, JSON_KEYWORD_ADDITIONAL_ITEMS);
                        boolean allowAdditionalItems = this.resolveBooleanFromObject(schema, JSON_KEYWORD_ADDITIONAL_ITEMS);
                        if (allowAdditionalItems || additionalItems != null) {
                            throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9702E"));
                        }
                        keywords.remove(JSON_KEYWORD_ADDITIONAL_ITEMS);
                    }
                    keywords.remove(JSON_KEYWORD_UNIQUE_ITEMS);
                    break;
                }
                case Tstring: 
                case TNullableString: {
                    keywords.remove(JSON_KEYWORD_MAX_LENGTH);
                    keywords.remove(JSON_KEYWORD_MIN_LENGTH);
                    keywords.remove(JSON_KEYWORD_PATTERN);
                    keywords.remove(JSON_KEYWORD_FORMAT);
                    keywords.remove(JSON_KEYWORD_DEFAULT);
                    if (!MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) break;
                    keywords.remove(JSON_KEYWORD_CONTENT_ENCODING);
                    keywords.remove(JSON_KEYWORD_CONTENT_MEDIA_TYPE);
                    keywords.remove(JSON_KEYWORD_CONTENT_SCHEMA);
                    keywords.remove(JSON_KEYWORD_CONST);
                    keywords.remove(JSON_KEYWORD_DEFAULT);
                    break;
                }
                case Tnumber: 
                case TNullableNumber: {
                    keywords.remove(JSON_KEYWORD_FORMAT);
                    keywords.remove(JSON_KEYWORD_MULTIPLE_OF);
                }
                case Tinteger: 
                case TNullableInteger: {
                    if (!MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                        if ((keywords.contains(JSON_KEYWORD_EXCLUSIVE_MAXIMUM) || keywords.contains(JSON_KEYWORD_MAX_EXCLUSIVE)) && !keywords.contains(JSON_KEYWORD_MAXIMUM)) {
                            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9703E", new Object[]{JSON_KEYWORD_EXCLUSIVE_MAXIMUM, JSON_KEYWORD_MAXIMUM}));
                        }
                        if ((keywords.contains(JSON_KEYWORD_EXCLUSIVE_MINIMUM) || keywords.contains(JSON_KEYWORD_MIN_EXCLUSIVE)) && !keywords.contains(JSON_KEYWORD_MINIMUM)) {
                            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9703E", new Object[]{JSON_KEYWORD_EXCLUSIVE_MINIMUM, JSON_KEYWORD_MINIMUM}));
                        }
                        keywords.remove(JSON_KEYWORD_MAX_EXCLUSIVE);
                        keywords.remove(JSON_KEYWORD_MIN_EXCLUSIVE);
                    }
                    keywords.remove(JSON_KEYWORD_MAXIMUM);
                    keywords.remove(JSON_KEYWORD_MINIMUM);
                    keywords.remove(JSON_KEYWORD_EXCLUSIVE_MAXIMUM);
                    keywords.remove(JSON_KEYWORD_EXCLUSIVE_MINIMUM);
                    keywords.remove(JSON_KEYWORD_FORMAT);
                    if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                        keywords.remove(JSON_KEYWORD_CONST);
                        keywords.remove(JSON_KEYWORD_DEFAULT);
                    }
                    js2ls.catchUnsupportedKeywords(keywords, JSON_INTEGER_UNSUPPORTED_KEYWORDS);
                    break;
                }
                case Tboolean: 
                case TNullableBoolean: {
                    break;
                }
                case Tnull: {
                    break;
                }
            }
            keywords.remove(JSON_KEYWORD_DESCRIPTION);
            keywords.remove(JSON_KEYWORD_ID);
            keywords.remove(JSON_KEYWORD_TITLE);
            keywords.remove(JSON_KEYWORD_$SCHEMA);
            keywords.remove(JSON_KEYWORD_$REF);
            keywords.remove(JSON_KEYWORD_ENUM);
            keywords.remove(JSON_KEYWORD_ALL_OF);
            keywords.remove(JSON_KEYWORD_ANY_OF);
            keywords.remove(JSON_KEYWORD_ONE_OF);
            keywords.remove(JSON_KEYWORD_NOT);
            keywords.remove(JSON_KEYWORD_DEFAULT);
            if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                keywords.remove(JSON_KEYWORD_$ID);
                keywords.remove(JSON_KEYWORD_$VOCABULARLY);
                keywords.remove(JSON_KEYWORD_$ANCHOR);
                keywords.remove(JSON_KEYWORD_$DYNAMIC_ANCHOR);
                keywords.remove(JSON_KEYWORD_$DYNAMIC_REF);
                keywords.remove(JSON_KEYWORD_$DEFS);
                keywords.remove(JSON_KEYWORD_$COMMENT);
                keywords.remove(JSON_KEYWORD_EXAMPLES);
                keywords.remove(JSON_KEYWORD_DEPRECATED);
                keywords.remove(JSON_KEYWORD_READ_ONLY);
                keywords.remove(JSON_KEYWORD_WRITE_ONLY);
                continue;
            }
            keywords.remove(JSON_KEYWORD_DEFINITIONS);
        }
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
            js2ls.catchUnsupportedKeywords(keywords, JSON_UNSUPPORTED_KEYWORDS_2020_12);
        } else {
            js2ls.catchUnsupportedKeywords(keywords, JSON_UNSUPPORTED_KEYWORDS);
        }
        for (String keyword : keywords) {
            if (!keywords.contains(keyword)) continue;
            Logging.writeMessage(4, "DFHPI9704W", new Object[]{keyword});
        }
    }

    private static void catchUnsupportedKeywords(Set<String> keywords, String[] unsupportedKeywords) throws CICSWSDLException {
        for (int i = 0; i < unsupportedKeywords.length; ++i) {
            String keyword = unsupportedKeywords[i];
            if (!keywords.contains(keyword)) continue;
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9701E", new Object[]{keyword}));
        }
    }

    private static Set<String> jsonArrayToSet(JSONArray requiredArray) throws CICSWSDLException {
        HashSet<String> value = new HashSet<String>();
        if (requiredArray != null && requiredArray.length() > 0) {
            for (int index = 0; index < requiredArray.length(); ++index) {
                try {
                    value.add(requiredArray.getString(index));
                    continue;
                }
                catch (JSONException e) {
                    CICSWSDLException ex = new CICSWSDLException(MessageHandler.getMessage("DFHPI9697E"));
                    ex.initCause(e);
                    throw ex;
                }
            }
        }
        return value;
    }

    private void appendSchemaToWsdl(ArrayList<String> generatedWsdl, JSONObject schema, String prefix, boolean canAnnotate, int elementLineNumber, String objectName, String overrideName, boolean forceOptional, ArrayList<String> schemaReferencesFollowed, List<JsonType> schemaTypes, JsonType schemaType, boolean rootObject) throws CICSWSDLException {
        boolean schemaReferenceFollowed = false;
        if (js2ls.jsonArrayToSet(schema.names()).contains(JSON_KEYWORD_$REF)) {
            String schemaReference = schema.optString(JSON_KEYWORD_$REF);
            if (schemaReferencesFollowed.contains(schemaReference)) {
                String referenceList = String.join((CharSequence)", ", schemaReferencesFollowed) + ", " + schemaReference;
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9740E", new Object[]{schemaReference, referenceList}));
            }
            schemaReferencesFollowed.add(schemaReference);
            schemaReferenceFollowed = true;
        }
        String name = objectName;
        if (overrideName != null) {
            name = overrideName;
        }
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && schema.optBoolean(JSON_KEYWORD_DEPRECATED)) {
            Logging.writeMessage(4, "DFHPI9746W", new Object[]{name});
        }
        this.checkForUnsuportedKeywords(schema, schemaTypes);
        JSONArray enumeratedValues = this.getEnumValues(schema, name, schemaType);
        if (forceOptional && !JsonType.Tarray.equals((Object)schemaType) && !JsonType.TNullableArray.equals((Object)schemaType)) {
            String oldLine = generatedWsdl.get(elementLineNumber);
            int placeToAdd = oldLine.length() - 1;
            String elementBounds = MAKE_OPTIONAL;
            if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && this.p.getProperty("ZOS-CONNECT-EE").equals("true") && rootObject && Util.isResponseCodeEntity(name)) {
                elementBounds = MAKE_UNBOUNDED;
            }
            String newLine = oldLine.substring(0, placeToAdd) + elementBounds + " >";
            generatedWsdl.set(elementLineNumber, newLine);
        } else if ((JsonType.Tarray.equals((Object)schemaType) || JsonType.TNullableArray.equals((Object)schemaType)) && elementLineNumber > -1 && generatedWsdl.get(elementLineNumber).contains("</xsd:annotation>")) {
            while (elementLineNumber > -1 && !generatedWsdl.get(elementLineNumber).contains("xsd:element")) {
                --elementLineNumber;
            }
        }
        this.appendAnnotations(generatedWsdl, schema, prefix + INDENT, canAnnotate, -1, -1, overrideName, null);
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && schemaTypes.size() > 1) {
            js2ls.appendMultiTypeAnnotation(generatedWsdl, prefix + INDENT);
        }
        switch (schemaType) {
            case Tstring: 
            case TNullableString: {
                this.appendStringToWsdl(generatedWsdl, schema, prefix + INDENT, this.p.getProperty("CHAR-WHITESPACE"), enumeratedValues, objectName);
                break;
            }
            case Tboolean: 
            case TNullableBoolean: {
                this.appendBooleanToWsdl(generatedWsdl, schema, prefix + INDENT, objectName);
                break;
            }
            case Tinteger: 
            case TNullableInteger: {
                this.appendIntegerToWsdl(generatedWsdl, schema, prefix + INDENT, enumeratedValues, objectName);
                break;
            }
            case Tnumber: 
            case TNullableNumber: {
                this.appendNumberToWsdl(generatedWsdl, schema, prefix + INDENT, enumeratedValues, objectName);
                break;
            }
            case Tarray: 
            case TNullableArray: {
                this.appendArrayToWsdl(generatedWsdl, schema, prefix, elementLineNumber, objectName, forceOptional, schemaReferencesFollowed, schemaType);
                break;
            }
            case Tobject: 
            case TNullableObject: {
                this.appendObjectToWsdl(generatedWsdl, schema, prefix + INDENT, objectName, schemaReferencesFollowed, false);
                break;
            }
            default: {
                String typeValue = schemaType.toString();
                typeValue = typeValue.substring(1);
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9694E", new Object[]{typeValue}));
            }
        }
        if (schemaReferenceFollowed) {
            schemaReferencesFollowed.remove(schemaReferencesFollowed.size() - 1);
        }
    }

    private void appendAnnotations(ArrayList<String> generatedWsdl, JSONObject schema, String prefix, boolean canAnnotate, int minOccurs, int maxOccurs, String overrideName, String parentArrayName) throws CICSWSDLException {
        ArrayList<String> annotations = new ArrayList<String>();
        for (int i = 0; i < JSON_ANNOTATION_KEYWORDS.length; ++i) {
            String keyword = JSON_ANNOTATION_KEYWORDS[i];
            String value = this.resolveStringFromObject(schema, keyword, overrideName, false, MismatchingTypesStrategy.MismatchTOLERATE).trim();
            value = value.replaceAll("&", "&amp;");
            if ((value = value.replaceAll("<", "&lt;")) == null || value.length() <= 0) continue;
            annotations.add("<dt> JSON schema " + keyword + ":</dt><dd>" + value + "</dd>");
        }
        if ((annotations.size() > 0 || minOccurs >= 0 || maxOccurs >= 0 || overrideName != null || parentArrayName != null) && canAnnotate) {
            generatedWsdl.add(prefix + "<xsd:annotation>");
            if (annotations.size() > 0) {
                generatedWsdl.add(prefix + THIRD_INDENT + "<xsd:documentation>");
                generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<dl>");
                for (String annotation : annotations) {
                    generatedWsdl.add(prefix + INDENT + annotation);
                }
                generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "</dl>");
                generatedWsdl.add(prefix + THIRD_INDENT + "</xsd:documentation>");
            }
            if (minOccurs >= 0 || maxOccurs >= 0 || overrideName != null) {
                generatedWsdl.add(prefix + THIRD_INDENT + "<xsd:appinfo source=\"" + "http://www.ibm.com/software/htp/cics/annotations" + "\">");
                if (minOccurs >= 0) {
                    generatedWsdl.add("com.ibm.cics.wsdl.properties.minOccurs=" + minOccurs);
                }
                if (maxOccurs >= 0) {
                    generatedWsdl.add("com.ibm.cics.wsdl.properties.maxOccurs=" + maxOccurs);
                }
                if (overrideName != null) {
                    String escaped = overrideName.replace("&", "&amp;");
                    escaped = escaped.replace("<", "&lt;");
                    escaped = escaped.replace(">", "&gt;");
                    generatedWsdl.add("com.ibm.cics.wsdl.properties.surrogateName=" + escaped);
                }
                if (parentArrayName != null) {
                    generatedWsdl.add("com.ibm.cics.wsdl.properties.outerArrayName=" + parentArrayName);
                }
                generatedWsdl.add(prefix + THIRD_INDENT + "</xsd:appinfo>");
            }
            generatedWsdl.add(prefix + "</xsd:annotation>");
        }
    }

    private static void appendOptionalArrayAnnotation(ArrayList<String> generatedWsdl, String prefix) {
        if (generatedWsdl.get(generatedWsdl.size() - 1).trim().equals("</xsd:annotation>")) {
            generatedWsdl.remove(generatedWsdl.size() - 1);
        } else {
            generatedWsdl.add(prefix + "<xsd:annotation>");
        }
        generatedWsdl.add(prefix + THIRD_INDENT + "<xsd:appinfo source=\"" + "http://www.ibm.com/software/htp/cics/annotations" + "\">");
        generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "com.ibm.cics.wsdl.properties.optionalarray" + "=true");
        generatedWsdl.add(prefix + THIRD_INDENT + "</xsd:appinfo>");
        generatedWsdl.add(prefix + "</xsd:annotation>");
    }

    private static void appendMultiTypeAnnotation(ArrayList<String> generatedWsdl, String prefix) {
        if (generatedWsdl.get(generatedWsdl.size() - 1).trim().equals("</xsd:annotation>")) {
            generatedWsdl.remove(generatedWsdl.size() - 1);
        } else {
            generatedWsdl.add(prefix + "<xsd:annotation>");
        }
        generatedWsdl.add(prefix + THIRD_INDENT + "<xsd:appinfo source=\"" + "http://www.ibm.com/software/htp/cics/annotations" + "\">");
        generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "com.ibm.cics.wsdl.properties.multitype" + "=true");
        generatedWsdl.add(prefix + THIRD_INDENT + "</xsd:appinfo>");
        generatedWsdl.add(prefix + "</xsd:annotation>");
    }

    private void appendStringToWsdl(ArrayList<String> generatedWsdl, JSONObject schema, String prefix, String whitespaceProperty, JSONArray enumeratedValues, String objectName) throws CICSWSDLException {
        String encoding;
        String whitespace = whitespaceProperty;
        String pattern = "";
        String format = this.resolveStringFromObject(schema, JSON_KEYWORD_FORMAT, objectName, true, MismatchingTypesStrategy.MismatchTOLERATE);
        int maxLength = this.resolveIntFromObject(schema, JSON_KEYWORD_MAX_LENGTH, objectName, NumberAccumulationStrategy.PreferBIG);
        String keyValue = this.resolveStringFromObject(schema, JSON_KEYWORD_MAX_LENGTH, objectName, true, MismatchingTypesStrategy.MismatchTOLERATE);
        int minLength = this.resolveIntFromObject(schema, JSON_KEYWORD_MIN_LENGTH, objectName, NumberAccumulationStrategy.PreferSMALL);
        this.resolveStringFromObject(schema, JSON_KEYWORD_MIN_LENGTH, objectName, true, MismatchingTypesStrategy.MismatchTOLERATE);
        String dataType = "string";
        if (format.length() > 0) {
            if (format.equals(JSON_FORMAT_DATE_TIME)) {
                dataType = "dateTime";
                whitespace = null;
                js2ls.checkForIncompatibleKeywords(schema, format);
            } else if (format.equals(JSON_FORMAT_EMAIL)) {
                pattern = "^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}$";
                pattern = ":email:";
            } else if (format.equals(JSON_FORMAT_HOSTNAME)) {
                pattern = "(((([a-zA-Z0-9][-a-zA-Z0-9]{0,61})?[a-zA-Z0-9])[.])*([a-zA-Z][-a-zA-Z0-9]{0,61}[a-zA-Z0-9]|[a-zA-Z])[.]?)";
                pattern = ":hostname:";
                maxLength = 255;
            } else if (format.equals(JSON_FORMAT_IPV4)) {
                pattern = "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.|$)){4}$";
                pattern = ":ipv4:";
            } else if (format.equals(JSON_FORMAT_IPV6)) {
                pattern = "^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$";
                pattern = ":ipv6:";
            } else if (format.equals(JSON_FORMAT_URI)) {
                dataType = "anyURI";
                whitespace = null;
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_URI_REF) || MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_URI_REFERENCE)) {
                dataType = "anyURI";
                whitespace = null;
            } else if (!MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_BASE64_BINARY)) {
                dataType = JSON_FORMAT_BASE64_BINARY;
                whitespace = null;
            } else if (!MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_HEX_BINARY)) {
                dataType = JSON_FORMAT_HEX_BINARY;
                whitespace = null;
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_DATE)) {
                dataType = JSON_FORMAT_DATE;
                whitespace = null;
                js2ls.checkForIncompatibleKeywords(schema, format);
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_TIME)) {
                dataType = JSON_FORMAT_TIME;
                whitespace = null;
                js2ls.checkForIncompatibleKeywords(schema, format);
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_DURATION)) {
                dataType = JSON_FORMAT_DURATION;
                whitespace = null;
                js2ls.checkForIncompatibleKeywords(schema, format);
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_IDN_EMAIL)) {
                pattern = "^[\\p{L}\\p{N}._%+-]+@[\\p{L}\\p{N}.-]+\\.[\\p{L}]{2,4}$";
                pattern = ":idn-email:";
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_IDN_HOSTNAME)) {
                pattern = "(((([\\p{L}\\p{N}][-\\p{L}\\p{N}]{0,61})?[\\p{L}\\p{N}])[.])*([\\p{L}Z][-\\p{L}\\p{N}]{0,61}[\\p{L}\\p{N}]|[\\p{L}])[.]?)";
                pattern = ":idn-hostname:";
                maxLength = 255;
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_IRI)) {
                dataType = "anyURI";
                whitespace = null;
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_IRI_REFERENCE)) {
                dataType = "anyURI";
                whitespace = null;
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_UUID)) {
                dataType = "anyURI";
                whitespace = null;
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_URI_TEMPLATE)) {
                dataType = "anyURI";
                whitespace = null;
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_JSON_POINTER)) {
                pattern = "^#/?.*";
                pattern = ":json-pointer:";
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_RELATIVE_JSON_POINTER)) {
                pattern = "^[0-9]{0, 255}#|/.*";
                pattern = ":relative-json-pointer:";
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && format.equals(JSON_FORMAT_REGEX)) {
                pattern = ".*";
                pattern = ":regex:";
            } else {
                Logging.writeMessage(4, "DFHPI9708W", new Object[]{format, "string", objectName});
            }
        }
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel) && !(encoding = this.resolveStringFromObject(schema, JSON_KEYWORD_CONTENT_ENCODING, objectName, true, MismatchingTypesStrategy.MismatchTOLERATE)).equals("")) {
            if (encoding.equals(JSON_CONTENT_ENCODING_BINARY)) {
                dataType = JSON_FORMAT_HEX_BINARY;
                whitespace = null;
            } else if (encoding.equals(JSON_CONTENT_ENCODING_BASE64)) {
                dataType = JSON_FORMAT_BASE64_BINARY;
                whitespace = null;
            } else {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9751E", new Object[]{encoding, objectName}));
            }
        }
        if (keyValue.length() > 0 && maxLength <= 0) {
            throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9709E"));
        }
        if (minLength < 0 || keyValue.length() > 0 && maxLength < minLength) {
            throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9709E"));
        }
        generatedWsdl.add(prefix + "<xsd:simpleType>");
        generatedWsdl.add(prefix + THIRD_INDENT + "<xsd:restriction base=\"xsd:" + dataType + "\">");
        if (maxLength != 0) {
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:maxLength value=\"" + maxLength + "\"/>");
        }
        if (maxLength != 0) {
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:minLength value=\"" + minLength + "\"/>");
        }
        if (pattern.length() > 0) {
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:pattern value=\"" + pattern + "\"/>");
        }
        if (whitespace != null) {
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:whiteSpace value=\"" + whitespace.toLowerCase() + "\"/>");
        }
        js2ls.addEnumeratedValuesToXMLSchema(generatedWsdl, prefix, enumeratedValues);
        generatedWsdl.add(prefix + THIRD_INDENT + "</xsd:restriction>");
        generatedWsdl.add(prefix + "</xsd:simpleType>");
    }

    private static void addEnumeratedValuesToXMLSchema(ArrayList<String> generatedWsdl, String prefix, JSONArray enumeratedValues) {
        if (enumeratedValues != null) {
            int length = enumeratedValues.length();
            for (int i = 0; i < length; ++i) {
                try {
                    String value = enumeratedValues.get(i).toString();
                    if (value == null || JSON_DEFINITIONS_NULL.equals(value)) continue;
                    generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:enumeration value=\"" + value + "\"/>");
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
    }

    private static void checkForIncompatibleKeywords(JSONObject schema, String format) throws CICSWSDLException {
        JSONArray keywordArray = schema.names();
        Set<String> keywords = js2ls.jsonArrayToSet(keywordArray);
        String badKeywords = null;
        for (int i = 0; i < JSON_FORMAT_UNSUPPORTED_KEYWORDS.length; ++i) {
            String element = JSON_FORMAT_UNSUPPORTED_KEYWORDS[i];
            if (!keywords.contains(element)) continue;
            badKeywords = badKeywords == null ? "[\"" + element + "\"" : badKeywords + ", \"" + element + "\"";
        }
        if (badKeywords != null) {
            badKeywords = badKeywords + "]";
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9710E", new Object[]{badKeywords, format}));
        }
    }

    private void appendBooleanToWsdl(ArrayList<String> generatedWsdl, JSONObject schema, String prefix, String objectName) throws CICSWSDLException {
        String format = this.resolveStringFromObject(schema, JSON_KEYWORD_FORMAT, objectName, true, MismatchingTypesStrategy.MismatchTOLERATE);
        if (!"".equals(format)) {
            Logging.writeMessage(4, "DFHPI9708W", new Object[]{format, "integer", objectName});
        }
        generatedWsdl.add(prefix + "<xsd:simpleType>");
        generatedWsdl.add(prefix + THIRD_INDENT + "<xsd:restriction base=\"xsd:boolean\"/>");
        generatedWsdl.add(prefix + "</xsd:simpleType>");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendIntegerToWsdl(ArrayList<String> generatedWsdl, JSONObject schema, String prefix, JSONArray enumeratedValues, String objectName) throws CICSWSDLException {
        DecimalFormat longIntegerFormat = new DecimalFormat("####################");
        BigInteger maximum = this.getBigIntegerValue(schema, JSON_KEYWORD_MAXIMUM, objectName, NumberAccumulationStrategy.PreferBIG);
        BigInteger minimum = this.getBigIntegerValue(schema, JSON_KEYWORD_MINIMUM, objectName, NumberAccumulationStrategy.PreferSMALL);
        boolean maxExclusive = false;
        boolean minExclusive = false;
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
            if (maximum == null) {
                maximum = this.getBigIntegerValue(schema, JSON_KEYWORD_EXCLUSIVE_MAXIMUM, objectName, NumberAccumulationStrategy.PreferBIG);
                maxExclusive = true;
            }
            if (minimum == null) {
                minimum = this.getBigIntegerValue(schema, JSON_KEYWORD_EXCLUSIVE_MINIMUM, objectName, NumberAccumulationStrategy.PreferSMALL);
                minExclusive = true;
            }
        } else {
            maxExclusive = this.getBooleanDefaultToFalse(schema, JSON_KEYWORD_EXCLUSIVE_MAXIMUM) | this.getBooleanDefaultToFalse(schema, JSON_KEYWORD_MAX_EXCLUSIVE);
            minExclusive = this.getBooleanDefaultToFalse(schema, JSON_KEYWORD_EXCLUSIVE_MINIMUM) | this.getBooleanDefaultToFalse(schema, JSON_KEYWORD_MIN_EXCLUSIVE);
        }
        String formattedMax = null;
        String formattedMin = null;
        String numType = "long";
        String format = this.resolveStringFromObject(schema, JSON_KEYWORD_FORMAT, objectName, true, MismatchingTypesStrategy.MismatchTOLERATE);
        if (!"".equals(format)) {
            Logging.writeMessage(4, "DFHPI9708W", new Object[]{format, "integer", objectName});
        }
        if (minimum == null) {
            minimum = BigInteger.ZERO.subtract(BigInteger.ONE);
        } else {
            formattedMin = longIntegerFormat.format(minimum);
        }
        if (maximum == null) {
            maximum = MAX_SIGNED_LONG;
            if (minimum.compareTo(BigInteger.ZERO) >= 0) {
                maximum = js2ls.unsignedValue(maximum);
            }
        } else {
            formattedMax = longIntegerFormat.format(maximum);
        }
        if (formattedMax != null && formattedMin != null && minimum.compareTo(maximum) > 0) {
            if (!MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9707E"));
            throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9749E"));
        }
        if (minimum.compareTo(BigInteger.ZERO) >= 0) {
            if (maximum != null) {
                if (maximum.compareTo(MAX_UNSIGNED_BYTE) <= 0 && (Util.getLanguage(this.p.getProperty("LANG")) != 1 || !MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel) && this.p.getProperty("INTEGER-AS-PIC9") != "YES")) {
                    numType = "unsignedByte";
                    if (formattedMax != null && formattedMin != null && maximum.compareTo(MAX_UNSIGNED_BYTE) == 0 && minimum.compareTo(BigInteger.ZERO) == 0) {
                        formattedMax = null;
                        formattedMin = null;
                    }
                } else if (maximum.compareTo(MAX_UNSIGNED_SHORT) <= 0) {
                    numType = "unsignedShort";
                    if (formattedMax != null && formattedMin != null && maximum.compareTo(MAX_UNSIGNED_SHORT) == 0 && minimum.compareTo(BigInteger.ZERO) == 0) {
                        formattedMax = null;
                        formattedMin = null;
                    }
                } else if (maximum.compareTo(MAX_UNSIGNED_INTEGER) <= 0) {
                    numType = "unsignedInt";
                    if (formattedMax != null && formattedMin != null && maximum.compareTo(MAX_UNSIGNED_INTEGER) == 0 && minimum.compareTo(BigInteger.ZERO) == 0) {
                        formattedMax = null;
                        formattedMin = null;
                    }
                } else {
                    if (maximum.compareTo(MAX_UNSIGNED_LONG) > 0) throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9707E"));
                    numType = "unsignedLong";
                    if (formattedMax != null && formattedMin != null && maximum.compareTo(MAX_UNSIGNED_LONG) == 0 && minimum.compareTo(BigInteger.ZERO) == 0) {
                        formattedMax = null;
                        formattedMin = null;
                    }
                }
            } else {
                numType = "unsignedLong";
            }
        } else {
            BigInteger size = minimum;
            if (minimum.compareTo(BigInteger.ZERO) < 0) {
                size = BigInteger.ZERO.subtract(BigInteger.ONE).subtract(minimum);
            }
            if (maximum.compareTo(BigInteger.ZERO) >= 0) {
                if (size.compareTo(maximum) < 0) {
                    size = maximum;
                }
            } else {
                BigInteger minusMax = BigInteger.ZERO.subtract(maximum);
                if (size.compareTo(minusMax) < 0) {
                    size = minusMax;
                }
            }
            if (size.compareTo(MAX_SIGNED_BYTE) <= 0 && (Util.getLanguage(this.p.getProperty("LANG")) != 1 || !MappingLevelHelper.supportsMappingLevel_4_0(this.mappingLevel) && this.p.getProperty("INTEGER-AS-PIC9") != "YES")) {
                numType = "byte";
                if (formattedMax != null && formattedMin != null && maximum.compareTo(MAX_SIGNED_BYTE) == 0 && minimum.compareTo(MIN_SIGNED_BYTE) == 0) {
                    formattedMax = null;
                    formattedMin = null;
                }
            } else if (size.compareTo(MAX_SIGNED_SHORT) <= 0) {
                numType = "short";
                if (formattedMax != null && formattedMin != null && maximum.compareTo(MAX_SIGNED_SHORT) == 0 && minimum.compareTo(MIN_SIGNED_SHORT) == 0) {
                    formattedMax = null;
                    formattedMin = null;
                }
            } else if (size.compareTo(MAX_SIGNED_INTEGER) <= 0) {
                numType = "int";
                if (formattedMax != null && formattedMin != null && maximum.compareTo(MAX_SIGNED_INTEGER) == 0 && minimum.compareTo(MIN_SIGNED_INTEGER) == 0) {
                    formattedMax = null;
                    formattedMin = null;
                }
            } else {
                if (size.compareTo(MAX_SIGNED_LONG) > 0) throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9707E"));
                numType = "long";
                if (formattedMax != null && formattedMin != null && maximum.compareTo(MAX_SIGNED_LONG) == 0 && minimum.compareTo(MIN_SIGNED_LONG) == 0) {
                    formattedMax = null;
                    formattedMin = null;
                }
            }
        }
        generatedWsdl.add(prefix + "<xsd:simpleType>");
        generatedWsdl.add(prefix + THIRD_INDENT + "<xsd:restriction base=\"xsd:" + numType + "\">");
        if (formattedMax != null) {
            if (maxExclusive) {
                generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:maxExclusive value=\"" + formattedMax + "\"/>");
            } else {
                generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:maxInclusive value=\"" + formattedMax + "\"/>");
            }
        }
        if (formattedMin != null) {
            if (minExclusive) {
                generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:minExclusive value=\"" + formattedMin + "\"/>");
            } else {
                generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:minInclusive value=\"" + formattedMin + "\"/>");
            }
        }
        js2ls.addEnumeratedValuesToXMLSchema(generatedWsdl, prefix, enumeratedValues);
        generatedWsdl.add(prefix + THIRD_INDENT + "</xsd:restriction>");
        generatedWsdl.add(prefix + "</xsd:simpleType>");
    }

    private void appendNumberToWsdl(ArrayList<String> generatedWsdl, JSONObject schema, String prefix, JSONArray enumeratedValues, String objectName) throws CICSWSDLException {
        String numberType = this.resolveStringFromObject(schema, JSON_KEYWORD_FORMAT, objectName, true, MismatchingTypesStrategy.MismatchTOLERATE);
        if (numberType.length() == 0) {
            numberType = JSON_FORMAT_DOUBLE;
        }
        if (!(numberType.equals(JSON_FORMAT_DECIMAL) || numberType.equals(JSON_FORMAT_FLOAT) || numberType.equals(JSON_FORMAT_DOUBLE))) {
            Logging.writeMessage(4, "DFHPI9708W", new Object[]{numberType, "number", objectName});
            numberType = JSON_FORMAT_DOUBLE;
        }
        String formattedMax = null;
        String formattedMin = null;
        BigDecimal max = this.resolveDecimalFromObject(schema, JSON_KEYWORD_MAXIMUM, objectName, NumberAccumulationStrategy.PreferBIG);
        BigDecimal min = this.resolveDecimalFromObject(schema, JSON_KEYWORD_MINIMUM, objectName, NumberAccumulationStrategy.PreferSMALL);
        boolean maxExclusive = false;
        boolean minExclusive = false;
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
            if (min == null) {
                min = this.resolveDecimalFromObject(schema, JSON_KEYWORD_EXCLUSIVE_MINIMUM, objectName, NumberAccumulationStrategy.PreferBIG);
                minExclusive = true;
            }
            if (max == null) {
                max = this.resolveDecimalFromObject(schema, JSON_KEYWORD_EXCLUSIVE_MAXIMUM, objectName, NumberAccumulationStrategy.PreferBIG);
                maxExclusive = true;
            }
        } else {
            maxExclusive = this.getBooleanDefaultToFalse(schema, JSON_KEYWORD_EXCLUSIVE_MAXIMUM) | this.getBooleanDefaultToFalse(schema, JSON_KEYWORD_MAX_EXCLUSIVE);
            minExclusive = this.getBooleanDefaultToFalse(schema, JSON_KEYWORD_EXCLUSIVE_MINIMUM) | this.getBooleanDefaultToFalse(schema, JSON_KEYWORD_MIN_EXCLUSIVE);
        }
        if (max != null) {
            formattedMax = max.toPlainString();
        }
        if (formattedMax == null && (formattedMax = this.getStringDefaultToNull(schema, JSON_KEYWORD_MAXIMUM, objectName)) == null && MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
            formattedMax = this.getStringDefaultToNull(schema, JSON_KEYWORD_EXCLUSIVE_MAXIMUM, objectName);
        }
        if (min != null) {
            formattedMin = min.toPlainString();
        }
        if (formattedMin == null && (formattedMin = this.getStringDefaultToNull(schema, JSON_KEYWORD_MINIMUM, objectName)) == null && MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
            formattedMin = this.getStringDefaultToNull(schema, JSON_KEYWORD_EXCLUSIVE_MINIMUM, objectName);
        }
        String formattedMultipleOf = null;
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
            formattedMultipleOf = this.getStringDefaultToNull(schema, JSON_KEYWORD_MULTIPLE_OF, objectName);
        }
        String totalDigits = null;
        String fractionDigits = null;
        if (numberType.equals(JSON_FORMAT_DECIMAL) && (formattedMax != null && formattedMin != null || formattedMultipleOf != null)) {
            int maxDigits = 0;
            int maxFraction = 0;
            if (formattedMax != null && formattedMin != null) {
                maxDigits = js2ls.getIntegerDigits(formattedMax);
                int minDigits = js2ls.getIntegerDigits(formattedMin);
                maxDigits = Math.max(maxDigits, minDigits);
                maxFraction = js2ls.getFractionDigits(formattedMax);
                int minFraction = js2ls.getFractionDigits(formattedMin);
                maxFraction = Math.max(maxFraction, minFraction);
            }
            int multipleOfFraction = 0;
            if (formattedMultipleOf != null && (multipleOfFraction = js2ls.getFractionDigits(formattedMultipleOf)) > maxFraction) {
                maxFraction = multipleOfFraction;
            }
            maxDigits += maxFraction;
            int maximumSupportedDigits = 18;
            if (!"NO".equals(this.p.getProperty("WIDE-COMP3"))) {
                maximumSupportedDigits = 31;
            }
            if (maxDigits > maximumSupportedDigits) {
                maxFraction -= maxDigits - maximumSupportedDigits;
                maxDigits = maximumSupportedDigits;
                if (maxFraction < 0) {
                    throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9713E"));
                }
                formattedMin = js2ls.reduceDecimalDigits(formattedMin, maxFraction);
                formattedMax = js2ls.reduceDecimalDigits(formattedMax, maxFraction);
                Logging.writeMessage(4, "DFHPI9712W", null);
            }
            totalDigits = "<xsd:totalDigits value=\"" + maxDigits + "\"/>";
            fractionDigits = "<xsd:fractionDigits value=\"" + maxFraction + "\"/>";
        }
        generatedWsdl.add(prefix + "<xsd:simpleType>");
        generatedWsdl.add(prefix + THIRD_INDENT + "<xsd:restriction base=\"xsd:" + numberType + "\">");
        if (formattedMax != null) {
            if (maxExclusive) {
                generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:maxExclusive value=\"" + formattedMax + "\"/>");
            } else {
                generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:maxInclusive value=\"" + formattedMax + "\"/>");
            }
        }
        if (totalDigits != null) {
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + totalDigits);
        }
        if (fractionDigits != null) {
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + fractionDigits);
        }
        if (formattedMin != null) {
            if (minExclusive) {
                generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:minExclusive value=\"" + formattedMin + "\"/>");
            } else {
                generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:minInclusive value=\"" + formattedMin + "\"/>");
            }
        }
        js2ls.addEnumeratedValuesToXMLSchema(generatedWsdl, prefix, enumeratedValues);
        generatedWsdl.add(prefix + THIRD_INDENT + "</xsd:restriction>");
        generatedWsdl.add(prefix + "</xsd:simpleType>");
    }

    private static String reduceDecimalDigits(String formattedMin, int maxFraction) {
        BigDecimal bigValue = new BigDecimal(formattedMin);
        bigValue = bigValue.movePointRight(maxFraction);
        bigValue = new BigDecimal(bigValue.toBigInteger());
        bigValue = bigValue.movePointLeft(maxFraction);
        formattedMin = bigValue.toPlainString();
        return formattedMin;
    }

    private static int getIntegerDigits(String formattedNumber) {
        if ((formattedNumber = formattedNumber.trim()).startsWith("-")) {
            formattedNumber = formattedNumber.substring(1);
        }
        if (formattedNumber.startsWith("0")) {
            formattedNumber = formattedNumber.substring(1);
        }
        int digits = formattedNumber.length();
        int pos = formattedNumber.indexOf(46);
        if (pos >= 0) {
            formattedNumber = formattedNumber.substring(0, pos);
            digits = formattedNumber.length();
        }
        return digits;
    }

    private static int getFractionDigits(String formattedNumber) {
        int digits = 0;
        if ((formattedNumber = formattedNumber.trim()).startsWith("1E-")) {
            Integer value = Integer.valueOf(formattedNumber.substring("1E-".length()));
            return value;
        }
        int pos = formattedNumber.indexOf(46);
        if (pos >= 0) {
            formattedNumber = formattedNumber.substring(pos + 1);
            digits = formattedNumber.length();
        }
        return digits;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendArrayToWsdl(ArrayList<String> generatedWsdl, JSONObject schema, String prefix, int elementLineNumber, String arrayName, boolean forceOptional, ArrayList<String> schemaReferencesFollowed, JsonType keyType) throws CICSWSDLException {
        if (elementLineNumber < 0) {
            if (!MappingLevelHelper.supportsMappingLevel_4_3(this.mappingLevel)) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9714E", new Object[]{"DFHWrapper"}));
            }
            elementLineNumber = generatedWsdl.size() - 1;
        }
        int minItems = this.resolveIntFromObject(schema, JSON_KEYWORD_MIN_ITEMS, arrayName, NumberAccumulationStrategy.PreferSMALL);
        int items = this.resolveIntFromObject(schema, JSON_KEYWORD_MAX_ITEMS, arrayName, NumberAccumulationStrategy.PreferBIG);
        String stringValue = this.resolveStringFromObject(schema, JSON_KEYWORD_MAX_ITEMS, arrayName, true, MismatchingTypesStrategy.MismatchTOLERATE);
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
            this.resolveBooleanFromObject(schema, JSON_KEYWORD_UNIQUE_ITEMS);
        }
        String maxOccurs = this.defaultArrayMaxItems > -1 ? (this.defaultArrayMaxItems >= minItems ? Integer.toString(this.defaultArrayMaxItems) : Integer.toString(minItems)) : "unbounded";
        if (stringValue.length() > 0) {
            if (items <= 0) throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9706E", new Object[]{JSON_KEYWORD_MAX_ITEMS}));
            maxOccurs = "" + items;
        } else {
            items = Integer.MAX_VALUE;
        }
        String minOccurs = " minOccurs=\"" + minItems + "\"";
        if (minItems < 0 || minItems > items) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9706E", new Object[]{JSON_KEYWORD_MIN_ITEMS}));
        }
        String oldLine = generatedWsdl.get(elementLineNumber);
        int placeToAdd = oldLine.length() - 1;
        if (oldLine.contains("maxOccurs")) {
            int startName = oldLine.indexOf(NAME_ATTRIBUTE);
            int endName = oldLine.indexOf(34, startName + NAME_ATTRIBUTE.length());
            String realName = oldLine.substring(startName + NAME_ATTRIBUTE.length(), endName);
            this.processMultiDimensionalArray(generatedWsdl, schema, realName, prefix, minOccurs, maxOccurs, schemaReferencesFollowed, keyType);
            return;
        }
        if (oldLine.contains("</xsd:annotation>") && elementLineNumber > 2) {
            oldLine = generatedWsdl.get(elementLineNumber -= 2);
            int indexOfArrayName = oldLine.indexOf("com.ibm.cics.wsdl.properties.outerArrayName");
            if (indexOfArrayName <= -1) return;
            String realName = oldLine.substring(indexOfArrayName + 1 + "com.ibm.cics.wsdl.properties.outerArrayName".length());
            this.processMultiDimensionalArray(generatedWsdl, schema, realName, prefix, minOccurs, maxOccurs, schemaReferencesFollowed, keyType);
            return;
        }
        if (forceOptional) {
            minOccurs = " minOccurs=\"0\"";
            js2ls.appendOptionalArrayAnnotation(generatedWsdl, prefix + INDENT);
        }
        String nameLine = oldLine.substring(0, placeToAdd);
        nameLine = nameLine + minOccurs + " maxOccurs=\"" + maxOccurs + "\">";
        generatedWsdl.set(elementLineNumber, nameLine);
        this.processArrayContents(generatedWsdl, schema, prefix, arrayName, schemaReferencesFollowed, elementLineNumber);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processArrayContents(ArrayList<String> generatedWsdl, JSONObject schema, String prefix, String arrayName, ArrayList<String> schemaReferencesFollowed, int elementLineNumber) throws CICSWSDLException {
        JSONObject subSchema;
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
            subSchema = this.resolveAndCombineJSONObjectFromObject(schema, arrayName, JSON_KEYWORD_ITEMS);
            if (subSchema == null) {
                JSONArray array = this.resolveJSONArrayFromObject(schema, JSON_KEYWORD_PREFIX_ITEMS);
                if (array == null) throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9754E", new Object[]{arrayName}));
                try {
                    JSONObject typeString = new JSONObject();
                    typeString.put(JSON_KEYWORD_TYPE, (Object)"string");
                    schema.put(JSON_KEYWORD_ITEMS, (Object)typeString);
                    subSchema = this.resolveAndCombineJSONObjectFromObject(schema, arrayName, JSON_KEYWORD_ITEMS);
                }
                catch (JSONException typeString) {}
            }
        } else {
            subSchema = this.resolveAndCombineJSONObjectFromObject(schema, arrayName, JSON_KEYWORD_ITEMS);
        }
        if (subSchema == null) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9698E", new Object[]{arrayName}));
        }
        List<JsonType> schemaTypes = this.getSchemasType(subSchema, JSON_KEYWORD_ITEMS);
        String entity = generatedWsdl.get(elementLineNumber);
        for (int i = 0; i < schemaTypes.size(); ++i) {
            String newEntity;
            String typeName;
            JsonType schemaType = schemaTypes.get(i);
            if (schemaTypes.size() > 1 && i == 0) {
                typeName = schemaType.name().substring(1).replaceFirst("Nullable", "");
                typeName = Character.toLowerCase(typeName.charAt(0)) + typeName.substring(1);
                newEntity = entity.replace(arrayName, arrayName + "-" + typeName);
                generatedWsdl.set(elementLineNumber, newEntity);
            } else if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
                String defaultConst = subSchema.optString(JSON_KEYWORD_CONST);
                if (defaultConst.equals("")) {
                    defaultConst = subSchema.optString(JSON_KEYWORD_DEFAULT);
                }
                if (!defaultConst.equals("")) {
                    String elementLine = entity.substring(0, entity.length() - 1) + " default=\"" + defaultConst + "\" >";
                    generatedWsdl.set(elementLineNumber, elementLine);
                }
            }
            this.appendSchemaToWsdl(generatedWsdl, subSchema, prefix, false, generatedWsdl.size() - 1, JSON_KEYWORD_ITEMS, null, false, schemaReferencesFollowed, schemaTypes, schemaType, false);
            if (schemaTypes.size() <= 1 || i + 1 >= schemaTypes.size()) continue;
            generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "</xsd:element>");
            schemaType = schemaTypes.get(i + 1);
            typeName = schemaType.name().substring(1).replaceFirst("Nullable", "");
            typeName = Character.toLowerCase(typeName.charAt(0)) + typeName.substring(1);
            newEntity = entity.replace(arrayName, arrayName + "-" + typeName);
            generatedWsdl.add(newEntity);
        }
    }

    private void processMultiDimensionalArray(ArrayList<String> generatedWsdl, JSONObject schema, String arrayName, String prefix, String minOccurs, String maxOccurs, ArrayList<String> schemaReferencesFollowed, JsonType keyType) throws CICSWSDLException {
        if (arrayName.endsWith("-array-array-array")) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9763E", new Object[]{arrayName.substring(0, arrayName.indexOf("-array-array-array"))}));
        }
        if (!MappingLevelHelper.supportsMappingLevel_4_3(this.mappingLevel)) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9714E", new Object[]{arrayName}));
        }
        String nillable = "false";
        if (JsonType.TNullableArray.equals((Object)keyType)) {
            nillable = "true";
        }
        generatedWsdl.add(prefix + "<xsd:complexType>");
        generatedWsdl.add(prefix + THIRD_INDENT + "<xsd:sequence>");
        String xsdElement = prefix + THIRD_INDENT + THIRD_INDENT + "<xsd:element name=\"" + arrayName + "\" nillable=\"" + nillable + "\"" + minOccurs + " maxOccurs=\"" + maxOccurs + "\" >";
        if (MappingLevelHelper.supportsMappingLevel_5_0(this.mappingLevel)) {
            String defaultConst = schema.optString(JSON_KEYWORD_CONST);
            if (defaultConst.equals("")) {
                defaultConst = schema.optString(JSON_KEYWORD_DEFAULT);
            }
            if (!defaultConst.equals("")) {
                xsdElement = xsdElement.substring(0, xsdElement.length() - 1) + " default=\"" + defaultConst + "\" >";
            }
        }
        generatedWsdl.add(xsdElement);
        int elementLineNumber = generatedWsdl.size() - 1;
        generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + "<xsd:annotation>");
        generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + "<xsd:appinfo source=\"" + "http://www.ibm.com/software/htp/cics/annotations" + "\">");
        generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + "com.ibm.cics.wsdl.properties.innerArray" + "=true");
        generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + "com.ibm.cics.wsdl.properties.outerArrayName" + "=" + arrayName);
        generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + "</xsd:appinfo>");
        generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + THIRD_INDENT + "</xsd:annotation>");
        this.processArrayContents(generatedWsdl, schema, prefix, arrayName, schemaReferencesFollowed, elementLineNumber);
        generatedWsdl.add(prefix + THIRD_INDENT + THIRD_INDENT + "</xsd:element>");
        generatedWsdl.add(prefix + THIRD_INDENT + "</xsd:sequence>");
        generatedWsdl.add(prefix + "</xsd:complexType>");
    }

    private BigInteger getBigIntegerValue(JSONObject schema, String key, String objectName, NumberAccumulationStrategy accumulationStrategy) throws CICSWSDLException {
        BigInteger value;
        try {
            value = this.resolveIntegerFromObject(schema, key, objectName, accumulationStrategy);
        }
        catch (NumberFormatException e) {
            BigDecimal number = this.resolveDecimalFromObject(schema, key, objectName, accumulationStrategy);
            value = number.toBigIntegerExact();
            Logging.writeMessage(4, "DFHPI9711W", new Object[]{number.toPlainString(), value.toString()});
        }
        return value;
    }

    private boolean getBooleanDefaultToFalse(JSONObject schema, String key) throws CICSWSDLException {
        return this.resolveBooleanFromObject(schema, key);
    }

    private String getStringDefaultToNull(JSONObject schema, String key, String objectName) throws CICSWSDLException {
        String value = this.resolveStringFromObject(schema, key, objectName, true, MismatchingTypesStrategy.MismatchTOLERATE);
        if ("".equals(value)) {
            return null;
        }
        return value;
    }

    private static BigInteger unsignedValue(BigInteger value) {
        value = value.multiply(new BigInteger("2"));
        value = value.add(BigInteger.ONE);
        return value;
    }

    private static enum NumberAccumulationStrategy {
        PreferBIG,
        PreferSMALL;

    }

    private static enum MismatchingTypesStrategy {
        MismatchREJECT,
        MismatchTOLERATE,
        MismatchREJECTExceptNull;

    }

    private static enum JsonType {
        Tobject(false),
        TNullableObject(true),
        Tarray(false),
        TNullableArray(true),
        Tboolean(false),
        TNullableBoolean(true),
        Tinteger(false),
        TNullableInteger(true),
        Tnumber(false),
        TNullableNumber(true),
        Tnull(false),
        Tstring(false),
        TNullableString(true);

        private boolean nullValid;

        private JsonType(boolean nullable) {
            this.nullValid = nullable;
        }

        public boolean isNullSupported() {
            return this.nullValid;
        }

        public JsonType getNullableVariant() {
            if (this.isNullSupported()) {
                return this;
            }
            switch (this) {
                case Tarray: {
                    return TNullableArray;
                }
                case Tboolean: {
                    return TNullableBoolean;
                }
                case Tinteger: {
                    return TNullableInteger;
                }
                case Tnull: {
                    return this;
                }
                case Tnumber: {
                    return TNullableNumber;
                }
                case Tobject: {
                    return TNullableObject;
                }
                case Tstring: {
                    return TNullableString;
                }
            }
            throw new RuntimeException("Unexpected type: " + (Object)((Object)this));
        }
    }
}

