/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ws2ls;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMBuilder;
import com.ibm.cics.schema.ICMCreationParameters;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.impl.Factory;
import com.ibm.cics.schema.impl.ICMImplFromWSDL;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.schema.utils.RuntimeLevelHelper;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.GenericSetup;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.QNameComparator;
import com.ibm.cics.wsdl.common.Util;
import com.ibm.cics.wsdl.common.XSDBind;
import com.ibm.cics.wsdl.ws2ls.BootStrapICM;
import com.ibm.cics.wsdl.ws2ls.LangStructManager;
import com.ibm.cics.wsdl.ws2ls.WSDLFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.xml.sax.SAXException;

public class sc2ls
extends GenericSetup {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private boolean inputFromWSDL = false;
    private Map<Object, String> PDSMEMs = new HashMap<Object, String>();
    private List<QName> globalElements = new LinkedList<QName>();
    private List<QName> globalTypes = new LinkedList<QName>();
    private List<ICM> elementICMs = new LinkedList<ICM>();
    private List<ICM> typeICMs = new LinkedList<ICM>();
    private static final boolean ELEMENT = true;
    private static final boolean TYPE = false;
    private Set<QName> enabledAsNillable = new TreeSet<QName>(new QNameComparator());

    @Override
    public void run(String[] args) {
        if (this.apiResp != null) {
            this.apiResp.setPDSMEMs(this.PDSMEMs);
            this.apiResp.setElementQNames(this.globalElements);
            this.apiResp.setTypeQNames(this.globalTypes);
        }
        this.commonExecute(args, 2, this.timestamp);
    }

    public static void main(String[] args) {
        sc2ls me = new sc2ls();
        me.run(args);
    }

    @Override
    public void doAssistantSpecificProcessing() throws CICSWSDLException {
        ICMBuilder builder = null;
        try {
            if (!this.vendorBindFileNeeded) {
                builder = this.getICMBuilder();
                ICMCreationParameters parms = this.initialiseBuilderForICM(builder);
                List<QName> elementsFromSchema = builder.getGlobalElements();
                List<QName> typesFromSchema = builder.getGlobalTypes();
                List<String> elementsFromUser = this.checker.getSchemaElements();
                List<String> typesFromUser = this.checker.getSchemaTypes();
                int numProcessed = this.processGlobalElements(elementsFromUser, elementsFromSchema, builder, parms);
                this.processAbstractSubTypes(builder, parms, typesFromSchema);
                this.reportUnprocessedElements(elementsFromUser);
                this.reportUnprocessedTypes(typesFromUser);
                if ((numProcessed += this.processGlobalTypes(typesFromUser, typesFromSchema, builder, parms)) == 0) {
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9670E", null));
                }
                if (this.checker.getBootStrapICM() != null) {
                    this.generateBootStrapICM(this.checker.getBootStrapICM());
                }
            }
            File xsdBind = this.buildXSDBindFile();
            if (!this.vendorBindFileNeeded) {
                this.generateAllLangStructs(xsdBind);
            }
        }
        catch (IOException e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{this.getFileName(), e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        catch (JAXBException e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{this.getFileName(), e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        catch (SAXException e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9523E", new Object[]{this.getFileName(), e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        catch (ICMException exc) {
            CICSWSDLException newEx = builder != null && builder.getMessages().length > 0 ? new CICSWSDLException(builder.getMessages()) : new CICSWSDLException(exc.getLocalizedMessage());
            newEx.initCause(exc);
            throw newEx;
        }
    }

    public String getBindFileName() {
        return this.p.getProperty("XSDBIND");
    }

    public XSDBind initBindFile() {
        return new XSDBind(this.isUTF8RequiredForXML("XMLCP"), this.isUsEBCDICRequiredForXML("XMLCP"), this.checker.getWSDLEncodingRequired());
    }

    private File buildXSDBindFile() throws IOException, ICMException, JAXBException, SAXException, CICSWSDLException {
        XSDBind xsdbind = this.initBindFile();
        File topLevelFile = this.getSchemaFile();
        return xsdbind.buildXSDBindFile(this.getBindFileName(), topLevelFile.getName(), RuntimeLevelHelper.WSBindMajorVerToRuntimeStr(this.checker.getWSBindVerNumber()), this.timestamp, this.p.getProperty("CCSID"), null, this.globalElements, this.elementICMs, this.globalTypes, this.typeICMs, ICM.MAPPING_LEVELS[this.mappingLevel], this.p.getProperty("BUNDLE"), topLevelFile, this.p.getProperty("VENDOR-CONVERTER-NAME"), this.vendorMetaData);
    }

    protected File getSchemaFile() {
        return new File(this.getFileName());
    }

    private ICMBuilder getICMBuilder() throws CICSWSDLException, FileNotFoundException, ICMException {
        List<Object> allTypesSections = null;
        String filename = this.getFileName();
        Util.checkXMLEncoding(filename, Logging.getPrintStream(), this.isZOS());
        if (this.inputFromWSDL) {
            WSDLFile wsdl = new WSDLFile(filename, true, null, null, this.isZOS(), this.checker.isXmlOnly(), false);
            allTypesSections = wsdl.getURIsForTypeSections(filename, null);
        }
        ICMBuilder builder = Factory.createICMBuilderFromWSDL(filename, this.lang, Logging.getPrintStream());
        if (allTypesSections != null) {
            builder.addURIs(allTypesSections);
        }
        return builder;
    }

    private ICMCreationParameters initialiseBuilderForICM(ICMBuilder builder) throws IOException, ICMException {
        ICMCreationParameters parms = builder.getICMCreationParameters();
        parms.populateParametersObject("TMP", ICM.BindingStyle.DOCUMENT_STYLE, new QName("", ""), ICM.XMLContentType.XML_ELEMENT, this.mappingLevel, true, this.charVaryingLimit, this.charVarying, this.defaultCharMaxlength, this.charMultiplier, this.useHexFloat, this.inlineMaxOccursLimit, false, this.lang, null, false, false, this.useAbstimeDates, this.dataTruncationSupported, this.allowsContainers, this.p, this.defaultFractionDigits, this.platform);
        builder.createICM(parms);
        return parms;
    }

    private int processGlobalElements(List<String> elementsFromUser, List<QName> elementsFromSchema, ICMBuilder builder, ICMCreationParameters parms) throws ICMException, IOException {
        return this.processGlobalItems(elementsFromUser, elementsFromSchema, builder, parms, true);
    }

    private int processGlobalTypes(List<String> typesFromUser, List<QName> typesFromSchema, ICMBuilder builder, ICMCreationParameters parms) throws ICMException, IOException {
        return this.processGlobalItems(typesFromUser, typesFromSchema, builder, parms, false);
    }

    private int processGlobalItems(List<String> itemsFromUser, List<QName> itemsFromSchema, ICMBuilder builder, ICMCreationParameters parms, boolean elements) throws ICMException, IOException {
        boolean enableAllItems = false;
        if (itemsFromUser.size() == 1 && itemsFromUser.get(0).equals("ALL")) {
            enableAllItems = true;
        }
        int numProcessed = 0;
        for (int genNumber = 0; genNumber < itemsFromSchema.size(); ++genNumber) {
            QName qname = itemsFromSchema.get(genNumber);
            if (elements) {
                Logging.getPrintStream().println("Found ICM Element: " + qname);
            } else {
                Logging.getPrintStream().println("Found ICM Type: " + qname);
            }
            if (!enableAllItems && !itemsFromUser.contains(qname.getLocalPart())) continue;
            this.createICM(qname, builder, parms, elements, false);
            itemsFromUser.remove(qname.getLocalPart());
            ++numProcessed;
        }
        return numProcessed;
    }

    private void createICM(QName qname, ICMBuilder builder, ICMCreationParameters parms, boolean elements, boolean nillableType) throws ICMException, IOException {
        if (elements) {
            Logging.getPrintStream().println("Processing ICM Element: " + qname);
        } else {
            Logging.getPrintStream().println("Processing ICM Type: " + qname);
        }
        parms.setName(qname.getLocalPart());
        ICM icm = builder.createICM(parms);
        if (elements) {
            icm.addElementDeclaration(null, null, qname, true);
        } else {
            icm.addGlobalTypeDefinition(qname, nillableType);
        }
        icm.completedICM();
        if (elements) {
            this.globalElements.add(qname);
            this.elementICMs.add(icm);
        } else {
            this.globalTypes.add(qname);
            this.typeICMs.add(icm);
        }
    }

    private void processAbstractSubTypes(ICMBuilder builder, ICMCreationParameters parms, List<QName> allDataTypes) throws ICMException, IOException {
        List<QName> typesToProcess = this.findTypesToEnable(builder);
        do {
            for (QName typeName : typesToProcess) {
                boolean nillable = builder.getNillableAbstractSubTypes().contains(typeName);
                this.createICM(typeName, builder, parms, false, nillable);
            }
        } while (!(typesToProcess = this.findTypesToEnable(builder)).isEmpty());
    }

    private List<QName> findTypesToEnable(ICMBuilder builder) {
        ArrayList<QName> typesToProcess = new ArrayList<QName>();
        TreeSet<QName> newNillables = new TreeSet<QName>(new QNameComparator());
        newNillables.addAll(builder.getNillableAbstractSubTypes());
        newNillables.removeAll(this.enabledAsNillable);
        for (QName newNillableName : newNillables) {
            int indexInGlobalList = this.globalTypes.indexOf(newNillableName);
            if (indexInGlobalList <= -1) continue;
            this.globalTypes.remove(indexInGlobalList);
            this.typeICMs.remove(indexInGlobalList);
        }
        typesToProcess.addAll(builder.getAbstractSubTypes());
        typesToProcess.removeAll(this.globalTypes);
        this.enabledAsNillable.addAll(newNillables);
        Collections.sort(typesToProcess, new ICMImplFromWSDL.QNameComparator());
        return typesToProcess;
    }

    private void generateAllLangStructs(File xsdBind) throws CICSWSDLException {
        int genNumber;
        LangStructManager manager = new LangStructManager(this.usePDSFiles(), this.isZOS());
        HashMap<QName, String> typeMemberNameMap = new HashMap<QName, String>();
        for (genNumber = 0; genNumber < this.globalTypes.size(); ++genNumber) {
            QName qType = this.globalTypes.get(genNumber);
            String fmtdPDSName = manager.formatName(this.p.getProperty("PDSMEM"), genNumber + this.globalElements.size(), this.lang);
            typeMemberNameMap.put(qType, fmtdPDSName);
        }
        for (genNumber = 0; genNumber < this.globalElements.size(); ++genNumber) {
            this.generatelangStructs(this.elementICMs.get(genNumber), this.globalElements.get(genNumber), genNumber, xsdBind, ICM.XMLContentType.XML_ELEMENT, typeMemberNameMap);
        }
        for (genNumber = 0; genNumber < this.globalTypes.size(); ++genNumber) {
            this.generatelangStructs(this.typeICMs.get(genNumber), this.globalTypes.get(genNumber), genNumber + this.globalElements.size(), xsdBind, ICM.XMLContentType.XML_TYPE, typeMemberNameMap);
        }
    }

    private void reportUnprocessedElements(List<String> elementNames) throws CICSWSDLException {
        this.reportUnprocessedItems(elementNames, true);
    }

    private void reportUnprocessedTypes(List<String> typeNames) throws CICSWSDLException {
        this.reportUnprocessedItems(typeNames, false);
    }

    private void reportUnprocessedItems(List<String> itemNames, boolean elements) throws CICSWSDLException {
        itemNames.remove("ALL");
        int numOfItems = itemNames.size();
        if (numOfItems < 1) {
            return;
        }
        String messageNumber = null;
        messageNumber = elements ? "DFHPI9669E" : "DFHPI9674E";
        for (int i = 0; i < numOfItems - 1; ++i) {
            Logging.writeMessage(12, messageNumber, new String[]{itemNames.get(i)});
        }
        throw new CICSWSDLException(MessageHandler.buildMessage(messageNumber, new String[]{itemNames.get(numOfItems - 1)}));
    }

    @Override
    public String getFileName() {
        String filename = this.p.getProperty("SCHEMA");
        if (filename == null) {
            filename = this.p.getProperty("WSDL");
            this.inputFromWSDL = true;
        }
        return filename;
    }

    public void generatelangStructs(ICM theICM, QName elementQName, int generationNumber, File xsdbind, ICM.XMLContentType icmType, Map<QName, String> typeMemberNameMap) throws CICSWSDLException {
        LangStructManager manager = new LangStructManager(this.usePDSFiles(), this.isZOS());
        String strucName = manager.getStrucName(this.p.getProperty("REQUEST_STRUCT"), this.p.getProperty("PDSMEM"));
        String pdsEncodingName = this.p.getProperty("PDSCP");
        Charset pdsEncoding = null;
        if (pdsEncodingName != null) {
            pdsEncoding = Charset.forName(pdsEncodingName);
        }
        manager.buildLangStructSetForArtifact(this.p.getProperty("PDSMEM"), generationNumber, this.lang, strucName, theICM, null, elementQName, "NA", pdsEncoding, this.mappingLevel, -1, this.checker.getLevelIncrementSize(), this.PDSMEMs, icmType, 2, typeMemberNameMap, this.p, false);
        try {
            manager.writeLangStructs(this.p.getProperty("PDSLIB"));
        }
        catch (IOException e) {
            boolean deleted = xsdbind.delete();
            if (!deleted) {
                // empty if block
            }
            CICSWSDLException newEx = new CICSWSDLException(e.getLocalizedMessage());
            newEx.initCause(e);
            throw newEx;
        }
    }

    private void generateBootStrapICM(String parameters) throws IOException, ICMException {
        if (this.elementICMs.size() != 1) {
            throw new RuntimeException("INTERNAL_ERROR: number of ICMs for a bootstrap ICM is != 1");
        }
        ICM theICM = this.elementICMs.get(0);
        File f = new File(this.getFileName());
        BootStrapICM bs = new BootStrapICM();
        bs.generateBootStrapICM(parameters, theICM.toByteArray(), f.getName());
    }
}

