/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsdl.ws2ls;

import com.ibm.cics.schema.ICM;
import com.ibm.cics.schema.ICMException;
import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.schema.utils.RuntimeLevelHelper;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.GenericSetup;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsdl.common.WSBind;
import com.ibm.cics.wsdl.common.WSBindAbstractTypeEntry;
import com.ibm.cics.wsdl.common.WSBindOperationEntry;
import com.ibm.cics.wsdl.ws2ls.LangStructManager;
import com.ibm.cics.wsdl.ws2ls.WSAddressingFault;
import com.ibm.cics.wsdl.ws2ls.WSDLFile;
import com.ibm.cics.wsdl.ws2ls.WSDLToICM;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class ws2ls
extends GenericSetup {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2004, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    private boolean soap12HTTPTransport = false;
    private boolean oldStyleWSDL_1_1 = true;
    protected Map<Object, String> REQMEMs = new HashMap<Object, String>();
    protected Map<Object, String> RESPMEMs = new HashMap<Object, String>();
    protected Map<Object, String> PDSMEMs = new HashMap<Object, String>();
    private int fileCount = 0;
    private boolean msg9680WEmitted = false;
    private static final char CALCULATED_ACTION = 'C';
    private static final char SUPPLIED_ACTION = 'S';
    public static final long MAX_COMMAREA_SIZE = 32767L;

    @Override
    public void run(String[] args) {
        if (this.apiResp != null) {
            this.apiResp.setREQMEMs(this.REQMEMs);
            this.apiResp.setRESPMEMs(this.RESPMEMs);
        }
        this.commonExecute(args, 0, this.timestamp);
    }

    public static void main(String[] args) {
        ws2ls me = new ws2ls();
        me.run(args);
    }

    @Override
    public void doAssistantSpecificProcessing() throws CICSWSDLException {
        WSDLFile wsdl;
        String pgmName;
        if (this.isRegistryClientSetup()) {
            this.retrieveFromRegistry();
        }
        boolean providerMode = (pgmName = this.p.getProperty("PGMNAME")) != null && !"".equals(pgmName) && !" ".equals(pgmName);
        String wsdlFileName = this.p.getProperty("WSDL");
        try {
            wsdl = new WSDLFile(wsdlFileName, providerMode, "Remove when policy enabled", this.p.getProperty("WSBIND"), this.isZOS(), this.checker.isXmlOnly(), false);
        }
        catch (CICSWSDLException e) {
            PrintStream logger = Logging.getPrintStream();
            File absoluteFile = new File(wsdlFileName).getAbsoluteFile();
            try {
                FileReader fr = new FileReader(absoluteFile);
                BufferedReader bf = new BufferedReader(fr);
                logger.println();
                logger.println("Exception found in file: " + absoluteFile);
                logger.println("------------------------");
                logger.println();
                String line = bf.readLine();
                while (line != null) {
                    line = bf.readLine();
                    logger.println(line);
                }
                logger.println();
                bf.close();
            }
            catch (RuntimeException e0) {
                throw e0;
            }
            catch (Exception e0) {
                // empty catch block
            }
            throw e;
        }
        if (wsdl.isWSDL_2_0()) {
            this.checker.checkMinRuntimeLevel_2_0(3);
            this.wsBindVer = this.checker.getWSBindVerNumber();
        }
        this.p.put("BINDING", wsdl.getBindingName(this.p.getProperty("BINDING")));
        String bindingStyle = wsdl.checkConsistentStyle();
        if (wsdl.isDocWrappedStyle()) {
            bindingStyle = "WRAPPED";
        }
        if (bindingStyle != null) {
            this.p.put("STYLE", bindingStyle);
        }
        wsdl.setStyle(bindingStyle);
        String wsdlEndpointAddress = wsdl.getEndpoint(this.p.getProperty("WSDL-SERVICE"));
        this.p.put("ENDPOINT", wsdlEndpointAddress);
        if (wsdl.moreThanOneOperations() && this.p.getProperty("PGMNAME") != null && this.p.getProperty("PGMINT").equals("COMMAREA")) {
            throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9612E"));
        }
        boolean soap_1_1_httpTransport = false;
        boolean soap11 = false;
        int soapVer = 0;
        if (wsdl.isSOAP_1_1_OverHttp()) {
            soap_1_1_httpTransport = true;
            soap11 = true;
            soapVer = 1;
        } else if (wsdl.isSOAPOverHttp()) {
            this.soap12HTTPTransport = true;
            soapVer = 2;
        }
        this.oldStyleWSDL_1_1 = wsdl.isWSDL_1_1_withOldStyleBindings();
        int wsdlVer = 0;
        if (wsdl.isWSDL_1_1()) {
            wsdlVer = 1;
        }
        if (wsdl.isWSDL_2_0()) {
            wsdlVer = 2;
        }
        boolean useCommarea = this.p.getProperty("PGMINT").equals("COMMAREA");
        List<String> operationNames = wsdl.getOperationNames(this.operationNames, this.p.getProperty("WSDL-SERVICE"), useCommarea);
        if (this.apiResp != null) {
            this.apiResp.setOperationNames(operationNames);
        }
        this.processPolicyAttachments(wsdl, operationNames);
        WSBind wsbind = new WSBind(this.p, this.wsBindVer, this.vendorBindFileNeeded, this.vendorMetaData, soapVer, wsdlVer, this.mappingLevel, null, null);
        for (String operationName : operationNames) {
            WSDLToICM x = new WSDLToICM(wsdl, operationName, this.p, this.mappingLevel, soap11, this.charVaryingLimit, this.charVarying, this.defaultCharMaxlength, this.charMultiplier, this.useHexFloat, useCommarea, this.inlineMaxOccursLimit, this.interceptor, this.useAbstimeDates, this.dataTruncationSupported, this.defaultFractionDigits, this.platform);
            ICM requestICM = null;
            ICM responseICM = null;
            if (!this.vendorBindFileNeeded && !((Boolean)this.p.get("XML-ONLY")).booleanValue()) {
                requestICM = x.getOperationICM(ICM.XMLContentType.SOAP_REQUEST);
                responseICM = x.getOperationICM(ICM.XMLContentType.SOAP_RESPONSE);
                try {
                    if (this.p.getProperty("PGMINT").equals("COMMAREA") && (requestICM != null && requestICM.getCommAreaLength() > 32767L || responseICM != null && responseICM.getCommAreaLength() > 32767L)) {
                        throw new CICSWSDLException(MessageHandler.getMessage("DFHPI9589E"));
                    }
                }
                catch (ICMException e) {
                    CICSWSDLException newEx = requestICM == null || requestICM.getMessages().length < 1 ? new CICSWSDLException(e.getLocalizedMessage()) : new CICSWSDLException(requestICM.getMessages());
                    newEx.initCause(e);
                    throw newEx;
                }
            }
            WSBindOperationEntry operation = this.createOperation(wsdl, operationName, requestICM, responseICM, soap_1_1_httpTransport, useCommarea);
            wsbind.addOperation(operation);
        }
        if (RuntimeLevelHelper.supportsRuntimeLevel_2_2(this.wsBindVer)) {
            this.createAbstractTypes(wsbind, wsdl, soap11, useCommarea);
        }
        wsbind.setSyncOnReturn(this.syncOnReturn);
        if (bindingStyle != null && bindingStyle.indexOf("WRAPPED") == -1 && !bindingStyle.equalsIgnoreCase("RPC")) {
            wsbind.checkUniqueSigs();
        }
        String eprAddress = wsdl.getEndpointEPRAddress(this.p.getProperty("WSDL-SERVICE"), this.p.getProperty("BINDING"));
        if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.wsBindVer)) {
            if (wsdlEndpointAddress != null && eprAddress != null) {
                if (!wsdlEndpointAddress.equals("") && !eprAddress.equals(wsdlEndpointAddress)) {
                    if (wsdl.isWSDL_1_1()) {
                        throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9672E", new Object[0]));
                    }
                    throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9673E", new Object[0]));
                }
                String epr = wsdl.getEndpointEPR(this.p.getProperty("WSDL-SERVICE"), this.p.getProperty("BINDING"));
                wsbind.setEndpointReference(epr);
            }
        } else if (eprAddress != null && !this.msg9680WEmitted) {
            this.msg9680WEmitted = true;
            Logging.writeMessage(4, "DFHPI9680W", new Object[0]);
        }
        wsbind.writeToFile(this.p.getProperty("WSBIND"), this.timestamp, wsdl.getTargetNameSpace(), this.getPortNamespaceAndName(wsdl));
        if (!this.vendorBindFileNeeded && !((Boolean)this.p.get("XML-ONLY")).booleanValue()) {
            LangStructManager manager = new LangStructManager(this.usePDSFiles(), this.isZOS());
            manager.buildWSDLLangStructs(wsbind.getOperations(), this.p, this.mappingLevel, this.REQMEMs, this.RESPMEMs, this.PDSMEMs, this.checker.getLevelIncrementSize());
            try {
                manager.writeLangStructs(this.p.getProperty("PDSLIB"));
            }
            catch (IOException e) {
                wsbind.deleteFile();
                CICSWSDLException newEx = new CICSWSDLException(e.getLocalizedMessage());
                newEx.initCause(e);
                throw newEx;
            }
        }
        wsdl.handleAllFeatures(operationNames);
    }

    private void createAbstractTypes(WSBind wsbind, WSDLFile wsdl, boolean soap11, boolean useCommarea) throws CICSWSDLException {
        WSDLToICM icmMaker;
        List<WSBindAbstractTypeEntry> types;
        if (!this.vendorBindFileNeeded && !((Boolean)this.p.get("XML-ONLY")).booleanValue() && (types = (icmMaker = new WSDLToICM(wsdl, "", this.p, this.mappingLevel, soap11, this.charVaryingLimit, this.charVarying, this.defaultCharMaxlength, this.charMultiplier, this.useHexFloat, useCommarea, this.inlineMaxOccursLimit, this.interceptor, this.useAbstimeDates, this.dataTruncationSupported, this.defaultFractionDigits, this.platform)).getAbstractTypes()).size() > 0) {
            String programInterface = (String)this.p.get("PGMINT");
            if (!programInterface.equalsIgnoreCase("CHANNEL") && !programInterface.equalsIgnoreCase("NA")) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9676E", null));
            }
            for (int i = 0; i < types.size(); ++i) {
                wsbind.addOperation(types.get(i));
            }
        }
    }

    private String getPortNamespaceAndName(WSDLFile wsdl) throws CICSWSDLException {
        String portNSName = "";
        portNSName = wsdl.getEndpointName(this.p.getProperty("WSDL-SERVICE"), this.p.getProperty("BINDING"));
        if (!portNSName.equals(" ")) {
            QName service = wsdl.getServiceQName(this.p.getProperty("WSDL-SERVICE"));
            portNSName = service.getNamespaceURI() + " " + portNSName;
        }
        return portNSName;
    }

    private void processPolicyAttachments(WSDLFile wsdl, List<String> operationNames) throws CICSWSDLException {
        wsdl.getPolicyAttachmentsForService();
        if (operationNames != null) {
            for (String opName : operationNames) {
                wsdl.getPolicyAttachmentsForOperation(opName);
                wsdl.getPolicyAttachmentsForMessage(opName, 1);
                wsdl.getPolicyAttachmentsForMessage(opName, 2);
            }
        }
    }

    private WSBindOperationEntry createOperation(WSDLFile wsdl, String operationName, ICM requestICM, ICM responseICM, boolean http11Transport, boolean useCommarea) throws CICSWSDLException {
        int httpMethod = 1;
        if (wsdl.useHTTP_POST(operationName)) {
            httpMethod = 2;
        }
        URI mepURI = wsdl.getMEP(operationName, useCommarea);
        int mep = 1;
        if (mepURI.equals(WSDLFile.MEP_IN_ONLY_URI)) {
            mep = 2;
        } else if (mepURI.equals(WSDLFile.MEP_IN_OPTIONAL_OUT_URI)) {
            mep = 4;
        } else if (mepURI.equals(WSDLFile.MEP_ROBUST_IN_ONLY_URI)) {
            mep = 3;
        }
        WSBindOperationEntry myOp = new WSBindOperationEntry(operationName, requestICM, responseICM, mep, httpMethod);
        if (!wsdl.requestMessageRequired(operationName)) {
            if (!wsdl.isStyleSetForOperation(operationName)) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9590E", new Object[]{operationName}));
            }
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9591E", new Object[]{operationName}));
        }
        String sig = wsdl.getRuntimeSignature(operationName);
        if (!sig.equals("")) {
            myOp.setSignature(sig);
            Logging.getPrintStream().println("Operation: " + operationName + " Signature: " + sig);
            Logging.getPrintStream().println("----------");
        }
        String soapAction = wsdl.getSoapAction(operationName);
        myOp.setSoapAction(soapAction);
        if (http11Transport) {
            if (soapAction == null) {
                Logging.writeMessage(4, "DFHPI9592W", new Object[]{operationName});
            }
        } else if (soapAction != null) {
            if (this.soap12HTTPTransport) {
                if (this.oldStyleWSDL_1_1) {
                    Logging.writeMessage(4, "DFHPI9593W", new Object[]{operationName});
                }
            } else {
                Logging.writeMessage(4, "DFHPI9594W", new Object[]{operationName});
            }
        }
        String action = wsdl.getInputAction(operationName, mep);
        if (RuntimeLevelHelper.supportsRuntimeLevel_3_0(this.wsBindVer)) {
            if (soapAction != null && !soapAction.equals("") && action.charAt(0) == 'S' && !action.substring(1).equals(soapAction)) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9671E", new Object[]{operationName}));
            }
            if (soapAction != null && !soapAction.equals("") && action.charAt(0) == 'C') {
                action = 'S' + soapAction;
            }
            myOp.setInputAction(action);
            if (mep == 4 || mep == 1) {
                action = wsdl.getOutputAction(operationName, mep);
                myOp.setOutputAction(action);
            } else {
                action = "C";
                myOp.setOutputAction(action);
            }
            List<WSAddressingFault> faultActions = wsdl.getFaultAction(operationName, mep);
            myOp.setFaultActions(faultActions);
        } else if (action != null && action.charAt(0) == 'S' && !this.msg9680WEmitted) {
            this.msg9680WEmitted = true;
            Logging.writeMessage(4, "DFHPI9680W", new Object[0]);
        }
        return myOp;
    }

    @Override
    public String getFileName() {
        return this.p.getProperty("WSDL");
    }

    private void retrieveFromRegistry() throws CICSWSDLException {
        if (this.p.getProperty("WSRR-USERNAME") != null) {
            this.registryClient.setHttpBasicAuthParameter(this.p.getProperty("WSRR-USERNAME"), this.p.getProperty("WSRR-PASSWORD"));
        }
        String rName = this.p.getProperty("WSRR-NAME");
        String rNamespace = this.p.getProperty("WSRR-NAMESPACE");
        String rVersion = this.p.getProperty("WSRR-VERSION");
        this.fileCount = this.registryClient.retrieveWSDL(rName, rNamespace, rVersion, this.getFileName());
        if (this.fileCount == 0) {
            if (rNamespace == null || rNamespace.equals("")) {
                rNamespace = "*";
            }
            if (rVersion == null || rVersion.equals("")) {
                rVersion = "*";
            }
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9821E", new Object[]{rName, rNamespace, rVersion}));
        }
    }
}

