/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.wsrr.client;

import com.ibm.cics.schema.utils.MessageHandler;
import com.ibm.cics.wsdl.CICSWSDLException;
import com.ibm.cics.wsdl.common.Logging;
import com.ibm.cics.wsrr.client.ServiceRegistryClient;
import com.ibm.xmlns.prod.serviceregistry._6._0.sdo.BaseObject;
import com.ibm.xmlns.prod.serviceregistry._6._0.sdo.Document;
import com.ibm.xmlns.prod.serviceregistry._6._0.sdo.GraphQuery;
import com.ibm.xmlns.prod.serviceregistry._6._0.sdo.UserDefinedProperty;
import com.ibm.xmlns.prod.serviceregistry._6._0.sdo.WSDLDocument;
import com.ibm.xmlns.prod.serviceregistry._6._0.sdo.WSRR;
import com.ibm.xmlns.prod.serviceregistry._6._0.sdo.XMLDocument;
import com.ibm.xmlns.prod.serviceregistry._6._0.sdo.XSDDocument;
import com.ibm.xmlns.prod.serviceregistry._6._0.ws.sdo.QueryResult;
import com.ibm.xmlns.prod.serviceregistry._6._0.ws.sdo.ServiceRegistryWebServiceException;
import com.ibm.xmlns.prod.serviceregistry._6._0.ws.sdo.ServiceRegistryWebServiceException_Exception;
import com.ibm.xmlns.prod.serviceregistry._6._0.ws.sdo.WSRRCoreSDOPortType;
import com.ibm.xmlns.prod.serviceregistry._6._0.ws.sdo.WSRRCoreSDOService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceRef;
import sdo.commonj.DataGraphType;
import sdo.commonj.ObjectFactory;

public class ServiceRegistryClientImpl
implements ServiceRegistryClient {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YA1 (c) Copyright IBM Corp. 2008, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SCCSID = "%Z% %W% %I% %E% %U%";
    @WebServiceRef
    WSRRCoreSDOService wsrrService = null;
    private String wsrrEndpoint;
    private WSRRCoreSDOPortType wsrrPort = null;
    private ObjectFactory commonOF = null;
    private com.ibm.xmlns.prod.serviceregistry._6._0.sdo.ObjectFactory sdoOF = null;
    private static final String default_version = "1";

    @Override
    public String getServiceRegistryEndpoint() {
        return this.wsrrEndpoint;
    }

    public ServiceRegistryClientImpl() {
        URL wsrrWSDLURL = Thread.currentThread().getContextClassLoader().getResource("wsdlfiles/wsrrSdoWs.wsdl");
        this.wsrrService = new WSRRCoreSDOService(wsrrWSDLURL, new QName("http://www.ibm.com/xmlns/prod/serviceregistry/6/0/ws/sdo", "WSRRCoreSDOService"));
    }

    @Override
    public String publishWSDL(String wsdlFileLocation, String name, String namespace, String version, Properties userProperties, String wsdlFileEncoding) throws CICSWSDLException {
        String bsrURI = "";
        String publishVersion = "";
        if (this.wsrrService == null || this.wsrrPort == null) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9800E", null));
        }
        publishVersion = version == null || "".equals(version) ? default_version : version;
        DataGraphType queryDGT = this.buildQuery(name, namespace, publishVersion, "WSDLDocument");
        bsrURI = this.executeQuery(name, queryDGT);
        if (!"".equals(bsrURI)) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9801E", null));
        }
        String wsdlFile = this.readWSDLFromFile(wsdlFileLocation, wsdlFileEncoding);
        DataGraphType createDGT = this.buildCreate(name, namespace, publishVersion, wsdlFile, userProperties);
        bsrURI = this.executeCreate(createDGT);
        return bsrURI;
    }

    @Override
    public String publishWSDL(String wsdlFileLocation, String name, String namespace, String version, String wsdlFileEncoding) throws CICSWSDLException {
        return this.publishWSDL(wsdlFileLocation, name, namespace, version, null, wsdlFileEncoding);
    }

    @Override
    public String publishWSDL(String wsdlFileLocation, String name, String namespace, String wsdlFileEncoding) throws CICSWSDLException {
        return this.publishWSDL(wsdlFileLocation, name, namespace, default_version, null, wsdlFileEncoding);
    }

    @Override
    public int retrieveWSDL(String name, String namespace, String version, String filePath) throws CICSWSDLException {
        int totalRetrieved = 0;
        String bsrURI = "";
        if (this.wsrrService == null || this.wsrrPort == null) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9800E", null));
        }
        DataGraphType query = this.buildQuery(name, namespace, version, "WSDLDocument");
        bsrURI = this.executeQuery(name, query);
        if (!"".equals(bsrURI)) {
            totalRetrieved = this.readWSDLFromServiceRegistry(bsrURI, filePath);
        }
        return totalRetrieved;
    }

    @Override
    public int retrieveWSDL(String name, String namespace, String filePath) throws CICSWSDLException {
        return this.retrieveWSDL(name, namespace, "", filePath);
    }

    @Override
    public int retrieveWSDL(String name, String filePath) throws CICSWSDLException {
        return this.retrieveWSDL(name, "", "", filePath);
    }

    @Override
    public final void setHttpBasicAuthParameter(String username, String password) throws CICSWSDLException {
        if (this.wsrrService == null || this.wsrrPort == null) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9800E", null));
        }
        if (username != null && password != null) {
            ((BindingProvider)this.wsrrPort).getRequestContext().put("javax.xml.ws.security.auth.password", password);
            ((BindingProvider)this.wsrrPort).getRequestContext().put("javax.xml.ws.security.auth.username", username);
        }
        password = "/WSRRCoreSDO/services/WSRRCoreSDOPort";
    }

    @Override
    public void setServiceRegistryServer(String server) throws CICSWSDLException {
        if (!server.endsWith("/")) {
            server = server + "/";
        }
        this.wsrrEndpoint = server + "WSRRCoreSDO/services/WSRRCoreSDOPort";
        if (this.wsrrService == null) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9800E", null));
        }
        this.wsrrPort = this.wsrrService.getWSRRCoreSDOPort();
        if (this.wsrrPort == null) {
            throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9802E", null));
        }
        ((BindingProvider)this.wsrrPort).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.wsrrEndpoint);
    }

    private DataGraphType buildQuery(String wsdl_name, String namespace, String version, String documentType) {
        DataGraphType queryDG = null;
        StringBuilder query = new StringBuilder("/WSRR/" + documentType + "[@name='" + wsdl_name);
        if (version != null) {
            query.append("' and @version='" + version);
        }
        if (namespace != null) {
            query.append("' and @namespace='" + namespace);
        }
        query.append("']");
        if (this.commonOF == null) {
            this.commonOF = new ObjectFactory();
        }
        if (this.sdoOF == null) {
            this.sdoOF = new com.ibm.xmlns.prod.serviceregistry._6._0.sdo.ObjectFactory();
        }
        queryDG = this.commonOF.createDataGraphType();
        WSRR queryWSRR = this.sdoOF.createWSRR();
        GraphQuery queryGQ = this.sdoOF.createGraphQuery();
        queryGQ.setQueryExpression(query.toString());
        queryGQ.setBsrURI("_1");
        queryGQ.setDepth(0);
        queryGQ.setNoContent(Boolean.TRUE);
        queryWSRR.setRoot(queryGQ);
        queryWSRR.getArtefacts().add(queryGQ);
        queryDG.setWSRR(queryWSRR);
        return queryDG;
    }

    private DataGraphType buildCreate(String name, String namespace, String version, String wsdl, Properties props) {
        DataGraphType createDGT = null;
        WSRR createWSRR = null;
        WSDLDocument createWSDL = null;
        if (this.commonOF == null) {
            this.commonOF = new ObjectFactory();
        }
        if (this.sdoOF == null) {
            this.sdoOF = new com.ibm.xmlns.prod.serviceregistry._6._0.sdo.ObjectFactory();
        }
        createDGT = this.commonOF.createDataGraphType();
        createWSRR = this.sdoOF.createWSRR();
        createWSDL = this.sdoOF.createWSDLDocument();
        createWSDL.setBsrURI("_1");
        createWSDL.setName(name);
        createWSDL.setVersion(version);
        createWSDL.setLocation(name);
        String fileEnc = null;
        if (props != null && props.containsKey("WSRR-ENCODING")) {
            fileEnc = props.getProperty("WSRR-ENCODING");
            createWSDL.setEncoding(fileEnc);
            props.remove("WSRR-ENCODING");
        }
        if ((fileEnc == null || fileEnc.equals("")) && (fileEnc = System.getProperty("file.encoding")) != null && !fileEnc.equals("")) {
            createWSDL.setEncoding(fileEnc);
        }
        if (fileEnc == null || fileEnc.equals("")) {
            createWSDL.setContent(wsdl.getBytes());
        } else {
            try {
                createWSDL.setContent(wsdl.getBytes(fileEnc));
            }
            catch (UnsupportedEncodingException uee) {
                createWSDL.setEncoding("");
                createWSDL.setContent(wsdl.getBytes());
            }
        }
        if (props != null) {
            if (props.containsKey("WSRR-ENCODING")) {
                createWSDL.setEncoding(props.getProperty("WSRR-ENCODING"));
                props.remove("WSRR-ENCODING");
            }
            if (props.containsKey("WSRR-DESCRIPTION")) {
                createWSDL.setDescription(props.getProperty("WSRR-DESCRIPTION"));
                props.remove("WSRR-DESCRIPTION");
            }
            if (props.containsKey("WSRR-LOCATION")) {
                String userLocation = props.getProperty("WSRR-LOCATION");
                if (userLocation != null && !"".equals(userLocation)) {
                    createWSDL.setLocation(props.getProperty("WSRR-LOCATION"));
                }
                props.remove("WSRR-LOCATION");
            }
            Enumeration<Object> keys = props.keys();
            int numProp = 0;
            while (keys.hasMoreElements()) {
                if (numProp >= 250) {
                    Logging.writeMessage(4, "DFHPI9803W", null);
                    break;
                }
                String thisKey = (String)keys.nextElement();
                UserDefinedProperty newProp = this.sdoOF.createUserDefinedProperty();
                newProp.setName(thisKey);
                newProp.setValue(props.getProperty(thisKey));
                createWSDL.getUserDefinedProperties().add(newProp);
                ++numProp;
            }
        }
        createWSRR.setRoot(createWSDL);
        createWSRR.getArtefacts().add(createWSDL);
        createDGT.setWSRR(createWSRR);
        return createDGT;
    }

    private int readWSDLFromServiceRegistry(String srURI, String filePath) throws CICSWSDLException {
        int totalRetrieved = 0;
        String baseDir = "";
        String fSeparator = System.getProperty("file.separator");
        int separatorOffset = filePath.lastIndexOf(fSeparator);
        baseDir = separatorOffset == -1 ? "" : filePath.substring(0, separatorOffset);
        Logging.writeMessage(1, "DFHPI9815I", new Object[]{"retrieve"});
        try {
            DataGraphType responseDatagraph = this.wsrrPort.retrieveWithDepth(srURI, -1);
            Logging.writeMessage(1, "DFHPI9816I", new Object[]{"retrieve"});
            if (responseDatagraph == null) {
                return totalRetrieved;
            }
            WSRR responseWSRR = responseDatagraph.getWSRR();
            if (responseWSRR == null) {
                return totalRetrieved;
            }
            List<BaseObject> responseArtefacts = responseWSRR.getArtefacts();
            if (responseArtefacts == null || responseArtefacts.isEmpty()) {
                return totalRetrieved;
            }
            for (BaseObject baseObj : responseArtefacts) {
                String respContent;
                if (!(baseObj instanceof Document)) continue;
                Document currentDoc = (Document)baseObj;
                String wsdl_name = currentDoc.getName();
                if (wsdl_name == null || wsdl_name.length() == 0) {
                    wsdl_name = "bsruri-" + srURI;
                }
                if (!wsdl_name.matches(".+?\\.((wsdl)|(xsd)|(xml))")) {
                    if (baseObj instanceof WSDLDocument) {
                        wsdl_name = wsdl_name.concat(".wsdl");
                    } else if (baseObj instanceof XSDDocument) {
                        wsdl_name = wsdl_name.concat(".xsd");
                    } else if (baseObj instanceof XMLDocument) {
                        wsdl_name = wsdl_name.concat(".xml");
                    }
                }
                String docEnc = currentDoc.getEncoding();
                byte[] docC = null;
                if (docEnc == null || docEnc.equals("")) {
                    docC = currentDoc.getContent();
                    respContent = new String(docC);
                } else {
                    docC = currentDoc.getContent();
                    respContent = docC != null ? (docC.length > 3 && docC[0] == -17 && docC[1] == -69 && docC[2] == -65 ? new String(docC, 3, docC.length - 3, docEnc) : (docC.length > 2 && (docC[0] == -2 && docC[1] == -1 || docC[0] == -1 && docC[1] == -2) ? new String(docC, 2, docC.length - 2, docEnc) : new String(docC, docEnc))) : "";
                }
                if (srURI.equals(currentDoc.getBsrURI())) {
                    this.writeToFile(filePath, respContent);
                } else {
                    String docLocation = currentDoc.getLocation();
                    if (docLocation == null || docLocation.equals("") || docLocation.startsWith("http:") || docLocation.startsWith("https:")) {
                        this.writeToFile(baseDir + fSeparator + wsdl_name, respContent);
                    } else {
                        this.writeToFile(baseDir + fSeparator + docLocation, respContent);
                    }
                }
                ++totalRetrieved;
            }
        }
        catch (ServiceRegistryWebServiceException_Exception srwee) {
            ServiceRegistryWebServiceException faultInfo = srwee.getFaultInfo();
            CICSWSDLException cwe = faultInfo != null ? new CICSWSDLException(MessageHandler.buildMessage("DFHPI9804E", new Object[]{faultInfo.getMessage()})) : new CICSWSDLException(MessageHandler.buildMessage("DFHPI9805E", new Object[]{srwee.getCause()}));
            cwe.initCause(srwee);
            throw cwe;
        }
        catch (Exception wse) {
            CICSWSDLException cwe = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9805E", new Object[]{wse.getLocalizedMessage()}));
            cwe.initCause(wse);
            throw cwe;
        }
        return totalRetrieved;
    }

    private String readWSDLFromFile(String wsdlFileLocation, String fileEncoding) throws CICSWSDLException {
        FileInputStream fileIS;
        try {
            fileIS = new FileInputStream(wsdlFileLocation);
        }
        catch (FileNotFoundException e) {
            CICSWSDLException cwe = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9806E", null));
            cwe.initCause(e);
            throw cwe;
        }
        InputStreamReader isr = null;
        StringBuilder outputStr = null;
        try {
            isr = fileEncoding.equals("") ? new InputStreamReader(fileIS) : new InputStreamReader((InputStream)fileIS, fileEncoding);
            outputStr = new StringBuilder();
            char[] buffer = new char[1000];
            int len = 0;
            while (len != -1) {
                outputStr.append(buffer, 0, len);
                len = isr.read(buffer);
            }
        }
        catch (UnsupportedEncodingException e) {
            CICSWSDLException cwe = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9807E", null));
            cwe.initCause(e);
            throw cwe;
        }
        catch (IOException e) {
            CICSWSDLException cwe = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9808E", null));
            cwe.initCause(e);
            throw cwe;
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException ioe) {
                Logging.handleExc(ioe);
            }
        }
        return outputStr.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String executeQuery(String name, DataGraphType query) throws CICSWSDLException {
        QueryResult result;
        Logging.writeMessage(1, "DFHPI9815I", new Object[]{"query"});
        try {
            result = this.wsrrPort.executeQuery(query);
            Logging.writeMessage(1, "DFHPI9816I", new Object[]{"query"});
        }
        catch (ServiceRegistryWebServiceException_Exception srwee) {
            ServiceRegistryWebServiceException faultInfo = srwee.getFaultInfo();
            CICSWSDLException cwe = faultInfo != null ? new CICSWSDLException(MessageHandler.buildMessage("DFHPI9809E", new Object[]{faultInfo.getMessage()})) : new CICSWSDLException(MessageHandler.buildMessage("DFHPI9810E", new Object[]{srwee.getCause()}));
            cwe.initCause(srwee);
            throw cwe;
        }
        catch (Exception wse) {
            CICSWSDLException cwe = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9810E", new Object[]{wse.getLocalizedMessage()}));
            cwe.initCause(wse);
            throw cwe;
        }
        if (result == null) return "";
        List<DataGraphType> resultList = result.getDatagraph();
        if (resultList.isEmpty()) return "";
        Iterator<DataGraphType> resultIter1 = resultList.iterator();
        DataGraphType resultDG = resultIter1.next();
        WSRR resultWSRR = resultDG.getWSRR();
        if (resultWSRR == null) {
            return "";
        }
        List<BaseObject> resultArtefacts = resultWSRR.getArtefacts();
        if (resultArtefacts == null || resultArtefacts.isEmpty()) {
            return "";
        }
        Iterator<BaseObject> artefactIter = resultArtefacts.iterator();
        BaseObject firstResult = artefactIter.next();
        String bsrURI = firstResult.getBsrURI();
        Logging.writeMessage(1, "DFHPI9811I", new Object[]{name, bsrURI});
        if (!resultIter1.hasNext()) return bsrURI;
        Logging.writeMessage(4, "DFHPI9812W", null);
        return bsrURI;
    }

    private String executeCreate(DataGraphType createDGT) throws CICSWSDLException {
        String bsrURI = "";
        Logging.writeMessage(1, "DFHPI9815I", new Object[]{"create"});
        try {
            bsrURI = this.wsrrPort.create(createDGT);
            Logging.writeMessage(1, "DFHPI9816I", new Object[]{"create"});
        }
        catch (ServiceRegistryWebServiceException_Exception srwee) {
            ServiceRegistryWebServiceException faultInfo = srwee.getFaultInfo();
            CICSWSDLException cwe = faultInfo != null ? new CICSWSDLException(MessageHandler.buildMessage("DFHPI9813E", new Object[]{faultInfo.getMessage()})) : new CICSWSDLException(MessageHandler.buildMessage("DFHPI9814E", new Object[]{srwee.getCause()}));
            cwe.initCause(srwee);
            throw cwe;
        }
        catch (Exception wse) {
            CICSWSDLException cwe = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9814E", new Object[]{wse.getLocalizedMessage()}));
            cwe.initCause(wse);
            throw cwe;
        }
        return bsrURI;
    }

    private final void writeToFile(String filename, String docContent) throws CICSWSDLException {
        Logging.writeMessage(1, "DFHPI9819I", new Object[]{filename});
        FileOutputStream wsdlFile = null;
        File outputFile = new File("(null)");
        try {
            boolean dirsCreated;
            String fileDir;
            boolean dirsExist;
            int dirIndex;
            String marker = "encoding=\"UTF-8\"";
            int index = docContent.indexOf(marker);
            if (index != -1) {
                String changedWsdl;
                docContent = changedWsdl = docContent.substring(0, index) + docContent.substring(index + marker.length());
            }
            if ((dirIndex = filename.lastIndexOf(System.getProperty("file.separator"))) != -1 && dirIndex != 0 && !(dirsExist = (outputFile = new File(fileDir = filename.substring(0, dirIndex))).exists()) && !(dirsCreated = outputFile.mkdirs())) {
                throw new CICSWSDLException(MessageHandler.buildMessage("DFHPI9820E", new Object[]{fileDir + System.getProperty("file.separator")}));
            }
            wsdlFile = new FileOutputStream(filename);
            wsdlFile.write(docContent.getBytes());
        }
        catch (IOException e) {
            CICSWSDLException newEx = new CICSWSDLException(MessageHandler.buildMessage("DFHPI9556E", new Object[]{outputFile.getAbsolutePath(), e.getLocalizedMessage()}));
            newEx.initCause(e);
            throw newEx;
        }
        finally {
            try {
                if (wsdlFile != null) {
                    wsdlFile.close();
                }
            }
            catch (IOException ioe) {
                Logging.handleExc(ioe);
            }
        }
    }
}

