/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.DefaultErrorHandler;
import org.eclipse.xsd.util.DefaultJAXPConfiguration;
import org.eclipse.xsd.util.JAXPConfiguration;
import org.eclipse.xsd.util.JAXPPool;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDParser;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDResourceImpl
extends ResourceImpl {
    public static String XSD_TRACK_LOCATION = "XSD_TRACK_LOCATION";
    public static String XSD_PROGRESS_MONITOR = "XSD_PROGRESS_MONITOR";
    public static String XSD_ENCODING = "XSD_ENCODING";
    public static String XSD_JAXP_POOL = "XSD_JAXP_POOL";
    public static String XSD_JAXP_CONFIG = "XSD_JAXP_CONFIG";
    protected static final SchemaLocator SCHEMA_LOCATOR = new SchemaLocator();
    protected Collection<XSDSchema> attachedSchemas;

    public static void serialize(OutputStream outputStream, Element element) {
        XSDResourceImpl.serialize(outputStream, element, null);
    }

    public static void serialize(OutputStream outputStream, Element element, String encoding) {
        try {
            XSDResourceImpl.doSerialize(outputStream, element, encoding);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static void doSerialize(OutputStream outputStream, Element element) throws IOException {
        XSDResourceImpl.doSerialize(outputStream, element, null);
    }

    protected static void doSerialize(OutputStream outputStream, Element element, String encoding) throws IOException {
        try {
            Transformer transformer = new DefaultJAXPConfiguration().createTransformer(encoding);
            encoding = transformer.getOutputProperty("encoding");
            OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, encoding);
            transformer.transform(new DOMSource(element), new StreamResult(writer));
        }
        catch (TransformerException exception) {
            XSDPlugin.INSTANCE.log(exception);
        }
    }

    public static void serialize(OutputStream outputStream, Document document) {
        XSDResourceImpl.serialize(outputStream, document, null);
    }

    public static void serialize(OutputStream outputStream, Document document, String encoding) {
        try {
            XSDResourceImpl.doSerialize(outputStream, document, encoding);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Deprecated
    protected static void doSerialize(OutputStream outputStream, Document document) throws IOException {
        XSDResourceImpl.doSerialize(outputStream, document, Collections.EMPTY_MAP);
    }

    protected static void doSerialize(OutputStream outputStream, Document document, Map<?, ?> options) throws IOException {
        JAXPPool jaxpPool = null;
        JAXPConfiguration config = null;
        String encoding = null;
        if (options != null) {
            jaxpPool = (JAXPPool)options.get(XSD_JAXP_POOL);
            config = (JAXPConfiguration)options.get(XSD_JAXP_CONFIG);
            encoding = (String)options.get(XSD_ENCODING);
        }
        if (jaxpPool == null) {
            if (config == null) {
                XSDResourceImpl.doSerialize(outputStream, document, encoding);
            } else {
                try {
                    Transformer transformer = config.createTransformer(encoding);
                    encoding = transformer.getOutputProperty("encoding");
                    OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, encoding);
                    transformer.transform(new DOMSource(document), new StreamResult(writer));
                }
                catch (TransformerException exception) {
                    XSDPlugin.INSTANCE.log(exception);
                }
            }
        } else {
            Transformer transformer = null;
            try {
                try {
                    transformer = jaxpPool.getTransformer(encoding);
                    OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, encoding);
                    transformer.transform(new DOMSource(document), new StreamResult(writer));
                }
                catch (TransformerException exception) {
                    XSDPlugin.INSTANCE.log(exception);
                    jaxpPool.releaseTransformer(transformer);
                }
            }
            finally {
                jaxpPool.releaseTransformer(transformer);
            }
        }
    }

    @Deprecated
    protected static void doSerialize(OutputStream outputStream, Document document, String encoding) throws IOException {
        try {
            Transformer transformer = new DefaultJAXPConfiguration().createTransformer(encoding);
            encoding = transformer.getOutputProperty("encoding");
            OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, encoding);
            transformer.transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (TransformerException exception) {
            XSDPlugin.INSTANCE.log(exception);
        }
    }

    protected static void doSerialize(Writer writer, Document document, Map<?, ?> options) throws IOException {
        block11: {
            JAXPPool jaxpPool = null;
            JAXPConfiguration config = null;
            String encoding = null;
            if (options != null) {
                jaxpPool = (JAXPPool)options.get(XSD_JAXP_POOL);
                config = (JAXPConfiguration)options.get(XSD_JAXP_CONFIG);
                encoding = (String)options.get(XSD_ENCODING);
            }
            if (jaxpPool == null) {
                try {
                    if (config == null) {
                        new DefaultJAXPConfiguration().createTransformer(encoding).transform(new DOMSource(document), new StreamResult(writer));
                        break block11;
                    }
                    config.createTransformer(encoding).transform(new DOMSource(document), new StreamResult(writer));
                }
                catch (TransformerException exception) {
                    XSDPlugin.INSTANCE.log(exception);
                }
            } else {
                Transformer transformer = null;
                try {
                    try {
                        transformer = jaxpPool.getTransformer(encoding);
                        transformer.transform(new DOMSource(document), new StreamResult(writer));
                    }
                    catch (TransformerException exception) {
                        XSDPlugin.INSTANCE.log(exception);
                        jaxpPool.releaseTransformer(transformer);
                    }
                }
                finally {
                    jaxpPool.releaseTransformer(transformer);
                }
            }
        }
    }

    @Deprecated
    protected static Document getDocument(InputSource inputSource, ErrorHandler errorHandler) throws IOException {
        try {
            DocumentBuilder documentBuilder = new DefaultJAXPConfiguration().createDocumentBuilder(errorHandler);
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (ParserConfigurationException exception) {
            throw new Resource.IOWrappedException((Exception)exception);
        }
        catch (SAXException exception) {
            throw new Resource.IOWrappedException((Exception)exception);
        }
    }

    protected static Document getDocument(InputSource inputSource, ErrorHandler errorHandler, Map<?, ?> options) throws IOException {
        JAXPPool jaxpPool = null;
        JAXPConfiguration config = null;
        if (options != null) {
            jaxpPool = (JAXPPool)options.get(XSD_JAXP_POOL);
            config = (JAXPConfiguration)options.get(XSD_JAXP_CONFIG);
        }
        if (jaxpPool == null) {
            if (config == null) {
                return XSDResourceImpl.getDocument(inputSource, errorHandler);
            }
            try {
                DocumentBuilder documentBuilder = config.createDocumentBuilder(errorHandler);
                Document document = documentBuilder.parse(inputSource);
                return document;
            }
            catch (ParserConfigurationException exception) {
                throw new Resource.IOWrappedException((Exception)exception);
            }
            catch (SAXException exception) {
                throw new Resource.IOWrappedException((Exception)exception);
            }
        }
        DocumentBuilder documentBuilder = null;
        try {
            Document document;
            documentBuilder = jaxpPool.getDocumentBuilder(errorHandler);
            Document document2 = document = documentBuilder.parse(inputSource);
            return document2;
        }
        catch (ParserConfigurationException exception) {
            throw new Resource.IOWrappedException((Exception)exception);
        }
        catch (SAXException exception) {
            throw new Resource.IOWrappedException((Exception)exception);
        }
        finally {
            jaxpPool.releaseDocumentBuilder(documentBuilder);
        }
    }

    @Deprecated
    protected static Document getDocument(InputStream inputStream, ErrorHandler errorHandler) throws IOException {
        return XSDResourceImpl.getDocument(new InputSource(inputStream), errorHandler);
    }

    protected static EntityResolver createEntityResolver() {
        final String baseURL = XSDPlugin.INSTANCE.getBaseURL().toString();
        DefaultHandler entityResolver = new DefaultHandler(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                InputSource inputSource;
                if ("-//W3C//DTD XMLSCHEMA 200102//EN".equalsIgnoreCase(publicId) || "http://www.w3.org/2001/XMLSchema.dtd".equalsIgnoreCase(systemId)) {
                    inputSource = new InputSource(String.valueOf(baseURL) + "cache/www.w3.org/2001/XMLSchema.dtd");
                    inputSource.setPublicId(publicId);
                } else if (systemId != null && systemId.startsWith("file://bundleentry:")) {
                    inputSource = new InputSource(systemId.substring(7));
                    inputSource.setPublicId(publicId);
                } else {
                    try {
                        inputSource = super.resolveEntity(publicId, systemId);
                    }
                    catch (IOException exception) {
                        throw new SAXException(exception);
                    }
                }
                return inputSource;
            }
        };
        return entityResolver;
    }

    protected static void assignDiagnostics(XSDSchema xsdSchema, Collection<XSDDiagnostic> xsdDiagnostics) {
        if (!xsdDiagnostics.isEmpty()) {
            xsdSchema.getDiagnostics().addAll(xsdDiagnostics);
            for (XSDDiagnostic xsdDiagnostic : xsdDiagnostics) {
                xsdDiagnostic.getComponents().add((Object)xsdSchema);
                if (xsdSchema.getElement() == null) continue;
                xsdDiagnostic.setNode(xsdSchema.getElement());
            }
        }
    }

    public XSDResourceImpl() {
    }

    public XSDResourceImpl(URI uri) {
        super(uri);
    }

    protected void doSave(OutputStream os, Map<?, ?> options) throws IOException {
        if (os instanceof URIConverter.WriteableOutputStream) {
            this.doSave(((URIConverter.WriteableOutputStream)os).asWriter(), options);
        } else {
            XSDSchema xsdSchema = this.getSchema();
            if (xsdSchema != null) {
                Document document = xsdSchema.getDocument();
                if (document == null) {
                    xsdSchema.updateDocument();
                    document = xsdSchema.getDocument();
                }
                if (xsdSchema.getElement() == null) {
                    xsdSchema.updateElement();
                }
                XSDResourceImpl.doSerialize(os, document, options);
            }
        }
    }

    public final void save(Writer writer, Map<?, ?> options) throws IOException {
        if (this.defaultSaveOptions == null || this.defaultSaveOptions.isEmpty()) {
            this.doSave(writer, options);
        } else if (options == null) {
            this.doSave(writer, this.defaultSaveOptions);
        } else {
            HashMap mergedOptions = new HashMap(this.defaultSaveOptions);
            mergedOptions.putAll(options);
            this.doSave(writer, mergedOptions);
        }
        this.setModified(false);
    }

    protected void doSave(Writer writer, Map<?, ?> options) throws IOException {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            Document document = xsdSchema.getDocument();
            if (document == null) {
                xsdSchema.updateDocument();
                document = xsdSchema.getDocument();
            }
            if (xsdSchema.getElement() == null) {
                xsdSchema.updateElement();
            }
            XSDResourceImpl.doSerialize(writer, document, options);
        }
    }

    public XSDSchema getSchema() {
        return this.getContents().size() >= 1 && this.getContents().get(0) instanceof XSDSchema ? (XSDSchema)this.getContents().get(0) : null;
    }

    public final void load(InputSource inputSource, Map<?, ?> options) throws IOException {
        if (!this.isLoaded) {
            Notification notification = this.setLoaded(true);
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            try {
                if (this.defaultLoadOptions == null || this.defaultLoadOptions.isEmpty()) {
                    this.doLoad(inputSource, options);
                } else if (options == null) {
                    this.doLoad(inputSource, this.defaultLoadOptions);
                } else {
                    HashMap mergedOptions = new HashMap(this.defaultLoadOptions);
                    mergedOptions.putAll(options);
                    this.doLoad(inputSource, mergedOptions);
                }
            }
            finally {
                this.isLoading = false;
                if (notification != null) {
                    this.eNotify(notification);
                }
                this.setModified(false);
            }
        }
    }

    protected void doLoad(InputSource inputSource, Map<?, ?> options) throws IOException {
        Collection<XSDDiagnostic> errors;
        IOException ioException;
        IProgressMonitor progressMonitor;
        block29: {
            Object monitor;
            this.attachedSchemas = new ArrayList<XSDSchema>();
            progressMonitor = null;
            Object v0 = monitor = options == null ? null : options.get("XSD_PROGRESS_MONITOR");
            if (monitor != null) {
                progressMonitor = monitor;
                progressMonitor.setTaskName(XSDPlugin.INSTANCE.getString("_UI_ResourceLoad_progress"));
                progressMonitor.subTask(this.getURI().toString());
            }
            ioException = null;
            errors = null;
            try {
                Document document;
                if (options != null && Boolean.TRUE.equals(options.get("XSD_TRACK_LOCATION"))) {
                    XSDParser xsdParser = new XSDParser(options);
                    xsdParser.parse(inputSource);
                    document = xsdParser.getDocument();
                    if (xsdParser.getEncoding() != null) {
                        this.getDefaultSaveOptions().put(XSD_ENCODING, xsdParser.getEncoding());
                    }
                    errors = xsdParser.getDiagnostics();
                } else {
                    DefaultErrorHandler errorHandler = new DefaultErrorHandler();
                    try {
                        document = XSDResourceImpl.getDocument(inputSource, errorHandler, options);
                    }
                    finally {
                        errors = errorHandler.getDiagnostics();
                    }
                }
                if (document != null && document.getDocumentElement() != null) {
                    ResourceSet globalResourceSet = XSDSchemaImpl.getGlobalResourceSet();
                    Object oldMonitor = globalResourceSet.getLoadOptions().get("XSD_PROGRESS_MONITOR");
                    try {
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_PROGRESS_MONITOR", progressMonitor);
                        if (options != null && (options.containsKey("XSD_MAGIC_XML_SCHEMA") || options.containsKey("XSD_XML_SCHEMA"))) {
                            this.handleSchemaElement(document.getDocumentElement(), true);
                        } else if (!this.findSchemas(document.getDocumentElement())) {
                            this.handleSchemaElement(document.getDocumentElement(), false);
                        }
                        break block29;
                    }
                    finally {
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_PROGRESS_MONITOR", oldMonitor);
                    }
                }
                this.handleSchemaElement(null, false);
            }
            catch (IOException exception) {
                this.handleSchemaElement(null, false);
                ioException = exception;
            }
        }
        if (errors != null) {
            for (XSDSchema xsdSchema : this.getContents()) {
                XSDResourceImpl.assignDiagnostics(xsdSchema, errors);
                for (XSDDiagnostic xsdDiagnostic : errors) {
                    switch (xsdDiagnostic.getSeverity().getValue()) {
                        case 0: 
                        case 1: {
                            this.getErrors().add((Object)xsdDiagnostic);
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.getWarnings().add((Object)xsdDiagnostic);
                        }
                    }
                }
            }
        }
        if (this.getContents().size() > 1) {
            this.eAdapters().add((Object)SCHEMA_LOCATOR);
        }
        String schemaLocation = this.getURI().toString();
        Collection<XSDSchema> previouslyAttachedSchemas = this.attachedSchemas;
        this.attachedSchemas = null;
        for (XSDSchema xsdSchema : previouslyAttachedSchemas) {
            xsdSchema.setSchemaLocation(schemaLocation);
        }
        for (XSDSchema xsdSchema : previouslyAttachedSchemas) {
            xsdSchema.setSchemaLocation(schemaLocation);
        }
        if (progressMonitor != null) {
            progressMonitor.worked(1);
        }
        if (ioException != null) {
            throw ioException;
        }
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        InputSource inputSource;
        InputSource inputSource2 = inputSource = inputStream instanceof URIConverter.ReadableInputStream ? new InputSource(((URIConverter.ReadableInputStream)inputStream).asReader()) : new InputSource(inputStream);
        if (this.getURI() != null) {
            String id = this.getURI().toString();
            inputSource.setPublicId(id);
            inputSource.setSystemId(id);
        }
        this.doLoad(inputSource, options);
    }

    protected boolean findSchemas(Element element) {
        if (XSDConstants.nodeType(element) == 33) {
            this.handleSchemaElement(element, false);
            return true;
        }
        boolean result = false;
        Node child = element.getFirstChild();
        while (child != null) {
            if (child instanceof Element && this.findSchemas((Element)child)) {
                result = true;
            }
            child = child.getNextSibling();
        }
        return result;
    }

    protected void handleSchemaElement(Element element, boolean isMeta) {
        XSDSchema xsdSchema;
        if (element == null) {
            xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
            xsdSchema.getQNamePrefixToNamespaceMap().put(null, "http://www.w3.org/2001/XMLSchema");
        } else {
            xsdSchema = isMeta ? XSDSchemaImpl.createMetaSchema(element) : XSDSchemaImpl.createSchema(element);
        }
        this.getContents().add((Object)xsdSchema);
    }

    public void attached(EObject eObject) {
        super.attached(eObject);
        if (eObject instanceof XSDSchema) {
            if (this.attachedSchemas != null) {
                this.attachedSchemas.add((XSDSchema)eObject);
            } else if (!(eObject instanceof XSDSchemaImpl) || ((XSDSchemaImpl)eObject).getPendingSchemaLocation() == null) {
                ((XSDSchema)eObject).setSchemaLocation(this.getURI().toString());
            }
        }
    }

    public String getURIFragment(EObject eObject) {
        XSDConcreteComponent xsdConcreteComponent;
        Element theElement;
        if (eObject instanceof XSDConcreteComponent && (theElement = (xsdConcreteComponent = (XSDConcreteComponent)eObject).getElement()) != null && theElement.hasAttributeNS(null, "id") && theElement.getOwnerDocument().getElementById(theElement.getAttributeNS(null, "id")) == theElement) {
            return theElement.getAttributeNS(null, "id");
        }
        return super.getURIFragment(eObject);
    }

    public EObject getEObject(String uriFragment) {
        Element theElement;
        if (!uriFragment.startsWith("/") && (theElement = this.getSchema().getElement()) != null) {
            Element resultElement = theElement.getOwnerDocument().getElementById(uriFragment);
            ArrayList<Element> parents = new ArrayList<Element>();
            Node parent = resultElement;
            while (parent != null) {
                if (parent.getNodeType() == 1) {
                    parents.add((Element)parent);
                }
                parent = parent.getParentNode();
            }
            return ((XSDSchemaImpl)this.getSchema()).getBestConcreteComponent(parents);
        }
        return super.getEObject(uriFragment);
    }

    public Map<Object, Object> getDefaultSaveOptions() {
        if (this.defaultSaveOptions == null) {
            this.defaultSaveOptions = new HashMap();
        }
        return this.defaultSaveOptions;
    }

    public Map<Object, Object> getLoadSaveOptions() {
        if (this.defaultLoadOptions == null) {
            this.defaultLoadOptions = new HashMap();
        }
        return this.defaultLoadOptions;
    }

    public void setModified(boolean isModified) {
        if (this.isModified != isModified) {
            super.setModified(isModified);
        }
    }

    public static class SchemaLocator
    extends AdapterImpl
    implements XSDSchemaLocator {
        public XSDSchema locateSchema(XSDSchema xsdSchema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocation) {
            Resource resource;
            if (rawSchemaLocationURI == null && (resource = xsdSchema.eResource()) != null) {
                for (XSDSchema otherSchema : resource.getContents()) {
                    if (!(namespaceURI == null ? otherSchema.getTargetNamespace() == null : namespaceURI.equals(otherSchema.getTargetNamespace()))) continue;
                    return otherSchema;
                }
            }
            return null;
        }

        public boolean isAdapterForType(Object type) {
            return type == XSDSchemaLocator.class;
        }
    }
}

