/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal.invocation.processor;

import com.ibm.cics.server.internal.invocation.processor.Messages;
import com.ibm.cics.server.internal.invocation.processor.ValidationException;
import com.ibm.cics.server.invocation.CICSProgram;
import java.lang.annotation.Annotation;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementKindVisitor7;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class AnnotatedMethod {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2016, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final SecureRandom generator = new SecureRandom();
    private static final String PROGRAM_NAME_PATTERN = "[A-Za-z0-9$@#]+";
    private static final String CICS_RESERVED_PREFIX = "DFH";
    public static final Class<CICSProgram> ANNOTATION_CLASS = CICSProgram.class;
    public static final String PROGRAM_NAME_ANNOTATION_VALUE = "value";
    private static final String TARGET_TYPE_ANNOTATION_VALUE = "targetType";
    private static final String ERROR__ANNOTATION__DISALLOWED_LOCATION = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__DISALLOWED_LOCATION"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__METHOD_NOT_PUBLIC = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__METHOD_NOT_PUBLIC"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__METHOD_NOT_CONCRETE = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__METHOD_NOT_CONCRETE"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__METHOD_HAS_ARGS = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__METHOD_HAS_ARGS"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__TYPE_NOT_TOP_LEVEL = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__TYPE_NOT_TOP_LEVEL"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__TYPE_MISSING_NO_ARGS_CONSTRUCTOR = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__TYPE_MISSING_NO_ARGS_CONSTRUCTOR"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__METHOD_NOT_VOID = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__METHOD_NOT_VOID"), CICSProgram.class.getSimpleName());
    private final ExecutableElement annotatedMethodElement;
    private final String programName;
    private final byte[] uuid;
    private ProcessingEnvironment processingEnv;
    private CICSProgram.TargetType targetType;

    public AnnotatedMethod(Element element, ProcessingEnvironment processingEnvironment) throws ValidationException {
        this.processingEnv = processingEnvironment;
        this.annotatedMethodElement = (ExecutableElement)element;
        CICSProgram cICSProgram = this.annotatedMethodElement.getAnnotation(ANNOTATION_CLASS);
        this.targetType = this.determineTargetType(cICSProgram);
        this.programName = cICSProgram.value();
        this.uuid = new byte[16];
        generator.nextBytes(this.uuid);
        this.prepareAnnotatedElementSave(element);
        this.prepareProgramNameSave(this.programName);
    }

    private Optional<String> getSpringAnnotations() {
        return this.getAnnotation("org.springframework.stereotype.Component");
    }

    private <T extends Annotation> Optional<String> getAnnotation(String string) {
        return this.getAnnotation(string, this.annotatedMethodElement.getEnclosingElement());
    }

    private <T extends Annotation> Optional<String> getAnnotation(String string, Element element) {
        Elements elements = this.processingEnv.getElementUtils();
        if (elements == null) {
            return Optional.empty();
        }
        TypeElement typeElement = elements.getTypeElement(string);
        if (typeElement == null) {
            return Optional.empty();
        }
        for (AnnotationMirror annotationMirror : elements.getAllAnnotationMirrors(element)) {
            if (this.processingEnv.getTypeUtils().isAssignable(annotationMirror.getAnnotationType(), typeElement.asType())) {
                return Optional.of(annotationMirror.getAnnotationType().asElement().getSimpleName().toString());
            }
            for (AnnotationMirror annotationMirror2 : elements.getAllAnnotationMirrors(annotationMirror.getAnnotationType().asElement())) {
                if (!this.processingEnv.getTypeUtils().isAssignable(annotationMirror2.getAnnotationType(), typeElement.asType())) continue;
                return Optional.of(annotationMirror.getAnnotationType().asElement().getSimpleName().toString());
            }
        }
        return Optional.empty();
    }

    private CICSProgram.TargetType determineTargetType(CICSProgram cICSProgram) {
        CICSProgram.TargetType targetType = cICSProgram.targetType();
        String string = "";
        Optional<String> optional = this.getSpringAnnotations();
        if (optional.isPresent()) {
            string = optional.get();
            targetType = CICSProgram.TargetType.SPRINGBEAN;
        }
        if (this.springBeanHasTargetTypePojo(cICSProgram, targetType)) {
            AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(this.annotatedMethodElement, ANNOTATION_CLASS);
            AnnotationValue annotationValue = AnnotatedMethod.retrieveAnnotationValue(annotationMirror, TARGET_TYPE_ANNOTATION_VALUE);
            String string2 = MessageFormat.format(Messages.getString("AnnotatedMethod.WARNING__TARGETTPE__SPRINGBEAN_ASSUMED"), string);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, string2, this.annotatedMethodElement, annotationMirror, annotationValue);
        }
        if (targetType == CICSProgram.TargetType.UNSPECIFIED) {
            targetType = CICSProgram.TargetType.POJO;
        }
        return targetType;
    }

    private boolean springBeanHasTargetTypePojo(CICSProgram cICSProgram, CICSProgram.TargetType targetType) {
        return cICSProgram.targetType() == CICSProgram.TargetType.POJO && targetType == CICSProgram.TargetType.SPRINGBEAN;
    }

    private void prepareAnnotatedElementSave(Element element) throws ValidationException {
        AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(element, ANNOTATION_CLASS);
        this.validateAnnotationIsOnMethod(element, annotationMirror);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validateMethodIsPublic(executableElement, annotationMirror);
        this.validateMethodIsConcrete(executableElement, annotationMirror);
        this.validateMethodIsNotNested(executableElement, annotationMirror);
        this.validateMethodHasNoArgs(executableElement, annotationMirror);
        this.validateMethodHasVoidReturnType(executableElement, annotationMirror);
        if (!this.isStaticMethod(executableElement)) {
            this.validateClassHasNoArgsConstructor(executableElement, annotationMirror);
        }
    }

    private boolean isStaticMethod(ExecutableElement executableElement) {
        return executableElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    private void validateClassHasNoArgsConstructor(ExecutableElement executableElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (this.targetType == CICSProgram.TargetType.SPRINGBEAN) {
            return;
        }
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        NoArgsConstructorDetectionResult noArgsConstructorDetectionResult = new NoArgsConstructorDetectionResult();
        typeElement.accept(new NoArgsDetectionVisitor(), noArgsConstructorDetectionResult);
        if (noArgsConstructorDetectionResult.isConstructorDefined() && !noArgsConstructorDetectionResult.isNoArgConstructorDefined()) {
            throw new ValidationException(ValidationException.Type.CLASS_MISSING_NO_ARGS_CONSTRUCTOR, ERROR__ANNOTATION__TYPE_MISSING_NO_ARGS_CONSTRUCTOR, executableElement, annotationMirror);
        }
    }

    private void validateMethodHasNoArgs(ExecutableElement executableElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (!executableElement.getParameters().isEmpty()) {
            throw new ValidationException(ValidationException.Type.METHOD_HAS_ARGS, ERROR__ANNOTATION__METHOD_HAS_ARGS, executableElement, annotationMirror);
        }
    }

    private void validateMethodIsNotNested(ExecutableElement executableElement, AnnotationMirror annotationMirror) throws ValidationException {
        Element element = executableElement.getEnclosingElement();
        if (!(element instanceof TypeElement) || ((TypeElement)element).getNestingKind().isNested()) {
            throw new ValidationException(ValidationException.Type.CLASS_IS_NESTED, ERROR__ANNOTATION__TYPE_NOT_TOP_LEVEL, executableElement, annotationMirror);
        }
    }

    private void validateMethodIsPublic(ExecutableElement executableElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ValidationException(ValidationException.Type.METHOD_NOT_PUBLIC, ERROR__ANNOTATION__METHOD_NOT_PUBLIC, executableElement, annotationMirror);
        }
    }

    private void validateMethodIsConcrete(ExecutableElement executableElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (executableElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ValidationException(ValidationException.Type.METHOD_NOT_CONCRETE, ERROR__ANNOTATION__METHOD_NOT_CONCRETE, executableElement, annotationMirror);
        }
    }

    private void validateMethodHasVoidReturnType(ExecutableElement executableElement, AnnotationMirror annotationMirror) throws ValidationException {
        Types types = this.processingEnv.getTypeUtils();
        if (!types.isSameType(executableElement.getReturnType(), types.getNoType(TypeKind.VOID))) {
            throw new ValidationException(ValidationException.Type.METHOD_HAS_NON_VOID_RETURN_TYPE, ERROR__ANNOTATION__METHOD_NOT_VOID, executableElement, annotationMirror);
        }
    }

    private void validateAnnotationIsOnMethod(Element element, AnnotationMirror annotationMirror) throws ValidationException {
        if (element.getKind() != ElementKind.METHOD) {
            throw new ValidationException(ValidationException.Type.ANNOTATION_NOT_ON_METHOD, ERROR__ANNOTATION__DISALLOWED_LOCATION, element, annotationMirror);
        }
    }

    private void prepareProgramNameSave(String string) throws ValidationException {
        AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(this.annotatedMethodElement, ANNOTATION_CLASS);
        AnnotationValue annotationValue = AnnotatedMethod.retrieveAnnotationValue(annotationMirror, PROGRAM_NAME_ANNOTATION_VALUE);
        if (string == null) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_MISSING, Messages.getString("AnnotatedMethod.ERROR__PROGRAM_NAME_MISSING"), this.annotatedMethodElement, annotationMirror, annotationValue);
        }
        if (string.isEmpty()) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_BAD_LENGTH, Messages.getString("AnnotatedMethod.ERROR__PROGRAM_NAME__LENGTH"), this.annotatedMethodElement, annotationMirror, annotationValue);
        }
        if (string.length() > 8) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_BAD_LENGTH, Messages.getString("AnnotatedMethod.ERROR__PROGRAM_NAME__LENGTH"), this.annotatedMethodElement, annotationMirror, annotationValue);
        }
        if (!string.matches(PROGRAM_NAME_PATTERN)) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_BAD_CHARS, Messages.getString("AnnotatedMethod.ERROR__PROGRAM_NAME__PERMITTED_CHARACTERS"), this.annotatedMethodElement, annotationMirror, annotationValue);
        }
    }

    public void validateProgramName() throws ValidationException {
        AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(this.annotatedMethodElement, ANNOTATION_CLASS);
        AnnotationValue annotationValue = AnnotatedMethod.retrieveAnnotationValue(annotationMirror, PROGRAM_NAME_ANNOTATION_VALUE);
        if (this.programName.startsWith(CICS_RESERVED_PREFIX)) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_RESERVED_FOR_CICS, MessageFormat.format(Messages.getString("AnnotatedMethod.WARNING__PROGRAM_NAME__CICS_RESERVED_PREFIX"), CICS_RESERVED_PREFIX), this.annotatedMethodElement, annotationMirror, annotationValue);
        }
    }

    public static AnnotationMirror retrieveAnnotationMirror(Element element, Class<?> clazz) {
        List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
        AnnotationMirror annotationMirror = null;
        for (AnnotationMirror annotationMirror2 : list) {
            if (!((TypeElement)annotationMirror2.getAnnotationType().asElement()).getQualifiedName().contentEquals(clazz.getCanonicalName())) continue;
            annotationMirror = annotationMirror2;
            break;
        }
        return annotationMirror;
    }

    public static AnnotationValue retrieveAnnotationValue(AnnotationMirror annotationMirror, String string) {
        AnnotationValue annotationValue = null;
        if (annotationMirror != null) {
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!executableElement.getSimpleName().contentEquals(string)) continue;
                annotationValue = annotationMirror.getElementValues().get(executableElement);
                break;
            }
        }
        return annotationValue;
    }

    public TypeElement getEnclosingTypeElement() {
        return (TypeElement)this.annotatedMethodElement.getEnclosingElement();
    }

    public boolean isStaticMethod() {
        return this.isStaticMethod(this.annotatedMethodElement);
    }

    public ExecutableElement getAnnotatedMethodElement() {
        return this.annotatedMethodElement;
    }

    public String getProgramName() {
        return this.programName;
    }

    public String getUUID() {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : this.uuid) {
            stringBuilder.append(String.format("%02x", by));
        }
        return stringBuilder.toString();
    }

    public CICSProgram.TargetType getTargetType() {
        return this.targetType;
    }

    private class NoArgsConstructorDetectionResult {
        private boolean constructorDefined = false;
        private boolean noArgConstructorDefined = false;

        private NoArgsConstructorDetectionResult() {
        }

        public void foundConstructor() {
            this.constructorDefined = true;
        }

        public void foundNoArgsConstructor() {
            this.constructorDefined = true;
            this.noArgConstructorDefined = true;
        }

        public boolean isConstructorDefined() {
            return this.constructorDefined;
        }

        public boolean isNoArgConstructorDefined() {
            return this.noArgConstructorDefined;
        }
    }

    private final class NoArgsDetectionVisitor
    extends ElementKindVisitor7<Void, NoArgsConstructorDetectionResult> {
        private NoArgsDetectionVisitor() {
        }

        @Override
        public Void visitType(TypeElement typeElement, NoArgsConstructorDetectionResult noArgsConstructorDetectionResult) {
            for (Element element : typeElement.getEnclosedElements()) {
                if (noArgsConstructorDetectionResult.isNoArgConstructorDefined()) break;
                if (!(element instanceof ExecutableElement)) continue;
                element.accept(this, noArgsConstructorDetectionResult);
            }
            return null;
        }

        @Override
        public Void visitExecutableAsConstructor(ExecutableElement executableElement, NoArgsConstructorDetectionResult noArgsConstructorDetectionResult) {
            if (executableElement.getParameters().isEmpty()) {
                noArgsConstructorDetectionResult.foundNoArgsConstructor();
            } else {
                noArgsConstructorDetectionResult.foundConstructor();
            }
            return null;
        }
    }
}

