/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal.invocation.processor;

import com.ibm.cics.server.internal.invocation.processor.AnnotatedMethod;
import com.ibm.cics.server.internal.invocation.processor.Messages;
import com.ibm.cics.server.internal.invocation.processor.ValidationException;
import com.ibm.cics.server.invocation.CICSProgram;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class AnnotatedType {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2016, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String ERROR__PROGRAM_NAME__DUPLICATE_PROGRAM_NAME = MessageFormat.format(Messages.getString("AnnotatedType.ERROR__PROGRAM_NAME__DUPLICATE_PROGRAM_NAME"), CICSProgram.class.getSimpleName());
    private List<AnnotatedMethod> methods = new ArrayList<AnnotatedMethod>();
    private TypeElement type;

    public AnnotatedType(TypeElement type) {
        this.type = type;
    }

    public void addMethod(AnnotatedMethod method) {
        this.methods.add(method);
    }

    public List<AnnotatedMethod> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public TypeElement getType() {
        return this.type;
    }

    public void validate() throws ValidationException {
        this.validateUniqueProgramNames();
    }

    private void validateUniqueProgramNames() throws ValidationException {
        HashMap<String, ArrayList<AnnotatedMethod>> programNamesToMethods = new HashMap<String, ArrayList<AnnotatedMethod>>();
        for (AnnotatedMethod annotatedMethod : this.methods) {
            String programName = annotatedMethod.getProgramName();
            ArrayList<AnnotatedMethod> methodList = (ArrayList<AnnotatedMethod>)programNamesToMethods.get(programName);
            if (methodList == null) {
                methodList = new ArrayList<AnnotatedMethod>();
                programNamesToMethods.put(programName, methodList);
            }
            methodList.add(annotatedMethod);
        }
        for (Map.Entry entry : programNamesToMethods.entrySet()) {
            List annotatedMethods = (List)entry.getValue();
            if (annotatedMethods.size() <= 1) continue;
            ExecutableElement annotatedElement = ((AnnotatedMethod)annotatedMethods.get(0)).getAnnotatedMethodElement();
            AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(annotatedElement, AnnotatedMethod.ANNOTATION_CLASS);
            AnnotationValue annotationValue = AnnotatedMethod.retrieveAnnotationValue(annotationMirror, "value");
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_DUPLICATED, ERROR__PROGRAM_NAME__DUPLICATE_PROGRAM_NAME, annotatedElement, annotationMirror, annotationValue);
        }
    }
}

